-- Started: 2025-01-19 15:15:49
SET NAMES 'utf8mb3';
-- -----------------------------------
-- Dumping table b_abtest
-- -----------------------------------
DROP TABLE IF EXISTS `b_abtest`;
CREATE TABLE `b_abtest` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SITE_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ENABLED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCR` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `TEST_DATA` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `STOP_DATE` datetime DEFAULT NULL,
  `DURATION` int NOT NULL DEFAULT '0',
  `PORTION` int NOT NULL DEFAULT '0',
  `MIN_AMOUNT` int DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_abtest` VALUES
(1, 's1', 'N', 'T', 'Новый дизайн', 'Запустите А/B-тестирование для сравнения текущего дизайна с новым, и убедитесь, что показатели конверсии нового шаблона сайта выше.', 'a:2:{s:2:\"id\";s:7:\"sample1\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:8:\"template\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 100),
(2, 's1', 'N', 'T', 'Главная страница', 'Запустите А/B-тестирование, сравните влияние изменений на главной странице на конверсию вашего сайта.', 'a:2:{s:2:\"id\";s:7:\"sample2\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:4:\"page\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 200),
(3, 's1', 'N', 'T', 'Детальная карточка товара', 'С этой страничкой знакомится почти каждый покупатель вашего магазина, прежде чем изменить ее, проведите А/B-тестирование и убедитесь, что для новой страницы показатели конверсии выше.', 'a:2:{s:2:\"id\";s:7:\"sample3\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:4:\"page\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 300),
(4, 's1', 'N', 'T', 'Страницы корзины', 'Запустите А/B-тестирование, сравните влияние изменений на странице корзины на конверсию вашего сайта.', 'a:2:{s:2:\"id\";s:7:\"sample4\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:4:\"page\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 400),
(5, 's1', 'N', 'T', 'Страница оформления заказа', 'Запустите А/B-тестирование, сравните влияние изменений на странице оформления заказа на конверсию вашего сайта.', 'a:2:{s:2:\"id\";s:7:\"sample5\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:4:\"page\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 500),
(6, 's1', 'N', 'T', 'Произвольная выбранная страница', 'Проведите А/B-тестирование для любой страницы вашего сайта и сравните показатели конверсии для принятия правильного решения.', 'a:2:{s:2:\"id\";s:7:\"sample6\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:4:\"page\";s:9:\"old_value\";s:0:\"\";s:9:\"new_value\";s:0:\"\";}}}', NULL, NULL, 0, 30, NULL, NULL, 600),
(7, 's1', 'N', 'N', 'Композит', 'Запустите А/B-тестирование и сравните показатели конверсии с композитом и без него.', 'a:2:{s:2:\"id\";s:7:\"sample7\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:9:\"composite\";s:9:\"old_value\";s:1:\"N\";s:9:\"new_value\";s:1:\"Y\";}}}', NULL, NULL, 0, 30, NULL, NULL, 700),
(8, 's1', 'N', 'N', 'CDN', 'Запустите А/B-тестирование, чтобы выявить влияние CDN на конверсию вашего сайта.', 'a:2:{s:2:\"id\";s:7:\"sample8\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:3:\"cdn\";s:9:\"old_value\";s:1:\"N\";s:9:\"new_value\";s:1:\"Y\";}}}', NULL, NULL, 0, 30, NULL, NULL, 800),
(9, 's1', 'N', 'N', 'BigData', 'Узнайте насколько эффективна работа BigData. Запустите А/B-тестирование и сравните показатели конверсии сайта.', 'a:2:{s:2:\"id\";s:7:\"sample9\";s:4:\"list\";a:1:{i:0;a:3:{s:4:\"type\";s:7:\"bigdata\";s:9:\"old_value\";s:1:\"N\";s:9:\"new_value\";s:1:\"Y\";}}}', NULL, NULL, 0, 30, NULL, NULL, 900);
-- -----------------------------------
-- Dumping table b_admin_notify
-- -----------------------------------
DROP TABLE IF EXISTS `b_admin_notify`;
CREATE TABLE `b_admin_notify` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TAG` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MESSAGE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `ENABLE_CLOSE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `PUBLIC_SECTION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `NOTIFY_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'M',
  PRIMARY KEY (`ID`),
  KEY `IX_AD_TAG` (`TAG`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_admin_notify` VALUES
(481, 'MAIN', 'SITE_CHECKER', 'Обнаружены ошибки в работе сайта. <a href=\"/bitrix/admin/site_checker.php?lang=ru&start_test=Y\">Проверить и исправить.</a>', 'Y', 'N', 'M');
-- -----------------------------------
-- Dumping table b_admin_notify_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_admin_notify_lang`;
CREATE TABLE `b_admin_notify_lang` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NOTIFY_ID` int NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MESSAGE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_ADM_NTFY_LANG` (`NOTIFY_ID`,`LID`),
  KEY `IX_ADM_NTFY_LID` (`LID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_agent
-- -----------------------------------
DROP TABLE IF EXISTS `b_agent`;
CREATE TABLE `b_agent` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  `NAME` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `LAST_EXEC` datetime DEFAULT NULL,
  `NEXT_EXEC` datetime NOT NULL,
  `DATE_CHECK` datetime DEFAULT NULL,
  `AGENT_INTERVAL` int DEFAULT '86400',
  `IS_PERIOD` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `USER_ID` int DEFAULT NULL,
  `RUNNING` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `RETRY_COUNT` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ix_agent_user_id` (`USER_ID`),
  KEY `ix_agent_name` (`NAME`(100)),
  KEY `ix_agent_act_period_next_exec` (`ACTIVE`,`IS_PERIOD`,`NEXT_EXEC`),
  KEY `ix_agent_next_exec` (`NEXT_EXEC`),
  KEY `ix_agent_module_act` (`MODULE_ID`,`ACTIVE`)
) ENGINE=InnoDB AUTO_INCREMENT=2270 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_agent` VALUES
(2, 'main', 100, 'CCaptchaAgent::DeleteOldCaptcha(3600);', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(3, 'main', 100, 'CSiteCheckerTest::CommonTest();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(4, 'main', 100, 'CEvent::CleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(5, 'main', 100, 'CUser::CleanUpHitAuthAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(6, 'main', 100, 'CUndo::CleanUpOld();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(7, 'main', 100, 'CUserCounter::DeleteOld();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(8, 'main', 100, '\\Bitrix\\Main\\UI\\Viewer\\FilePreviewTable::deleteOldAgent(22, 20);', 'Y', '2025-01-19 15:13:06', '2025-01-19 15:43:06', NULL, 1800, 'N', NULL, 'N', 0),
(9, 'main', 100, 'CUser::AuthActionsCleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(10, 'main', 100, 'CUser::CleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(11, 'main', 100, 'CUser::DeactivateAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(12, 'main', 100, 'CEventLog::CleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(13, 'catalog', 100, '\\Bitrix\\Catalog\\CatalogViewedProductTable::clearAgent();', 'Y', '2025-01-16 16:58:17', '2025-01-21 16:58:17', NULL, 432000, 'N', NULL, 'N', 0),
(15, 'clouds', 100, 'CCloudStorage::CleanUp();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(16, 'currency', 100, '\\Bitrix\\Currency\\CurrencyManager::currencyBaseRateAgent();', 'Y', '2025-01-19 00:36:28', '2025-01-20 00:01:00', NULL, 86400, 'Y', NULL, 'N', 0),
(17, 'forum', 100, 'CForumStat::CleanUp();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(18, 'forum', 100, 'CForumFiles::CleanUp();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(19, 'landing', 100, 'Bitrix\\Landing\\Agent::clearRecycle();', 'Y', '2025-01-19 13:25:16', '2025-01-19 15:25:16', NULL, 7200, 'N', NULL, 'N', 0),
(20, 'landing', 100, 'Bitrix\\Landing\\Agent::clearFiles(30);', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(21, 'landing', 100, 'Bitrix\\Landing\\Agent::sendRestStatistic();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(22, 'landing', 100, 'Bitrix\\Landing\\Agent::clearTempFiles();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(23, 'messageservice', 100, 'Bitrix\\MessageService\\Queue::cleanUpAgent();', 'Y', '2025-01-19 00:00:07', '2025-01-20 00:00:00', NULL, 86400, 'Y', NULL, 'N', 0),
(27, 'rest', 100, 'Bitrix\\Rest\\Marketplace\\Client::getNumUpdates();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(28, 'rest', 100, '\\Bitrix\\Rest\\EventOfflineTable::cleanProcessAgent();', 'Y', '2025-01-19 11:03:50', '2025-01-20 11:03:50', NULL, 86400, 'N', NULL, 'N', 0),
(29, 'rest', 100, '\\Bitrix\\Rest\\LogTable::cleanUpAgent();', 'Y', '2025-01-19 11:03:50', '2025-01-20 11:03:50', NULL, 86400, 'N', NULL, 'N', 0),
(30, 'rest', 100, '\\Bitrix\\Rest\\Configuration\\Helper::sendStatisticAgent();', 'Y', '2025-01-19 11:03:50', '2025-01-20 11:03:50', NULL, 86400, 'N', NULL, 'N', 0),
(31, 'rest', 100, '\\Bitrix\\Rest\\UsageStatTable::sendAgent();', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(32, 'rest', 100, '\\Bitrix\\Rest\\UsageStatTable::cleanUpAgent();', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(33, 'rest', 100, '\\Bitrix\\Rest\\Marketplace\\Notification::checkAgent();', 'Y', '2025-01-19 11:03:50', '2025-01-20 11:03:50', NULL, 86400, 'N', NULL, 'N', 0),
(34, 'rest', 100, '\\Bitrix\\Rest\\Marketplace\\Immune::load();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(35, 'rest', 100, '\\Bitrix\\Rest\\Configuration\\Structure::clearContentAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(36, 'rest', 100, '\\Bitrix\\Rest\\Helper::recoveryAgents();', 'Y', '2025-01-15 18:10:09', '2025-01-22 18:10:09', NULL, 604800, 'N', NULL, 'N', 0),
(38, 'sale', 100, '\\Bitrix\\Sale\\Product2ProductTable::deleteOldProducts(10);', 'Y', '2025-01-16 16:58:17', '2025-01-26 16:58:17', NULL, 864000, 'N', NULL, 'N', 0),
(39, 'sale', 100, 'CSaleRecurring::AgentCheckRecurring();', 'Y', '2025-01-19 13:25:16', '2025-01-19 15:25:16', NULL, 7200, 'N', NULL, 'N', 0),
(40, 'sale', 100, 'CSaleOrder::RemindPayment();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(41, 'sale', 100, 'CSaleViewedProduct::ClearViewed();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(42, 'sale', 100, 'CSaleOrder::ClearProductReservedQuantity();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(44, 'sale', 100, '\\Bitrix\\Sale\\Internals\\Analytics\\Storage::cleanUpAgent();', 'Y', '2025-01-19 00:00:07', '2025-01-20 00:00:00', NULL, 86400, 'Y', NULL, 'N', 0),
(47, 'search', 10, 'CSearchSuggest::CleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(48, 'search', 10, 'CSearchStatistic::CleanUpAgent();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(50, 'security', 100, 'CSecuritySession::CleanUpAgent();', 'Y', '2025-01-19 15:13:06', '2025-01-19 15:43:06', NULL, 1800, 'N', NULL, 'N', 0),
(51, 'security', 100, 'CSecurityIPRule::CleanUpAgent();', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(55, 'seo', 100, 'Bitrix\\Seo\\Engine\\YandexDirect::updateAgent();', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(56, 'seo', 100, 'Bitrix\\Seo\\Adv\\LogTable::clean();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(57, 'seo', 100, 'Bitrix\\Seo\\Adv\\Auto::checkQuantityAgent();', 'Y', '2025-01-19 14:36:45', '2025-01-19 15:36:45', NULL, 3600, 'N', NULL, 'N', 0),
(60, 'storeassist', 100, 'CStoreAssist::AgentCountDayOrders();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(62, 'subscribe', 100, 'CSubscription::CleanUp();', 'Y', '2025-01-19 03:02:41', '2025-01-20 03:00:00', NULL, 86400, 'Y', NULL, 'N', 0),
(69, 'pull', 100, 'CPullChannel::CheckOnlineChannel();', 'Y', '2025-01-19 15:13:06', '2025-01-19 15:17:06', NULL, 240, 'N', NULL, 'N', 0),
(70, 'pull', 100, 'CPullChannel::CheckExpireAgent();', 'Y', '2025-01-19 15:13:06', '2025-01-20 03:13:06', NULL, 43200, 'N', NULL, 'N', 0),
(71, 'pull', 100, 'CPullWatch::CheckExpireAgent();', 'Y', '2025-01-19 15:13:06', '2025-01-19 15:33:06', NULL, 600, 'N', NULL, 'N', 0),
(1941, 'bizproc', 100, '\\CBPDocument::sendB24LimitsNotifyToAdmins();', 'N', NULL, '2024-10-02 00:00:00', '2024-10-02 15:05:35', 43200, 'N', NULL, 'N', 0),
(1944, 'calendar', 100, 'Bitrix\\Calendar\\Update\\GoogleDublicatesCleaner::doCheckAndClean();', 'N', NULL, '2024-10-02 00:00:00', '2024-10-02 15:07:39', 420, 'N', NULL, 'N', 0),
(1946, 'calendar', 100, '\\Bitrix\\Calendar\\Update\\InitLocalDataToGoogle::execAgent();', 'N', NULL, '2024-10-02 17:46:59', NULL, 1, 'Y', NULL, 'N', 0),
(1948, 'calendar', 100, '\\Bitrix\\Calendar\\Update\\SectionStructureUpdate::execAgent();', 'N', NULL, '2024-10-02 15:03:31', '2024-10-02 15:13:31', 1, 'Y', NULL, 'N', 0),
(1949, 'calendar', 100, '\\Bitrix\\Calendar\\Update\\CorrectEventInGoogle::execAgent();', 'N', NULL, '2024-10-02 19:58:32', NULL, 1, 'Y', NULL, 'N', 0),
(1950, 'calendar', 100, '\\Bitrix\\Calendar\\Update\\EventWithLocationUpdate::execAgent();', 'N', NULL, '2024-10-02 16:58:32', NULL, 1, 'Y', NULL, 'N', 0),
(1953, 'im', 100, '\\Bitrix\\Im\\Disk\\NoRelationPermission::cleaningAgent();', 'N', NULL, '2024-10-02 14:59:58', '2024-10-02 15:09:58', 3600, 'N', NULL, 'N', 0),
(1955, 'im', 100, 'CIMChat::InstallGeneralChat(true);', 'N', NULL, '2024-10-02 15:14:57', NULL, 900, 'N', NULL, 'N', 0),
(1957, 'im', 100, 'Bitrix\\Im\\Update\\MessageIndex::execAgent();', 'N', NULL, '2024-10-02 15:10:03', NULL, 1, 'Y', NULL, 'N', 0),
(1959, 'im', 100, '\\Bitrix\\Im\\Chat::checkReplicaDeprecatedAgent();', 'N', NULL, '2024-10-02 16:00:41', NULL, 3600, 'Y', NULL, 'N', 0),
(1961, 'im', 100, 'Bitrix\\Im\\Update\\ChatConfigConverter::execAgent();', 'N', NULL, '2024-10-02 15:05:49', NULL, 1, 'Y', NULL, 'N', 0),
(1963, 'messageservice', 100, 'Bitrix\\MessageService\\IncomingMessage::cleanUpAgent();', 'Y', '2025-01-19 00:00:07', '2025-01-20 00:00:00', NULL, 86400, 'Y', NULL, 'N', 0),
(1967, 'ui', 100, '\\Bitrix\\UI\\FileUploader\\TempFileAgent::clearOldRecords();', 'Y', '2025-01-19 15:13:06', '2025-01-19 15:43:06', NULL, 1800, 'N', NULL, 'N', 0),
(1976, 'location', 100, '\\Bitrix\\Location\\Infrastructure\\Service\\RecentAddressesService::cleanUp();', 'Y', '2025-01-19 11:03:50', '2025-01-20 11:03:50', NULL, 86400, 'N', NULL, 'N', 0),
(1982, 'calendar', 100, '\\Bitrix\\Calendar\\Sync\\Office365\\SectionManager::updateSectionsAgent();', 'N', NULL, '2024-10-02 00:00:00', '2024-10-02 15:12:54', 3600, 'N', NULL, 'N', 0),
(1983, 'calendar', 100, '\\Bitrix\\Calendar\\Update\\GoogleToNewSync::execAgent();', 'N', NULL, '2024-10-02 15:12:54', NULL, 1, 'Y', NULL, 'N', 0),
(1985, 'calendar', 100, 'Bitrix\\Calendar\\Core\\Queue\\Agent\\PushDelayedSectionAgent::runAgent();', 'N', NULL, '2024-10-02 16:03:03', NULL, 3600, 'N', NULL, 'N', 0),
(1986, 'calendar', 100, 'Bitrix\\Calendar\\Core\\Queue\\Agent\\PushDelayedConnectionAgent::runAgent();', 'N', NULL, '2024-10-02 16:03:03', NULL, 3600, 'N', NULL, 'N', 0),
(1989, 'im', 100, '\\Bitrix\\Im\\Update\\ChatConfigConnectionsRestorer::execAgent();', 'N', NULL, '2024-10-02 15:13:20', NULL, 1, 'Y', NULL, 'N', 0),
(1993, 'landing', 100, 'Bitrix\\Landing\\Agent::clearHistory();', 'Y', '2025-01-19 11:03:51', '2025-01-20 11:03:51', NULL, 86400, 'N', NULL, 'N', 0),
(2000, 'im', 100, '\\Bitrix\\Im\\Update\\Settings::cleanCacheAgent();', 'N', NULL, '2024-10-02 15:14:45', NULL, 60, 'N', NULL, 'N', 0),
(2005, 'im', 100, '\\Bitrix\\Im\\Update\\MessageDisappearing::disappearMessagesAgent();', 'Y', NULL, '2024-10-02 15:05:19', '2025-01-19 15:23:06', 60, 'N', NULL, 'N', 0),
(2006, 'im', 100, '\\Bitrix\\Im\\V2\\Chat\\User\\OwnerService::migrateOwnershipOfGeneralChatAgent();', 'Y', NULL, '2024-10-02 15:05:49', '2025-01-19 15:23:06', 30, 'N', NULL, 'N', 0),
(2010, 'socialnetwork', 100, '\\Bitrix\\Socialnetwork\\Update\\CalendarLogEvent::execAgent();', 'Y', NULL, '2024-10-02 15:16:04', '2025-01-19 15:23:06', 1, 'Y', NULL, 'N', 0),
(2014, 'bizproc', 100, 'Bitrix\\Bizproc\\Worker\\Task\\CreateSearchContentStepper::execAgent();', 'Y', NULL, '2024-10-02 15:23:06', '2025-01-19 15:23:06', 1, 'Y', NULL, 'N', 0),
(2015, 'bizproc', 100, 'Bitrix\\Bizproc\\Worker\\Workflow\\ClearFilterAgent::execute();', 'Y', NULL, '2024-10-02 00:00:00', '2025-01-19 15:23:06', 86400, 'N', NULL, 'N', 0),
(2016, 'bizproc', 100, 'Bitrix\\Bizproc\\Worker\\Task\\ClearSearchContentAgent::execute();', 'Y', NULL, '2024-10-02 00:00:00', '2025-01-19 15:23:06', 86400, 'N', NULL, 'N', 0),
(2018, 'im', 100, '\\Bitrix\\Im\\Update\\DeleteTsParamAgent::deleteTsParamAgent();', 'Y', NULL, '2024-10-02 15:19:32', '2025-01-19 15:23:06', 10, 'N', NULL, 'N', 0),
(2019, 'im', 100, '\\Bitrix\\Im\\Update\\MessageViewedFlag::execAgent();', 'Y', NULL, '2024-10-02 15:28:32', '2025-01-19 15:23:06', 1, 'Y', NULL, 'N', 0),
(2020, 'im', 100, '\\Bitrix\\Im\\Update\\UpdateAIProvider::updateProviderAgent();', 'Y', NULL, '2024-10-02 15:19:32', '2025-01-19 15:23:06', 86400, 'N', NULL, 'N', 0),
(2027, 'im', 100, '\\Bitrix\\Im\\V2\\Integration\\HumanResources\\Sync\\SyncService::syncRelationAgent();', 'Y', NULL, '2024-10-02 15:29:12', '2025-01-19 15:23:06', 300, 'N', NULL, 'N', 0),
(2028, 'im', 100, '\\Bitrix\\Im\\V2\\Integration\\HumanResources\\Sync\\SyncService::syncMemberAgent();', 'Y', NULL, '2024-10-02 15:29:12', '2025-01-19 15:23:06', 300, 'N', NULL, 'N', 0),
(2029, 'im', 100, '\\Bitrix\\Im\\V2\\Chat\\GeneralChannel::installAgent();', 'Y', NULL, '2024-10-03 15:19:12', '2025-01-19 15:23:06', 3600, 'N', NULL, 'N', 0),
(2031, 'im', 100, '\\Bitrix\\Im\\V2\\Chat\\GeneralChannel::changeLangAgent();', 'Y', NULL, '2024-10-02 15:29:17', '2025-01-19 15:23:06', 600, 'N', NULL, 'N', 0),
(2032, 'im', 100, '\\Bitrix\\Im\\V2\\Chat\\GeneralChat::changeLangAgent();', 'Y', NULL, '2024-10-02 15:29:17', '2025-01-19 15:23:06', 600, 'N', NULL, 'N', 0),
(2049, 'socialnetwork', 100, '\\Bitrix\\Socialnetwork\\Update\\GroupTypeConverter::execAgent();', 'Y', NULL, '2024-11-27 16:07:21', '2025-01-19 15:23:06', 1, 'Y', NULL, 'N', 0),
(2268, 'sale', 100, '\\Bitrix\\Sale\\Internals\\Analytics\\Agent::send();', 'Y', NULL, '2025-01-20 11:03:51', NULL, 86400, 'Y', NULL, 'N', 0);
-- -----------------------------------
-- Dumping table b_app_password
-- -----------------------------------
DROP TABLE IF EXISTS `b_app_password`;
CREATE TABLE `b_app_password` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `APPLICATION_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PASSWORD` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DIGEST_PASSWORD` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `DATE_LOGIN` datetime DEFAULT NULL,
  `LAST_IP` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `COMMENT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SYSCOMMENT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CODE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_app_password_user` (`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_b24connector_button_site
-- -----------------------------------
DROP TABLE IF EXISTS `b_b24connector_button_site`;
CREATE TABLE `b_b24connector_button_site` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BUTTON_ID` int NOT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BUTTON_ID` (`BUTTON_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_b24connector_buttons
-- -----------------------------------
DROP TABLE IF EXISTS `b_b24connector_buttons`;
CREATE TABLE `b_b24connector_buttons` (
  `ID` int NOT NULL,
  `APP_ID` int NOT NULL,
  `ADD_DATE` datetime NOT NULL,
  `ADD_BY` int NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SCRIPT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_bitrixcloud_option
-- -----------------------------------
DROP TABLE IF EXISTS `b_bitrixcloud_option`;
CREATE TABLE `b_bitrixcloud_option` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SORT` int NOT NULL,
  `PARAM_KEY` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PARAM_VALUE` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_b_bitrixcloud_option_1` (`NAME`)
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_bitrixcloud_option` VALUES
(38, 'backup_quota', 0, '0', '0'),
(39, 'backup_total_size', 0, '0', '0'),
(40, 'backup_last_backup_time', 0, '0', '0'),
(41, 'monitoring_result', 0, '0', '3.220.68.174'),
(42, 'monitoring_result', 1, '1', 'amiramir.beget.tech'),
(43, 'monitoring_result', 2, '2', 'atl.in.ua'),
(44, 'monitoring_result', 3, '3', 'bitrix.firstlegion.ru'),
(45, 'monitoring_result', 4, '4', 'bravovivat.ru'),
(46, 'monitoring_result', 5, '5', 'bxmplace.ru'),
(47, 'monitoring_result', 6, '6', 'dezpenser.ru'),
(48, 'monitoring_result', 7, '7', 'dveri-nizhniy-novgorod.ru'),
(49, 'monitoring_result', 8, '8', 'dveritermos.ru'),
(50, 'monitoring_result', 9, '9', 'elektrogood.ru'),
(51, 'monitoring_result', 10, '10', 'extremedimension48.ru'),
(52, 'monitoring_result', 11, '11', 'fabrica.tehoblog.beget.tech'),
(53, 'monitoring_result', 12, '12', 'gbi366.ru'),
(54, 'monitoring_result', 13, '13', 'globalmarking.ru'),
(55, 'monitoring_result', 14, '14', 'goodsberry.ru'),
(56, 'monitoring_result', 15, '15', 'greatbuy.biz.ua'),
(57, 'monitoring_result', 16, '16', 'hyundaitools.ru'),
(58, 'monitoring_result', 17, '17', 'ingazxnp.beget.tech'),
(59, 'monitoring_result', 18, '18', 'komfort-dveri.ch31034.tmweb.ru'),
(60, 'monitoring_result', 19, '19', 'luboznashka.ru'),
(61, 'monitoring_result', 20, '20', 'mi-market.net'),
(62, 'monitoring_result', 21, '21', 'mnogoparfuma.ga'),
(63, 'monitoring_result', 22, '22', 'motya.tehoblog.beget.tech'),
(64, 'monitoring_result', 23, '23', 'nasosynsk.ru'),
(65, 'monitoring_result', 24, '24', 'naviservis.ru'),
(66, 'monitoring_result', 25, '25', 'new.drivetyres.ru'),
(67, 'monitoring_result', 26, '26', 'new.dvernik.ru'),
(68, 'monitoring_result', 27, '27', 'new.evomatika.ru'),
(69, 'monitoring_result', 28, '28', 'oalt.ru'),
(70, 'monitoring_result', 29, '29', 'ppwood.ru'),
(71, 'monitoring_result', 30, '30', 'promdetals.ru'),
(72, 'monitoring_result', 31, '31', 'pwa.su'),
(73, 'monitoring_result', 32, '32', 'remont-okon-nizhniy-novgorod.ru'),
(74, 'monitoring_result', 33, '33', 'remont.fixstroy.com.ua'),
(75, 'monitoring_result', 34, '34', 'ry4ka.ru'),
(76, 'monitoring_result', 35, '35', 'sravni.markets'),
(77, 'monitoring_result', 36, '36', 'teploobmennic.ru'),
(78, 'monitoring_result', 37, '37', 'terawood.ru'),
(79, 'monitoring_result', 38, '38', 'tnbshop.ru'),
(80, 'monitoring_result', 39, '39', 'tualetnaya-woda.ru'),
(81, 'monitoring_result', 40, '40', 'unevers.tehoblog.beget.tech'),
(82, 'monitoring_result', 41, '41', 'veloclick.ru'),
(83, 'monitoring_result', 42, '42', 'xn--d1aamjbdp7b6bxa2c.xn--p1ai'),
(84, 'monitoring_result', 43, '43', 'ya24.ga'),
(85, 'monitoring_result', 44, '44', 'z92580lh.beget.tech'),
(86, 'monitoring_result_0', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1620740737;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(87, 'monitoring_result_0', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1698039669;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(88, 'monitoring_result_0', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844456;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(89, 'monitoring_result_0', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1623246995;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1654041599\";}'),
(90, 'monitoring_result_1', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727852762;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(91, 'monitoring_result_1', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1721769621;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.473709s;;20.000000;0.000000 size=5792B;;;0\";}'),
(92, 'monitoring_result_1', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844123;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(93, 'monitoring_result_1', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1583237345;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(94, 'monitoring_result_2', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851865;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1744664400\";}'),
(95, 'monitoring_result_2', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1706966712;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=4.562877s;;20.000000;0.000000 size=328B;;;0\";}'),
(96, 'monitoring_result_2', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843901;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(97, 'monitoring_result_3', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675620062;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1697230800\";}'),
(98, 'monitoring_result_3', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727161226;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.462102s;;20.000000;0.000000 size=398B;;;0\";}'),
(99, 'monitoring_result_3', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844787;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(100, 'monitoring_result_3', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727773562;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1755425799\";}'),
(101, 'monitoring_result_4', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675619762;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1679691600\";}'),
(102, 'monitoring_result_4', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727058856;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.464911s;;20.000000;0.000000 size=754B;;;0\";}'),
(103, 'monitoring_result_4', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(104, 'monitoring_result_4', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1745330762\";}'),
(105, 'monitoring_result_5', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1591690020;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1588971600\";}'),
(106, 'monitoring_result_5', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1655262084;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(107, 'monitoring_result_5', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844123;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(108, 'monitoring_result_6', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1650149078;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(109, 'monitoring_result_6', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655263796;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(110, 'monitoring_result_6', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845563;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(111, 'monitoring_result_6', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1636112462;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1640410469\";}'),
(112, 'monitoring_result_7', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1675533661;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1677704400\";}'),
(113, 'monitoring_result_7', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727058988;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.206114s;;20.000000;0.000000 size=766B;;;0\";}'),
(114, 'monitoring_result_7', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844787;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(115, 'monitoring_result_7', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1745330762\";}'),
(116, 'monitoring_result_8', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1659377833;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1656795600\";}'),
(117, 'monitoring_result_8', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1702042498;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(118, 'monitoring_result_8', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844456;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(119, 'monitoring_result_8', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1659463137;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1621380972\";}'),
(120, 'monitoring_result_9', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675622461;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1694206800\";}'),
(121, 'monitoring_result_9', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1726938318;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.619064s;;20.000000;0.000000 size=353B;;;0\";}'),
(122, 'monitoring_result_9', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(123, 'monitoring_result_9', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727858771;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1728814664\";}'),
(124, 'monitoring_result_10', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1651353255;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(125, 'monitoring_result_10', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1655264057;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(126, 'monitoring_result_10', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843901;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(127, 'monitoring_result_10', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1610326002;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1617183220\";}'),
(128, 'monitoring_result_11', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851599;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(129, 'monitoring_result_11', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1655263795;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(130, 'monitoring_result_11', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845564;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(131, 'monitoring_result_11', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1551441006;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(132, 'monitoring_result_12', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1650149120;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(133, 'monitoring_result_12', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655263391;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(134, 'monitoring_result_12', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(135, 'monitoring_result_12', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1533389169;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1538661987\";}'),
(136, 'monitoring_result_13', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675619762;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1699390800\";}'),
(137, 'monitoring_result_13', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1721769615;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=1.046937s;;20.000000;0.000000 size=8191B;;;0\";}'),
(138, 'monitoring_result_13', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(139, 'monitoring_result_13', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851866;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1735624112\";}'),
(140, 'monitoring_result_14', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675622161;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1696194000\";}'),
(141, 'monitoring_result_14', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1726827451;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.563592s;;20.000000;0.000000 size=204B;;;0\";}'),
(142, 'monitoring_result_14', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844123;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(143, 'monitoring_result_14', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851618;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1745751989\";}'),
(144, 'monitoring_result_15', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1964552400\";}'),
(145, 'monitoring_result_15', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655264055;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(146, 'monitoring_result_15', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(147, 'monitoring_result_15', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1561281661;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1566991327\";}'),
(148, 'monitoring_result_16', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1651353299;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(149, 'monitoring_result_16', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1717619555;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(150, 'monitoring_result_16', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(151, 'monitoring_result_16', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1691583962;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1714808719\";}'),
(152, 'monitoring_result_17', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851289;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(153, 'monitoring_result_17', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1720648889;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.147741s;;20.000000;0.000000 size=517B;;;0\";}'),
(154, 'monitoring_result_17', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(155, 'monitoring_result_17', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1657177676;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(156, 'monitoring_result_18', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675613162;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1687986000\";}'),
(157, 'monitoring_result_18', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1668690781;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(158, 'monitoring_result_18', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(159, 'monitoring_result_18', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1625222176;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1658102399\";}'),
(160, 'monitoring_result_19', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1628091972;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1625346000\";}'),
(161, 'monitoring_result_19', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655262768;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(162, 'monitoring_result_19', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(163, 'monitoring_result_20', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1745874000\";}'),
(164, 'monitoring_result_20', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727161819;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.606975s;;20.000000;0.000000 size=8191B;;;0\";}'),
(165, 'monitoring_result_20', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845564;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(166, 'monitoring_result_20', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727858168;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1729572034\";}'),
(167, 'monitoring_result_21', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1528074963;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(168, 'monitoring_result_21', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655263793;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(169, 'monitoring_result_21', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(170, 'monitoring_result_21', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1529459762;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1535856607\";}'),
(171, 'monitoring_result_22', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851012;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(172, 'monitoring_result_22', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1655263396;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(173, 'monitoring_result_22', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844458;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(174, 'monitoring_result_22', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1551438852;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(175, 'monitoring_result_23', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1698037305;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(176, 'monitoring_result_23', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727161756;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.310767s;;20.000000;0.000000 size=8191B;;;0\";}'),
(177, 'monitoring_result_23', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(178, 'monitoring_result_23', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844458;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1731918296\";}'),
(179, 'monitoring_result_24', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1635172009;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1632430800\";}'),
(180, 'monitoring_result_24', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1702042498;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(181, 'monitoring_result_24', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(182, 'monitoring_result_24', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1552315868;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1581748835\";}'),
(183, 'monitoring_result_25', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1684316726;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(184, 'monitoring_result_25', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1685521993;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.278737s;;20.000000;0.000000 size=7240B;;;0\";}'),
(185, 'monitoring_result_25', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(186, 'monitoring_result_25', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1685442663;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1999683103\";}'),
(187, 'monitoring_result_26', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1731790800\";}'),
(188, 'monitoring_result_26', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655262088;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(189, 'monitoring_result_26', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(190, 'monitoring_result_26', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1594898219;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1626004800\";}'),
(191, 'monitoring_result_27', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1651353351;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(192, 'monitoring_result_27', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655264054;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(193, 'monitoring_result_27', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(194, 'monitoring_result_27', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1554954070;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1561507392\";}'),
(195, 'monitoring_result_28', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675620062;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1681160400\";}'),
(196, 'monitoring_result_28', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727241936;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.117944s;;20.000000;0.000000 size=363B;;;0\";}'),
(197, 'monitoring_result_28', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(198, 'monitoring_result_28', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851618;s:6:\"uptime\";s:13:\"604801/604801\";s:6:\"result\";s:10:\"1734131752\";}'),
(199, 'monitoring_result_29', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844788;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1734814800\";}'),
(200, 'monitoring_result_29', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727150878;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.717655s;;20.000000;0.000000 size=8191B;;;0\";}'),
(201, 'monitoring_result_29', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(202, 'monitoring_result_29', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851264;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1734240025\";}'),
(203, 'monitoring_result_30', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1675535461;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1672779600\";}'),
(204, 'monitoring_result_30', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1675795286;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(205, 'monitoring_result_30', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(206, 'monitoring_result_30', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1672849262;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1677744188\";}'),
(207, 'monitoring_result_31', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675620662;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1678827600\";}'),
(208, 'monitoring_result_31', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1724143781;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.266231s;;20.000000;0.000000 size=739B;;;0\";}'),
(209, 'monitoring_result_31', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(210, 'monitoring_result_32', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1650149244;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(211, 'monitoring_result_32', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655264056;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(212, 'monitoring_result_32', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844457;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(214, 'monitoring_result_33', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1651353399;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(215, 'monitoring_result_33', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655263789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(216, 'monitoring_result_33', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844124;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(218, 'monitoring_result_34', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675621262;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1702760400\";}'),
(219, 'monitoring_result_34', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1723629565;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:48:\"time=0.270965s;;20.000000;0.000000 size=360B;;;0\";}'),
(220, 'monitoring_result_34', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(221, 'monitoring_result_34', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1655421923\";}'),
(222, 'monitoring_result_35', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727844125;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1733518800\";}'),
(223, 'monitoring_result_35', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727241784;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.339245s;;20.000000;0.000000 size=8191B;;;0\";}'),
(224, 'monitoring_result_35', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(225, 'monitoring_result_35', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727852774;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1740320989\";}'),
(226, 'monitoring_result_36', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675620361;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1705438800\";}'),
(227, 'monitoring_result_36', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1726728483;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.839685s;;20.000000;0.000000 size=4257B;;;0\";}'),
(228, 'monitoring_result_36', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844458;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(229, 'monitoring_result_36', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727772674;s:6:\"uptime\";s:13:\"345656/604800\";s:6:\"result\";s:10:\"1735260128\";}'),
(230, 'monitoring_result_37', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1651353430;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(231, 'monitoring_result_37', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655263790;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(232, 'monitoring_result_37', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844125;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(233, 'monitoring_result_37', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1636311067;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1643111239\";}'),
(234, 'monitoring_result_38', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675619762;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1680728400\";}'),
(235, 'monitoring_result_38', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727821736;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.627412s;;20.000000;0.000000 size=8191B;;;0\";}'),
(236, 'monitoring_result_38', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(237, 'monitoring_result_38', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851290;s:6:\"uptime\";s:13:\"604801/604801\";s:6:\"result\";s:10:\"1729897844\";}'),
(238, 'monitoring_result_39', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1623246105;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1620507600\";}'),
(239, 'monitoring_result_39', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1692967375;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(240, 'monitoring_result_39', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(241, 'monitoring_result_39', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1623243365;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1646037496\";}'),
(242, 'monitoring_result_40', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851290;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(243, 'monitoring_result_40', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1655262086;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(244, 'monitoring_result_40', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(245, 'monitoring_result_40', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1551440370;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(246, 'monitoring_result_41', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1671128462;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1668373200\";}'),
(247, 'monitoring_result_41', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1671131694;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(248, 'monitoring_result_41', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844458;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(249, 'monitoring_result_41', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1668528363;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1681200554\";}'),
(250, 'monitoring_result_42', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1675620062;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1706302800\";}'),
(251, 'monitoring_result_42', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1726212952;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.664154s;;20.000000;0.000000 size=8191B;;;0\";}'),
(252, 'monitoring_result_42', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844125;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(253, 'monitoring_result_42', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851600;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1729897608\";}'),
(254, 'monitoring_result_43', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1528955338;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(255, 'monitoring_result_43', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1656308414;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(256, 'monitoring_result_43', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727843902;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(257, 'monitoring_result_44', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727851600;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1756414800\";}'),
(258, 'monitoring_result_44', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1655262769;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:1:\"-\";}'),
(259, 'monitoring_result_44', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727845566;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(261, 'monitoring_expire_time', 0, '0', '1737290591'),
(262, 'monitoring_result', 45, '45', 'zap-zip.ru'),
(263, 'monitoring_result_31', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1727845565;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1732919037\";}'),
(264, 'monitoring_result_43', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1537431078;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:10:\"1542410408\";}'),
(265, 'monitoring_result_45', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1579732865;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1576962000\";}'),
(266, 'monitoring_result_45', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1717012557;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:49:\"time=0.109410s;;20.000000;0.000000 size=8191B;;;0\";}'),
(267, 'monitoring_result_45', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844789;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(269, 'monitoring_result', 46, '46', 'zolotoy-tekstil.ru'),
(270, 'monitoring_result_32', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1650149248;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(271, 'monitoring_result_44', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1547887918;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(272, 'monitoring_result_46', 0, 'test_domain_registration', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1650149332;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(273, 'monitoring_result_46', 1, 'test_http_response_time', 'a:4:{s:6:\"status\";s:5:\"green\";s:4:\"time\";i:1702123511;s:6:\"uptime\";s:13:\"604800/604800\";s:6:\"result\";s:1:\"-\";}'),
(274, 'monitoring_result_46', 2, 'test_lic', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1727844125;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1713128400\";}'),
(275, 'monitoring_result_46', 3, 'test_ssl_cert_validity', 'a:4:{s:6:\"status\";s:3:\"red\";s:4:\"time\";i:1577663181;s:6:\"uptime\";s:8:\"0/604800\";s:6:\"result\";s:10:\"1540711239\";}');
-- -----------------------------------
-- Dumping table b_blog
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog`;
CREATE TABLE `b_blog` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DATE_CREATE` datetime NOT NULL,
  `DATE_UPDATE` datetime NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `OWNER_ID` int DEFAULT NULL,
  `SOCNET_GROUP_ID` int DEFAULT NULL,
  `URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `REAL_URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `GROUP_ID` int NOT NULL,
  `ENABLE_COMMENTS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ENABLE_IMG_VERIF` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ENABLE_RSS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `LAST_POST_ID` int DEFAULT NULL,
  `LAST_POST_DATE` datetime DEFAULT NULL,
  `AUTO_GROUPS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EMAIL_NOTIFY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_HTML` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SEARCH_INDEX` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `USE_SOCNET` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `EDITOR_USE_FONT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `EDITOR_USE_LINK` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `EDITOR_USE_IMAGE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `EDITOR_USE_VIDEO` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `EDITOR_USE_FORMAT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_BLOG_4` (`URL`),
  KEY `IX_BLOG_BLOG_1` (`GROUP_ID`,`ACTIVE`),
  KEY `IX_BLOG_BLOG_2` (`OWNER_ID`),
  KEY `IX_BLOG_BLOG_5` (`LAST_POST_DATE`),
  KEY `IX_BLOG_BLOG_6` (`SOCNET_GROUP_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog` VALUES
(1, 'Отзывы на товары', 'Здесь хранятся отзывы посетителей магазина на товары магазина', '2023-05-12 18:25:33', '2023-06-29 22:29:47', 'Y', 1, NULL, 'catalog_comments', NULL, 1, 'Y', 'Y', 'N', 6, '2023-06-29 22:29:47', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
-- -----------------------------------
-- Dumping table b_blog_category
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_category`;
CREATE TABLE `b_blog_category` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_CAT_1` (`BLOG_ID`,`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_comment
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_comment`;
CREATE TABLE `b_blog_comment` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int NOT NULL,
  `POST_ID` int NOT NULL,
  `PARENT_ID` int DEFAULT NULL,
  `AUTHOR_ID` int DEFAULT NULL,
  `ICON_ID` int DEFAULT NULL,
  `AUTHOR_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_EMAIL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_IP` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_IP1` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DATE_CREATE` datetime NOT NULL,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `POST_TEXT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PUBLISH_STATUS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `HAS_PROPS` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SHARE_DEST` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_COMM_1` (`BLOG_ID`,`POST_ID`),
  KEY `IX_BLOG_COMM_2` (`AUTHOR_ID`),
  KEY `IX_BLOG_COMM_3` (`DATE_CREATE`,`AUTHOR_ID`),
  KEY `IX_BLOG_COMM_4` (`POST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_group`;
CREATE TABLE `b_blog_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_GROUP_1` (`SITE_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog_group` VALUES
(1, 'Группа отзывов', 's1');
-- -----------------------------------
-- Dumping table b_blog_image
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_image`;
CREATE TABLE `b_blog_image` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FILE_ID` int NOT NULL DEFAULT '0',
  `BLOG_ID` int NOT NULL DEFAULT '0',
  `POST_ID` int NOT NULL DEFAULT '0',
  `USER_ID` int NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime NOT NULL DEFAULT '1970-01-01 00:00:01',
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IMAGE_SIZE` int NOT NULL DEFAULT '0',
  `IS_COMMENT` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `COMMENT_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_IMAGE_1` (`POST_ID`,`BLOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_post
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_post`;
CREATE TABLE `b_blog_post` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `BLOG_ID` int NOT NULL,
  `AUTHOR_ID` int NOT NULL,
  `PREVIEW_TEXT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `PREVIEW_TEXT_TYPE` char(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `DETAIL_TEXT` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DETAIL_TEXT_TYPE` char(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `DATE_CREATE` datetime NOT NULL,
  `DATE_PUBLISH` datetime NOT NULL,
  `KEYWORDS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PUBLISH_STATUS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `CATEGORY_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ATRIBUTE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ENABLE_TRACKBACK` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ENABLE_COMMENTS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ATTACH_IMG` int DEFAULT NULL,
  `NUM_COMMENTS` int NOT NULL DEFAULT '0',
  `NUM_COMMENTS_ALL` int NOT NULL DEFAULT '0',
  `NUM_TRACKBACKS` int NOT NULL DEFAULT '0',
  `VIEWS` int DEFAULT NULL,
  `FAVORITE_SORT` int DEFAULT NULL,
  `PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CODE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MICRO` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `HAS_IMAGES` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HAS_PROPS` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HAS_TAGS` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HAS_COMMENT_IMAGES` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HAS_SOCNET_ALL` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SEO_TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SEO_TAGS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SEO_DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `BACKGROUND_CODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_POST_1` (`BLOG_ID`,`PUBLISH_STATUS`,`DATE_PUBLISH`),
  KEY `IX_BLOG_POST_2` (`BLOG_ID`,`DATE_PUBLISH`,`PUBLISH_STATUS`),
  KEY `IX_BLOG_POST_3` (`BLOG_ID`,`CATEGORY_ID`),
  KEY `IX_BLOG_POST_4` (`PUBLISH_STATUS`,`DATE_PUBLISH`),
  KEY `IX_BLOG_POST_5` (`DATE_PUBLISH`,`AUTHOR_ID`),
  KEY `IX_BLOG_POST_CODE` (`BLOG_ID`,`CODE`),
  KEY `IX_BLOG_POST_6` (`CODE`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog_post` VALUES
(1, 'Как совмещать отдых с воспитанием детей?', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/sovety/kak-sovmeshchat-otdykh-s-vospitaniem-detey/]Как совмещать отдых с воспитанием детей?[/URL]\nРодители часто затрудняются в выборе отдыха для своих детей. Из-за постоянной занятости приходится отдавать ребенка в детские лагеря. При этом появляется риск оказаться полностью оторванным от своего чада. В статье расскажем, как можно совмещать отдых и контроль за детьми.\r\n\n', 'text', '2023-05-12 18:25:33', '2023-05-12 18:25:33', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'Отдых с домашним питомцем', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/letniy-otdykh/pets-recreation/]Отдых с домашним питомцем[/URL]\n<p>\r\n	 Многие хозяева домашних животных отказываются от длительных поездок, поскольку не могут взять с собой своего любимца. Наша база отдыха дает прекрасную возможность насладиться отдыхом с питомцем.\r\n</p>\n', 'text', '2023-05-12 18:26:59', '2023-05-12 18:26:59', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'Чем заняться в санатории?', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/sovety/chem-zanyatsya-v-sanatorii/]Чем заняться в санатории?[/URL]\nНе знаете, куда сходить на базе отдыха в свободное время? Наш санаторий регулярно проводит много различных развлекательных мероприятий и экскурсий. Расскажем о них подробнее.\r\n\n', 'text', '2023-05-12 18:27:03', '2023-05-12 18:27:03', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(4, 'Популярные горнолыжные курорты России', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/zimniy-otdykh/popular-mountain-resort/]Популярные горнолыжные курорты России[/URL]\n<p>\r\n	 С приходом зимы любители экстремального спорта начинают планировать свой отдых. Горнолыжные курорты позволяют провести отпуск с пользой для здоровья, а также насладиться прекрасными видами горных склонов.<br>\r\n</p>\n', 'text', '2023-06-29 22:29:46', '2023-06-29 22:29:46', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'Как обустроить мангальную зону?', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/sovety/kak-obustroit-mangalnuyu-zonu/]Как обустроить мангальную зону?[/URL]\nКакой отдых может обойтись без аппетитного шашлыка? В статье подробно расскажем, как обустроить зону для мангала своими руками, чтобы вы всегда могли насладиться вкусным стейком или креветками.\r\n\n', 'text', '2023-06-29 22:29:46', '2023-06-29 22:29:46', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'Правила поведения на горных склонах', 1, 1, NULL, 'text', '[URL=http://travel.web-dag.ru/articles/zimniy-otdykh/rules-habits-on-mountains/]Правила поведения на горных склонах[/URL]\n<p>\r\n	 Перед посещением горнолыжного комплекса настоятельно рекомендуем ознакомиться с правилами поведения от международной спортивной федерации. Эти положения приняты на зимних курортах по всему миру.\r\n</p>\n', 'text', '2023-06-29 22:29:47', '2023-06-29 22:29:47', NULL, 'P', NULL, NULL, 'N', 'Y', NULL, 0, 0, 0, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
-- -----------------------------------
-- Dumping table b_blog_post_category
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_post_category`;
CREATE TABLE `b_blog_post_category` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int NOT NULL,
  `POST_ID` int NOT NULL,
  `CATEGORY_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_POST_CATEGORY` (`POST_ID`,`CATEGORY_ID`),
  KEY `IX_BLOG_POST_CATEGORY_CAT_ID` (`CATEGORY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_post_param
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_post_param`;
CREATE TABLE `b_blog_post_param` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `POST_ID` int DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_PP_1` (`POST_ID`,`USER_ID`),
  KEY `IX_BLOG_PP_2` (`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_site_path
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_site_path`;
CREATE TABLE `b_blog_site_path` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_SITE_PATH_2` (`SITE_ID`,`TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_socnet
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_socnet`;
CREATE TABLE `b_blog_socnet` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_SOCNET` (`BLOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_socnet_rights
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_socnet_rights`;
CREATE TABLE `b_blog_socnet_rights` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `POST_ID` int NOT NULL,
  `ENTITY_TYPE` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ENTITY_ID` int NOT NULL,
  `ENTITY` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_SR_1` (`POST_ID`),
  KEY `IX_BLOG_SR_2` (`ENTITY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_trackback
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_trackback`;
CREATE TABLE `b_blog_trackback` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PREVIEW_TEXT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `BLOG_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `POST_DATE` datetime NOT NULL,
  `BLOG_ID` int NOT NULL,
  `POST_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_TRBK_1` (`BLOG_ID`,`POST_ID`),
  KEY `IX_BLOG_TRBK_2` (`POST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_user
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_user`;
CREATE TABLE `b_blog_user` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `ALIAS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `AVATAR` int DEFAULT NULL,
  `INTERESTS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LAST_VISIT` datetime DEFAULT NULL,
  `DATE_REG` datetime NOT NULL,
  `ALLOW_POST` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_USER_1` (`USER_ID`),
  KEY `IX_BLOG_USER_2` (`ALIAS`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog_user` VALUES
(1, 1, '', '', NULL, '', NULL, '2023-04-28 18:47:23', 'Y'),
(3, 3, '', '', NULL, '						', NULL, '2024-12-01 11:58:21', 'Y');
-- -----------------------------------
-- Dumping table b_blog_user2blog
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_user2blog`;
CREATE TABLE `b_blog_user2blog` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `BLOG_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_USER2GROUP_1` (`BLOG_ID`,`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_user2user_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_user2user_group`;
CREATE TABLE `b_blog_user2user_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `BLOG_ID` int NOT NULL,
  `USER_GROUP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_USER2GROUP_1` (`USER_ID`,`BLOG_ID`,`USER_GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_blog_user_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_user_group`;
CREATE TABLE `b_blog_user_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_BLOG_USER_GROUP_1` (`BLOG_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog_user_group` VALUES
(1, NULL, 'all'),
(2, NULL, 'registered');
-- -----------------------------------
-- Dumping table b_blog_user_group_perms
-- -----------------------------------
DROP TABLE IF EXISTS `b_blog_user_group_perms`;
CREATE TABLE `b_blog_user_group_perms` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BLOG_ID` int NOT NULL,
  `USER_GROUP_ID` int NOT NULL,
  `PERMS_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `POST_ID` int DEFAULT NULL,
  `PERMS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'D',
  `AUTOSET` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_BLOG_UG_PERMS_1` (`BLOG_ID`,`USER_GROUP_ID`,`PERMS_TYPE`,`POST_ID`),
  KEY `IX_BLOG_UG_PERMS_2` (`USER_GROUP_ID`,`PERMS_TYPE`,`POST_ID`),
  KEY `IX_BLOG_UG_PERMS_3` (`POST_ID`,`USER_GROUP_ID`,`PERMS_TYPE`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_blog_user_group_perms` VALUES
(1, 1, 1, 'P', NULL, 'I', 'N'),
(2, 1, 2, 'P', NULL, 'I', 'N'),
(3, 1, 1, 'C', NULL, 'P', 'N'),
(4, 1, 2, 'C', NULL, 'P', 'N'),
(5, 1, 1, 'P', 1, 'I', 'Y'),
(6, 1, 2, 'P', 1, 'I', 'Y'),
(7, 1, 1, 'C', 1, 'P', 'Y'),
(8, 1, 2, 'C', 1, 'P', 'Y'),
(9, 1, 1, 'P', 2, 'I', 'Y'),
(10, 1, 2, 'P', 2, 'I', 'Y'),
(11, 1, 1, 'C', 2, 'P', 'Y'),
(12, 1, 2, 'C', 2, 'P', 'Y'),
(13, 1, 1, 'P', 3, 'I', 'Y'),
(14, 1, 2, 'P', 3, 'I', 'Y'),
(15, 1, 1, 'C', 3, 'P', 'Y'),
(16, 1, 2, 'C', 3, 'P', 'Y'),
(17, 1, 1, 'P', 4, 'I', 'Y'),
(18, 1, 2, 'P', 4, 'I', 'Y'),
(19, 1, 1, 'C', 4, 'P', 'Y'),
(20, 1, 2, 'C', 4, 'P', 'Y'),
(21, 1, 1, 'P', 5, 'I', 'Y'),
(22, 1, 2, 'P', 5, 'I', 'Y'),
(23, 1, 1, 'C', 5, 'P', 'Y'),
(24, 1, 2, 'C', 5, 'P', 'Y'),
(25, 1, 1, 'P', 6, 'I', 'Y'),
(26, 1, 2, 'P', 6, 'I', 'Y'),
(27, 1, 1, 'C', 6, 'P', 'Y'),
(28, 1, 2, 'C', 6, 'P', 'Y');
-- -----------------------------------
-- Dumping table b_bp_task_search_content
-- -----------------------------------
DROP TABLE IF EXISTS `b_bp_task_search_content`;
CREATE TABLE `b_bp_task_search_content` (
  `TASK_ID` int NOT NULL,
  `WORKFLOW_ID` varchar(32) NOT NULL,
  `SEARCH_CONTENT` text NOT NULL,
  PRIMARY KEY (`TASK_ID`),
  KEY `ix_bp_task_search_1` (`WORKFLOW_ID`),
  FULLTEXT KEY `ix_bp_task_search_2` (`SEARCH_CONTENT`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_cache_tag
-- -----------------------------------
DROP TABLE IF EXISTS `b_cache_tag`;
CREATE TABLE `b_cache_tag` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CACHE_SALT` char(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `RELATIVE_PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TAG` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_init_tag` (`SITE_ID`,`CACHE_SALT`,`RELATIVE_PATH`,`TAG`),
  KEY `ix_relative_path` (`RELATIVE_PATH`),
  KEY `ix_tag_relative_path` (`TAG`,`RELATIVE_PATH`)
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_cache_tag` VALUES
(24, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlock_GetList/iblocks/', 'iblocks'),
(25, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_mainblocks5/', 'aspro_allcorp3resort_mainblocks5'),
(26, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlock_GetList/iblocks/', 'iblock_id_5'),
(27, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_mainblocks5/', 'aspro_allcorp3resort_mainblocks5'),
(28, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_mainblocks5/', 'iblock_id_5'),
(29, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_advtbig23/', 'aspro_allcorp3resort_advtbig23'),
(30, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_mainblocks5/', 'iblock_id_23'),
(31, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(34, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(35, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_43'),
(36, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'iblock_id_43'),
(37, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(38, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(39, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'iblock_id_27'),
(40, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'aspro_allcorp3resort_projects42'),
(41, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'iblock_id_42'),
(42, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(43, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'iblock_id_36'),
(44, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(45, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_tarifs36/', 'iblock_id_36'),
(46, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_front_tizers2/', 'aspro_allcorp3resort_front_tizers2'),
(47, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_6'),
(48, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_23'),
(49, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_2'),
(50, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_id_6'),
(51, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_id_23'),
(52, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(53, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_property_enum_544'),
(54, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_id_44'),
(55, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_44'),
(56, 's1', '/e25', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(57, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_2'),
(58, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_id_49'),
(59, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_39'),
(60, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_43'),
(61, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_26'),
(62, 's1', '/e25', '/s1/aspro/catalog.section.list.allcorp3resort/345', 'iblock_id_44'),
(63, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_36'),
(64, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_35'),
(65, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_articles38/', 'aspro_allcorp3resort_articles38'),
(66, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_38'),
(67, 's1', '/e25', '/s1/bitrix/news.list/345', 'iblock_id_7'),
(68, 's1', '/e25', '/s1/bitrix/news.detail/345', 'iblock_id_33'),
(69, 's1', '/e25', '/s1/bitrix/news.detail/345', 'iblock_id_2'),
(73, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_marketings48/', 'aspro_allcorp3resort_marketings48'),
(74, 's1', '/e25', '/s1/aspro/social.info.allcorp3resort/345', 'iblock_id_48'),
(75, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_bottom_icons22/', 'aspro_allcorp3resort_bottom_icons22'),
(76, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_marketings48/', 'iblock_id_22'),
(78, 's1', '/48e', 'iblock_find', 'iblock_id_44'),
(79, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(80, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_44'),
(81, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(82, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog_info45/', 'aspro_allcorp3resort_catalog_info45'),
(83, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_45'),
(84, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_45'),
(85, 's1', '/48e', '/s1/bitrix/catalog.smart.filter/48e', 'iblock_id_44'),
(86, 's1', '/48e', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(87, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_24'),
(98, 's1', '/969', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(99, 's1', '/315', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_contact31/', 'aspro_allcorp3resort_contact31'),
(100, 's1', '/315', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_contact31/', 'aspro_allcorp3resort_contact31'),
(101, 's1', '/315', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_contact31/', 'iblock_id_31'),
(102, 's1', '/a72', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(103, 's1', '/a72', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(104, 's1', '/a72', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_tarifs36/', 'iblock_id_36'),
(105, 's1', '/837', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_articles38/', 'aspro_allcorp3resort_articles38'),
(106, 's1', '/837', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_articles38/', 'aspro_allcorp3resort_articles38'),
(107, 's1', '/837', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_articles38/', 'iblock_id_38'),
(108, 's1', '/837', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_articles38/', 'iblock_id_38'),
(109, 's1', '/837', '/s1/bitrix/search.tags.cloud/837', 'bitrix:search.tags.cloud'),
(110, 's1', '/837', '/s1/bitrix/search.tags.cloud/837', 'iblock_id_38'),
(111, 's1', '/837', '/s1/bitrix/news.list/837', 'iblock_id_38'),
(112, 's1', '/837', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(113, 's1', '/6d1', 'iblock_find', 'iblock_id_43'),
(114, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(115, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(116, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'iblock_id_43'),
(117, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'iblock_id_43'),
(118, 's1', '/6d1', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(119, 's1', '/9a2', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_sales40/', 'aspro_allcorp3resort_sales40'),
(120, 's1', '/9a2', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_sales40/', 'aspro_allcorp3resort_sales40'),
(121, 's1', '/9a2', '/s1/bitrix/news.detail/9a2', 'iblock_id_40'),
(122, 's1', '/9a2', '/s1/bitrix/news.detail/9a2', 'iblock_id_27'),
(123, 's1', '/9a2', '/s1/bitrix/news.list/9a2', 'iblock_id_43'),
(124, 's1', '/9a2', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/_notag/', '_notag'),
(125, 's1', '/9a2', '/s1/bitrix/news.list/9a2', 'iblock_id_40'),
(126, 's1', '/7ee', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_projects42/', 'aspro_allcorp3resort_projects42'),
(127, 's1', '/7ee', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_projects42/', 'iblock_id_42'),
(128, 's1', '/7ee', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'aspro_allcorp3resort_projects42'),
(129, 's1', '/7ee', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'iblock_id_42'),
(130, 's1', '/7ee', '/s1/bitrix/news.list/7ee', 'iblock_id_42'),
(131, 's1', '/7ee', '/s1/bitrix/news.detail/7ee', 'iblock_id_42'),
(132, 's1', '/7ee', '/s1/bitrix/news.detail/7ee', 'iblock_id_44'),
(133, 's1', '/7ee', '/s1/bitrix/news.detail/7ee', 'iblock_id_43'),
(134, 's1', '/7ee', '/s1/bitrix/news.list/7ee', 'iblock_id_40'),
(135, 's1', '/7ee', '/s1/bitrix/news.list/7ee', 'iblock_id_43'),
(136, 's1', '/7ee', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(137, 's1', '/7ee', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(138, 's1', '/973', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_staff41/', 'aspro_allcorp3resort_staff41'),
(139, 's1', '/973', '/s1/bitrix/news.detail/973', 'iblock_id_41'),
(140, 's1', '/973', '/s1/bitrix/news.detail/973', 'iblock_id_35'),
(141, 's1', '/973', '/s1/bitrix/news.list/973', 'iblock_id_35'),
(142, 's1', '/973', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(143, 's1', '/837', 'iblock_find', 'iblock_id_38'),
(144, 's1', '/837', '/s1/bitrix/news.detail/837', 'iblock_id_38'),
(145, 's1', '/837', '/s1/bitrix/catalog.comments/837', 'iblock_id_38'),
(146, 's1', '/837', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/_notag/', '_notag'),
(147, 's1', '/48e', 'iblock_find', 'iblock_id_45'),
(148, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_2'),
(149, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_44'),
(150, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_44'),
(151, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_40'),
(152, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_sales40/', 'aspro_allcorp3resort_sales40'),
(153, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_40'),
(154, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_sales40/', 'iblock_id_40'),
(155, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_40'),
(156, 's1', '/4a9', 'iblock_find', 'iblock_id_27'),
(157, 's1', '/4a9', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(158, 's1', '/4a9', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(159, 's1', '/4a9', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_price27/', 'iblock_id_27'),
(160, 's1', '/4a9', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'iblock_id_27'),
(161, 's1', '/4a9', '/s1/bitrix/news.list/4a9', 'iblock_id_27'),
(162, 's1', '/4a9', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(163, 's1', '/48e', '/s1/aspro/catalog.section.list.allcorp3resort/48e', 'iblock_id_44'),
(164, 's1', '/fc1', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'aspro_allcorp3resort_news39'),
(165, 's1', '/fc1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_news39/', 'aspro_allcorp3resort_news39'),
(166, 's1', '/fc1', '/s1/bitrix/news.detail/fc1', 'iblock_id_39'),
(167, 's1', '/fc1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/_notag/', '_notag'),
(168, 's1', '/fc1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_news39/', 'iblock_id_39'),
(169, 's1', '/fc1', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(170, 's1', '/2b7', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_gallery7/', 'aspro_allcorp3resort_gallery7'),
(171, 's1', '/2b7', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_gallery7/', 'iblock_id_7'),
(172, 's1', '/2b7', '/s1/bitrix/news.list/2b7', 'iblock_id_7'),
(175, 's1', '/e25', '/s1/aspro/com.banners.allcorp3resort/345', 'iblock_id_2'),
(176, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_front_tizers2/', 'iblock_id_2'),
(177, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_front_tizers2/', 'iblock_property_enum_544'),
(178, 's1', '/e25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_front_tizers2/', 'iblock_id_44'),
(187, 's1', '/4a9', '/s1/bitrix/news.detail/4a9', 'iblock_id_27'),
(188, 's1', '/4a9', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/_notag/', '_notag'),
(191, 's1', '/5ae', '/s1/bitrix/news.list/cd2', 'iblock_id_31'),
(192, 's1', '/a72', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(193, 's1', '/a72', '/s1/bitrix/news.detail/a72', 'iblock_id_36'),
(194, 's1', '/a72', '/s1/bitrix/news.detail/a72', 'iblock_id_44'),
(195, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_vacancy25/', 'aspro_allcorp3resort_vacancy25'),
(196, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_vacancy25/', 'aspro_allcorp3resort_vacancy25'),
(197, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_vacancy25/', 'iblock_id_25'),
(198, 's1', '/b3c', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(199, 's1', '/fc1', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'iblock_id_39'),
(200, 's1', '/fc1', '/s1/bitrix/news.list/fc1', 'iblock_id_39'),
(201, 's1', '/ab9', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(202, 's1', '/6d1', '/s1/bitrix/news.detail/6d1', 'iblock_id_43'),
(203, 's1', '/6d1', '/s1/bitrix/news.detail/6d1', 'iblock_id_26'),
(204, 's1', '/6d1', '/s1/bitrix/news.detail/6d1', 'iblock_id_44'),
(205, 's1', '/6d1', '/s1/bitrix/news.detail/6d1', 'iblock_id_27'),
(206, 's1', '/6d1', '/s1/bitrix/news.list/6d1', 'iblock_id_27'),
(207, 's1', '/6d1', '/s1/bitrix/news.list/6d1', 'iblock_id_26'),
(208, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(209, 's1', '/6d1', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(210, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/_notag/', '_notag'),
(211, 's1', '/6d1', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_43'),
(212, 's1', '/d23', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(213, 's1', '/2b7', '/s1/bitrix/news.detail/2b7', 'iblock_id_7'),
(214, 's1', '/a25', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(215, 's1', '/a25', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(216, 's1', '/a25', '/s1/bitrix/news.list/a25', 'iblock_id_27'),
(217, 's1', '/a25', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(218, 's1', '/973', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_staff41/', 'aspro_allcorp3resort_staff41'),
(219, 's1', '/973', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_staff41/', 'iblock_id_41'),
(220, 's1', '/959', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(221, 's1', '/06b', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_reviews35/', 'aspro_allcorp3resort_reviews35'),
(222, 's1', '/06b', '/s1/bitrix/news.list/06b', 'iblock_id_35'),
(223, 's1', '/06b', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(224, 's1', '/454', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(225, 's1', '/47e', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(226, 's1', '/8bf', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_landing47/', 'aspro_allcorp3resort_landing47'),
(227, 's1', '/8bf', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_landing47/', 'iblock_id_47'),
(228, 's1', '/8bf', '/s1/bitrix/news.list/8bf', 'iblock_id_47'),
(229, 's1', '/9a2', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_sales40/', 'iblock_id_40'),
(230, 's1', '/9a2', '/s1/bitrix/news.list/9a2', 'iblock_id_27'),
(231, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_2'),
(232, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_35'),
(233, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_26'),
(234, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(235, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_43'),
(236, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'iblock_id_43'),
(237, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'iblock_id_44'),
(238, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_26'),
(239, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_35'),
(240, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_43'),
(241, 's1', '/371', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_history30/', 'aspro_allcorp3resort_history30'),
(242, 's1', '/371', '/s1/bitrix/news.list/371', 'iblock_id_30'),
(243, 's1', '/371', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(244, 's1', '/ef7', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_partners37/', 'aspro_allcorp3resort_partners37'),
(245, 's1', '/ef7', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_partners37/', 'aspro_allcorp3resort_partners37'),
(246, 's1', '/ef7', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_partners37/', 'iblock_id_37'),
(247, 's1', '/ef7', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(248, 's1', '/c66', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(249, 's1', '/47b', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(251, 's1', '/6b1', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(252, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_43'),
(253, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'aspro_allcorp3resort_news39'),
(254, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_39'),
(255, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'iblock_id_39'),
(256, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'iblock_id_43'),
(257, 's1', '/48e', '/s1/bitrix/news.list/48e', 'iblock_id_39'),
(258, 's1', '/837', '/s1/bitrix/rss.out/837', 'iblock_id_38'),
(259, 's1', '/48e', '/s1/bitrix/catalog.element/48e', 'iblock_id_1'),
(260, 's1', '/fc1', '/s1/bitrix/rss.out/fc1', 'iblock_id_39'),
(261, 's1', '/ccf', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(262, 's1', '/48e', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_news39/', 'iblock_id_44'),
(268, 's1', '/a20', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_brands28/', 'aspro_allcorp3resort_brands28'),
(269, 's1', '/a20', '/s1/bitrix/news.detail/a20', 'iblock_id_28'),
(270, 's1', '/a20', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(271, 's1', '/a20', '/s1/bitrix/news.list/345', 'iblock_id_24'),
(272, 'ru', '/f00', '/CAllcorp3ResortCache/form/CForm_GetList/forms/', 'forms'),
(273, 'ru', '/f00', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_mainblocks5/', 'aspro_allcorp3resort_mainblocks5'),
(274, 'ru', '/f00', '/CAllcorp3ResortCache/form/CForm_GetList/forms/', 'iblock_id_5'),
(275, 'ru', '/f00', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_mainblocks5/', 'aspro_allcorp3resort_mainblocks5'),
(276, 'ru', '/f00', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_mainblocks5/', 'iblock_id_5'),
(279, 's1', '/e25', '/s1/bitrix/form.result.new', 'forms'),
(280, 's1', '/e25', '/s1/bitrix/form.result.new', 'form_8'),
(299, 's1', '/ef7', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_partners37/', 'iblock_id_37'),
(300, 's1', '/ef7', '/s1/bitrix/news.detail/ef7', 'iblock_id_37'),
(301, 's1', '/ef7', '/s1/bitrix/news.list/ef7', 'iblock_id_43'),
(304, 's1', '/8bf', '/s1/bitrix/news.detail/8bf', 'iblock_id_47'),
(305, 's1', '/8bf', '/s1/bitrix/news.detail/8bf', 'iblock_id_42'),
(306, 's1', '/8bf', '/s1/bitrix/news.detail/8bf', 'iblock_id_2'),
(307, 's1', '/8bf', '/s1/bitrix/news.list/8bf', 'iblock_id_2'),
(308, 's1', '/8bf', '/s1/bitrix/news.list/8bf', 'iblock_id_43'),
(309, 's1', '/8bf', '/s1/bitrix/news.list/8bf', 'iblock_id_42'),
(310, 's1', '/8bf', '/s1/bitrix/news.list/8bf', 'iblock_id_38'),
(311, 's1', '/86a', '/s1/bitrix/news.detail/cd2', 'iblock_id_40'),
(316, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_advtbig23/', 'aspro_allcorp3resort_advtbig23'),
(317, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'aspro_allcorp3resort_catalog44'),
(320, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(321, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_catalog44/', 'iblock_id_43'),
(322, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_services43/', 'iblock_id_43'),
(323, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'aspro_allcorp3resort_services43'),
(324, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'aspro_allcorp3resort_price27'),
(325, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_services43/', 'iblock_id_27'),
(326, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'aspro_allcorp3resort_projects42'),
(327, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_price27/', 'iblock_id_42'),
(328, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(329, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_projects42/', 'iblock_id_36'),
(330, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_tarifs36/', 'aspro_allcorp3resort_tarifs36'),
(331, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockSection_GetList/aspro_allcorp3resort_tarifs36/', 'iblock_id_36'),
(332, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_front_tizers2/', 'aspro_allcorp3resort_front_tizers2'),
(333, 's1', '/b3c', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_6'),
(334, 's1', '/b3c', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_23'),
(335, 's1', '/b3c', '/s1/aspro/com.banners.allcorp3resort/06f', 'iblock_id_2'),
(339, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_marketings48/', 'aspro_allcorp3resort_marketings48'),
(340, 's1', '/b3c', '/s1/aspro/social.info.allcorp3resort/345', 'iblock_id_48'),
(341, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_bottom_icons22/', 'aspro_allcorp3resort_bottom_icons22'),
(342, 's1', '/b3c', '/CAllcorp3ResortCache/iblock/CIBlockElement_GetList/aspro_allcorp3resort_marketings48/', 'iblock_id_22'),
(348, 's1', '/86a', '/s1/bitrix/form.result.new', 'forms'),
(349, 's1', '/86a', '/s1/bitrix/form.result.new', 'form_3'),
(356, 's1', '/86a', '/s1/bitrix/form.result.new', 'form_7'),
(366, 's1', '/86a', '/s1/bitrix/news.detail/cd2', 'iblock_id_35'),
(372, 's1', '/a58', '/s1/bitrix/catalog.section', 'iblock_id_44'),
(385, 's1', '/86a', '/s1/bitrix/form.result.new', 'form_8'),
(403, 's1', '/e25', '/s1/bitrix/menu/06f', 'bitrix:menu'),
(404, 's1', '/e25', '/s1/bitrix/menu/06f', 'iblock_id_44'),
(405, 's1', '/e25', '/s1/bitrix/menu/345', 'bitrix:menu'),
(406, 's1', '/e25', '/s1/bitrix/menu/345', 'iblock_id_44'),
(407, 's1', '/e25', '/s1/bitrix/menu/345', 'iblock_id_43'),
(408, 's1', '/ee2', '/s1/bitrix/menu/06f', 'bitrix:menu'),
(409, 's1', '/8bf', '/s1/bitrix/menu/06f', 'bitrix:menu'),
(412, 's1', '/6b1', '/s1/bitrix/menu/345', 'bitrix:menu');
-- -----------------------------------
-- Dumping table b_calendar_event_connection
-- -----------------------------------
DROP TABLE IF EXISTS `b_calendar_event_connection`;
CREATE TABLE `b_calendar_event_connection` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `EVENT_ID` int NOT NULL,
  `CONNECTION_ID` int NOT NULL,
  `VENDOR_EVENT_ID` varchar(255) DEFAULT NULL,
  `SYNC_STATUS` varchar(20) DEFAULT NULL,
  `ENTITY_TAG` varchar(255) DEFAULT NULL COMMENT 'Version of vendor event',
  `VERSION` varchar(255) DEFAULT NULL COMMENT 'Version of internal event',
  `VENDOR_VERSION_ID` varchar(255) DEFAULT NULL,
  `RECURRENCE_ID` varchar(255) DEFAULT NULL,
  `DATA` text,
  `RETRY_COUNT` int DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ix_cal_event_con_event_id` (`EVENT_ID`),
  KEY `ix_cal_event_con_connection_id` (`CONNECTION_ID`),
  KEY `ix_cal_event_con_recurrence_id` (`RECURRENCE_ID`),
  KEY `ix_cal_event_con_vendor_event_id` (`VENDOR_EVENT_ID`),
  KEY `ix_cal_event_con_sync_status` (`SYNC_STATUS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_calendar_event_original_recursion
-- -----------------------------------
DROP TABLE IF EXISTS `b_calendar_event_original_recursion`;
CREATE TABLE `b_calendar_event_original_recursion` (
  `PARENT_EVENT_ID` int NOT NULL,
  `ORIGINAL_RECURSION_EVENT_ID` int NOT NULL,
  PRIMARY KEY (`PARENT_EVENT_ID`),
  KEY `ix_calendar_event_original_recursion_original_recursion_event_id` (`ORIGINAL_RECURSION_EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_calendar_section_connection
-- -----------------------------------
DROP TABLE IF EXISTS `b_calendar_section_connection`;
CREATE TABLE `b_calendar_section_connection` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SECTION_ID` int NOT NULL,
  `CONNECTION_ID` int NOT NULL,
  `VENDOR_SECTION_ID` varchar(255) NOT NULL,
  `SYNC_TOKEN` text,
  `PAGE_TOKEN` text,
  `ACTIVE` char(1) DEFAULT 'Y',
  `LAST_SYNC_DATE` datetime DEFAULT NULL,
  `LAST_SYNC_STATUS` varchar(10) DEFAULT NULL,
  `VERSION_ID` varchar(255) DEFAULT NULL,
  `IS_PRIMARY` char(1) DEFAULT 'N',
  PRIMARY KEY (`ID`),
  KEY `ix_cal_section_con_section_id` (`SECTION_ID`),
  KEY `ix_cal_section_con_connection_id` (`CONNECTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_calendar_sharing_link_member
-- -----------------------------------
DROP TABLE IF EXISTS `b_calendar_sharing_link_member`;
CREATE TABLE `b_calendar_sharing_link_member` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_ID` int NOT NULL,
  `MEMBER_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `LINK_ID` (`LINK_ID`,`MEMBER_ID`),
  KEY `ix_calendar_sharing_link_member_link_id` (`LINK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_captcha
-- -----------------------------------
DROP TABLE IF EXISTS `b_captcha`;
CREATE TABLE `b_captcha` (
  `ID` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CODE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `IP` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DATE_CREATE` datetime NOT NULL,
  UNIQUE KEY `UX_B_CAPTCHA` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_agent_contract
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_agent_contract`;
CREATE TABLE `b_catalog_agent_contract` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) NOT NULL,
  `CONTRACTOR_ID` int unsigned DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `CONTRACTOR_ID` (`CONTRACTOR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_agent_contract_file
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_agent_contract_file`;
CREATE TABLE `b_catalog_agent_contract_file` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CONTRACT_ID` int NOT NULL,
  `FILE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `CONTRACT_ID` (`CONTRACT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_agent_product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_agent_product`;
CREATE TABLE `b_catalog_agent_product` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `CONTRACT_ID` int unsigned NOT NULL,
  `PRODUCT_ID` int unsigned NOT NULL,
  `PRODUCT_TYPE` varchar(8) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `CONTRACT_ID` (`CONTRACT_ID`),
  KEY `PRODUCT_ID` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_contractor
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_contractor`;
CREATE TABLE `b_catalog_contractor` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PERSON_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PERSON_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PERSON_LASTNAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PERSON_MIDDLENAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EMAIL` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PHONE` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `POST_INDEX` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `COUNTRY` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CITY` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `COMPANY` varchar(145) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `INN` varchar(145) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `KPP` varchar(145) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ADDRESS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT CURRENT_TIMESTAMP,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_currency
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_currency`;
CREATE TABLE `b_catalog_currency` (
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `AMOUNT_CNT` int NOT NULL DEFAULT '1',
  `AMOUNT` decimal(18,4) DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  `DATE_UPDATE` datetime NOT NULL,
  `NUMCODE` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `BASE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `CREATED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `CURRENT_BASE_RATE` decimal(26,12) DEFAULT NULL,
  PRIMARY KEY (`CURRENCY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_catalog_currency` VALUES
('BYN', 1, 32.2000, 500, '2023-04-27 00:03:15', '933', 'N', NULL, '2023-04-27 00:03:15', NULL, 32.200000000000),
('EUR', 1, 78.3200, 300, '2023-04-27 00:03:15', '978', 'N', NULL, '2023-04-27 00:03:15', NULL, 78.320000000000),
('RUB', 1, 1.0000, 100, '2023-04-27 00:03:15', '643', 'Y', NULL, '2023-04-27 00:03:15', NULL, 1.000000000000),
('UAH', 10, 25.1100, 400, '2023-04-27 00:03:15', '980', 'N', NULL, '2023-04-27 00:03:15', NULL, 2.511000000000),
('USD', 1, 68.7900, 200, '2023-04-27 00:03:15', '840', 'N', NULL, '2023-04-27 00:03:15', NULL, 68.790000000000);
-- -----------------------------------
-- Dumping table b_catalog_currency_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_currency_lang`;
CREATE TABLE `b_catalog_currency_lang` (
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FORMAT_STRING` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FULL_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DEC_POINT` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '.',
  `THOUSANDS_SEP` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT ' ',
  `DECIMALS` tinyint NOT NULL DEFAULT '2',
  `THOUSANDS_VARIANT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HIDE_ZERO` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `CREATED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  PRIMARY KEY (`CURRENCY`,`LID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_catalog_currency_lang` VALUES
('BYN', 'en', 'Br#', 'Belarusian Ruble', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('BYN', 'ru', '# руб.', 'Белорусский рубль', '.', NULL, 2, 'B', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('EUR', 'en', '&euro;#', 'Euro', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('EUR', 'ru', '# &euro;', 'Евро', '.', NULL, 2, 'B', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('RUB', 'en', '&#8381;#', 'Russian Ruble', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('RUB', 'ru', '# &#8381;', 'Российский рубль', '.', NULL, 2, 'B', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('UAH', 'en', '&#8372;#', 'Hryvnia', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('UAH', 'ru', '# грн.', 'Гривна', '.', NULL, 2, 'B', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('USD', 'en', '$#', 'US Dollar', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15'),
('USD', 'ru', '$#', 'Доллар США', '.', NULL, 2, 'C', 'Y', NULL, '2023-04-27 00:03:15', NULL, '2023-04-27 00:03:15');
-- -----------------------------------
-- Dumping table b_catalog_currency_rate
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_currency_rate`;
CREATE TABLE `b_catalog_currency_rate` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `BASE_CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DATE_RATE` date NOT NULL,
  `RATE_CNT` int NOT NULL DEFAULT '1',
  `RATE` decimal(18,4) NOT NULL DEFAULT '0.0000',
  `CREATED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_CURRENCY_RATE` (`CURRENCY`,`DATE_RATE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_disc_save_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_disc_save_group`;
CREATE TABLE `b_catalog_disc_save_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `GROUP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_DSG_DISCOUNT` (`DISCOUNT_ID`),
  KEY `IX_CAT_DSG_GROUP` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_disc_save_range
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_disc_save_range`;
CREATE TABLE `b_catalog_disc_save_range` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `RANGE_FROM` double NOT NULL,
  `TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `VALUE` double NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_DSR_DISCOUNT2` (`DISCOUNT_ID`,`RANGE_FROM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_disc_save_user
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_disc_save_user`;
CREATE TABLE `b_catalog_disc_save_user` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `USER_ID` int NOT NULL,
  `ACTIVE_FROM` datetime NOT NULL,
  `ACTIVE_TO` datetime NOT NULL,
  `RANGE_FROM` double NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_DSU_USER` (`DISCOUNT_ID`,`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount`;
CREATE TABLE `b_catalog_discount` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TYPE` int NOT NULL DEFAULT '0',
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ACTIVE_FROM` datetime DEFAULT NULL,
  `ACTIVE_TO` datetime DEFAULT NULL,
  `RENEWAL` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MAX_USES` int NOT NULL DEFAULT '0',
  `COUNT_USES` int NOT NULL DEFAULT '0',
  `COUPON` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  `MAX_DISCOUNT` decimal(18,4) DEFAULT NULL,
  `VALUE_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `VALUE` decimal(18,4) NOT NULL DEFAULT '0.0000',
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MIN_ORDER_SUM` decimal(18,4) DEFAULT '0.0000',
  `TIMESTAMP_X` datetime NOT NULL,
  `COUNT_PERIOD` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'U',
  `COUNT_SIZE` int NOT NULL DEFAULT '0',
  `COUNT_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `COUNT_FROM` datetime DEFAULT NULL,
  `COUNT_TO` datetime DEFAULT NULL,
  `ACTION_SIZE` int NOT NULL DEFAULT '0',
  `ACTION_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `PRIORITY` int NOT NULL DEFAULT '1',
  `LAST_DISCOUNT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `VERSION` int NOT NULL DEFAULT '1',
  `NOTES` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CONDITIONS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UNPACK` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USE_COUPONS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SALE_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_C_D_ACT` (`ACTIVE`,`ACTIVE_FROM`,`ACTIVE_TO`),
  KEY `IX_C_D_ACT_B` (`SITE_ID`,`RENEWAL`,`ACTIVE`,`ACTIVE_FROM`,`ACTIVE_TO`),
  KEY `IX_B_CAT_DISCOUNT_COUPON` (`USE_COUPONS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount2cat
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount2cat`;
CREATE TABLE `b_catalog_discount2cat` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `CATALOG_GROUP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_D2C_CATDIS` (`CATALOG_GROUP_ID`,`DISCOUNT_ID`),
  UNIQUE KEY `IX_C_D2C_CATDIS_B` (`DISCOUNT_ID`,`CATALOG_GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount2group
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount2group`;
CREATE TABLE `b_catalog_discount2group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `GROUP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_D2G_GRDIS` (`GROUP_ID`,`DISCOUNT_ID`),
  UNIQUE KEY `IX_C_D2G_GRDIS_B` (`DISCOUNT_ID`,`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount2iblock
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount2iblock`;
CREATE TABLE `b_catalog_discount2iblock` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `IBLOCK_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_D2I_IBDIS` (`IBLOCK_ID`,`DISCOUNT_ID`),
  UNIQUE KEY `IX_C_D2I_IBDIS_B` (`DISCOUNT_ID`,`IBLOCK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount2product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount2product`;
CREATE TABLE `b_catalog_discount2product` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `PRODUCT_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_D2P_PRODIS` (`PRODUCT_ID`,`DISCOUNT_ID`),
  UNIQUE KEY `IX_C_D2P_PRODIS_B` (`DISCOUNT_ID`,`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount2section
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount2section`;
CREATE TABLE `b_catalog_discount2section` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `SECTION_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_D2S_SECDIS` (`SECTION_ID`,`DISCOUNT_ID`),
  UNIQUE KEY `IX_C_D2S_SECDIS_B` (`DISCOUNT_ID`,`SECTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount_cond
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount_cond`;
CREATE TABLE `b_catalog_discount_cond` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_GROUP_ID` int NOT NULL DEFAULT '-1',
  `PRICE_TYPE_ID` int NOT NULL DEFAULT '-1',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount_coupon
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount_coupon`;
CREATE TABLE `b_catalog_discount_coupon` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `COUPON` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DATE_APPLY` datetime DEFAULT NULL,
  `ONE_TIME` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ix_cat_dc_index1` (`DISCOUNT_ID`,`COUPON`),
  KEY `ix_cat_dc_index2` (`COUPON`,`ACTIVE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount_entity
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount_entity`;
CREATE TABLE `b_catalog_discount_entity` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ENTITY` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ENTITY_ID` int DEFAULT NULL,
  `ENTITY_VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD_ENTITY` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FIELD_TABLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_DSC_ENT_SEARCH` (`DISCOUNT_ID`,`MODULE_ID`,`ENTITY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_discount_module
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_discount_module`;
CREATE TABLE `b_catalog_discount_module` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DISCOUNT_ID` int NOT NULL,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_DSC_MOD` (`DISCOUNT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_docs_barcode
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_docs_barcode`;
CREATE TABLE `b_catalog_docs_barcode` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DOC_ID` int NOT NULL,
  `DOC_ELEMENT_ID` int NOT NULL,
  `BARCODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CATALOG_DOCS_BARCODE1` (`DOC_ELEMENT_ID`),
  KEY `IX_B_CATALOG_DOCS_BARCODE_OWNER` (`DOC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_docs_element
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_docs_element`;
CREATE TABLE `b_catalog_docs_element` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DOC_ID` int NOT NULL,
  `STORE_FROM` int DEFAULT NULL,
  `STORE_TO` int DEFAULT NULL,
  `ELEMENT_ID` int DEFAULT NULL,
  `AMOUNT` double DEFAULT NULL,
  `PURCHASING_PRICE` double DEFAULT NULL,
  `BASE_PRICE` decimal(18,2) DEFAULT NULL,
  `BASE_PRICE_EXTRA` decimal(18,2) DEFAULT NULL,
  `BASE_PRICE_EXTRA_RATE` int DEFAULT NULL,
  `COMMENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CATALOG_DOCS_ELEMENT1` (`DOC_ID`),
  KEY `IX_B_CATALOG_DOCS_ELEMENT2` (`ELEMENT_ID`),
  KEY `IX_B_CATALOG_DOCS_ELEMENT3` (`STORE_FROM`),
  KEY `IX_B_CATALOG_DOCS_ELEMENT4` (`STORE_TO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_export
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_export`;
CREATE TABLE `b_catalog_export` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FILE_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DEFAULT_PROFILE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_MENU` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_AGENT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_CRON` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SETUP_VARS` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `LAST_USE` datetime DEFAULT NULL,
  `IS_EXPORT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `NEED_EDIT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `BCAT_EX_FILE_NAME` (`FILE_NAME`),
  KEY `IX_CAT_IS_EXPORT` (`IS_EXPORT`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_exported_product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_exported_product`;
CREATE TABLE `b_catalog_exported_product` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `SERVICE_ID` varchar(100) NOT NULL,
  `TIMESTAMP_X` datetime NOT NULL,
  `ERROR` text,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_PR_EXP_PRID_SVID` (`PRODUCT_ID`,`SERVICE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_exported_product_queue
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_exported_product_queue`;
CREATE TABLE `b_catalog_exported_product_queue` (
  `QUEUE_ID` int NOT NULL,
  `PRODUCT_IDS` text NOT NULL,
  PRIMARY KEY (`QUEUE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_extra
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_extra`;
CREATE TABLE `b_catalog_extra` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PERCENTAGE` decimal(18,2) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_group`;
CREATE TABLE `b_catalog_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `BASE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SORT` int NOT NULL DEFAULT '100',
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_group2group
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_group2group`;
CREATE TABLE `b_catalog_group2group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATALOG_GROUP_ID` int NOT NULL,
  `GROUP_ID` int NOT NULL,
  `BUY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_CATG2G_UNI` (`CATALOG_GROUP_ID`,`GROUP_ID`,`BUY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_group_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_group_lang`;
CREATE TABLE `b_catalog_group_lang` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATALOG_GROUP_ID` int NOT NULL,
  `LANG` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_CATALOG_GROUP_ID` (`CATALOG_GROUP_ID`,`LANG`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_iblock
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_iblock`;
CREATE TABLE `b_catalog_iblock` (
  `IBLOCK_ID` int NOT NULL,
  `YANDEX_EXPORT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SUBSCRIPTION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `VAT_ID` int DEFAULT '0',
  `PRODUCT_IBLOCK_ID` int NOT NULL DEFAULT '0',
  `SKU_PROPERTY_ID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`IBLOCK_ID`),
  KEY `IXS_CAT_IB_PRODUCT` (`PRODUCT_IBLOCK_ID`),
  KEY `IXS_CAT_IB_SKU_PROP` (`SKU_PROPERTY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_load
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_load`;
CREATE TABLE `b_catalog_load` (
  `NAME` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `VALUE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'I',
  `LAST_USED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`NAME`,`TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_measure
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_measure`;
CREATE TABLE `b_catalog_measure` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CODE` int NOT NULL,
  `MEASURE_TITLE` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SYMBOL_RUS` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SYMBOL_INTL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SYMBOL_LETTER_INTL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IS_DEFAULT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_B_CATALOG_MEASURE1` (`CODE`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_catalog_measure` VALUES
(1, 6, NULL, NULL, 'm', 'MTR', 'N'),
(2, 112, NULL, NULL, 'l', 'LTR', 'N'),
(3, 163, NULL, NULL, 'g', 'GRM', 'N'),
(4, 166, NULL, NULL, 'kg', 'KGM', 'N'),
(5, 796, NULL, NULL, 'pc. 1', 'PCE. NMB', 'Y');
-- -----------------------------------
-- Dumping table b_catalog_measure_ratio
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_measure_ratio`;
CREATE TABLE `b_catalog_measure_ratio` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `RATIO` double NOT NULL DEFAULT '1',
  `IS_DEFAULT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_B_CATALOG_MEASURE_RATIO` (`PRODUCT_ID`,`RATIO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_permission
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_permission`;
CREATE TABLE `b_catalog_permission` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `ROLE_ID` int unsigned NOT NULL,
  `PERMISSION_ID` varchar(32) NOT NULL DEFAULT '0',
  `VALUE` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ROLE_ID` (`ROLE_ID`),
  KEY `PERMISSION_ID` (`PERMISSION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_price
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_price`;
CREATE TABLE `b_catalog_price` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `EXTRA_ID` int DEFAULT NULL,
  `CATALOG_GROUP_ID` int NOT NULL,
  `PRICE` decimal(18,2) NOT NULL,
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TIMESTAMP_X` datetime NOT NULL,
  `QUANTITY_FROM` int DEFAULT NULL,
  `QUANTITY_TO` int DEFAULT NULL,
  `TMP_ID` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PRICE_SCALE` decimal(26,12) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IXS_CAT_PRICE_PID` (`PRODUCT_ID`,`CATALOG_GROUP_ID`),
  KEY `IXS_CAT_PRICE_GID` (`CATALOG_GROUP_ID`),
  KEY `IXS_CAT_PRICE_SCALE` (`PRICE_SCALE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_product`;
CREATE TABLE `b_catalog_product` (
  `ID` int NOT NULL,
  `QUANTITY` double NOT NULL,
  `QUANTITY_TRACE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `WEIGHT` double NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime NOT NULL,
  `PRICE_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'S',
  `RECUR_SCHEME_LENGTH` int DEFAULT NULL,
  `RECUR_SCHEME_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'D',
  `TRIAL_PRICE_ID` int DEFAULT NULL,
  `WITHOUT_ORDER` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SELECT_BEST_PRICE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `VAT_ID` int DEFAULT '0',
  `VAT_INCLUDED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `CAN_BUY_ZERO` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `NEGATIVE_AMOUNT_TRACE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'D',
  `TMP_ID` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PURCHASING_PRICE` decimal(18,2) DEFAULT NULL,
  `PURCHASING_CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `BARCODE_MULTI` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `QUANTITY_RESERVED` double DEFAULT '0',
  `SUBSCRIBE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `WIDTH` double DEFAULT NULL,
  `LENGTH` double DEFAULT NULL,
  `HEIGHT` double DEFAULT NULL,
  `MEASURE` int DEFAULT NULL,
  `TYPE` int DEFAULT NULL,
  `AVAILABLE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `BUNDLE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_product2group
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_product2group`;
CREATE TABLE `b_catalog_product2group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `GROUP_ID` int NOT NULL,
  `ACCESS_LENGTH` int NOT NULL,
  `ACCESS_LENGTH_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'D',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_C_P2G_PROD_GROUP` (`PRODUCT_ID`,`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_product_compilation
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_product_compilation`;
CREATE TABLE `b_catalog_product_compilation` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DEAL_ID` int NOT NULL,
  `PRODUCT_IDS` text NOT NULL,
  `CREATION_DATE` datetime NOT NULL,
  `CHAT_ID` int DEFAULT NULL,
  `QUEUE_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_COMPILATION_DEAL_ID` (`DEAL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_product_sets
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_product_sets`;
CREATE TABLE `b_catalog_product_sets` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TYPE` int NOT NULL,
  `SET_ID` int NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `OWNER_ID` int NOT NULL,
  `ITEM_ID` int NOT NULL,
  `QUANTITY` double DEFAULT NULL,
  `MEASURE` int DEFAULT NULL,
  `DISCOUNT_PERCENT` double DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  `CREATED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_PR_SET_TYPE` (`TYPE`),
  KEY `IX_CAT_PR_SET_OWNER_ID` (`OWNER_ID`),
  KEY `IX_CAT_PR_SET_SET_ID` (`SET_ID`),
  KEY `IX_CAT_PR_SET_ITEM_ID` (`ITEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_role
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_role`;
CREATE TABLE `b_catalog_role` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `NAME` varchar(250) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_role_relation
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_role_relation`;
CREATE TABLE `b_catalog_role_relation` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `ROLE_ID` int unsigned NOT NULL,
  `RELATION` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `ROLE_ID` (`ROLE_ID`),
  KEY `RELATION` (`RELATION`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_rounding
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_rounding`;
CREATE TABLE `b_catalog_rounding` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATALOG_GROUP_ID` int NOT NULL,
  `PRICE` decimal(18,4) NOT NULL,
  `ROUND_TYPE` int NOT NULL,
  `ROUND_PRECISION` decimal(18,4) NOT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_RND_CATALOG_GROUP` (`CATALOG_GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_store
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store`;
CREATE TABLE `b_catalog_store` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(75) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ADDRESS` varchar(245) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `GPS_N` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '0',
  `GPS_S` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '0',
  `IMAGE_ID` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LOCATION_ID` int DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT CURRENT_TIMESTAMP,
  `DATE_CREATE` datetime DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `PHONE` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SCHEDULE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '100',
  `EMAIL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ISSUING_CENTER` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SHIPPING_CENTER` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CODE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IS_DEFAULT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_barcode
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_barcode`;
CREATE TABLE `b_catalog_store_barcode` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `BARCODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STORE_ID` int DEFAULT NULL,
  `ORDER_ID` int DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_B_CATALOG_STORE_BARCODE1` (`BARCODE`),
  KEY `IX_B_CATALOG_STORE_BARCODE2` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_batch
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_batch`;
CREATE TABLE `b_catalog_store_batch` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ELEMENT_ID` int NOT NULL,
  `STORE_ID` int NOT NULL,
  `STORE_DOC_ELEMENT_ID` int DEFAULT NULL,
  `AVAILABLE_AMOUNT` double DEFAULT NULL,
  `PURCHASING_PRICE` decimal(22,6) DEFAULT NULL,
  `PURCHASING_CURRENCY` char(3) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_ELEMENT_ID` (`ELEMENT_ID`),
  KEY `IX_B_STORE_ID` (`STORE_ID`),
  KEY `IX_B_CATALOG_STORE_DOC_ELEMENT_ID` (`STORE_DOC_ELEMENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_batch_docs_element
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_batch_docs_element`;
CREATE TABLE `b_catalog_store_batch_docs_element` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DOCUMENT_ELEMENT_ID` int DEFAULT NULL,
  `SHIPMENT_ITEM_STORE_ID` int DEFAULT NULL,
  `AMOUNT` double NOT NULL,
  `PRODUCT_BATCH_ID` int NOT NULL,
  `BATCH_PRICE` decimal(22,6) DEFAULT NULL,
  `BATCH_CURRENCY` char(3) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_SHIPMENT_ITEM_STORE_ID` (`SHIPMENT_ITEM_STORE_ID`),
  KEY `IX_B_DOCUMENT_ELEMENT_ID` (`DOCUMENT_ELEMENT_ID`),
  KEY `IX_B_PRODUCT_BATCH_ID` (`PRODUCT_BATCH_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_docs
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_docs`;
CREATE TABLE `b_catalog_store_docs` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DOC_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CONTRACTOR_ID` int DEFAULT NULL,
  `DATE_MODIFY` datetime DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `CURRENCY` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STATUS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `DATE_STATUS` datetime DEFAULT NULL,
  `DATE_DOCUMENT` datetime DEFAULT NULL,
  `STATUS_BY` int DEFAULT NULL,
  `TOTAL` double DEFAULT NULL,
  `COMMENTARY` varchar(1000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `RESPONSIBLE_ID` int DEFAULT NULL,
  `ITEMS_ORDER_DATE` datetime DEFAULT NULL,
  `ITEMS_RECEIVED_DATE` datetime DEFAULT NULL,
  `DOC_NUMBER` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `WAS_CANCELLED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  PRIMARY KEY (`ID`),
  KEY `IX_B_CATALOG_STORE_DOCS_MOBILE` (`DOC_TYPE`,`DATE_MODIFY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_document_file
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_document_file`;
CREATE TABLE `b_catalog_store_document_file` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DOCUMENT_ID` int NOT NULL,
  `FILE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CATALOG_STORE_DOCUMENT_FILE_DOC_ID` (`DOCUMENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_store_product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_store_product`;
CREATE TABLE `b_catalog_store_product` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PRODUCT_ID` int NOT NULL,
  `AMOUNT` double NOT NULL DEFAULT '0',
  `STORE_ID` int NOT NULL,
  `QUANTITY_RESERVED` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_CATALOG_STORE_PRODUCT2` (`PRODUCT_ID`,`STORE_ID`),
  KEY `IX_CATALOG_STORE_PRODUCT1` (`STORE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_subscribe
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_subscribe`;
CREATE TABLE `b_catalog_subscribe` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `DATE_FROM` datetime NOT NULL,
  `DATE_TO` datetime DEFAULT NULL,
  `USER_CONTACT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CONTACT_TYPE` smallint unsigned NOT NULL,
  `USER_ID` int unsigned DEFAULT NULL,
  `ITEM_ID` int unsigned NOT NULL,
  `NEED_SENDING` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LANDING_SITE_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_SUB_USER_CONTACT` (`USER_CONTACT`),
  KEY `IX_CAT_SUB_USER_ID` (`USER_ID`),
  KEY `IX_CAT_SUB_ITEM_ID` (`ITEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_subscribe_access
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_subscribe_access`;
CREATE TABLE `b_catalog_subscribe_access` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `DATE_FROM` datetime NOT NULL,
  `USER_CONTACT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TOKEN` char(6) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_SUB_ACS_USER_CONTACT` (`USER_CONTACT`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_vat
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_vat`;
CREATE TABLE `b_catalog_vat` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `C_SORT` int NOT NULL DEFAULT '100',
  `NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `RATE` decimal(18,2) DEFAULT '0.00',
  `EXCLUDE_VAT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_VAT_ACTIVE` (`ACTIVE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_catalog_viewed_product
-- -----------------------------------
DROP TABLE IF EXISTS `b_catalog_viewed_product`;
CREATE TABLE `b_catalog_viewed_product` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FUSER_ID` int NOT NULL,
  `DATE_VISIT` datetime NOT NULL,
  `PRODUCT_ID` int NOT NULL,
  `ELEMENT_ID` int NOT NULL DEFAULT '0',
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `VIEW_COUNT` int NOT NULL DEFAULT '1',
  `RECOMMENDATION` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_CAT_V_PR_VISIT` (`FUSER_ID`,`SITE_ID`,`DATE_VISIT`),
  KEY `IX_CAT_V_PR_PRODUCT` (`FUSER_ID`,`SITE_ID`,`ELEMENT_ID`),
  KEY `IX_CAT_V_PR_PRODUCT_VISIT` (`ELEMENT_ID`,`DATE_VISIT`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_checklist
-- -----------------------------------
DROP TABLE IF EXISTS `b_checklist`;
CREATE TABLE `b_checklist` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DATE_CREATE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TESTER` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `COMPANY_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PICTURE` int DEFAULT NULL,
  `TOTAL` int DEFAULT NULL,
  `SUCCESS` int DEFAULT NULL,
  `FAILED` int DEFAULT NULL,
  `PENDING` int DEFAULT NULL,
  `SKIP` int DEFAULT NULL,
  `STATE` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `REPORT_COMMENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `REPORT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `EMAIL` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PHONE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SENDED_TO_BITRIX` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `HIDDEN` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_copy_queue
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_copy_queue`;
CREATE TABLE `b_clouds_copy_queue` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL,
  `OP` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SOURCE_BUCKET_ID` int NOT NULL,
  `SOURCE_FILE_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TARGET_BUCKET_ID` int NOT NULL,
  `TARGET_FILE_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FILE_SIZE` int NOT NULL DEFAULT '-1',
  `FILE_POS` int NOT NULL DEFAULT '0',
  `FAIL_COUNTER` int NOT NULL DEFAULT '0',
  `STATUS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ERROR_MESSAGE` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_delete_queue
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_delete_queue`;
CREATE TABLE `b_clouds_delete_queue` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL,
  `BUCKET_ID` int NOT NULL,
  `FILE_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_b_clouds_delete_queue_1` (`BUCKET_ID`,`FILE_PATH`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_file_bucket
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_file_bucket`;
CREATE TABLE `b_clouds_file_bucket` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `SORT` int DEFAULT '500',
  `READ_ONLY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `SERVICE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `BUCKET` varchar(63) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LOCATION` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CNAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FILE_COUNT` int DEFAULT '0',
  `FILE_SIZE` double DEFAULT '0',
  `LAST_FILE_ID` int DEFAULT NULL,
  `PREFIX` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SETTINGS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `FILE_RULES` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `FAILOVER_ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `FAILOVER_BUCKET_ID` int DEFAULT NULL,
  `FAILOVER_COPY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `FAILOVER_DELETE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `FAILOVER_DELETE_DELAY` int DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_file_hash
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_file_hash`;
CREATE TABLE `b_clouds_file_hash` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BUCKET_ID` int NOT NULL,
  `FILE_PATH` varchar(760) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FILE_SIZE` bigint DEFAULT NULL,
  `FILE_MTIME` datetime DEFAULT NULL,
  `FILE_HASH` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_b_clouds_file_hash` (`BUCKET_ID`,`FILE_PATH`(190))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_file_resize
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_file_resize`;
CREATE TABLE `b_clouds_file_resize` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL,
  `ERROR_CODE` int NOT NULL DEFAULT '0',
  `FILE_ID` int DEFAULT NULL,
  `PARAMS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `FROM_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TO_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_b_file_resize_ts` (`TIMESTAMP_X`),
  KEY `ix_b_file_resize_path` (`TO_PATH`(100)),
  KEY `ix_b_file_resize_file` (`FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_file_save
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_file_save`;
CREATE TABLE `b_clouds_file_save` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL,
  `BUCKET_ID` int NOT NULL,
  `SUBDIR` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FILE_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `EXTERNAL_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FILE_SIZE` bigint DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_EXTERNAL_ID` (`EXTERNAL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_clouds_file_upload
-- -----------------------------------
DROP TABLE IF EXISTS `b_clouds_file_upload`;
CREATE TABLE `b_clouds_file_upload` (
  `ID` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TIMESTAMP_X` datetime NOT NULL,
  `FILE_PATH` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FILE_SIZE` bigint DEFAULT NULL,
  `TMP_FILE` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `BUCKET_ID` int NOT NULL,
  `PART_SIZE` int NOT NULL,
  `PART_NO` int NOT NULL,
  `PART_FAIL_COUNTER` int NOT NULL,
  `NEXT_STEP` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_component_params
-- -----------------------------------
DROP TABLE IF EXISTS `b_component_params`;
CREATE TABLE `b_component_params` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `COMPONENT_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TEMPLATE_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `REAL_PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SEF_MODE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SEF_FOLDER` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `START_CHAR` int NOT NULL,
  `END_CHAR` int NOT NULL,
  `PARAMETERS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `ix_comp_params_name` (`COMPONENT_NAME`),
  KEY `ix_comp_params_path` (`SITE_ID`,`REAL_PATH`),
  KEY `ix_comp_params_sname` (`SITE_ID`,`COMPONENT_NAME`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_component_params` VALUES
(4, 's1', 'bitrix:map.yandex.view', '', '/include/contacts-site-map-yandex.php', 'N', NULL, 89, 698, 'a:8:{s:7:\"API_KEY\";s:0:\"\";s:8:\"CONTROLS\";a:4:{i:0;s:4:\"ZOOM\";i:1;s:7:\"MINIMAP\";i:2;s:11:\"TYPECONTROL\";i:3;s:9:\"SCALELINE\";}s:13:\"INIT_MAP_TYPE\";s:3:\"MAP\";s:8:\"MAP_DATA\";s:240:\"a:4:{s:10:\"yandex_lat\";d:43.15360302465258;s:10:\"yandex_lon\";d:47.471670270672924;s:12:\"yandex_scale\";i:14;s:10:\"PLACEMARKS\";a:1:{i:0;a:3:{s:3:\"LON\";d:47.48000389408222;s:3:\"LAT\";d:43.15347832632487;s:4:\"TEXT\";s:19:\"Город Моря\";}}}\";s:10:\"MAP_HEIGHT\";s:3:\"500\";s:6:\"MAP_ID\";s:0:\"\";s:9:\"MAP_WIDTH\";s:3:\"600\";s:7:\"OPTIONS\";a:3:{i:0;s:18:\"ENABLE_SCROLL_ZOOM\";i:1;s:20:\"ENABLE_DBLCLICK_ZOOM\";i:2;s:15:\"ENABLE_DRAGGING\";}}'),
(8, 's1', 'aspro:developer.allcorp3resort', '.default', '/include/footer/developer.php', 'N', NULL, 2, 276, 'a:5:{s:10:\"CACHE_TYPE\";s:1:\"A\";s:10:\"CACHE_TIME\";s:7:\"3600000\";s:12:\"CACHE_GROUPS\";s:1:\"N\";s:18:\"COMPONENT_TEMPLATE\";s:8:\".default\";s:12:\"CACHE_FILTER\";s:1:\"N\";}'),
(10, 's1', 'bitrix:news', 'news', '/news/index.php', 'Y', '/news/', 99, 6093, 'a:126:{s:17:\"ADD_ELEMENT_CHAIN\";s:1:\"Y\";s:18:\"ADD_SECTIONS_CHAIN\";s:1:\"N\";s:9:\"AJAX_MODE\";s:1:\"N\";s:22:\"AJAX_OPTION_ADDITIONAL\";s:0:\"\";s:19:\"AJAX_OPTION_HISTORY\";s:1:\"N\";s:16:\"AJAX_OPTION_JUMP\";s:1:\"N\";s:17:\"AJAX_OPTION_STYLE\";s:1:\"Y\";s:13:\"BROWSER_TITLE\";s:1:\"-\";s:12:\"CACHE_FILTER\";s:1:\"N\";s:12:\"CACHE_GROUPS\";s:1:\"Y\";s:10:\"CACHE_TIME\";s:8:\"36000000\";s:10:\"CACHE_TYPE\";s:1:\"A\";s:11:\"CHECK_DATES\";s:1:\"Y\";s:20:\"COMPOSITE_FRAME_MODE\";s:1:\"A\";s:20:\"COMPOSITE_FRAME_TYPE\";s:4:\"AUTO\";s:25:\"DETAIL_ACTIVE_DATE_FORMAT\";s:5:\"d.m.Y\";s:27:\"DETAIL_DISPLAY_BOTTOM_PAGER\";s:1:\"Y\";s:24:\"DETAIL_DISPLAY_TOP_PAGER\";s:1:\"N\";s:17:\"DETAIL_FIELD_CODE\";a:8:{i:0;s:2:\"ID\";i:1;s:4:\"TAGS\";i:2;s:12:\"PREVIEW_TEXT\";i:3;s:15:\"PREVIEW_PICTURE\";i:4;s:14:\"DETAIL_PICTURE\";i:5;s:16:\"DATE_ACTIVE_FROM\";i:6;s:9:\"ACTIVE_TO\";i:7;s:0:\"\";}s:21:\"DETAIL_PAGER_SHOW_ALL\";s:1:\"Y\";s:21:\"DETAIL_PAGER_TEMPLATE\";s:0:\"\";s:18:\"DETAIL_PAGER_TITLE\";s:16:\"Страница\";s:20:\"DETAIL_PROPERTY_CODE\";a:54:{i:0;s:13:\"FORM_QUESTION\";i:1;s:10:\"FORM_ORDER\";i:2;s:6:\"PERIOD\";i:3;s:8:\"PHOTOPOS\";i:4;s:12:\"VIDEO_IFRAME\";i:5;s:5:\"VIDEO\";i:6;s:12:\"LINK_VACANCY\";i:7;s:13:\"LINK_PARTNERS\";i:8;s:11:\"LINK_TIZERS\";i:9;s:10:\"LINK_GOODS\";i:10;s:17:\"LINK_GOODS_FILTER\";i:11;s:13:\"LINK_SERVICES\";i:12;s:9:\"LINK_SALE\";i:13;s:9:\"LINK_NEWS\";i:14;s:13:\"LINK_PROJECTS\";i:15;s:12:\"LINK_REVIEWS\";i:16;s:10:\"LINK_STAFF\";i:17;s:8:\"LINK_FAQ\";i:18;s:13:\"LINK_ARTICLES\";i:19;s:6:\"AUTHOR\";i:20;s:4:\"DATA\";i:21;s:12:\"TASK_PROJECT\";i:22;s:4:\"SITE\";i:23;s:7:\"ORDERER\";i:24;s:5:\"PRICE\";i:25;s:8:\"PRICEOLD\";i:26;s:7:\"ECONOMY\";i:27;s:10:\"LINK_STUDY\";i:28;s:10:\"FOR_SHOW_1\";i:29;s:10:\"FOR_SHOW_5\";i:30;s:10:\"FOR_SHOW_2\";i:31;s:10:\"FOR_SHOW_3\";i:32;s:10:\"FOR_SHOW_4\";i:33;s:10:\"FOR_SHOW_6\";i:34;s:10:\"FOR_SHOW_7\";i:35;s:10:\"FOR_SHOW_8\";i:36;s:9:\"DOCUMENTS\";i:37;s:6:\"PHOTOS\";i:38;s:6:\"STATUS\";i:39;s:7:\"ARTICLE\";i:40;s:8:\"LINK_SKU\";i:41;s:14:\"PRICE_CURRENCY\";i:42;s:5:\"DEPTH\";i:43;s:11:\"GRUZ_STRELI\";i:44;s:4:\"GRUZ\";i:45;s:12:\"DLINA_STRELI\";i:46;s:6:\"VOLUME\";i:47;s:9:\"RECOMMEND\";i:48;s:5:\"SPEED\";i:49;s:12:\"WIDTH_PROHOD\";i:50;s:12:\"WIDTH_PROEZD\";i:51;s:12:\"DATE_COUNTER\";i:52;s:11:\"SALE_NUMBER\";i:53;s:0:\"\";}s:24:\"DETAIL_SET_CANONICAL_URL\";s:1:\"N\";s:20:\"DISPLAY_BOTTOM_PAGER\";s:1:\"Y\";s:12:\"DISPLAY_DATE\";s:1:\"Y\";s:12:\"DISPLAY_NAME\";s:1:\"Y\";s:15:\"DISPLAY_PICTURE\";s:1:\"Y\";s:20:\"DISPLAY_PREVIEW_TEXT\";s:1:\"Y\";s:17:\"DISPLAY_TOP_PAGER\";s:1:\"N\";s:17:\"FILTER_FIELD_CODE\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:11:\"FILTER_NAME\";s:0:\"\";s:20:\"FILTER_PROPERTY_CODE\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:24:\"HIDE_LINK_WHEN_NO_DETAIL\";s:1:\"N\";s:9:\"IBLOCK_ID\";s:2:\"39\";s:11:\"IBLOCK_TYPE\";s:28:\"aspro_allcorp3resort_content\";s:25:\"INCLUDE_IBLOCK_INTO_CHAIN\";s:1:\"N\";s:23:\"LIST_ACTIVE_DATE_FORMAT\";s:5:\"j F Y\";s:15:\"LIST_FIELD_CODE\";a:5:{i:0;s:4:\"NAME\";i:1;s:12:\"PREVIEW_TEXT\";i:2;s:15:\"PREVIEW_PICTURE\";i:3;s:11:\"ACTIVE_FROM\";i:4;s:0:\"\";}s:18:\"LIST_PROPERTY_CODE\";a:4:{i:0;s:6:\"PERIOD\";i:1;s:8:\"REDIRECT\";i:2;s:11:\"SALE_NUMBER\";i:3;s:0:\"\";}s:11:\"MESSAGE_404\";s:0:\"\";s:16:\"META_DESCRIPTION\";s:1:\"-\";s:13:\"META_KEYWORDS\";s:1:\"-\";s:10:\"NEWS_COUNT\";s:2:\"10\";s:22:\"PAGER_BASE_LINK_ENABLE\";s:1:\"N\";s:20:\"PAGER_DESC_NUMBERING\";s:1:\"N\";s:31:\"PAGER_DESC_NUMBERING_CACHE_TIME\";s:5:\"36000\";s:14:\"PAGER_SHOW_ALL\";s:1:\"N\";s:17:\"PAGER_SHOW_ALWAYS\";s:1:\"N\";s:14:\"PAGER_TEMPLATE\";s:4:\"main\";s:11:\"PAGER_TITLE\";s:14:\"Новости\";s:20:\"PREVIEW_TRUNCATE_LEN\";s:0:\"\";s:10:\"SEF_FOLDER\";s:6:\"/news/\";s:8:\"SEF_MODE\";s:1:\"Y\";s:17:\"SET_LAST_MODIFIED\";s:1:\"N\";s:14:\"SET_STATUS_404\";s:1:\"Y\";s:9:\"SET_TITLE\";s:1:\"Y\";s:8:\"SHOW_404\";s:1:\"Y\";s:8:\"SORT_BY1\";s:11:\"ACTIVE_FROM\";s:8:\"SORT_BY2\";s:4:\"SORT\";s:11:\"SORT_ORDER1\";s:4:\"DESC\";s:11:\"SORT_ORDER2\";s:3:\"ASC\";s:20:\"STRICT_SECTION_CHECK\";s:1:\"N\";s:14:\"USE_CATEGORIES\";s:1:\"N\";s:10:\"USE_FILTER\";s:1:\"Y\";s:15:\"USE_PERMISSIONS\";s:1:\"N\";s:10:\"USE_RATING\";s:1:\"N\";s:7:\"USE_RSS\";s:1:\"Y\";s:10:\"USE_SEARCH\";s:1:\"N\";s:9:\"USE_SHARE\";s:1:\"Y\";s:18:\"COMPONENT_TEMPLATE\";s:4:\"news\";s:26:\"SECTION_ELEMENTS_TYPE_VIEW\";s:11:\"FROM_MODULE\";s:17:\"ELEMENT_TYPE_VIEW\";s:9:\"element_1\";s:16:\"SHOW_DETAIL_LINK\";s:1:\"Y\";s:19:\"INCLUDE_SUBSECTIONS\";s:1:\"Y\";s:16:\"SHOW_FILTER_DATE\";s:1:\"N\";s:13:\"SHOW_CATEGORY\";s:1:\"Y\";s:15:\"DETAIL_USE_TAGS\";s:1:\"Y\";s:23:\"PROPERTIES_DISPLAY_TYPE\";s:5:\"TABLE\";s:6:\"T_DESC\";s:0:\"\";s:6:\"T_CHAR\";s:0:\"\";s:16:\"SHOW_BIG_GALLERY\";s:1:\"Y\";s:16:\"TYPE_BIG_GALLERY\";s:5:\"SMALL\";s:13:\"T_BIG_GALLERY\";s:0:\"\";s:21:\"BIG_GALLERY_PROP_CODE\";s:6:\"PHOTOS\";s:7:\"T_VIDEO\";s:0:\"\";s:6:\"T_DOCS\";s:0:\"\";s:14:\"DOCS_PROP_CODE\";s:9:\"DOCUMENTS\";s:5:\"T_FAQ\";s:0:\"\";s:9:\"T_REVIEWS\";s:0:\"\";s:9:\"T_VACANCY\";s:0:\"\";s:7:\"T_STAFF\";s:0:\"\";s:6:\"T_SALE\";s:0:\"\";s:6:\"T_NEWS\";s:0:\"\";s:10:\"T_ARTICLES\";s:0:\"\";s:10:\"T_SERVICES\";s:0:\"\";s:10:\"T_PROJECTS\";s:0:\"\";s:10:\"T_PARTNERS\";s:0:\"\";s:7:\"T_GOODS\";s:0:\"\";s:9:\"SHOW_DOPS\";s:1:\"N\";s:19:\"DETAIL_USE_COMMENTS\";s:1:\"N\";s:23:\"DETAIL_BLOCKS_ALL_ORDER\";s:142:\"order_form,desc,big_gallery,char,projects,reviews,tizers,video,services,news,sale,articles,docs,staff,faq,partners,vacancy,goods,dops,comments\";s:14:\"S_ASK_QUESTION\";s:0:\"\";s:15:\"S_ORDER_SERVISE\";s:29:\"Заказать услугу\";s:21:\"FORM_ID_ORDER_SERVISE\";s:0:\"\";s:8:\"NUM_NEWS\";s:2:\"20\";s:8:\"NUM_DAYS\";s:2:\"30\";s:6:\"YANDEX\";s:1:\"N\";s:6:\"T_DOPS\";s:0:\"\";s:15:\"DETAIL_BLOG_USE\";s:1:\"Y\";s:15:\"DETAIL_BLOG_URL\";s:16:\"catalog_comments\";s:14:\"COMMENTS_COUNT\";s:1:\"5\";s:17:\"DETAIL_BLOG_TITLE\";s:22:\"Комментарии\";s:24:\"DETAIL_BLOG_EMAIL_NOTIFY\";s:1:\"N\";s:13:\"DETAIL_VK_USE\";s:1:\"N\";s:13:\"DETAIL_FB_USE\";s:1:\"N\";s:13:\"SKU_IBLOCK_ID\";s:2:\"21\";s:17:\"SKU_PROPERTY_CODE\";a:13:{i:0;s:10:\"FORM_ORDER\";i:1;s:6:\"STATUS\";i:2;s:7:\"ARTICLE\";i:3;s:14:\"PRICE_CURRENCY\";i:4;s:5:\"PRICE\";i:5;s:8:\"PRICEOLD\";i:6;s:7:\"ECONOMY\";i:7;s:5:\"COLOR\";i:8;s:4:\"GOST\";i:9;s:5:\"DLINA\";i:10;s:12:\"VYLET_STRELY\";i:11;s:10:\"MARK_STEEL\";i:12;s:5:\"WIDTH\";}s:14:\"SKU_TREE_PROPS\";a:6:{i:0;s:5:\"COLOR\";i:1;s:8:\"DIAMETER\";i:2;s:5:\"DLINA\";i:3;s:12:\"VYLET_STRELY\";i:4;s:15:\"THICKNESS_STEEL\";i:5;s:5:\"WIDTH\";}s:14:\"SKU_SORT_FIELD\";s:4:\"sort\";s:14:\"SKU_SORT_ORDER\";s:3:\"asc\";s:15:\"SKU_SORT_FIELD2\";s:4:\"name\";s:15:\"SKU_SORT_ORDER2\";s:3:\"asc\";s:10:\"USE_REVIEW\";s:1:\"N\";s:8:\"FILE_404\";s:0:\"\";s:17:\"SEF_URL_TEMPLATES\";a:5:{s:4:\"news\";s:0:\"\";s:7:\"section\";s:0:\"\";s:6:\"detail\";s:15:\"#ELEMENT_CODE#/\";s:3:\"rss\";s:4:\"rss/\";s:11:\"rss_section\";s:17:\"#SECTION_ID#/rss/\";}}');
-- -----------------------------------
-- Dumping table b_composite_log
-- -----------------------------------
DROP TABLE IF EXISTS `b_composite_log`;
CREATE TABLE `b_composite_log` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `HOST` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `URI` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TITLE` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CREATED` datetime NOT NULL,
  `TYPE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MESSAGE` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `AJAX` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `USER_ID` int NOT NULL DEFAULT '0',
  `PAGE_ID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `IX_B_COMPOSITE_LOG_PAGE_ID` (`PAGE_ID`),
  KEY `IX_B_COMPOSITE_LOG_HOST` (`HOST`),
  KEY `IX_B_COMPOSITE_LOG_TYPE` (`TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_composite_page
-- -----------------------------------
DROP TABLE IF EXISTS `b_composite_page`;
CREATE TABLE `b_composite_page` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CACHE_KEY` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `HOST` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `URI` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TITLE` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CREATED` datetime NOT NULL,
  `CHANGED` datetime NOT NULL,
  `LAST_VIEWED` datetime NOT NULL,
  `VIEWS` int NOT NULL DEFAULT '0',
  `REWRITES` int NOT NULL DEFAULT '0',
  `SIZE` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `IX_B_COMPOSITE_PAGE_CACHE_KEY` (`CACHE_KEY`(100)),
  KEY `IX_B_COMPOSITE_PAGE_VIEWED` (`LAST_VIEWED`),
  KEY `IX_B_COMPOSITE_PAGE_HOST` (`HOST`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_consent_agreement
-- -----------------------------------
DROP TABLE IF EXISTS `b_consent_agreement`;
CREATE TABLE `b_consent_agreement` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CODE` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DATE_INSERT` datetime NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LANGUAGE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DATA_PROVIDER` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AGREEMENT_TEXT` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `LABEL_TEXT` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECURITY_CODE` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USE_URL` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IS_AGREEMENT_TEXT_HTML` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ID`),
  KEY `IX_B_CONSENT_AGREEMENT_CODE` (`CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_consent_field
-- -----------------------------------
DROP TABLE IF EXISTS `b_consent_field`;
CREATE TABLE `b_consent_field` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `AGREEMENT_ID` int NOT NULL,
  `CODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `VALUE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CONSENT_FIELD_AG_ID` (`AGREEMENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_consent_user_consent
-- -----------------------------------
DROP TABLE IF EXISTS `b_consent_user_consent`;
CREATE TABLE `b_consent_user_consent` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DATE_INSERT` datetime NOT NULL,
  `AGREEMENT_ID` int NOT NULL,
  `USER_ID` int DEFAULT NULL,
  `IP` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `URL` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ORIGIN_ID` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ORIGINATOR_ID` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CONSENT_USER_CONSENT` (`AGREEMENT_ID`),
  KEY `IX_CONSENT_USER_CONSENT_USER_ORIGIN` (`USER_ID`,`ORIGIN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_consent_user_consent_item
-- -----------------------------------
DROP TABLE IF EXISTS `b_consent_user_consent_item`;
CREATE TABLE `b_consent_user_consent_item` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_CONSENT_ID` int NOT NULL,
  `VALUE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_CONSENT_USER_ITEM_AG_ID` (`USER_CONSENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_conv_context
-- -----------------------------------
DROP TABLE IF EXISTS `b_conv_context`;
CREATE TABLE `b_conv_context` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `SNAPSHOT` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_B_CONV_CONTEXT_SNAPSHOT` (`SNAPSHOT`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_conv_context` VALUES
(1, 'ac28e9d3b958eac0e8be6ef5c1de29b9d59496fc74fa555e845871e2c0fd3833'),
(2, '13711320167b7d48ecada5db836b3c4eb6a6fa7ea7e419c821efc56901c13a3f'),
(3, '23a6bbcf8f06b3ea0e6e29dc690bbcdbccd18b53aec7d5c690697ddfc5e09bf8'),
(4, 'beaf60bb7d8195a0acf5d934f2b636b9e67a3213cc29100130415e2682378aa2'),
(5, 'a45a6dfa916ff42c3e19fe44ae4a5a595504230b19368d8a99abe9c6faeaeada'),
(6, '63f0fd7cef5d90ee9a9a08c2eaa888f95d7afd9008d9facdbf01f76b22194281'),
(7, 'f30dbffa4ac0a3816522ee64fc073185f4770f876adb593e3eae426f132a25d0'),
(8, '962c9a763ecd21b55860b2564c5648856e722a3bcdc36e0c034b0e5d1d67f168'),
(9, 'befa27a7316915d0272d801dc9880900021cf8c237fa91dfe4927925c92bd5c3'),
(10, '8beea819a03742c6540dc7e61feb1083882cb0191658bd2d4b7fcb9f4aac941d'),
(11, '0768cfc1102f5c336f776566f943fdf1ce5fc817a9f1cc4da17eaa4e1e9d43c7'),
(12, 'e122fac568c0ffc9a06f5b22c1ef26b71ed82addeac6ebd2b41094f7cd82566a'),
(13, 'a97fd457af9b8c29e2925ccaa1abd45bb0ef5ba722b0b41fcb4bc5fdbb062d7d'),
(14, '81f1c4b8f4bdbc00e962413319eb4f509adca227ee7d1070091928bb9672486e'),
(15, 'b51d738ea001617fbf56eda34ff4a3b04237f4f5cb18e40ca40020d462810685'),
(16, '4375db1191189fba9d764c43cc4b055ec501c797c139430ea242d4f97ac08677'),
(17, '04c31c6de4e5ded47fb7fdad66764c37c315e46a1f046f63c60bae9e7394c72c'),
(18, '33404b30a203a68125cece6c3d2046154eb1d0cd91b976891160999894350ed6'),
(19, 'ddc5506ae398aae3e2465f51a34c5fd5a99b3a5ba0b33677ceebac29a8134f57'),
(20, '9b897a1652484740fe8ca706f5f55667255eb989e3773bacf9b397989c3fba1b'),
(21, 'b6a94643fe54eb05dbc5f493a344d026a5b8e889918d489276435b5f2c66c11f'),
(22, '37a15551aa43b23adef414286637657ddda68d07da48503babcb5f82a257399b'),
(23, 'e1ee49fc26e0e887edd553f2a837642198772d40e1326ac2645ce82933fe823f'),
(24, '07aa8b324efa79b20da405cd56106c8b2ebb8f8cabf6eed10f1281d43d54c622'),
(25, '9adb867da0bdd14924a509fbb8dac1a899c8f746e9a9eb80781b32ba24217fa4'),
(26, '90dc371436b80101fa7be633d45406f6897317aba9f53667c017b21eda241f24'),
(27, '00b999d0ade5ecda5f9a3e898c94d8c8572b2d3e0b3e4d656daaff0006aaef1a');
-- -----------------------------------
-- Dumping table b_conv_context_attribute
-- -----------------------------------
DROP TABLE IF EXISTS `b_conv_context_attribute`;
CREATE TABLE `b_conv_context_attribute` (
  `CONTEXT_ID` int unsigned NOT NULL,
  `NAME` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `VALUE` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`CONTEXT_ID`,`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_conv_context_attribute` VALUES
(1, 'conversion_browser', 'firefox'),
(1, 'conversion_device_desktop', ''),
(1, 'conversion_operating_system', 'windows'),
(1, 'conversion_site', 's1'),
(2, 'conversion_browser', 'chrome'),
(2, 'conversion_device_desktop', ''),
(2, 'conversion_operating_system', 'windows'),
(2, 'conversion_site', 's1'),
(3, 'conversion_browser', 'safari'),
(3, 'conversion_device_mobile', ''),
(3, 'conversion_operating_system', 'macos'),
(3, 'conversion_site', 's1'),
(4, 'conversion_browser', 'chrome'),
(4, 'conversion_device_desktop', ''),
(4, 'conversion_operating_system', 'macos'),
(4, 'conversion_site', 's1'),
(5, 'conversion_browser', 'chrome'),
(5, 'conversion_device_desktop', ''),
(5, 'conversion_site', 's1'),
(6, 'conversion_browser', 'firefox'),
(6, 'conversion_device_desktop', ''),
(6, 'conversion_operating_system', 'linux'),
(6, 'conversion_site', 's1'),
(7, 'conversion_browser', 'chrome'),
(7, 'conversion_device_desktop', ''),
(7, 'conversion_operating_system', 'linux'),
(7, 'conversion_site', 's1'),
(8, 'conversion_browser', 'chrome'),
(8, 'conversion_device_desktop', ''),
(8, 'conversion_operating_system', 'windows'),
(8, 'conversion_search_engine', 'yandex'),
(8, 'conversion_site', 's1'),
(9, 'conversion_browser', 'chrome'),
(9, 'conversion_device_mobile', ''),
(9, 'conversion_operating_system', 'android'),
(9, 'conversion_search_engine', 'yandex'),
(9, 'conversion_site', 's1'),
(10, 'conversion_browser', 'safari'),
(10, 'conversion_device_mobile', ''),
(10, 'conversion_operating_system', 'macos'),
(10, 'conversion_search_engine', 'yandex'),
(10, 'conversion_site', 's1'),
(11, 'conversion_browser', 'chrome'),
(11, 'conversion_device_mobile', ''),
(11, 'conversion_operating_system', 'android'),
(11, 'conversion_site', 's1'),
(12, 'conversion_site', 's1'),
(13, 'conversion_browser', 'firefox'),
(13, 'conversion_device_desktop', ''),
(13, 'conversion_operating_system', 'windows'),
(13, 'conversion_search_engine', 'yandex'),
(13, 'conversion_site', 's1'),
(14, 'conversion_browser', 'chrome'),
(14, 'conversion_device_desktop', ''),
(14, 'conversion_operating_system', 'linux'),
(14, 'conversion_search_engine', 'yandex'),
(14, 'conversion_site', 's1'),
(15, 'conversion_browser', 'safari'),
(15, 'conversion_device_desktop', ''),
(15, 'conversion_operating_system', 'macos'),
(15, 'conversion_site', 's1'),
(16, 'conversion_browser', 'firefox'),
(16, 'conversion_device_desktop', ''),
(16, 'conversion_operating_system', 'linux'),
(16, 'conversion_search_engine', 'yandex'),
(16, 'conversion_site', 's1'),
(17, 'conversion_browser', 'chrome'),
(17, 'conversion_device_mobile', ''),
(17, 'conversion_operating_system', 'linux'),
(17, 'conversion_search_engine', 'yandex'),
(17, 'conversion_site', 's1'),
(18, 'conversion_browser', 'chrome'),
(18, 'conversion_device_mobile', ''),
(18, 'conversion_operating_system', 'android'),
(18, 'conversion_search_engine', 'google'),
(18, 'conversion_site', 's1'),
(19, 'conversion_browser', 'chrome'),
(19, 'conversion_device_desktop', ''),
(19, 'conversion_operating_system', 'windows'),
(19, 'conversion_search_engine', 'google'),
(19, 'conversion_site', 's1'),
(20, 'conversion_browser', 'safari'),
(20, 'conversion_device_desktop', ''),
(20, 'conversion_operating_system', 'macos'),
(20, 'conversion_search_engine', 'yandex'),
(20, 'conversion_site', 's1'),
(21, 'conversion_browser', 'chrome'),
(21, 'conversion_device_mobile', ''),
(21, 'conversion_operating_system', 'linux'),
(21, 'conversion_site', 's1'),
(22, 'conversion_browser', 'chrome'),
(22, 'conversion_device_desktop', ''),
(22, 'conversion_operating_system', 'macos'),
(22, 'conversion_search_engine', 'yandex'),
(22, 'conversion_site', 's1'),
(23, 'conversion_browser', 'mobile'),
(23, 'conversion_device_mobile', ''),
(23, 'conversion_operating_system', 'macos'),
(23, 'conversion_site', 's1'),
(24, 'conversion_browser', 'firefox'),
(24, 'conversion_device_mobile', ''),
(24, 'conversion_operating_system', 'android'),
(24, 'conversion_site', 's1'),
(25, 'conversion_browser', 'safari'),
(25, 'conversion_device_tablet', ''),
(25, 'conversion_operating_system', 'macos'),
(25, 'conversion_search_engine', 'yandex'),
(25, 'conversion_site', 's1'),
(26, 'conversion_browser', 'safari'),
(26, 'conversion_device_mobile', ''),
(26, 'conversion_operating_system', 'macos'),
(26, 'conversion_search_engine', 'google'),
(26, 'conversion_site', 's1'),
(27, 'conversion_browser', 'firefox'),
(27, 'conversion_device_desktop', ''),
(27, 'conversion_operating_system', 'linux'),
(27, 'conversion_search_engine', 'google'),
(27, 'conversion_site', 's1');
-- -----------------------------------
-- Dumping table b_conv_context_counter_day
-- -----------------------------------
DROP TABLE IF EXISTS `b_conv_context_counter_day`;
CREATE TABLE `b_conv_context_counter_day` (
  `DAY` date NOT NULL,
  `CONTEXT_ID` int unsigned NOT NULL,
  `NAME` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `VALUE` float NOT NULL,
  PRIMARY KEY (`DAY`,`CONTEXT_ID`,`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_conv_context_counter_day` VALUES
('2023-04-27', 1, 'conversion_visit_day', 1),
('2023-04-27', 2, 'conversion_visit_day', 1),
('2023-04-27', 3, 'conversion_visit_day', 1),
('2023-04-28', 2, 'conversion_visit_day', 1),
('2023-04-29', 4, 'conversion_visit_day', 1),
('2023-05-02', 2, 'conversion_visit_day', 1),
('2023-05-03', 2, 'conversion_visit_day', 1),
('2023-05-04', 2, 'conversion_visit_day', 1),
('2023-05-11', 2, 'conversion_visit_day', 1),
('2023-05-12', 2, 'conversion_visit_day', 1),
('2023-05-13', 3, 'conversion_visit_day', 1),
('2023-05-13', 5, 'conversion_visit_day', 47),
('2023-06-11', 2, 'conversion_visit_day', 1),
('2023-06-12', 2, 'conversion_visit_day', 1),
('2023-06-13', 2, 'conversion_visit_day', 1),
('2023-06-15', 2, 'conversion_visit_day', 1),
('2023-06-17', 2, 'conversion_visit_day', 1),
('2023-06-18', 2, 'conversion_visit_day', 1),
('2023-06-20', 2, 'conversion_visit_day', 1),
('2023-06-21', 2, 'conversion_visit_day', 1),
('2023-06-22', 2, 'conversion_visit_day', 1),
('2023-06-23', 2, 'conversion_visit_day', 1),
('2023-06-25', 1, 'conversion_visit_day', 1),
('2023-06-25', 2, 'conversion_visit_day', 1),
('2023-06-25', 6, 'conversion_visit_day', 2),
('2023-06-26', 2, 'conversion_visit_day', 1),
('2023-06-27', 2, 'conversion_visit_day', 1),
('2023-06-27', 5, 'conversion_visit_day', 1),
('2023-06-27', 7, 'conversion_visit_day', 1),
('2023-06-29', 2, 'conversion_visit_day', 2),
('2023-06-29', 5, 'conversion_visit_day', 139),
('2023-06-30', 2, 'conversion_visit_day', 1),
('2023-06-30', 8, 'conversion_visit_day', 2),
('2023-06-30', 9, 'conversion_visit_day', 1),
('2023-07-01', 2, 'conversion_visit_day', 1),
('2023-07-01', 5, 'conversion_visit_day', 101),
('2023-07-01', 10, 'conversion_visit_day', 1),
('2023-07-02', 2, 'conversion_visit_day', 1),
('2023-07-02', 10, 'conversion_visit_day', 1),
('2023-07-03', 2, 'conversion_visit_day', 1),
('2023-07-03', 10, 'conversion_visit_day', 1),
('2023-07-04', 2, 'conversion_visit_day', 1),
('2023-07-05', 2, 'conversion_visit_day', 1),
('2023-07-06', 2, 'conversion_visit_day', 1),
('2023-07-07', 2, 'conversion_visit_day', 1),
('2023-07-08', 2, 'conversion_visit_day', 1),
('2023-07-09', 2, 'conversion_visit_day', 1),
('2023-07-10', 2, 'conversion_visit_day', 1),
('2023-07-11', 2, 'conversion_visit_day', 1),
('2023-07-12', 2, 'conversion_visit_day', 1),
('2023-07-13', 2, 'conversion_visit_day', 1),
('2023-07-13', 4, 'conversion_visit_day', 1),
('2023-07-16', 7, 'conversion_visit_day', 2),
('2023-07-19', 4, 'conversion_visit_day', 1),
('2023-08-03', 4, 'conversion_visit_day', 1),
('2023-08-06', 4, 'conversion_visit_day', 1),
('2023-08-13', 2, 'conversion_visit_day', 1),
('2023-08-16', 2, 'conversion_visit_day', 1),
('2023-08-17', 2, 'conversion_visit_day', 1),
('2023-08-18', 2, 'conversion_visit_day', 2),
('2023-08-23', 2, 'conversion_visit_day', 1),
('2023-08-24', 2, 'conversion_visit_day', 2),
('2023-08-28', 2, 'conversion_visit_day', 6),
('2023-08-28', 3, 'conversion_visit_day', 1),
('2023-08-28', 6, 'conversion_visit_day', 6),
('2023-08-28', 7, 'conversion_visit_day', 1),
('2023-08-28', 11, 'conversion_visit_day', 1),
('2023-08-29', 7, 'conversion_visit_day', 1),
('2023-08-31', 2, 'conversion_visit_day', 1),
('2023-09-04', 2, 'conversion_visit_day', 2),
('2023-09-04', 11, 'conversion_visit_day', 1),
('2023-09-05', 2, 'conversion_visit_day', 1),
('2023-09-05', 3, 'conversion_visit_day', 1),
('2023-09-05', 5, 'conversion_visit_day', 491),
('2023-09-05', 11, 'conversion_visit_day', 1),
('2023-09-06', 2, 'conversion_visit_day', 3),
('2023-09-06', 3, 'conversion_visit_day', 1),
('2023-09-06', 5, 'conversion_visit_day', 83),
('2023-09-06', 11, 'conversion_visit_day', 1),
('2023-09-06', 12, 'conversion_visit_day', 1),
('2023-09-08', 5, 'conversion_visit_day', 2),
('2023-09-08', 8, 'conversion_visit_day', 1),
('2023-09-09', 2, 'conversion_visit_day', 1),
('2023-09-09', 7, 'conversion_visit_day', 2),
('2023-09-10', 5, 'conversion_visit_day', 57),
('2023-09-11', 2, 'conversion_visit_day', 1),
('2023-09-11', 5, 'conversion_visit_day', 125),
('2023-09-11', 8, 'conversion_visit_day', 1),
('2023-09-12', 5, 'conversion_visit_day', 13),
('2023-09-12', 8, 'conversion_visit_day', 2),
('2023-09-14', 5, 'conversion_visit_day', 2),
('2023-09-14', 8, 'conversion_visit_day', 5),
('2023-09-15', 8, 'conversion_visit_day', 2),
('2023-09-17', 5, 'conversion_visit_day', 1),
('2023-09-17', 8, 'conversion_visit_day', 2),
('2023-09-17', 11, 'conversion_visit_day', 1),
('2023-09-18', 5, 'conversion_visit_day', 1),
('2023-09-18', 7, 'conversion_visit_day', 2),
('2023-09-18', 8, 'conversion_visit_day', 3),
('2023-09-19', 5, 'conversion_visit_day', 1),
('2023-09-19', 8, 'conversion_visit_day', 1),
('2023-09-20', 2, 'conversion_visit_day', 1),
('2023-09-20', 5, 'conversion_visit_day', 1),
('2023-09-20', 8, 'conversion_visit_day', 1),
('2023-09-21', 5, 'conversion_visit_day', 6),
('2023-09-22', 5, 'conversion_visit_day', 2),
('2023-09-24', 8, 'conversion_visit_day', 1),
('2023-09-25', 5, 'conversion_visit_day', 1),
('2023-09-25', 8, 'conversion_visit_day', 1),
('2023-09-26', 5, 'conversion_visit_day', 1),
('2023-09-26', 8, 'conversion_visit_day', 1),
('2023-09-27', 5, 'conversion_visit_day', 2),
('2023-09-28', 3, 'conversion_visit_day', 1),
('2023-09-29', 2, 'conversion_visit_day', 1),
('2023-09-29', 3, 'conversion_visit_day', 1),
('2023-09-29', 8, 'conversion_visit_day', 1),
('2023-09-30', 8, 'conversion_visit_day', 2),
('2023-10-01', 5, 'conversion_visit_day', 3),
('2023-10-01', 8, 'conversion_visit_day', 1),
('2023-10-01', 13, 'conversion_visit_day', 1),
('2023-10-02', 2, 'conversion_visit_day', 1),
('2023-10-02', 3, 'conversion_visit_day', 1),
('2023-10-02', 5, 'conversion_visit_day', 6),
('2023-10-02', 8, 'conversion_visit_day', 3),
('2023-10-03', 2, 'conversion_visit_day', 2),
('2023-10-03', 5, 'conversion_visit_day', 11),
('2023-10-03', 8, 'conversion_visit_day', 2),
('2023-10-04', 5, 'conversion_visit_day', 29),
('2023-10-04', 8, 'conversion_visit_day', 3),
('2023-10-05', 5, 'conversion_visit_day', 1),
('2023-10-05', 8, 'conversion_visit_day', 5),
('2023-10-06', 2, 'conversion_visit_day', 1),
('2023-10-06', 8, 'conversion_visit_day', 3),
('2023-10-07', 5, 'conversion_visit_day', 1),
('2023-10-07', 7, 'conversion_visit_day', 1),
('2023-10-07', 8, 'conversion_visit_day', 3),
('2023-10-08', 5, 'conversion_visit_day', 1),
('2023-10-08', 8, 'conversion_visit_day', 2),
('2023-10-09', 8, 'conversion_visit_day', 1),
('2023-10-10', 5, 'conversion_visit_day', 2),
('2023-10-10', 8, 'conversion_visit_day', 7),
('2023-10-11', 7, 'conversion_visit_day', 1),
('2023-10-12', 8, 'conversion_visit_day', 3),
('2023-10-13', 5, 'conversion_visit_day', 2),
('2023-10-13', 8, 'conversion_visit_day', 2),
('2023-10-14', 5, 'conversion_visit_day', 1),
('2023-10-14', 8, 'conversion_visit_day', 2),
('2023-10-15', 5, 'conversion_visit_day', 4),
('2023-10-15', 8, 'conversion_visit_day', 2),
('2023-10-16', 8, 'conversion_visit_day', 2),
('2023-10-16', 9, 'conversion_visit_day', 1),
('2023-10-17', 5, 'conversion_visit_day', 1),
('2023-10-17', 8, 'conversion_visit_day', 3),
('2023-10-17', 13, 'conversion_visit_day', 1),
('2023-10-18', 5, 'conversion_visit_day', 2),
('2023-10-18', 8, 'conversion_visit_day', 2),
('2023-10-19', 2, 'conversion_visit_day', 1),
('2023-10-19', 5, 'conversion_visit_day', 2),
('2023-10-20', 8, 'conversion_visit_day', 7),
('2023-10-21', 5, 'conversion_visit_day', 1),
('2023-10-22', 8, 'conversion_visit_day', 2),
('2023-10-23', 8, 'conversion_visit_day', 2),
('2023-10-24', 8, 'conversion_visit_day', 1),
('2023-10-24', 13, 'conversion_visit_day', 1),
('2023-10-25', 2, 'conversion_visit_day', 1),
('2023-10-25', 8, 'conversion_visit_day', 2),
('2023-10-26', 2, 'conversion_visit_day', 1),
('2023-10-26', 8, 'conversion_visit_day', 2),
('2023-10-26', 11, 'conversion_visit_day', 1),
('2023-10-27', 2, 'conversion_visit_day', 1),
('2023-10-27', 6, 'conversion_visit_day', 1),
('2023-10-28', 8, 'conversion_visit_day', 3),
('2023-10-29', 8, 'conversion_visit_day', 5),
('2023-10-30', 8, 'conversion_visit_day', 1),
('2023-10-31', 2, 'conversion_visit_day', 2),
('2023-10-31', 5, 'conversion_visit_day', 1),
('2023-10-31', 8, 'conversion_visit_day', 1),
('2023-10-31', 14, 'conversion_visit_day', 1),
('2023-11-01', 2, 'conversion_visit_day', 1),
('2023-11-01', 8, 'conversion_visit_day', 3),
('2023-11-01', 12, 'conversion_visit_day', 1),
('2023-11-01', 14, 'conversion_visit_day', 2),
('2023-11-02', 8, 'conversion_visit_day', 5),
('2023-11-02', 14, 'conversion_visit_day', 1),
('2023-11-03', 4, 'conversion_visit_day', 1),
('2023-11-04', 8, 'conversion_visit_day', 4),
('2023-11-05', 8, 'conversion_visit_day', 2),
('2023-11-06', 2, 'conversion_visit_day', 1),
('2023-11-06', 8, 'conversion_visit_day', 5),
('2023-11-07', 5, 'conversion_visit_day', 7),
('2023-11-07', 8, 'conversion_visit_day', 1),
('2023-11-07', 15, 'conversion_visit_day', 1),
('2023-11-08', 5, 'conversion_visit_day', 2),
('2023-11-08', 8, 'conversion_visit_day', 3),
('2023-11-08', 12, 'conversion_visit_day', 1),
('2023-11-09', 2, 'conversion_visit_day', 1),
('2023-11-09', 8, 'conversion_visit_day', 5),
('2023-11-10', 2, 'conversion_visit_day', 1),
('2023-11-10', 8, 'conversion_visit_day', 3),
('2023-11-10', 13, 'conversion_visit_day', 1),
('2023-11-11', 5, 'conversion_visit_day', 1),
('2023-11-11', 16, 'conversion_visit_day', 2),
('2023-11-12', 1, 'conversion_visit_day', 1),
('2023-11-12', 8, 'conversion_visit_day', 1),
('2023-11-13', 2, 'conversion_visit_day', 1),
('2023-11-13', 8, 'conversion_visit_day', 3),
('2023-11-13', 14, 'conversion_visit_day', 1),
('2023-11-14', 2, 'conversion_visit_day', 1),
('2023-11-14', 5, 'conversion_visit_day', 1),
('2023-11-14', 8, 'conversion_visit_day', 5),
('2023-11-15', 2, 'conversion_visit_day', 2),
('2023-11-15', 8, 'conversion_visit_day', 2),
('2023-11-15', 15, 'conversion_visit_day', 1),
('2023-11-15', 17, 'conversion_visit_day', 1),
('2023-11-16', 2, 'conversion_visit_day', 2),
('2023-11-16', 8, 'conversion_visit_day', 1),
('2023-11-16', 14, 'conversion_visit_day', 1),
('2023-11-17', 2, 'conversion_visit_day', 1),
('2023-11-17', 8, 'conversion_visit_day', 4),
('2023-11-18', 8, 'conversion_visit_day', 1),
('2023-11-18', 14, 'conversion_visit_day', 2),
('2023-11-18', 16, 'conversion_visit_day', 1),
('2023-11-19', 8, 'conversion_visit_day', 2),
('2023-11-19', 14, 'conversion_visit_day', 1),
('2023-11-20', 8, 'conversion_visit_day', 3),
('2023-11-20', 12, 'conversion_visit_day', 1),
('2023-11-21', 2, 'conversion_visit_day', 1),
('2023-11-21', 8, 'conversion_visit_day', 1),
('2023-11-21', 14, 'conversion_visit_day', 1),
('2023-11-21', 17, 'conversion_visit_day', 1),
('2023-11-22', 2, 'conversion_visit_day', 1),
('2023-11-22', 8, 'conversion_visit_day', 6),
('2023-11-22', 14, 'conversion_visit_day', 2),
('2023-11-23', 8, 'conversion_visit_day', 2),
('2023-11-24', 8, 'conversion_visit_day', 3),
('2023-11-24', 14, 'conversion_visit_day', 1),
('2023-11-25', 2, 'conversion_visit_day', 2),
('2023-11-25', 4, 'conversion_visit_day', 1),
('2023-11-25', 8, 'conversion_visit_day', 2),
('2023-11-25', 14, 'conversion_visit_day', 1),
('2023-11-26', 2, 'conversion_visit_day', 2),
('2023-11-26', 7, 'conversion_visit_day', 1),
('2023-11-26', 8, 'conversion_visit_day', 5),
('2023-11-26', 9, 'conversion_visit_day', 1),
('2023-11-26', 14, 'conversion_visit_day', 1),
('2023-11-27', 8, 'conversion_visit_day', 2),
('2023-11-27', 9, 'conversion_visit_day', 1),
('2023-11-27', 18, 'conversion_visit_day', 1),
('2023-11-29', 4, 'conversion_visit_day', 1),
('2023-11-29', 8, 'conversion_visit_day', 6),
('2023-11-29', 14, 'conversion_visit_day', 1),
('2023-11-29', 15, 'conversion_visit_day', 1),
('2023-11-29', 19, 'conversion_visit_day', 1),
('2023-11-30', 8, 'conversion_visit_day', 3),
('2023-11-30', 14, 'conversion_visit_day', 1),
('2023-12-01', 8, 'conversion_visit_day', 2),
('2023-12-01', 12, 'conversion_visit_day', 1),
('2023-12-01', 13, 'conversion_visit_day', 1),
('2023-12-01', 14, 'conversion_visit_day', 2),
('2023-12-02', 8, 'conversion_visit_day', 3),
('2023-12-02', 15, 'conversion_visit_day', 2),
('2023-12-03', 3, 'conversion_visit_day', 1),
('2023-12-04', 2, 'conversion_visit_day', 1),
('2023-12-05', 2, 'conversion_visit_day', 1),
('2023-12-05', 8, 'conversion_visit_day', 4),
('2023-12-05', 14, 'conversion_visit_day', 1),
('2023-12-06', 8, 'conversion_visit_day', 2),
('2023-12-06', 15, 'conversion_visit_day', 1),
('2023-12-07', 2, 'conversion_visit_day', 1),
('2023-12-07', 8, 'conversion_visit_day', 3),
('2023-12-08', 8, 'conversion_visit_day', 3),
('2023-12-08', 14, 'conversion_visit_day', 1),
('2023-12-09', 4, 'conversion_visit_day', 1),
('2023-12-09', 8, 'conversion_visit_day', 2),
('2023-12-09', 12, 'conversion_visit_day', 1),
('2023-12-10', 2, 'conversion_visit_day', 1),
('2023-12-10', 8, 'conversion_visit_day', 3),
('2023-12-10', 10, 'conversion_visit_day', 1),
('2023-12-11', 2, 'conversion_visit_day', 1),
('2023-12-12', 2, 'conversion_visit_day', 1),
('2023-12-12', 8, 'conversion_visit_day', 6),
('2023-12-13', 5, 'conversion_visit_day', 1),
('2023-12-13', 8, 'conversion_visit_day', 1),
('2023-12-14', 2, 'conversion_visit_day', 1),
('2023-12-14', 5, 'conversion_visit_day', 1),
('2023-12-14', 8, 'conversion_visit_day', 6),
('2023-12-15', 2, 'conversion_visit_day', 1),
('2023-12-15', 5, 'conversion_visit_day', 3),
('2023-12-15', 8, 'conversion_visit_day', 1),
('2023-12-15', 14, 'conversion_visit_day', 1),
('2023-12-16', 4, 'conversion_visit_day', 1),
('2023-12-16', 5, 'conversion_visit_day', 3),
('2023-12-16', 8, 'conversion_visit_day', 2),
('2023-12-16', 14, 'conversion_visit_day', 1),
('2023-12-17', 8, 'conversion_visit_day', 2),
('2023-12-18', 2, 'conversion_visit_day', 1),
('2023-12-18', 3, 'conversion_visit_day', 1),
('2023-12-18', 5, 'conversion_visit_day', 5),
('2023-12-18', 7, 'conversion_visit_day', 1),
('2023-12-18', 8, 'conversion_visit_day', 2),
('2023-12-18', 13, 'conversion_visit_day', 1),
('2023-12-19', 2, 'conversion_visit_day', 2),
('2023-12-19', 8, 'conversion_visit_day', 1),
('2023-12-19', 13, 'conversion_visit_day', 1),
('2023-12-20', 2, 'conversion_visit_day', 1),
('2023-12-20', 5, 'conversion_visit_day', 8),
('2023-12-20', 8, 'conversion_visit_day', 2),
('2023-12-21', 2, 'conversion_visit_day', 4),
('2023-12-21', 5, 'conversion_visit_day', 19),
('2023-12-21', 7, 'conversion_visit_day', 1),
('2023-12-21', 8, 'conversion_visit_day', 1),
('2023-12-22', 2, 'conversion_visit_day', 2),
('2023-12-22', 5, 'conversion_visit_day', 1),
('2023-12-22', 8, 'conversion_visit_day', 9),
('2023-12-22', 14, 'conversion_visit_day', 1),
('2023-12-23', 3, 'conversion_visit_day', 1),
('2023-12-23', 8, 'conversion_visit_day', 1),
('2023-12-23', 14, 'conversion_visit_day', 1),
('2023-12-24', 2, 'conversion_visit_day', 1),
('2023-12-24', 8, 'conversion_visit_day', 2),
('2023-12-24', 10, 'conversion_visit_day', 1),
('2023-12-24', 16, 'conversion_visit_day', 2),
('2023-12-25', 2, 'conversion_visit_day', 1),
('2023-12-25', 8, 'conversion_visit_day', 2),
('2023-12-25', 10, 'conversion_visit_day', 1),
('2023-12-25', 20, 'conversion_visit_day', 1),
('2023-12-26', 2, 'conversion_visit_day', 2),
('2023-12-26', 3, 'conversion_visit_day', 1),
('2023-12-26', 8, 'conversion_visit_day', 2),
('2023-12-27', 8, 'conversion_visit_day', 3),
('2023-12-27', 16, 'conversion_visit_day', 1),
('2023-12-28', 2, 'conversion_visit_day', 1),
('2023-12-28', 8, 'conversion_visit_day', 3),
('2023-12-29', 8, 'conversion_visit_day', 3),
('2023-12-30', 8, 'conversion_visit_day', 4),
('2023-12-31', 8, 'conversion_visit_day', 1),
('2023-12-31', 14, 'conversion_visit_day', 2),
('2024-01-01', 12, 'conversion_visit_day', 1),
('2024-01-01', 14, 'conversion_visit_day', 1),
('2024-01-02', 8, 'conversion_visit_day', 4),
('2024-01-03', 2, 'conversion_visit_day', 1),
('2024-01-03', 8, 'conversion_visit_day', 3),
('2024-01-04', 8, 'conversion_visit_day', 1),
('2024-01-04', 10, 'conversion_visit_day', 1),
('2024-01-05', 8, 'conversion_visit_day', 1),
('2024-01-06', 2, 'conversion_visit_day', 1),
('2024-01-06', 8, 'conversion_visit_day', 3),
('2024-01-07', 8, 'conversion_visit_day', 1),
('2024-01-08', 2, 'conversion_visit_day', 1),
('2024-01-08', 9, 'conversion_visit_day', 2),
('2024-01-09', 8, 'conversion_visit_day', 3),
('2024-01-09', 9, 'conversion_visit_day', 1),
('2024-01-09', 15, 'conversion_visit_day', 1),
('2024-01-10', 2, 'conversion_visit_day', 1),
('2024-01-10', 5, 'conversion_visit_day', 1),
('2024-01-10', 8, 'conversion_visit_day', 2),
('2024-01-11', 8, 'conversion_visit_day', 1),
('2024-01-11', 12, 'conversion_visit_day', 1),
('2024-01-12', 2, 'conversion_visit_day', 1),
('2024-01-12', 8, 'conversion_visit_day', 1),
('2024-01-12', 9, 'conversion_visit_day', 1),
('2024-01-12', 10, 'conversion_visit_day', 1),
('2024-01-13', 2, 'conversion_visit_day', 1),
('2024-01-13', 5, 'conversion_visit_day', 1),
('2024-01-14', 2, 'conversion_visit_day', 1),
('2024-01-14', 5, 'conversion_visit_day', 1),
('2024-01-15', 2, 'conversion_visit_day', 2),
('2024-01-16', 2, 'conversion_visit_day', 1),
('2024-01-17', 1, 'conversion_visit_day', 1),
('2024-01-17', 2, 'conversion_visit_day', 2),
('2024-01-17', 8, 'conversion_visit_day', 1),
('2024-01-17', 11, 'conversion_visit_day', 2),
('2024-01-18', 2, 'conversion_visit_day', 2),
('2024-01-18', 8, 'conversion_visit_day', 1),
('2024-01-18', 9, 'conversion_visit_day', 1),
('2024-01-18', 12, 'conversion_visit_day', 1),
('2024-01-19', 8, 'conversion_visit_day', 1),
('2024-01-21', 9, 'conversion_visit_day', 1),
('2024-01-21', 10, 'conversion_visit_day', 1),
('2024-01-22', 2, 'conversion_visit_day', 1),
('2024-01-22', 9, 'conversion_visit_day', 1),
('2024-01-22', 10, 'conversion_visit_day', 1),
('2024-01-22', 13, 'conversion_visit_day', 1),
('2024-01-23', 2, 'conversion_visit_day', 2),
('2024-01-24', 2, 'conversion_visit_day', 1),
('2024-01-24', 9, 'conversion_visit_day', 1),
('2024-01-25', 2, 'conversion_visit_day', 1),
('2024-01-25', 8, 'conversion_visit_day', 1),
('2024-01-26', 2, 'conversion_visit_day', 2),
('2024-01-26', 8, 'conversion_visit_day', 1),
('2024-01-27', 2, 'conversion_visit_day', 2),
('2024-01-27', 4, 'conversion_visit_day', 1),
('2024-01-28', 9, 'conversion_visit_day', 1),
('2024-01-28', 10, 'conversion_visit_day', 1),
('2024-01-29', 3, 'conversion_visit_day', 1),
('2024-01-30', 2, 'conversion_visit_day', 1),
('2024-01-30', 5, 'conversion_visit_day', 1),
('2024-01-30', 7, 'conversion_visit_day', 1),
('2024-01-31', 2, 'conversion_visit_day', 1),
('2024-01-31', 12, 'conversion_visit_day', 1),
('2024-01-31', 13, 'conversion_visit_day', 1),
('2024-02-01', 8, 'conversion_visit_day', 3),
('2024-02-02', 2, 'conversion_visit_day', 1),
('2024-02-02', 5, 'conversion_visit_day', 17),
('2024-02-03', 5, 'conversion_visit_day', 12),
('2024-02-04', 5, 'conversion_visit_day', 10),
('2024-02-04', 9, 'conversion_visit_day', 1),
('2024-02-05', 2, 'conversion_visit_day', 1),
('2024-02-05', 5, 'conversion_visit_day', 2),
('2024-02-06', 2, 'conversion_visit_day', 2),
('2024-02-06', 5, 'conversion_visit_day', 7),
('2024-02-07', 2, 'conversion_visit_day', 1),
('2024-02-07', 5, 'conversion_visit_day', 6),
('2024-02-07', 11, 'conversion_visit_day', 1),
('2024-02-08', 2, 'conversion_visit_day', 1),
('2024-02-08', 5, 'conversion_visit_day', 16),
('2024-02-09', 3, 'conversion_visit_day', 1),
('2024-02-09', 5, 'conversion_visit_day', 1),
('2024-02-09', 8, 'conversion_visit_day', 1),
('2024-02-09', 9, 'conversion_visit_day', 1),
('2024-02-09', 10, 'conversion_visit_day', 1),
('2024-02-09', 12, 'conversion_visit_day', 1),
('2024-02-09', 21, 'conversion_visit_day', 1),
('2024-02-11', 8, 'conversion_visit_day', 1),
('2024-02-11', 9, 'conversion_visit_day', 1),
('2024-02-12', 2, 'conversion_visit_day', 2),
('2024-02-12', 5, 'conversion_visit_day', 2),
('2024-02-12', 8, 'conversion_visit_day', 1),
('2024-02-12', 12, 'conversion_visit_day', 1),
('2024-02-13', 2, 'conversion_visit_day', 1),
('2024-02-13', 9, 'conversion_visit_day', 1),
('2024-02-15', 2, 'conversion_visit_day', 1),
('2024-02-15', 8, 'conversion_visit_day', 2),
('2024-02-15', 9, 'conversion_visit_day', 1),
('2024-02-15', 12, 'conversion_visit_day', 1),
('2024-02-17', 7, 'conversion_visit_day', 1),
('2024-02-18', 5, 'conversion_visit_day', 1),
('2024-02-18', 9, 'conversion_visit_day', 1),
('2024-02-19', 2, 'conversion_visit_day', 1),
('2024-02-19', 3, 'conversion_visit_day', 1),
('2024-02-20', 2, 'conversion_visit_day', 1),
('2024-02-21', 5, 'conversion_visit_day', 2),
('2024-02-21', 8, 'conversion_visit_day', 1),
('2024-02-21', 11, 'conversion_visit_day', 1),
('2024-02-22', 2, 'conversion_visit_day', 1),
('2024-02-22', 9, 'conversion_visit_day', 1),
('2024-02-22', 10, 'conversion_visit_day', 1),
('2024-02-22', 11, 'conversion_visit_day', 1),
('2024-02-23', 10, 'conversion_visit_day', 1),
('2024-02-24', 8, 'conversion_visit_day', 1),
('2024-02-25', 2, 'conversion_visit_day', 1),
('2024-02-25', 3, 'conversion_visit_day', 1),
('2024-02-25', 9, 'conversion_visit_day', 1),
('2024-02-25', 10, 'conversion_visit_day', 1),
('2024-02-26', 7, 'conversion_visit_day', 1),
('2024-02-26', 8, 'conversion_visit_day', 1),
('2024-02-27', 2, 'conversion_visit_day', 1),
('2024-02-27', 5, 'conversion_visit_day', 1),
('2024-02-27', 9, 'conversion_visit_day', 1),
('2024-02-27', 10, 'conversion_visit_day', 1),
('2024-02-28', 2, 'conversion_visit_day', 1),
('2024-02-28', 3, 'conversion_visit_day', 1),
('2024-02-28', 8, 'conversion_visit_day', 1),
('2024-02-28', 10, 'conversion_visit_day', 1),
('2024-02-28', 17, 'conversion_visit_day', 1),
('2024-02-29', 3, 'conversion_visit_day', 2),
('2024-02-29', 8, 'conversion_visit_day', 1),
('2024-02-29', 12, 'conversion_visit_day', 1),
('2024-03-01', 2, 'conversion_visit_day', 1),
('2024-03-01', 8, 'conversion_visit_day', 1),
('2024-03-01', 9, 'conversion_visit_day', 1),
('2024-03-01', 10, 'conversion_visit_day', 1),
('2024-03-01', 12, 'conversion_visit_day', 2),
('2024-03-02', 2, 'conversion_visit_day', 1),
('2024-03-02', 3, 'conversion_visit_day', 1),
('2024-03-02', 5, 'conversion_visit_day', 1),
('2024-03-02', 10, 'conversion_visit_day', 1),
('2024-03-03', 10, 'conversion_visit_day', 1),
('2024-03-04', 14, 'conversion_visit_day', 1),
('2024-03-05', 2, 'conversion_visit_day', 2),
('2024-03-05', 5, 'conversion_visit_day', 2),
('2024-03-06', 8, 'conversion_visit_day', 1),
('2024-03-06', 9, 'conversion_visit_day', 1),
('2024-03-06', 12, 'conversion_visit_day', 1),
('2024-03-07', 3, 'conversion_visit_day', 2),
('2024-03-08', 5, 'conversion_visit_day', 1),
('2024-03-08', 8, 'conversion_visit_day', 1),
('2024-03-08', 9, 'conversion_visit_day', 1),
('2024-03-09', 5, 'conversion_visit_day', 1),
('2024-03-09', 9, 'conversion_visit_day', 1),
('2024-03-10', 5, 'conversion_visit_day', 1),
('2024-03-10', 9, 'conversion_visit_day', 1),
('2024-03-11', 2, 'conversion_visit_day', 1),
('2024-03-12', 5, 'conversion_visit_day', 1),
('2024-03-12', 9, 'conversion_visit_day', 1),
('2024-03-12', 13, 'conversion_visit_day', 1),
('2024-03-13', 8, 'conversion_visit_day', 1),
('2024-03-13', 9, 'conversion_visit_day', 1),
('2024-03-13', 12, 'conversion_visit_day', 1),
('2024-03-14', 5, 'conversion_visit_day', 7),
('2024-03-14', 8, 'conversion_visit_day', 1),
('2024-03-14', 9, 'conversion_visit_day', 1),
('2024-03-15', 8, 'conversion_visit_day', 1),
('2024-03-16', 5, 'conversion_visit_day', 13),
('2024-03-16', 12, 'conversion_visit_day', 1),
('2024-03-17', 5, 'conversion_visit_day', 3),
('2024-03-18', 2, 'conversion_visit_day', 1),
('2024-03-18', 5, 'conversion_visit_day', 2),
('2024-03-18', 13, 'conversion_visit_day', 1),
('2024-03-19', 2, 'conversion_visit_day', 1),
('2024-03-19', 8, 'conversion_visit_day', 1),
('2024-03-20', 5, 'conversion_visit_day', 9),
('2024-03-20', 10, 'conversion_visit_day', 1),
('2024-03-21', 9, 'conversion_visit_day', 1),
('2024-03-21', 12, 'conversion_visit_day', 1),
('2024-03-22', 2, 'conversion_visit_day', 1),
('2024-03-22', 5, 'conversion_visit_day', 19),
('2024-03-24', 5, 'conversion_visit_day', 1),
('2024-03-24', 10, 'conversion_visit_day', 2),
('2024-03-25', 8, 'conversion_visit_day', 1),
('2024-03-26', 9, 'conversion_visit_day', 1),
('2024-03-30', 12, 'conversion_visit_day', 1),
('2024-03-31', 8, 'conversion_visit_day', 4),
('2024-03-31', 14, 'conversion_visit_day', 1),
('2024-04-01', 2, 'conversion_visit_day', 1),
('2024-04-01', 8, 'conversion_visit_day', 5),
('2024-04-01', 15, 'conversion_visit_day', 1),
('2024-04-02', 2, 'conversion_visit_day', 1),
('2024-04-02', 8, 'conversion_visit_day', 3),
('2024-04-02', 10, 'conversion_visit_day', 1),
('2024-04-02', 11, 'conversion_visit_day', 1),
('2024-04-03', 2, 'conversion_visit_day', 1),
('2024-04-03', 8, 'conversion_visit_day', 1),
('2024-04-03', 9, 'conversion_visit_day', 1),
('2024-04-04', 2, 'conversion_visit_day', 1),
('2024-04-04', 8, 'conversion_visit_day', 4),
('2024-04-05', 2, 'conversion_visit_day', 1),
('2024-04-05', 8, 'conversion_visit_day', 3),
('2024-04-06', 2, 'conversion_visit_day', 1),
('2024-04-06', 3, 'conversion_visit_day', 1),
('2024-04-06', 5, 'conversion_visit_day', 2),
('2024-04-06', 8, 'conversion_visit_day', 3),
('2024-04-06', 14, 'conversion_visit_day', 1),
('2024-04-07', 3, 'conversion_visit_day', 1),
('2024-04-07', 5, 'conversion_visit_day', 1),
('2024-04-07', 8, 'conversion_visit_day', 5),
('2024-04-07', 14, 'conversion_visit_day', 1),
('2024-04-08', 3, 'conversion_visit_day', 1),
('2024-04-08', 5, 'conversion_visit_day', 2),
('2024-04-08', 8, 'conversion_visit_day', 4),
('2024-04-08', 9, 'conversion_visit_day', 1),
('2024-04-09', 5, 'conversion_visit_day', 1),
('2024-04-09', 8, 'conversion_visit_day', 4),
('2024-04-09', 9, 'conversion_visit_day', 1),
('2024-04-10', 8, 'conversion_visit_day', 3),
('2024-04-10', 14, 'conversion_visit_day', 1),
('2024-04-11', 8, 'conversion_visit_day', 2),
('2024-04-11', 9, 'conversion_visit_day', 1),
('2024-04-11', 14, 'conversion_visit_day', 1),
('2024-04-12', 2, 'conversion_visit_day', 2),
('2024-04-12', 7, 'conversion_visit_day', 1),
('2024-04-12', 8, 'conversion_visit_day', 2),
('2024-04-12', 11, 'conversion_visit_day', 1),
('2024-04-12', 12, 'conversion_visit_day', 1),
('2024-04-12', 13, 'conversion_visit_day', 1),
('2024-04-13', 14, 'conversion_visit_day', 1),
('2024-04-14', 5, 'conversion_visit_day', 14),
('2024-04-14', 8, 'conversion_visit_day', 4),
('2024-04-14', 9, 'conversion_visit_day', 1),
('2024-04-14', 11, 'conversion_visit_day', 1),
('2024-04-14', 14, 'conversion_visit_day', 1),
('2024-04-15', 2, 'conversion_visit_day', 2),
('2024-04-15', 5, 'conversion_visit_day', 1),
('2024-04-15', 8, 'conversion_visit_day', 4),
('2024-04-15', 11, 'conversion_visit_day', 1),
('2024-04-15', 19, 'conversion_visit_day', 1),
('2024-04-16', 2, 'conversion_visit_day', 1),
('2024-04-16', 8, 'conversion_visit_day', 1),
('2024-04-16', 11, 'conversion_visit_day', 2),
('2024-04-16', 17, 'conversion_visit_day', 1),
('2024-04-17', 2, 'conversion_visit_day', 3),
('2024-04-17', 8, 'conversion_visit_day', 4),
('2024-04-17', 9, 'conversion_visit_day', 1),
('2024-04-17', 10, 'conversion_visit_day', 1),
('2024-04-17', 11, 'conversion_visit_day', 1),
('2024-04-18', 8, 'conversion_visit_day', 4),
('2024-04-18', 14, 'conversion_visit_day', 2),
('2024-04-19', 8, 'conversion_visit_day', 3),
('2024-04-19', 9, 'conversion_visit_day', 1),
('2024-04-19', 11, 'conversion_visit_day', 1),
('2024-04-19', 14, 'conversion_visit_day', 1),
('2024-04-20', 2, 'conversion_visit_day', 2),
('2024-04-20', 8, 'conversion_visit_day', 3),
('2024-04-20', 11, 'conversion_visit_day', 1),
('2024-04-21', 3, 'conversion_visit_day', 2),
('2024-04-21', 8, 'conversion_visit_day', 1),
('2024-04-21', 11, 'conversion_visit_day', 1),
('2024-04-21', 14, 'conversion_visit_day', 1),
('2024-04-21', 17, 'conversion_visit_day', 1),
('2024-04-22', 2, 'conversion_visit_day', 1),
('2024-04-22', 4, 'conversion_visit_day', 1),
('2024-04-22', 8, 'conversion_visit_day', 5),
('2024-04-22', 9, 'conversion_visit_day', 1),
('2024-04-23', 2, 'conversion_visit_day', 2),
('2024-04-23', 8, 'conversion_visit_day', 6),
('2024-04-23', 9, 'conversion_visit_day', 1),
('2024-04-23', 11, 'conversion_visit_day', 2),
('2024-04-23', 14, 'conversion_visit_day', 1),
('2024-04-23', 17, 'conversion_visit_day', 1),
('2024-04-24', 2, 'conversion_visit_day', 1),
('2024-04-24', 3, 'conversion_visit_day', 3),
('2024-04-24', 4, 'conversion_visit_day', 1),
('2024-04-24', 8, 'conversion_visit_day', 4),
('2024-04-24', 9, 'conversion_visit_day', 3),
('2024-04-24', 10, 'conversion_visit_day', 1),
('2024-04-24', 18, 'conversion_visit_day', 1),
('2024-04-24', 19, 'conversion_visit_day', 1),
('2024-04-24', 20, 'conversion_visit_day', 1),
('2024-04-25', 3, 'conversion_visit_day', 2),
('2024-04-25', 5, 'conversion_visit_day', 2),
('2024-04-25', 8, 'conversion_visit_day', 5),
('2024-04-25', 9, 'conversion_visit_day', 1),
('2024-04-25', 10, 'conversion_visit_day', 1),
('2024-04-25', 11, 'conversion_visit_day', 1),
('2024-04-25', 12, 'conversion_visit_day', 1),
('2024-04-25', 14, 'conversion_visit_day', 3),
('2024-04-25', 18, 'conversion_visit_day', 1),
('2024-04-26', 2, 'conversion_visit_day', 3),
('2024-04-26', 8, 'conversion_visit_day', 5),
('2024-04-27', 2, 'conversion_visit_day', 1),
('2024-04-27', 5, 'conversion_visit_day', 1),
('2024-04-27', 8, 'conversion_visit_day', 4),
('2024-04-27', 11, 'conversion_visit_day', 5),
('2024-04-27', 12, 'conversion_visit_day', 1),
('2024-04-27', 14, 'conversion_visit_day', 1),
('2024-04-27', 15, 'conversion_visit_day', 1),
('2024-04-28', 3, 'conversion_visit_day', 2),
('2024-04-28', 5, 'conversion_visit_day', 11),
('2024-04-28', 8, 'conversion_visit_day', 3),
('2024-04-29', 3, 'conversion_visit_day', 7),
('2024-04-29', 5, 'conversion_visit_day', 9),
('2024-04-29', 8, 'conversion_visit_day', 3),
('2024-04-29', 9, 'conversion_visit_day', 2),
('2024-04-29', 10, 'conversion_visit_day', 2),
('2024-04-29', 14, 'conversion_visit_day', 2),
('2024-04-30', 3, 'conversion_visit_day', 1),
('2024-04-30', 5, 'conversion_visit_day', 3),
('2024-04-30', 9, 'conversion_visit_day', 1),
('2024-04-30', 11, 'conversion_visit_day', 1),
('2024-04-30', 12, 'conversion_visit_day', 1),
('2024-04-30', 14, 'conversion_visit_day', 1),
('2024-05-01', 3, 'conversion_visit_day', 1),
('2024-05-01', 5, 'conversion_visit_day', 1),
('2024-05-01', 8, 'conversion_visit_day', 5),
('2024-05-01', 9, 'conversion_visit_day', 1),
('2024-05-01', 10, 'conversion_visit_day', 2),
('2024-05-01', 11, 'conversion_visit_day', 1),
('2024-05-01', 12, 'conversion_visit_day', 1),
('2024-05-01', 14, 'conversion_visit_day', 1),
('2024-05-01', 18, 'conversion_visit_day', 1),
('2024-05-02', 2, 'conversion_visit_day', 1),
('2024-05-02', 3, 'conversion_visit_day', 1),
('2024-05-02', 5, 'conversion_visit_day', 2),
('2024-05-02', 8, 'conversion_visit_day', 5),
('2024-05-02', 14, 'conversion_visit_day', 1),
('2024-05-02', 19, 'conversion_visit_day', 2),
('2024-05-03', 2, 'conversion_visit_day', 3),
('2024-05-03', 3, 'conversion_visit_day', 1),
('2024-05-03', 5, 'conversion_visit_day', 2),
('2024-05-03', 8, 'conversion_visit_day', 2),
('2024-05-03', 9, 'conversion_visit_day', 1),
('2024-05-03', 11, 'conversion_visit_day', 2),
('2024-05-03', 14, 'conversion_visit_day', 4),
('2024-05-04', 2, 'conversion_visit_day', 1),
('2024-05-04', 3, 'conversion_visit_day', 3),
('2024-05-04', 5, 'conversion_visit_day', 1),
('2024-05-04', 8, 'conversion_visit_day', 6),
('2024-05-04', 9, 'conversion_visit_day', 1),
('2024-05-04', 11, 'conversion_visit_day', 4),
('2024-05-04', 18, 'conversion_visit_day', 1),
('2024-05-05', 3, 'conversion_visit_day', 2),
('2024-05-05', 5, 'conversion_visit_day', 4),
('2024-05-05', 8, 'conversion_visit_day', 5),
('2024-05-05', 9, 'conversion_visit_day', 1),
('2024-05-05', 10, 'conversion_visit_day', 2),
('2024-05-05', 13, 'conversion_visit_day', 1),
('2024-05-05', 20, 'conversion_visit_day', 1),
('2024-05-06', 2, 'conversion_visit_day', 2),
('2024-05-06', 5, 'conversion_visit_day', 1),
('2024-05-06', 8, 'conversion_visit_day', 8),
('2024-05-06', 9, 'conversion_visit_day', 1),
('2024-05-06', 14, 'conversion_visit_day', 1),
('2024-05-07', 2, 'conversion_visit_day', 3),
('2024-05-07', 5, 'conversion_visit_day', 7),
('2024-05-07', 7, 'conversion_visit_day', 1),
('2024-05-07', 8, 'conversion_visit_day', 5),
('2024-05-07', 9, 'conversion_visit_day', 1),
('2024-05-07', 10, 'conversion_visit_day', 1),
('2024-05-07', 11, 'conversion_visit_day', 5),
('2024-05-07', 14, 'conversion_visit_day', 1),
('2024-05-07', 18, 'conversion_visit_day', 1),
('2024-05-08', 2, 'conversion_visit_day', 1),
('2024-05-08', 5, 'conversion_visit_day', 1),
('2024-05-08', 7, 'conversion_visit_day', 1),
('2024-05-08', 8, 'conversion_visit_day', 3),
('2024-05-08', 11, 'conversion_visit_day', 2),
('2024-05-08', 14, 'conversion_visit_day', 1),
('2024-05-09', 3, 'conversion_visit_day', 2),
('2024-05-09', 5, 'conversion_visit_day', 1),
('2024-05-09', 8, 'conversion_visit_day', 2),
('2024-05-09', 11, 'conversion_visit_day', 1),
('2024-05-09', 12, 'conversion_visit_day', 1),
('2024-05-10', 3, 'conversion_visit_day', 1),
('2024-05-10', 5, 'conversion_visit_day', 1),
('2024-05-10', 8, 'conversion_visit_day', 2),
('2024-05-10', 11, 'conversion_visit_day', 4),
('2024-05-10', 19, 'conversion_visit_day', 4),
('2024-05-11', 5, 'conversion_visit_day', 2),
('2024-05-11', 8, 'conversion_visit_day', 2),
('2024-05-11', 9, 'conversion_visit_day', 2),
('2024-05-11', 11, 'conversion_visit_day', 2),
('2024-05-11', 14, 'conversion_visit_day', 1),
('2024-05-12', 2, 'conversion_visit_day', 1),
('2024-05-12', 3, 'conversion_visit_day', 1),
('2024-05-12', 5, 'conversion_visit_day', 2),
('2024-05-12', 8, 'conversion_visit_day', 1),
('2024-05-12', 9, 'conversion_visit_day', 2),
('2024-05-12', 10, 'conversion_visit_day', 1),
('2024-05-12', 11, 'conversion_visit_day', 3),
('2024-05-12', 18, 'conversion_visit_day', 1),
('2024-05-13', 2, 'conversion_visit_day', 1),
('2024-05-13', 5, 'conversion_visit_day', 2),
('2024-05-13', 8, 'conversion_visit_day', 4),
('2024-05-13', 11, 'conversion_visit_day', 1),
('2024-05-13', 14, 'conversion_visit_day', 1),
('2024-05-14', 5, 'conversion_visit_day', 1),
('2024-05-14', 8, 'conversion_visit_day', 1),
('2024-05-14', 14, 'conversion_visit_day', 1),
('2024-05-15', 5, 'conversion_visit_day', 5),
('2024-05-15', 8, 'conversion_visit_day', 5),
('2024-05-15', 9, 'conversion_visit_day', 1),
('2024-05-15', 10, 'conversion_visit_day', 1),
('2024-05-15', 11, 'conversion_visit_day', 3),
('2024-05-16', 5, 'conversion_visit_day', 7),
('2024-05-16', 7, 'conversion_visit_day', 1),
('2024-05-16', 8, 'conversion_visit_day', 1),
('2024-05-16', 10, 'conversion_visit_day', 1),
('2024-05-17', 2, 'conversion_visit_day', 2),
('2024-05-17', 5, 'conversion_visit_day', 1),
('2024-05-17', 9, 'conversion_visit_day', 4),
('2024-05-17', 12, 'conversion_visit_day', 1),
('2024-05-18', 2, 'conversion_visit_day', 1),
('2024-05-18', 3, 'conversion_visit_day', 4),
('2024-05-18', 5, 'conversion_visit_day', 1),
('2024-05-18', 10, 'conversion_visit_day', 2),
('2024-05-18', 11, 'conversion_visit_day', 2),
('2024-05-19', 2, 'conversion_visit_day', 1),
('2024-05-19', 3, 'conversion_visit_day', 6),
('2024-05-19', 5, 'conversion_visit_day', 1),
('2024-05-19', 8, 'conversion_visit_day', 1),
('2024-05-19', 11, 'conversion_visit_day', 3),
('2024-05-19', 15, 'conversion_visit_day', 1),
('2024-05-19', 17, 'conversion_visit_day', 1),
('2024-05-20', 2, 'conversion_visit_day', 2),
('2024-05-20', 3, 'conversion_visit_day', 3),
('2024-05-20', 5, 'conversion_visit_day', 2),
('2024-05-20', 8, 'conversion_visit_day', 2),
('2024-05-20', 9, 'conversion_visit_day', 4),
('2024-05-20', 11, 'conversion_visit_day', 1),
('2024-05-20', 14, 'conversion_visit_day', 1),
('2024-05-20', 19, 'conversion_visit_day', 1),
('2024-05-21', 2, 'conversion_visit_day', 2),
('2024-05-21', 3, 'conversion_visit_day', 2),
('2024-05-21', 5, 'conversion_visit_day', 7),
('2024-05-21', 8, 'conversion_visit_day', 5),
('2024-05-21', 11, 'conversion_visit_day', 2),
('2024-05-22', 2, 'conversion_visit_day', 2),
('2024-05-22', 3, 'conversion_visit_day', 2),
('2024-05-22', 5, 'conversion_visit_day', 2),
('2024-05-22', 8, 'conversion_visit_day', 3),
('2024-05-22', 9, 'conversion_visit_day', 1),
('2024-05-22', 10, 'conversion_visit_day', 4),
('2024-05-22', 11, 'conversion_visit_day', 2),
('2024-05-23', 2, 'conversion_visit_day', 2),
('2024-05-23', 3, 'conversion_visit_day', 2),
('2024-05-23', 5, 'conversion_visit_day', 1),
('2024-05-23', 8, 'conversion_visit_day', 7),
('2024-05-23', 10, 'conversion_visit_day', 1),
('2024-05-23', 11, 'conversion_visit_day', 1),
('2024-05-23', 12, 'conversion_visit_day', 1),
('2024-05-24', 2, 'conversion_visit_day', 1),
('2024-05-24', 3, 'conversion_visit_day', 2),
('2024-05-24', 5, 'conversion_visit_day', 2),
('2024-05-24', 8, 'conversion_visit_day', 3),
('2024-05-24', 9, 'conversion_visit_day', 3),
('2024-05-24', 10, 'conversion_visit_day', 1),
('2024-05-24', 11, 'conversion_visit_day', 2),
('2024-05-24', 16, 'conversion_visit_day', 1),
('2024-05-25', 1, 'conversion_visit_day', 1),
('2024-05-25', 3, 'conversion_visit_day', 1),
('2024-05-25', 5, 'conversion_visit_day', 1),
('2024-05-25', 8, 'conversion_visit_day', 4),
('2024-05-26', 2, 'conversion_visit_day', 1),
('2024-05-26', 3, 'conversion_visit_day', 2),
('2024-05-26', 5, 'conversion_visit_day', 1),
('2024-05-26', 8, 'conversion_visit_day', 5),
('2024-05-26', 9, 'conversion_visit_day', 3),
('2024-05-26', 10, 'conversion_visit_day', 1),
('2024-05-26', 11, 'conversion_visit_day', 2),
('2024-05-26', 14, 'conversion_visit_day', 1),
('2024-05-26', 18, 'conversion_visit_day', 2),
('2024-05-27', 2, 'conversion_visit_day', 1),
('2024-05-27', 5, 'conversion_visit_day', 3),
('2024-05-27', 7, 'conversion_visit_day', 1),
('2024-05-27', 8, 'conversion_visit_day', 6),
('2024-05-27', 9, 'conversion_visit_day', 1),
('2024-05-27', 11, 'conversion_visit_day', 1),
('2024-05-28', 2, 'conversion_visit_day', 2),
('2024-05-28', 3, 'conversion_visit_day', 2),
('2024-05-28', 5, 'conversion_visit_day', 2),
('2024-05-28', 7, 'conversion_visit_day', 1),
('2024-05-28', 8, 'conversion_visit_day', 5),
('2024-05-28', 9, 'conversion_visit_day', 1),
('2024-05-28', 11, 'conversion_visit_day', 4),
('2024-05-28', 13, 'conversion_visit_day', 1),
('2024-05-28', 14, 'conversion_visit_day', 3),
('2024-05-28', 17, 'conversion_visit_day', 1),
('2024-05-29', 2, 'conversion_visit_day', 2),
('2024-05-29', 5, 'conversion_visit_day', 1),
('2024-05-29', 8, 'conversion_visit_day', 6),
('2024-05-29', 11, 'conversion_visit_day', 2),
('2024-05-30', 2, 'conversion_visit_day', 4),
('2024-05-30', 3, 'conversion_visit_day', 6),
('2024-05-30', 5, 'conversion_visit_day', 3),
('2024-05-30', 8, 'conversion_visit_day', 4),
('2024-05-30', 12, 'conversion_visit_day', 2),
('2024-05-30', 14, 'conversion_visit_day', 1),
('2024-05-30', 19, 'conversion_visit_day', 1),
('2024-05-31', 2, 'conversion_visit_day', 2),
('2024-05-31', 3, 'conversion_visit_day', 4),
('2024-05-31', 5, 'conversion_visit_day', 2),
('2024-05-31', 8, 'conversion_visit_day', 9),
('2024-05-31', 9, 'conversion_visit_day', 2),
('2024-05-31', 10, 'conversion_visit_day', 1),
('2024-05-31', 11, 'conversion_visit_day', 2),
('2024-05-31', 19, 'conversion_visit_day', 1),
('2024-05-31', 22, 'conversion_visit_day', 1),
('2024-06-01', 3, 'conversion_visit_day', 1),
('2024-06-01', 5, 'conversion_visit_day', 2),
('2024-06-01', 8, 'conversion_visit_day', 3),
('2024-06-01', 9, 'conversion_visit_day', 1),
('2024-06-01', 10, 'conversion_visit_day', 1),
('2024-06-01', 11, 'conversion_visit_day', 3),
('2024-06-01', 14, 'conversion_visit_day', 1),
('2024-06-01', 18, 'conversion_visit_day', 2),
('2024-06-01', 22, 'conversion_visit_day', 1),
('2024-06-02', 3, 'conversion_visit_day', 3),
('2024-06-02', 5, 'conversion_visit_day', 1),
('2024-06-02', 7, 'conversion_visit_day', 1),
('2024-06-02', 8, 'conversion_visit_day', 2),
('2024-06-02', 9, 'conversion_visit_day', 2),
('2024-06-02', 10, 'conversion_visit_day', 1),
('2024-06-02', 11, 'conversion_visit_day', 1),
('2024-06-02', 14, 'conversion_visit_day', 1),
('2024-06-03', 2, 'conversion_visit_day', 3),
('2024-06-03', 3, 'conversion_visit_day', 5),
('2024-06-03', 5, 'conversion_visit_day', 2),
('2024-06-03', 8, 'conversion_visit_day', 3),
('2024-06-03', 9, 'conversion_visit_day', 1),
('2024-06-03', 10, 'conversion_visit_day', 3),
('2024-06-03', 11, 'conversion_visit_day', 3),
('2024-06-03', 12, 'conversion_visit_day', 1),
('2024-06-03', 14, 'conversion_visit_day', 3),
('2024-06-04', 2, 'conversion_visit_day', 2),
('2024-06-04', 3, 'conversion_visit_day', 1),
('2024-06-04', 5, 'conversion_visit_day', 5),
('2024-06-04', 8, 'conversion_visit_day', 4),
('2024-06-04', 9, 'conversion_visit_day', 1),
('2024-06-04', 10, 'conversion_visit_day', 2),
('2024-06-04', 11, 'conversion_visit_day', 2),
('2024-06-04', 14, 'conversion_visit_day', 2),
('2024-06-05', 2, 'conversion_visit_day', 3),
('2024-06-05', 3, 'conversion_visit_day', 1),
('2024-06-05', 5, 'conversion_visit_day', 4),
('2024-06-05', 8, 'conversion_visit_day', 5),
('2024-06-05', 9, 'conversion_visit_day', 4),
('2024-06-05', 11, 'conversion_visit_day', 4),
('2024-06-05', 12, 'conversion_visit_day', 1),
('2024-06-05', 16, 'conversion_visit_day', 2),
('2024-06-05', 19, 'conversion_visit_day', 1),
('2024-06-06', 2, 'conversion_visit_day', 3),
('2024-06-06', 3, 'conversion_visit_day', 3),
('2024-06-06', 5, 'conversion_visit_day', 2),
('2024-06-06', 8, 'conversion_visit_day', 6),
('2024-06-06', 9, 'conversion_visit_day', 1),
('2024-06-06', 10, 'conversion_visit_day', 2),
('2024-06-06', 11, 'conversion_visit_day', 1),
('2024-06-07', 2, 'conversion_visit_day', 1),
('2024-06-07', 3, 'conversion_visit_day', 2),
('2024-06-07', 5, 'conversion_visit_day', 1),
('2024-06-07', 8, 'conversion_visit_day', 5),
('2024-06-07', 9, 'conversion_visit_day', 2),
('2024-06-07', 10, 'conversion_visit_day', 3),
('2024-06-07', 11, 'conversion_visit_day', 1),
('2024-06-07', 14, 'conversion_visit_day', 1),
('2024-06-08', 3, 'conversion_visit_day', 4),
('2024-06-08', 5, 'conversion_visit_day', 1),
('2024-06-08', 8, 'conversion_visit_day', 4),
('2024-06-08', 10, 'conversion_visit_day', 1),
('2024-06-08', 11, 'conversion_visit_day', 1),
('2024-06-08', 14, 'conversion_visit_day', 1),
('2024-06-09', 3, 'conversion_visit_day', 9),
('2024-06-09', 5, 'conversion_visit_day', 1),
('2024-06-09', 8, 'conversion_visit_day', 1),
('2024-06-09', 10, 'conversion_visit_day', 3),
('2024-06-09', 11, 'conversion_visit_day', 8),
('2024-06-09', 14, 'conversion_visit_day', 1),
('2024-06-10', 2, 'conversion_visit_day', 1),
('2024-06-10', 3, 'conversion_visit_day', 2),
('2024-06-10', 5, 'conversion_visit_day', 12),
('2024-06-10', 8, 'conversion_visit_day', 5),
('2024-06-10', 10, 'conversion_visit_day', 1),
('2024-06-10', 11, 'conversion_visit_day', 6),
('2024-06-10', 12, 'conversion_visit_day', 1),
('2024-06-10', 14, 'conversion_visit_day', 1),
('2024-06-10', 18, 'conversion_visit_day', 1),
('2024-06-11', 2, 'conversion_visit_day', 1),
('2024-06-11', 3, 'conversion_visit_day', 4),
('2024-06-11', 5, 'conversion_visit_day', 6),
('2024-06-11', 8, 'conversion_visit_day', 7),
('2024-06-11', 10, 'conversion_visit_day', 2),
('2024-06-11', 11, 'conversion_visit_day', 6),
('2024-06-11', 13, 'conversion_visit_day', 1),
('2024-06-11', 20, 'conversion_visit_day', 1),
('2024-06-12', 3, 'conversion_visit_day', 2),
('2024-06-12', 5, 'conversion_visit_day', 4),
('2024-06-12', 8, 'conversion_visit_day', 7),
('2024-06-12', 9, 'conversion_visit_day', 1),
('2024-06-12', 12, 'conversion_visit_day', 1),
('2024-06-12', 20, 'conversion_visit_day', 1),
('2024-06-13', 2, 'conversion_visit_day', 1),
('2024-06-13', 3, 'conversion_visit_day', 7),
('2024-06-13', 5, 'conversion_visit_day', 3),
('2024-06-13', 8, 'conversion_visit_day', 4),
('2024-06-13', 9, 'conversion_visit_day', 1),
('2024-06-13', 11, 'conversion_visit_day', 4),
('2024-06-13', 14, 'conversion_visit_day', 3),
('2024-06-13', 18, 'conversion_visit_day', 1),
('2024-06-14', 2, 'conversion_visit_day', 4),
('2024-06-14', 3, 'conversion_visit_day', 2),
('2024-06-14', 5, 'conversion_visit_day', 1),
('2024-06-14', 8, 'conversion_visit_day', 3),
('2024-06-14', 9, 'conversion_visit_day', 1),
('2024-06-14', 10, 'conversion_visit_day', 1),
('2024-06-14', 11, 'conversion_visit_day', 3),
('2024-06-14', 13, 'conversion_visit_day', 1),
('2024-06-14', 14, 'conversion_visit_day', 1),
('2024-06-15', 2, 'conversion_visit_day', 3),
('2024-06-15', 3, 'conversion_visit_day', 4),
('2024-06-15', 5, 'conversion_visit_day', 7),
('2024-06-15', 8, 'conversion_visit_day', 3),
('2024-06-15', 9, 'conversion_visit_day', 1),
('2024-06-15', 10, 'conversion_visit_day', 1),
('2024-06-15', 11, 'conversion_visit_day', 2),
('2024-06-15', 13, 'conversion_visit_day', 1),
('2024-06-15', 15, 'conversion_visit_day', 1),
('2024-06-16', 2, 'conversion_visit_day', 1),
('2024-06-16', 3, 'conversion_visit_day', 3),
('2024-06-16', 5, 'conversion_visit_day', 12),
('2024-06-16', 7, 'conversion_visit_day', 1),
('2024-06-16', 8, 'conversion_visit_day', 6),
('2024-06-16', 9, 'conversion_visit_day', 1),
('2024-06-16', 10, 'conversion_visit_day', 3),
('2024-06-16', 11, 'conversion_visit_day', 6),
('2024-06-16', 14, 'conversion_visit_day', 2),
('2024-06-17', 3, 'conversion_visit_day', 4),
('2024-06-17', 5, 'conversion_visit_day', 6),
('2024-06-17', 8, 'conversion_visit_day', 6),
('2024-06-17', 11, 'conversion_visit_day', 3),
('2024-06-17', 14, 'conversion_visit_day', 1),
('2024-06-17', 19, 'conversion_visit_day', 1),
('2024-06-18', 2, 'conversion_visit_day', 5),
('2024-06-18', 3, 'conversion_visit_day', 4),
('2024-06-18', 5, 'conversion_visit_day', 13),
('2024-06-18', 8, 'conversion_visit_day', 6),
('2024-06-18', 9, 'conversion_visit_day', 3),
('2024-06-18', 10, 'conversion_visit_day', 2),
('2024-06-18', 11, 'conversion_visit_day', 7),
('2024-06-18', 14, 'conversion_visit_day', 1),
('2024-06-19', 2, 'conversion_visit_day', 3),
('2024-06-19', 3, 'conversion_visit_day', 6),
('2024-06-19', 5, 'conversion_visit_day', 10),
('2024-06-19', 8, 'conversion_visit_day', 1),
('2024-06-19', 10, 'conversion_visit_day', 1),
('2024-06-19', 11, 'conversion_visit_day', 5),
('2024-06-20', 2, 'conversion_visit_day', 1),
('2024-06-20', 3, 'conversion_visit_day', 3),
('2024-06-20', 5, 'conversion_visit_day', 13),
('2024-06-20', 8, 'conversion_visit_day', 4),
('2024-06-20', 9, 'conversion_visit_day', 1),
('2024-06-20', 10, 'conversion_visit_day', 4),
('2024-06-20', 11, 'conversion_visit_day', 4),
('2024-06-20', 12, 'conversion_visit_day', 1),
('2024-06-20', 14, 'conversion_visit_day', 2),
('2024-06-20', 23, 'conversion_visit_day', 1),
('2024-06-21', 2, 'conversion_visit_day', 2),
('2024-06-21', 3, 'conversion_visit_day', 3),
('2024-06-21', 5, 'conversion_visit_day', 5),
('2024-06-21', 8, 'conversion_visit_day', 7),
('2024-06-21', 9, 'conversion_visit_day', 1),
('2024-06-21', 11, 'conversion_visit_day', 2),
('2024-06-22', 2, 'conversion_visit_day', 2),
('2024-06-22', 3, 'conversion_visit_day', 1),
('2024-06-22', 5, 'conversion_visit_day', 1),
('2024-06-22', 8, 'conversion_visit_day', 3),
('2024-06-22', 11, 'conversion_visit_day', 4),
('2024-06-22', 19, 'conversion_visit_day', 1),
('2024-06-23', 2, 'conversion_visit_day', 2),
('2024-06-23', 3, 'conversion_visit_day', 3),
('2024-06-23', 5, 'conversion_visit_day', 5),
('2024-06-23', 8, 'conversion_visit_day', 4),
('2024-06-23', 9, 'conversion_visit_day', 2),
('2024-06-23', 10, 'conversion_visit_day', 3),
('2024-06-23', 11, 'conversion_visit_day', 7),
('2024-06-23', 14, 'conversion_visit_day', 1),
('2024-06-24', 2, 'conversion_visit_day', 2),
('2024-06-24', 3, 'conversion_visit_day', 4),
('2024-06-24', 5, 'conversion_visit_day', 6),
('2024-06-24', 7, 'conversion_visit_day', 1),
('2024-06-24', 8, 'conversion_visit_day', 3),
('2024-06-24', 9, 'conversion_visit_day', 2),
('2024-06-24', 10, 'conversion_visit_day', 1),
('2024-06-24', 11, 'conversion_visit_day', 11),
('2024-06-25', 2, 'conversion_visit_day', 1),
('2024-06-25', 5, 'conversion_visit_day', 5),
('2024-06-25', 7, 'conversion_visit_day', 2),
('2024-06-25', 8, 'conversion_visit_day', 2),
('2024-06-25', 9, 'conversion_visit_day', 2),
('2024-06-25', 11, 'conversion_visit_day', 5),
('2024-06-25', 17, 'conversion_visit_day', 1),
('2024-06-26', 2, 'conversion_visit_day', 2),
('2024-06-26', 3, 'conversion_visit_day', 7),
('2024-06-26', 5, 'conversion_visit_day', 5),
('2024-06-26', 8, 'conversion_visit_day', 9),
('2024-06-26', 9, 'conversion_visit_day', 1),
('2024-06-26', 10, 'conversion_visit_day', 3),
('2024-06-26', 11, 'conversion_visit_day', 8),
('2024-06-26', 14, 'conversion_visit_day', 2),
('2024-06-26', 16, 'conversion_visit_day', 1),
('2024-06-27', 2, 'conversion_visit_day', 4),
('2024-06-27', 3, 'conversion_visit_day', 1),
('2024-06-27', 5, 'conversion_visit_day', 8),
('2024-06-27', 7, 'conversion_visit_day', 2),
('2024-06-27', 8, 'conversion_visit_day', 6),
('2024-06-27', 9, 'conversion_visit_day', 1),
('2024-06-27', 11, 'conversion_visit_day', 2),
('2024-06-27', 12, 'conversion_visit_day', 1),
('2024-06-27', 16, 'conversion_visit_day', 1),
('2024-06-28', 2, 'conversion_visit_day', 1),
('2024-06-28', 5, 'conversion_visit_day', 15),
('2024-06-28', 8, 'conversion_visit_day', 4),
('2024-06-28', 9, 'conversion_visit_day', 1),
('2024-06-28', 11, 'conversion_visit_day', 6),
('2024-06-28', 14, 'conversion_visit_day', 1),
('2024-06-29', 2, 'conversion_visit_day', 3),
('2024-06-29', 3, 'conversion_visit_day', 6),
('2024-06-29', 5, 'conversion_visit_day', 9),
('2024-06-29', 8, 'conversion_visit_day', 3),
('2024-06-29', 9, 'conversion_visit_day', 1),
('2024-06-29', 10, 'conversion_visit_day', 2),
('2024-06-29', 11, 'conversion_visit_day', 1),
('2024-06-29', 18, 'conversion_visit_day', 1),
('2024-06-29', 22, 'conversion_visit_day', 1),
('2024-06-30', 2, 'conversion_visit_day', 1),
('2024-06-30', 3, 'conversion_visit_day', 13),
('2024-06-30', 5, 'conversion_visit_day', 9),
('2024-06-30', 8, 'conversion_visit_day', 6),
('2024-06-30', 9, 'conversion_visit_day', 3),
('2024-06-30', 10, 'conversion_visit_day', 1),
('2024-06-30', 11, 'conversion_visit_day', 4),
('2024-06-30', 14, 'conversion_visit_day', 1),
('2024-07-01', 2, 'conversion_visit_day', 2),
('2024-07-01', 3, 'conversion_visit_day', 6),
('2024-07-01', 5, 'conversion_visit_day', 21),
('2024-07-01', 7, 'conversion_visit_day', 1),
('2024-07-01', 8, 'conversion_visit_day', 5),
('2024-07-01', 9, 'conversion_visit_day', 2),
('2024-07-01', 11, 'conversion_visit_day', 3),
('2024-07-01', 12, 'conversion_visit_day', 1),
('2024-07-01', 14, 'conversion_visit_day', 1),
('2024-07-01', 15, 'conversion_visit_day', 1),
('2024-07-02', 1, 'conversion_visit_day', 1),
('2024-07-02', 2, 'conversion_visit_day', 2),
('2024-07-02', 3, 'conversion_visit_day', 7),
('2024-07-02', 5, 'conversion_visit_day', 14),
('2024-07-02', 8, 'conversion_visit_day', 5),
('2024-07-02', 9, 'conversion_visit_day', 1),
('2024-07-02', 10, 'conversion_visit_day', 2),
('2024-07-02', 11, 'conversion_visit_day', 5),
('2024-07-03', 2, 'conversion_visit_day', 2),
('2024-07-03', 3, 'conversion_visit_day', 5),
('2024-07-03', 5, 'conversion_visit_day', 27),
('2024-07-03', 8, 'conversion_visit_day', 4),
('2024-07-03', 9, 'conversion_visit_day', 5),
('2024-07-03', 10, 'conversion_visit_day', 3),
('2024-07-03', 11, 'conversion_visit_day', 6),
('2024-07-03', 12, 'conversion_visit_day', 1),
('2024-07-03', 13, 'conversion_visit_day', 1),
('2024-07-04', 1, 'conversion_visit_day', 1),
('2024-07-04', 2, 'conversion_visit_day', 3),
('2024-07-04', 3, 'conversion_visit_day', 6),
('2024-07-04', 5, 'conversion_visit_day', 8),
('2024-07-04', 8, 'conversion_visit_day', 4),
('2024-07-04', 11, 'conversion_visit_day', 6),
('2024-07-04', 14, 'conversion_visit_day', 2),
('2024-07-05', 2, 'conversion_visit_day', 3),
('2024-07-05', 3, 'conversion_visit_day', 4),
('2024-07-05', 5, 'conversion_visit_day', 25),
('2024-07-05', 8, 'conversion_visit_day', 4),
('2024-07-05', 9, 'conversion_visit_day', 1),
('2024-07-05', 10, 'conversion_visit_day', 4),
('2024-07-05', 11, 'conversion_visit_day', 2),
('2024-07-05', 14, 'conversion_visit_day', 1),
('2024-07-06', 2, 'conversion_visit_day', 1),
('2024-07-06', 3, 'conversion_visit_day', 7),
('2024-07-06', 5, 'conversion_visit_day', 4),
('2024-07-06', 8, 'conversion_visit_day', 5),
('2024-07-06', 9, 'conversion_visit_day', 2),
('2024-07-06', 10, 'conversion_visit_day', 2),
('2024-07-06', 11, 'conversion_visit_day', 6),
('2024-07-06', 14, 'conversion_visit_day', 2),
('2024-07-06', 22, 'conversion_visit_day', 2),
('2024-07-07', 2, 'conversion_visit_day', 1),
('2024-07-07', 3, 'conversion_visit_day', 11),
('2024-07-07', 5, 'conversion_visit_day', 19),
('2024-07-07', 8, 'conversion_visit_day', 3),
('2024-07-07', 9, 'conversion_visit_day', 1),
('2024-07-07', 10, 'conversion_visit_day', 2),
('2024-07-07', 11, 'conversion_visit_day', 5),
('2024-07-08', 2, 'conversion_visit_day', 3),
('2024-07-08', 3, 'conversion_visit_day', 6),
('2024-07-08', 5, 'conversion_visit_day', 29),
('2024-07-08', 8, 'conversion_visit_day', 3),
('2024-07-08', 9, 'conversion_visit_day', 4),
('2024-07-08', 10, 'conversion_visit_day', 4),
('2024-07-08', 11, 'conversion_visit_day', 6),
('2024-07-08', 14, 'conversion_visit_day', 2),
('2024-07-09', 2, 'conversion_visit_day', 1),
('2024-07-09', 3, 'conversion_visit_day', 3),
('2024-07-09', 5, 'conversion_visit_day', 28),
('2024-07-09', 8, 'conversion_visit_day', 2),
('2024-07-09', 9, 'conversion_visit_day', 2),
('2024-07-09', 10, 'conversion_visit_day', 2),
('2024-07-09', 11, 'conversion_visit_day', 5),
('2024-07-09', 22, 'conversion_visit_day', 3),
('2024-07-10', 2, 'conversion_visit_day', 1),
('2024-07-10', 3, 'conversion_visit_day', 2),
('2024-07-10', 5, 'conversion_visit_day', 13),
('2024-07-10', 8, 'conversion_visit_day', 8),
('2024-07-10', 9, 'conversion_visit_day', 2),
('2024-07-10', 10, 'conversion_visit_day', 2),
('2024-07-10', 11, 'conversion_visit_day', 5),
('2024-07-11', 2, 'conversion_visit_day', 1),
('2024-07-11', 3, 'conversion_visit_day', 3),
('2024-07-11', 5, 'conversion_visit_day', 8),
('2024-07-11', 8, 'conversion_visit_day', 4),
('2024-07-11', 9, 'conversion_visit_day', 1),
('2024-07-11', 10, 'conversion_visit_day', 2),
('2024-07-11', 11, 'conversion_visit_day', 2),
('2024-07-11', 12, 'conversion_visit_day', 1),
('2024-07-11', 14, 'conversion_visit_day', 1),
('2024-07-11', 22, 'conversion_visit_day', 2),
('2024-07-12', 2, 'conversion_visit_day', 4),
('2024-07-12', 3, 'conversion_visit_day', 4),
('2024-07-12', 5, 'conversion_visit_day', 7),
('2024-07-12', 8, 'conversion_visit_day', 4),
('2024-07-12', 10, 'conversion_visit_day', 2),
('2024-07-12', 11, 'conversion_visit_day', 3),
('2024-07-12', 12, 'conversion_visit_day', 1),
('2024-07-13', 2, 'conversion_visit_day', 2),
('2024-07-13', 3, 'conversion_visit_day', 5),
('2024-07-13', 4, 'conversion_visit_day', 1),
('2024-07-13', 5, 'conversion_visit_day', 5),
('2024-07-13', 7, 'conversion_visit_day', 1),
('2024-07-13', 8, 'conversion_visit_day', 2),
('2024-07-13', 9, 'conversion_visit_day', 6),
('2024-07-13', 10, 'conversion_visit_day', 5),
('2024-07-13', 11, 'conversion_visit_day', 1),
('2024-07-13', 14, 'conversion_visit_day', 2),
('2024-07-14', 2, 'conversion_visit_day', 2),
('2024-07-14', 3, 'conversion_visit_day', 4),
('2024-07-14', 5, 'conversion_visit_day', 13),
('2024-07-14', 8, 'conversion_visit_day', 1),
('2024-07-14', 9, 'conversion_visit_day', 1),
('2024-07-14', 10, 'conversion_visit_day', 3),
('2024-07-14', 11, 'conversion_visit_day', 2),
('2024-07-14', 14, 'conversion_visit_day', 1),
('2024-07-14', 18, 'conversion_visit_day', 1),
('2024-07-15', 2, 'conversion_visit_day', 2),
('2024-07-15', 3, 'conversion_visit_day', 8),
('2024-07-15', 5, 'conversion_visit_day', 2),
('2024-07-15', 7, 'conversion_visit_day', 1),
('2024-07-15', 8, 'conversion_visit_day', 8),
('2024-07-15', 9, 'conversion_visit_day', 4),
('2024-07-15', 10, 'conversion_visit_day', 6),
('2024-07-15', 11, 'conversion_visit_day', 6),
('2024-07-15', 13, 'conversion_visit_day', 1),
('2024-07-16', 2, 'conversion_visit_day', 1),
('2024-07-16', 3, 'conversion_visit_day', 6),
('2024-07-16', 5, 'conversion_visit_day', 5),
('2024-07-16', 8, 'conversion_visit_day', 8),
('2024-07-16', 9, 'conversion_visit_day', 1),
('2024-07-16', 10, 'conversion_visit_day', 6),
('2024-07-16', 11, 'conversion_visit_day', 4),
('2024-07-16', 13, 'conversion_visit_day', 1),
('2024-07-16', 19, 'conversion_visit_day', 1),
('2024-07-17', 2, 'conversion_visit_day', 3),
('2024-07-17', 3, 'conversion_visit_day', 7),
('2024-07-17', 5, 'conversion_visit_day', 2),
('2024-07-17', 8, 'conversion_visit_day', 6),
('2024-07-17', 9, 'conversion_visit_day', 1),
('2024-07-17', 10, 'conversion_visit_day', 3),
('2024-07-17', 11, 'conversion_visit_day', 4),
('2024-07-17', 18, 'conversion_visit_day', 1),
('2024-07-17', 19, 'conversion_visit_day', 1),
('2024-07-17', 20, 'conversion_visit_day', 1),
('2024-07-18', 3, 'conversion_visit_day', 12),
('2024-07-18', 5, 'conversion_visit_day', 3),
('2024-07-18', 8, 'conversion_visit_day', 9),
('2024-07-18', 9, 'conversion_visit_day', 2),
('2024-07-18', 10, 'conversion_visit_day', 2),
('2024-07-18', 11, 'conversion_visit_day', 4),
('2024-07-18', 12, 'conversion_visit_day', 1),
('2024-07-18', 14, 'conversion_visit_day', 2),
('2024-07-18', 22, 'conversion_visit_day', 1),
('2024-07-19', 2, 'conversion_visit_day', 1),
('2024-07-19', 3, 'conversion_visit_day', 8),
('2024-07-19', 5, 'conversion_visit_day', 1),
('2024-07-19', 7, 'conversion_visit_day', 1),
('2024-07-19', 8, 'conversion_visit_day', 4),
('2024-07-19', 9, 'conversion_visit_day', 3),
('2024-07-19', 10, 'conversion_visit_day', 6),
('2024-07-19', 11, 'conversion_visit_day', 5),
('2024-07-19', 14, 'conversion_visit_day', 1),
('2024-07-19', 22, 'conversion_visit_day', 1),
('2024-07-20', 3, 'conversion_visit_day', 5),
('2024-07-20', 4, 'conversion_visit_day', 1),
('2024-07-20', 5, 'conversion_visit_day', 1),
('2024-07-20', 8, 'conversion_visit_day', 7),
('2024-07-20', 9, 'conversion_visit_day', 3),
('2024-07-20', 10, 'conversion_visit_day', 3),
('2024-07-20', 11, 'conversion_visit_day', 5),
('2024-07-21', 2, 'conversion_visit_day', 2),
('2024-07-21', 3, 'conversion_visit_day', 6),
('2024-07-21', 4, 'conversion_visit_day', 1),
('2024-07-21', 8, 'conversion_visit_day', 3),
('2024-07-21', 9, 'conversion_visit_day', 3),
('2024-07-21', 10, 'conversion_visit_day', 5),
('2024-07-21', 11, 'conversion_visit_day', 7),
('2024-07-22', 2, 'conversion_visit_day', 1),
('2024-07-22', 3, 'conversion_visit_day', 7),
('2024-07-22', 5, 'conversion_visit_day', 3),
('2024-07-22', 7, 'conversion_visit_day', 1),
('2024-07-22', 8, 'conversion_visit_day', 4),
('2024-07-22', 9, 'conversion_visit_day', 4),
('2024-07-22', 10, 'conversion_visit_day', 3),
('2024-07-22', 11, 'conversion_visit_day', 5),
('2024-07-22', 19, 'conversion_visit_day', 1),
('2024-07-23', 2, 'conversion_visit_day', 3),
('2024-07-23', 3, 'conversion_visit_day', 6),
('2024-07-23', 4, 'conversion_visit_day', 1),
('2024-07-23', 5, 'conversion_visit_day', 4),
('2024-07-23', 8, 'conversion_visit_day', 4),
('2024-07-23', 9, 'conversion_visit_day', 3),
('2024-07-23', 10, 'conversion_visit_day', 2),
('2024-07-23', 11, 'conversion_visit_day', 9),
('2024-07-23', 12, 'conversion_visit_day', 1),
('2024-07-23', 14, 'conversion_visit_day', 1),
('2024-07-23', 22, 'conversion_visit_day', 1),
('2024-07-23', 24, 'conversion_visit_day', 1),
('2024-07-24', 2, 'conversion_visit_day', 1),
('2024-07-24', 3, 'conversion_visit_day', 7),
('2024-07-24', 5, 'conversion_visit_day', 2),
('2024-07-24', 8, 'conversion_visit_day', 9),
('2024-07-24', 9, 'conversion_visit_day', 1),
('2024-07-24', 10, 'conversion_visit_day', 1),
('2024-07-24', 11, 'conversion_visit_day', 4),
('2024-07-25', 2, 'conversion_visit_day', 2),
('2024-07-25', 3, 'conversion_visit_day', 3),
('2024-07-25', 5, 'conversion_visit_day', 3),
('2024-07-25', 8, 'conversion_visit_day', 5),
('2024-07-25', 9, 'conversion_visit_day', 2),
('2024-07-25', 10, 'conversion_visit_day', 2),
('2024-07-25', 11, 'conversion_visit_day', 5),
('2024-07-25', 13, 'conversion_visit_day', 1),
('2024-07-26', 2, 'conversion_visit_day', 5),
('2024-07-26', 3, 'conversion_visit_day', 8),
('2024-07-26', 5, 'conversion_visit_day', 13),
('2024-07-26', 8, 'conversion_visit_day', 1),
('2024-07-26', 9, 'conversion_visit_day', 4),
('2024-07-26', 10, 'conversion_visit_day', 3),
('2024-07-26', 11, 'conversion_visit_day', 7),
('2024-07-26', 19, 'conversion_visit_day', 1),
('2024-07-26', 22, 'conversion_visit_day', 1),
('2024-07-27', 2, 'conversion_visit_day', 2),
('2024-07-27', 3, 'conversion_visit_day', 3),
('2024-07-27', 5, 'conversion_visit_day', 2),
('2024-07-27', 8, 'conversion_visit_day', 2),
('2024-07-27', 9, 'conversion_visit_day', 2),
('2024-07-27', 10, 'conversion_visit_day', 4),
('2024-07-27', 11, 'conversion_visit_day', 4),
('2024-07-27', 13, 'conversion_visit_day', 1),
('2024-07-27', 14, 'conversion_visit_day', 1),
('2024-07-27', 22, 'conversion_visit_day', 2),
('2024-07-28', 3, 'conversion_visit_day', 7),
('2024-07-28', 4, 'conversion_visit_day', 1),
('2024-07-28', 5, 'conversion_visit_day', 3),
('2024-07-28', 8, 'conversion_visit_day', 3),
('2024-07-28', 9, 'conversion_visit_day', 1),
('2024-07-28', 10, 'conversion_visit_day', 3),
('2024-07-28', 11, 'conversion_visit_day', 4),
('2024-07-28', 14, 'conversion_visit_day', 1),
('2024-07-28', 22, 'conversion_visit_day', 1),
('2024-07-29', 2, 'conversion_visit_day', 3),
('2024-07-29', 3, 'conversion_visit_day', 4),
('2024-07-29', 4, 'conversion_visit_day', 1),
('2024-07-29', 5, 'conversion_visit_day', 1),
('2024-07-29', 8, 'conversion_visit_day', 5),
('2024-07-29', 9, 'conversion_visit_day', 1),
('2024-07-29', 10, 'conversion_visit_day', 1),
('2024-07-29', 11, 'conversion_visit_day', 7),
('2024-07-29', 14, 'conversion_visit_day', 1),
('2024-07-29', 19, 'conversion_visit_day', 1),
('2024-07-29', 22, 'conversion_visit_day', 1),
('2024-07-30', 2, 'conversion_visit_day', 3),
('2024-07-30', 3, 'conversion_visit_day', 3),
('2024-07-30', 4, 'conversion_visit_day', 1),
('2024-07-30', 5, 'conversion_visit_day', 3),
('2024-07-30', 8, 'conversion_visit_day', 6),
('2024-07-30', 9, 'conversion_visit_day', 1),
('2024-07-30', 10, 'conversion_visit_day', 3),
('2024-07-30', 11, 'conversion_visit_day', 2),
('2024-07-30', 15, 'conversion_visit_day', 1),
('2024-07-30', 22, 'conversion_visit_day', 1),
('2024-07-31', 2, 'conversion_visit_day', 1),
('2024-07-31', 3, 'conversion_visit_day', 12),
('2024-07-31', 5, 'conversion_visit_day', 2),
('2024-07-31', 8, 'conversion_visit_day', 2),
('2024-07-31', 9, 'conversion_visit_day', 1),
('2024-07-31', 10, 'conversion_visit_day', 1),
('2024-07-31', 11, 'conversion_visit_day', 2),
('2024-07-31', 12, 'conversion_visit_day', 1),
('2024-07-31', 15, 'conversion_visit_day', 1),
('2024-08-01', 2, 'conversion_visit_day', 3),
('2024-08-01', 3, 'conversion_visit_day', 6),
('2024-08-01', 5, 'conversion_visit_day', 4),
('2024-08-01', 7, 'conversion_visit_day', 1),
('2024-08-01', 8, 'conversion_visit_day', 7),
('2024-08-01', 9, 'conversion_visit_day', 3),
('2024-08-01', 10, 'conversion_visit_day', 3),
('2024-08-01', 11, 'conversion_visit_day', 6),
('2024-08-01', 14, 'conversion_visit_day', 1),
('2024-08-02', 3, 'conversion_visit_day', 14),
('2024-08-02', 5, 'conversion_visit_day', 8),
('2024-08-02', 8, 'conversion_visit_day', 4),
('2024-08-02', 10, 'conversion_visit_day', 6),
('2024-08-02', 11, 'conversion_visit_day', 6),
('2024-08-02', 12, 'conversion_visit_day', 1),
('2024-08-02', 25, 'conversion_visit_day', 1),
('2024-08-03', 2, 'conversion_visit_day', 2),
('2024-08-03', 3, 'conversion_visit_day', 7),
('2024-08-03', 5, 'conversion_visit_day', 19),
('2024-08-03', 8, 'conversion_visit_day', 5),
('2024-08-03', 10, 'conversion_visit_day', 6),
('2024-08-03', 11, 'conversion_visit_day', 1),
('2024-08-03', 22, 'conversion_visit_day', 1),
('2024-08-04', 2, 'conversion_visit_day', 1),
('2024-08-04', 3, 'conversion_visit_day', 8),
('2024-08-04', 4, 'conversion_visit_day', 1),
('2024-08-04', 5, 'conversion_visit_day', 11),
('2024-08-04', 8, 'conversion_visit_day', 5),
('2024-08-04', 9, 'conversion_visit_day', 1),
('2024-08-04', 10, 'conversion_visit_day', 1),
('2024-08-04', 11, 'conversion_visit_day', 1),
('2024-08-05', 2, 'conversion_visit_day', 3),
('2024-08-05', 3, 'conversion_visit_day', 7),
('2024-08-05', 5, 'conversion_visit_day', 12),
('2024-08-05', 8, 'conversion_visit_day', 8),
('2024-08-05', 9, 'conversion_visit_day', 4),
('2024-08-05', 10, 'conversion_visit_day', 3),
('2024-08-05', 11, 'conversion_visit_day', 8),
('2024-08-05', 13, 'conversion_visit_day', 2),
('2024-08-05', 22, 'conversion_visit_day', 1),
('2024-08-06', 2, 'conversion_visit_day', 4),
('2024-08-06', 3, 'conversion_visit_day', 3),
('2024-08-06', 5, 'conversion_visit_day', 15),
('2024-08-06', 8, 'conversion_visit_day', 4),
('2024-08-06', 9, 'conversion_visit_day', 1),
('2024-08-06', 10, 'conversion_visit_day', 1),
('2024-08-06', 11, 'conversion_visit_day', 7),
('2024-08-06', 12, 'conversion_visit_day', 1),
('2024-08-06', 15, 'conversion_visit_day', 1),
('2024-08-07', 2, 'conversion_visit_day', 4),
('2024-08-07', 3, 'conversion_visit_day', 10),
('2024-08-07', 5, 'conversion_visit_day', 18),
('2024-08-07', 8, 'conversion_visit_day', 5),
('2024-08-07', 10, 'conversion_visit_day', 3),
('2024-08-07', 11, 'conversion_visit_day', 7),
('2024-08-08', 2, 'conversion_visit_day', 3),
('2024-08-08', 3, 'conversion_visit_day', 9),
('2024-08-08', 5, 'conversion_visit_day', 9),
('2024-08-08', 8, 'conversion_visit_day', 6),
('2024-08-08', 10, 'conversion_visit_day', 2),
('2024-08-08', 11, 'conversion_visit_day', 5),
('2024-08-08', 18, 'conversion_visit_day', 1),
('2024-08-09', 2, 'conversion_visit_day', 2),
('2024-08-09', 3, 'conversion_visit_day', 5),
('2024-08-09', 5, 'conversion_visit_day', 1),
('2024-08-09', 8, 'conversion_visit_day', 2),
('2024-08-09', 9, 'conversion_visit_day', 1),
('2024-08-09', 10, 'conversion_visit_day', 3),
('2024-08-09', 11, 'conversion_visit_day', 3),
('2024-08-09', 14, 'conversion_visit_day', 1),
('2024-08-10', 2, 'conversion_visit_day', 1),
('2024-08-10', 3, 'conversion_visit_day', 7),
('2024-08-10', 4, 'conversion_visit_day', 1),
('2024-08-10', 5, 'conversion_visit_day', 16),
('2024-08-10', 8, 'conversion_visit_day', 1),
('2024-08-10', 9, 'conversion_visit_day', 3),
('2024-08-10', 10, 'conversion_visit_day', 1),
('2024-08-10', 11, 'conversion_visit_day', 2),
('2024-08-11', 3, 'conversion_visit_day', 2),
('2024-08-11', 5, 'conversion_visit_day', 1),
('2024-08-11', 8, 'conversion_visit_day', 1),
('2024-08-11', 9, 'conversion_visit_day', 2),
('2024-08-11', 10, 'conversion_visit_day', 2),
('2024-08-11', 11, 'conversion_visit_day', 9),
('2024-08-11', 14, 'conversion_visit_day', 1),
('2024-08-11', 22, 'conversion_visit_day', 1),
('2024-08-12', 2, 'conversion_visit_day', 2),
('2024-08-12', 3, 'conversion_visit_day', 10),
('2024-08-12', 5, 'conversion_visit_day', 11),
('2024-08-12', 8, 'conversion_visit_day', 9),
('2024-08-12', 9, 'conversion_visit_day', 2),
('2024-08-12', 11, 'conversion_visit_day', 12),
('2024-08-12', 14, 'conversion_visit_day', 1),
('2024-08-13', 2, 'conversion_visit_day', 5),
('2024-08-13', 3, 'conversion_visit_day', 3),
('2024-08-13', 4, 'conversion_visit_day', 1),
('2024-08-13', 5, 'conversion_visit_day', 4),
('2024-08-13', 8, 'conversion_visit_day', 5),
('2024-08-13', 9, 'conversion_visit_day', 1),
('2024-08-13', 10, 'conversion_visit_day', 3),
('2024-08-13', 11, 'conversion_visit_day', 5),
('2024-08-13', 14, 'conversion_visit_day', 1),
('2024-08-13', 19, 'conversion_visit_day', 1),
('2024-08-13', 20, 'conversion_visit_day', 1),
('2024-08-14', 3, 'conversion_visit_day', 3),
('2024-08-14', 8, 'conversion_visit_day', 2),
('2024-08-14', 9, 'conversion_visit_day', 3),
('2024-08-14', 10, 'conversion_visit_day', 1),
('2024-08-14', 11, 'conversion_visit_day', 2),
('2024-08-14', 12, 'conversion_visit_day', 1),
('2024-08-14', 13, 'conversion_visit_day', 1),
('2024-08-14', 14, 'conversion_visit_day', 1),
('2024-08-14', 20, 'conversion_visit_day', 1),
('2024-08-15', 2, 'conversion_visit_day', 2),
('2024-08-15', 3, 'conversion_visit_day', 2),
('2024-08-15', 4, 'conversion_visit_day', 1),
('2024-08-15', 5, 'conversion_visit_day', 1),
('2024-08-15', 8, 'conversion_visit_day', 8),
('2024-08-15', 9, 'conversion_visit_day', 1),
('2024-08-15', 12, 'conversion_visit_day', 1),
('2024-08-15', 14, 'conversion_visit_day', 1),
('2024-08-16', 2, 'conversion_visit_day', 5),
('2024-08-16', 3, 'conversion_visit_day', 4),
('2024-08-16', 5, 'conversion_visit_day', 2),
('2024-08-16', 8, 'conversion_visit_day', 4),
('2024-08-16', 9, 'conversion_visit_day', 2),
('2024-08-16', 10, 'conversion_visit_day', 4),
('2024-08-16', 11, 'conversion_visit_day', 2),
('2024-08-16', 14, 'conversion_visit_day', 1),
('2024-08-16', 22, 'conversion_visit_day', 1),
('2024-08-17', 1, 'conversion_visit_day', 1),
('2024-08-17', 2, 'conversion_visit_day', 1),
('2024-08-17', 3, 'conversion_visit_day', 6),
('2024-08-17', 8, 'conversion_visit_day', 4),
('2024-08-17', 10, 'conversion_visit_day', 3),
('2024-08-17', 11, 'conversion_visit_day', 2),
('2024-08-17', 14, 'conversion_visit_day', 1),
('2024-08-18', 2, 'conversion_visit_day', 5),
('2024-08-18', 3, 'conversion_visit_day', 6),
('2024-08-18', 5, 'conversion_visit_day', 4),
('2024-08-18', 8, 'conversion_visit_day', 1),
('2024-08-18', 9, 'conversion_visit_day', 3),
('2024-08-18', 10, 'conversion_visit_day', 4),
('2024-08-18', 22, 'conversion_visit_day', 3),
('2024-08-19', 2, 'conversion_visit_day', 4),
('2024-08-19', 3, 'conversion_visit_day', 6),
('2024-08-19', 5, 'conversion_visit_day', 28),
('2024-08-19', 7, 'conversion_visit_day', 1),
('2024-08-19', 8, 'conversion_visit_day', 3),
('2024-08-19', 10, 'conversion_visit_day', 5),
('2024-08-19', 11, 'conversion_visit_day', 2),
('2024-08-19', 12, 'conversion_visit_day', 1),
('2024-08-20', 2, 'conversion_visit_day', 2),
('2024-08-20', 3, 'conversion_visit_day', 6),
('2024-08-20', 4, 'conversion_visit_day', 1),
('2024-08-20', 5, 'conversion_visit_day', 3),
('2024-08-20', 7, 'conversion_visit_day', 1),
('2024-08-20', 8, 'conversion_visit_day', 5),
('2024-08-20', 9, 'conversion_visit_day', 1),
('2024-08-20', 10, 'conversion_visit_day', 3),
('2024-08-20', 12, 'conversion_visit_day', 1),
('2024-08-20', 22, 'conversion_visit_day', 1),
('2024-08-21', 2, 'conversion_visit_day', 2),
('2024-08-21', 3, 'conversion_visit_day', 3),
('2024-08-21', 4, 'conversion_visit_day', 1),
('2024-08-21', 5, 'conversion_visit_day', 6),
('2024-08-21', 8, 'conversion_visit_day', 7),
('2024-08-21', 9, 'conversion_visit_day', 1),
('2024-08-21', 11, 'conversion_visit_day', 2),
('2024-08-21', 22, 'conversion_visit_day', 1),
('2024-08-22', 2, 'conversion_visit_day', 3),
('2024-08-22', 3, 'conversion_visit_day', 8),
('2024-08-22', 5, 'conversion_visit_day', 5),
('2024-08-22', 8, 'conversion_visit_day', 4),
('2024-08-22', 9, 'conversion_visit_day', 1),
('2024-08-22', 10, 'conversion_visit_day', 2),
('2024-08-22', 11, 'conversion_visit_day', 4),
('2024-08-22', 22, 'conversion_visit_day', 1),
('2024-08-23', 3, 'conversion_visit_day', 6),
('2024-08-23', 5, 'conversion_visit_day', 24),
('2024-08-23', 8, 'conversion_visit_day', 4),
('2024-08-23', 9, 'conversion_visit_day', 1),
('2024-08-23', 10, 'conversion_visit_day', 1),
('2024-08-23', 11, 'conversion_visit_day', 4),
('2024-08-23', 22, 'conversion_visit_day', 1),
('2024-08-24', 2, 'conversion_visit_day', 2),
('2024-08-24', 3, 'conversion_visit_day', 5),
('2024-08-24', 5, 'conversion_visit_day', 10),
('2024-08-24', 8, 'conversion_visit_day', 3),
('2024-08-24', 10, 'conversion_visit_day', 1),
('2024-08-24', 11, 'conversion_visit_day', 4),
('2024-08-24', 22, 'conversion_visit_day', 2),
('2024-08-25', 2, 'conversion_visit_day', 2),
('2024-08-25', 3, 'conversion_visit_day', 4),
('2024-08-25', 5, 'conversion_visit_day', 17),
('2024-08-25', 8, 'conversion_visit_day', 3),
('2024-08-25', 10, 'conversion_visit_day', 1),
('2024-08-25', 11, 'conversion_visit_day', 1),
('2024-08-25', 22, 'conversion_visit_day', 1),
('2024-08-26', 3, 'conversion_visit_day', 1),
('2024-08-26', 5, 'conversion_visit_day', 1),
('2024-08-26', 7, 'conversion_visit_day', 1),
('2024-08-26', 8, 'conversion_visit_day', 2),
('2024-08-26', 10, 'conversion_visit_day', 2),
('2024-08-26', 11, 'conversion_visit_day', 3),
('2024-08-26', 22, 'conversion_visit_day', 1),
('2024-08-27', 2, 'conversion_visit_day', 1),
('2024-08-27', 3, 'conversion_visit_day', 3),
('2024-08-27', 5, 'conversion_visit_day', 3),
('2024-08-27', 8, 'conversion_visit_day', 5),
('2024-08-27', 10, 'conversion_visit_day', 2),
('2024-08-27', 11, 'conversion_visit_day', 4),
('2024-08-27', 12, 'conversion_visit_day', 1),
('2024-08-28', 2, 'conversion_visit_day', 4),
('2024-08-28', 3, 'conversion_visit_day', 2),
('2024-08-28', 5, 'conversion_visit_day', 30),
('2024-08-28', 8, 'conversion_visit_day', 5),
('2024-08-28', 10, 'conversion_visit_day', 1),
('2024-08-28', 11, 'conversion_visit_day', 4),
('2024-08-29', 2, 'conversion_visit_day', 4),
('2024-08-29', 3, 'conversion_visit_day', 2),
('2024-08-29', 5, 'conversion_visit_day', 59),
('2024-08-29', 8, 'conversion_visit_day', 8),
('2024-08-29', 9, 'conversion_visit_day', 1),
('2024-08-29', 11, 'conversion_visit_day', 8),
('2024-08-29', 19, 'conversion_visit_day', 1),
('2024-08-29', 22, 'conversion_visit_day', 1),
('2024-08-30', 3, 'conversion_visit_day', 3),
('2024-08-30', 5, 'conversion_visit_day', 62),
('2024-08-30', 8, 'conversion_visit_day', 5),
('2024-08-30', 11, 'conversion_visit_day', 2),
('2024-08-30', 12, 'conversion_visit_day', 1),
('2024-08-30', 14, 'conversion_visit_day', 1),
('2024-08-30', 22, 'conversion_visit_day', 2),
('2024-08-31', 3, 'conversion_visit_day', 1),
('2024-08-31', 5, 'conversion_visit_day', 39),
('2024-08-31', 8, 'conversion_visit_day', 3),
('2024-08-31', 10, 'conversion_visit_day', 1),
('2024-08-31', 11, 'conversion_visit_day', 2),
('2024-09-01', 2, 'conversion_visit_day', 2),
('2024-09-01', 3, 'conversion_visit_day', 3),
('2024-09-01', 5, 'conversion_visit_day', 128),
('2024-09-01', 8, 'conversion_visit_day', 2),
('2024-09-01', 9, 'conversion_visit_day', 1),
('2024-09-01', 10, 'conversion_visit_day', 1),
('2024-09-01', 11, 'conversion_visit_day', 2),
('2024-09-01', 14, 'conversion_visit_day', 1),
('2024-09-02', 2, 'conversion_visit_day', 3),
('2024-09-02', 3, 'conversion_visit_day', 4),
('2024-09-02', 5, 'conversion_visit_day', 68),
('2024-09-02', 7, 'conversion_visit_day', 1),
('2024-09-02', 8, 'conversion_visit_day', 7),
('2024-09-02', 10, 'conversion_visit_day', 2),
('2024-09-02', 11, 'conversion_visit_day', 1),
('2024-09-02', 19, 'conversion_visit_day', 1),
('2024-09-02', 22, 'conversion_visit_day', 1),
('2024-10-02', 2, 'conversion_visit_day', 3),
('2024-10-02', 6, 'conversion_visit_day', 1),
('2024-11-27', 2, 'conversion_visit_day', 5),
('2024-11-27', 5, 'conversion_visit_day', 1),
('2024-11-27', 8, 'conversion_visit_day', 1),
('2024-11-28', 2, 'conversion_visit_day', 2),
('2024-11-28', 5, 'conversion_visit_day', 5),
('2024-11-28', 22, 'conversion_visit_day', 2),
('2024-11-29', 2, 'conversion_visit_day', 2),
('2024-11-29', 5, 'conversion_visit_day', 7),
('2024-11-29', 8, 'conversion_visit_day', 2),
('2024-11-29', 11, 'conversion_visit_day', 3),
('2024-11-30', 2, 'conversion_visit_day', 2),
('2024-11-30', 5, 'conversion_visit_day', 2),
('2024-11-30', 8, 'conversion_visit_day', 2),
('2024-12-01', 2, 'conversion_visit_day', 1),
('2024-12-01', 5, 'conversion_visit_day', 1),
('2024-12-01', 7, 'conversion_visit_day', 1),
('2024-12-01', 8, 'conversion_visit_day', 3),
('2024-12-01', 9, 'conversion_visit_day', 1),
('2024-12-01', 11, 'conversion_visit_day', 3),
('2024-12-02', 2, 'conversion_visit_day', 1),
('2024-12-02', 8, 'conversion_visit_day', 3),
('2024-12-02', 11, 'conversion_visit_day', 1),
('2024-12-02', 14, 'conversion_visit_day', 1),
('2024-12-03', 2, 'conversion_visit_day', 1),
('2024-12-03', 5, 'conversion_visit_day', 3),
('2024-12-03', 7, 'conversion_visit_day', 1),
('2024-12-03', 8, 'conversion_visit_day', 3),
('2024-12-03', 11, 'conversion_visit_day', 2),
('2024-12-03', 19, 'conversion_visit_day', 1),
('2024-12-04', 5, 'conversion_visit_day', 2),
('2024-12-04', 8, 'conversion_visit_day', 2),
('2024-12-04', 11, 'conversion_visit_day', 1),
('2024-12-04', 12, 'conversion_visit_day', 1),
('2024-12-05', 5, 'conversion_visit_day', 1),
('2024-12-05', 11, 'conversion_visit_day', 1),
('2024-12-05', 22, 'conversion_visit_day', 1),
('2024-12-06', 2, 'conversion_visit_day', 1),
('2024-12-06', 5, 'conversion_visit_day', 1),
('2024-12-06', 8, 'conversion_visit_day', 2),
('2024-12-06', 11, 'conversion_visit_day', 2),
('2024-12-06', 14, 'conversion_visit_day', 1),
('2024-12-07', 2, 'conversion_visit_day', 1),
('2024-12-07', 5, 'conversion_visit_day', 4),
('2024-12-07', 11, 'conversion_visit_day', 4),
('2024-12-08', 2, 'conversion_visit_day', 1),
('2024-12-08', 5, 'conversion_visit_day', 2),
('2024-12-08', 8, 'conversion_visit_day', 1),
('2024-12-08', 14, 'conversion_visit_day', 1),
('2024-12-10', 5, 'conversion_visit_day', 3),
('2024-12-10', 8, 'conversion_visit_day', 1),
('2024-12-11', 2, 'conversion_visit_day', 2),
('2024-12-11', 5, 'conversion_visit_day', 1),
('2024-12-11', 8, 'conversion_visit_day', 3),
('2024-12-11', 9, 'conversion_visit_day', 1),
('2024-12-11', 11, 'conversion_visit_day', 1),
('2024-12-11', 12, 'conversion_visit_day', 1),
('2024-12-11', 22, 'conversion_visit_day', 1),
('2024-12-12', 5, 'conversion_visit_day', 1),
('2024-12-12', 8, 'conversion_visit_day', 1),
('2024-12-12', 12, 'conversion_visit_day', 1),
('2024-12-13', 2, 'conversion_visit_day', 1),
('2024-12-13', 5, 'conversion_visit_day', 3),
('2024-12-13', 8, 'conversion_visit_day', 1),
('2024-12-13', 11, 'conversion_visit_day', 1),
('2024-12-14', 2, 'conversion_visit_day', 1),
('2024-12-14', 5, 'conversion_visit_day', 1),
('2024-12-14', 8, 'conversion_visit_day', 2),
('2024-12-14', 15, 'conversion_visit_day', 1),
('2024-12-15', 8, 'conversion_visit_day', 1),
('2024-12-16', 3, 'conversion_visit_day', 2),
('2024-12-16', 5, 'conversion_visit_day', 2),
('2024-12-16', 8, 'conversion_visit_day', 2),
('2024-12-16', 11, 'conversion_visit_day', 1),
('2024-12-16', 18, 'conversion_visit_day', 1),
('2024-12-17', 3, 'conversion_visit_day', 1),
('2024-12-17', 13, 'conversion_visit_day', 1),
('2024-12-17', 18, 'conversion_visit_day', 1),
('2024-12-18', 5, 'conversion_visit_day', 1),
('2024-12-18', 20, 'conversion_visit_day', 1),
('2024-12-19', 2, 'conversion_visit_day', 5),
('2024-12-19', 3, 'conversion_visit_day', 1),
('2024-12-19', 5, 'conversion_visit_day', 1),
('2024-12-19', 8, 'conversion_visit_day', 1),
('2024-12-20', 2, 'conversion_visit_day', 2),
('2024-12-20', 5, 'conversion_visit_day', 3),
('2024-12-20', 8, 'conversion_visit_day', 1),
('2024-12-20', 9, 'conversion_visit_day', 1),
('2024-12-20', 11, 'conversion_visit_day', 3),
('2024-12-20', 14, 'conversion_visit_day', 1),
('2024-12-20', 16, 'conversion_visit_day', 1),
('2024-12-21', 5, 'conversion_visit_day', 1),
('2024-12-21', 11, 'conversion_visit_day', 1),
('2024-12-22', 2, 'conversion_visit_day', 1),
('2024-12-22', 5, 'conversion_visit_day', 2),
('2024-12-22', 8, 'conversion_visit_day', 1),
('2024-12-23', 5, 'conversion_visit_day', 3),
('2024-12-23', 8, 'conversion_visit_day', 1),
('2024-12-23', 20, 'conversion_visit_day', 2),
('2024-12-24', 2, 'conversion_visit_day', 1),
('2024-12-24', 5, 'conversion_visit_day', 1),
('2024-12-24', 8, 'conversion_visit_day', 2),
('2024-12-25', 5, 'conversion_visit_day', 2),
('2024-12-25', 8, 'conversion_visit_day', 3),
('2024-12-25', 9, 'conversion_visit_day', 1),
('2024-12-25', 10, 'conversion_visit_day', 1),
('2024-12-25', 11, 'conversion_visit_day', 1),
('2024-12-26', 3, 'conversion_visit_day', 1),
('2024-12-26', 8, 'conversion_visit_day', 1),
('2024-12-26', 11, 'conversion_visit_day', 1),
('2024-12-27', 2, 'conversion_visit_day', 1),
('2024-12-27', 5, 'conversion_visit_day', 2),
('2024-12-27', 7, 'conversion_visit_day', 1),
('2024-12-27', 8, 'conversion_visit_day', 2),
('2024-12-27', 11, 'conversion_visit_day', 3),
('2024-12-28', 5, 'conversion_visit_day', 1),
('2024-12-28', 8, 'conversion_visit_day', 1),
('2024-12-28', 11, 'conversion_visit_day', 1),
('2024-12-28', 14, 'conversion_visit_day', 1),
('2024-12-28', 22, 'conversion_visit_day', 1),
('2024-12-29', 2, 'conversion_visit_day', 1),
('2024-12-29', 3, 'conversion_visit_day', 1),
('2024-12-29', 5, 'conversion_visit_day', 1),
('2024-12-29', 19, 'conversion_visit_day', 1),
('2024-12-30', 3, 'conversion_visit_day', 1),
('2024-12-30', 5, 'conversion_visit_day', 1),
('2024-12-30', 8, 'conversion_visit_day', 1),
('2024-12-30', 9, 'conversion_visit_day', 1),
('2024-12-30', 11, 'conversion_visit_day', 1),
('2024-12-31', 5, 'conversion_visit_day', 1),
('2024-12-31', 8, 'conversion_visit_day', 2),
('2024-12-31', 11, 'conversion_visit_day', 2),
('2025-01-01', 5, 'conversion_visit_day', 2),
('2025-01-01', 8, 'conversion_visit_day', 1),
('2025-01-01', 11, 'conversion_visit_day', 4),
('2025-01-01', 14, 'conversion_visit_day', 2),
('2025-01-02', 2, 'conversion_visit_day', 1),
('2025-01-02', 5, 'conversion_visit_day', 3),
('2025-01-02', 8, 'conversion_visit_day', 4),
('2025-01-02', 11, 'conversion_visit_day', 3),
('2025-01-02', 18, 'conversion_visit_day', 1),
('2025-01-03', 3, 'conversion_visit_day', 1),
('2025-01-03', 5, 'conversion_visit_day', 4),
('2025-01-03', 8, 'conversion_visit_day', 1),
('2025-01-03', 11, 'conversion_visit_day', 6),
('2025-01-03', 18, 'conversion_visit_day', 2),
('2025-01-04', 5, 'conversion_visit_day', 1),
('2025-01-04', 9, 'conversion_visit_day', 2),
('2025-01-04', 10, 'conversion_visit_day', 1),
('2025-01-04', 11, 'conversion_visit_day', 1),
('2025-01-04', 20, 'conversion_visit_day', 1),
('2025-01-05', 3, 'conversion_visit_day', 1),
('2025-01-05', 5, 'conversion_visit_day', 1),
('2025-01-05', 8, 'conversion_visit_day', 4),
('2025-01-05', 9, 'conversion_visit_day', 2),
('2025-01-05', 11, 'conversion_visit_day', 3),
('2025-01-05', 14, 'conversion_visit_day', 1),
('2025-01-05', 26, 'conversion_visit_day', 1),
('2025-01-06', 2, 'conversion_visit_day', 1),
('2025-01-06', 3, 'conversion_visit_day', 1),
('2025-01-06', 5, 'conversion_visit_day', 3),
('2025-01-06', 19, 'conversion_visit_day', 1),
('2025-01-07', 3, 'conversion_visit_day', 2),
('2025-01-07', 8, 'conversion_visit_day', 1),
('2025-01-07', 9, 'conversion_visit_day', 2),
('2025-01-07', 11, 'conversion_visit_day', 2),
('2025-01-07', 26, 'conversion_visit_day', 1),
('2025-01-08', 8, 'conversion_visit_day', 3),
('2025-01-08', 11, 'conversion_visit_day', 1),
('2025-01-08', 16, 'conversion_visit_day', 1),
('2025-01-08', 18, 'conversion_visit_day', 1),
('2025-01-08', 19, 'conversion_visit_day', 1),
('2025-01-09', 5, 'conversion_visit_day', 1),
('2025-01-09', 8, 'conversion_visit_day', 6),
('2025-01-09', 11, 'conversion_visit_day', 20),
('2025-01-09', 18, 'conversion_visit_day', 1),
('2025-01-10', 2, 'conversion_visit_day', 1),
('2025-01-10', 5, 'conversion_visit_day', 1),
('2025-01-10', 8, 'conversion_visit_day', 1),
('2025-01-10', 9, 'conversion_visit_day', 3),
('2025-01-10', 10, 'conversion_visit_day', 2),
('2025-01-10', 11, 'conversion_visit_day', 11),
('2025-01-10', 12, 'conversion_visit_day', 1),
('2025-01-10', 18, 'conversion_visit_day', 1),
('2025-01-10', 19, 'conversion_visit_day', 1),
('2025-01-11', 2, 'conversion_visit_day', 2),
('2025-01-11', 3, 'conversion_visit_day', 1),
('2025-01-11', 5, 'conversion_visit_day', 3),
('2025-01-11', 8, 'conversion_visit_day', 2),
('2025-01-11', 11, 'conversion_visit_day', 9),
('2025-01-11', 18, 'conversion_visit_day', 2),
('2025-01-12', 2, 'conversion_visit_day', 2),
('2025-01-12', 3, 'conversion_visit_day', 1),
('2025-01-12', 5, 'conversion_visit_day', 2),
('2025-01-12', 8, 'conversion_visit_day', 3),
('2025-01-12', 9, 'conversion_visit_day', 2),
('2025-01-12', 10, 'conversion_visit_day', 1),
('2025-01-12', 11, 'conversion_visit_day', 5),
('2025-01-12', 13, 'conversion_visit_day', 1),
('2025-01-12', 18, 'conversion_visit_day', 1),
('2025-01-13', 2, 'conversion_visit_day', 2),
('2025-01-13', 3, 'conversion_visit_day', 1),
('2025-01-13', 5, 'conversion_visit_day', 2),
('2025-01-13', 8, 'conversion_visit_day', 5),
('2025-01-13', 9, 'conversion_visit_day', 2),
('2025-01-13', 10, 'conversion_visit_day', 1),
('2025-01-13', 11, 'conversion_visit_day', 5),
('2025-01-13', 19, 'conversion_visit_day', 1),
('2025-01-14', 8, 'conversion_visit_day', 4),
('2025-01-14', 9, 'conversion_visit_day', 1),
('2025-01-14', 11, 'conversion_visit_day', 4),
('2025-01-14', 14, 'conversion_visit_day', 3),
('2025-01-14', 19, 'conversion_visit_day', 2),
('2025-01-14', 20, 'conversion_visit_day', 1),
('2025-01-15', 2, 'conversion_visit_day', 1),
('2025-01-15', 5, 'conversion_visit_day', 2),
('2025-01-15', 9, 'conversion_visit_day', 1),
('2025-01-15', 11, 'conversion_visit_day', 8),
('2025-01-15', 18, 'conversion_visit_day', 3),
('2025-01-15', 19, 'conversion_visit_day', 1),
('2025-01-16', 2, 'conversion_visit_day', 2),
('2025-01-16', 5, 'conversion_visit_day', 3),
('2025-01-16', 8, 'conversion_visit_day', 6),
('2025-01-16', 9, 'conversion_visit_day', 2),
('2025-01-16', 11, 'conversion_visit_day', 6),
('2025-01-16', 12, 'conversion_visit_day', 1),
('2025-01-16', 13, 'conversion_visit_day', 1),
('2025-01-16', 14, 'conversion_visit_day', 1),
('2025-01-16', 16, 'conversion_visit_day', 1),
('2025-01-16', 22, 'conversion_visit_day', 1),
('2025-01-16', 27, 'conversion_visit_day', 1),
('2025-01-17', 5, 'conversion_visit_day', 2),
('2025-01-17', 8, 'conversion_visit_day', 4),
('2025-01-17', 9, 'conversion_visit_day', 1),
('2025-01-17', 10, 'conversion_visit_day', 1),
('2025-01-17', 11, 'conversion_visit_day', 5),
('2025-01-17', 19, 'conversion_visit_day', 1),
('2025-01-17', 26, 'conversion_visit_day', 1),
('2025-01-18', 5, 'conversion_visit_day', 6),
('2025-01-18', 8, 'conversion_visit_day', 2),
('2025-01-18', 9, 'conversion_visit_day', 2),
('2025-01-18', 10, 'conversion_visit_day', 1),
('2025-01-18', 11, 'conversion_visit_day', 11),
('2025-01-18', 14, 'conversion_visit_day', 1),
('2025-01-18', 18, 'conversion_visit_day', 1),
('2025-01-19', 2, 'conversion_visit_day', 2),
('2025-01-19', 3, 'conversion_visit_day', 3),
('2025-01-19', 5, 'conversion_visit_day', 2),
('2025-01-19', 11, 'conversion_visit_day', 4),
('2025-01-19', 14, 'conversion_visit_day', 1);
-- -----------------------------------
-- Dumping table b_conv_context_entity_item
-- -----------------------------------
DROP TABLE IF EXISTS `b_conv_context_entity_item`;
CREATE TABLE `b_conv_context_entity_item` (
  `ENTITY` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ITEM` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CONTEXT_ID` int unsigned NOT NULL,
  PRIMARY KEY (`ENTITY`,`ITEM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_counter_data
-- -----------------------------------
DROP TABLE IF EXISTS `b_counter_data`;
CREATE TABLE `b_counter_data` (
  `ID` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TYPE` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DATA` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_culture
-- -----------------------------------
DROP TABLE IF EXISTS `b_culture`;
CREATE TABLE `b_culture` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CODE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FORMAT_DATE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FORMAT_DATETIME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FORMAT_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `WEEK_START` int DEFAULT '1',
  `CHARSET` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DIRECTION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `SHORT_DATE_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'n/j/Y',
  `MEDIUM_DATE_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'M j, Y',
  `LONG_DATE_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'F j, Y',
  `FULL_DATE_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'l, F j, Y',
  `DAY_MONTH_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'F j',
  `DAY_SHORT_MONTH_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'M j',
  `DAY_OF_WEEK_MONTH_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'l, F j',
  `SHORT_DAY_OF_WEEK_MONTH_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'D, F j',
  `SHORT_DAY_OF_WEEK_SHORT_MONTH_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'D, M j',
  `SHORT_TIME_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'g:i a',
  `LONG_TIME_FORMAT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'g:i:s a',
  `AM_VALUE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'am',
  `PM_VALUE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'pm',
  `NUMBER_THOUSANDS_SEPARATOR` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT ',',
  `NUMBER_DECIMAL_SEPARATOR` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '.',
  `NUMBER_DECIMALS` tinyint DEFAULT '2',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_culture` VALUES
(1, 'ru', 'ru', 'DD.MM.YYYY', 'DD.MM.YYYY HH:MI:SS', '#NAME# #LAST_NAME#', 1, 'UTF-8', 'Y', 'd.m.Y', 'j M Y', 'j F Y', 'l, j F Y', 'j F', 'j M', 'l, j F', 'D, j F', 'D, j M', 'H:i', 'H:i:s', 'am', 'pm', ' ', ',', 2),
(2, 'en', 'en', 'MM/DD/YYYY', 'MM/DD/YYYY H:MI:SS T', '#NAME# #LAST_NAME#', 0, 'UTF-8', 'Y', 'n/j/Y', 'M j, Y', 'F j, Y', 'l, F j, Y', 'F j', 'M j', 'l, F j', 'D, F j', 'D, M j', 'g:i a', 'g:i:s a', 'am', 'pm', ',', '.', 2),
(3, 'la', 'la', 'DD/MM/YYYY', 'DD/MM/YYYY HH:MI:SS', '#NAME# #LAST_NAME#', 0, 'utf-8', 'Y', 'n/j/Y', 'M j, Y', 'F j, Y', 'l, F j, Y', 'F j', 'M j', 'l, F j', 'D, F j', 'D, M j', 'g:i a', 'g:i:s a', 'am', 'pm', ',', '.', 2),
(4, 'fr', 'fr', 'MM/DD/YYYY', 'MM/DD/YYYY HH:MI:SS', '#NAME# #LAST_NAME#', 0, 'utf-8', 'Y', 'n/j/Y', 'M j, Y', 'F j, Y', 'l, F j, Y', 'F j', 'M j', 'l, F j', 'D, F j', 'D, M j', 'g:i a', 'g:i:s a', 'am', 'pm', ',', '.', 2);
-- -----------------------------------
-- Dumping table b_entity_usage
-- -----------------------------------
DROP TABLE IF EXISTS `b_entity_usage`;
CREATE TABLE `b_entity_usage` (
  `USER_ID` int NOT NULL,
  `CONTEXT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ENTITY_ID` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ITEM_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ITEM_ID_INT` int NOT NULL DEFAULT '0',
  `PREFIX` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `LAST_USE_DATE` datetime NOT NULL,
  PRIMARY KEY (`USER_ID`,`CONTEXT`,`ENTITY_ID`,`ITEM_ID`),
  KEY `IX_ENTITY_USAGE_ITEM_ID_INT` (`ITEM_ID_INT`),
  KEY `IX_ENTITY_USAGE_LAST_USE_DATE` (`LAST_USE_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_event
-- -----------------------------------
DROP TABLE IF EXISTS `b_event`;
CREATE TABLE `b_event` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `EVENT_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MESSAGE_ID` int DEFAULT NULL,
  `LID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `C_FIELDS` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DATE_INSERT` datetime DEFAULT NULL,
  `DATE_EXEC` datetime DEFAULT NULL,
  `SUCCESS_EXEC` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `DUPLICATE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `LANGUAGE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_success` (`SUCCESS_EXEC`),
  KEY `ix_b_event_date_exec` (`DATE_EXEC`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_event` VALUES
(56, 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 53, 's1', 'a:28:{s:10:\"RS_FORM_ID\";s:1:\"3\";s:12:\"RS_FORM_NAME\";s:26:\"Забронировать\";s:15:\"RS_FORM_VARNAME\";s:37:\"aspro_allcorp3resort_order_product_s1\";s:11:\"RS_FORM_SID\";s:37:\"aspro_allcorp3resort_order_product_s1\";s:12:\"RS_RESULT_ID\";s:2:\"56\";s:14:\"RS_DATE_CREATE\";s:19:\"10.01.2025 17:40:35\";s:10:\"RS_USER_ID\";s:35:\"не зарегистрирован\";s:13:\"RS_USER_EMAIL\";s:0:\"\";s:12:\"RS_USER_NAME\";s:0:\"\";s:12:\"RS_USER_AUTH\";s:0:\"\";s:16:\"RS_STAT_GUEST_ID\";s:1:\"0\";s:18:\"RS_STAT_SESSION_ID\";s:1:\"0\";s:4:\"NAME\";s:29:\"Евгения кулиева\";s:8:\"NAME_RAW\";s:29:\"Евгения кулиева\";s:5:\"PHONE\";s:18:\"+7 (925) 568-86-36\";s:9:\"PHONE_RAW\";s:18:\"+7 (925) 568-86-36\";s:4:\"FROM\";s:15:\"16.07.2025 12:0\";s:8:\"FROM_RAW\";s:15:\"16.07.2025 12:0\";s:2:\"TO\";s:15:\"26.07.2025 12:0\";s:6:\"TO_RAW\";s:15:\"26.07.2025 12:0\";s:7:\"PRODUCT\";s:12:\"Эконом\";s:11:\"PRODUCT_RAW\";s:12:\"Эконом\";s:7:\"NUMBERS\";s:6:\"1 [18]\";s:11:\"NUMBERS_RAW\";s:1:\"1\";s:8:\"SERVICES\";s:53:\"Питание [23]<br />Санузел / душ [25]\";s:12:\"SERVICES_RAW\";s:38:\"Питание,Санузел / душ\";s:7:\"MESSAGE\";s:38:\"2 взрослых и 2 ребенка\";s:11:\"MESSAGE_RAW\";s:38:\"2 взрослых и 2 ребенка\";}', '2025-01-10 17:40:35', '2025-01-10 17:40:35', 'F', 'Y', 'ru'),
(57, 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 53, 's1', 'a:28:{s:10:\"RS_FORM_ID\";s:1:\"3\";s:12:\"RS_FORM_NAME\";s:26:\"Забронировать\";s:15:\"RS_FORM_VARNAME\";s:37:\"aspro_allcorp3resort_order_product_s1\";s:11:\"RS_FORM_SID\";s:37:\"aspro_allcorp3resort_order_product_s1\";s:12:\"RS_RESULT_ID\";s:2:\"57\";s:14:\"RS_DATE_CREATE\";s:19:\"10.01.2025 17:42:27\";s:10:\"RS_USER_ID\";s:35:\"не зарегистрирован\";s:13:\"RS_USER_EMAIL\";s:0:\"\";s:12:\"RS_USER_NAME\";s:0:\"\";s:12:\"RS_USER_AUTH\";s:0:\"\";s:16:\"RS_STAT_GUEST_ID\";s:1:\"0\";s:18:\"RS_STAT_SESSION_ID\";s:1:\"0\";s:4:\"NAME\";s:14:\"Евгения\";s:8:\"NAME_RAW\";s:14:\"Евгения\";s:5:\"PHONE\";s:18:\"+7 (925) 568-86-36\";s:9:\"PHONE_RAW\";s:18:\"+7 (925) 568-86-36\";s:4:\"FROM\";s:15:\"16.07.2025 12:0\";s:8:\"FROM_RAW\";s:15:\"16.07.2025 12:0\";s:2:\"TO\";s:15:\"26.07.2025 12:0\";s:6:\"TO_RAW\";s:15:\"26.07.2025 12:0\";s:7:\"PRODUCT\";s:24:\"Номер в отеле\";s:11:\"PRODUCT_RAW\";s:24:\"Номер в отеле\";s:7:\"NUMBERS\";s:6:\"1 [18]\";s:11:\"NUMBERS_RAW\";s:1:\"1\";s:8:\"SERVICES\";s:53:\"Питание [23]<br />Санузел / душ [25]\";s:12:\"SERVICES_RAW\";s:38:\"Питание,Санузел / душ\";s:7:\"MESSAGE\";s:35:\"2 взрослых 2 ребенка\";s:11:\"MESSAGE_RAW\";s:35:\"2 взрослых 2 ребенка\";}', '2025-01-10 17:42:27', '2025-01-10 17:42:28', 'F', 'Y', 'ru'),
(58, 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 58, 's1', 'a:16:{s:10:\"RS_FORM_ID\";s:1:\"8\";s:12:\"RS_FORM_NAME\";s:29:\"Заказать звонок\";s:15:\"RS_FORM_VARNAME\";s:32:\"aspro_allcorp3resort_callback_s1\";s:11:\"RS_FORM_SID\";s:32:\"aspro_allcorp3resort_callback_s1\";s:12:\"RS_RESULT_ID\";s:2:\"58\";s:14:\"RS_DATE_CREATE\";s:19:\"10.01.2025 17:43:33\";s:10:\"RS_USER_ID\";s:35:\"не зарегистрирован\";s:13:\"RS_USER_EMAIL\";s:0:\"\";s:12:\"RS_USER_NAME\";s:0:\"\";s:12:\"RS_USER_AUTH\";s:0:\"\";s:16:\"RS_STAT_GUEST_ID\";s:1:\"0\";s:18:\"RS_STAT_SESSION_ID\";s:1:\"0\";s:4:\"NAME\";s:14:\"Евгения\";s:8:\"NAME_RAW\";s:14:\"Евгения\";s:5:\"PHONE\";s:18:\"+7 (925) 568-86-36\";s:9:\"PHONE_RAW\";s:18:\"+7 (925) 568-86-36\";}', '2025-01-10 17:43:33', '2025-01-10 17:43:33', 'F', 'Y', 'ru'),
(59, 'FORM_FILLING_aspro_allcorp3resort_question_s1', 57, 's1', 'a:22:{s:10:\"RS_FORM_ID\";s:1:\"7\";s:12:\"RS_FORM_NAME\";s:25:\"Задать вопрос\";s:15:\"RS_FORM_VARNAME\";s:32:\"aspro_allcorp3resort_question_s1\";s:11:\"RS_FORM_SID\";s:32:\"aspro_allcorp3resort_question_s1\";s:12:\"RS_RESULT_ID\";s:2:\"59\";s:14:\"RS_DATE_CREATE\";s:19:\"15.01.2025 10:50:53\";s:10:\"RS_USER_ID\";s:35:\"не зарегистрирован\";s:13:\"RS_USER_EMAIL\";s:0:\"\";s:12:\"RS_USER_NAME\";s:0:\"\";s:12:\"RS_USER_AUTH\";s:0:\"\";s:16:\"RS_STAT_GUEST_ID\";s:1:\"0\";s:18:\"RS_STAT_SESSION_ID\";s:1:\"0\";s:4:\"NAME\";s:10:\"Ирина\";s:8:\"NAME_RAW\";s:10:\"Ирина\";s:5:\"PHONE\";s:18:\"+7 (919) 486-94-03\";s:9:\"PHONE_RAW\";s:18:\"+7 (919) 486-94-03\";s:5:\"EMAIL\";s:56:\"<a href=\"mailto:irka_p_2008@bk.ru\">irka_p_2008@bk.ru</a>\";s:9:\"EMAIL_RAW\";s:17:\"irka_p_2008@bk.ru\";s:12:\"NEED_PRODUCT\";s:45:\"База отдыха «Город Моря»\";s:16:\"NEED_PRODUCT_RAW\";s:45:\"База отдыха «Город Моря»\";s:7:\"MESSAGE\";s:47:\"Домик на 5 человек с 14.08-19.08\";s:11:\"MESSAGE_RAW\";s:47:\"Домик на 5 человек с 14.08-19.08\";}', '2025-01-15 10:50:53', '2025-01-15 10:50:53', 'F', 'Y', 'ru');
-- -----------------------------------
-- Dumping table b_event_attachment
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_attachment`;
CREATE TABLE `b_event_attachment` (
  `EVENT_ID` int NOT NULL,
  `FILE_ID` int NOT NULL,
  `IS_FILE_COPIED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`EVENT_ID`,`FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_event_log
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_log`;
CREATE TABLE `b_event_log` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `SEVERITY` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `AUDIT_TYPE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ITEM_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `REMOTE_ADDR` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_AGENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `REQUEST_URI` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `GUEST_ID` int DEFAULT NULL,
  `DESCRIPTION` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `ix_b_event_log_time` (`TIMESTAMP_X`),
  KEY `ix_b_event_log_audit_type_time` (`AUDIT_TYPE_ID`,`TIMESTAMP_X`)
) ENGINE=InnoDB AUTO_INCREMENT=584 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_event_log` VALUES
(574, '2025-01-12 09:29:03', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/food/', 's1', NULL, NULL, ''),
(575, '2025-01-13 09:35:38', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/company/transfer/', 's1', NULL, NULL, ''),
(576, '2025-01-14 09:43:34', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/tours/goor-kakhib/', 's1', NULL, NULL, ''),
(577, '2025-01-15 10:05:39', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/company/vacancy/', 's1', NULL, NULL, ''),
(578, '2025-01-16 10:11:56', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/index.php/jk', 's1', NULL, NULL, ''),
(579, '2025-01-16 18:35:56', 'UNKNOWN', 'MENU_EDIT', 'main', 'UNKNOWN', '185.78.113.109', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 YaBrowser/24.12.0.0 Safari/537.36', '/bitrix/admin/public_menu_edit.php?bxsender=core_window_cdialog&lang=ru&site=s1&back_url=%2F%3Fbitrix_include_areas%3DY&path=%2F&name=bottom4&siteTemplateId=aspro-allcorp3resort', NULL, 1, NULL, 'a:2:{s:9:\"menu_name\";s:0:\"\";s:4:\"path\";s:0:\"\";}'),
(580, '2025-01-16 18:36:34', 'UNKNOWN', 'MENU_DELETE', 'main', 'UNKNOWN', '185.78.113.109', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 YaBrowser/24.12.0.0 Safari/537.36', '/bitrix/admin/public_menu_edit.php?lang=ru&site=s1&back_url=%2F%3Fbitrix_include_areas%3DY%26clear_cache%3DY&path=%2F&name=bottom4&action=delete', NULL, 1, NULL, 'a:2:{s:9:\"menu_name\";N;s:4:\"path\";s:0:\"\";}'),
(581, '2025-01-17 10:13:09', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/price/mangalnye-zony/arenda-oborudovaniya/podstavka-pod-mangal/', 's1', NULL, NULL, ''),
(582, '2025-01-18 10:13:56', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/landings/', 's1', NULL, NULL, ''),
(583, '2025-01-19 11:03:51', 'WARNING', 'SITE_CHECKER_ERROR', 'main', 'CSiteCheckerTest::CommonTest();', '-', '-', '/ra.rar', 's1', NULL, NULL, '');
-- -----------------------------------
-- Dumping table b_event_message
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_message`;
CREATE TABLE `b_event_message` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `EVENT_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `EMAIL_FROM` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '#EMAIL_FROM#',
  `EMAIL_TO` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '#EMAIL_TO#',
  `SUBJECT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MESSAGE` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `MESSAGE_PHP` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `BODY_TYPE` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `BCC` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `REPLY_TO` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CC` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IN_REPLY_TO` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PRIORITY` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD1_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD1_VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD2_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD2_VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SITE_TEMPLATE_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ADDITIONAL_FIELD` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `LANGUAGE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_b_event_message_name` (`EVENT_NAME`(50))
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_event_message` VALUES
(1, '2023-04-27 00:03:09', 'NEW_USER', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#DEFAULT_EMAIL_FROM#', '#SITE_NAME#: Зарегистрировался новый пользователь', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНа сайте #SERVER_NAME# успешно зарегистрирован новый пользователь.\n\nДанные пользователя:\nID пользователя: #USER_ID#\n\nИмя: #NAME#\nФамилия: #LAST_NAME#\nE-Mail: #EMAIL#\n\nLogin: #LOGIN#\n\nПисьмо сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНа сайте <?=$arParams[\"SERVER_NAME\"];?> успешно зарегистрирован новый пользователь.\n\nДанные пользователя:\nID пользователя: <?=$arParams[\"USER_ID\"];?>\n\n\nИмя: <?=$arParams[\"NAME\"];?>\n\nФамилия: <?=$arParams[\"LAST_NAME\"];?>\n\nE-Mail: <?=$arParams[\"EMAIL\"];?>\n\n\nLogin: <?=$arParams[\"LOGIN\"];?>\n\n\nПисьмо сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(2, '2023-04-27 00:03:09', 'USER_INFO', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Регистрационная информация', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n#NAME# #LAST_NAME#,\n\n#MESSAGE#\n\nВаша регистрационная информация:\n\nID пользователя: #USER_ID#\nСтатус профиля: #STATUS#\nLogin: #LOGIN#\n\nВы можете изменить пароль, перейдя по следующей ссылке:\nhttp://#SERVER_NAME#/auth/index.php?change_password=yes&lang=ru&USER_CHECKWORD=#CHECKWORD#&USER_LOGIN=#URL_LOGIN#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n<?=$arParams[\"NAME\"];?> <?=$arParams[\"LAST_NAME\"];?>,\n\n<?=$arParams[\"MESSAGE\"];?>\n\n\nВаша регистрационная информация:\n\nID пользователя: <?=$arParams[\"USER_ID\"];?>\n\nСтатус профиля: <?=$arParams[\"STATUS\"];?>\n\nLogin: <?=$arParams[\"LOGIN\"];?>\n\n\nВы можете изменить пароль, перейдя по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/auth/index.php?change_password=yes&lang=ru&USER_CHECKWORD=<?=$arParams[\"CHECKWORD\"];?>&USER_LOGIN=<?=$arParams[\"URL_LOGIN\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(3, '2023-04-27 00:03:09', 'USER_PASS_REQUEST', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Запрос на смену пароля', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n#NAME# #LAST_NAME#,\n\n#MESSAGE#\n\nДля смены пароля перейдите по следующей ссылке:\nhttp://#SERVER_NAME#/auth/index.php?change_password=yes&lang=ru&USER_CHECKWORD=#CHECKWORD#&USER_LOGIN=#URL_LOGIN#\n\nВаша регистрационная информация:\n\nID пользователя: #USER_ID#\nСтатус профиля: #STATUS#\nLogin: #LOGIN#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n<?=$arParams[\"NAME\"];?> <?=$arParams[\"LAST_NAME\"];?>,\n\n<?=$arParams[\"MESSAGE\"];?>\n\n\nДля смены пароля перейдите по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/auth/index.php?change_password=yes&lang=ru&USER_CHECKWORD=<?=$arParams[\"CHECKWORD\"];?>&USER_LOGIN=<?=$arParams[\"URL_LOGIN\"];?>\n\n\nВаша регистрационная информация:\n\nID пользователя: <?=$arParams[\"USER_ID\"];?>\n\nСтатус профиля: <?=$arParams[\"STATUS\"];?>\n\nLogin: <?=$arParams[\"LOGIN\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(4, '2023-04-27 00:03:09', 'USER_PASS_CHANGED', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Подтверждение смены пароля', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n#NAME# #LAST_NAME#,\n\n#MESSAGE#\n\nВаша регистрационная информация:\n\nID пользователя: #USER_ID#\nСтатус профиля: #STATUS#\nLogin: #LOGIN#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n<?=$arParams[\"NAME\"];?> <?=$arParams[\"LAST_NAME\"];?>,\n\n<?=$arParams[\"MESSAGE\"];?>\n\n\nВаша регистрационная информация:\n\nID пользователя: <?=$arParams[\"USER_ID\"];?>\n\nСтатус профиля: <?=$arParams[\"STATUS\"];?>\n\nLogin: <?=$arParams[\"LOGIN\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(5, '2023-04-27 00:03:09', 'NEW_USER_CONFIRM', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Подтверждение регистрации нового пользователя', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был использован при регистрации нового пользователя на сервере #SERVER_NAME#.\n\nВаш код для подтверждения регистрации: #CONFIRM_CODE#\n\nДля подтверждения регистрации перейдите по следующей ссылке:\nhttp://#SERVER_NAME#/auth/index.php?confirm_registration=yes&confirm_user_id=#USER_ID#&confirm_code=#CONFIRM_CODE#\n\nВы также можете ввести код для подтверждения регистрации на странице:\nhttp://#SERVER_NAME#/auth/index.php?confirm_registration=yes&confirm_user_id=#USER_ID#\n\nВнимание! Ваш профиль не будет активным, пока вы не подтвердите свою регистрацию.\n\n---------------------------------------------------------------------\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был использован при регистрации нового пользователя на сервере <?=$arParams[\"SERVER_NAME\"];?>.\n\nВаш код для подтверждения регистрации: <?=$arParams[\"CONFIRM_CODE\"];?>\n\n\nДля подтверждения регистрации перейдите по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/auth/index.php?confirm_registration=yes&confirm_user_id=<?=$arParams[\"USER_ID\"];?>&confirm_code=<?=$arParams[\"CONFIRM_CODE\"];?>\n\n\nВы также можете ввести код для подтверждения регистрации на странице:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/auth/index.php?confirm_registration=yes&confirm_user_id=<?=$arParams[\"USER_ID\"];?>\n\n\nВнимание! Ваш профиль не будет активным, пока вы не подтвердите свою регистрацию.\n\n---------------------------------------------------------------------\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(6, '2023-04-27 00:03:09', 'USER_INVITE', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Приглашение на сайт', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\nЗдравствуйте, #NAME# #LAST_NAME#!\n\nАдминистратором сайта вы добавлены в число зарегистрированных пользователей.\n\nПриглашаем Вас на наш сайт.\n\nВаша регистрационная информация:\n\nID пользователя: #ID#\nLogin: #LOGIN#\n\nРекомендуем вам сменить установленный автоматически пароль.\n\nДля смены пароля перейдите по следующей ссылке:\nhttp://#SERVER_NAME#/auth.php?change_password=yes&USER_LOGIN=#URL_LOGIN#&USER_CHECKWORD=#CHECKWORD#\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\nЗдравствуйте, <?=$arParams[\"NAME\"];?> <?=$arParams[\"LAST_NAME\"];?>!\n\nАдминистратором сайта вы добавлены в число зарегистрированных пользователей.\n\nПриглашаем Вас на наш сайт.\n\nВаша регистрационная информация:\n\nID пользователя: <?=$arParams[\"ID\"];?>\n\nLogin: <?=$arParams[\"LOGIN\"];?>\n\n\nРекомендуем вам сменить установленный автоматически пароль.\n\nДля смены пароля перейдите по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/auth.php?change_password=yes&USER_LOGIN=<?=$arParams[\"URL_LOGIN\"];?>&USER_CHECKWORD=<?=$arParams[\"CHECKWORD\"];?>\n\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(7, '2023-04-27 00:03:09', 'FEEDBACK_FORM', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: Сообщение из формы обратной связи', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВам было отправлено сообщение через форму обратной связи\n\nАвтор: #AUTHOR#\nE-mail автора: #AUTHOR_EMAIL#\n\nТекст сообщения:\n#TEXT#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВам было отправлено сообщение через форму обратной связи\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nE-mail автора: <?=$arParams[\"AUTHOR_EMAIL\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"TEXT\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(8, '2023-04-27 00:03:09', 'MAIN_MAIL_CONFIRM_CODE', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#MESSAGE_SUBJECT#', '<? EventMessageThemeCompiler::includeComponent(\'bitrix:main.mail.confirm\', \'\', $arParams); ?>', '<? EventMessageThemeCompiler::includeComponent(\'bitrix:main.mail.confirm\', \'\', $arParams); ?>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'mail_join', NULL, NULL),
(9, '2023-04-27 00:03:09', 'EVENT_LOG_NOTIFICATION', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', 'Оповещение журнала событий: #NAME#', 'Зафиксированы события в журнале, соответствующие параметрам оповещения:\n\nТип события: #AUDIT_TYPE_ID#\nОбъект: #ITEM_ID#\nПользователь: #USER_ID# \nIP-адрес: #REMOTE_ADDR#\nБраузер: #USER_AGENT#\nСтраница: #REQUEST_URI# \n\nКоличество записей: #EVENT_COUNT# \n\n#ADDITIONAL_TEXT#\n\nПерейти в журнал событий:\nhttp://#SERVER_NAME#/bitrix/admin/event_log.php?set_filter=Y&find_audit_type_id=#AUDIT_TYPE_ID#', 'Зафиксированы события в журнале, соответствующие параметрам оповещения:\n\nТип события: <?=$arParams[\"AUDIT_TYPE_ID\"];?>\n\nОбъект: <?=$arParams[\"ITEM_ID\"];?>\n\nПользователь: <?=$arParams[\"USER_ID\"];?> \nIP-адрес: <?=$arParams[\"REMOTE_ADDR\"];?>\n\nБраузер: <?=$arParams[\"USER_AGENT\"];?>\n\nСтраница: <?=$arParams[\"REQUEST_URI\"];?> \n\nКоличество записей: <?=$arParams[\"EVENT_COUNT\"];?> \n\n<?=$arParams[\"ADDITIONAL_TEXT\"];?>\n\n\nПерейти в журнал событий:\nhttp://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/event_log.php?set_filter=Y&find_audit_type_id=<?=$arParams[\"AUDIT_TYPE_ID\"];?>', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(10, '2023-04-27 00:03:09', 'USER_CODE_REQUEST', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Запрос кода авторизации', 'Используйте для авторизации код:\n\n#CHECKWORD#\n\nПосле авторизации вы сможете изменить свой пароль в редактировании профиля.\n\nВаша регистрационная информация:\n\nID пользователя: #USER_ID#\nСтатус профиля: #STATUS#\nЛогин: #LOGIN#\n\nСообщение создано автоматически.', 'Используйте для авторизации код:\n\n<?=$arParams[\"CHECKWORD\"];?>\n\n\nПосле авторизации вы сможете изменить свой пароль в редактировании профиля.\n\nВаша регистрационная информация:\n\nID пользователя: <?=$arParams[\"USER_ID\"];?>\n\nСтатус профиля: <?=$arParams[\"STATUS\"];?>\n\nЛогин: <?=$arParams[\"LOGIN\"];?>\n\n\nСообщение создано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(11, '2023-04-27 00:03:13', 'NEW_BLOG_MESSAGE', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] #BLOG_NAME# : #MESSAGE_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовое сообщение в блоге \"#BLOG_NAME#\"\n\nТема:\n#MESSAGE_TITLE#\n\nАвтор: #AUTHOR#\nДата: #MESSAGE_DATE#\n\nТекст сообщения:\n#MESSAGE_TEXT#\n\nАдрес сообщения:\n#MESSAGE_PATH#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовое сообщение в блоге \"<?=$arParams[\"BLOG_NAME\"];?>\"\n\nТема:\n<?=$arParams[\"MESSAGE_TITLE\"];?>\n\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата: <?=$arParams[\"MESSAGE_DATE\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"MESSAGE_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"MESSAGE_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(12, '2023-04-27 00:03:13', 'NEW_BLOG_COMMENT', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] #MESSAGE_TITLE# : #COMMENT_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовый комментарий в блоге \"#BLOG_NAME#\" на сообщение \"#MESSAGE_TITLE#\"\n\nТема:\n#COMMENT_TITLE#\nАвтор: #AUTHOR#\nДата: #COMMENT_DATE#\n\nТекст сообщения:\n#COMMENT_TEXT#\n\nАдрес сообщения:\n#COMMENT_PATH#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовый комментарий в блоге \"<?=$arParams[\"BLOG_NAME\"];?>\" на сообщение \"<?=$arParams[\"MESSAGE_TITLE\"];?>\"\n\nТема:\n<?=$arParams[\"COMMENT_TITLE\"];?>\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата: <?=$arParams[\"COMMENT_DATE\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"COMMENT_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"COMMENT_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(13, '2023-04-27 00:03:13', 'NEW_BLOG_COMMENT2COMMENT', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] #MESSAGE_TITLE# : #COMMENT_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовый комментарий на ваш комментарий в блоге \"#BLOG_NAME#\" на сообщение \"#MESSAGE_TITLE#\".\n\nТема:\n#COMMENT_TITLE#\nАвтор: #AUTHOR#\nДата: #COMMENT_DATE#\n\nТекст сообщения:\n#COMMENT_TEXT#\n\nАдрес сообщения:\n#COMMENT_PATH#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовый комментарий на ваш комментарий в блоге \"<?=$arParams[\"BLOG_NAME\"];?>\" на сообщение \"<?=$arParams[\"MESSAGE_TITLE\"];?>\".\n\nТема:\n<?=$arParams[\"COMMENT_TITLE\"];?>\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата: <?=$arParams[\"COMMENT_DATE\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"COMMENT_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"COMMENT_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(14, '2023-04-27 00:03:13', 'NEW_BLOG_COMMENT_WITHOUT_TITLE', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] #MESSAGE_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовый комментарий в блоге \"#BLOG_NAME#\" на сообщение \"#MESSAGE_TITLE#\"\n\nАвтор: #AUTHOR#\nДата: #COMMENT_DATE#\n\nТекст сообщения:\n#COMMENT_TEXT#\n\nАдрес сообщения:\n#COMMENT_PATH#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовый комментарий в блоге \"<?=$arParams[\"BLOG_NAME\"];?>\" на сообщение \"<?=$arParams[\"MESSAGE_TITLE\"];?>\"\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата: <?=$arParams[\"COMMENT_DATE\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"COMMENT_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"COMMENT_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(15, '2023-04-27 00:03:13', 'NEW_BLOG_COMMENT2COMMENT_WITHOUT_TITLE', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] #MESSAGE_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовый комментарий на ваш комментарий в блоге \"#BLOG_NAME#\" на сообщение \"#MESSAGE_TITLE#\".\n\nАвтор: #AUTHOR#\nДата: #COMMENT_DATE#\n\nТекст сообщения:\n#COMMENT_TEXT#\n\nАдрес сообщения:\n#COMMENT_PATH#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовый комментарий на ваш комментарий в блоге \"<?=$arParams[\"BLOG_NAME\"];?>\" на сообщение \"<?=$arParams[\"MESSAGE_TITLE\"];?>\".\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата: <?=$arParams[\"COMMENT_DATE\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"COMMENT_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"COMMENT_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(16, '2023-04-27 00:03:13', 'BLOG_YOUR_BLOG_TO_USER', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] Ваш блог \"#BLOG_NAME#\" был добавлен в друзья к #USER#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВаш блог \"#BLOG_NAME#\" был добавлен в друзья к #USER#.\n\nПрофиль пользователя: #USER_URL#\n\nАдрес вашего блога: #BLOG_ADR#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВаш блог \"<?=$arParams[\"BLOG_NAME\"];?>\" был добавлен в друзья к <?=$arParams[\"USER\"];?>.\n\nПрофиль пользователя: <?=$arParams[\"USER_URL\"];?>\n\n\nАдрес вашего блога: <?=$arParams[\"BLOG_ADR\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(17, '2023-04-27 00:03:13', 'BLOG_YOU_TO_BLOG', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] Вы были добавлены в друзья блога \"#BLOG_NAME#\"', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВы были добавлены в друзья блога \"#BLOG_NAME#\".\n\nАдрес блога: #BLOG_ADR#\n\nВаш профиль: #USER_URL#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВы были добавлены в друзья блога \"<?=$arParams[\"BLOG_NAME\"];?>\".\n\nАдрес блога: <?=$arParams[\"BLOG_ADR\"];?>\n\n\nВаш профиль: <?=$arParams[\"USER_URL\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(18, '2023-04-27 00:03:13', 'BLOG_BLOG_TO_YOU', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] К вам в друзья был добавлен блог \"#BLOG_NAME#\"', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nК вам в друзья был добавлен блог \"#BLOG_NAME#\".\n\nАдрес блога: #BLOG_ADR#\n\nВаш профиль: #USER_URL#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nК вам в друзья был добавлен блог \"<?=$arParams[\"BLOG_NAME\"];?>\".\n\nАдрес блога: <?=$arParams[\"BLOG_ADR\"];?>\n\n\nВаш профиль: <?=$arParams[\"USER_URL\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(19, '2023-04-27 00:03:13', 'BLOG_USER_TO_YOUR_BLOG', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [B] В ваш блог \"#BLOG_NAME#\" был добавлен друг #USER#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВ ваш блог \"#BLOG_NAME#\" был добавлен друг #USER#.\n\nПрофиль пользователя: #USER_URL#\n\nАдрес вашего блога: #BLOG_ADR#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВ ваш блог \"<?=$arParams[\"BLOG_NAME\"];?>\" был добавлен друг <?=$arParams[\"USER\"];?>.\n\nПрофиль пользователя: <?=$arParams[\"USER_URL\"];?>\n\n\nАдрес вашего блога: <?=$arParams[\"BLOG_ADR\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(20, '2023-04-27 00:03:13', 'BLOG_SONET_NEW_POST', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#POST_TITLE#', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post.mail\",\"\",Array(\"EMAIL_TO\" => \"{#EMAIL_TO#}\",\"RECIPIENT_ID\" => \"{#RECIPIENT_ID#}\",\"POST_ID\" => \"{#POST_ID#}\",\"URL\" => \"{#URL#}\"));?>', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post.mail\",\"\",Array(\"EMAIL_TO\" => \"{$arParams[\'EMAIL_TO\']}\",\"RECIPIENT_ID\" => \"{$arParams[\'RECIPIENT_ID\']}\",\"POST_ID\" => \"{$arParams[\'POST_ID\']}\",\"URL\" => \"{$arParams[\'URL\']}\"));?>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'mail_user', NULL, NULL),
(21, '2023-04-27 00:03:13', 'BLOG_SONET_NEW_COMMENT', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', 'Re: #POST_TITLE#', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post.comment.mail\",\"\",Array(\"COMMENT_ID\" => \"{#COMMENT_ID#}\",\"RECIPIENT_ID\" => \"{#RECIPIENT_ID#}\",\"EMAIL_TO\" => \"{#EMAIL_TO#}\",\"POST_ID\" => \"{#POST_ID#}\",\"URL\" => \"{#URL#}\"));?>', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post.comment.mail\",\"\",Array(\"COMMENT_ID\" => \"{$arParams[\'COMMENT_ID\']}\",\"RECIPIENT_ID\" => \"{$arParams[\'RECIPIENT_ID\']}\",\"EMAIL_TO\" => \"{$arParams[\'EMAIL_TO\']}\",\"POST_ID\" => \"{$arParams[\'POST_ID\']}\",\"URL\" => \"{$arParams[\'URL\']}\"));?>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'mail_user', NULL, NULL),
(22, '2023-04-27 00:03:13', 'BLOG_SONET_POST_SHARE', 's1', 'Y', '#EMAIL_FROM#', '#EMAIL_TO#', '#POST_TITLE#', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post_share.mail\",\"\",Array(\"EMAIL_TO\" => \"{#EMAIL_TO#}\",\"RECIPIENT_ID\" => \"{#RECIPIENT_ID#}\",\"POST_ID\" => \"{#POST_ID#}\",\"URL\" => \"{#URL#}\"));?>', '<?EventMessageThemeCompiler::includeComponent(\"bitrix:socialnetwork.blog.post_share.mail\",\"\",Array(\"EMAIL_TO\" => \"{$arParams[\'EMAIL_TO\']}\",\"RECIPIENT_ID\" => \"{$arParams[\'RECIPIENT_ID\']}\",\"POST_ID\" => \"{$arParams[\'POST_ID\']}\",\"URL\" => \"{$arParams[\'URL\']}\"));?>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'mail_user', NULL, NULL),
(23, '2023-04-27 00:03:13', 'BLOG_POST_BROADCAST', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: #MESSAGE_TITLE#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНа сайте добавлено новое сообщение.\n\nТема:\n#MESSAGE_TITLE#\n\nАвтор: #AUTHOR#\n\nТекст сообщения:\n#MESSAGE_TEXT#\n\nАдрес сообщения:\n#MESSAGE_PATH#\n\nСообщение сгенерировано автоматически.', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНа сайте добавлено новое сообщение.\n\nТема:\n<?=$arParams[\"MESSAGE_TITLE\"];?>\n\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\n\nТекст сообщения:\n<?=$arParams[\"MESSAGE_TEXT\"];?>\n\n\nАдрес сообщения:\n<?=$arParams[\"MESSAGE_PATH\"];?>\n\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(24, '2023-04-27 00:03:14', 'CATALOG_PRODUCT_SUBSCRIBE_LIST_CONFIRM', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: Код подтверждения', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Информационное сообщение сайта #SITE_NAME#</td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, #USER_NAME#!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nВы получили это сообщение, так как на ваш адрес был запрошен код подтверждения для доступа к подпискам сайта #SERVER_NAME#. <br><br> \nВаш код для подтверждения подписки: #TOKEN# <br><br> \nДля получения доступа к подпискам перейдите по следующей ссылке: #TOKEN_URL# <br><br>\nВы также можете ввести код на странице: #LIST_SUBSCRIBES# <br><br>\nПисьмо содержит информацию для авторизации.<br>\nИспользуя код подтверждения, вы cможете получить доступ к списку подписок.<br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:#DEFAULT_EMAIL_FROM#\" style=\"color:#2e6eb6;\">#DEFAULT_EMAIL_FROM#</a>\n							\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?></td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, <?=$arParams[\"USER_NAME\"];?>!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nВы получили это сообщение, так как на ваш адрес был запрошен код подтверждения для доступа к подпискам сайта <?=$arParams[\"SERVER_NAME\"];?>. <br><br> \nВаш код для подтверждения подписки: <?=$arParams[\"TOKEN\"];?> <br><br> \nДля получения доступа к подпискам перейдите по следующей ссылке: <?=$arParams[\"TOKEN_URL\"];?> <br><br>\nВы также можете ввести код на странице: <?=$arParams[\"LIST_SUBSCRIBES\"];?> <br><br>\nПисьмо содержит информацию для авторизации.<br>\nИспользуя код подтверждения, вы cможете получить доступ к списку подписок.<br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:<?=$arParams[\"DEFAULT_EMAIL_FROM\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"DEFAULT_EMAIL_FROM\"];?></a>\n							\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(25, '2023-04-27 00:03:14', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: Уведомление о поступлении товара', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Уведомление о поступлении товара в магазин #SITE_NAME#</td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, #USER_NAME#!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nТовар \"#NAME#\" (#PAGE_URL#) поступил на склад.<br><br>\nВы просили оповестить вас о поступлении товара.<br><br>\nТовар поступил к нам в магазин, вы можете оформить заказ прямо сейчас: (#CHECKOUT_URL#)<br><br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:#DEFAULT_EMAIL_FROM#\" style=\"color:#2e6eb6;\">#DEFAULT_EMAIL_FROM#</a>\n							<br><a href=\"#UNSUBSCRIBE_URL#\">Отписаться</a>\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Уведомление о поступлении товара в магазин <?=$arParams[\"SITE_NAME\"];?></td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, <?=$arParams[\"USER_NAME\"];?>!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nТовар \"<?=$arParams[\"NAME\"];?>\" (<?=$arParams[\"PAGE_URL\"];?>) поступил на склад.<br><br>\nВы просили оповестить вас о поступлении товара.<br><br>\nТовар поступил к нам в магазин, вы можете оформить заказ прямо сейчас: (<?=$arParams[\"CHECKOUT_URL\"];?>)<br><br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:<?=$arParams[\"DEFAULT_EMAIL_FROM\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"DEFAULT_EMAIL_FROM\"];?></a>\n							<br><a href=\"<?=$arParams[\"UNSUBSCRIBE_URL\"];?>\">Отписаться</a>\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(26, '2023-04-27 00:03:14', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY_REPEATED', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', 'Уведомление о товаре в магазине #SITE_NAME#', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Уведомление о товаре в магазине #SITE_NAME#</td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, #USER_NAME#!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nТовар \"#NAME#\" (#PAGE_URL#) к сожалению снова закончился.<br><br>\nМы обязательно сообщим вам о поступлении товара.<br><br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:#DEFAULT_EMAIL_FROM#\" style=\"color:#2e6eb6;\">#DEFAULT_EMAIL_FROM#</a>\n							<br><a href=\"#UNSUBSCRIBE_URL#\">Отписаться</a>\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', '\n			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n			<html xmlns=\"http://www.w3.org/1999/xhtml\">\n			<head>\n				<style>\n					body\n					{\n						font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n						font-size: 14px;\n						color: #000;\n					}\n				</style>\n			</head>\n			<body>\n			<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; \n				border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n				<tr>\n					<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; \n						padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n						<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n							<tr>\n								<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: \n								center; font-size: 26px; color: #0b3961;\">Уведомление о товаре в магазине <?=$arParams[\"SITE_NAME\"];?></td>\n							</tr>\n							<tr>\n								<td bgcolor=\"#bad3df\" height=\"11\"></td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n				<tr>\n					<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n						<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, <?=$arParams[\"USER_NAME\"];?>!</p>\n						<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">\nТовар \"<?=$arParams[\"NAME\"];?>\" (<?=$arParams[\"PAGE_URL\"];?>) к сожалению снова закончился.<br><br>\nМы обязательно сообщим вам о поступлении товара.<br><br>\nНе отвечайте на письмо, оно сформировано автоматически.<br><br>\nСпасибо, что вы с нами!<br>\n</p>\n					</td>\n				</tr>\n				<tr>\n					<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; \n						padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n						<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; \n							line-height:21px;\">С уважением, администрация \n							<a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n							E-mail: <a href=\"mailto:<?=$arParams[\"DEFAULT_EMAIL_FROM\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"DEFAULT_EMAIL_FROM\"];?></a>\n							<br><a href=\"<?=$arParams[\"UNSUBSCRIBE_URL\"];?>\">Отписаться</a>\n						</p>\n					</td>\n				</tr>\n			</table>\n			</body>\n			</html>\n		', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(27, '2023-04-27 00:03:17', 'NEW_FORUM_MESSAGE', 's1', 'Y', '#FROM_EMAIL#', '#RECIPIENT#', '#SITE_NAME#: [F] #TOPIC_TITLE# : #FORUM_NAME#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nНовое сообщение на форуме #SERVER_NAME#.\n\nТема:\n#TOPIC_TITLE#\n\nАвтор: #AUTHOR#\nДата : #MESSAGE_DATE#\nТекст сообщения:\n\n#MESSAGE_TEXT#\n\nАдрес сообщения:\nhttp://#SERVER_NAME##PATH2FORUM#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nНовое сообщение на форуме <?=$arParams[\"SERVER_NAME\"];?>.\n\nТема:\n<?=$arParams[\"TOPIC_TITLE\"];?>\n\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата : <?=$arParams[\"MESSAGE_DATE\"];?>\n\nТекст сообщения:\n\n<?=$arParams[\"MESSAGE_TEXT\"];?>\n\n\nАдрес сообщения:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"PATH2FORUM\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(28, '2023-04-27 00:03:17', 'NEW_FORUM_PRIV', 's1', 'Y', '#FROM_EMAIL#', '#TO_EMAIL#', '#SITE_NAME#: [private] #SUBJECT#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВы получили персональное сообщение с форума на сайте #SERVER_NAME#.\n\nТема: #SUBJECT#\n\nАвтор: #FROM_NAME# #FROM_EMAIL#\nДата : #MESSAGE_DATE#\nСообщение:\n\n#MESSAGE#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВы получили персональное сообщение с форума на сайте <?=$arParams[\"SERVER_NAME\"];?>.\n\nТема: <?=$arParams[\"SUBJECT\"];?>\n\n\nАвтор: <?=$arParams[\"FROM_NAME\"];?> <?=$arParams[\"FROM_EMAIL\"];?>\n\nДата : <?=$arParams[\"MESSAGE_DATE\"];?>\n\nСообщение:\n\n<?=$arParams[\"MESSAGE\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(29, '2023-04-27 00:03:17', 'NEW_FORUM_PRIVATE_MESSAGE', 's1', 'Y', '#FROM_EMAIL#', '#TO_EMAIL#', '#SITE_NAME#: [private] #SUBJECT#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nВы получили персональное сообщение с форума на сайте #SERVER_NAME#.\n\nТема: #SUBJECT#\n\nАвтор: #FROM_NAME#\nДата: #MESSAGE_DATE#\nСообщение:\n\n#MESSAGE#\n\nСсылка на сообщение: #MESSAGE_LINK#Сообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nВы получили персональное сообщение с форума на сайте <?=$arParams[\"SERVER_NAME\"];?>.\n\nТема: <?=$arParams[\"SUBJECT\"];?>\n\n\nАвтор: <?=$arParams[\"FROM_NAME\"];?>\n\nДата: <?=$arParams[\"MESSAGE_DATE\"];?>\n\nСообщение:\n\n<?=$arParams[\"MESSAGE\"];?>\n\n\nСсылка на сообщение: <?=$arParams[\"MESSAGE_LINK\"];?>Сообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(30, '2023-04-27 00:03:17', 'EDIT_FORUM_MESSAGE', 's1', 'Y', '#FROM_EMAIL#', '#RECIPIENT#', '#SITE_NAME#: [F] #TOPIC_TITLE# : #FORUM_NAME#', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nИзменение сообщения на форуме #SERVER_NAME#.\n\nТема:\n#TOPIC_TITLE#\n\nАвтор: #AUTHOR#\nДата : #MESSAGE_DATE#\nТекст сообщения:\n\n#MESSAGE_TEXT#\n\nАдрес сообщения:\nhttp://#SERVER_NAME##PATH2FORUM#\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nИзменение сообщения на форуме <?=$arParams[\"SERVER_NAME\"];?>.\n\nТема:\n<?=$arParams[\"TOPIC_TITLE\"];?>\n\n\nАвтор: <?=$arParams[\"AUTHOR\"];?>\n\nДата : <?=$arParams[\"MESSAGE_DATE\"];?>\n\nТекст сообщения:\n\n<?=$arParams[\"MESSAGE_TEXT\"];?>\n\n\nАдрес сообщения:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"PATH2FORUM\"];?>\n\n\nСообщение сгенерировано автоматически.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(31, '2023-04-27 00:03:17', 'FORUM_NEW_MESSAGE_MAIL', 's1', 'Y', '#FROM_EMAIL#', '#RECIPIENT#', '#TOPIC_TITLE#', '#MESSAGE_TEXT#\n\n------------------------------------------  \nВы получили это сообщение, так как выподписаны на форум #FORUM_NAME#.\n\nОтветить на сообщение можно по электронной почте или через форму на сайте:\nhttp://#SERVER_NAME##PATH2FORUM#\n\nНаписать новое сообщение: #FORUM_EMAIL#\n\nАвтор сообщения: #AUTHOR#\n\nСообщение сгенерировано автоматически на сайте #SITE_NAME#.\n', '<?=$arParams[\"MESSAGE_TEXT\"];?>\n\n\n------------------------------------------  \nВы получили это сообщение, так как выподписаны на форум <?=$arParams[\"FORUM_NAME\"];?>.\n\nОтветить на сообщение можно по электронной почте или через форму на сайте:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"PATH2FORUM\"];?>\n\n\nНаписать новое сообщение: <?=$arParams[\"FORUM_EMAIL\"];?>\n\n\nАвтор сообщения: <?=$arParams[\"AUTHOR\"];?>\n\n\nСообщение сгенерировано автоматически на сайте <?=$arParams[\"SITE_NAME\"];?>.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(32, '2023-04-27 00:03:26', 'SALE_NEW_ORDER', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Новый заказ N#ORDER_ID#', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вами оформлен заказ в магазине #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый #ORDER_USER#,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Ваш заказ номер #ORDER_ID# от #ORDER_DATE# принят.<br />\n<br />\nСтоимость заказа: #PRICE#.<br />\n<br />\nСостав заказа:<br />\n#ORDER_LIST#<br />\n<br />\nВы можете следить за выполнением своего заказа (на какой стадии выполнения он находится), войдя в Ваш персональный раздел сайта #SITE_NAME#.<br />\n<br />\nОбратите внимание, что для входа в этот раздел Вам необходимо будет ввести логин и пароль пользователя сайта #SITE_NAME#.<br />\n<br />\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией отмены заказа, которая доступна в Вашем персональном разделе сайта #SITE_NAME#.<br />\n<br />\nПожалуйста, при обращении к администрации сайта #SITE_NAME# ОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - #ORDER_ID#.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вами оформлен заказ в магазине <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый <?=$arParams[\"ORDER_USER\"];?>,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Ваш заказ номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> принят.<br />\n<br />\nСтоимость заказа: <?=$arParams[\"PRICE\"];?>.<br />\n<br />\nСостав заказа:<br />\n<?=$arParams[\"ORDER_LIST\"];?><br />\n<br />\nВы можете следить за выполнением своего заказа (на какой стадии выполнения он находится), войдя в Ваш персональный раздел сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nОбратите внимание, что для входа в этот раздел Вам необходимо будет ввести логин и пароль пользователя сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией отмены заказа, которая доступна в Вашем персональном разделе сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nПожалуйста, при обращении к администрации сайта <?=$arParams[\"SITE_NAME\"];?> ОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - <?=$arParams[\"ORDER_ID\"];?>.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(33, '2023-04-27 00:03:26', 'SALE_ORDER_CANCEL', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Отмена заказа N#ORDER_ID#', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">#SITE_NAME#: Отмена заказа N#ORDER_ID#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Заказ номер #ORDER_ID# от #ORDER_DATE# отменен.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">#ORDER_CANCEL_DESCRIPTION#<br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт http://#SERVER_NAME#/personal/order/#ORDER_ACCOUNT_NUMBER_ENCODE#/<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\"><?=$arParams[\"SITE_NAME\"];?>: Отмена заказа N<?=$arParams[\"ORDER_ID\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Заказ номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> отменен.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><?=$arParams[\"ORDER_CANCEL_DESCRIPTION\"];?><br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт http://<?=$arParams[\"SERVER_NAME\"];?>/personal/order/<?=$arParams[\"ORDER_ACCOUNT_NUMBER_ENCODE\"];?>/<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(34, '2023-04-27 00:03:26', 'SALE_ORDER_DELIVERY', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Доставка заказа N#ORDER_ID# разрешена', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Доставка вашего заказа с сайта #SITE_NAME# разрешена</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Доставка заказа номер #ORDER_ID# от #ORDER_DATE# разрешена.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Для получения подробной информации по заказу пройдите на сайт http://#SERVER_NAME#/personal/order/#ORDER_ACCOUNT_NUMBER_ENCODE#/<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Доставка вашего заказа с сайта <?=$arParams[\"SITE_NAME\"];?> разрешена</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Доставка заказа номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> разрешена.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Для получения подробной информации по заказу пройдите на сайт http://<?=$arParams[\"SERVER_NAME\"];?>/personal/order/<?=$arParams[\"ORDER_ACCOUNT_NUMBER_ENCODE\"];?>/<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(35, '2023-04-27 00:03:26', 'SALE_ORDER_PAID', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Заказ N#ORDER_ID# оплачен', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вы оплатили заказ на сайте #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Заказ номер #ORDER_ID# от #ORDER_DATE# оплачен.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Для получения подробной информации по заказу пройдите на сайт http://#SERVER_NAME#/personal/order/#ORDER_ACCOUNT_NUMBER_ENCODE#/</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вы оплатили заказ на сайте <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Заказ номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> оплачен.</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Для получения подробной информации по заказу пройдите на сайт http://<?=$arParams[\"SERVER_NAME\"];?>/personal/order/<?=$arParams[\"ORDER_ACCOUNT_NUMBER_ENCODE\"];?>/</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(36, '2023-04-27 00:03:26', 'SALE_ORDER_REMIND_PAYMENT', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Напоминание об оплате заказа N#ORDER_ID# ', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Напоминаем вам об оплате заказа на сайте #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый #ORDER_USER#,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Вами был оформлен заказ N #ORDER_ID# от #ORDER_DATE# на сумму #PRICE#.<br />\n<br />\nК сожалению, на сегодняшний день средства по этому заказу не поступили к нам.<br />\n<br />\nВы можете следить за выполнением своего заказа (на какой стадии выполнения он находится), войдя в Ваш персональный раздел сайта #SITE_NAME#.<br />\n<br />\nОбратите внимание, что для входа в этот раздел Вам необходимо будет ввести логин и пароль пользователя сайта #SITE_NAME#.<br />\n<br />\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией отмены заказа, которая доступна в Вашем персональном разделе сайта #SITE_NAME#.<br />\n<br />\nПожалуйста, при обращении к администрации сайта #SITE_NAME# ОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - #ORDER_ID#.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Напоминаем вам об оплате заказа на сайте <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый <?=$arParams[\"ORDER_USER\"];?>,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Вами был оформлен заказ N <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> на сумму <?=$arParams[\"PRICE\"];?>.<br />\n<br />\nК сожалению, на сегодняшний день средства по этому заказу не поступили к нам.<br />\n<br />\nВы можете следить за выполнением своего заказа (на какой стадии выполнения он находится), войдя в Ваш персональный раздел сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nОбратите внимание, что для входа в этот раздел Вам необходимо будет ввести логин и пароль пользователя сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией отмены заказа, которая доступна в Вашем персональном разделе сайта <?=$arParams[\"SITE_NAME\"];?>.<br />\n<br />\nПожалуйста, при обращении к администрации сайта <?=$arParams[\"SITE_NAME\"];?> ОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - <?=$arParams[\"ORDER_ID\"];?>.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(37, '2023-04-27 00:03:26', 'SALE_SUBSCRIBE_PRODUCT', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Уведомление о поступлении товара', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Уведомление о поступлении товара в магазин #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, #USER_NAME#!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Товар \"#NAME#\" (#PAGE_URL#) поступил на склад.<br />\n<br />\nВы можете Оформить заказ (http://#SERVER_NAME#/personal/cart/).<br />\n<br />\nНе забудьте авторизоваться!<br />\n<br />\nВы получили это сообщение по Вашей просьбе оповестить при появлении товара.<br />\nНе отвечайте на него - письмо сформировано автоматически.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Уведомление о поступлении товара в магазин <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый, <?=$arParams[\"USER_NAME\"];?>!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Товар \"<?=$arParams[\"NAME\"];?>\" (<?=$arParams[\"PAGE_URL\"];?>) поступил на склад.<br />\n<br />\nВы можете Оформить заказ (http://<?=$arParams[\"SERVER_NAME\"];?>/personal/cart/).<br />\n<br />\nНе забудьте авторизоваться!<br />\n<br />\nВы получили это сообщение по Вашей просьбе оповестить при появлении товара.<br />\nНе отвечайте на него - письмо сформировано автоматически.<br />\n<br />\nСпасибо за покупку!<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(38, '2023-04-27 00:03:26', 'SALE_ORDER_TRACKING_NUMBER', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', 'Номер идентификатора отправления вашего заказа на сайте #SITE_NAME#', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Номер идентификатора отправления вашего заказа на сайте #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый #ORDER_USER#,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Произошла почтовая отправка заказа N #ORDER_ID# от #ORDER_DATE#.<br />\n<br />\nНомер идентификатора отправления: #ORDER_TRACKING_NUMBER#.<br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт http://#SERVER_NAME#/personal/order/detail/#ORDER_ACCOUNT_NUMBER_ENCODE#/<br />\n<br />\nE-mail: #SALE_EMAIL#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Номер идентификатора отправления вашего заказа на сайте <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый <?=$arParams[\"ORDER_USER\"];?>,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Произошла почтовая отправка заказа N <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?>.<br />\n<br />\nНомер идентификатора отправления: <?=$arParams[\"ORDER_TRACKING_NUMBER\"];?>.<br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт http://<?=$arParams[\"SERVER_NAME\"];?>/personal/order/detail/<?=$arParams[\"ORDER_ACCOUNT_NUMBER_ENCODE\"];?>/<br />\n<br />\nE-mail: <?=$arParams[\"SALE_EMAIL\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(39, '2023-04-27 00:03:26', 'SALE_CHECK_PRINT', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', 'Ссылка на чек', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вы оплатили заказ на сайте #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый #ORDER_USER#,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nСогласно требованиям закона ФЗ-54 о фискальных чеках по вашему заказу произведена оплата и сформирован фискальный кассовый чек, который вы можете посмотреть по ссылке:<br />\n<br />\n#CHECK_LINK#<br />\n<br />\nДля получения подробной информации по заказу №#ORDER_ID# от #ORDER_DATE# пройдите на сайт #LINK_URL#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Вы оплатили заказ на сайте <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый <?=$arParams[\"ORDER_USER\"];?>,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nСогласно требованиям закона ФЗ-54 о фискальных чеках по вашему заказу произведена оплата и сформирован фискальный кассовый чек, который вы можете посмотреть по ссылке:<br />\n<br />\n<?=$arParams[\"CHECK_LINK\"];?><br />\n<br />\nДля получения подробной информации по заказу №<?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> пройдите на сайт <?=$arParams[\"LINK_URL\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(40, '2023-04-27 00:03:26', 'SALE_CHECK_PRINT_ERROR', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', 'Ошибка при печати чека', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Ошибка при печати чека</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Здравствуйте!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nПо какой-то причине чек №#CHECK_ID# по заказу №#ORDER_ACCOUNT_NUMBER# от #ORDER_DATE# не удалось распечатать!<br />\n<br />\nПерейдите по ссылке, чтобы устранить причину возникшей ситуации:<br />\n#LINK_URL#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Ошибка при печати чека</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Здравствуйте!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nПо какой-то причине чек №<?=$arParams[\"CHECK_ID\"];?> по заказу №<?=$arParams[\"ORDER_ACCOUNT_NUMBER\"];?> от <?=$arParams[\"ORDER_DATE\"];?> не удалось распечатать!<br />\n<br />\nПерейдите по ссылке, чтобы устранить причину возникшей ситуации:<br />\n<?=$arParams[\"LINK_URL\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(41, '2023-04-27 00:03:26', 'SALE_ORDER_SHIPMENT_STATUS_CHANGED', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', 'Статус почтового отправления вашего заказа на сайте #SITE_NAME# изменился', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменился статус почтового отправления заказа на сайте #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый #ORDER_USER#,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Статус почтового отправления по заказу № #ORDER_NO# от #ORDER_DATE#<br />\n<br />\nизменил значение на \"#STATUS_NAME#\" (#STATUS_DESCRIPTION#).<br />\n<br />\nИдентификатор отправления: #TRACKING_NUMBER#.<br />\n<br />\nНаименование службы доставки: #DELIVERY_NAME#.<br />\n<br />\n#DELIVERY_TRACKING_URL##ORDER_DETAIL_URL#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменился статус почтового отправления заказа на сайте <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Уважаемый <?=$arParams[\"ORDER_USER\"];?>,</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Статус почтового отправления по заказу № <?=$arParams[\"ORDER_NO\"];?> от <?=$arParams[\"ORDER_DATE\"];?><br />\n<br />\nизменил значение на \"<?=$arParams[\"STATUS_NAME\"];?>\" (<?=$arParams[\"STATUS_DESCRIPTION\"];?>).<br />\n<br />\nИдентификатор отправления: <?=$arParams[\"TRACKING_NUMBER\"];?>.<br />\n<br />\nНаименование службы доставки: <?=$arParams[\"DELIVERY_NAME\"];?>.<br />\n<br />\n<?=$arParams[\"DELIVERY_TRACKING_URL\"];?><?=$arParams[\"ORDER_DETAIL_URL\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(42, '2023-04-27 00:03:26', 'SALE_CHECK_VALIDATION_ERROR', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', 'Ошибка при формировании чека', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Ошибка при формировании чека</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Здравствуйте!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nПо какой-то причине чек по заказу №#ORDER_ACCOUNT_NUMBER# от #ORDER_DATE# не был сформирован!<br />\n<br />\nПерейдите по ссылке, чтобы устранить причину возникшей ситуации:<br />\n#LINK_URL#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Ошибка при формировании чека</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\">Здравствуйте!</p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\"><br />\nПо какой-то причине чек по заказу №<?=$arParams[\"ORDER_ACCOUNT_NUMBER\"];?> от <?=$arParams[\"ORDER_DATE\"];?> не был сформирован!<br />\n<br />\nПерейдите по ссылке, чтобы устранить причину возникшей ситуации:<br />\n<?=$arParams[\"LINK_URL\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(43, '2023-04-27 00:03:26', 'SALE_NEW_ORDER_RECURRING', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Новый заказ N#ORDER_ID# на продление подписки', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nУважаемый #ORDER_USER#,\n\nВаш заказ номер #ORDER_ID# от #ORDER_DATE# на продление подписки принят.\n\nСтоимость заказа: #PRICE#.\n\nСостав заказа:\n#ORDER_LIST#\n\nВы можете следить за выполнением своего заказа (на какой\nстадии выполнения он находится), войдя в Ваш персональный\nраздел сайта #SITE_NAME#. Обратите внимание, что для входа\nв этот раздел Вам необходимо будет ввести логин и пароль\nпользователя сайта #SITE_NAME#.\n\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией\nотмены заказа, которая доступна в Вашем персональном\nразделе сайта #SITE_NAME#.\n\nПожалуйста, при обращении к администрации сайта #SITE_NAME#\nОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - #ORDER_ID#.\n\nСпасибо за покупку!\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nУважаемый <?=$arParams[\"ORDER_USER\"];?>,\n\nВаш заказ номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> на продление подписки принят.\n\nСтоимость заказа: <?=$arParams[\"PRICE\"];?>.\n\nСостав заказа:\n<?=$arParams[\"ORDER_LIST\"];?>\n\n\nВы можете следить за выполнением своего заказа (на какой\nстадии выполнения он находится), войдя в Ваш персональный\nраздел сайта <?=$arParams[\"SITE_NAME\"];?>. Обратите внимание, что для входа\nв этот раздел Вам необходимо будет ввести логин и пароль\nпользователя сайта <?=$arParams[\"SITE_NAME\"];?>.\n\nДля того, чтобы аннулировать заказ, воспользуйтесь функцией\nотмены заказа, которая доступна в Вашем персональном\nразделе сайта <?=$arParams[\"SITE_NAME\"];?>.\n\nПожалуйста, при обращении к администрации сайта <?=$arParams[\"SITE_NAME\"];?>\n\nОБЯЗАТЕЛЬНО указывайте номер Вашего заказа - <?=$arParams[\"ORDER_ID\"];?>.\n\nСпасибо за покупку!\n', 'text', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(44, '2023-04-27 00:03:26', 'SALE_RECURRING_CANCEL', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SITE_NAME#: Подписка отменена', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nПодписка отменена\n\n#CANCELED_REASON#\n#SITE_NAME#\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nПодписка отменена\n\n<?=$arParams[\"CANCELED_REASON\"];?>\n\n<?=$arParams[\"SITE_NAME\"];?>\n\n', 'text', '#BCC#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(45, '2023-04-27 00:03:26', 'SALE_STATUS_CHANGED_F', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SERVER_NAME#: Изменение статуса заказа N#ORDER_ID#', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменение статуса заказа в магазине #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\"></p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Информационное сообщение сайта #SITE_NAME#<br />\n------------------------------------------<br />\n<br />\nСтатус заказа номер #ORDER_ID# от #ORDER_DATE# изменен.<br />\n<br />\nНовый статус заказа:<br />\n#ORDER_STATUS#<br />\n#ORDER_DESCRIPTION#<br />\n#TEXT#<br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт #SERVER_NAME#/personal/order/#ORDER_ID#/<br />\n<br />\nСпасибо за ваш выбор!<br />\n#SITE_NAME#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменение статуса заказа в магазине <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\"></p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?><br />\n------------------------------------------<br />\n<br />\nСтатус заказа номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> изменен.<br />\n<br />\nНовый статус заказа:<br />\n<?=$arParams[\"ORDER_STATUS\"];?><br />\n<?=$arParams[\"ORDER_DESCRIPTION\"];?><br />\n<?=$arParams[\"TEXT\"];?><br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт <?=$arParams[\"SERVER_NAME\"];?>/personal/order/<?=$arParams[\"ORDER_ID\"];?>/<br />\n<br />\nСпасибо за ваш выбор!<br />\n<?=$arParams[\"SITE_NAME\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(46, '2023-04-27 00:03:26', 'SALE_STATUS_CHANGED_N', 's1', 'Y', '#SALE_EMAIL#', '#EMAIL#', '#SERVER_NAME#: Изменение статуса заказа N#ORDER_ID#', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменение статуса заказа в магазине #SITE_NAME#</td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\"></p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Информационное сообщение сайта #SITE_NAME#<br />\n------------------------------------------<br />\n<br />\nСтатус заказа номер #ORDER_ID# от #ORDER_DATE# изменен.<br />\n<br />\nНовый статус заказа:<br />\n#ORDER_STATUS#<br />\n#ORDER_DESCRIPTION#<br />\n#TEXT#<br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт #SERVER_NAME#/personal/order/#ORDER_ID#/<br />\n<br />\nСпасибо за ваш выбор!<br />\n#SITE_NAME#<br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://#SERVER_NAME#\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:#SALE_EMAIL#\" style=\"color:#2e6eb6;\">#SALE_EMAIL#</a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ru\" lang=\"ru\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n	<style>\n		body\n		{\n			font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;\n			font-size: 14px;\n			color: #000;\n		}\n	</style>\n</head>\n<body>\n<table cellpadding=\"0\" cellspacing=\"0\" width=\"850\" style=\"background-color: #d1d1d1; border-radius: 2px; border:1px solid #d1d1d1; margin: 0 auto;\" border=\"1\" bordercolor=\"#d1d1d1\">\n	<tr>\n		<td height=\"83\" width=\"850\" bgcolor=\"#eaf3f5\" style=\"border: none; padding-top: 23px; padding-right: 17px; padding-bottom: 24px; padding-left: 17px;\">\n			<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n				<tr>\n					<td bgcolor=\"#ffffff\" height=\"75\" style=\"font-weight: bold; text-align: center; font-size: 26px; color: #0b3961;\">Изменение статуса заказа в магазине <?=$arParams[\"SITE_NAME\"];?></td>\n				</tr>\n				<tr>\n					<td bgcolor=\"#bad3df\" height=\"11\"></td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n	<tr>\n		<td width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 16px; padding-left: 44px;\">\n			<p style=\"margin-top:30px; margin-bottom: 28px; font-weight: bold; font-size: 19px;\"></p>\n			<p style=\"margin-top: 0; margin-bottom: 20px; line-height: 20px;\">Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?><br />\n------------------------------------------<br />\n<br />\nСтатус заказа номер <?=$arParams[\"ORDER_ID\"];?> от <?=$arParams[\"ORDER_DATE\"];?> изменен.<br />\n<br />\nНовый статус заказа:<br />\n<?=$arParams[\"ORDER_STATUS\"];?><br />\n<?=$arParams[\"ORDER_DESCRIPTION\"];?><br />\n<?=$arParams[\"TEXT\"];?><br />\n<br />\nДля получения подробной информации по заказу пройдите на сайт <?=$arParams[\"SERVER_NAME\"];?>/personal/order/<?=$arParams[\"ORDER_ID\"];?>/<br />\n<br />\nСпасибо за ваш выбор!<br />\n<?=$arParams[\"SITE_NAME\"];?><br />\n</p>\n		</td>\n	</tr>\n	<tr>\n		<td height=\"40px\" width=\"850\" bgcolor=\"#f7f7f7\" valign=\"top\" style=\"border: none; padding-top: 0; padding-right: 44px; padding-bottom: 30px; padding-left: 44px;\">\n			<p style=\"border-top: 1px solid #d1d1d1; margin-bottom: 5px; margin-top: 0; padding-top: 20px; line-height:21px;\">С уважением,<br />администрация <a href=\"http://<?=$arParams[\"SERVER_NAME\"];?>\" style=\"color:#2e6eb6;\">Интернет-магазина</a><br />\n				E-mail: <a href=\"mailto:<?=$arParams[\"SALE_EMAIL\"];?>\" style=\"color:#2e6eb6;\"><?=$arParams[\"SALE_EMAIL\"];?></a>\n			</p>\n		</td>\n	</tr>\n</table>\n</body>\n</html>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(47, '2023-04-27 00:03:28', 'VIRUS_DETECTED', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Обнаружен вирус', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nЗдравствуйте!\n\nВы получили это сообщение, так как модуль проактивной защиты сервера #SERVER_NAME# обнаружил код, похожий на вирус.\n\n1. Подозрительный код был вырезан из html.\n2. Проверьте журнал вторжений и убедитесь, что код действительно вредоносный, а не является кодом какого-либо счетчика или фреймворка.\n (ссылка: http://#SERVER_NAME#/bitrix/admin/event_log.php?lang=ru&set_filter=Y&find_type=audit_type_id&find_audit_type[]=SECURITY_VIRUS )\n3. В случае, если код не является опасным, добавьте его в исключения на странице настройки антивируса.\n (ссылка: http://#SERVER_NAME#/bitrix/admin/security_antivirus.php?lang=ru&tabControl_active_tab=exceptions )\n4. Если код является вирусным, то необходимо выполнить следующие действия:\n\n а) Смените пароли доступа к сайту у администраторов и ответственных сотрудников.\n б) Смените пароли доступа по ssh и ftp.\n в) Проверьте и вылечите компьютеры администраторов, имевших доступ к сайту по ssh или ftp.\n г) В программах доступа к сайту по ssh и ftp отключите сохранение паролей.\n д) Удалите вредоносный код из зараженных файлов. Например, восстановите поврежденные файлы из самой свежей резервной копии.\n\n---------------------------------------------------------------------\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nЗдравствуйте!\n\nВы получили это сообщение, так как модуль проактивной защиты сервера <?=$arParams[\"SERVER_NAME\"];?> обнаружил код, похожий на вирус.\n\n1. Подозрительный код был вырезан из html.\n2. Проверьте журнал вторжений и убедитесь, что код действительно вредоносный, а не является кодом какого-либо счетчика или фреймворка.\n (ссылка: http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/event_log.php?lang=ru&set_filter=Y&find_type=audit_type_id&find_audit_type[]=SECURITY_VIRUS )\n3. В случае, если код не является опасным, добавьте его в исключения на странице настройки антивируса.\n (ссылка: http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/security_antivirus.php?lang=ru&tabControl_active_tab=exceptions )\n4. Если код является вирусным, то необходимо выполнить следующие действия:\n\n а) Смените пароли доступа к сайту у администраторов и ответственных сотрудников.\n б) Смените пароли доступа по ssh и ftp.\n в) Проверьте и вылечите компьютеры администраторов, имевших доступ к сайту по ssh или ftp.\n г) В программах доступа к сайту по ssh и ftp отключите сохранение паролей.\n д) Удалите вредоносный код из зараженных файлов. Например, восстановите поврежденные файлы из самой свежей резервной копии.\n\n---------------------------------------------------------------------\nСообщение сгенерировано автоматически.\n', 'text', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(48, '2023-04-27 00:03:28', 'SENDER_SUBSCRIBE_CONFIRM', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Подтверждение подписки', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был подписан\nна список рассылки сервера #SERVER_NAME#.\n\nДополнительная информация о подписке:\n\nАдрес подписки (email) ............ #EMAIL#\nДата добавления/редактирования .... #DATE#\nСписок рассылок:\n#MAILING_LIST#\n\n\nДля подтверждения подписки перейдите по следующей ссылке:\nhttp://#SERVER_NAME##CONFIRM_URL#\n\n\nВнимание! Вы не будете получать сообщения рассылки, пока не подтвердите\nсвою подписку.\nЕсли вы не подписывались на рассылку и получили это письмо по ошибке,\nпроигнорируйте его.\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был подписан\nна список рассылки сервера <?=$arParams[\"SERVER_NAME\"];?>.\n\nДополнительная информация о подписке:\n\nАдрес подписки (email) ............ <?=$arParams[\"EMAIL\"];?>\n\nДата добавления/редактирования .... <?=$arParams[\"DATE\"];?>\n\nСписок рассылок:\n<?=$arParams[\"MAILING_LIST\"];?>\n\n\n\nДля подтверждения подписки перейдите по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"CONFIRM_URL\"];?>\n\n\n\nВнимание! Вы не будете получать сообщения рассылки, пока не подтвердите\nсвою подписку.\nЕсли вы не подписывались на рассылку и получили это письмо по ошибке,\nпроигнорируйте его.\n\nСообщение сгенерировано автоматически.\n', 'text', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(49, '2023-04-27 00:03:31', 'SUBSCRIBE_CONFIRM', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', '#SITE_NAME#: Подтверждение подписки', 'Информационное сообщение сайта #SITE_NAME#\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был подписан\nна список рассылки сервера #SERVER_NAME#.\n\nДополнительная информация о подписке:\n\nАдрес подписки (email) ............ #EMAIL#\nДата добавления/редактирования .... #DATE_SUBSCR#\n\nВаш код для подтверждения подписки: #CONFIRM_CODE#\n\nДля подтверждения подписки перейдите по следующей ссылке:\nhttp://#SERVER_NAME##SUBSCR_SECTION#subscr_edit.php?ID=#ID#&CONFIRM_CODE=#CONFIRM_CODE#\n\nВы также можете ввести код для подтверждения подписки на странице:\nhttp://#SERVER_NAME##SUBSCR_SECTION#subscr_edit.php?ID=#ID#\n\nВнимание! Вы не будете получать сообщения рассылки, пока не подтвердите\nсвою подписку.\n\n---------------------------------------------------------------------\nСохраните это письмо, так как оно содержит информацию для авторизации.\nИспользуя код подтверждения подписки, вы cможете изменить параметры\nподписки или отписаться от рассылки.\n\nИзменить параметры:\nhttp://#SERVER_NAME##SUBSCR_SECTION#subscr_edit.php?ID=#ID#&CONFIRM_CODE=#CONFIRM_CODE#\n\nОтписаться:\nhttp://#SERVER_NAME##SUBSCR_SECTION#subscr_edit.php?ID=#ID#&CONFIRM_CODE=#CONFIRM_CODE#&action=unsubscribe\n---------------------------------------------------------------------\n\nСообщение сгенерировано автоматически.\n', 'Информационное сообщение сайта <?=$arParams[\"SITE_NAME\"];?>\n\n------------------------------------------\n\nЗдравствуйте,\n\nВы получили это сообщение, так как ваш адрес был подписан\nна список рассылки сервера <?=$arParams[\"SERVER_NAME\"];?>.\n\nДополнительная информация о подписке:\n\nАдрес подписки (email) ............ <?=$arParams[\"EMAIL\"];?>\n\nДата добавления/редактирования .... <?=$arParams[\"DATE_SUBSCR\"];?>\n\n\nВаш код для подтверждения подписки: <?=$arParams[\"CONFIRM_CODE\"];?>\n\n\nДля подтверждения подписки перейдите по следующей ссылке:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"SUBSCR_SECTION\"];?>subscr_edit.php?ID=<?=$arParams[\"ID\"];?>&CONFIRM_CODE=<?=$arParams[\"CONFIRM_CODE\"];?>\n\n\nВы также можете ввести код для подтверждения подписки на странице:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"SUBSCR_SECTION\"];?>subscr_edit.php?ID=<?=$arParams[\"ID\"];?>\n\n\nВнимание! Вы не будете получать сообщения рассылки, пока не подтвердите\nсвою подписку.\n\n---------------------------------------------------------------------\nСохраните это письмо, так как оно содержит информацию для авторизации.\nИспользуя код подтверждения подписки, вы cможете изменить параметры\nподписки или отписаться от рассылки.\n\nИзменить параметры:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"SUBSCR_SECTION\"];?>subscr_edit.php?ID=<?=$arParams[\"ID\"];?>&CONFIRM_CODE=<?=$arParams[\"CONFIRM_CODE\"];?>\n\n\nОтписаться:\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"SUBSCR_SECTION\"];?>subscr_edit.php?ID=<?=$arParams[\"ID\"];?>&CONFIRM_CODE=<?=$arParams[\"CONFIRM_CODE\"];?>&action=unsubscribe\n---------------------------------------------------------------------\n\nСообщение сгенерировано автоматически.\n', 'text', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(50, '2023-04-27 00:03:33', 'VOTE_FOR', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SITE_NAME#: [V] #VOTE_TITLE#', '#USER_NAME# принял участие в опросе \"#VOTE_TITLE#\":\n#VOTE_STATISTIC#\n\nhttp://#SERVER_NAME##URL#\nСообщение сгенерировано автоматически.', '<?=$arParams[\"USER_NAME\"];?> принял участие в опросе \"<?=$arParams[\"VOTE_TITLE\"];?>\":\n<?=$arParams[\"VOTE_STATISTIC\"];?>\n\n\nhttp://<?=$arParams[\"SERVER_NAME\"];?><?=$arParams[\"URL\"];?>\n\nСообщение сгенерировано автоматически.', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(51, '2023-04-27 00:10:27', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый заказ с сайта', 'Заполнена форма \"Оформление заказа\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #NAME#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nНазвание компании: #COMPANY#<br />\nАдрес доставки: #ADDRESS#<br />\nКомментарий к заказу: #MESSAGE#<br />\nСостав заказа: #ORDER_LIST#<br /><br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Оформление заказа\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"NAME\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nНазвание компании: <?=$arParams[\"COMPANY\"];?><br />\nАдрес доставки: <?=$arParams[\"ADDRESS\"];?><br />\nКомментарий к заказу: <?=$arParams[\"MESSAGE\"];?><br />\nСостав заказа: <?=$arParams[\"ORDER_LIST\"];?><br /><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(52, '2023-04-27 00:10:28', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#DEFAULT_EMAIL_FROM#', 'Новое письмо директору с сайта', 'Заполнена форма \"Написать директору\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #NAME#<br />\nТема: #TITLE#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Написать директору\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"NAME\"];?><br />\nТема: <?=$arParams[\"TITLE\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(53, '2023-04-27 00:10:28', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новое бронирование с сайта', 'Заполнена форма \"Забронировать\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #NAME#<br />\nТелефон: #PHONE#<br />\nДата приезда: #FROM#<br />\nДата отъезда: #TO#<br />\nТип проживания: #PRODUCT#<br />\nКоличество человек: #NUMBERS#<br />\nДополнительные услуги: #SERVICES#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Забронировать\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"NAME\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nДата приезда: <?=$arParams[\"FROM\"];?><br />\nДата отъезда: <?=$arParams[\"TO\"];?><br />\nТип проживания: <?=$arParams[\"PRODUCT\"];?><br />\nКоличество человек: <?=$arParams[\"NUMBERS\"];?><br />\nДополнительные услуги: <?=$arParams[\"SERVICES\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(54, '2023-04-27 00:10:28', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый заказ проекта с сайта', 'Заполнена форма \"Заказать проект\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nПроект: #PROJECT#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Заказать проект\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nПроект: <?=$arParams[\"PROJECT\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(55, '2023-04-27 00:10:29', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый заказ услуги с сайта', 'Заполнена форма \"Заказать услугу\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nУслуга: #SERVICE#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Заказать услугу\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nУслуга: <?=$arParams[\"SERVICE\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(56, '2023-04-27 00:10:29', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новое резюме с сайта', 'Заполнена форма \"Отправить резюме\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nЖелаемая должность: #POST#<br />\nДополнительная информация: #MESSAGE#<br />\nФайл с резюме: #FILE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Отправить резюме\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nЖелаемая должность: <?=$arParams[\"POST\"];?><br />\nДополнительная информация: <?=$arParams[\"MESSAGE\"];?><br />\nФайл с резюме: <?=$arParams[\"FILE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(57, '2023-04-27 00:10:29', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый вопрос с сайта', 'Заполнена форма \"Задать вопрос\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nИнтересующий товар/услуга: #NEED_PRODUCT#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Задать вопрос\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nИнтересующий товар/услуга: <?=$arParams[\"NEED_PRODUCT\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(58, '2023-04-27 00:10:30', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый звонок с сайта', 'Заполнена форма \"Задать звонок\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Задать звонок\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(59, '2023-04-27 00:10:30', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#STAFF_EMAIL_HIDDEN#', 'Новое сообщение сотруднику с сайта', 'Заполнена форма \"Написать сотруднику\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nСотрудник: #STAFF#<br />\nEmail сотрудника: #STAFF_EMAIL_HIDDEN#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Написать сотруднику\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nСотрудник: <?=$arParams[\"STAFF\"];?><br />\nEmail сотрудника: <?=$arParams[\"STAFF_EMAIL_HIDDEN\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(60, '2023-04-27 00:10:30', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый отзыв с сайта', 'Заполнена форма \"Оставить отзыв\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nДолжность: #POST#<br />\nФайлы: #FILES#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Оставить отзыв\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nДолжность: <?=$arParams[\"POST\"];?><br />\nФайлы: <?=$arParams[\"FILES\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(61, '2023-04-27 00:10:30', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новый быстрый заказ продукта с сайта', 'Заполнена форма \"Купить в 1 клик\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #FIO#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nПродукт: #PRODUCT_NAME#<br />\nЦена продукта: #PRODUCT_PRICE#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Купить в 1 клик\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"FIO\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nПродукт: <?=$arParams[\"PRODUCT_NAME\"];?><br />\nЦена продукта: <?=$arParams[\"PRODUCT_PRICE\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(62, '2023-04-27 00:10:31', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_RAW#', 'Новое бронирование тура с сайта', 'Заполнена форма \"Забронировать тур\" на сайте #SITE_NAME# (#RS_RESULT_ID#)<br />\nИмя посетителя: #NAME#<br />\nТелефон: #PHONE#<br />\nEmail: #EMAIL#<br />\nТур: #PRODUCT#<br />\nСообщение: #MESSAGE#<br />\n	\nЗапрос отправлен: #RS_DATE_CREATE#\nПросмотр результата на сайте: <a href=\'http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#\' target=\'_blank\'>http://#SERVER_NAME#/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=#RS_FORM_ID#&RESULT_ID=#RS_RESULT_ID#&WEB_FORM_NAME=#RS_FORM_NAME#</a>', 'Заполнена форма \"Забронировать тур\" на сайте <?=$arParams[\"SITE_NAME\"];?> (<?=$arParams[\"RS_RESULT_ID\"];?>)<br />\nИмя посетителя: <?=$arParams[\"NAME\"];?><br />\nТелефон: <?=$arParams[\"PHONE\"];?><br />\nEmail: <?=$arParams[\"EMAIL\"];?><br />\nТур: <?=$arParams[\"PRODUCT\"];?><br />\nСообщение: <?=$arParams[\"MESSAGE\"];?><br />\n	\nЗапрос отправлен: <?=$arParams[\"RS_DATE_CREATE\"];?>\n\nПросмотр результата на сайте: <a href=\'http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?>\' target=\'_blank\'>http://<?=$arParams[\"SERVER_NAME\"];?>/bitrix/admin/form_result_edit.php?lang=ru&WEB_FORM_ID=<?=$arParams[\"RS_FORM_ID\"];?>&RESULT_ID=<?=$arParams[\"RS_RESULT_ID\"];?>&WEB_FORM_NAME=<?=$arParams[\"RS_FORM_NAME\"];?></a>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(63, '2024-10-02 15:02:03', 'NEW_DEVICE_LOGIN', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL#', 'Вход с нового устройства', 'Здравствуйте, #NAME#,\n\nНовое устройство авторизовалось под вашим логином #LOGIN#.\n \nУстройство: #DEVICE# \nБраузер: #BROWSER#\nПлатформа: #PLATFORM#\nМестоположение: #LOCATION# (может быть неточным)\nДата: #DATE#\n\nЕсли вы не знаете, кто это был, рекомендуем немедленно сменить пароль.\n', 'Здравствуйте, <?=$arParams[\"NAME\"];?>,\n\nНовое устройство авторизовалось под вашим логином <?=$arParams[\"LOGIN\"];?>.\n \nУстройство: <?=$arParams[\"DEVICE\"];?> \nБраузер: <?=$arParams[\"BROWSER\"];?>\n\nПлатформа: <?=$arParams[\"PLATFORM\"];?>\n\nМестоположение: <?=$arParams[\"LOCATION\"];?> (может быть неточным)\nДата: <?=$arParams[\"DATE\"];?>\n\n\nЕсли вы не знаете, кто это был, рекомендуем немедленно сменить пароль.\n', 'text', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ru'),
(64, '2024-10-02 15:04:34', 'CALENDAR_SHARING', 's1', 'Y', '#DEFAULT_EMAIL_FROM#', '#EMAIL_TO#', '#SUBJECT#', '<?php EventMessageThemeCompiler::includeComponent(\n				\"bitrix:calendar.sharing.mail\",\n				\"\",\n				$arParams,\n			);?>', '<?php EventMessageThemeCompiler::includeComponent(\n				\"bitrix:calendar.sharing.mail\",\n				\"\",\n				$arParams,\n			);?>', 'html', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
-- -----------------------------------
-- Dumping table b_event_message_attachment
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_message_attachment`;
CREATE TABLE `b_event_message_attachment` (
  `EVENT_MESSAGE_ID` int NOT NULL,
  `FILE_ID` int NOT NULL,
  PRIMARY KEY (`EVENT_MESSAGE_ID`,`FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_event_message_site
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_message_site`;
CREATE TABLE `b_event_message_site` (
  `EVENT_MESSAGE_ID` int NOT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`EVENT_MESSAGE_ID`,`SITE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_event_message_site` VALUES
(1, 's1'),
(2, 's1'),
(3, 's1'),
(4, 's1'),
(5, 's1'),
(6, 's1'),
(7, 's1'),
(8, 's1'),
(9, 's1'),
(10, 's1'),
(11, 's1'),
(12, 's1'),
(13, 's1'),
(14, 's1'),
(15, 's1'),
(16, 's1'),
(17, 's1'),
(18, 's1'),
(19, 's1'),
(20, 's1'),
(21, 's1'),
(22, 's1'),
(23, 's1'),
(24, 's1'),
(25, 's1'),
(26, 's1'),
(27, 's1'),
(28, 's1'),
(29, 's1'),
(30, 's1'),
(31, 's1'),
(32, 's1'),
(33, 's1'),
(34, 's1'),
(35, 's1'),
(36, 's1'),
(37, 's1'),
(38, 's1'),
(39, 's1'),
(40, 's1'),
(41, 's1'),
(42, 's1'),
(43, 's1'),
(44, 's1'),
(45, 's1'),
(46, 's1'),
(47, 's1'),
(48, 's1'),
(49, 's1'),
(50, 's1'),
(51, 's1'),
(52, 's1'),
(53, 's1'),
(54, 's1'),
(55, 's1'),
(56, 's1'),
(57, 's1'),
(58, 's1'),
(59, 's1'),
(60, 's1'),
(61, 's1'),
(62, 's1'),
(63, 's1'),
(64, 's1');
-- -----------------------------------
-- Dumping table b_event_type
-- -----------------------------------
DROP TABLE IF EXISTS `b_event_type`;
CREATE TABLE `b_event_type` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `EVENT_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `SORT` int NOT NULL DEFAULT '150',
  `EVENT_TYPE` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'email',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ux_1` (`EVENT_NAME`,`LID`)
) ENGINE=InnoDB AUTO_INCREMENT=379 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_event_type` VALUES
(1, 'ru', 'NEW_USER', 'Зарегистрировался новый пользователь', '\n\n#USER_ID# - ID пользователя\n#LOGIN# - Логин\n#EMAIL# - EMail\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#USER_IP# - IP пользователя\n#USER_HOST# - Хост пользователя\n', 1, 'email'),
(2, 'ru', 'USER_INFO', 'Информация о пользователе', '\n\n#USER_ID# - ID пользователя\n#STATUS# - Статус логина\n#MESSAGE# - Сообщение пользователю\n#LOGIN# - Логин\n#URL_LOGIN# - Логин, закодированный для использования в URL\n#CHECKWORD# - Контрольная строка для смены пароля\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#EMAIL# - E-Mail пользователя\n', 2, 'email'),
(3, 'ru', 'NEW_USER_CONFIRM', 'Подтверждение регистрации нового пользователя', '\n\n\n#USER_ID# - ID пользователя\n#LOGIN# - Логин\n#EMAIL# - EMail\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#USER_IP# - IP пользователя\n#USER_HOST# - Хост пользователя\n#CONFIRM_CODE# - Код подтверждения\n', 3, 'email'),
(4, 'ru', 'USER_PASS_REQUEST', 'Запрос на смену пароля', '\n\n#USER_ID# - ID пользователя\n#STATUS# - Статус логина\n#MESSAGE# - Сообщение пользователю\n#LOGIN# - Логин\n#URL_LOGIN# - Логин, закодированный для использования в URL\n#CHECKWORD# - Контрольная строка для смены пароля\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#EMAIL# - E-Mail пользователя\n', 4, 'email'),
(5, 'ru', 'USER_PASS_CHANGED', 'Подтверждение смены пароля', '\n\n#USER_ID# - ID пользователя\n#STATUS# - Статус логина\n#MESSAGE# - Сообщение пользователю\n#LOGIN# - Логин\n#URL_LOGIN# - Логин, закодированный для использования в URL\n#CHECKWORD# - Контрольная строка для смены пароля\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#EMAIL# - E-Mail пользователя\n', 5, 'email'),
(6, 'ru', 'USER_INVITE', 'Приглашение на сайт нового пользователя', '#ID# - ID пользователя\n#LOGIN# - Логин\n#URL_LOGIN# - Логин, закодированный для использования в URL\n#EMAIL# - EMail\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#PASSWORD# - пароль пользователя \n#CHECKWORD# - Контрольная строка для смены пароля\n#XML_ID# - ID пользователя для связи с внешними источниками\n', 6, 'email'),
(7, 'ru', 'FEEDBACK_FORM', 'Отправка сообщения через форму обратной связи', '#AUTHOR# - Автор сообщения\n#AUTHOR_EMAIL# - Email автора сообщения\n#TEXT# - Текст сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 7, 'email'),
(8, 'ru', 'MAIN_MAIL_CONFIRM_CODE', 'Подтверждение email-адреса отправителя', '\n\n#EMAIL_TO# - Email-адрес для подтверждения\n#MESSAGE_SUBJECT# - Тема сообщения\n#CONFIRM_CODE# - Код подтверждения', 8, 'email'),
(9, 'ru', 'EVENT_LOG_NOTIFICATION', 'Оповещение журнала событий', '#EMAIL# - Email получателя\n#ADDITIONAL_TEXT# - Дополнительный текст действия\n#NAME# - Название оповещения\n#AUDIT_TYPE_ID# - Тип события\n#ITEM_ID# - Объект\n#USER_ID# - Пользователь\n#REMOTE_ADDR# - IP-адрес\n#USER_AGENT# - Браузер\n#REQUEST_URI# - Страница\n#EVENT_COUNT# - Количество записей', 9, 'email'),
(10, 'ru', 'USER_CODE_REQUEST', 'Запрос кода авторизации', '#USER_ID# - ID пользователя\n#STATUS# - Статус логина\n#LOGIN# - Логин\n#CHECKWORD# - Код для авторизации\n#NAME# - Имя\n#LAST_NAME# - Фамилия\n#EMAIL# - Email пользователя\n', 10, 'email'),
(11, 'ru', 'SMS_USER_CONFIRM_NUMBER', 'Подтверждение номера телефона по СМС', '#USER_PHONE# - номер телефона\n#CODE# - код подтверждения\n', 100, 'sms'),
(12, 'ru', 'SMS_USER_RESTORE_PASSWORD', 'Восстановление пароля через СМС', '#USER_PHONE# - номер телефона\n#CODE# - код для восстановления\n', 100, 'sms'),
(13, 'ru', 'SMS_EVENT_LOG_NOTIFICATION', 'Оповещение журнала событий', '#PHONE_NUMBER# - Номер телефона получателя\n#ADDITIONAL_TEXT# - Дополнительный текст действия\n#NAME# - Название оповещения\n#AUDIT_TYPE_ID# - Тип события\n#ITEM_ID# - Объект\n#USER_ID# - Пользователь\n#REMOTE_ADDR# - IP-адрес\n#USER_AGENT# - Браузер\n#REQUEST_URI# - Страница\n#EVENT_COUNT# - Количество записей', 100, 'sms'),
(14, 'en', 'NEW_USER', 'New user was registered', '\n\n#USER_ID# - User ID\n#LOGIN# - Login\n#EMAIL# - EMail\n#NAME# - Name\n#LAST_NAME# - Last Name\n#USER_IP# - User IP\n#USER_HOST# - User Host\n', 1, 'email'),
(15, 'en', 'USER_INFO', 'Account Information', '\n\n#USER_ID# - User ID\n#STATUS# - Account status\n#MESSAGE# - Message for user\n#LOGIN# - Login\n#URL_LOGIN# - Encoded login for use in URL\n#CHECKWORD# - Check string for password change\n#NAME# - Name\n#LAST_NAME# - Last Name\n#EMAIL# - User E-Mail\n', 2, 'email'),
(16, 'en', 'NEW_USER_CONFIRM', 'New user registration confirmation', '\n\n#USER_ID# - User ID\n#LOGIN# - Login\n#EMAIL# - E-mail\n#NAME# - First name\n#LAST_NAME# - Last name\n#USER_IP# - User IP\n#USER_HOST# - User host\n#CONFIRM_CODE# - Confirmation code\n', 3, 'email'),
(17, 'en', 'USER_PASS_REQUEST', 'Password Change Request', '\n\n#USER_ID# - User ID\n#STATUS# - Account status\n#MESSAGE# - Message for user\n#LOGIN# - Login\n#URL_LOGIN# - Encoded login for use in URL\n#CHECKWORD# - Check string for password change\n#NAME# - Name\n#LAST_NAME# - Last Name\n#EMAIL# - User E-Mail\n', 4, 'email'),
(18, 'en', 'USER_PASS_CHANGED', 'Password Change Confirmation', '\n\n#USER_ID# - User ID\n#STATUS# - Account status\n#MESSAGE# - Message for user\n#LOGIN# - Login\n#URL_LOGIN# - Encoded login for use in URL\n#CHECKWORD# - Check string for password change\n#NAME# - Name\n#LAST_NAME# - Last Name\n#EMAIL# - User E-Mail\n', 5, 'email'),
(19, 'en', 'USER_INVITE', 'Invitation of a new site user', '#ID# - User ID\n#LOGIN# - Login\n#URL_LOGIN# - Encoded login for use in URL\n#EMAIL# - EMail\n#NAME# - Name\n#LAST_NAME# - Last Name\n#PASSWORD# - User password \n#CHECKWORD# - Password check string\n#XML_ID# - User ID to link with external data sources\n\n', 6, 'email'),
(20, 'en', 'FEEDBACK_FORM', 'Sending a message using a feedback form', '#AUTHOR# - Message author\n#AUTHOR_EMAIL# - Author\'s e-mail address\n#TEXT# - Message text\n#EMAIL_FROM# - Sender\'s e-mail address\n#EMAIL_TO# - Recipient\'s e-mail address', 7, 'email'),
(21, 'en', 'MAIN_MAIL_CONFIRM_CODE', 'Confirm sender\'s email address', '\n\n#EMAIL_TO# - confirmation email address\n#MESSAGE_SUBJECT# - Message subject\n#CONFIRM_CODE# - Confirmation code', 8, 'email'),
(22, 'en', 'EVENT_LOG_NOTIFICATION', 'Event log notification', '#EMAIL# - Recipient email\n#ADDITIONAL_TEXT# - Action additional text\n#NAME# - Notification name\n#AUDIT_TYPE_ID# - Event type\n#ITEM_ID# - Object\n#USER_ID# - User\n#REMOTE_ADDR# - IP address\n#USER_AGENT# - Browser\n#REQUEST_URI# - Page URL\n#EVENT_COUNT# - Number of events', 9, 'email'),
(23, 'en', 'USER_CODE_REQUEST', 'Request for verification code', '#USER_ID# - user ID\n#STATUS# - Login status\n#LOGIN# - Login\n#CHECKWORD# - Verification code\n#NAME# - First name\n#LAST_NAME# - Last name\n#EMAIL# - User email\n', 10, 'email'),
(24, 'en', 'SMS_USER_CONFIRM_NUMBER', 'Verify phone number using SMS', '#USER_PHONE# - phone number\n#CODE# - confirmation code', 100, 'sms'),
(25, 'en', 'SMS_USER_RESTORE_PASSWORD', 'Recover password using SMS', '#USER_PHONE# - phone number\n#CODE# - recovery confirmation code', 100, 'sms'),
(26, 'en', 'SMS_EVENT_LOG_NOTIFICATION', 'Event log notification', '#PHONE_NUMBER# - Recipient phone number\n#ADDITIONAL_TEXT# - Action additional text\n#NAME# - Notification name\n#AUDIT_TYPE_ID# - Event type\n#ITEM_ID# - Object\n#USER_ID# - User\n#REMOTE_ADDR# - IP address\n#USER_AGENT# - Browser\n#REQUEST_URI# - Page URL\n#EVENT_COUNT# - Number of events', 100, 'sms'),
(27, 'ru', 'NEW_BLOG_MESSAGE', 'Новое сообщение в блоге', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#MESSAGE_TITLE# - Тема сообщения\n#MESSAGE_TEXT# - Текст сообщения\n#MESSAGE_DATE# - Дата сообщения\n#MESSAGE_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(28, 'ru', 'NEW_BLOG_COMMENT', 'Новый комментарий в блоге', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#MESSAGE_TITLE# - Тема сообщения\n#COMMENT_TITLE# - Заголовок комментария\n#COMMENT_TEXT# - Текст комментария\n#COMMENT_DATE# - Текст комментария\n#COMMENT_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(29, 'ru', 'NEW_BLOG_COMMENT2COMMENT', 'Новый комментарий на ваш комментарий в блоге', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#MESSAGE_TITLE# - Тема сообщения\n#COMMENT_TITLE# - Заголовок комментария\n#COMMENT_TEXT# - Текст комментария\n#COMMENT_DATE# - Текст комментария\n#COMMENT_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(30, 'ru', 'NEW_BLOG_COMMENT_WITHOUT_TITLE', 'Новый комментарий в блоге (без темы)', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#MESSAGE_TITLE# - Тема сообщения\n#COMMENT_TEXT# - Текст комментария\n#COMMENT_DATE# - Текст комментария\n#COMMENT_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(31, 'ru', 'NEW_BLOG_COMMENT2COMMENT_WITHOUT_TITLE', 'Новый комментарий на ваш комментарий в блоге (без темы)', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#COMMENT_TITLE# - Заголовок комментария\n#COMMENT_TEXT# - Текст комментария\n#COMMENT_DATE# - Текст комментария\n#COMMENT_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(32, 'ru', 'BLOG_YOUR_BLOG_TO_USER', 'Ваш блог был добавлен в друзья', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#BLOG_ADR# - Адрес блога\n#USER_ID# - ID пользователя\n#USER# - Пользователь\n#USER_URL# - Адрес пользователя\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма\n', 100, 'email'),
(33, 'ru', 'BLOG_YOU_TO_BLOG', 'Вы были добавлены в друзья блога', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#BLOG_ADR# - Адрес блога\n#USER_ID# - ID пользователя\n#USER# - Пользователь\n#USER_URL# - Адрес пользователя\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма\n', 100, 'email'),
(34, 'ru', 'BLOG_BLOG_TO_YOU', 'К вам в друзья был добавлен блог', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#BLOG_ADR# - Адрес блога\n#USER_ID# - ID пользователя\n#USER# - Пользователь\n#USER_URL# - Адрес пользователя\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма\n', 100, 'email'),
(35, 'ru', 'BLOG_USER_TO_YOUR_BLOG', 'В ваш блог был добавлен друг', '#BLOG_ID# - ID блога \n#BLOG_NAME# - Название блога\n#BLOG_URL# - Название блога латиницей\n#BLOG_ADR# - Адрес блога\n#USER_ID# - ID пользователя\n#USER# - Пользователь\n#USER_URL# - Адрес пользователя\n#EMAIL_FROM# - Email отправителя письма\n#EMAIL_TO# - Email получателя письма\n', 100, 'email'),
(36, 'ru', 'BLOG_SONET_NEW_POST', 'Добавлено новое сообщение', '#EMAIL_TO# - Email получателя письма\n#POST_ID# - ID сообщения\n#RECIPIENT_ID# - ID получателя\n#URL_ID# - URL страницы сообщения\n', 100, 'email'),
(37, 'ru', 'BLOG_SONET_NEW_COMMENT', 'Добавлен новый комментарий', '#EMAIL_TO# - Email получателя письма\n#COMMENT_ID# - ID комментария\n#POST_ID# - ID сообщения\n#RECIPIENT_ID# - ID получателя\n#URL_ID# - URL страницы сообщения\n', 100, 'email'),
(38, 'ru', 'BLOG_SONET_POST_SHARE', 'Добавлен новый получатель сообщения', '#EMAIL_TO# - Email получателя письма\n#POST_ID# - ID сообщения\n#RECIPIENT_ID# - ID получателя\n#URL_ID# - URL страницы сообщения\n', 100, 'email'),
(39, 'ru', 'BLOG_POST_BROADCAST', 'Добавлено новое сообщение', '\n#MESSAGE_TITLE# - Тема сообщения\n#MESSAGE_TEXT# - Текст сообщения\n#MESSAGE_PATH# - URL адрес сообщения\n#AUTHOR# - Автор сообщения\n#EMAIL_TO# - Email получателя письма', 100, 'email'),
(40, 'en', 'NEW_BLOG_MESSAGE', 'New blog message', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog title\n#BLOG_URL# - Blog url\n#MESSAGE_TITLE# - Message title\n#MESSAGE_TEXT# - Message text\n#MESSAGE_DATE# - Message date\n#MESSAGE_PATH# - URL to message\n#AUTHOR# - Message author\n#EMAIL_FROM# - Sender email\n#EMAIL_TO# - Recipient email', 100, 'email'),
(41, 'en', 'NEW_BLOG_COMMENT', 'New comment in blog', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog title\n#BLOG_URL# - Blog url\n#MESSAGE_TITLE# - Message title\n#COMMENT_TITLE# - Comment title\n#COMMENT_TEXT# - Comment text\n#COMMENT_DATE# - Comment date\n#COMMENT_PATH# - Comment URL\n#AUTHOR# - Comment author\n#EMAIL_FROM# - Sender email\n#EMAIL_TO# - Recipient email', 100, 'email'),
(42, 'en', 'NEW_BLOG_COMMENT2COMMENT', 'New comment for your in blog', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog title\n#BLOG_URL# - Blog url\n#MESSAGE_TITLE# - Message title\n#COMMENT_TITLE# - Comment title\n#COMMENT_TEXT# - Comment text\n#COMMENT_DATE# - Comment date\n#COMMENT_PATH# - Comment URL\n#AUTHOR# - Comment author\n#EMAIL_FROM# - Sender email\n#EMAIL_TO# - Recipient email', 100, 'email'),
(43, 'en', 'NEW_BLOG_COMMENT_WITHOUT_TITLE', 'New comment in blog (without subject)', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog title\n#BLOG_URL# - Blog url\n#MESSAGE_TITLE# - Message title\n#COMMENT_TEXT# - Comment text\n#COMMENT_DATE# - Comment date\n#COMMENT_PATH# - Comment URL\n#AUTHOR# - Comment author\n#EMAIL_FROM# - Sender email\n#EMAIL_TO# - Recipient email', 100, 'email'),
(44, 'en', 'NEW_BLOG_COMMENT2COMMENT_WITHOUT_TITLE', 'New comment for your in blog (without subject)', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog title\n#BLOG_URL# - Blog url\n#MESSAGE_TITLE# - Message title\n#COMMENT_TEXT# - Comment text\n#COMMENT_DATE# - Comment date\n#COMMENT_PATH# - Comment URL\n#AUTHOR# - Comment author\n#EMAIL_FROM# - Sender email\n#EMAIL_TO# - Recipient email', 100, 'email'),
(45, 'en', 'BLOG_YOUR_BLOG_TO_USER', 'Your blog has been added to friends', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog name\n#BLOG_URL# - Blog name, Latin letters only\n#BLOG_ADR# - Blog address\n#USER_ID# - User ID\n#USER# - User\n#USER_URL# - User URL\n#EMAIL_FROM# - Sender E-mail\n#EMAIL_TO# - Recipient E-mail', 100, 'email'),
(46, 'en', 'BLOG_YOU_TO_BLOG', 'You have been added to blog friends', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog name\n#BLOG_URL# - Blog name, Latin letters only\n#BLOG_ADR# - Blog address\n#USER_ID# - User ID\n#USER# - User\n#USER_URL# - User URL\n#EMAIL_FROM# - Sender E-mail\n#EMAIL_TO# - Recipient E-mail', 100, 'email'),
(47, 'en', 'BLOG_BLOG_TO_YOU', 'A blog has been added to your friends', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog name\n#BLOG_URL# - Blog name, Latin letters only\n#BLOG_ADR# - Blog address\n#USER_ID# - User ID\n#USER# - User\n#USER_URL# - User URL\n#EMAIL_FROM# - Sender E-mail\n#EMAIL_TO# - Recipient E-mail', 100, 'email'),
(48, 'en', 'BLOG_USER_TO_YOUR_BLOG', 'A friend has been added to your blog', '#BLOG_ID# - Blog ID\n#BLOG_NAME# - Blog name\n#BLOG_URL# - Blog name, Latin letters only\n#BLOG_ADR# - Blog address\n#USER_ID# - User ID\n#USER# - User\n#USER_URL# - User URL\n#EMAIL_FROM# - Sender E-mail\n#EMAIL_TO# - Recipient E-mail', 100, 'email'),
(49, 'en', 'BLOG_SONET_NEW_POST', 'New post added', '#EMAIL_TO# - Recipient email\n#POST_ID# - Post ID\n#URL_ID# - Post URL', 100, 'email'),
(50, 'en', 'BLOG_SONET_NEW_COMMENT', 'Comment added', '#EMAIL_TO# - Recipient email\n#COMMENT_ID# - Comment ID\n#POST_ID# - Post ID\n#URL_ID# - Post URL', 100, 'email'),
(51, 'en', 'BLOG_SONET_POST_SHARE', 'New recipient added', '#EMAIL_TO# - Recipient email\n#POST_ID# - Post ID\n#URL_ID# - Post URL', 100, 'email'),
(52, 'en', 'BLOG_POST_BROADCAST', 'New post added', '\n#MESSAGE_TITLE# - Post subject\n#MESSAGE_TEXT# - Post text \n#MESSAGE_PATH# - Post URL\n#AUTHOR# - Post author\n#EMAIL_TO# - E-mail recipient', 100, 'email'),
(53, 'en', 'CATALOG_PRODUCT_SUBSCRIBE_LIST_CONFIRM', 'Код подтверждения', '\n#TOKEN# - Код подтверждения\n#TOKEN_URL# - Ссылка с кодом подтверждения\n#LIST_SUBSCRIBES# - Список подписок\n#URL_PARAMETERS# - Параметры ссылки для подтверждения кода доступа\n', 100, 'email'),
(54, 'en', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY', 'Уведомление о поступлении товара', '#USER_NAME# - имя пользователя\n#EMAIL_TO# - email пользователя\n#NAME# - название товара\n#PAGE_URL# - детальная страница товара\n#CHECKOUT_URL# - добавление товара в корзину\n#CHECKOUT_URL_PARAMETERS# - параметры ссылки добавления товара в корзину\n#PRODUCT_ID# - id товара для формирования ссылок\n#UNSUBSCRIBE_URL# - ссылка отписки от товара\n#UNSUBSCRIBE_URL_PARAMETERS# - параметры ссылки отписки от товара\n', 100, 'email'),
(55, 'en', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY_REPEATED', 'Уведомление о товаре в магазине', '#USER_NAME# - имя пользователя\n#EMAIL_TO# - email пользователя\n#NAME# - название товара\n#PAGE_URL# - детальная страница товара\n#PRODUCT_ID# - id товара для формирования ссылок\n#UNSUBSCRIBE_URL# - ссылка отписки от товара\n#UNSUBSCRIBE_URL_PARAMETERS# - параметры ссылки отписки от товара\n', 100, 'email'),
(56, 'ru', 'CATALOG_PRODUCT_SUBSCRIBE_LIST_CONFIRM', 'Код подтверждения', '\n#TOKEN# - Код подтверждения\n#TOKEN_URL# - Ссылка с кодом подтверждения\n#LIST_SUBSCRIBES# - Список подписок\n#URL_PARAMETERS# - Параметры ссылки для подтверждения кода доступа\n', 100, 'email'),
(57, 'ru', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY', 'Уведомление о поступлении товара', '#USER_NAME# - имя пользователя\n#EMAIL_TO# - email пользователя\n#NAME# - название товара\n#PAGE_URL# - детальная страница товара\n#CHECKOUT_URL# - добавление товара в корзину\n#CHECKOUT_URL_PARAMETERS# - параметры ссылки добавления товара в корзину\n#PRODUCT_ID# - id товара для формирования ссылок\n#UNSUBSCRIBE_URL# - ссылка отписки от товара\n#UNSUBSCRIBE_URL_PARAMETERS# - параметры ссылки отписки от товара\n', 100, 'email'),
(58, 'ru', 'CATALOG_PRODUCT_SUBSCRIBE_NOTIFY_REPEATED', 'Уведомление о товаре в магазине', '#USER_NAME# - имя пользователя\n#EMAIL_TO# - email пользователя\n#NAME# - название товара\n#PAGE_URL# - детальная страница товара\n#PRODUCT_ID# - id товара для формирования ссылок\n#UNSUBSCRIBE_URL# - ссылка отписки от товара\n#UNSUBSCRIBE_URL_PARAMETERS# - параметры ссылки отписки от товара\n', 100, 'email'),
(59, 'ru', 'NEW_FORUM_MESSAGE', 'Новое сообщение на форуме', '\n			#FORUM_ID# - ID форума\n			#FORUM_NAME# - Название форума\n			#TOPIC_ID# - ID темы\n			#MESSAGE_ID# - ID сообщения\n			#TOPIC_TITLE# - Тема сообщения\n			#MESSAGE_TEXT# - Текст сообщения\n			#MESSAGE_DATE# - Дата сообщения\n			#AUTHOR# - Автор сообщения\n			#RECIPIENT# - Получатель сообщения\n			#TAPPROVED# - Тема сообщения показывается\n			#MAPPROVED# - Тело сообщения показывается\n			#PATH2FORUM# - Адрес сообщения\n			#FROM_EMAIL# - E-Mail для поля From письма', 100, 'email'),
(60, 'ru', 'NEW_FORUM_PRIV', 'Приватное письмо посетителю форума', '\n			#FROM_NAME# - Автор сообщения\n			#FROM_EMAIL# - E-Mail автора сообщения\n			#TO_NAME# - Имя получателя сообщения\n			#TO_EMAIL# - E-Mail получателя сообщения\n			#SUBJECT# - Тема сообщения\n			#MESSAGE# - Тело сообщения\n			#MESSAGE_DATE# - Дата сообщения', 100, 'email'),
(61, 'ru', 'NEW_FORUM_PRIVATE_MESSAGE', 'Приватное сообщение', '\n			#FROM_NAME# - Имя автора сообщения\n			#FROM_USER_ID# - ID автора сообщения\n			#FROM_EMAIL# - E-Mail автора сообщения\n			#TO_NAME# - Имя получателя сообщения\n			#TO_USER_ID# - ID получателя сообщения\n			#TO_EMAIL# - E-Mail получателя сообщения\n			#SUBJECT# - Тема сообщения\n			#MESSAGE# - Текст сообщения\n			#MESSAGE_DATE# - Дата сообщения\n			#MESSAGE_LINK# - Ссылка на сообщение', 100, 'email'),
(62, 'ru', 'EDIT_FORUM_MESSAGE', 'Изменение сообщения на форуме', '\n			#FORUM_ID# - ID форума\n			#FORUM_NAME# - Название форума\n			#TOPIC_ID# - ID темы\n			#MESSAGE_ID# - ID сообщения\n			#TOPIC_TITLE# - Тема сообщения\n			#MESSAGE_TEXT# - Текст сообщения\n			#MESSAGE_DATE# - Дата сообщения\n			#AUTHOR# - Автор сообщения\n			#RECIPIENT# - Получатель сообщения\n			#TAPPROVED# - Тема сообщения показывается\n			#MAPPROVED# - Тело сообщения показывается\n			#PATH2FORUM# - Адрес сообщения\n			#FROM_EMAIL# - E-Mail для поля From письма', 100, 'email'),
(63, 'en', 'NEW_FORUM_MESSAGE', 'New forum message', '\n			#FORUM_ID# - Forum ID\n			#FORUM_NAME# - Forum name\n			#TOPIC_ID# - Topic ID\n			#MESSAGE_ID# - Message ID\n			#TOPIC_TITLE# - Topic title\n			#MESSAGE_TEXT# - Message text\n			#MESSAGE_DATE# - Message date\n			#AUTHOR# - Message author\n			#RECIPIENT# - E-Mail recipient\n			#TAPPROVED# - Message topic is approved\n			#MAPPROVED# - Message is approved\n			#PATH2FORUM# - Message Url\n			#FROM_EMAIL# - E-Mail for From field of the EMail', 100, 'email'),
(64, 'en', 'NEW_FORUM_PRIV', 'Private message for forum user', '\n			#FROM_NAME# - Name of the sender\n			#FROM_EMAIL# - E-Mail of the sender\n			#TO_NAME# - Name of recipient\n			#TO_EMAIL# - E-Mail of recipient\n			#SUBJECT# - Topic\n			#MESSAGE# - Message\n			#MESSAGE_DATE# - Date', 100, 'email'),
(65, 'en', 'NEW_FORUM_PRIVATE_MESSAGE', 'Private message for forum user', '\n			#FROM_NAME# - Name of the sender\n			#FROM_USER_ID# - ID of the sender\n			#FROM_EMAIL# - E-Mail of the sender\n			#TO_NAME# - Name of recipient\n			#TO_USER_ID# - ID of recipient\n			#TO_EMAIL# - E-Mail of recipient\n			#SUBJECT# - Topic\n			#MESSAGE# - Message\n			#MESSAGE_DATE# - Date\n			#MESSAGE_LINK# - Link to message', 100, 'email'),
(66, 'en', 'EDIT_FORUM_MESSAGE', 'Changing forum message', '\n			#FORUM_ID# - Forum ID\n			#FORUM_NAME# - Forum name\n			#TOPIC_ID# - Topic ID\n			#MESSAGE_ID# - Message ID\n			#TOPIC_TITLE# - Topic title\n			#MESSAGE_TEXT# - Message text\n			#MESSAGE_DATE# - Message date\n			#AUTHOR# - Message author\n			#RECIPIENT# - E-Mail recipient\n			#TAPPROVED# - Message topic is approved\n			#MAPPROVED# - Message is approved\n			#PATH2FORUM# - Message Url\n			#FROM_EMAIL# - E-Mail for From field of the EMail', 100, 'email'),
(67, 'ru', 'FORUM_NEW_MESSAGE_MAIL', 'Новое сообщение на форуме в режиме общения по E-Mail', '#FORUM_NAME# - Название форума\n#AUTHOR# - Автор сообщения\n#FROM_EMAIL# - E-Mail для поля From письма\n#RECIPIENT# - Получатель сообщения\n#TOPIC_TITLE# - Тема сообщения\n#MESSAGE_TEXT# - Текст сообщения\n#PATH2FORUM# - Адрес сообщения\n#MESSAGE_DATE# - Дата сообщения\n#FORUM_EMAIL# - Е-Mail адрес для добавления сообщений на форум\n#FORUM_ID# - ID форума\n#TOPIC_ID# - ID темы \n#MESSAGE_ID# - ID сообщения\n#TAPPROVED# - Тема опубликована\n#MAPPROVED# - Сообщение опубликовано\n', 100, 'email'),
(68, 'en', 'FORUM_NEW_MESSAGE_MAIL', 'New message at the forum (e-mail messaging mode)', '#FORUM_NAME# - Forum name\n#AUTHOR# - Message author\n#FROM_EMAIL# - E-Mail in the &amp;From&amp; field\n#RECIPIENT# - Message recipient\n#TOPIC_TITLE# - Message subject\n#MESSAGE_TEXT# - Message text\n#PATH2FORUM# - Message URL\n#MESSAGE_DATE# - Message date\n#FORUM_EMAIL# - E-Mail to add messages to the forum \n#FORUM_ID# - Forum ID\n#TOPIC_ID# - Topic ID \n#MESSAGE_ID# - Message ID\n#TAPPROVED# - Topic approved and published\n#MAPPROVED# - Message approved and published\n', 100, 'email'),
(69, 'ru', 'SALE_NEW_ORDER', 'Новый заказ', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#ORDER_USER# - заказчик\n#PRICE# - сумма заказа\n#EMAIL# - E-Mail заказчика\n#BCC# - E-Mail скрытой копии\n#ORDER_LIST# - состав заказа\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(70, 'ru', 'SALE_NEW_ORDER_RECURRING', 'Новый заказ на продление подписки', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#ORDER_USER# - заказчик\n#PRICE# - сумма заказа\n#EMAIL# - E-Mail заказчика\n#BCC# - E-Mail скрытой копии\n#ORDER_LIST# - состав заказа\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(71, 'ru', 'SALE_ORDER_REMIND_PAYMENT', 'Напоминание об оплате заказа', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#ORDER_USER# - заказчик\n#PRICE# - сумма заказа\n#EMAIL# - E-Mail заказчика\n#BCC# - E-Mail скрытой копии\n#ORDER_LIST# - состав заказа\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(72, 'ru', 'SALE_ORDER_CANCEL', 'Отмена заказа', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#EMAIL# - E-Mail пользователя\n#ORDER_CANCEL_DESCRIPTION# - причина отмены\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(73, 'ru', 'SALE_ORDER_PAID', 'Заказ оплачен', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#EMAIL# - E-Mail пользователя\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(74, 'ru', 'SALE_ORDER_DELIVERY', 'Доставка заказа разрешена', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#EMAIL# - E-Mail пользователя\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(75, 'ru', 'SALE_RECURRING_CANCEL', 'Подписка отменена', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#EMAIL# - E-Mail пользователя\n#CANCELED_REASON# - причина отмены\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(76, 'ru', 'SALE_SUBSCRIBE_PRODUCT', 'Уведомление о поступлении товара', '#USER_NAME# - имя пользователя\n#EMAIL# - email пользователя\n#NAME# - название товара\n#PAGE_URL# - детальная страница товара', 100, 'email'),
(77, 'ru', 'SALE_ORDER_TRACKING_NUMBER', 'Уведомление об изменении идентификатора почтового отправления', '#ORDER_ID# - код заказа\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_REAL_ID# - реальный ID заказа\n#ORDER_DATE# - дата заказа\n#ORDER_USER# - заказчик\n#ORDER_TRACKING_NUMBER# - идентификатор почтового отправления\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#EMAIL# - E-Mail заказчика\n#BCC# - E-Mail скрытой копии\n#SALE_EMAIL# - E-Mail отдела продаж', 100, 'email'),
(78, 'ru', 'SALE_CHECK_PRINT', 'Уведомление о печати чека', '#ORDER_ID# - код заказа\n#ORDER_DATE# - дата заказа\n#ORDER_USER# - заказчик\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#CHECK_LINK# - ссылка на чек', 100, 'email'),
(79, 'ru', 'SALE_CHECK_PRINT_ERROR', 'Уведомление об ошибке при печати чека', '#ORDER_ACCOUNT_NUMBER# - код заказа\n#ORDER_DATE# - дата заказа\n#ORDER_ID# - ID заказа\n#CHECK_ID# - номер чека', 100, 'email'),
(80, 'ru', 'SALE_ORDER_SHIPMENT_STATUS_CHANGED', 'Уведомление об изменении статуса почтового отправления', '#SHIPMENT_NO# - номер отгрузки\n#SHIPMENT_DATE# - дата отгрузки\n#ORDER_NO# - номер заказа\n#ORDER_DATE# - дата заказа\n#STATUS_NAME# - название статуса\n#STATUS_DESCRIPTION# - описание статуса\n#TRACKING_NUMBER# - идентификатор почтового отправления\n#EMAIL# - кому будет отправлено письмо\n#BCC# - кому будет отправлена копия письма\n#ORDER_USER# - заказчик\n#DELIVERY_NAME# - наименование службы доставки\n#DELIVERY_TRACKING_URL# - ссылка на сайте службы доставке, где можно подробнее узнать о статусе отправления\n#ORDER_ACCOUNT_NUMBER_ENCODE# - код заказа(для ссылок)\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n#ORDER_DETAIL_URL# - ссылка для просмотра подробной информации о заказе', 100, 'email'),
(81, 'ru', 'SALE_CHECK_VALIDATION_ERROR', 'Уведомление об ошибке при формировании чека', '#ORDER_ACCOUNT_NUMBER# - код заказа\n#ORDER_DATE# - дата заказа\n#ORDER_ID# - ID заказа', 100, 'email'),
(82, 'ru', 'SALE_STATUS_CHANGED_F', 'Изменение статуса заказа на  \"Выполнен\"', '#ORDER_ID# - код заказа\n#ORDER_DATE# - дата заказа\n#ORDER_STATUS# - статус заказа\n#EMAIL# - E-Mail пользователя\n#ORDER_DESCRIPTION# - описание статуса заказа\n#TEXT# - текст\n#SALE_EMAIL# - E-Mail отдела продаж\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n', 100, 'email'),
(83, 'ru', 'SALE_STATUS_CHANGED_N', 'Изменение статуса заказа на  \"Принят, ожидается оплата\"', '#ORDER_ID# - код заказа\n#ORDER_DATE# - дата заказа\n#ORDER_STATUS# - статус заказа\n#EMAIL# - E-Mail пользователя\n#ORDER_DESCRIPTION# - описание статуса заказа\n#TEXT# - текст\n#SALE_EMAIL# - E-Mail отдела продаж\n#ORDER_PUBLIC_URL# - ссылка для просмотра заказа без авторизации (требуется настройка в модуле интернет-магазина)\n', 100, 'email'),
(84, 'en', 'SALE_NEW_ORDER', 'New order', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#ORDER_USER# - customer\n#PRICE# - order amount\n#EMAIL# - customer e-mail\n#BCC# - BCC e-mail\n#ORDER_LIST# - order contents\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(85, 'en', 'SALE_NEW_ORDER_RECURRING', 'New Order for Subscription Renewal', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#ORDER_USER# - customer\n#PRICE# - order amount\n#EMAIL# - customer e-mail\n#BCC# - BCC e-mail\n#ORDER_LIST# - order contents\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(86, 'en', 'SALE_ORDER_REMIND_PAYMENT', 'Order Payment Reminder', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#ORDER_USER# - customer\n#PRICE# - order amount\n#EMAIL# - customer e-mail\n#BCC# - BCC e-mail\n#ORDER_LIST# - order contents\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(87, 'en', 'SALE_ORDER_CANCEL', 'Cancel order', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#EMAIL# - customer e-mail\n#ORDER_LIST# - order contents\n#ORDER_CANCEL_DESCRIPTION# - reason for cancellation\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#SALE_EMAIL# - sales dept. e-mail\n', 100, 'email'),
(88, 'en', 'SALE_ORDER_PAID', 'Paid order', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#EMAIL# - customer e-mail\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(89, 'en', 'SALE_ORDER_DELIVERY', 'Order delivery allowed', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#EMAIL# - customer e-mail\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(90, 'en', 'SALE_RECURRING_CANCEL', 'Recurring payment canceled', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#EMAIL# - customer e-mail\n#CANCELED_REASON# - reason for cancellation\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(91, 'en', 'SALE_SUBSCRIBE_PRODUCT', 'Back in stock notification', '#USER_NAME# - user name\n#EMAIL# - user e-mail \n#NAME# - product name\n#PAGE_URL# - product details page', 100, 'email'),
(92, 'en', 'SALE_ORDER_TRACKING_NUMBER', 'Notification of change in tracking number ', '#ORDER_ID# - order ID\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for URL\'s)\n#ORDER_REAL_ID# - real order ID\n#ORDER_DATE# - order date\n#ORDER_USER# - customer\n#ORDER_TRACKING_NUMBER# - tracking number\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#EMAIL# - customer e-mail\n#BCC# - BCC e-mail\n#SALE_EMAIL# - sales dept. e-mail', 100, 'email'),
(93, 'en', 'SALE_CHECK_PRINT', 'Receipt printout notification', '#ORDER_ID# - order ID\n#ORDER_DATE# - order date\n#ORDER_USER# - customer\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order Id for use in links\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#CHECK_LINK# - receipt link', 100, 'email'),
(94, 'en', 'SALE_CHECK_PRINT_ERROR', 'Receipt printout error notification', '#ORDER_ACCOUNT_NUMBER# - order id\n#ORDER_DATE# - order date\n#ORDER_ID# - order id\n#CHECK_ID# - receipt id', 100, 'email'),
(95, 'en', 'SALE_ORDER_SHIPMENT_STATUS_CHANGED', 'Package status update', '#SHIPMENT_NO# - shipment ID\n#SHIPMENT_DATE# - shipped on\n#ORDER_NO# - order #\n#ORDER_DATE# - order date\n#STATUS_NAME# - status name\n#STATUS_DESCRIPTION# - status description\n#TRACKING_NUMBER# - tracking number\n#EMAIL# - notify e-mail address\n#BCC# - send copy to address\n#ORDER_USER# - customer\n#DELIVERY_NAME# - delivery service name\n#DELIVERY_TRACKING_URL# - delivery service website for more tracking details\n#ORDER_ACCOUNT_NUMBER_ENCODE# - order ID (for links)\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n#ORDER_DETAIL_URL# - order details URL', 100, 'email'),
(96, 'en', 'SALE_CHECK_VALIDATION_ERROR', 'Receipt create error notification', '#ORDER_ACCOUNT_NUMBER# - order #\n#ORDER_DATE# - order date\n#ORDER_ID# - order ID', 100, 'email'),
(97, 'en', 'SALE_STATUS_CHANGED_F', 'Changing order status to \"\"', '#ORDER_ID# - order ID\n#ORDER_DATE# - order date\n#ORDER_STATUS# - order status\n#EMAIL# - customer e-mail\n#ORDER_DESCRIPTION# - order status description\n#TEXT# - text\n#SALE_EMAIL# - Sales department e-mail\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n', 100, 'email'),
(98, 'en', 'SALE_STATUS_CHANGED_N', 'Changing order status to \"\"', '#ORDER_ID# - order ID\n#ORDER_DATE# - order date\n#ORDER_STATUS# - order status\n#EMAIL# - customer e-mail\n#ORDER_DESCRIPTION# - order status description\n#TEXT# - text\n#SALE_EMAIL# - Sales department e-mail\n#ORDER_PUBLIC_URL# - order view link for unauthorized users (requires configuration in the e-Store module settings)\n', 100, 'email'),
(99, 'ru', 'VIRUS_DETECTED', 'Обнаружен вирус', '#EMAIL# - E-Mail администратора сайта (из настроек главного модуля)', 100, 'email'),
(100, 'en', 'VIRUS_DETECTED', 'Virus detected', '#EMAIL# - Site administrator\'s e-mail address (from the Kernel module settings)', 100, 'email'),
(101, 'ru', 'SENDER_SUBSCRIBE_CONFIRM', 'Подтверждение подписки', '#EMAIL# - адрес подписки\n#DATE# - дата добавления/изменения адреса\n#CONFIRM_URL# - адрес подтверждения\n#MAILING_LIST# - список подписок\n', 100, 'email'),
(102, 'en', 'SENDER_SUBSCRIBE_CONFIRM', 'Confirm subscription', '#EMAIL# - subscription URL\n#DATE# - the date the address was added or updated\n#CONFIRM_URL# - confirmation URL\n#MAILING_LIST# - subscriptions\n', 100, 'email'),
(103, 'ru', 'SUBSCRIBE_CONFIRM', 'Подтверждение подписки', '#ID# - идентификатор подписки\n#EMAIL# - адрес подписки\n#CONFIRM_CODE# - код подтверждения\n#SUBSCR_SECTION# - раздел, где находится страница редактирования подписки (задается в настройках)\n#USER_NAME# - имя подписчика (может отсутствовать)\n#DATE_SUBSCR# - дата добавления/изменения адреса\n', 100, 'email'),
(104, 'en', 'SUBSCRIBE_CONFIRM', 'Confirmation of subscription', '#ID# - subscription ID\n#EMAIL# - subscription email\n#CONFIRM_CODE# - confirmation code\n#SUBSCR_SECTION# - section with subscription edit page (specifies in the settings)\n#USER_NAME# - subscriber\'s name (optional)\n#DATE_SUBSCR# - date of adding/change of address\n', 100, 'email'),
(105, 'ru', 'VOTE_FOR', 'Новый голос', '#ID# - ID результата голосования\n#TIME# - время голосования\n#VOTE_TITLE# - наименование опроса\n#VOTE_DESCRIPTION# - описание опроса\n#VOTE_ID# - ID опроса\n#CHANNEL# - наименование группы опроса\n#CHANNEL_ID# - ID группы опроса\n#VOTER_ID# - ID проголосовавшего посетителя\n#USER_NAME# - ФИО пользователя\n#LOGIN# - логин\n#USER_ID# - ID пользователя\n#STAT_GUEST_ID# - ID посетителя модуля статистики\n#SESSION_ID# - ID сессии модуля статистики\n#IP# - IP адрес\n#VOTE_STATISTIC# - Сводная статистика опроса типа ( - Вопрос - Ответ )\n#URL# - Путь к опросу\n', 100, 'email'),
(106, 'en', 'VOTE_FOR', 'New vote', '#ID# - Vote result ID\n#TIME# - Time of vote\n#VOTE_TITLE# - Poll name\n#VOTE_DESCRIPTION# - Poll description\n#VOTE_ID# - Poll ID\n#CHANNEL# - Poll group name\n#CHANNEL_ID# - Poll group ID\n#VOTER_ID# - Voter\'s user ID\n#USER_NAME# - User full name\n#LOGIN# - login\n#USER_ID# - User ID\n#STAT_GUEST_ID# - Visitor ID in web analytics module\n#SESSION_ID# - Session ID in web analytics module\n#IP# - IP address\n#VOTE_STATISTIC# - Summary statistics of this poll type ( - Question - Answer)\n#URL# - Poll URL', 100, 'email'),
(279, 'ru', 'NEW_DEVICE_LOGIN', 'Вход с нового устройства', '#USER_ID# - ID пользователя\n#EMAIL# - Email пользователя\n#LOGIN# - Логин пользователя\n#NAME# - Имя пользователя\n#LAST_NAME# - Фамилия пользователя\n#DEVICE# - Устройство\n#BROWSER# - Браузер\n#PLATFORM# - Платформа\n#USER_AGENT# - User agent\n#IP# - IP-адрес\n#DATE# - Дата\n#COUNTRY# - Страна\n#REGION# - Регион\n#CITY# - Город\n#LOCATION# - Объединенные город, регион, страна\n', 150, 'email'),
(280, 'en', 'NEW_DEVICE_LOGIN', 'New device signed in', '#USER_ID# - User ID\n#EMAIL# - User email:\n#LOGIN# - User login\n#NAME# - User first name\n#LAST_NAME# - User last name\n#DEVICE# - Device\n#BROWSER# - Browser\n#PLATFORM# - Platform\n#USER_AGENT# - User agent\n#IP# - IP address\n#DATE# - Date\n#COUNTRY# - Country\n#REGION# - Region\n#CITY# - City\n#LOCATION# - Full location (city, region, country)\n', 150, 'email'),
(281, 'ru', 'CALENDAR_SHARING', NULL, NULL, 100, 'email'),
(282, 'en', 'CALENDAR_SHARING', NULL, NULL, 100, 'email'),
(283, 'ru', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Заполнена web-форма \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (оригинальное значение)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (оригинальное значение)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (оригинальное значение)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (оригинальное значение)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (оригинальное значение)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (оригинальное значение)\n', 100, 'email'),
(284, 'en', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Web form filled \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (original value)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (original value)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (original value)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (original value)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (original value)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (original value)\n', 100, 'email'),
(285, 'br', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Web form filled \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (original value)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (original value)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (original value)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (original value)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (original value)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (original value)\n', 100, 'email'),
(286, 'fr', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'formulaire Web rempli \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (valeur originale)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (valeur originale)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (valeur originale)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (valeur originale)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (valeur originale)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (valeur originale)\n', 100, 'email'),
(287, 'it', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Web form filled \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (original value)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (original value)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (original value)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (original value)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (original value)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (original value)\n', 100, 'email'),
(288, 'la', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (valor original)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (valor original)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (valor original)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (valor original)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (valor original)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (valor original)\n', 100, 'email'),
(289, 'pl', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (wartość początkowa)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (wartość początkowa)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (wartość początkowa)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (wartość początkowa)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (wartość początkowa)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (wartość początkowa)\n', 100, 'email'),
(290, 'ua', 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', 'Заповнена web-форма \"aspro_allcorp3resort_order_page_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#COMPANY# - Название компании\n#COMPANY_RAW# - Название компании (оригінальне значення)\n#ADDRESS# - Адрес доставки\n#ADDRESS_RAW# - Адрес доставки (оригінальне значення)\n#MESSAGE# - Комментарий к заказу\n#MESSAGE_RAW# - Комментарий к заказу (оригінальне значення)\n#ORDER_LIST# - Состав заказа\n#ORDER_LIST_RAW# - Состав заказа (оригінальне значення)\n#SESSION_ID# - SESSION_ID\n#SESSION_ID_RAW# - SESSION_ID (оригінальне значення)\n#TOTAL_SUMM# - TOTAL_SUMM \n#TOTAL_SUMM_RAW# - TOTAL_SUMM  (оригінальне значення)\n', 100, 'email'),
(291, 'ru', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Заполнена web-форма \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(292, 'en', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Web form filled \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(293, 'br', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Web form filled \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(294, 'fr', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'formulaire Web rempli \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(295, 'it', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Web form filled \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(296, 'la', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(297, 'pl', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(298, 'ua', 'FORM_FILLING_aspro_allcorp3resort_director_s1', 'Заповнена web-форма \"aspro_allcorp3resort_director_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#TITLE# - Тема\n#TITLE_RAW# - Тема (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(299, 'ru', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Заполнена web-форма \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (оригинальное значение)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (оригинальное значение)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (оригинальное значение)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (оригинальное значение)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(300, 'en', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Web form filled \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (original value)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (original value)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (original value)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (original value)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(301, 'br', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Web form filled \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (original value)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (original value)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (original value)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (original value)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(302, 'fr', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'formulaire Web rempli \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (valeur originale)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (valeur originale)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (valeur originale)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (valeur originale)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(303, 'it', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Web form filled \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (original value)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (original value)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (original value)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (original value)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(304, 'la', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (valor original)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (valor original)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (valor original)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (valor original)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(305, 'pl', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (wartość początkowa)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (wartość początkowa)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (wartość początkowa)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (wartość początkowa)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(306, 'ua', 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', 'Заповнена web-форма \"aspro_allcorp3resort_order_product_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Имя и фамилия\n#NAME_RAW# - Имя и фамилия (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#FROM# - Дата приезда\n#FROM_RAW# - Дата приезда (оригінальне значення)\n#TO# - Дата отъезда\n#TO_RAW# - Дата отъезда (оригінальне значення)\n#PRODUCT# - Тип проживания\n#PRODUCT_RAW# - Тип проживания (оригінальне значення)\n#NUMBERS# - Количество человек\n#NUMBERS_RAW# - Количество человек (оригінальне значення)\n#SERVICES# - Дополнительные услуги\n#SERVICES_RAW# - Дополнительные услуги (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(307, 'ru', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Заполнена web-форма \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(308, 'en', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Web form filled \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(309, 'br', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Web form filled \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(310, 'fr', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'formulaire Web rempli \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(311, 'it', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Web form filled \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(312, 'la', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(313, 'pl', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(314, 'ua', 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', 'Заповнена web-форма \"aspro_allcorp3resort_order_project_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#PROJECT# - Проект\n#PROJECT_RAW# - Проект (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(315, 'ru', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Заполнена web-форма \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(316, 'en', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Web form filled \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(317, 'br', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Web form filled \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(318, 'fr', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'formulaire Web rempli \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(319, 'it', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Web form filled \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(320, 'la', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(321, 'pl', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(322, 'ua', 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', 'Заповнена web-форма \"aspro_allcorp3resort_order_services_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#SERVICE# - Услуга\n#SERVICE_RAW# - Услуга (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(323, 'ru', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Заполнена web-форма \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (оригинальное значение)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (оригинальное значение)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (оригинальное значение)\n', 100, 'email'),
(324, 'en', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Web form filled \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (original value)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (original value)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (original value)\n', 100, 'email'),
(325, 'br', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Web form filled \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (original value)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (original value)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (original value)\n', 100, 'email'),
(326, 'fr', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'formulaire Web rempli \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (valeur originale)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (valeur originale)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (valeur originale)\n', 100, 'email'),
(327, 'it', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Web form filled \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (original value)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (original value)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (original value)\n', 100, 'email'),
(328, 'la', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (valor original)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (valor original)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (valor original)\n', 100, 'email'),
(329, 'pl', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (wartość początkowa)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (wartość początkowa)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (wartość początkowa)\n', 100, 'email'),
(330, 'ua', 'FORM_FILLING_aspro_allcorp3resort_resume_s1', 'Заповнена web-форма \"aspro_allcorp3resort_resume_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#POST# - Желаемая должность\n#POST_RAW# - Желаемая должность (оригінальне значення)\n#MESSAGE# - Дополнительная информация\n#MESSAGE_RAW# - Дополнительная информация (оригінальне значення)\n#FILE# - Файл с резюме\n#FILE_RAW# - Файл с резюме (оригінальне значення)\n', 100, 'email'),
(331, 'ru', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Заполнена web-форма \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(332, 'en', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Web form filled \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(333, 'br', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Web form filled \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(334, 'fr', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'formulaire Web rempli \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(335, 'it', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Web form filled \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(336, 'la', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(337, 'pl', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(338, 'ua', 'FORM_FILLING_aspro_allcorp3resort_question_s1', 'Заповнена web-форма \"aspro_allcorp3resort_question_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#NEED_PRODUCT# - Интересующий товар/услуга\n#NEED_PRODUCT_RAW# - Интересующий товар/услуга (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(339, 'ru', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Заполнена web-форма \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n', 100, 'email'),
(340, 'en', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Web form filled \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(341, 'br', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Web form filled \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(342, 'fr', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'formulaire Web rempli \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n', 100, 'email'),
(343, 'it', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Web form filled \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(344, 'la', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n', 100, 'email'),
(345, 'pl', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n', 100, 'email'),
(346, 'ua', 'FORM_FILLING_aspro_allcorp3resort_callback_s1', 'Заповнена web-форма \"aspro_allcorp3resort_callback_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n', 100, 'email'),
(347, 'ru', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Заполнена web-форма \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (оригинальное значение)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(348, 'en', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Web form filled \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (original value)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(349, 'br', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Web form filled \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (original value)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(350, 'fr', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'formulaire Web rempli \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (valeur originale)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(351, 'it', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Web form filled \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (original value)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(352, 'la', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (valor original)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(353, 'pl', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (wartość początkowa)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(354, 'ua', 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', 'Заповнена web-форма \"aspro_allcorp3resort_callstaff_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#STAFF# - Сотрудник\n#STAFF_RAW# - Сотрудник (оригінальне значення)\n#STAFF_EMAIL_HIDDEN# - Email сотрудника\n#STAFF_EMAIL_HIDDEN_RAW# - Email сотрудника (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email'),
(355, 'ru', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Заполнена web-форма \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (оригинальное значение)\n#FILE# - Файл\n#FILE_RAW# - Файл (оригинальное значение)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#POST# - Должность\n#POST_RAW# - Должность (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n', 100, 'email'),
(356, 'en', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Web form filled \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (original value)\n#FILE# - Файл\n#FILE_RAW# - Файл (original value)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#POST# - Должность\n#POST_RAW# - Должность (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(357, 'br', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Web form filled \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (original value)\n#FILE# - Файл\n#FILE_RAW# - Файл (original value)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#POST# - Должность\n#POST_RAW# - Должность (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(358, 'fr', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'formulaire Web rempli \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (valeur originale)\n#FILE# - Файл\n#FILE_RAW# - Файл (valeur originale)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#POST# - Должность\n#POST_RAW# - Должность (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n', 100, 'email'),
(359, 'it', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Web form filled \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (original value)\n#FILE# - Файл\n#FILE_RAW# - Файл (original value)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#POST# - Должность\n#POST_RAW# - Должность (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n', 100, 'email'),
(360, 'la', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (valor original)\n#FILE# - Файл\n#FILE_RAW# - Файл (valor original)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#POST# - Должность\n#POST_RAW# - Должность (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n', 100, 'email'),
(361, 'pl', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (wartość początkowa)\n#FILE# - Файл\n#FILE_RAW# - Файл (wartość początkowa)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#POST# - Должность\n#POST_RAW# - Должность (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n', 100, 'email'),
(362, 'ua', 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', 'Заповнена web-форма \"aspro_allcorp3resort_feedback_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#RATING# - Ваша оценка\n#RATING_RAW# - Ваша оценка (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n#PHOTO# - Ваша фотография\n#PHOTO_RAW# - Ваша фотография (оригінальне значення)\n#FILE# - Файл\n#FILE_RAW# - Файл (оригінальне значення)\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#POST# - Должность\n#POST_RAW# - Должность (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n', 100, 'email'),
(363, 'ru', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Заполнена web-форма \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (оригинальное значение)\n', 100, 'email'),
(364, 'en', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Web form filled \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (original value)\n', 100, 'email'),
(365, 'br', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Web form filled \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (original value)\n', 100, 'email'),
(366, 'fr', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'formulaire Web rempli \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (valeur originale)\n', 100, 'email'),
(367, 'it', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Web form filled \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (original value)\n', 100, 'email'),
(368, 'la', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (valor original)\n', 100, 'email'),
(369, 'pl', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (wartość początkowa)\n', 100, 'email'),
(370, 'ua', 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', 'Заповнена web-форма \"aspro_allcorp3resort_quick_buy_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#PRODUCT_NAME# - Продукт\n#PRODUCT_NAME_RAW# - Продукт (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n#PRODUCT_PRICE# - Цена продукта\n#PRODUCT_PRICE_RAW# - Цена продукта (оригінальне значення)\n', 100, 'email'),
(371, 'ru', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Заполнена web-форма \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - ID формы\n#RS_FORM_NAME# - Имя формы\n#RS_FORM_SID# - SID формы\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заполнения формы\n#RS_USER_ID# - ID пользователя\n#RS_USER_EMAIL# - EMail пользователя\n#RS_USER_NAME# - Фамилия, имя пользователя\n#RS_USER_AUTH# - Пользователь был авторизован?\n#RS_STAT_GUEST_ID# - ID посетителя\n#RS_STAT_SESSION_ID# - ID сессии\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригинальное значение)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригинальное значение)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригинальное значение)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (оригинальное значение)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригинальное значение)\n', 100, 'email'),
(372, 'en', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Web form filled \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(373, 'br', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Web form filled \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(374, 'fr', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'formulaire Web rempli \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - image de formulaire\n#RS_FORM_NAME# - Nom de la forme\n#RS_FORM_SID# - SID du formulaire\n#RS_RESULT_ID# - ID du résultat\n#RS_DATE_CREATE# - Date de remplissage du formulaire\n#RS_USER_ID# - Identifiant de l\'utilisateur\n#RS_USER_EMAIL# - Adresse emailde l\'utilisateur\n#RS_USER_NAME# - Nom, prénom de l\'utilisateur\n#RS_USER_AUTH# - L\'utilisateur a-t-il été autorisé ?\n#RS_STAT_GUEST_ID# - Identifiant du visiteur\n#RS_STAT_SESSION_ID# - ID de la session\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valeur originale)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valeur originale)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valeur originale)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (valeur originale)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valeur originale)\n', 100, 'email'),
(375, 'it', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Web form filled \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - Form ID\n#RS_FORM_NAME# - Form name\n#RS_FORM_SID# - Form SID\n#RS_RESULT_ID# - Result ID\n#RS_DATE_CREATE# - Form filling date\n#RS_USER_ID# - User ID\n#RS_USER_EMAIL# - User e-mail\n#RS_USER_NAME# - First and last user names\n#RS_USER_AUTH# - User authorized?\n#RS_STAT_GUEST_ID# - Visitor ID\n#RS_STAT_SESSION_ID# - Session ID\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (original value)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (original value)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (original value)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (original value)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (original value)\n', 100, 'email'),
(376, 'la', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Formulario Web rellenado \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - ID del formulario\n#RS_FORM_NAME# - Nombre del formulario\n#RS_FORM_SID# - SID formulario\n#RS_RESULT_ID# - ID resultado\n#RS_DATE_CREATE# - Completando fecha del formulario\n#RS_USER_ID# - ID usuario\n#RS_USER_EMAIL# - E-Mail de usuario\n#RS_USER_NAME# - Nombres completos de usuarios\n#RS_USER_AUTH# - ¿Es usuario autorizado?\n#RS_STAT_GUEST_ID# - ID de visitante\n#RS_STAT_SESSION_ID# - ID de sesión\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (valor original)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (valor original)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (valor original)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (valor original)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (valor original)\n', 100, 'email'),
(377, 'pl', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Wypełniony formularz sieciowy \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - ID Formularza\n#RS_FORM_NAME# - Nazwa Formularza\n#RS_FORM_SID# - Formularz SID\n#RS_RESULT_ID# - ID Wyniku\n#RS_DATE_CREATE# - Data wypełnienia formularza\n#RS_USER_ID# - ID Użytkownika\n#RS_USER_EMAIL# - E-mail użytkownika\n#RS_USER_NAME# - Imię i nazwisko użytkownika\n#RS_USER_AUTH# - Użytkownik autoryzowany?\n#RS_STAT_GUEST_ID# - ID Gościa\n#RS_STAT_SESSION_ID# - ID Sesji\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (wartość początkowa)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (wartość początkowa)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (wartość początkowa)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (wartość początkowa)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (wartość początkowa)\n', 100, 'email'),
(378, 'ua', 'FORM_FILLING_aspro_allcorp3resort_tour_s1', 'Заповнена web-форма \"aspro_allcorp3resort_tour_s1\"', '#RS_FORM_ID# - ID форми\n#RS_FORM_NAME# - Ім\'я форми\n#RS_FORM_SID# - SID форми\n#RS_RESULT_ID# - ID результата\n#RS_DATE_CREATE# - Дата заповнення форми\n#RS_USER_ID# - ID користувача\n#RS_USER_EMAIL# - E-mail користувача\n#RS_USER_NAME# - Прізвище, ім\'я користувача\n#RS_USER_AUTH# - Користувач був авторизований?\n#RS_STAT_GUEST_ID# - ID відвідувача\n#RS_STAT_SESSION_ID# - ID сесії\n#NAME# - Ваше имя\n#NAME_RAW# - Ваше имя (оригінальне значення)\n#PHONE# - Телефон\n#PHONE_RAW# - Телефон (оригінальне значення)\n#EMAIL# - E-mail\n#EMAIL_RAW# - E-mail (оригінальне значення)\n#PRODUCT# - Тур\n#PRODUCT_RAW# - Тур (оригінальне значення)\n#MESSAGE# - Сообщение\n#MESSAGE_RAW# - Сообщение (оригінальне значення)\n', 100, 'email');
-- -----------------------------------
-- Dumping table b_favorite
-- -----------------------------------
DROP TABLE IF EXISTS `b_favorite`;
CREATE TABLE `b_favorite` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `C_SORT` int NOT NULL DEFAULT '100',
  `MODIFIED_BY` int DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `URL` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `COMMENTS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `LANGUAGE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `CODE_ID` int DEFAULT NULL,
  `COMMON` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `MENU_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_file
-- -----------------------------------
DROP TABLE IF EXISTS `b_file`;
CREATE TABLE `b_file` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `MODULE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HEIGHT` int DEFAULT NULL,
  `WIDTH` int DEFAULT NULL,
  `FILE_SIZE` bigint DEFAULT NULL,
  `CONTENT_TYPE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'IMAGE',
  `SUBDIR` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FILE_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ORIGINAL_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HANDLER_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EXTERNAL_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FILE_EXTERNAL_ID` (`EXTERNAL_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=625 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_file` VALUES
(1, '2023-04-27 00:09:22', '', 900, 1920, 280316, 'image/jpeg', 'CAllcorp3Resort/2c9', 'ltis7dd7zdpz2om3ghh17qtx10chwpfb.jpg', '623f79835b25f993eec6a18e522c8422.jpg', '', NULL, 'a21aa5c9832df136d3e147b8d0599af8'),
(2, '2023-04-27 00:09:22', '', 640, 960, 400738, 'image/jpeg', 'CAllcorp3Resort/9e6', 'bjm15diilu7z21136i1ne8y3rljt1w29.jpg', '9f6172161d2e9b955b27e92202dba502.jpg', '', NULL, 'af3a347115165b4f0bbdf0bccd329ea2'),
(3, '2023-04-27 00:09:25', 'main', 0, 0, 1695, 'application/octet-stream', 'uf/a3e', 'g3tuzjogttg0z7cdnbkz962yqkowbvdq.svg', 'visa.svg', '', NULL, 'b81ec94087a14619f53ff40d832fdd07'),
(4, '2023-04-27 00:09:25', 'main', 0, 0, 683, 'application/octet-stream', 'uf/98f', 'p1y8l0e4dax4vrlft3q5td1k2k4mr820.svg', 'mastercard.svg', '', NULL, '00d1d6a6d4563ab9730b06d9c65fd380'),
(5, '2023-04-27 00:09:25', 'main', 0, 0, 1968, 'application/octet-stream', 'uf/516', '3yl3s3snx80gy7r2xpvlqgsxap3r5rfx.svg', 'cach.svg', '', NULL, '8a9bb36738193cc689904b86a93656d3'),
(6, '2023-04-27 00:09:25', 'main', 0, 0, 1497, 'application/octet-stream', 'uf/899', 'uswvzwxkunfguam5fy8ybmukag02mybn.svg', 'mir.svg', '', NULL, '723f214cc6e1acb0e128c31e30b45930'),
(7, '2023-04-27 00:09:27', 'iblock', 60, 60, 922, 'image/png', 'iblock/b93', 'h3pqg8zf9qxt9sbwbfm9runjqcggxqpe.png', 'v2q7binpm7aillp1ocvvb10nrp2hii49.png', '', NULL, '6bee92241b90cda601be6ec9f6c00edc'),
(8, '2023-06-29 21:03:25', 'iblock', 140, 140, 11240, 'image/jpeg', 'iblock/3b4', 'qx8a0kgvx9q09pp7tnrw9p8gl0mc2ynt.jpg', '3kmwise0agao34bhgn4lbcj5kz4bvlm1.jpg', '', NULL, 'a45597b5e0fd2483198b9e90cfbb1f8f'),
(9, '2023-04-27 00:09:27', 'iblock', 0, 0, 2594, 'application/octet-stream', 'iblock/0dc', 'xzzbyqk5c2u8w3m8oobmh6jyj6406gvc.svg', '9dvr0d75i970rv3n4qw06xgrgr4zo33h.svg', '', NULL, '9d99f699a2ba7b81f7c67cb3ff1e0abb'),
(10, '2023-04-27 00:09:27', 'iblock', 140, 140, 8470, 'image/jpeg', 'iblock/271', 'oop3dexsi0fem3yk6t6eq043m3wxa1kp.jpg', 'p5wh1su2xxi9tzl18hg6oaile22hudiy.jpg', '', NULL, '0c8a2405489a25ffa250fc53e0213b97'),
(11, '2023-04-27 00:09:27', 'iblock', 0, 0, 2780, 'application/octet-stream', 'iblock/3d6', 'vvecwlkh2y72et9ehofwxrjpkkgfh855.svg', 'h5d4ge28e2y8y6tjkvdt74fil8t2jaw5.svg', '', NULL, 'c2f13e59b50ef5ebb22273e4bb4cbaf8'),
(12, '2023-04-27 00:09:27', 'iblock', 140, 140, 11993, 'image/jpeg', 'iblock/505', 'to5pbuo2c3v67h46wq5zs0v7k2ii7jh0.jpg', 'dwj3zgq5mjgguldd4k9y2jdm021epq5i.jpg', '', NULL, '2815d1c06cda6587bbb7ef1b76887f01'),
(13, '2023-04-27 00:09:27', 'iblock', 0, 0, 6954, 'application/octet-stream', 'iblock/95e', 'a6c39pjgr6xojrqlodpdhhqnp3auwmlq.svg', 'ibra191x8wq53vhc3m21vcwueqbjl1gg.svg', '', NULL, 'ec34665422bd7517e9d1b77dfe1ae8ca'),
(14, '2023-04-27 00:09:28', 'iblock', 140, 140, 13683, 'image/jpeg', 'iblock/96d', 'ufoo4y9kja5coufcmg0cnru73x5vc08b.jpg', '2f43xwbzz875qo03vmljc79o2o6npzly.jpg', '', NULL, '2694eb12d569006a97ff56261285875d'),
(15, '2023-04-27 00:09:28', 'iblock', 0, 0, 2964, 'application/octet-stream', 'iblock/63a', 've2mbuyem11kqamvpzs9b2ewbulafpzf.svg', '7nreonnn95yenxxopjmzcwbjzmkf3nke.svg', '', NULL, 'feddabb5998ccbd0c45a84378b16194a'),
(16, '2023-04-27 00:09:29', 'iblock', 551, 824, 94489, 'image/jpeg', 'iblock/60e', 'n2gn9cy3khmhhuwcfklu5u8mdv17zeiw.jpg', 'mxiptxed0rt41590m1obciqtx04j9rvg.jpg', '', NULL, '598299aadc2e9912b8e94506b3362c68'),
(17, '2023-04-27 00:09:29', 'iblock', 551, 824, 106334, 'image/jpeg', 'iblock/7b9', 'n3txj0o7bbp6sz1vvo7r56yg3boo1m5r.jpg', 'e4udq6jyl40dkpckrt5ozo4exytnyj59.jpg', '0', NULL, 'efd39dfc7c751cd607da1ae12c6cf775'),
(18, '2023-04-27 00:09:29', 'iblock', 551, 824, 79182, 'image/jpeg', 'iblock/888', 'jd0q7siz6wj0hzb80310tiwg4osq1fsg.jpg', 'qympjb4uahcu1buhgccgj5kweemm3363.jpg', '', NULL, '1615ce9025fc69b8c5a86d79b29d05ad'),
(19, '2023-04-27 00:09:29', 'iblock', 551, 824, 120111, 'image/jpeg', 'iblock/6b0', 'a3dsyx72nl2bppx3qs5cbfnjzza1r1k3.jpg', '3zq1umt5h65ig3x0029r2ksqqwokkjpy.jpg', '', NULL, 'ea01c0b3a8c1f77ca3123dbed009af66'),
(20, '2023-04-27 00:09:30', 'main', 0, 0, 3531, 'application/octet-stream', 'uf/f8e', 'o69t18kp7yj7ahsj9wbvaf0wmdpop91l.svg', 'hf34ruq39exee3du54xxm14uybrq7wup.svg', '', NULL, '8434ae41059ac48f2c9a572df150c0a3'),
(21, '2023-04-27 00:09:30', 'main', 120, 120, 19661, 'image/png', 'uf/0d5', 'e8uxh58zoly12r4awwglqqs9o492aix0.png', 'iz9vbik0ckovfbmrh2k1222hzn1m1j3h.png', '', NULL, '0001da9042bb4e62fb2cee087e5b62bc'),
(22, '2023-04-27 00:09:30', 'main', 0, 0, 7647, 'application/octet-stream', 'uf/009', 'ewae0t6sx9pa0bt32fj7kxm7mmtxsf0q.svg', 'd3fetavtdwcg60882s7rpaqidbmogkkq.svg', '', NULL, '09dda7d38e5f00b05649b603b14e0ca7'),
(23, '2023-04-27 00:09:30', 'main', 120, 120, 23872, 'image/png', 'uf/b41', '2796aokbn3b4k3d0xjx4yt7986zk0wh5.png', 'b2jqvrmv11v5zseult7a60mzsm7q2uos.png', '', NULL, 'a705b0c7d46c02f8c5fc9f54f44eb36d'),
(24, '2023-04-27 00:09:30', 'main', 0, 0, 2656, 'application/octet-stream', 'uf/fbc', 'mwpkx1qqez41zjhk8mjb5zco30sgcoh3.svg', 'xep1rdw6l5qbfc5zq4u3kv94hbsetlyo.svg', '', NULL, '9ef76cc7210ffb6a479c7339af60cc65'),
(25, '2023-04-27 00:09:30', 'main', 120, 120, 23715, 'image/png', 'uf/812', 'vudks173b8nxc1djwsznos0gtjjp60zg.png', '7r3dceffkoabdtf0njx2lzg3q51l3p5w.png', '', NULL, 'd7509462bcfc4a004891333c8e6246bc'),
(26, '2023-04-27 00:09:30', 'main', 0, 0, 1440, 'application/octet-stream', 'uf/559', 'v4i1ry0whwqpunie9tyjnd3rqe70qkqf.svg', 'wxsd3e4wso8y119fojvlpmgyvi592ajy.svg', '', NULL, 'ed40a87754ee4cbc6d11e2c389762c41'),
(27, '2023-04-27 00:09:30', 'main', 120, 120, 26056, 'image/png', 'uf/2de', 'omwxn9fwu5znu7oy1bwnr2wj6j6chmpe.png', 'obdic46rqcastjt13dzpv67gshooesji.png', '', NULL, '2d6b80daa81812026471c26c28bf1b40'),
(48, '2023-04-27 00:09:36', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, 'a00d1d8abb614ced250707edd1a83f2e'),
(49, '2023-04-27 00:09:36', 'iblock', 330, 330, 183471, 'image/png', 'iblock/b7a', 'ncd3q3ge898bg45pmcu23fkqx9vbn5uy.xls', 'kit3xnee818l26gehjzded91aw38qafi.xls', '', NULL, '021f682d002c136ad59c1b1f80778dcc'),
(50, '2023-04-27 00:09:36', 'iblock', 16, 16, 32988, 'image/vnd.microsoft.icon', 'iblock/dc3', '0609fpn3y5j625h8p6rck7mti6a24hw7.hhh', 'swouo23qwm786xrjyk3puba9mrxy9wpk.hhh', '', NULL, '8d56e9ff588c1bc0650086840e9c9626'),
(51, '2023-04-27 00:09:46', 'iblock', 0, 0, 740, 'application/octet-stream', 'iblock/e3e', 'k8fqufoos5q9cy37k9dn9voddi8o3xnl.svg', 'rzsrnczkjttlhd33nv072wehmhszuddq.svg', '', NULL, 'bf37ce5703ba943c155e832d8e4486be'),
(52, '2023-04-27 00:09:46', 'iblock', 0, 0, 1854, 'application/octet-stream', 'iblock/e4f', 'rgn7yrfkzsz7b0bb04xpztved4az7eq5.svg', '912asvr8thybhftzpxs15sworrid3n80.svg', '', NULL, '7d75929adfab219c31077e8d64878b2d'),
(53, '2023-04-27 00:09:46', 'iblock', 0, 0, 1165, 'application/octet-stream', 'iblock/101', 'hdtrlx6ekicbp8nghadtmu3ootw7o8p6.svg', '7v9zrlzqmtoacbssja5jbwokppkzhzzg.svg', '', NULL, '8cc7cc8506866e7976aa53cd79a9c194'),
(54, '2023-04-27 00:09:46', 'iblock', 0, 0, 838, 'application/octet-stream', 'iblock/82a', 'entlwt8xuplq9rpg3n4bqdo651ktnnwb.svg', '4o0nyxhb2voq7wlfaf3hjlk2en073876.svg', '', NULL, '36104aa99130e5b940ef339ca3655756'),
(55, '2023-04-27 00:09:46', 'iblock', 0, 0, 1343, 'application/octet-stream', 'iblock/b63', '5zjeyy0b1jfc7hfimf9k1o03l03l8cgj.svg', 'eudgb0e1cm5slwd8o2v2s80lkojc0mn3.svg', '', NULL, '173a650b8c48495833aa2de4ba9b2669'),
(56, '2023-04-27 00:09:46', 'iblock', 0, 0, 1125, 'application/octet-stream', 'iblock/9d9', '3z68slk1i1e74kxw2mukhys02cryj67k.svg', 'ox9l5f62vz00985ywx3jenb8arspkgym.svg', '', NULL, '9fb3294cd52589ec65417013931a9d46'),
(57, '2023-04-27 00:09:46', 'iblock', 0, 0, 931, 'application/octet-stream', 'iblock/e51', '0vjuvlga5tw6895t7wtdky9syyh8lnu2.svg', '3rza3xsmv8hgfd7w5scsob1s20txzfa5.svg', '', NULL, '7d8716af6765d69ca9b802671c711efe'),
(58, '2023-04-27 00:09:46', 'iblock', 0, 0, 1007, 'application/octet-stream', 'iblock/52c', 'qhqwu05dlovwzxo6vj7ixm9wkctibvw9.svg', '9zwr0ky0fdpt84s3wh5fdb808fr8scg7.svg', '', NULL, '006e8ae0fbd5a94a69dd39458847f7ed'),
(59, '2023-04-27 00:09:46', 'iblock', 0, 0, 925, 'application/octet-stream', 'iblock/6a2', 's41u6yk5y3bkprbdroxye3gaoyhk7i79.svg', 'gy11dmsshah3a0wro1283fvrh7rus5jc.svg', '', NULL, 'f485c5faa27a18c2c6c22c8c5da87971'),
(60, '2023-04-27 00:09:46', 'iblock', 0, 0, 719, 'application/octet-stream', 'iblock/b36', 'r3qnepghsi5utjh9d0y34z1jo88kp0sh.svg', 'xfwawx52tn7yapcyqa4p8wk9owiwhbeq.svg', '', NULL, '4353a6bb679285175037afb7ff5f4c45'),
(61, '2023-04-27 00:09:46', 'iblock', 0, 0, 664, 'application/octet-stream', 'iblock/b29', '3009q62zfcanxqtqj94e7y0hn0ihwhug.svg', 'wzqz7hy04mpzoncl90i4e56nr1zga5ak.svg', '', NULL, 'c05d45be47af71ad5fb63ba1d1814eb6'),
(62, '2023-04-27 00:09:46', 'iblock', 0, 0, 1268, 'application/octet-stream', 'iblock/ade', '9tkvz99b0tg7s3mzy6wk90vcqr6x7z0v.svg', 'vyfj63iq1ptek9zvl8truomrmvcxfy7k.svg', '', NULL, 'dde7a2568b5c037aa2dc12a38ecc82fb'),
(63, '2023-04-27 00:09:46', 'iblock', 0, 0, 2008, 'application/octet-stream', 'iblock/23c', 'id5j9b8gz44ik7ha4flary3kmosznp7f.svg', '700ixpg07y14h66uuscunyfv6ddcbppc.svg', '', NULL, 'c1deb3847651bb2bc890ad0904a8ccb0'),
(64, '2023-04-27 00:09:46', 'iblock', 0, 0, 1029, 'application/octet-stream', 'iblock/6c6', 'jr3z7ma9uar9qtycm3gmuotes2hq5x0o.svg', 'proq94hoh7n0tc6e47dff6qyyncaz6wt.svg', '', NULL, '22b8dfad19ba2be3e9434be0fd94ca2b'),
(65, '2023-04-27 00:09:46', 'iblock', 0, 0, 910, 'application/octet-stream', 'iblock/de9', 'i37ld304335a2cx8sg04htq3txgdf57j.svg', '4pambmegxtuzjevx1jt2sj3argz56ziz.svg', '', NULL, 'b47882fa4fb18a9ca974e236e0311fee'),
(66, '2023-04-27 00:09:46', 'iblock', 0, 0, 1403, 'application/octet-stream', 'iblock/3f6', 's9035p1q7m4kk1wfg032g6yjv3ja9zdf.svg', 'svo0vluwjf4hwtqua51l0y5bra9yznf0.svg', '', NULL, 'b908573cc9bd1145257062b4a95a51c4'),
(67, '2023-04-27 00:09:46', 'iblock', 0, 0, 1777, 'application/octet-stream', 'iblock/970', '311eyto86q299dfn5oq99q80unq1y5fb.svg', 'ismlp7xv7ukfe362u6fxke2ydk40g4pq.svg', '', NULL, '80918535a0699ab004510e70a6e7ef34'),
(68, '2023-04-27 00:09:48', 'iblock', 1080, 1920, 520560, 'image/jpeg', 'iblock/bd6', 'e0rmcml0p9z6ww3dx42p8oyvbdb3prvw.jpeg', 'itic28dbm92nxie10gd0tc01rn33yk7j.jpeg', '', NULL, '9b78fa2dbfd3cccaa770de46ccc46cbc'),
(69, '2023-04-27 00:09:48', 'iblock', 770, 516, 616882, 'image/png', 'iblock/4ff', 'igftsl778o80wspa1ebse8li5qx4gfkk.png', 'k1hc6n6q96iat8uw4o2f7jxz2ji2tcr0.png', '', NULL, 'bb4d7c5c43eba58a981d05433105c339'),
(70, '2023-04-27 00:09:48', 'iblock', 936, 1920, 370023, 'image/jpeg', 'iblock/d8e', 'bgygjbxub92ot03li1grst6rfbzdwg70.jpg', 'yp51dso161uhl12f7udqa7vtb0yspqy4.jpg', '', NULL, '8f12979681634fd270aff8c039b418d0'),
(71, '2023-04-27 00:09:48', 'iblock', 589, 491, 394965, 'image/png', 'iblock/190', 'vasnd0vrokqvzutv2r1omnp5zk8famsw.png', 'r1d3bkz96b3hqjpsowcwgxx5gsad9r1w.png', '', NULL, '49a3274449fcba47a5c2438807d9948a'),
(72, '2023-04-27 00:09:48', 'iblock', 734, 1920, 294621, 'image/jpeg', 'iblock/df1', 'r7jsq5oz03zlo395785yc12tlh0q0pmb.jpg', '4dgyfvicwx7u9c7a6cr3404mt47rh04g.jpg', '', NULL, '721a937e2b249ab74627507b69992df5'),
(73, '2023-04-27 00:09:48', 'iblock', 434, 554, 262229, 'image/png', 'iblock/511', 'z4dden29lcbbcs10rnickqv1vv09tlnr.png', 'kd2a0mc91y3a56a8itr2fz3fclf9jrfm.png', '', NULL, 'd3d48197d849e2a4681b30ba16243ea4'),
(74, '2023-04-27 00:09:48', 'iblock', 600, 1920, 228777, 'image/jpeg', 'iblock/62f', '9o0gcsemgwwlbf3wdlsm2i9rmnw2zbbl.jpg', 'hwulzcvuk8wwxhr8v41lt608xowy86oa.jpg', '', NULL, 'c95e9fa434f3f49568abdc39e808e4e2'),
(75, '2023-04-27 00:09:48', 'iblock', 506, 736, 168583, 'image/jpeg', 'iblock/29d', '3o46fr1kzmkaovk0syzcbv5hqok7rl24.jpeg', 'akpx7zhw6cy9zby75acindjndpb8kxd6.jpeg', '', NULL, '06b54555fd80e9bb07e2021bd2ba1414'),
(76, '2023-04-27 00:09:48', 'iblock', 744, 902, 1402440, 'image/png', 'iblock/3d6', '53wu1xu773n7nxoq0wivims2oafy1pr3.png', 'k7xvtzz31ru7s84dl4dmn99tzpnr10dt.png', '', NULL, '2c45f9659e46a42510c44d7b419a974c'),
(77, '2023-04-27 00:09:48', 'iblock', 936, 1920, 400299, 'image/jpeg', 'iblock/ae6', '3prggoz5hfuxb26ebkze4ia61nffkcum.jpeg', 'ia0el2yafm2isp8gf3y3os8gkhdrfbmv.jpeg', '', NULL, '5d7c6838af6add9ae68b2902a066060d'),
(78, '2023-04-27 00:09:48', 'iblock', 589, 739, 756277, 'image/png', 'iblock/393', '1nhc8r0r5ejg4cqkauirn3xjzpjyy1b0.png', '3ulup8frts9j8ig0ymjmlcdpdgog0xl7.png', '', NULL, 'e304b6dfb5c7b6d66a9999a41c5c3b33'),
(79, '2023-04-27 00:09:48', 'iblock', 734, 1920, 328235, 'image/jpeg', 'iblock/e90', '7f1hx78bl2ieyn7sb47iwlzx0x4xvc7q.jpg', 'srdkjgo5accwyrvx18xk0ndztxmp3f7m.jpg', '', NULL, '66324f4a6feef260fae3e7fb18c4bcdc'),
(80, '2023-04-27 00:09:48', 'iblock', 434, 572, 437725, 'image/png', 'iblock/cd9', '8gwsx52u1s04l2tpxlp2zcy53tht4jv8.png', 'unbykshkzpl5kb9qcwjv3o62gdq9at5f.png', '', NULL, '7d42d392cfdf0cb1464e15633fcfa5c4'),
(81, '2023-04-27 00:09:48', 'iblock', 600, 1920, 293564, 'image/jpeg', 'iblock/56b', '9mv7m3pkkp29xbwsp85o7hs8bv7e4ibk.jpg', 'dp6mqst81eqepnugjb7ddfiz7ym3qio9.jpg', '', NULL, 'f9ed39187db9fdb3d882e71f3f073571'),
(82, '2023-04-27 00:09:48', 'iblock', 506, 736, 175239, 'image/jpeg', 'iblock/76a', 'sak34jpaigkqp5jsilumpx1zanko0ukh.jpeg', '1e45cxkm19miq4po9vyut16ra9dc2w57.jpeg', '', NULL, '73a70fadbf83f142c4332e448b885dc9'),
(83, '2024-04-15 22:23:01', 'iblock', 744, 898, 703000, 'image/png', 'iblock/f0e', '6pq0zsuqmryb1h4nf4xrpd8nx8obe4mf.png', '428685xd9pi5q0asnxcy4scjm3ooophi.png', '', NULL, '48bed282476c0853f91060911fa6a4eb'),
(84, '2024-04-15 22:23:01', 'iblock', 936, 1920, 237702, 'image/jpeg', 'iblock/445', 'if55kkxw0501aptot4zr94qraywo5999.jpeg', 'cdssvgx6vy9u91ukdox2lv97s4mkwrf3.jpeg', '', NULL, 'a8168c10b2de158d7c5decb0ac83993f'),
(85, '2023-04-27 00:09:48', 'iblock', 589, 813, 428709, 'image/png', 'iblock/db0', 'pnvsaeyhushn5tluldvnfg0mgkjdk1s6.png', '1u39233tselyzc95imium3dj9rh5l0mg.png', '', NULL, 'db7cfb529002eac3bbb3514ba2ab8592'),
(86, '2023-04-27 00:09:48', 'iblock', 734, 1920, 199557, 'image/jpeg', 'iblock/1c7', 'z98l5up6z2yw7z6ydylkz9hu0y97823d.jpeg', 'dbbi5gkhma2frbxwmfap0cimjgpye6tp.jpeg', '', NULL, 'ec08ae5fc374c57d993de88f33cede2d'),
(87, '2023-04-27 00:09:48', 'iblock', 434, 586, 249410, 'image/png', 'iblock/dc6', 'kksvsyyklje645wpey18d5zjj8pczobc.png', 'c26yh6jvazbpbc85qj6qcsnvd3t5irvx.png', '', NULL, '302669c5471da328869ae98739cfac25'),
(88, '2023-04-27 00:09:48', 'iblock', 600, 1920, 171954, 'image/jpeg', 'iblock/866', 'u4qfvgbl3mgydjkr5094am3gfc7hwy6o.jpeg', '4olqhnc3towz6b4qx15cnt01fiqhcwko.jpeg', '', NULL, '7c0a766814488e6dc660614c49533a79'),
(89, '2023-04-27 00:09:48', 'iblock', 506, 736, 132490, 'image/jpeg', 'iblock/755', 'zsawtayhvf6x2zk0038mf6qiggkusg7s.jpeg', 'm73y4mw3c1kxgua3kcjo5qcpa6u7fgsj.jpeg', '', NULL, '6dd21e0f214dcb3ee9e8dceb8c66e06a'),
(90, '2023-04-27 00:09:48', 'iblock', 713, 1000, 700253, 'image/jpeg', 'iblock/aae', '14arz867cok2cjd8ywnlkoglu10lb0a0.jpeg', 'zs93rvumf0d4q9qy2vhyeuw79333u2gs.jpeg', '', NULL, 'cb162bda12bb230918400356264babee'),
(91, '2023-04-27 00:09:48', 'iblock', 380, 570, 72436, 'image/jpeg', 'iblock/df8', 'yz0zy944e6upcgpj5dkf4tc5lyv72huw.jpg', 'ybv5p26hp22e1mbmkd2jl3sa33ho2ntn.jpg', '', NULL, '3dbedcf14f50567f36ac9617797a2226'),
(92, '2023-04-27 00:09:48', 'iblock', 380, 570, 79627, 'image/jpeg', 'iblock/258', 'ins0dc41ofaepkyecr8db67wuohhibt2.jpg', 'nvwzmfn80cbveg72mxmff2j0iq14ppao.jpg', '', NULL, '4dff1e6564aa320a0dd306e6a7590fca'),
(93, '2023-04-27 00:09:49', 'iblock', 70, 1920, 14866, 'image/png', 'iblock/e16', 'rjn4anhs96k7zoc34iv68xzw2ua22k51.png', '1keh25xzx71ynvu2rgo3mdy7bmdu1hkm.png', '', NULL, 'c64ef333d9cbbb64d11e4afe6805ea3a'),
(94, '2023-04-27 00:09:49', 'iblock', 192, 192, 37059, 'image/png', 'iblock/4a7', '4b6jiirdzhfdx20ps2k6ps5pjb2z1gtg.png', 'yvmtselh8fuois6zjnnryrz72mffmnz5.png', '', NULL, 'e99a172925ad020fe3af49fa1bebec5b'),
(95, '2023-04-27 00:09:49', 'iblock', 100, 1920, 20140, 'image/png', 'iblock/9bc', 'qupq1mrtui0beu92z3r0nle2hl0v5xx1.png', 'kayek3p1kqdwl59e0duo9gv7a1ngj3tp.png', '', NULL, 'ab442560e3804f0114a2e36970b1a852'),
(96, '2023-04-27 00:09:49', 'iblock', 357, 1243, 64031, 'image/png', 'iblock/774', '3o1q1o6c23rdt2gn09yy11jrpgtxrj3k.png', 'ubve3izkb3sssub8siszomg5y48poeru.png', '', NULL, 'db1070ea7002245806be80b9ed837685'),
(97, '2023-04-27 00:09:49', 'iblock', 120, 1920, 23253, 'image/png', 'iblock/838', '9sa1n5dqzzs5rts74va7jcf4jny8yx3k.png', 'ebdq2ddwnk091eem8lbmtz2sby59poti.png', '', NULL, '41881be82950e0174a8935ec217216fb'),
(98, '2023-04-27 00:09:54', 'iblock', 38, 150, 1221, 'image/png', 'iblock/a36', 'ox8h9qxv9q3mz6myky677x8ksezik4bo.png', 'ot8i7r0aiyqmp911w3jp6x57auphtbev.png', '', NULL, '782b59396188f71c38d7d53bc9d71045'),
(99, '2023-04-27 00:09:54', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, 'e29c237b3b32a9ee73091bdd120d18eb'),
(100, '2023-04-27 00:09:54', 'iblock', 29, 150, 3084, 'image/png', 'iblock/8ea', 'r581l7cv6ce86m45ev0aoxpynz9y7fce.png', 'zb975hmctvyrkg1usg7p5y7ohmmfbnno.png', '', NULL, 'aad731536067e383b8d7000afd5c2159'),
(101, '2023-04-27 00:09:54', 'iblock', 29, 150, 3084, 'image/png', 'iblock/8ea', 'r581l7cv6ce86m45ev0aoxpynz9y7fce.png', 'zb975hmctvyrkg1usg7p5y7ohmmfbnno.png', '', NULL, 'aad731536067e383b8d7000afd5c2159'),
(102, '2023-04-27 00:09:54', 'iblock', 50, 150, 1464, 'image/png', 'iblock/7dc', 'aj773uja6w1u8tozmvcx7aby4k7aw65k.png', 'jlrjczpzq4iwjesgxj3pwccclq0e7c8y.png', '', NULL, '9ef1a6afdc9f99f8a9e12dc679e04345'),
(103, '2023-04-27 00:09:54', 'iblock', 50, 150, 1464, 'image/png', 'iblock/7dc', 'aj773uja6w1u8tozmvcx7aby4k7aw65k.png', 'jlrjczpzq4iwjesgxj3pwccclq0e7c8y.png', '', NULL, '9ef1a6afdc9f99f8a9e12dc679e04345'),
(104, '2023-04-27 00:09:54', 'iblock', 30, 150, 1805, 'image/png', 'iblock/6e3', 'ouaklahmz58pudiae9rys6dzhknxqry2.png', 'wdnlelyp22hge1npxubiyt6kes9ubf4n.png', '', NULL, '4b391ca31a6ea6dbf2c3c88c2748e2a1'),
(105, '2023-04-27 00:09:54', 'iblock', 25, 150, 1328, 'image/png', 'iblock/468', 'dpu24e95lu1cvtj46nwh8a0vcnthybks.png', '9ic982yj1xmwsrdliaf0k0ca1obc3ows.png', '', NULL, 'eb0297b6cc43d10adcf517e6007baaae'),
(106, '2023-04-27 00:09:54', 'iblock', 25, 150, 1328, 'image/png', 'iblock/468', 'dpu24e95lu1cvtj46nwh8a0vcnthybks.png', '9ic982yj1xmwsrdliaf0k0ca1obc3ows.png', '', NULL, 'eb0297b6cc43d10adcf517e6007baaae'),
(107, '2023-04-27 00:09:54', 'iblock', 56, 150, 2081, 'image/png', 'iblock/777', 'a2yt5o8dv7d705tcxi43klda02dsjndu.png', 'd9y8wnchysv2xj36dy4wtjp0djx9vj8o.png', '', NULL, 'dea77657161e199cc7629813988106cd'),
(108, '2023-04-27 00:09:54', 'iblock', 23, 150, 1142, 'image/png', 'iblock/79b', 'xgy841aiwnqpog2t5u2dvqhb2j61x94s.png', 'f2fk24c5gr47y6dmsi4x5eu6f1ute13h.png', '', NULL, 'e8b74d699a9d2518db7b48ff3ca5d0a0'),
(109, '2023-04-27 00:09:54', 'iblock', 31, 150, 1846, 'image/png', 'iblock/bc5', 'ywp6m0kkmyj3030wikcaab3c8o68yzpj.png', 'f5jym082gldsrdcse77emcivisvirdw7.png', '', NULL, '5b85bc9c68b0d16c24d2735187106ea4'),
(110, '2023-04-27 00:09:54', 'iblock', 30, 150, 1224, 'image/png', 'iblock/d92', '5s4fdbdpixgmgh5zgql6fib9nghdqx23.png', 's8tlt6pg0la80eyotidhpdcghwnfhevd.png', '', NULL, '4e5cf13a8da779096e9fd793c24c8735'),
(111, '2023-04-27 00:09:54', 'iblock', 40, 150, 2477, 'image/png', 'iblock/f7d', 'qdisi5xq06oelb0yjzhn6c1i52qy3xm5.png', 'uelr117uc2ddtxn2qomtxch913lz56k6.png', '', NULL, '3ea7b3b68fa353a00f5f1b203b015b68'),
(112, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(113, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(114, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(115, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(116, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(117, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(118, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(119, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(120, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(121, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(122, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(123, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(124, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(125, '2023-04-27 00:09:55', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '0644a1b3ad7f3b0d7ebc661c7105011d'),
(126, '2023-04-27 00:09:56', 'iblock', 466, 700, 38639, 'image/jpeg', 'iblock/062', '9sho2fq725qm0yo5ld2trl72c1ovsp73.jpg', '7ss3dkpmj5ilp37xol0hfmzat390y6kb.jpg', '', NULL, '8883108fd89bd4d2aa5a5db664f10bae'),
(127, '2023-07-07 12:03:51', 'iblock', 468, 700, 70576, 'image/jpeg', 'iblock/117', 'o93mzocarerougsz21msnnphr078b4de.jpg', 'k1vk4jzu2wy1pkwqy9ckz3wkmctvqagm.jpg', '', NULL, '1c779e0f70f8689066729142a73414ac'),
(128, '2023-07-07 12:03:51', 'iblock', 551, 824, 106334, 'image/jpeg', 'iblock/7b9', 'n3txj0o7bbp6sz1vvo7r56yg3boo1m5r.jpg', 'e4udq6jyl40dkpckrt5ozo4exytnyj59.jpg', '', NULL, 'f2adebc9c9317407e6e6a0d3322c5d50'),
(129, '2023-07-07 12:03:51', 'iblock', 551, 824, 86721, 'image/jpeg', 'iblock/6ed', 'tnq0oth721t61kapf4j7r67cpluosqky.jpg', '3e1o9s7q32xjglw7c2w4l17pvmajk7ol.jpg', '', NULL, 'a17bcbc4ace53b3ac0b994b8e66eac76'),
(132, '2023-04-27 00:09:57', 'iblock', 468, 700, 81442, 'image/jpeg', 'iblock/af8', '1xope5blh2h4yo500y3ocxqn1xqs1yf6.jpg', '7xhquz0kt5ddz68u06cj1g0u3yzkthaa.jpg', '', NULL, 'b491c6e03dcb127c6c8218949267350f'),
(133, '2023-04-27 00:09:57', 'iblock', 551, 824, 129104, 'image/jpeg', 'iblock/863', '7t7vnst82pwv7bowyivbg73r0vinm1zs.jpg', '4tnvhoade8ga8esr28j4po0a9zyx2yg0.jpg', '', NULL, '6eb4f2f2b25b34f33ad12980dcf4c96c'),
(134, '2023-04-27 00:09:57', 'iblock', 468, 700, 55202, 'image/jpeg', 'iblock/ff1', '8vcvpwxk29lj4dt2i27ku14gj54nc3ys.jpg', 'o4rci7tls5po8ojmo5v6ofv85edmvcq7.jpg', '', NULL, '1aea821b1556bd30dc53175c7c218a5f'),
(135, '2023-04-27 00:09:57', 'iblock', 551, 824, 79182, 'image/jpeg', 'iblock/888', 'jd0q7siz6wj0hzb80310tiwg4osq1fsg.jpg', 'qympjb4uahcu1buhgccgj5kweemm3363.jpg', '', NULL, '54eaf2d946616a125d3f0b27f0690b13'),
(136, '2023-04-27 00:09:57', 'iblock', 468, 700, 61186, 'image/jpeg', 'iblock/524', 'pw5rbojqn1nh6i6kx09k1iri6ca41gzl.jpg', 'hlcr4r7t0yg1y00wzpz6ui3oxmml4f1z.jpg', '', NULL, '219c8a82c930ae64bb60e9a1409e91db'),
(137, '2023-04-27 00:09:57', 'iblock', 551, 824, 89972, 'image/jpeg', 'iblock/a2b', '1i1jq6o3ay8uqk0jbptdq1n17mld5c1b.jpg', '9o7f57ei3dbjx2g5h5a7hbpzbxdn9uzy.jpg', '', NULL, '5f854d1d1f93b53b1a42c6beca02aa1f'),
(138, '2023-04-27 00:09:57', 'iblock', 468, 700, 66206, 'image/jpeg', 'iblock/aa3', 'ea3ll6kq3zib4oxlulvnldwqcsip91au.jpg', 'io097mhjayrk2tlbpislwtqe00rk0w5i.jpg', '', NULL, '6195536b7d8907fb5a3a9b9af53e37f6'),
(139, '2023-04-27 00:09:57', 'iblock', 551, 824, 94489, 'image/jpeg', 'iblock/60e', 'n2gn9cy3khmhhuwcfklu5u8mdv17zeiw.jpg', 'mxiptxed0rt41590m1obciqtx04j9rvg.jpg', '', NULL, '9f3dcc9888fb96a3ac3e7dcc9816ab35'),
(140, '2023-04-27 00:09:57', 'iblock', 551, 824, 87315, 'image/jpeg', 'iblock/697', '62ujkpwq2x7d5q2jb2fiwgqn97417805.jpg', '0kvssicd8ifnqf97142qik3kxpgyiuru.jpg', '', NULL, '4a6c5e6b1d55f84b7524dab85da456f2'),
(141, '2023-04-27 00:09:57', 'iblock', 551, 824, 86721, 'image/jpeg', 'iblock/6ed', 'tnq0oth721t61kapf4j7r67cpluosqky.jpg', '3e1o9s7q32xjglw7c2w4l17pvmajk7ol.jpg', '', NULL, 'a17bcbc4ace53b3ac0b994b8e66eac76'),
(142, '2023-04-27 00:09:58', 'iblock', 306, 1050, 156546, 'image/jpeg', 'iblock/d0c', 'jjkea71o18llyim93vk5fhl3jx0xw9za.jpeg', 'xga7l83095mf7raar15osbfsbztmukix.jpeg', '', NULL, 'ea512d2170fe65f2f7c9e58e61c0f1e3'),
(143, '2023-04-27 00:09:58', 'iblock', 306, 1050, 87855, 'image/jpeg', 'iblock/4ae', '9oxnqec7cl0uafly7icz0fdnrs425z8f.jpeg', 'y780h5zi2olnzh8d3e04utyt15hz8lml.jpeg', '', NULL, 'a40fd1f133407b1403cfb7b15da8cbd8'),
(144, '2023-04-27 00:09:58', 'iblock', 180, 1919, 197244, 'image/jpeg', 'iblock/090', '3h3bx2q24rt5ddwbuqau5bdf191c6c69.jpeg', '8oxxidd0hqfrdrv8ndxanhg43z1r4u2c.jpeg', '', NULL, '5e01c7f4fdfb2c0388a5cb4cc0d3b5b6'),
(145, '2023-08-28 12:29:23', 'iblock', 500, 1920, 1226140, 'image/jpeg', 'iblock/867', 'feqdw9gfuyja9ucspzsb73omtszrti3t.jpg', 'e8gxmxxoueqg47jd0bfdygq7mdznz1wq.jpg', '', NULL, '65b1ab8f75cd401098666a1362f6f204'),
(146, '2023-04-27 00:09:59', 'iblock', 500, 1920, 1226140, 'image/jpeg', 'iblock/867', 'feqdw9gfuyja9ucspzsb73omtszrti3t.jpg', 'e8gxmxxoueqg47jd0bfdygq7mdznz1wq.jpg', '', NULL, '65b1ab8f75cd401098666a1362f6f204'),
(148, '2023-04-27 00:10:00', 'iblock', 650, 700, 528882, 'image/png', 'iblock/6be', 'irz9r3bbw0u2qlh3xuyxlr2kiky3iz1p.png', 'h1yfnnmcuf41iws4ygsuy4brlj89x0wi.png', '', NULL, 'c9c51a9821bf28f297511a20a9e3d6c9'),
(149, '2023-04-27 00:10:00', 'iblock', 650, 1920, 192019, 'image/jpeg', 'iblock/384', 'hy60hauyunp5gmhi946krjs7im2xumn5.jpeg', 'p7rrypssej4z0z92hj96cq60s8rwjehf.jpeg', '', NULL, 'abcf4176fa41ff2fa1b8c84d40abdb31'),
(150, '2023-04-27 00:10:00', 'iblock', 623, 700, 422422, 'image/png', 'iblock/2ea', '1nhsko45peirantqrmbzavlyx7ziudg9.png', 'htoavv7amtx9gzd3c40iruy6o22gm22n.png', '', NULL, '02ddebaa22ec512e4c031e7822d8fecd'),
(151, '2023-04-27 00:10:00', 'iblock', 650, 1920, 236113, 'image/jpeg', 'iblock/07f', '19agdoxs7maltj8bpwtx9zrhsw28fu0b.jpeg', '9sn2lzxf92ww9jqdil1cantp3dwmv3hv.jpeg', '', NULL, 'cfb2deb518ee2d9c383ac4b00c5c9002'),
(152, '2023-04-27 00:10:00', 'iblock', 314, 367, 164094, 'image/png', 'iblock/5a7', 'ktrats8uxy32uoe2grl9cuyc3uqdkvpn.png', 'xhn7pjhdvdnks4pelt7sat1s8h4zqyfo.png', '', NULL, '76a04b98f58b1fbd05cad4628af8243a'),
(153, '2023-04-27 00:10:00', 'iblock', 314, 367, 125303, 'image/png', 'iblock/ce2', '2jhprb53lqne1r2w3rsj29b740uqovb1.png', '9fsu37bo0dip4kdcx6kwu3k1h8emhkmk.png', '', NULL, 'c0c2c9ca5a89f454368a10daeee0fe9a'),
(161, '2023-04-27 00:10:02', 'iblock', 0, 0, 15813, 'application/pdf', 'iblock/3d6', '9n4cdmf6ojgmjcv6ovryxqdwiqqs1t3u.pdf', 'us1mmffl002r3sy24y1idm9dag2jv0zg.pdf', '', NULL, 'e1a207db35f24deb1482eeec921d9da1'),
(168, '2023-07-08 23:33:13', 'iblock', 90, 150, 3288, 'image/png', 'iblock/a14', '84qc464w7nbo4lm1q0w6mt16icm9mbb9.png', '0tf3gy5x0jibejodddd7i2e1m0f73pxn.png', '', NULL, 'a6965a366e9daafec20fe5e24065c4a2'),
(169, '2023-07-08 23:33:13', 'iblock', 36, 176, 1402, 'image/png', 'iblock/18b', 'mpny9vkbavsp37c37izw9ep1krgzn9yk.png', 'lq9gtf0s9yuthe0291sf8hynb6397ar5.png', '', NULL, 'e3ab5be8db10862e9178940e917cbe27'),
(170, '2023-07-08 23:32:59', 'iblock', 90, 150, 1446, 'image/png', 'iblock/975', 'd9356n0vaqrrfzc10mup0ugbiyfir3k6.png', 'jzdlsumej02z6auw7iebtkv35cmcvt05.png', '', NULL, '0471c01946289584c48189e28c80d901'),
(171, '2023-07-08 23:32:59', 'iblock', 628, 1200, 105298, 'image/jpeg', 'iblock/789', 'fuxgmwnyoksnu0ddsvt1b7rxyn01utzv.jpg', '0zl4ae9ulei7owy2dosu53b6q6uw1oco.jpg', 'Награды', NULL, 'e3b2d00bcece2956948a79ebf3cf9e2e'),
(172, '2023-07-08 23:33:27', 'iblock', 90, 150, 1716, 'image/png', 'iblock/85a', 'y35bap2beogk0572kk6tp7f1vq3vyhbc.png', '0nqh6w1sbhbxixda4zwz6keekwtgfej9.png', '', NULL, 'a01d7e703ab6a503126403cd2dd020d4'),
(173, '2023-04-27 00:10:08', 'iblock', 90, 150, 2891, 'image/png', 'iblock/d66', 'jv6ca0u97uhpqf5x3hi4sd2qdqw2c97g.png', '2eskfw1dkh5t9b6t3ufj6b5ikqembuar.png', '', NULL, '85fc79a445c9bac61ce0157f9301fca9'),
(174, '2023-04-27 00:10:08', 'iblock', 90, 150, 2623, 'image/png', 'iblock/c5f', 'zxhndmso1ub1fsnaed4it70vnjm0k0rg.png', 'at56hhaihrplhu5ij329lwx847ejzpwb.png', '', NULL, 'a88a06241ba7afb2760dffe42c2b33a9'),
(175, '2023-04-27 00:10:08', 'iblock', 90, 150, 1694, 'image/png', 'iblock/463', 'jwbnbyxry5z5fyy11eui418kon78u5sb.png', 'ycfhuxh6ps154fnvqq7e59jps4z7ccns.png', '', NULL, '0f791caceb2d08793cf913fd0ff12d31'),
(179, '2023-07-06 00:36:01', 'iblock', 640, 960, 152620, 'image/jpeg', 'iblock/984', 't200e5nz3dgb6912ge6w55tbhzv8vqo3.jpg', 'n8toclfo85o6bx01pe033n186i4rsepz.jpg', '', NULL, '094e5a3785e151ce8ae77e80ea5b77a5'),
(180, '2023-07-06 00:36:01', 'iblock', 830, 1700, 165655, 'image/jpeg', 'iblock/2a6', 'qi2obmklom89swcfoz3ng95nbeff5562.jpg', 'kr1r0u6tpoprqn7s9q86emxb0kq05vjq.jpg', '', NULL, '4ac30b7d1891ee234c4b9bf95dacdb44'),
(181, '2023-04-27 00:10:09', 'iblock', 640, 960, 121174, 'image/jpeg', 'iblock/8c8', '4l598puc812c0novqb9wrf50xkczszv9.jpg', 'ije3dp1pcf1ep1k015ijct3f8v3nki3p.jpg', '', NULL, '7531a674a875c1867b5b0596d31c527c'),
(182, '2023-04-27 00:10:09', 'iblock', 486, 870, 110167, 'image/jpeg', 'iblock/047', '0qejq70r2igt51pm5rwo8cxajg2d8022.jpeg', 'd4qcpqpqkoehsykpxz8qjf0nei5gripd.jpeg', '', NULL, '7c3207df373f88567282fe4eb3dd593b'),
(183, '2023-04-27 00:10:09', 'iblock', 640, 960, 143129, 'image/jpeg', 'iblock/4b5', 't9h7ky143bw0dxo75cqgbvtu9929gb2k.jpg', '5o2pytcejnwsbuvg6r3mnb1pz3g2p1rp.jpg', '', NULL, 'a6dd57503fb784a1d4a611650f75a519'),
(184, '2023-04-27 00:10:09', 'iblock', 666, 1000, 221008, 'image/jpeg', 'iblock/4d2', 't4kh6lflkdjr6wjgj36hmk03gzmbeamy.jpeg', 'xo7c94904txfmpzttbemp9juv9hua6ta.jpeg', '', NULL, 'dc93e75ef3c06f2c3958454581df1814'),
(187, '2023-04-27 00:10:09', 'iblock', 640, 960, 310676, 'image/jpeg', 'iblock/004', 'tt4gk399py7tf4yrlp1kb0rfbv40y8tb.jpg', '4fa0j8kyqloro1ugzi90j2e05le0dzs4.jpg', '', NULL, 'a769bee5af205d99b2bfa8cd73cc260b'),
(189, '2023-04-27 00:10:11', 'iblock', 467, 700, 152024, 'image/jpeg', 'iblock/4d1', '5402cy2dkk1tpw7l3z219f6igfcwt8br.jpg', 'vkprkcpqhktmes2t0aow0n061rk6xj78.jpg', '', NULL, 'f2773f50990d876e33a70f98280bc384'),
(190, '2023-04-27 00:10:11', 'iblock', 466, 700, 63927, 'image/jpeg', 'iblock/040', 'uscnl6sjwuuh1yx1xve67gzn88bejgbw.jpg', 'jtqhg0vzlcuke164lf42i3azsq54ht9s.jpg', '', NULL, 'd2d135caa58f932a4b9b7d2dc4909f81'),
(191, '2023-04-27 00:10:11', 'iblock', 830, 1700, 274956, 'image/jpeg', 'iblock/91d', 'ci9ykml9lib8yhvx2bwf4orzx6jm1jx1.jpg', '50vy41wzlfqs35ca3l4m24zvvlqzcxue.jpg', '', NULL, '43ec5c9e0809239fcb798c1233947bb3'),
(192, '2023-04-27 00:10:11', 'iblock', 467, 700, 105672, 'image/jpeg', 'iblock/648', 'fejok8yykc2l3vuai46v9s2pccyvq6au.jpg', '0pysq5lo4oiml4jiiflxwf6r6hvgs5w0.jpg', '', NULL, '41d553fcf5a846da15b85b77fa16e946'),
(194, '2023-04-27 00:10:11', 'iblock', 466, 700, 38639, 'image/jpeg', 'iblock/062', '9sho2fq725qm0yo5ld2trl72c1ovsp73.jpg', '7ss3dkpmj5ilp37xol0hfmzat390y6kb.jpg', '', NULL, 'db63a7deb2b1aa7719ec4bc925784b3f'),
(195, '2023-04-27 00:10:11', 'iblock', 466, 700, 38730, 'image/jpeg', 'iblock/e85', '43tlk1b1vqqb0zfon6r38xnaxxk2sbjg.jpg', '09m6w5brcfptczjjyo1rm2z77165nkxa.jpg', '', NULL, 'cf37d4f819d8a58cf2098e64bcdbcd93'),
(196, '2023-04-27 00:10:11', 'iblock', 830, 1700, 158335, 'image/jpeg', 'iblock/bdd', 'm288cgj2o52mne0shtt2hjljxdq0a91o.jpg', 'w06z6rxplk3blmuzybd7tb89fzmkscla.jpg', '', NULL, '50a1ebb34405f52c0928f0d9a633c252'),
(199, '2023-04-27 00:10:12', 'iblock', 640, 960, 134029, 'image/jpeg', 'iblock/251', 'szzbfh2f48nfzb3bk65uyjwzsuaifjtu.jpg', 'uap8h8wnakw72t8va5nid5pcg1t75x3m.jpg', '', NULL, '62ee7310f7c3ce9b482e530f683019c6'),
(200, '2023-04-27 00:10:12', 'iblock', 830, 1700, 220982, 'image/jpeg', 'iblock/56c', '2goxk5biw0lxlmvq9zdmuiwk1emym2ll.jpg', 'f0z9vjm0aj6plw9yig893p14w338x832.jpg', '', NULL, '206f9a4b7c3835bfc4c2cf1b75595044'),
(201, '2023-04-27 00:10:12', 'iblock', 466, 700, 194033, 'image/jpeg', 'iblock/baa', 'h614nqkmwg709guqsesqqnmwijim1k4i.jpg', 's22cuk7sg0kdcfqpo714ga5hf1x9jlzx.jpg', '', NULL, '8d49794873e251d081b963639b68ca56'),
(204, '2023-07-11 22:46:18', 'iblock', 832, 1250, 670339, 'image/jpeg', 'iblock/b91', 'dbssjuo9g7n9zvmf5o9cdklyf4rnu4xb.jpg', 'prhp2bsa94ynt1o658lf2ppwxtfns291.jpg', '', NULL, '6eb79846b0ac3d34789af349d75a2167'),
(205, '2023-07-07 18:12:03', 'iblock', 480, 720, 34726, 'image/jpeg', 'iblock/fff', 'dj09otpi6zpn4yelgb3pxzel0lwfs53p.jpg', 'qad2l67pnzxuzflt8tpmyiikpo5f0585.jpg', '', NULL, '20fb26ea83801a11abd4ba5813b3a2b0'),
(206, '2023-07-07 18:08:49', 'iblock', 480, 720, 35535, 'image/jpeg', 'iblock/a81', '3r408lrxh0veqfc67g82y2t21um8ycza.jpg', 'd0bkl1ju410zo921blkp463va8nofzjy.jpg', '', NULL, 'a8ed9b777f6021d1eaa8d3b70474a7cc'),
(208, '2023-04-27 00:10:13', 'iblock', 480, 720, 31438, 'image/jpeg', 'iblock/f04', 'bihy1tvn9f8zgl9sw883djk8dwe4d4xq.jpg', 'qenaity7mx4r0va9iyohehudy5dvbo1w.jpg', '', NULL, '7e324a99dd0a3c683c15d13c05ee94c5'),
(209, '2023-04-27 00:10:13', 'iblock', 480, 720, 41520, 'image/jpeg', 'iblock/972', 'a6hswuvhgc1xa1plcn389rlsip95lica.jpg', 'uv0urdi09o7kgo3a1hal8gupomj4gsgd.jpg', '', NULL, '6242bec4527c87cf1ff512c3299482b8'),
(210, '2023-04-27 00:10:13', 'iblock', 480, 720, 34223, 'image/jpeg', 'iblock/a88', 'm46vzwfv6kz462au579hj3jkqvhz90m2.jpg', '49i0ufhxlfrg983g3knseji85n5qeq47.jpg', '', NULL, '8bb854fc0b37a33921dbc794235320e5'),
(211, '2023-04-27 00:10:13', 'iblock', 480, 720, 34223, 'image/jpeg', 'iblock/a88', 'm46vzwfv6kz462au579hj3jkqvhz90m2.jpg', '49i0ufhxlfrg983g3knseji85n5qeq47.jpg', '', NULL, '8bb854fc0b37a33921dbc794235320e5'),
(212, '2023-04-27 00:10:13', 'iblock', 480, 720, 36910, 'image/jpeg', 'iblock/b4a', '1bhive727qw26xt8jra2l0gtmfo6z4pn.jpg', 'z3kt7lr19rjls4uz0udkjya0j5ubiixg.jpg', '', NULL, '340bc208974d9d11217e5aa9fadadc71'),
(213, '2023-04-27 00:10:13', 'iblock', 480, 720, 28521, 'image/jpeg', 'iblock/375', '51imiewmz0txymfyu0qx2028c3efep53.jpg', 'x2a8pxy2223p7di9llawknr7onyv2ml5.jpg', '', NULL, 'cc2108eafcff1bbeeede35a44d9298a7'),
(214, '2023-07-07 18:05:31', 'iblock', 480, 720, 28232, 'image/jpeg', 'iblock/019', '22drdhyv06z1hetdtxvap2ln5ghff8bo.jpg', '3de2j86f5qjon8pryy961nm1ntr558t1.jpg', '', NULL, 'e4b33781ee95da518085d238a3b99413'),
(215, '2023-07-07 18:05:31', 'iblock', 0, 0, 15813, 'application/pdf', 'iblock/3d6', '9n4cdmf6ojgmjcv6ovryxqdwiqqs1t3u.pdf', 'us1mmffl002r3sy24y1idm9dag2jv0zg.pdf', '', NULL, 'f76b3edf6db896d85c1e65e02079fae9'),
(216, '2023-07-07 18:05:31', 'iblock', 693, 500, 85929, 'image/jpeg', 'iblock/6b0', 'zm884sii9o8ks9jcam2o98fmh239oigj.jpg', 'g03er8ghnw5497rtyb30zmsv3xhc816o.jpg', '', NULL, '86336fae9f90d0fbb54cadfb89b8cd47'),
(217, '2023-04-27 00:10:15', 'iblock', 800, 1920, 454408, 'image/jpeg', 'iblock/f58', 'cc70poa8ix43orpyypz1u2zhai6y11tt.jpg', '8aojzxc4nqo28ensyjtt2frep5jnur12.jpg', '', NULL, '9d1aa9b53b98aa403206e13b8d539103'),
(219, '2023-04-27 00:10:15', 'iblock', 740, 1920, 364702, 'image/jpeg', 'iblock/823', '6wse45v2hfxy9j3pahgbu8df9s8n7mku.jpg', '6xso14ex0y3awi1drhu71szxdusoqkq1.jpg', '', NULL, '80cbc3d5fc340fb83d5f685642d8a6f1'),
(220, '2023-04-27 00:10:15', 'iblock', 740, 1920, 364702, 'image/jpeg', 'iblock/823', '6wse45v2hfxy9j3pahgbu8df9s8n7mku.jpg', '6xso14ex0y3awi1drhu71szxdusoqkq1.jpg', '', NULL, '80cbc3d5fc340fb83d5f685642d8a6f1'),
(221, '2023-04-27 00:10:15', 'iblock', 740, 1920, 254504, 'image/jpeg', 'iblock/002', '3bt96la4x9dzm93xetaxxlr5noj214yi.jpg', 'uwvkesp6i2syadfpma66mnn147b3lq7z.jpg', '', NULL, 'c3b72473d00d5e9f2e497f5036e7ac4a'),
(222, '2023-04-27 00:10:15', 'iblock', 740, 1920, 254504, 'image/jpeg', 'iblock/002', '3bt96la4x9dzm93xetaxxlr5noj214yi.jpg', 'uwvkesp6i2syadfpma66mnn147b3lq7z.jpg', '', NULL, 'c3b72473d00d5e9f2e497f5036e7ac4a'),
(223, '2023-04-27 00:10:15', 'iblock', 740, 1920, 453029, 'image/jpeg', 'iblock/137', 'wjv61b6zpu9z62c7cjbim64fqrz65o99.jpg', 'lojcryrbyhcqvid9zld7gknlx0fikbl8.jpg', '', NULL, 'f0946e38761417de9379fe5b619638b5'),
(224, '2023-04-27 00:10:15', 'iblock', 740, 1920, 453029, 'image/jpeg', 'iblock/137', 'wjv61b6zpu9z62c7cjbim64fqrz65o99.jpg', 'lojcryrbyhcqvid9zld7gknlx0fikbl8.jpg', '', NULL, 'f0946e38761417de9379fe5b619638b5'),
(225, '2023-04-27 00:10:17', 'iblock', 640, 960, 198992, 'image/jpeg', 'iblock/6d1', 'vuasju4q8194upc1tnpf1tylndbso3kx.jpg', '8oiuqy45p3zcf0hk9pj1uur1vhzsanql.jpg', '', NULL, '1be39b1ec22687aa8bd3cde3de858d49'),
(226, '2023-04-27 00:10:17', 'iblock', 625, 1500, 117786, 'image/jpeg', 'iblock/1e4', '5r08f9nvqatajqfik08kzu5nzv8p4yzt.jpg', 'u1vadtqblsh68cmcjhxs3r6l2mqxyar1.jpg', '', NULL, '29659bd35596b0eed73a9d55ea7b5ef6'),
(227, '2023-04-27 00:10:17', 'main', 0, 0, 5318, 'application/octet-stream', 'uf/e72', 'sdw20agpb2hx5gowuip9ksjfj8wj0tnz.svg', 'lqz0ys7xsncu00yc1jqgpg05u02fa8ju.svg', '', NULL, 'b7fba3958317c0a1fc3f5dc047c35a12'),
(228, '2023-04-27 00:10:17', 'main', 120, 120, 28574, 'image/png', 'uf/fc2', '3ww016h14d34stuwnqvev9r3ic3xeo9r.png', 'n735v5mv7asr4i0hl8h6jgexp6zwb6kl.png', '', NULL, '956a8d438cdb1f7e6f7d094b2f4395e0'),
(229, '2023-04-27 00:10:17', 'iblock', 640, 960, 178261, 'image/jpeg', 'iblock/29e', 'feq066jyh2yknz7z5665433p7dn4jme7.jpg', 'qobv9vztdsk4e21bk90castgzc7ienb2.jpg', '', NULL, '1d816c3b2a97173429019d0f4150ae5c'),
(230, '2023-04-27 00:10:17', 'iblock', 800, 1920, 457704, 'image/jpeg', 'iblock/ae7', 'rl4h2q9rhsxbelcgeuenxl239tmlmcf7.jpg', 'ugfmwrbbl726qomj7gusebto1lsb6tef.jpg', '', NULL, '0769434e7af7145d0f63874852426497'),
(231, '2023-04-27 00:10:17', 'main', 0, 0, 4390, 'application/octet-stream', 'uf/876', 'uirmg3f8rpjg3w3skpk6h14d0djik6lm.svg', 'l7w9aehdc9n5m1qd8c0loxt81l3ho1vn.svg', '', NULL, '4639281793d74784c625bcea5650403d'),
(232, '2023-04-27 00:10:17', 'main', 120, 120, 30861, 'image/png', 'uf/7cb', 'h3qz52i86pjwrtokl9uek4tgrncguybi.png', 'lilmvwqwk0ynpb250ttza4e1730pd3e1.png', '', NULL, '99bd4d2d210021a95604172a04848948'),
(233, '2023-04-27 00:10:17', 'iblock', 640, 960, 242521, 'image/jpeg', 'iblock/e2b', 'ofrrq37iuh1k2qdzdpbxismnlybxjuvd.jpg', 't94eb1yfmyjottsxwlyiae6gcgc5aqwl.jpg', '', NULL, '517e1bbc471f44a223f629d3b3fe1db5'),
(234, '2023-04-27 00:10:17', 'iblock', 625, 1500, 125253, 'image/jpeg', 'iblock/836', '031s2w7tf63bxbd2n2m19mbahs18mle0.jpg', 'l3ofsk9pgiv17krxdw24c23qhbonw031.jpg', '', NULL, 'caf5984d601fa8381100523b98424940'),
(235, '2023-04-27 00:10:17', 'main', 0, 0, 4116, 'application/octet-stream', 'uf/b6e', 'p651be5izspt4ne08j9lraiggdaonqze.svg', '2hexuzcvuw5r2oy5fqktk4po1t03llov.svg', '', NULL, '3d68a1df0433fe7d1187368b5904d9bb'),
(236, '2023-04-27 00:10:17', 'main', 120, 120, 26668, 'image/png', 'uf/9a8', '4q9hsjj9z556orclfs2cij2zt8orpe5l.png', 'cor3mtmvaw6bc750lss56c8nvbjxgzzs.png', '', NULL, '2983e807ec851561cca629432e1dc098'),
(237, '2023-04-27 00:10:17', 'iblock', 640, 960, 243867, 'image/jpeg', 'iblock/5e0', 'nqukl5n5krrqc1yim062rts9glllp0l1.jpg', 'pb9gxekaim0p0ruqz1zg63o8ld8s2f4b.jpg', '', NULL, '2b65362806e322e168cbb770526fb281'),
(238, '2023-04-27 00:10:17', 'iblock', 800, 1920, 751206, 'image/jpeg', 'iblock/215', 'e82hysz1l3kptidq1dw4rfft4swanqir.jpg', 'ad6bqvyxqy96zj73k1440n5jsjet3tj3.jpg', '', NULL, '56269f3c06a4bcd76b2edfb3b561ef72'),
(239, '2023-04-27 00:10:17', 'main', 0, 0, 2249, 'application/octet-stream', 'uf/13a', 'mhv714xoz3zckchejf8bicqewe4en16x.svg', '5lu9igvm9ozi9yk3htqb8vmxqybn2zh1.svg', '', NULL, 'aae31563d0686839bc8fa2593a2f4f58'),
(240, '2023-04-27 00:10:17', 'main', 120, 120, 32648, 'image/png', 'uf/55b', 'p50601p3tm9sdpie1xz9xv3pnjqb3mma.png', '3p79z7dg8bbo2m7tp5ssp8cjo3a18tgs.png', '', NULL, '88c94ab3fdf357bb270e6ed7af1a49f2'),
(241, '2023-04-27 00:10:17', 'iblock', 640, 960, 210987, 'image/jpeg', 'iblock/fc6', '7du9n486e29tw5281zu9jka93a1p6ac5.jpg', 'lyly9bch0rw6wk9a1g4p2nkpfah5c2tp.jpg', '', NULL, 'b73bd3dd25807affe0f4b8fa8b04ceaf'),
(242, '2023-04-27 00:10:17', 'iblock', 800, 1920, 372619, 'image/jpeg', 'iblock/ee2', '3remvnkauof2luxd1v6dqxfpqkeyp7yp.jpg', 'g0k9uutd04r0weepu5h4a1tpiha85lfu.jpg', '', NULL, '310abad2aa035a211c8e7e3254fa308b'),
(243, '2023-04-27 00:10:17', 'iblock', 120, 120, 22397, 'image/png', 'iblock/509', '1ajxwothnn8sd1m3v8fp7sn9yf6mlq4c.png', '5cso7hr57l7ef2gfsdpuvol3ujbdtp2x.png', '', NULL, '7fb753c1a659731d06a3f428529ebfa4'),
(244, '2023-04-27 00:10:17', 'iblock', 0, 0, 3990, 'application/octet-stream', 'iblock/0a5', '125swoo2x5jrvjeisyyrf9v0tztetxv0.svg', 'dpqt75w43cuwumetzyrvcy3z241z02t7.svg', '', NULL, '80bb560ee61556229cfb924fd5ce5e95'),
(245, '2023-04-27 00:10:17', 'iblock', 640, 960, 250186, 'image/jpeg', 'iblock/d92', 'yrijocfs1810sng9n576t95ew13jzpmo.jpg', '82zd3szmr9af96vxy10ot7lzs2xujrqz.jpg', '', NULL, 'b6d2b8ad1b88ee5c96c7c211ae123e9a'),
(246, '2023-04-27 00:10:17', 'iblock', 800, 1920, 506920, 'image/jpeg', 'iblock/7a3', '007184wj0k7x7g0i1idumeg9wggvmocb.jpg', 'ry0vnz7ihhxa63dh0fcr35uhzbmaxcdq.jpg', '', NULL, '446360bfc6ef1fe0dfc32b88e4774f7a'),
(247, '2023-04-27 00:10:17', 'iblock', 120, 120, 17046, 'image/png', 'iblock/2e8', '3beydabh6nfde9636u25jimami0r19fv.png', '5npxt4x4m9ubsmehu0j0t6rx350mphwa.png', '', NULL, '9f1d85b66fbcbf5260598b14fe650d2e'),
(248, '2023-04-27 00:10:17', 'iblock', 466, 700, 194033, 'image/jpeg', 'iblock/baa', 'h614nqkmwg709guqsesqqnmwijim1k4i.jpg', 's22cuk7sg0kdcfqpo714ga5hf1x9jlzx.jpg', '', NULL, 'c7d8b030f12c07ca618349f4a8e09df1'),
(249, '2023-04-27 00:10:17', 'iblock', 0, 0, 1649, 'application/octet-stream', 'iblock/c01', 'm1uigjz94mk0g7u3mdta3c38xrfsmebr.svg', '98d066zh291b694na4rboyms0pddjooz.svg', '', NULL, '3c139d1c5746f473ffdde3128ff9882a'),
(250, '2023-04-27 00:10:17', 'iblock', 640, 960, 189191, 'image/jpeg', 'iblock/354', 'z3g2acqqr8dygn2gsx5pt4sik6xxgarx.jpg', 'dn41b9zitjswr1swwc9olsxvmnrcm0h5.jpg', '', NULL, '15031832d7add829c9917ad937554b32'),
(251, '2023-04-27 00:10:17', 'iblock', 800, 1920, 454408, 'image/jpeg', 'iblock/f58', 'cc70poa8ix43orpyypz1u2zhai6y11tt.jpg', '8aojzxc4nqo28ensyjtt2frep5jnur12.jpg', '', NULL, '6e20d333571918aa7dd5c5c0f3d81f02'),
(252, '2023-04-27 00:10:17', 'iblock', 120, 120, 22523, 'image/png', 'iblock/517', '2nwjl5xrs37zwf2c3qtmvam0w3gotubw.png', '6mwp08ni7xen0j9cg9t7jhqso8f4f0ua.png', '', NULL, '7f754cad459fe20db68b9c30cb14d6c7'),
(253, '2023-04-27 00:10:17', 'iblock', 0, 0, 2941, 'application/octet-stream', 'iblock/587', 'e86ne0gof15ol7bpom4bwa8nbbs9sehy.svg', 'oxzovcafi29jqxyl2z7cdg8n70wkf261.svg', '', NULL, '790c261607049ca3ab8d32fdf6e286a2'),
(254, '2023-04-27 00:10:17', 'iblock', 640, 960, 169379, 'image/jpeg', 'iblock/a08', '81k5othkzeqon3ubycwh0eflg1s2h7ut.jpg', 'qfhhpfmn99tondgoi1f2o1r0s8b4p0vo.jpg', '', NULL, '4938aeeefdebd3a1b4bfdce1c80fa663'),
(255, '2023-04-27 00:10:17', 'iblock', 800, 1920, 355405, 'image/jpeg', 'iblock/d77', 'dxrqnq2gmiys04cb4uy5yapt3iu1wm7q.jpg', 'iegzkc086iz2wf0yfuwvsewq8ktlss8z.jpg', '', NULL, '7b7417df7aa76bdf96afbdca8e48b0e9'),
(256, '2023-04-27 00:10:17', 'iblock', 120, 120, 26662, 'image/png', 'iblock/ca0', 'tqfmyrsjyjrlptj3u8qa0kf5fj7tyy5p.png', 'k1jgl7y5eveeysr0wpf3y7kkw5p3sr4w.png', '', NULL, 'adf1eaca104f0b24c55a40947a9c00b9'),
(257, '2023-04-27 00:10:17', 'iblock', 0, 0, 5838, 'application/octet-stream', 'iblock/fe6', 'uwouqlmnhj9h26i0mjapvsy7j504a9x0.svg', '6n0az6exnyfth0sis7x4xofekdw4tnco.svg', '', NULL, '8d2d0221dacb1587301e8fdb00ed9959'),
(258, '2023-04-27 00:10:17', 'iblock', 640, 960, 128234, 'image/jpeg', 'iblock/a2d', '9szbt5pnk20p09l13198ed55z1g1h9rb.jpg', 'i7xv9ioigswuxgb722wj6tgzpj8vamth.jpg', '', NULL, 'ea93bb7cc2de2df0e79a36b0d9268926'),
(259, '2023-04-27 00:10:17', 'iblock', 800, 1920, 261340, 'image/jpeg', 'iblock/f82', '5rahzg0hn1q8ulf6eplxvp9ru04mo2hf.jpg', 'jg3juw1c452l0p0bm9utuq1wrxyudvo8.jpg', '', NULL, 'dad5ff6b2a2574d0b33e89904672def8'),
(260, '2023-04-27 00:10:17', 'iblock', 120, 120, 32360, 'image/png', 'iblock/d2e', 'c6n566cyhsaaceqbkerth6rurfprzz5l.png', 'zjqk9piokx3pfc4tk6p7e5caqox34ko3.png', '', NULL, '34942cf2afb6b9051fa258fc84ea6ccf'),
(261, '2023-04-27 00:10:17', 'iblock', 0, 0, 6087, 'application/octet-stream', 'iblock/8bc', 'f22qjipuwg6lwr0ze8lfb1miiqeeafgt.svg', 'rzfq3p7j0cbex5ot09xy23rmqg6u6edm.svg', '', NULL, '6122aa0d9dcea2fd9708eb4a366ee776'),
(262, '2023-04-27 00:10:17', 'iblock', 640, 960, 139975, 'image/jpeg', 'iblock/bea', 'aik49l4m4izoujrw3f9eihe8z7o8t0ri.jpg', 'i2zmybecp8yecolvdc7jejg5o3kiyab7.jpg', '', NULL, '9890ecfdeb2b075a46ae89b65c06e48a'),
(263, '2023-04-27 00:10:17', 'iblock', 800, 1920, 297278, 'image/jpeg', 'iblock/d46', '585xpweznz2mnpeiqgsbck2ivlajvnzg.jpg', 'q1pztn2o89pr1fpklwarsn16yonequid.jpg', '', NULL, '3b6c8a2e1ff531739499bf2623292cba'),
(264, '2023-04-27 00:10:17', 'iblock', 120, 120, 31772, 'image/png', 'iblock/047', 'n1bpxoubay84gdxcnjws312bewxix0ck.png', 'qqciasnfm9rhr77of8b19g2bg7m9pejs.png', '', NULL, '8f3da19f618f80a73fddc2cb354f7d11'),
(265, '2023-04-27 00:10:17', 'iblock', 0, 0, 4141, 'application/octet-stream', 'iblock/395', 'r7sbjtxgpwww9lmcyms8724iz40ml1zy.svg', '6pij5sp6ek1ccxi612wyn9y3jxfl2124.svg', '', NULL, '756deb9370f132382b0f8633a92c528c'),
(266, '2023-04-27 00:10:17', 'iblock', 640, 960, 218602, 'image/jpeg', 'iblock/cf9', '1ajeq7c9ccmtdchyak1ok2i3f50m9b6v.jpg', 'utoggihaw0mwy3l3lcdwmsl2r49fdnxr.jpg', '', NULL, 'c128f31b0f5713fe101a6fed09206b10'),
(267, '2023-04-27 00:10:17', 'iblock', 800, 1920, 357833, 'image/jpeg', 'iblock/d10', 'j131cvdg9p6dpkm36u9mnpn72ajhh6r9.jpg', 'iw0hjy47wb9j4m8buygkx1g2taxbzdhc.jpg', '', NULL, '3ab76127eca722ee97c4ffd07d4c5b26'),
(268, '2023-04-27 00:10:17', 'iblock', 120, 120, 23188, 'image/png', 'iblock/872', 'o8oa7cxvsd6ystmwsw0d85uqptip8yty.png', 'yufbtb7yf0qsdsiu4jszvy2pc2t4xe43.png', '', NULL, 'd28359614c746f570a468d3f46815206'),
(269, '2023-04-27 00:10:17', 'iblock', 0, 0, 8696, 'application/octet-stream', 'iblock/55b', 'aoi70d53ry99wblvv7hzy8zn7tiwelrp.svg', 'yi9d1ha35d2n4rkyfscw1vyxd4lu929e.svg', '', NULL, '9da034638aa0e68f19c4ee7827524a83'),
(270, '2023-04-27 00:10:17', 'iblock', 640, 960, 119889, 'image/jpeg', 'iblock/cee', 'zyt4k74nvhz2m4w1cicig85k390zrqe9.jpg', 'ej389qxdvmbxiaw20t9mft0gpzjwrv5k.jpg', '', NULL, '6b077611412cd1f5247f9e7ea6d86516'),
(271, '2023-04-27 00:10:17', 'iblock', 800, 1920, 249862, 'image/jpeg', 'iblock/785', 'rgkzzxy0g7j134ki8xdgmji3qg6s7p0x.jpg', 'p9u0ig0nsng3ncsi75y6js7pyq5fr0sj.jpg', '', NULL, 'fe4bc4ca306bb20d2fdda6a15d33acc7'),
(272, '2023-04-27 00:10:17', 'iblock', 120, 120, 34718, 'image/png', 'iblock/b81', '7bvg9voqtboik5zimglq4fpra9tenigz.png', 'pwnsr9jel6hxb8qrr9awykty0bcjolhh.png', '', NULL, '471bf5769841d4f2676f85e7499ed469'),
(273, '2023-04-27 00:10:17', 'iblock', 0, 0, 8864, 'application/octet-stream', 'iblock/587', 'dl4l0x0e4kz8athf6kxy1e6arxzsno83.svg', 'u5sao7duhtp6nst5407o2v7tk1d3p4l5.svg', '', NULL, 'f72b8bb692419c544035830787904bfa'),
(274, '2023-04-27 00:10:17', 'iblock', 640, 960, 214213, 'image/jpeg', 'iblock/fff', '3uxln2usqhqy7h71si74snqyfib8qmeo.jpg', '5ci3uudj5rp40waqpd07uxfz63r25iah.jpg', '', NULL, 'e771f201a9639d61d03ed1e76ad989aa'),
(275, '2023-04-27 00:10:17', 'iblock', 800, 1920, 430998, 'image/jpeg', 'iblock/2a8', 'pawcnse5qdnsov9esrex30s95emfiin6.jpg', '0fy5dnm40rnrxe5k12pgyzdq1er8b2l8.jpg', '', NULL, '01a67e4aa817572b2c131b2706b6a918'),
(276, '2023-04-27 00:10:17', 'iblock', 120, 120, 18798, 'image/png', 'iblock/5f3', 'hux1e6ru7r2n2tf6btatcx745bvvo7eq.png', 'lf9mob497c6uk1rx03rfej4u781b18rn.png', '', NULL, '975b4e19637ce408cf816a89ce8f3d3b'),
(277, '2023-04-27 00:10:17', 'iblock', 0, 0, 3760, 'application/octet-stream', 'iblock/ebd', 'drtr04y97e8o3354hl04hktisn5cvyp6.svg', 'rgrxet7luounke92rla156dfj6p4y1lg.svg', '', NULL, 'aba7d6c11b9d7d39bace0b8fb410b034'),
(278, '2023-07-05 22:59:37', 'iblock', 640, 960, 265659, 'image/jpeg', 'iblock/de2', '6qt8waxp6nesl80v6gt84v98xssvi859.jpg', 'lvfowsre7ng1gac7ebv6plioxkdsujrz.jpg', '', NULL, 'fd99b274dc9ad06aee96f82108dc3841'),
(279, '2023-07-05 22:59:37', 'iblock', 800, 1920, 469865, 'image/jpeg', 'iblock/5fe', 'mil0vo3mnpkfvsq04rb3lgczod0wzckf.jpg', '9l1xuciad0mlqdmunzclpt9t8xyjqb3t.jpg', '', NULL, 'ea81a7e98293ab83b6860e41cd75cdbe'),
(281, '2023-04-27 00:10:17', 'iblock', 0, 0, 7351, 'application/octet-stream', 'iblock/5d8', '6vq8w7k4ueifuikdp6cm6wu2j4uewxjg.svg', 'aiwrttw0toicx4mpyildfcktufri5bsb.svg', '', NULL, '4323de49d8e2aa129714f925b92ad8cf'),
(282, '2023-04-27 00:10:17', 'iblock', 640, 960, 162255, 'image/jpeg', 'iblock/d3e', '3ak1bstfxhy7yjk6qdqamkzcm6krhltu.jpg', 'z5n88xb31lnhfkdd7bks04kp45xj938h.jpg', '', NULL, '6c08c8abcb07b48a0503ce6686721800'),
(283, '2023-04-27 00:10:17', 'iblock', 800, 1920, 297409, 'image/jpeg', 'iblock/689', 'qnzunc11ja0lu45c7fyhk6qcdlrd7l2e.jpg', '87evp8xrds4ricpv1fkt233kkxjlo95s.jpg', '', NULL, 'a1cbd797118463ec8d3c9a089f67966b'),
(284, '2023-04-27 00:10:17', 'iblock', 120, 120, 25372, 'image/png', 'iblock/798', 'x2wls6crvetlppf3cqtd2176b4gkrwh8.png', 'widijp7verfyzn9sxg9mrtg9g0bzgafb.png', '', NULL, 'a313eb9052b3cdc4172aa6116fec132a'),
(285, '2023-04-27 00:10:17', 'iblock', 0, 0, 4079, 'application/octet-stream', 'iblock/2d5', 'sirdnziixy340bw5qnl17lmx4zzamh44.svg', '9ajemhfgloubgg0smckov76bwafxijxm.svg', '', NULL, 'ce480d16511eeb1c7941f581c2a0d8a4'),
(286, '2023-04-27 00:10:17', 'iblock', 640, 960, 216884, 'image/jpeg', 'iblock/64b', 'xoj3k6o38czjjcdv8ftf1qd45xgf3sjw.jpg', '134egrs2d9tuludwi6lai94nvpz2lzho.jpg', '', NULL, '87d161bf2121788d2bd13d7fd780148e'),
(287, '2023-04-27 00:10:17', 'iblock', 800, 1920, 433458, 'image/jpeg', 'iblock/d98', 't17moxlhklf7dwazwld7e577fkbyi1xr.jpg', 'i946jdfz33ulolod8aezj29z1y2e7hng.jpg', '', NULL, '7d130631434bcf0c6596537a296330fe'),
(288, '2023-04-27 00:10:17', 'iblock', 120, 120, 17161, 'image/png', 'iblock/584', 'zuo7pg5lt2hchu41oz5dum713s21hfjt.png', 'zfoqwzyisczleoevjo3fx0skv928kgzf.png', '', NULL, 'c7b688eb83b80d473fbd485b17ddd513'),
(289, '2023-04-27 00:10:17', 'iblock', 0, 0, 3506, 'application/octet-stream', 'iblock/866', 'u1pi0g7pwqtbo6g2b6nv8erql46lu0xa.svg', 'jben6oy36oq1chykv8yf71d8xj3m39i2.svg', '', NULL, '0211f63c0ac5d590624152c9d23ca673'),
(290, '2023-04-27 00:10:17', 'iblock', 640, 960, 242298, 'image/jpeg', 'iblock/7bd', 'bwhljijtz8d1j6sgeejcjfrj93erv8px.jpg', 'cljk11s0z3klhh47epywkyuw43rwg6u1.jpg', '', NULL, 'b65ed884cf865a8f9abe854dd069f3bb'),
(291, '2023-04-27 00:10:17', 'iblock', 800, 1920, 479608, 'image/jpeg', 'iblock/ee0', 'r7rxzp28797e2e17tn1dqhogr5pgpvid.jpg', '2wj052qju570fwe91lr58wxt6qfbizms.jpg', '', NULL, 'c20ce0e4ebfa5e626a09b7742050ff85'),
(292, '2023-04-27 00:10:17', 'iblock', 120, 120, 23784, 'image/png', 'iblock/b88', 'vurssi91dnxy4hz40nmk2bva64y1sou7.png', '3kcrz956wzt8226emkr25i84p17ower0.png', '', NULL, 'ca616904e664a4f4786dc2bb00462488'),
(293, '2023-04-27 00:10:17', 'iblock', 0, 0, 4693, 'application/octet-stream', 'iblock/e67', 'a6tbu6gu68qilvxtlk2c1x2wc6tlabpf.svg', '16ol4v7vhvoxmrfszubohgo9s6cyiob4.svg', '', NULL, 'f4cec57eef10bf2ceed9ea4ae531d140'),
(294, '2023-04-27 00:10:17', 'iblock', 640, 960, 178875, 'image/jpeg', 'iblock/717', 'oqj5d4pcamh08in63ad71vjnbv9j4vsn.jpg', 'z5ytowx4rdhggyik6oyxicwbyxvgffl8.jpg', '', NULL, '06808192ad8173c719913d11fcae3371'),
(295, '2023-04-27 00:10:17', 'iblock', 800, 1920, 402279, 'image/jpeg', 'iblock/ae8', 'jw0gdgc4tiyu6uij13a2kd03m8jyprp3.jpg', 'z6zvxcg2dn8oe36dw80yybqkrltkgu31.jpg', '', NULL, 'b0ab2a797b4a2ebfb4bdb4d32290ff63'),
(296, '2023-04-27 00:10:17', 'iblock', 120, 120, 34727, 'image/png', 'iblock/047', '4qusp9q0g051p13pniii550x2941sdi1.png', 'xw05zazqjbp348603m9tojug66625jgt.png', '', NULL, '8be78c8952b8ee7e3d382ee86d33d0cc'),
(297, '2023-04-27 00:10:17', 'iblock', 0, 0, 4681, 'application/octet-stream', 'iblock/5d4', 'lgy6p45cddm5kwzw3w4dud8vcjm5mrki.svg', 'elzl8jttkvu84g7nm6xhaqyxhjcu782a.svg', '', NULL, '28a41fa0ff0fed0c1bc48c331453cbf1'),
(298, '2023-04-27 00:10:17', 'iblock', 466, 700, 227629, 'image/jpeg', 'iblock/e93', 'uxtnwtqf0btswxp6pnqnee4vmdj9i7go.jpg', '4t6ylyhhqsi0o7bl8o7z0ibywuameh7a.jpg', '', NULL, '18c6f4958b9064bdd2f344a21205744b'),
(299, '2023-04-27 00:10:17', 'iblock', 800, 1920, 844288, 'image/jpeg', 'iblock/d5e', 'wnz308nlaepij2x2hjwubtjplqus18gy.jpg', 'qtdb0mv7k3q12st3832amweh52bjs57u.jpg', '', NULL, '2924ff1fdf20971cf0503fcdfc1c9fd7'),
(300, '2023-04-27 00:10:17', 'iblock', 120, 120, 25058, 'image/png', 'iblock/96e', 'kl6jj4o4bj2561tbeunpsv8h1pl4kky0.png', 'zr8bokry5qzqtdz1l3g06v6ieesbkjw7.png', '', NULL, '3549011d1113cb1a5768a7341375981d'),
(301, '2023-04-27 00:10:17', 'iblock', 0, 0, 4849, 'application/octet-stream', 'iblock/b1d', '5ufd7jwsxvko6ksrmpvtbr9lh3fz5m62.svg', 's9zx39g7ss3kuh0gjyhif7ug17c793qq.svg', '', NULL, 'e430d56e71a5c1ed53b3d5c1a35d56ed'),
(302, '2023-04-27 00:10:17', 'iblock', 640, 960, 190501, 'image/jpeg', 'iblock/0df', 'yx6o5r4nijwhy8v5saqgf0hf7jbvhprm.jpg', 'y21t101b1u102d7w5j6lsw10v8l83hp2.jpg', '', NULL, 'efa69d971376622ec7c3ec01c8e4ec7c'),
(303, '2023-04-27 00:10:17', 'iblock', 800, 1920, 459477, 'image/jpeg', 'iblock/fed', 'yf2by7euk86lhr47mlj250fdaixo1t2n.jpg', 'qyr60ltggvrsvyasyc6c8ic6rnkw1e7d.jpg', '', NULL, '7316fae1adf8d4a91492027626345eec'),
(304, '2023-04-27 00:10:17', 'iblock', 120, 120, 23256, 'image/png', 'iblock/004', '154kzrqn0m3vetmtdhif4z8165m3btew.png', 'cz700ysd78enq9jb1603yuv5npsxugc3.png', '', NULL, '355b73e369932b8deb063c18866531f1'),
(305, '2023-04-27 00:10:17', 'iblock', 0, 0, 2724, 'application/octet-stream', 'iblock/01c', 'uclvndawxbuipu06u1lsludcu7ibbegc.svg', '770fue2izlxb6ah32fkb92qw092eycv4.svg', '', NULL, 'd806f76ee9753ce3b43ade206ddc10ef'),
(306, '2023-07-08 23:35:37', 'iblock', 640, 960, 191297, 'image/jpeg', 'iblock/d1d', '4dkdnl149v4ma6iottq8lrndyja2prf7.jpg', 'v47clxzyd1une8jxjx6okym468j1s3f2.jpg', '', NULL, 'f1f178a8b5b06736eee79f798606e2e1'),
(307, '2024-06-20 14:16:01', 'iblock', 640, 960, 191297, 'image/jpeg', 'iblock/d1d', '4dkdnl149v4ma6iottq8lrndyja2prf7.jpg', 'v47clxzyd1une8jxjx6okym468j1s3f2.jpg', '', NULL, 'f1f178a8b5b06736eee79f798606e2e1'),
(308, '2023-04-27 00:10:20', 'main', 0, 0, 2361, 'application/octet-stream', 'uf/bee', '3t5g0xcvt75s4hh2pvjx9arnegr1dw2h.svg', 'w6k2o9ykjfk2o5hqz6sehdodz3spa2fo.svg', '', NULL, '5e37438b29c674d502faa4ef0adb7c2f'),
(309, '2023-04-27 00:10:20', 'main', 120, 120, 20503, 'image/png', 'uf/456', 'npzwhcik25dlzcs9o24fd9t1nlfh0rnj.png', 'd8wof7ylf3bfczkbtzcszcrip56zf3e5.png', '', NULL, '2196b9d8864c0e9dae6ff31c4c661e2b'),
(310, '2024-06-20 14:11:41', 'iblock', 640, 960, 285432, 'image/jpeg', 'iblock/48f', 'eq0ljxmk0cvb69hwghl6uunxq2ghktse.jpg', 'pxqat39odudr9g726yhi0jcakch53omy.jpg', '', NULL, 'ad6e9396c2e5c003b4be306b61254c36'),
(311, '2024-06-20 14:11:41', 'iblock', 640, 960, 285432, 'image/jpeg', 'iblock/48f', 'eq0ljxmk0cvb69hwghl6uunxq2ghktse.jpg', 'pxqat39odudr9g726yhi0jcakch53omy.jpg', '', NULL, 'ad6e9396c2e5c003b4be306b61254c36'),
(312, '2023-04-27 00:10:20', 'main', 0, 0, 7647, 'application/octet-stream', 'uf/009', 'ewae0t6sx9pa0bt32fj7kxm7mmtxsf0q.svg', 'd3fetavtdwcg60882s7rpaqidbmogkkq.svg', '', NULL, 'b30cf4955ea0bba7bc71686817309b7c'),
(313, '2023-04-27 00:10:20', 'main', 120, 120, 23872, 'image/png', 'uf/b41', '2796aokbn3b4k3d0xjx4yt7986zk0wh5.png', 'b2jqvrmv11v5zseult7a60mzsm7q2uos.png', '', NULL, 'd53e1145dada0f39cc6d69b301cb67e2'),
(314, '2024-06-20 14:11:59', 'iblock', 640, 960, 218238, 'image/jpeg', 'iblock/4a0', 'tyly2z6j3rxa3o649go93ruvf990xx7w.jpg', '5hygfgacm2itbt0zevs86htnkbho5pdx.jpg', '', NULL, '10cd9a5d5008bef6a2c5370f1a1b5fdf'),
(315, '2024-06-20 14:11:59', 'iblock', 640, 960, 218238, 'image/jpeg', 'iblock/4a0', 'tyly2z6j3rxa3o649go93ruvf990xx7w.jpg', '5hygfgacm2itbt0zevs86htnkbho5pdx.jpg', '', NULL, '10cd9a5d5008bef6a2c5370f1a1b5fdf'),
(316, '2023-04-27 00:10:20', 'main', 0, 0, 2656, 'application/octet-stream', 'uf/fbc', 'mwpkx1qqez41zjhk8mjb5zco30sgcoh3.svg', 'xep1rdw6l5qbfc5zq4u3kv94hbsetlyo.svg', '', NULL, 'b9622799a2265cecc6e321d736a30dc4'),
(317, '2023-04-27 00:10:20', 'main', 120, 120, 23715, 'image/png', 'uf/812', 'vudks173b8nxc1djwsznos0gtjjp60zg.png', '7r3dceffkoabdtf0njx2lzg3q51l3p5w.png', '', NULL, '224b6ef33cc3448790eeb82bbcf35ed1'),
(318, '2024-06-20 14:12:47', 'iblock', 640, 960, 408070, 'image/jpeg', 'iblock/110', '5fv9nug6lw1sysy0hqrhawmktnuxs0ml.jpg', '8om0sxzlkpfslubro9rrsrujuupmx951.jpg', '', NULL, 'f5385e8b785f4f07019e6da40a0e730b'),
(319, '2024-06-20 14:12:47', 'iblock', 640, 960, 408070, 'image/jpeg', 'iblock/110', '5fv9nug6lw1sysy0hqrhawmktnuxs0ml.jpg', '8om0sxzlkpfslubro9rrsrujuupmx951.jpg', '', NULL, 'f5385e8b785f4f07019e6da40a0e730b'),
(320, '2023-04-27 00:10:20', 'main', 0, 0, 1440, 'application/octet-stream', 'uf/559', 'v4i1ry0whwqpunie9tyjnd3rqe70qkqf.svg', 'wxsd3e4wso8y119fojvlpmgyvi592ajy.svg', '', NULL, '960cced92f96101bd17eafcf9efa497b'),
(321, '2023-04-27 00:10:20', 'main', 120, 120, 26056, 'image/png', 'uf/2de', 'omwxn9fwu5znu7oy1bwnr2wj6j6chmpe.png', 'obdic46rqcastjt13dzpv67gshooesji.png', '', NULL, 'f71220ec15983ae5b1e482216034d267'),
(327, '2023-04-27 00:10:20', 'iblock', 665, 1000, 103288, 'image/jpeg', 'iblock/e25', 'jn2faqgf8pqh19aao3ltprobuz7cpruw.jpg', '648jeeilyfhwzd1xhgsqtn2rd6i6c45a.jpg', '', NULL, '3343daf7a0a65364097347d04148471b'),
(328, '2023-04-27 00:10:20', 'iblock', 832, 1250, 499710, 'image/jpeg', 'iblock/f27', '7dus5pl915zcx00bbx3cr8ip0v60545l.jpg', '0prw6mx3u3gado0f26j4atn4ozejcuio.jpg', '', NULL, 'af83d48b2f7ba165f1a1b13e868823db'),
(333, '2024-08-22 14:28:07', 'iblock', 665, 1000, 188480, 'image/jpeg', 'iblock/85e', 'ghmiozcfqnwefhl6am36p3re8r6c6ocb.jpg', 'hbl1aecxk2t1zb6zenql7q4abje86rb0.jpg', '', NULL, '44698d1f193295b1a18d1bda8be7df6e'),
(334, '2024-08-22 14:28:07', 'iblock', 832, 1250, 741965, 'image/jpeg', 'iblock/d8d', 'mw3pj3s7dao5h8d7zzjdi7oc90m3crfa.jpg', 'i0s9ghoeobc61aaarslmn0b3zctyjzio.jpg', '', NULL, 'ff29f505ca0f72355742bc8b87e027f1'),
(335, '2024-08-22 14:28:13', 'iblock', 665, 1000, 184948, 'image/jpeg', 'iblock/30c', 'z1ovlda31rsytpyk3dj829fu07wkzpzf.jpg', 'f8owb1x3di0n8svb1evjfakgy8wdcknn.jpg', '', NULL, '1d078b5a517580e89dcdc29b06814ced'),
(336, '2024-08-22 14:28:13', 'iblock', 832, 1250, 748198, 'image/jpeg', 'iblock/9f5', '2rfz3q9w9ttmjpt9b6jym126nivbwjm9.jpg', 'x94aucwiziu890hwqhx3pacfeglump3w.jpg', '', NULL, '3b07e8081690e4e714660c07b1205af9'),
(337, '2024-08-22 14:27:55', 'iblock', 665, 1000, 209181, 'image/jpeg', 'iblock/f97', 'ucg23br8anl2r0bmo6hweu5xwh9b4159.jpg', 'r0ed15i69iv4ho7lsxsbx1ty5dv9h4fb.jpg', '', NULL, 'be00fcc425f45fb54c34ad230e532192'),
(338, '2024-08-22 14:27:55', 'iblock', 832, 1250, 809907, 'image/jpeg', 'iblock/031', '4bfyeq0pl5dmxwu13gag5e6wd3f68unu.jpg', '1zox4py7bcd8s334z760n4o39qsp0xcc.jpg', '', NULL, '05a0897b9788045a0d0fbe772463420d'),
(339, '2024-08-22 14:28:01', 'iblock', 665, 1000, 202754, 'image/jpeg', 'iblock/69a', 'xor31t31lqfve3oocfvdornrwkumujc1.jpg', 'obnxjd40s9tdh6sk7zupa60n3zs6r5id.jpg', '', NULL, 'e6abf52644a14c001b78f760f6a4ce5a'),
(340, '2024-08-22 14:28:01', 'iblock', 832, 1250, 769463, 'image/jpeg', 'iblock/73e', 'jqtacelqtbnymj29fet82crbg66ko2fr.jpg', 'e2929mgzqzixpjf7jtlfj1582dk3v4ie.jpg', '', NULL, '227633479f2b66b22ce3c26745ba5638'),
(341, '2024-08-22 14:28:44', 'iblock', 665, 1000, 188843, 'image/jpeg', 'iblock/8ef', '9lucfqlpxg1386my0ogxuk6pocs2f8oq.jpg', 'dv68kdz8vp0wsfkbzb3uqzipbbnhb9dz.jpg', '', NULL, 'e2aafa297d473dd83e1ac76d5bc303b2'),
(342, '2024-08-22 14:28:44', 'iblock', 832, 1250, 613721, 'image/jpeg', 'iblock/876', 'hez10saopvkdopm5oys2j2ey1pxp3yfw.jpg', 'd6slvl2tjsknpjq3ve0e7j7wl6027z8y.jpg', '', NULL, '49c33383c8b31d284fc7a81dd45c02d6'),
(343, '2024-08-22 14:28:51', 'iblock', 832, 1250, 670339, 'image/jpeg', 'iblock/b91', 'dbssjuo9g7n9zvmf5o9cdklyf4rnu4xb.jpg', 'prhp2bsa94ynt1o658lf2ppwxtfns291.jpg', '', NULL, '9ffa9e55fa9733373a50898488db20b0'),
(344, '2024-08-22 14:29:03', 'iblock', 665, 1000, 207474, 'image/jpeg', 'iblock/beb', '8253bl6ih83mgx6w6hyfk5bh05w428a9.jpg', 'q2qaewusegi01cagf4tcj5aitajvt4zp.jpg', '', NULL, 'abc7c579e9db6a03ded203d948dc8dec'),
(345, '2024-08-22 14:29:03', 'iblock', 832, 1250, 731717, 'image/jpeg', 'iblock/2d4', '9o86ucnhxnxcpen3jzud64gckp18y8lz.jpg', 'nk3sxcrejqyh0jjjx4sha4hitzfc8jm5.jpg', '', NULL, '7e5f3ebf3dbb1fb162733d9027bae00f'),
(346, '2024-08-22 14:29:12', 'iblock', 665, 1000, 133297, 'image/jpeg', 'iblock/88e', 'ih2sc69dd29wn5ozlbuggvmtl40g47f8.jpg', 'qhlix8lfob8c92tpfh51ryisqvnaau76.jpg', '', NULL, '536a8bdb60da875096f8019340d6fab1'),
(347, '2024-08-22 14:29:12', 'iblock', 832, 1250, 472401, 'image/jpeg', 'iblock/4bf', 'vd9l6y9o3zpy893n12fyvfnan61hry6a.jpg', '3qfhakdi07wg8vid62nwlvbzpopae71l.jpg', '', NULL, '0311305010e65facd24fdfe3f8d6f792'),
(348, '2024-08-22 14:29:20', 'iblock', 832, 1250, 539538, 'image/jpeg', 'iblock/e10', 'ackr60uqq59jannasom10mwc7feahisr.jpg', 'pmjfnswzpu5g6g2t9vqnlzilzbwgw0bt.jpg', '', NULL, 'a091bf94f6b85c389371be5592c67d5e'),
(349, '2023-04-27 00:10:21', 'iblock', 832, 1300, 675401, 'image/jpeg', 'iblock/cf5', 'ut6lu8jluu50brt97jdweq5x1xcuuu67.jpg', 'kk3evg1vbannfnrn8n6f60tq3ajuniur.jpg', '', NULL, 'fd9c2d8a0c09563ad054397c705a6daa'),
(350, '2023-04-27 00:10:21', 'iblock', 832, 1300, 628302, 'image/jpeg', 'iblock/db1', 'h1isps12ph6ytupnt79y4uhky6g095za.jpg', 'vkjdkgk3qdd7p46clsrolxlr97sbucy5.jpg', '', NULL, 'f32f1f585c2b6c6901243160a07ba5a8'),
(351, '2023-04-27 00:10:21', 'iblock', 832, 1300, 880149, 'image/jpeg', 'iblock/be4', '18gmlzec5vjm5zvfueg72qtqdkkwfrnn.jpg', 'klz9mtpt5807snz9m5msregh95mgv1p1.jpg', '', NULL, '3edd62bef6ad190cf5765bc47cfd8b1c'),
(352, '2024-08-22 14:29:26', 'iblock', 665, 1000, 163935, 'image/jpeg', 'iblock/235', '4fzmxg3v0t7tx914kgp5ux710it74k2f.jpg', 'am6f13qgxpcpujakceonjrzl2125vbg0.jpg', '', NULL, 'b78478c01a245d4064036a1bcff1fa64'),
(353, '2024-08-22 14:29:26', 'iblock', 832, 1250, 611224, 'image/jpeg', 'iblock/fd7', 'o5jqdh8xbf6govfbv3f75422d78gj4ga.jpg', 'xfi72y9o31sxthnclu13bvmasso9tagz.jpg', '', NULL, '804cb0af182a22a2f361389963a326ad'),
(354, '2024-08-22 14:29:37', 'iblock', 665, 1000, 186675, 'image/jpeg', 'iblock/b0f', 'bx9daebb877g43i3stq37e3rhs0oht0q.jpg', 'yyxbgv80zryzu4z36f07gtmbh6y6dakk.jpg', '', NULL, '7167f4012f4c4a837fc95d00b45d62ad'),
(355, '2024-08-22 14:29:37', 'iblock', 832, 1250, 632105, 'image/jpeg', 'iblock/b95', 't5yr6t3vcqc38xu7wpctebv8rdv7h2b4.jpg', 'cjwc3j8mbb07maz6ggaw30v27djhy7ja.jpg', '', NULL, '378c16e33a9e7d21df798f312b57871b'),
(356, '2024-08-22 14:29:47', 'iblock', 665, 1000, 181679, 'image/jpeg', 'iblock/4ae', 'xdgw368wn0gd0749qtzwx6bns3i0z3ie.jpg', '9h5u6zs03k9kzpwonbra80amrk7b4pp1.jpg', '', NULL, 'b132aeeb5828630ca8b75a480d5e44c3'),
(357, '2024-08-22 14:29:47', 'iblock', 832, 1250, 695563, 'image/jpeg', 'iblock/3cb', 'maa3rqwf6lw6gwzj7sod6wdvtfitr2n8.jpg', '4d47tzscvvv2wiclaxb68t0b0xyr29qo.jpg', '', NULL, 'fd675e17844445c36e6152cfc8439e5d'),
(358, '2023-04-27 00:10:21', 'iblock', 832, 1300, 599130, 'image/jpeg', 'iblock/5d7', '8swhc42ocis954sdvxscff56003btn2o.jpg', 'q5mvtm1b8m6fvjmg8d23sz7vvi1ai89a.jpg', '', NULL, 'e84114fc581d73d73301a632ebeed504'),
(359, '2023-04-27 00:10:21', 'iblock', 832, 1300, 604779, 'image/jpeg', 'iblock/5b9', '9cf0n1iee1t7fsielkxokbtl2ita0iy3.jpg', '1zis1me83kyh4g4ipboyi4zus1yhij6j.jpg', '', NULL, '1347942a1f1636356c64c476b0473678'),
(360, '2023-04-27 00:10:22', 'iblock', 300, 300, 175366, 'image/png', 'iblock/f14', '3jsxxbglb4qavye1cwtgmpslu5u2qono.png', 'cqwtvdv5kerazvwjs9k6yr0kh3rvlo6q.png', '', NULL, '98b16c85905b5558183aea50c25ec29e'),
(361, '2023-04-27 00:10:22', 'iblock', 697, 1500, 715999, 'image/jpeg', 'iblock/a4d', 'ckk3azxucbd56jvjzsi4qfrxn5qiulyr.jpeg', 'z1y3wunum3rq3kft45vir07qsg6i7p2k.jpeg', '', NULL, '9272695204b4fdc426fad49899818137'),
(362, '2023-04-27 00:10:23', 'iblock', 466, 700, 46317, 'image/jpeg', 'iblock/da4', '7j72gjevmgy59ragzff2wk9qvswszzqp.jpg', 'mcigx181j1stuxl5u2mp616yudvbzgrz.jpg', '', NULL, 'db65d700d4c04ce1c50f23934e390bed'),
(363, '2023-04-27 00:10:23', 'iblock', 740, 1920, 183668, 'image/jpeg', 'iblock/01a', 'xkwao0kzz9nu2e50wxvhp774791zdqq0.jpg', '61s1ocnk4vrvghtcr0llnt8oarfgy32d.jpg', '', NULL, '8642d3b1ed3891dc5089022b950a0235'),
(364, '2023-04-27 00:10:23', 'iblock', 714, 1000, 105893, 'image/jpeg', 'iblock/271', 'uqc0qr6dnzbgq4v16ptm2a1tttxrn3oj.jpg', 'ejb47q8ch32b8fj5123q14h1rd3vfg8j.jpg', '', NULL, 'c2e8d35d984a2380e7d9e73351ca447f'),
(365, '2023-04-27 00:10:23', 'iblock', 466, 700, 43993, 'image/jpeg', 'iblock/25b', 'wt07bfj06dgpycin3w0h9129kbf0a5ly.jpg', 'rt902eepq2ia62wvnc1t3nb1hfv3fn54.jpg', '', NULL, 'dab57235185f8a91bdee25d717539090'),
(366, '2023-04-27 00:10:23', 'iblock', 740, 1920, 148005, 'image/jpeg', 'iblock/677', 'wf56r3zdwb4uo2qk21j2zn1apbnbyubl.jpg', 'a8um83gytqzol0i4h6zfwk3ofqe74wkg.jpg', '', NULL, '470ed2a5fe735fa709c21d550b6520b4'),
(367, '2023-04-27 00:10:23', 'iblock', 466, 700, 41077, 'image/jpeg', 'iblock/691', 'tc2wdtleino060xfjppfilnfks3ai4gq.jpg', '1tjsgfslx2hoef57z3f75lxqyjuz61us.jpg', '', NULL, 'b0441fa1e989cbb6e2f3cb05cf80ad16'),
(368, '2023-04-27 00:10:23', 'iblock', 500, 1920, 85880, 'image/jpeg', 'iblock/62c', 'y1zz5l805kfajryqnqwdwddr9c6qk5h1.jpg', 'tk9vf4gihyfglzgu7gm0mvl3hu1unbls.jpg', '', NULL, 'c03b5bbea4c898630381a3cbe16e159a'),
(369, '2023-04-27 00:10:24', 'iblock', 420, 630, 83425, 'image/jpeg', 'iblock/8d2', 'a4q8qd19mgtfrdxhggubhtj3gd7kvw1l.jpg', 'wuoc7ak7p0sum2om234p6vgl4hctbmrw.jpg', '', NULL, '4e1ab44c9767c70f59e26dd2ff23a24d'),
(370, '2023-04-27 00:10:24', 'iblock', 920, 1700, 278924, 'image/jpeg', 'iblock/cce', 'c1qpkr9pff66fgz0muic846zrlw5mjqj.jpg', 'tjh36j1rgzlyb3h17dlkp17vzv8bwwzq.jpg', '', NULL, 'd51bec1df291f4f9926ab5ad5f4f9198'),
(371, '2023-04-27 00:10:26', 'iblock', 640, 960, 291713, 'image/jpeg', 'iblock/c47', 'qbyixflep2rqbrllbcl3rdgfgsqx2be2.jpg', 'r0hzo20cftosgb99qkzs2czdegjo733k.jpg', '', NULL, 'c8e23154b4bc24f4d8a2a16d2ff35c5b'),
(372, '2023-04-27 00:10:26', 'iblock', 640, 960, 202833, 'image/jpeg', 'iblock/f9a', 'cszttkovv1q7sgi1b4k6pcs3h82fm01k.jpg', 'w2etvlndjbzfpjg7j3hr31nmjvfvtw2p.jpg', '', NULL, 'db16e611fdfbb9322bb0ffb74a33b481'),
(373, '2023-04-27 00:10:26', 'iblock', 640, 960, 280169, 'image/jpeg', 'iblock/460', 'jopqs7bev5a6t480q27abrw48yt7bjas.jpg', 's94joc9jfbklisbsle11yc9o0xvrzbk8.jpg', '', NULL, '18bd548e1f619d20bf491337017166dd'),
(374, '2023-08-28 01:02:21', 'iblock', 640, 960, 250673, 'image/jpeg', 'iblock/2e9', 'hldk56ke2cmkxjwhz1jn3lkjdx546v21.jpg', 'u9sm3kgf8ja2yins70vw4ckw2fv5uelv.jpg', '', NULL, 'e45cff2f061ddc4938777cc3c12ec37b'),
(375, '2023-08-28 01:01:39', 'iblock', 640, 960, 135076, 'image/jpeg', 'iblock/6d0', 'rmh8z46zcq9si1ubnuoq6lp882ckkcvx.jpg', 'b9ymyvy0vnipcv8jww7tugvstw6f8f9k.jpg', '', NULL, '71c28c63a64b8ef3cc75dd99f70327f1'),
(376, '2023-04-27 00:10:26', 'iblock', 640, 960, 162109, 'image/jpeg', 'iblock/70e', '1vspgpu9qkye3a7w788lxwelktrqpixs.jpg', '33kpbv7ygsphubvbqz5bxkgto0nu10kn.jpg', '', NULL, 'd3fb4e8d0a6407f4c06cb52c021c435e'),
(386, '2023-06-29 22:37:23', 'iblock', 533, 800, 167482, 'image/jpeg', 'iblock/331', '7ivcf8wx54231pv749dg3binwt40bwj8.jpg', 'derbent.jpg', '', NULL, '4d39addf128a73612f5ef24e696ec93d'),
(389, '2023-06-29 22:33:12', 'iblock', 533, 800, 120746, 'image/jpeg', 'iblock/dba', 'tvhkpkoa42mus3zs8zj5w9he7xifuz9l.jpg', 'sulak.jpg', '', NULL, 'a15e2c6eaf9b958a92314fb844fa8d93'),
(390, '2023-06-29 22:45:27', 'iblock', 533, 800, 117472, 'image/jpeg', 'iblock/ed0', 'y4zv8gn34e60ifq72vpxoy0ppsjtha97.jpg', 'goor.jpg', '', NULL, 'fe7dfa2885b3df76d9d54595b793e9aa'),
(391, '2023-06-29 22:58:44', 'iblock', 533, 800, 176772, 'image/jpeg', 'iblock/054', '13rw2m2471ul1ubsr5pzom72c2gnw6kg.jpg', 'tobot.jpg', '', NULL, '3ba13e5463e758fa57bd062deafffadb'),
(392, '2023-06-29 23:05:38', 'iblock', 533, 800, 107650, 'image/jpeg', 'iblock/165', '8y5u9k5vf8dn4wqz90fnls8m0utpk9gy.jpg', 'gamsutl.jpg', '', NULL, '99fabe5e07d4442daa0f357e4ab0bf49'),
(393, '2023-06-29 23:12:40', 'iblock', 533, 800, 177406, 'image/jpeg', 'iblock/3ba', 'v3gk9o2sz12mqh6fvha7iwokwzvjwlhr.jpg', 'karadah.jpg', '', NULL, '21c5c798d144abe84921343fac5c2a96'),
(394, '2023-08-28 01:06:09', 'iblock', 522, 960, 62453, 'image/jpeg', 'iblock/ced', 'refx0o38zaqkcurtn4774jvh06kq1860.jpeg', 'adobestock_209739260.jpeg', '', NULL, 'de3b80483f2cfacb63f75097c1f16e1c'),
(395, '2023-08-28 01:06:09', 'iblock', 1088, 2000, 189506, 'image/jpeg', 'iblock/a1c', 's4pqx7srjxl7e6ah0zhjmqy18tjqk1tu.jpeg', 'adobestock_209739260.jpeg', '', NULL, '1363201ac159450cde03dc8be8a7e110'),
(396, '2023-09-06 08:14:30', 'iblock', 600, 960, 67454, 'image/jpeg', 'iblock/a4b', 'wrxrz5sjuiqk5h7sb3hf9bg4kazqxbf4.jpg', 'podgotovka-k-svadebnoj-czeremonii-na-maldivah-1024x640.jpg', '', NULL, 'b0d12a9cfecfa5707b244ccfce9747d8'),
(397, '2023-09-06 08:14:30', 'iblock', 640, 1024, 104663, 'image/jpeg', 'iblock/9c2', 'tzax97dztxpkyr0u0jaouzzrsdb1zc9h.jpg', 'podgotovka-k-svadebnoj-czeremonii-na-maldivah-1024x640.jpg', '', NULL, 'fa3968dad2e2e0276d3eb92fc38c346c'),
(399, '2023-07-05 22:50:04', 'main', 800, 800, 44311, 'image/png', 'uf/586', '791hou9jztwhd5j89ovxtlkwz1tt6b59.png', 'Logo.png', '', NULL, 'acfb0b29a999397d5c9633637229541c'),
(400, '2023-07-05 23:39:13', 'iblock', 666, 1000, 80563, 'image/jpeg', 'iblock/52d', '0flxqwrgnhphph2g23r43bzea0q95u1c.jpg', '1651046632_68-vsegda-pomnim-com-p-deti-otdikhayut-na-more-foto-74.jpg', '', NULL, '53b698908e8748563bdbdcaaa555edbc'),
(401, '2023-07-05 23:39:13', 'iblock', 800, 1200, 103974, 'image/jpeg', 'iblock/ae5', 'b1ifvr2wdfmlpypwv7jto4ejti2tu2ae.jpg', '1651046632_68-vsegda-pomnim-com-p-deti-otdikhayut-na-more-foto-74.jpg', '', NULL, 'bd8fabacab505e4a022235be19abb56e'),
(402, '2023-07-06 00:04:05', 'iblock', 650, 980, 205937, 'image/jpeg', 'iblock/fed', 'lw1lwijcsf0px93o0rz2hyxzklv1oq7t.jpeg', '147447270922.jpeg', '', NULL, '103e4409d96d8c8596bf497169626cbd'),
(403, '2023-07-06 00:04:05', 'iblock', 650, 980, 205937, 'image/jpeg', 'iblock/fed', 'lw1lwijcsf0px93o0rz2hyxzklv1oq7t.jpeg', '147447270922.jpeg', '', NULL, '7f3ec36040cba02261618c2687b337f8'),
(404, '2023-07-06 00:35:40', 'iblock', 664, 1000, 109321, 'image/jpeg', 'iblock/00a', 'u5fsibu8kjlaggby3jycvqk5v9fkfqm9.jpg', '1632972345_49-krasivosti-pro-p-tyuleni-kaspiiskogo-morya-zhivotnie-krasiv-55.jpg', '', NULL, '8032a81db9c017d54b68306811e0361c'),
(405, '2023-07-06 00:35:40', 'iblock', 797, 1200, 205805, 'image/jpeg', 'iblock/842', 'q31d6hmkvbri034pwbf1yegin3xzy49w.jpg', '1632972345_49-krasivosti-pro-p-tyuleni-kaspiiskogo-morya-zhivotnie-krasiv-55.jpg', '', NULL, 'e26a26dc7758d05854122d2a82734461'),
(408, '2024-08-22 15:59:17', 'iblock', 1125, 2000, 368506, 'image/jpeg', 'iblock/ddb', '2mikd1adfolmqn3c4bkxr8r384e244cf.jpg', 'IMG_3069.jpg', '', NULL, '62105558c1cf991173c728353797418e'),
(409, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1918695, 'image/jpeg', 'iblock/421', 'ksw6e3yolgoyyozga4widwqr30plo159.jpg', 'IMG_3061.jpg', '', NULL, 'b527525a413a53a0300da82687e41d21'),
(410, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1863271, 'image/jpeg', 'iblock/ae0', 'cb4mgfgclz1axmejblo5c0uw0qgblr34.jpg', 'IMG_3062.jpg', '', NULL, '3f6ebd48a88a64fd72f0b293c1d4a7ab'),
(411, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1824161, 'image/jpeg', 'iblock/620', 'cz1r6yhts88tmo252ewmvv5inz5nmyd6.jpg', 'IMG_3063.jpg', '', NULL, '74682cd7fca48c0f60635e0ba16f8f6a'),
(412, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1950902, 'image/jpeg', 'iblock/e57', 'xbtlcclrb1cwr3b2g0ka4o7g1nae7dj1.jpg', 'IMG_3064.jpg', '', NULL, '6f72d559bb5a176ac4c764ce8101ef33'),
(413, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1891178, 'image/jpeg', 'iblock/38c', 'hs4h59wy6hv7ks371qlom26yspgfnalo.jpg', 'IMG_3065.jpg', '', NULL, '8b37c9781fc2a5e8e1d3720f515219a9'),
(414, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1765638, 'image/jpeg', 'iblock/9a3', '41d02kuxg0n9ixse8o8cnhgsh0njjk98.jpg', 'IMG_3066.jpg', '', NULL, '1d95d67f5134e8caba4d5894f7f7a40e'),
(415, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1600601, 'image/jpeg', 'iblock/6cc', 'vsrafc4cdtn1m9m1g6p6s90ens08d90g.jpg', 'IMG_3067.jpg', '', NULL, '89a98761e556a123fa30eb593890008a'),
(416, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1766897, 'image/jpeg', 'iblock/256', '3rxgb1x2gftxlyht4ntp2u76y04mssni.jpg', 'IMG_3068.jpg', '', NULL, '62e253d2747168ccbd40205c63a3d523'),
(417, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1798626, 'image/jpeg', 'iblock/192', 'cyikn0pxh6f5793w4vneez42jw7n9szg.jpg', 'IMG_3070.jpg', '', NULL, '82cf4b07a31ba5999551249c4f1b2995'),
(418, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1668465, 'image/jpeg', 'iblock/3e7', 'b1tc20o2a0uku3zyd3ei0i3zhrmcky2z.jpg', 'IMG_3071.jpg', '', NULL, '386d7e95d62eccedd2d9bc83ee856ed5'),
(419, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1573766, 'image/jpeg', 'iblock/c26', 'c9bjlzh227wu3psaft0p7wajx3mj74lu.jpg', 'IMG_3072.jpg', '', NULL, '1ddc2d32cdf243e80943308ce0e00ba2'),
(420, '2024-08-22 15:59:17', 'iblock', 2268, 4032, 1878703, 'image/jpeg', 'iblock/ccf', 'g96vt2ijc194go6f94q6yswmfi1c7dep.jpg', 'IMG_3073.jpg', '', NULL, '644281ff9a21ce7b47232b4b7d453930'),
(421, '2023-07-08 23:46:46', 'iblock', 810, 1440, 564568, 'image/jpeg', 'iblock/cbe', '56d4udpp9z0yit0ph4e1dq04ns3npuvr.jpg', '30258560090011465_cf5f.jpg', '', NULL, '483c57a32797de2b999d5acd192c19d8'),
(422, '2023-07-08 23:46:46', 'iblock', 810, 1440, 564568, 'image/jpeg', 'iblock/cbe', '56d4udpp9z0yit0ph4e1dq04ns3npuvr.jpg', '30258560090011465_cf5f.jpg', '', NULL, '42b9c0b05e8c17cdb04dbe6d3ff37e26'),
(423, '2023-07-11 23:07:22', 'iblock', 562, 1000, 136351, 'image/jpeg', 'iblock/5d3', 'zzmobgh6ghfl25yk25b4rkm3y7fc65tf.jpg', '4d0eb046-d8fd-4a31-8e76-2ce8157b922d.jpg', '', NULL, 'f016fcfc691b1d9c12db6b8bdcb71957'),
(424, '2023-07-11 23:07:22', 'iblock', 899, 1599, 284585, 'image/jpeg', 'iblock/073', '3udigcgtr1gcyeojbkmvvq3v332iaiqx.jpg', '4d0eb046-d8fd-4a31-8e76-2ce8157b922d.jpg', '', NULL, 'e2874b234facc856aa2bbc718146b384'),
(427, '2023-07-11 23:31:08', 'iblock', 1066, 1600, 481118, 'image/jpeg', 'iblock/442', '1i3hiovx3kw93opbad7bcn4jetmfag1m.jpeg', 'cdc6dd8a-a348-430b-80df-ba3fcedcb7ba.jpeg', '', NULL, 'c71c8cfc23b4a0165a07d2171ce7eec4'),
(428, '2023-07-11 23:31:08', 'iblock', 666, 1000, 139713, 'image/jpeg', 'iblock/3c7', 'axjdkmsnqr1ju0w1xx34vhdr2b2s5575.jpeg', 'cdc6dd8a-a348-430b-80df-ba3fcedcb7ba.jpeg', '', NULL, 'ea7fb8e60fa4f516a04ec1122347f439'),
(429, '2023-08-18 00:06:59', 'iblock', 562, 1000, 106591, 'image/jpeg', 'iblock/778', '2k0pm5isoqp0swyje2t8rnie4yqyl8ia.JPG', 'VFUV8081.JPG', '', NULL, '6e565612d70f761b4d68d1ba06ded4fe'),
(430, '2023-08-18 00:06:59', 'iblock', 1125, 2000, 349932, 'image/jpeg', 'iblock/05c', 'vsqvz28qhed52bvrrvoz2xfth4tkhvef.JPG', 'VFUV8081.JPG', '', NULL, '923d6055cc15b338e1b81b3160b156c4'),
(431, '2023-08-23 13:55:33', 'iblock', 393, 700, 79082, 'image/jpeg', 'iblock/59d', '2l8su5j3vu3052qp5rewiqxuciyz1fyf.JPG', 'DMWU7180.JPG', '', NULL, '92c68badab8d274c37bed98da33a0cea'),
(432, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1766897, 'image/jpeg', 'iblock/256', '3rxgb1x2gftxlyht4ntp2u76y04mssni.jpg', 'IMG_3068.jpg', '', NULL, '80efb1fa1a4841be2d21a3d301904189'),
(433, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1985091, 'image/jpeg', 'iblock/a3f', '76h8itlocffipoglq9sf0svagsdtqx4o.jpg', 'IMG_3069.jpg', '', NULL, '84c18875de368415cc374dfc26c589f5'),
(434, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1798626, 'image/jpeg', 'iblock/192', 'cyikn0pxh6f5793w4vneez42jw7n9szg.jpg', 'IMG_3070.jpg', '', NULL, '41508b4a13a6671e504e13c3ec17dd8f'),
(435, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1668465, 'image/jpeg', 'iblock/3e7', 'b1tc20o2a0uku3zyd3ei0i3zhrmcky2z.jpg', 'IMG_3071.jpg', '', NULL, '020f0738a2b2ffedd2c509d5fd39fc1a'),
(436, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1573766, 'image/jpeg', 'iblock/c26', 'c9bjlzh227wu3psaft0p7wajx3mj74lu.jpg', 'IMG_3072.jpg', '', NULL, '8f67d2b75d231213414b5b978b7e9031'),
(437, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1878703, 'image/jpeg', 'iblock/ccf', 'g96vt2ijc194go6f94q6yswmfi1c7dep.jpg', 'IMG_3073.jpg', '', NULL, '7d5a6c114527ad38ba4609fbb151b158'),
(438, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1918695, 'image/jpeg', 'iblock/421', 'ksw6e3yolgoyyozga4widwqr30plo159.jpg', 'IMG_3061.jpg', '', NULL, '7b3d06c47b7ad517b9fcafa6eb1c54ae'),
(439, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1863271, 'image/jpeg', 'iblock/ae0', 'cb4mgfgclz1axmejblo5c0uw0qgblr34.jpg', 'IMG_3062.jpg', '', NULL, '0f987def078bd05690bac2dd3e153f92'),
(440, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1824161, 'image/jpeg', 'iblock/620', 'cz1r6yhts88tmo252ewmvv5inz5nmyd6.jpg', 'IMG_3063.jpg', '', NULL, '99b6e2b0698cb3a8d2fecdb265c372ee'),
(441, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1950902, 'image/jpeg', 'iblock/e57', 'xbtlcclrb1cwr3b2g0ka4o7g1nae7dj1.jpg', 'IMG_3064.jpg', '', NULL, '38c4918557b1c86e16bbbb6c5a9d167f'),
(442, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1891178, 'image/jpeg', 'iblock/38c', 'hs4h59wy6hv7ks371qlom26yspgfnalo.jpg', 'IMG_3065.jpg', '', NULL, '24bbbcddb23c14e2ecc074f1f7e221bb'),
(443, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1765638, 'image/jpeg', 'iblock/9a3', '41d02kuxg0n9ixse8o8cnhgsh0njjk98.jpg', 'IMG_3066.jpg', '', NULL, '4ca94f04db610f69547a56969f86b0b0'),
(444, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1600601, 'image/jpeg', 'iblock/6cc', 'vsrafc4cdtn1m9m1g6p6s90ens08d90g.jpg', 'IMG_3067.jpg', '', NULL, '0bc3059e69a85c26ab38d9d1e9bc198f'),
(445, '2023-08-23 13:55:33', 'iblock', 3024, 4032, 3607365, 'image/jpeg', 'iblock/ac6', 'u52h8nlgugys9b1di7t2y7tt1kjtvgtu.JPG', 'IMG_3582.JPG', '', NULL, '3da9353ed8983ed928229389ffa5ccc7'),
(446, '2023-08-23 13:55:33', 'iblock', 3024, 4032, 2346918, 'image/jpeg', 'iblock/76b', 'dsqipj7bc2gja0lcr5v6wia3z2zx8n78.JPG', 'IMG_3624.JPG', '', NULL, 'd8c0a5f9a7ae83563e92bd01964399e2'),
(447, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 2645262, 'image/jpeg', 'iblock/b6a', '4i899inhzi0u8t7azlhxvvyfdwwffcs5.JPG', 'RKQY3933.JPG', '', NULL, 'e8ddb00ecae5bc30ab2bc88e2405d0e8'),
(448, '2023-08-23 13:55:33', 'iblock', 2268, 4032, 1324924, 'image/jpeg', 'iblock/f49', 'b6efp81wleqbgkxsr5brwwd5rv2s71h0.JPG', 'XWVD7185.JPG', '', NULL, '13c50fee310a8295d0e03c14aacc8724'),
(449, '2023-08-23 13:55:42', 'iblock', 393, 700, 72488, 'image/jpeg', 'iblock/f71', 'bzm5ylv8oyx7wtsd8a9fr11en72rsgqm.JPG', 'TMCX6561.JPG', '', NULL, '491693d8aade37e6c62d73358d9d6b98'),
(450, '2023-08-23 13:55:42', 'iblock', 2268, 4032, 2263907, 'image/jpeg', 'iblock/a94', '9flue1f523qtc1og6gjd9ra5cjayz9sl.JPG', 'HHZD4547.JPG', '', NULL, 'f2b296454399b5d88f1c85f78f0cc560'),
(451, '2023-08-23 13:55:42', 'iblock', 2268, 4032, 2310934, 'image/jpeg', 'iblock/431', '6sf469thcbh082z1szn1yl2vkj69z262.JPG', 'MJGQ6292.JPG', '', NULL, '6d9b0328465118674dae6cd0ea6c3b55'),
(452, '2023-08-23 13:55:42', 'iblock', 2268, 4032, 2365149, 'image/jpeg', 'iblock/10f', 'n2vkw2i9cwft0b1um0osccs0g04ojysl.JPG', 'GWNF9455.JPG', '', NULL, 'fe6ed718873c07e884be6935e8d23e89'),
(453, '2023-08-23 13:55:42', 'iblock', 3024, 4032, 3161828, 'image/jpeg', 'iblock/58f', 'z6j9q6bg05k5wd5dm5goa6sxxotkdcnr.JPG', 'IMG_3583.JPG', '', NULL, '6b882c4dc8b7497b68d5ea67532734d5'),
(454, '2023-08-23 13:55:42', 'iblock', 3024, 4032, 2966813, 'image/jpeg', 'iblock/fa1', 'whq7udvl32oz1q4bxz6rzym9a1rkhx27.JPG', 'IMG_3592.JPG', '', NULL, 'f4be9cfe4eed16f6e97eb7712be711bb'),
(455, '2023-08-23 13:55:42', 'iblock', 2268, 4032, 2689137, 'image/jpeg', 'iblock/196', 'sx5fpoyuecl9itd643y2x8n12joa15yg.JPG', 'IMG_E3586.JPG', '', NULL, '24106dbec88701e690e9db72d4a9dd62'),
(456, '2023-08-23 13:55:51', 'iblock', 393, 700, 465895, 'image/png', 'iblock/7cd', '4o5zd404pleylyta7hhjiim0zlpf5nd2.png', '2023-08-23_13-50-16.png', '', NULL, 'af2d1716ea507e0526307aa86194b51d'),
(457, '2023-08-23 13:55:51', 'iblock', 3024, 4032, 4049593, 'image/jpeg', 'iblock/99c', '5ptnm7fv3m3q1jgbwdx7vmxa1zvvg3mg.JPG', 'IMG_3744.JPG', '', NULL, 'ac081c46d165eaec88beae253cdf2da8'),
(458, '2023-08-23 13:55:51', 'iblock', 1080, 1920, 3446606, 'image/png', 'iblock/279', '2iz2yl7tp5ctr7dz0ejyigv5mezx88z5.png', '2023-08-23_13-50-16.png', '', NULL, 'c482058b344d41e1d3cb87f2a56b8121'),
(459, '2023-08-23 13:56:00', 'iblock', 393, 700, 71037, 'image/jpeg', 'iblock/0c3', 'olyj3qtgcha38cgf38dz25wpi931mcal.JPG', 'XBQE3134.JPG', '', NULL, '4e72e396c47d3f81699122d944e2d07f'),
(460, '2023-08-23 13:56:01', 'iblock', 2268, 4032, 2961849, 'image/jpeg', 'iblock/765', 'ujb5fbovepplmcbp9ai63zcm7xlyrf5o.JPG', 'MJMJ9626.JPG', '', NULL, '9b0be8a066a36accb7293cab58ca10a8'),
(461, '2023-08-23 13:56:01', 'iblock', 2268, 4032, 1796305, 'image/jpeg', 'iblock/71c', 'wp17jkjw1cg6c1i1cs4d4ss614wypaxc.JPG', 'MKXP6227.JPG', '', NULL, '483d30716f7fe9078d7cb356b4c2d9c1'),
(462, '2023-08-23 13:56:01', 'iblock', 3024, 4032, 4087157, 'image/jpeg', 'iblock/808', 'txht1aeozt4qzoszk8j9nj5ktzst0d1f.JPG', 'IMG_3580.JPG', '', NULL, 'c005f709f390942bb0ccc98fbdd7464b'),
(463, '2023-08-23 13:56:01', 'iblock', 3024, 4032, 3294752, 'image/jpeg', 'iblock/32e', 'ykvg3meqbn6ecgrewak1iw0pe1usi6f4.JPG', 'IMG_3593.JPG', '', NULL, '6009f43202cc24cf1526c437c7b8a3e2'),
(464, '2023-08-23 13:56:01', 'iblock', 3024, 4032, 3481903, 'image/jpeg', 'iblock/54c', 'xbdwxa3lzafpzyg26u8t46fq9iagy9m4.JPG', 'IMG_3601.JPG', '', NULL, '409f3055b538a47295d38d418c83d19a'),
(465, '2023-08-23 13:56:01', 'iblock', 2739, 4005, 3334892, 'image/jpeg', 'iblock/a29', '8myf4f6ify4pq9q61wwahenipqujzqmc.JPG', 'NGWN2101.JPG', '', NULL, '7139f064d9c90cb6880990ad3df9702c'),
(466, '2023-08-23 13:56:01', 'iblock', 2268, 4032, 1942577, 'image/jpeg', 'iblock/fd8', 'oo7hhiv5exwmxtk25hbw03wb5fultoa3.JPG', 'XSDJ5760.JPG', '', NULL, 'ab86f7069b1516c6688c3321b8a5d3ba'),
(467, '2023-08-23 13:56:01', 'iblock', 2268, 4032, 2145787, 'image/jpeg', 'iblock/a75', '1oprgdlrzq0m7s6bohxblvms9mm7ricq.JPG', 'XBQE3134.JPG', '', NULL, '4381b39a6bc12f2f9cfff1fc210588e7'),
(468, '2023-08-23 13:55:51', 'iblock', 2268, 4032, 1842105, 'image/jpeg', 'iblock/7ed', 'n0il2p5jxf5jcugbk82zd1u2g0cvo5d0.JPG', 'VAQL7792.JPG', '', NULL, 'd041643c36f059ed66a0e0b036428348'),
(469, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1918695, 'image/jpeg', 'iblock/421', 'ksw6e3yolgoyyozga4widwqr30plo159.jpg', 'IMG_3061.jpg', '', NULL, '1ee5940aa48acf74a58d2573e8f3f934'),
(470, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1863271, 'image/jpeg', 'iblock/ae0', 'cb4mgfgclz1axmejblo5c0uw0qgblr34.jpg', 'IMG_3062.jpg', '', NULL, '0775378ceead2a67690f504f4eaa2254'),
(471, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1824161, 'image/jpeg', 'iblock/620', 'cz1r6yhts88tmo252ewmvv5inz5nmyd6.jpg', 'IMG_3063.jpg', '', NULL, '622812fdcae6165ee91067a59d4d1705'),
(472, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1950902, 'image/jpeg', 'iblock/e57', 'xbtlcclrb1cwr3b2g0ka4o7g1nae7dj1.jpg', 'IMG_3064.jpg', '', NULL, 'ff00d532a70e7165e0a97e4427e2d1b6'),
(473, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1891178, 'image/jpeg', 'iblock/38c', 'hs4h59wy6hv7ks371qlom26yspgfnalo.jpg', 'IMG_3065.jpg', '', NULL, 'c90133bac7a00da65612487f1104cb4d'),
(474, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1765638, 'image/jpeg', 'iblock/9a3', '41d02kuxg0n9ixse8o8cnhgsh0njjk98.jpg', 'IMG_3066.jpg', '', NULL, '3a25c0ceb136e9e61196ac765ca049c4'),
(475, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1600601, 'image/jpeg', 'iblock/6cc', 'vsrafc4cdtn1m9m1g6p6s90ens08d90g.jpg', 'IMG_3067.jpg', '', NULL, '5def6c00f3d7cfe168c6e80c7d69db0e'),
(476, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1766897, 'image/jpeg', 'iblock/256', '3rxgb1x2gftxlyht4ntp2u76y04mssni.jpg', 'IMG_3068.jpg', '', NULL, '1fc477728703ba69548f34d8b7ec8cd6'),
(477, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1985091, 'image/jpeg', 'iblock/a3f', '76h8itlocffipoglq9sf0svagsdtqx4o.jpg', 'IMG_3069.jpg', '', NULL, 'c3012d46c64f1f191349a451edf25ad6'),
(478, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1798626, 'image/jpeg', 'iblock/192', 'cyikn0pxh6f5793w4vneez42jw7n9szg.jpg', 'IMG_3070.jpg', '', NULL, '394d16b07e0a630be09772fcd317d25f'),
(479, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1668465, 'image/jpeg', 'iblock/3e7', 'b1tc20o2a0uku3zyd3ei0i3zhrmcky2z.jpg', 'IMG_3071.jpg', '', NULL, '34a0963e1ee212249595aea71dfb1388'),
(480, '2023-08-28 01:32:14', 'iblock', 2268, 4032, 1573766, 'image/jpeg', 'iblock/c26', 'c9bjlzh227wu3psaft0p7wajx3mj74lu.jpg', 'IMG_3072.jpg', '', NULL, '34cc5f5463fb59c7b4d4833e3e0290fa'),
(481, '2023-08-28 01:32:15', 'iblock', 2268, 4032, 1878703, 'image/jpeg', 'iblock/ccf', 'g96vt2ijc194go6f94q6yswmfi1c7dep.jpg', 'IMG_3073.jpg', '', NULL, 'ba4ab633c4616eb6a07d7f8755aabe7e'),
(482, '2023-08-28 01:48:26', '', 0, 0, 5564, 'image/svg+xml', 'CAllcorp3Resort/209', 'sli3ur72jihkkulbicmm70qc1g2cnw2b.svg', 'logo_gk.svg', '', NULL, '2e94d97a8c11bebc90a501956a5c9bcd'),
(485, '2023-08-28 01:50:45', '', 0, 0, 5564, 'image/svg+xml', 'CAllcorp3Resort/155', 'qu3cgwpiaglm6sm2a7ucaqlzl5wxiwj3.svg', 'logo_gk_fff.svg', '', NULL, '6bfb2cb2eb0e4641786f0894b3db3359'),
(488, '2023-08-28 01:55:30', '', 16, 16, 398, 'image/png', 'CAllcorp3Resort/4c2', 'f9x8mnv6oirx8sqzn3wmx13c12e3tshm.png', 'favicon-16x16.png', '', NULL, '09442d5cbb2fef2ce398d65275b58bb1'),
(491, '2024-08-22 20:26:51', 'iblock', 576, 1024, 197112, 'image/jpeg', 'iblock/881', 'tj2cmi3f6cci5zbsw3n563vhoo5kotsd.jpeg', '02ab7da446866184f3df1e491f.jpeg', '', NULL, 'e58eaba7ad504bfa4c477aca62843b23'),
(492, '2023-08-28 11:44:56', 'iblock', 465, 700, 578174, 'image/webp', 'iblock/f94', 'fls4o5moumlv7g35dx2typ2riyqeaegh.webp', '55f8f360842941cd93e593cb59262ff6.webp', '', NULL, '4e1333169a0bdb9bcfd5d1deffc0cef4'),
(493, '2023-08-28 12:13:21', 'iblock', 393, 700, 57094, 'image/jpeg', 'iblock/9ce', 'xtzjr1c7t2ynt4u8n1wm6lb2l3hr6lcj.JPG', 'VFUV8081.JPG', '', NULL, '9f158f2dfe8217dd4f01eaba41833447'),
(494, '2023-08-28 12:13:21', 'iblock', 1125, 2000, 349932, 'image/jpeg', 'iblock/05c', 'vsqvz28qhed52bvrrvoz2xfth4tkhvef.JPG', 'VFUV8081.JPG', '', NULL, '008a18ce035e50a90f8583ecd15842a4'),
(495, '2023-08-28 12:13:21', 'iblock', 2268, 4032, 2217535, 'image/jpeg', 'iblock/863', 'v3kaqfxgzqvq2n42913bh8le0wblkpn3.JPG', 'TMCX6561.JPG', '', NULL, '945dd3d05e98dfe8a7093c440d5c709f'),
(496, '2023-08-28 12:13:21', 'iblock', 2268, 4032, 2374654, 'image/jpeg', 'iblock/7d7', 'q9wbaqw1zy27vi6movyorttuql7c9aqm.JPG', 'TNOH0766.JPG', '', NULL, 'b49f48d778e8e1760b3514390d94e44a'),
(497, '2023-08-28 12:13:21', 'iblock', 2268, 4032, 2342547, 'image/jpeg', 'iblock/d86', '77t232dk3wzova3g2muat2nkfbe6m4wm.JPG', 'IMG_E3592.JPG', '', NULL, 'fa9a1a8b2ca470311395bbc0e2cbc54e'),
(498, '2023-08-28 11:55:02', 'iblock', 393, 700, 60800, 'image/jpeg', 'iblock/9cb', '4bn1jh9wnr8b7je3v3ys6axzf3fkn917.JPG', 'XBQE3134.JPG', '', NULL, '9e03a9705771a30bd10ecb38a4256241'),
(499, '2023-08-28 11:55:02', 'iblock', 1125, 2000, 395866, 'image/jpeg', 'iblock/f05', 'pjefzy77eghrk7w9sz3mi2bloc1hs8yq.JPG', 'XBQE3134.JPG', '', NULL, 'a89b67416eb685adf3db3b5c6bef4364'),
(500, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 2365149, 'image/jpeg', 'iblock/10f', 'n2vkw2i9cwft0b1um0osccs0g04ojysl.JPG', 'GWNF9455.JPG', '', NULL, '24b2846f4029f1b42b2fc3d141c96e31'),
(501, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 2961849, 'image/jpeg', 'iblock/765', 'ujb5fbovepplmcbp9ai63zcm7xlyrf5o.JPG', 'MJMJ9626.JPG', '', NULL, 'f13ff206a6dbdff8b8f8ba8a8ba9742d'),
(502, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 2310934, 'image/jpeg', 'iblock/431', '6sf469thcbh082z1szn1yl2vkj69z262.JPG', 'MJGQ6292.JPG', '', NULL, '77d2da7bd9bdbc97e58f77bb7f2b2913'),
(503, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 2317677, 'image/jpeg', 'iblock/5bf', '1wis5ez5z9idybrjd3697vlon88hfjjc.JPG', 'XKVU9225.JPG', '', NULL, '78a78673813129dda027e383d8a539ea'),
(504, '2023-08-28 11:55:02', 'iblock', 3024, 4032, 4087157, 'image/jpeg', 'iblock/808', 'txht1aeozt4qzoszk8j9nj5ktzst0d1f.JPG', 'IMG_3580.JPG', '', NULL, 'ddd086ca9e849bc19c9e26f01493c72a'),
(505, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 1791289, 'image/jpeg', 'iblock/09d', 'bfbp4neoc4coah8pelssci3ye7h5i6cu.JPG', 'CEZS0714.JPG', '', NULL, '416fcdffb43b806893e4f5fc2be17751'),
(506, '2023-08-28 11:55:02', 'iblock', 2268, 4032, 3011078, 'image/jpeg', 'iblock/709', 'f01u1b1w0gdtqwxex4is5hti6uhz5vye.JPG', 'FJAO4599.JPG', '', NULL, 'cddbf61e79226317afa15ea1c615c562'),
(507, '2023-08-28 13:57:37', 'iblock', 408, 700, 570163, 'image/png', 'iblock/4cf', '52alqdmwe25joubm3zny0d0ovwk4gebg.png', 'image (9).png', '', NULL, '4b62b98f5e7ca05724a3f479bcbd6814'),
(508, '2023-08-28 13:57:37', 'iblock', 700, 1200, 958427, 'image/png', 'iblock/16c', 'xs3styrxhc5eq0u93dkyzxsftia24muc.png', 'image (9).png', '', NULL, '33f471b9c8999516e7d51739d9832543'),
(509, '2024-06-20 14:16:01', 'iblock', 562, 1000, 105505, 'image/jpeg', 'iblock/cb5', 'twdgljhs434wy00ffjgj4m2ouwoqa2oe.jpg', 'IMG_3061.jpg', '', NULL, '2108f042f6ebc915d1bd19691a69e901'),
(510, '2023-09-04 14:51:20', 'iblock', 667, 1000, 77501, 'image/jpeg', 'iblock/9ec', '635afs8zcbx9tc377g1w0ulzuxostyku.jpg', 'logo_off.jpg', '', NULL, 'bca6505119878bc1677cdda4a6402b47'),
(511, '2023-09-04 14:51:20', 'iblock', 667, 1000, 77501, 'image/jpeg', 'iblock/9ec', '635afs8zcbx9tc377g1w0ulzuxostyku.jpg', 'logo_off.jpg', '', NULL, 'e5d807464260f3277f2e98fb29d9d440'),
(514, '2024-08-22 14:31:53', 'iblock', 562, 1000, 646421, 'image/png', 'iblock/4fd', 'e7q7gvcyumbq6onlus0bjnqxdof2ei70.png', '2024-04-23_19-05-33.png', '', NULL, '75fb7ff935208caa19a098b7326a82a2'),
(515, '2024-08-22 14:31:53', 'iblock', 1080, 1920, 2012614, 'image/png', 'iblock/0b2', 'wq1q7m9edr9dhhgparssi3xtalc6ismq.png', '2024-04-23_19-05-33.png', '', NULL, 'c9632cfb84afe71c9d9c0b68cfc53217'),
(516, '2024-08-22 14:31:53', 'iblock', 3024, 4032, 3471608, 'image/jpeg', 'iblock/baa', '890d8az67i74utqf4e2o7u1hbsej9zqs.JPG', 'IMG_3581.JPG', '', NULL, 'df7fb4b0be14ebd3b74c455de4a902d1'),
(517, '2024-08-22 14:31:53', 'iblock', 1080, 1920, 1945045, 'image/png', 'iblock/c4c', '0dy24hj5sa3o33yuk6zpchz1gcp9a7i1.png', '2024-06-20_13-51-03.png', '', NULL, '22e42e550a288f360fb545a50bea9521'),
(518, '2024-08-22 14:31:53', 'iblock', 1080, 1920, 1912049, 'image/png', 'iblock/e05', 'a5jbm518uobt8izlnwwehjej2lade1re.png', '2024-06-20_13-53-29.png', '', NULL, 'c7418f16797b0a2c8421d3a10049b6e4'),
(519, '2024-08-22 14:31:53', 'iblock', 1080, 1920, 2338207, 'image/png', 'iblock/58c', 'rhhwi2xdhx3vw6482c997mkaql06y7ed.png', '2024-06-20_13-53-51.png', '', NULL, 'ed8906bbfb458f7067bd5af07ffe98ab'),
(520, '2024-06-20 13:54:35', 'iblock', 1080, 1920, 1945045, 'image/png', 'iblock/c4c', '0dy24hj5sa3o33yuk6zpchz1gcp9a7i1.png', '2024-06-20_13-51-03.png', '', NULL, 'b9c30c003f1aea7a4ab470a3a519799e'),
(521, '2024-06-20 13:55:20', 'iblock', 1080, 1920, 1912049, 'image/png', 'iblock/e05', 'a5jbm518uobt8izlnwwehjej2lade1re.png', '2024-06-20_13-53-29.png', '', NULL, '441b08f2cc882c527d1513164f06eae2'),
(522, '2024-06-20 13:55:20', 'iblock', 1080, 1920, 2338207, 'image/png', 'iblock/58c', 'rhhwi2xdhx3vw6482c997mkaql06y7ed.png', '2024-06-20_13-53-51.png', '', NULL, 'f6d36087c29c4476f64f9f3ca308cc39'),
(523, '2024-08-22 15:59:29', 'iblock', 562, 1000, 161193, 'image/jpeg', 'iblock/b08', '917nnzmchofxzsdcsrqc9v1up9fzmixr.jpg', 'IMG_6540.jpg', '', NULL, 'cb4d3bbb6eaf849d99e8ea5363759759'),
(524, '2024-08-22 15:59:29', 'iblock', 1125, 2000, 573029, 'image/jpeg', 'iblock/066', 'er7kqpmce6ylj0cht3oqyh2680nkt84p.jpg', 'IMG_6540.jpg', '', NULL, '73020fe63c1e32f3d029552db56607f3'),
(525, '2024-08-22 15:59:29', 'iblock', 2268, 4032, 2234813, 'image/jpeg', 'iblock/4c4', '5kowmcexr0i8y8xjcvp1z1ngyesoznhk.jpg', 'IMG_6544.jpg', '', NULL, '134cf27449f759d6206637c50db4789c'),
(526, '2024-08-22 15:59:29', 'iblock', 2268, 4032, 2064705, 'image/jpeg', 'iblock/733', 's0auwa1lfoxog0fbyv3hyvssqcmwocvr.jpg', 'IMG_6545.jpg', '', NULL, '7191e6ea01e58be5897d649da1742d8e'),
(527, '2024-08-22 15:59:29', 'iblock', 2268, 4032, 2187370, 'image/jpeg', 'iblock/a60', 'say9dsiv6cznpat78itrvyho05ct2j7e.jpg', 'IMG_6542.jpg', '', NULL, 'acadb6e5ccdedc91bc0b8fb162a033a0'),
(528, '2024-08-22 15:59:29', 'iblock', 2226, 3958, 2048339, 'image/jpeg', 'iblock/d75', '4jb1d4rsxvi6blmjt65d4aiq1lnkncvf.jpg', 'IMG_6543.jpg', '', NULL, 'd57a34c6ff4bc8ea30db27b08a070e1e'),
(529, '2024-08-22 15:59:29', 'iblock', 4032, 2268, 2140934, 'image/jpeg', 'iblock/233', 'ufj3h3of3fc90etoe6w39xczjzi723eo.jpg', 'IMG_6550.jpg', '', NULL, '821d02fd3b690a11c9e434b4f036b370'),
(530, '2024-08-22 15:59:29', 'iblock', 4032, 2268, 2102338, 'image/jpeg', 'iblock/9e9', 'xzrcanp1jwugy67foq5cxknkq4zlpvpv.jpg', 'IMG_6551.jpg', '', NULL, '8f80523784d4aa9b981e4892148cb591'),
(531, '2024-08-22 15:59:29', 'iblock', 2268, 4032, 1878320, 'image/jpeg', 'iblock/fe7', 'anz77pjqo1acztqhlx087x53c7lk56b7.jpg', 'IMG_6554.jpg', '', NULL, '14b15cd79073305d549606da07fb7605'),
(532, '2024-08-22 15:59:29', 'iblock', 4032, 2268, 2080471, 'image/jpeg', 'iblock/545', '0nuw8jg88af0vsgid7gg1flviryzzrx5.jpg', 'IMG_6553.jpg', '', NULL, '1d10e13cd69203e4e6bb883b07b5f8a6'),
(533, '2024-08-22 15:59:29', 'iblock', 4032, 2268, 2094724, 'image/jpeg', 'iblock/56f', '69dvnpki2yg52psyi2sg5hlko3pgrgom.jpg', 'IMG_6548.jpg', '', NULL, 'a7712054dd511555da30f573bbde5aec'),
(534, '2024-08-22 14:32:06', 'iblock', 562, 1000, 103376, 'image/jpeg', 'iblock/208', '9kob838bbiryrvbzkfoxvr9pj5e88dw6.jpg', 'IMG_7196.jpg', '', NULL, '4ff0e76151baf7dbf84afe8421c794ce'),
(535, '2024-08-22 14:32:06', 'iblock', 1125, 2000, 360482, 'image/jpeg', 'iblock/fff', 'bklgf961tjzgpz23wocksfr0swpxjosu.jpg', 'IMG_7196.jpg', '', NULL, '3eee97204a6b4ae271b48566550f5af9'),
(536, '2024-08-22 14:32:06', 'iblock', 1080, 1920, 1057077, 'image/png', 'iblock/8db', '2sn7ne6fghkgwqkzae7fsjisq6hxawv0.png', '2024-08-20_17-51-53.png', '', NULL, 'bd907dd2f33edbf085485cb726257bba'),
(537, '2024-08-22 14:32:06', 'iblock', 1080, 1920, 1473164, 'image/png', 'iblock/7d5', 'optdxbfh9cp6j54thspn6sm0qbz2warj.png', '2024-08-20_17-52-12.png', '', NULL, 'a7ecefdbda1a82d42d5a4769225b0cdb'),
(538, '2024-08-22 14:32:06', 'iblock', 1080, 1920, 1196691, 'image/png', 'iblock/040', 'xxuzs805dsusci1xfgsum8ap85v8dryb.png', '2024-08-20_17-56-07.png', '', NULL, '8a8774b662f56f50247b957c411e8e7b'),
(539, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2053646, 'image/jpeg', 'iblock/19a', 'wxphfqdejm3a3jh3sl4h66kiz3ya6mx5.jpg', 'IMG_7191.jpg', '', NULL, '582decb55de90ae092e172eb9ff57d4a'),
(540, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2098581, 'image/jpeg', 'iblock/a8d', 'nrjucybinaerolf3q0974ysz2x0vb839.jpg', 'IMG_7192.jpg', '', NULL, 'fdc02dc1b2aa409092f1f99bbac9f081'),
(541, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2168647, 'image/jpeg', 'iblock/d25', 'jvwtufw8c83zj5be204u61n0gus7xia9.jpg', 'IMG_7193.jpg', '', NULL, '3fd3afe7430af60871bd278df788678a'),
(542, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2032832, 'image/jpeg', 'iblock/17a', 'k2q9ezfe6jcsemslybbgg74bfpvmb7uc.jpg', 'IMG_7194.jpg', '', NULL, '7074465209e3596a43d59c24177eda12'),
(543, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2080649, 'image/jpeg', 'iblock/242', 'fglwoj0vvln1ufpzehui94rwwsyru2gy.jpg', 'IMG_7195.jpg', '', NULL, 'ddbb997dce210a8fd02d4a3e677a94ec'),
(544, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 2011517, 'image/jpeg', 'iblock/483', 'n03dpnd359b4zos1eoz0kg2qjp1g98nj.jpg', 'IMG_7197.jpg', '', NULL, '55255ebe5e93520af880c2383dd8704f'),
(545, '2024-08-22 14:32:06', 'iblock', 2268, 4032, 1744690, 'image/jpeg', 'iblock/de9', 'vtwv9f4xigyozcmm3rygqjapd3ufbo0q.jpg', 'IMG_7198.jpg', '', NULL, '850d1130e4ce11eff30c68ae5a66760f'),
(546, '2024-08-22 14:32:06', 'iblock', 1080, 1920, 1711414, 'image/png', 'iblock/e70', '3p0lcqc1lqob4h104a0jblss5irh87be.png', '2024-08-20_17-51-01.png', '', NULL, '897da8466efc02864b3ba14902be7854'),
(547, '2024-08-20 19:09:41', 'iblock', 1080, 1920, 1711414, 'image/png', 'iblock/e70', '3p0lcqc1lqob4h104a0jblss5irh87be.png', '2024-08-20_17-51-01.png', '', NULL, '64e447464862b51982a05974f24069f1'),
(548, '2024-08-20 19:09:41', 'iblock', 1080, 1920, 1057077, 'image/png', 'iblock/8db', '2sn7ne6fghkgwqkzae7fsjisq6hxawv0.png', '2024-08-20_17-51-53.png', '', NULL, '587f7d6429ce622ec921863c2b1126a0'),
(549, '2024-08-20 19:09:41', 'iblock', 1080, 1920, 1473164, 'image/png', 'iblock/7d5', 'optdxbfh9cp6j54thspn6sm0qbz2warj.png', '2024-08-20_17-52-12.png', '', NULL, '0461298c6316cacf2158704980e01298'),
(550, '2024-08-20 19:09:41', 'iblock', 1080, 1920, 1196691, 'image/png', 'iblock/040', 'xxuzs805dsusci1xfgsum8ap85v8dryb.png', '2024-08-20_17-56-07.png', '', NULL, '9e8c6008096846939c2603e4ab8f3ae4'),
(551, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2053646, 'image/jpeg', 'iblock/19a', 'wxphfqdejm3a3jh3sl4h66kiz3ya6mx5.jpg', 'IMG_7191.jpg', '', NULL, 'a7c27899aea76dde53dc97c36b8f9ecf'),
(552, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2098581, 'image/jpeg', 'iblock/a8d', 'nrjucybinaerolf3q0974ysz2x0vb839.jpg', 'IMG_7192.jpg', '', NULL, 'd271cba7ec056adb7f255f8d314a3abd'),
(553, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2168647, 'image/jpeg', 'iblock/d25', 'jvwtufw8c83zj5be204u61n0gus7xia9.jpg', 'IMG_7193.jpg', '', NULL, 'e13310fea705ccd4259793a867de3d33'),
(554, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2032832, 'image/jpeg', 'iblock/17a', 'k2q9ezfe6jcsemslybbgg74bfpvmb7uc.jpg', 'IMG_7194.jpg', '', NULL, '7d231913e2161ecd9ab3f376db3e9ea9'),
(555, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2080649, 'image/jpeg', 'iblock/242', 'fglwoj0vvln1ufpzehui94rwwsyru2gy.jpg', 'IMG_7195.jpg', '', NULL, 'b55901ba5f92e9e0513ad15145c07a1f'),
(556, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 2011517, 'image/jpeg', 'iblock/483', 'n03dpnd359b4zos1eoz0kg2qjp1g98nj.jpg', 'IMG_7197.jpg', '', NULL, '879d77a3b414dc2a0c04f9671c12fd23'),
(557, '2024-08-20 19:09:41', 'iblock', 2268, 4032, 1744690, 'image/jpeg', 'iblock/de9', 'vtwv9f4xigyozcmm3rygqjapd3ufbo0q.jpg', 'IMG_7198.jpg', '', NULL, '29134bd1b8c60a9b0f9062e77f1f3020'),
(558, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 4462326, 'image/jpeg', 'iblock/c4a', 'ls2ztw21f396tcw9vgvtw17iargou4ra.JPG', 'IMG_9934.JPG', '', NULL, 'cd8be560264f94f87f7217655d19df1a'),
(559, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5357496, 'image/jpeg', 'iblock/a77', 'dd2w4hcsj8julk3l22gzpyft9qkmohf3.JPG', 'IMG_9937.JPG', '', NULL, '87b81e900fdfa8ab267bf3144cbf1f29'),
(560, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5078046, 'image/jpeg', 'iblock/14f', '445qq1rizzzv2trnigid47twwfan3vw7.JPG', 'IMG_9938.JPG', '', NULL, '73882582a98871909369ab4bc28ea65a'),
(561, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 6333149, 'image/jpeg', 'iblock/e50', 'q10s4jlee7ne2wisl0krc7izm95f9vu9.JPG', 'IMG_9942.JPG', '', NULL, '21a56b126be45883beaa6c37a026f8e6'),
(562, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 6711403, 'image/jpeg', 'iblock/df5', '1rjmh1p3p9gjasnhrl1r71krcyn2bngx.JPG', 'IMG_9943.JPG', '', NULL, 'd3053bd95a0ced010ca4b4788ae35f09'),
(563, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5579063, 'image/jpeg', 'iblock/990', 'nmjsdtjs9tqvqefhamajq3gr5klocm7h.JPG', 'IMG_9958.JPG', '', NULL, '72e26d027393773c44740a2f58c56633'),
(564, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5106259, 'image/jpeg', 'iblock/55f', 'rlwsohzhwtioic8ywguxoxiry7wkf2yg.JPG', 'IMG_9961.JPG', '', NULL, 'f32a7f7efd9092bfd0bd5022a393214a'),
(565, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 6377975, 'image/jpeg', 'iblock/a60', '2o8s038mzu120r0sq3cvmscau5aamys2.JPG', 'IMG_9962.JPG', '', NULL, '466992a93fd4dd2c92589e4cb365c55c'),
(566, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 6407033, 'image/jpeg', 'iblock/fdc', 'yaotm4x4myin0eg5036v1l1vm936xjc5.JPG', 'IMG_9966.JPG', '', NULL, '07e80fb09a79071d074c312c25d4d5d9'),
(567, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 4299996, 'image/jpeg', 'iblock/0b9', '5qbl1z6jm9l043dd9e04602n4fq9v33o.JPG', 'IMG_9977.JPG', '', NULL, '61d2c9b3e3954da75ac7006530c010fa'),
(568, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5191995, 'image/jpeg', 'iblock/862', 'vbpu6pzypfa16l0pxkjs38axalr4n2uy.JPG', 'IMG_9978.JPG', '', NULL, 'd8e0ea27567eaf45a99d4875f855d01b'),
(569, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5491294, 'image/jpeg', 'iblock/d81', '9e5isyandl7up741fg2tjtvakguz8rv7.JPG', 'IMG_9986.JPG', '', NULL, '6f85114286c0744348def176caa99cdb'),
(570, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5594432, 'image/jpeg', 'iblock/c86', 'sh4qhxr8xbj1epq2yllkeyl90sqhu4g0.JPG', 'IMG_9997.JPG', '', NULL, 'ba8409aae22bee946fcb114f15515d17'),
(571, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 6173902, 'image/jpeg', 'iblock/c50', 'i9o59jb3lzh2nmneqbrvf1oim1e56iyg.JPG', 'IMG_9996.JPG', '', NULL, 'ae9acaa633a900924748ce1d25a7f00a'),
(572, '2024-08-21 23:09:13', 'iblock', 3648, 5472, 5687070, 'image/jpeg', 'iblock/b52', 'renkleaevb73cptpo4y25s18cetibqf2.JPG', 'IMG_9998.JPG', '', NULL, '464c0372941ddae6e65e9b79b2795909'),
(573, '2024-08-21 23:16:53', 'iblock', 466, 700, 58753, 'image/jpeg', 'iblock/8d7', 'ik815053apy8z3xfi20kgkbzl3fruw71.JPG', 'IMG_9998.JPG', '', NULL, 'c630f697a2a874fb8d72ed7733954537'),
(574, '2024-08-21 23:16:53', 'iblock', 1333, 2000, 247681, 'image/jpeg', 'iblock/bf7', 'qyip0vxc1cyi0rjbxl26nib0ub9egsfj.JPG', 'IMG_9934.JPG', '', NULL, '8cd7737282659ed0a54b12a96cdafbd6'),
(575, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5687070, 'image/jpeg', 'iblock/b52', 'renkleaevb73cptpo4y25s18cetibqf2.JPG', 'IMG_9998.JPG', '', NULL, '502ea1654d789aabb2e8a841abf5aef8'),
(576, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5357496, 'image/jpeg', 'iblock/a77', 'dd2w4hcsj8julk3l22gzpyft9qkmohf3.JPG', 'IMG_9937.JPG', '', NULL, '7b2aaa729f075d995e20a184923ace43'),
(577, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5078046, 'image/jpeg', 'iblock/14f', '445qq1rizzzv2trnigid47twwfan3vw7.JPG', 'IMG_9938.JPG', '', NULL, 'd07f8bd593eb5946bb19487dec935d06'),
(578, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5716029, 'image/jpeg', 'iblock/751', 'sw4f5l9fjdaa57mzebzzvdle3fmlwxcn.JPG', 'IMG_9939.JPG', '', NULL, 'e983b188c6aabf1ff589055862941f94'),
(579, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 6711403, 'image/jpeg', 'iblock/df5', '1rjmh1p3p9gjasnhrl1r71krcyn2bngx.JPG', 'IMG_9943.JPG', '', NULL, '5b88dff15fa41efc7193c3673bf69126'),
(580, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5171666, 'image/jpeg', 'iblock/b9c', '3bq0drxvbw3iybswfjqahi2pxgld1bk3.JPG', 'IMG_9949.JPG', '', NULL, '109fdc2d8087ed9ecdf333bfbdabaa8c'),
(581, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5579063, 'image/jpeg', 'iblock/990', 'nmjsdtjs9tqvqefhamajq3gr5klocm7h.JPG', 'IMG_9958.JPG', '', NULL, '11d1c1709d29ed2d3657834e2a369e84'),
(582, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5106259, 'image/jpeg', 'iblock/55f', 'rlwsohzhwtioic8ywguxoxiry7wkf2yg.JPG', 'IMG_9961.JPG', '', NULL, 'ae09bdcd1c8b80f75299e9a335b0ca8d'),
(583, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 6377975, 'image/jpeg', 'iblock/a60', '2o8s038mzu120r0sq3cvmscau5aamys2.JPG', 'IMG_9962.JPG', '', NULL, '05aa55430058b678440850a4720cf38f'),
(584, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 4299996, 'image/jpeg', 'iblock/0b9', '5qbl1z6jm9l043dd9e04602n4fq9v33o.JPG', 'IMG_9977.JPG', '', NULL, '352c18c78e557b51e84491c613f6fd03'),
(585, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5191995, 'image/jpeg', 'iblock/862', 'vbpu6pzypfa16l0pxkjs38axalr4n2uy.JPG', 'IMG_9978.JPG', '', NULL, '34bc4d27c27972941488e048f5b90708'),
(586, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5786632, 'image/jpeg', 'iblock/fea', '24nyfj82dy4g1o3qchhzsfq7p834bdue.JPG', 'IMG_9983.JPG', '', NULL, '019f519ea5be2cc5bb1ca303b9eca439'),
(587, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5491294, 'image/jpeg', 'iblock/d81', '9e5isyandl7up741fg2tjtvakguz8rv7.JPG', 'IMG_9986.JPG', '', NULL, '54c1667f883494dd21e1bdb6054d3a5f'),
(588, '2024-08-21 23:16:53', 'iblock', 3648, 5472, 5594432, 'image/jpeg', 'iblock/c86', 'sh4qhxr8xbj1epq2yllkeyl90sqhu4g0.JPG', 'IMG_9997.JPG', '', NULL, 'a3f52278d302af0441db49fd2fe3dde0'),
(589, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2093484, 'image/jpeg', 'iblock/ee3', '77z7x2w19ucptiloao8m66yhijkeidnq.jpg', 'IMG_6998.jpg', '', NULL, 'fdfa44ba9e56475851e3e0a5d91e0e46'),
(590, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2089197, 'image/jpeg', 'iblock/eab', 'tgqenp49emjgn49998x0v8puvoavzz4q.jpg', 'IMG_6999.jpg', '', NULL, '267d6902b868ac69edfd9c5865194a0a'),
(591, '2024-08-22 14:14:46', 'iblock', 4032, 2268, 2235726, 'image/jpeg', 'iblock/df4', '9sf1v4so82nuzzuy3kz97ueqpbp5xum6.jpg', 'IMG_7004.jpg', '', NULL, '1c2eaf6c1ab66d7d5f995e86fae9f43a'),
(592, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2329422, 'image/jpeg', 'iblock/372', 'pqwjpc8lcbmi26jzpp736ttwrv3ccoq5.jpg', 'IMG_7003.jpg', '', NULL, '17e75b9d3e9b34496af6dc942cc3c934'),
(593, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 1757202, 'image/jpeg', 'iblock/639', 'pihq72hwfj76ihpw460wyq39wff9tfql.jpg', 'IMG_7008.jpg', '', NULL, 'cb8a305430512ae8101183a1c70be3cd'),
(594, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2017453, 'image/jpeg', 'iblock/02e', 'z21w2x68h200dyv5lrgzhzlvpxeobf83.jpg', 'IMG_7005.jpg', '', NULL, 'cbeea7a280275f2b142afbab11a8fb37'),
(595, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 1836876, 'image/jpeg', 'iblock/ba5', '5i3blqb7b3j84xx02ntk7momwwso900h.jpg', 'IMG_7006.jpg', '', NULL, '6940849d5748bdca92cee6c0998f601f'),
(596, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2279208, 'image/jpeg', 'iblock/516', '1utdurm33slal5qhji79m9y9kq013ajq.jpg', 'IMG_7012.jpg', '', NULL, '5f7a8cb6da92ed897ba83d1613c99d16'),
(597, '2024-08-22 14:14:46', 'iblock', 2268, 4032, 2325724, 'image/jpeg', 'iblock/b65', '48ja495n2fs2fw0beevjaofdqp9pbmq9.jpg', 'IMG_7030.jpg', '', NULL, '8fb9916b1c98ba132903ccad4c54c620'),
(598, '2024-08-22 14:14:46', 'iblock', 4032, 2268, 1945881, 'image/jpeg', 'iblock/124', 'bdm4nyp15f7d3fixkwvxrsspal0nb4l1.jpg', 'IMG_7032.jpg', '', NULL, 'c76b987a5a82c311c4cd9f7a2a0cb510'),
(599, '2024-08-22 14:14:46', 'iblock', 525, 700, 82005, 'image/jpeg', 'iblock/f62', 'etmwts1imtonk5isrvprpnjntm8aeucf.jpg', 'IMG_1993.jpg', '', NULL, 'f5672c1f0a8ff11645c26295100b844d'),
(600, '2024-08-22 14:14:46', 'iblock', 1500, 2000, 572719, 'image/jpeg', 'iblock/17b', 'sugtgaayv72a4byn2503ewy6wlyly43x.jpg', 'IMG_1993.jpg', '', NULL, 'aa71835c2e1753c57a93623de52ad5a9'),
(602, '2024-08-22 14:15:19', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/2c4', '60a1aie072vcaxd96j8yh1jkp54vmux8', '98frp1i9xQX5ZXYv5URqU3JPkrLuHVr2', '', NULL, 'fac067340eed672429acce553b0b3b9d'),
(604, '2024-08-22 14:19:25', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/901', '3illrv4ypyej9l3kzrug2t4erplu17uj', 'Uz04mYMbvSXYz8Ae5cZoLgljNmaWgovU', '', NULL, 'd7e358e84284921cb594b68bf618698e'),
(606, '2024-08-22 14:20:06', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/ba2', 'cl9cvoa6urcm6vx0dk5vvnls8d4cg6mt', '98frp1i9xQX5ZXYv5URqU3JPkrLuHVr2', '', NULL, 'd7fcd9a9a3252b91bc81aee122460df2'),
(608, '2024-08-22 14:21:19', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/df7', 'mvgjezegg6n12d1gbv8l46itggfxneo4', 'Uz04mYMbvSXYz8Ae5cZoLgljNmaWgovU', '', NULL, 'ec4ef47bdaf4c28dc31604f0dc3a0265'),
(610, '2024-08-22 14:22:38', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/c57', 'fsnxkx1z4waq13e2eqhlzfvgzfmzspvh', 'sy2IoI68tPIOHLaPuG01Z0IhFfjr74gf', '', NULL, 'a6015a2aee43c41ecb419d5cb9a61a3f'),
(612, '2024-08-22 14:23:15', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/468', '3pas00vbjogxhwkp2tedz2lgm9bvucaw', 'j4iy1KL2ySM5lLSsu71z5NVHgJBg3YAA', '', NULL, '2a584c95ce2c757964c4a26fdcc97cc4'),
(614, '2024-08-22 15:57:49', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/f20', 'e0vv2q1e7h68mkwo5n4rfq081s39yaxz', 'UTGHEyOKHXl8RFI6xLTTyqkyHEEMHdzP', '', NULL, '5f8dfe887f8ff01f45add5a49410a2bc'),
(616, '2024-08-22 15:58:35', 'aspro.allcorp3resort', 0, 0, 46864, 'application/octet-stream', 'aspro.allcorp3resort/gs/be8', 'onvtwfov6vurkwhao5ccpthp5l4q4bk1', 'AOsRSPg2sPFwQYfsdLi8pkkQ9oOF3563', '', NULL, 'b0c4b771e7f241665196272202899001'),
(617, '2024-08-22 19:58:16', 'iblock', 666, 1000, 106436, 'image/jpeg', 'iblock/794', 'yyh661e4djtw7goip3kvx5woz57g2qgh.JPG', 'IMG_9986.JPG', '', NULL, 'efe72b67d986fe22baffa0f6e4999be1'),
(618, '2024-08-22 19:58:16', 'iblock', 1333, 2000, 309654, 'image/jpeg', 'iblock/af5', '1jmo3q593en9oowpi5vnpqfxwovrp8l0.JPG', 'IMG_9986.JPG', '', NULL, 'd357416fcc17419b694b7d8e1ce26279'),
(619, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 5786632, 'image/jpeg', 'iblock/fea', '24nyfj82dy4g1o3qchhzsfq7p834bdue.JPG', 'IMG_9983.JPG', '', NULL, '665cb46b8d3c5ac9762b6d7d5c37af69'),
(620, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 5191995, 'image/jpeg', 'iblock/862', 'vbpu6pzypfa16l0pxkjs38axalr4n2uy.JPG', 'IMG_9978.JPG', '', NULL, '999953f690d4cf0781fc01f10b77643b'),
(621, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 6377975, 'image/jpeg', 'iblock/a60', '2o8s038mzu120r0sq3cvmscau5aamys2.JPG', 'IMG_9962.JPG', '', NULL, 'd3e7ec470fdd29d4e8dafc26a1d6af86'),
(622, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 5978472, 'image/jpeg', 'iblock/069', '7tqfhmoh9oy7ucuygumm0bfiwove6fg9.JPG', 'IMG_9956.JPG', '', NULL, 'b013811f7d4986c491d34020a8299a02'),
(623, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 5716029, 'image/jpeg', 'iblock/751', 'sw4f5l9fjdaa57mzebzzvdle3fmlwxcn.JPG', 'IMG_9939.JPG', '', NULL, 'e62e2004da0503cf68bf50abd0713beb'),
(624, '2024-08-22 19:58:16', 'iblock', 3648, 5472, 4462326, 'image/jpeg', 'iblock/c4a', 'ls2ztw21f396tcw9vgvtw17iargou4ra.JPG', 'IMG_9934.JPG', '', NULL, '5d9634e9646cfc76837bc03866d2c468');
-- -----------------------------------
-- Dumping table b_file_duplicate
-- -----------------------------------
DROP TABLE IF EXISTS `b_file_duplicate`;
CREATE TABLE `b_file_duplicate` (
  `DUPLICATE_ID` int NOT NULL,
  `ORIGINAL_ID` int NOT NULL,
  `COUNTER` int NOT NULL DEFAULT '1',
  `ORIGINAL_DELETED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`DUPLICATE_ID`,`ORIGINAL_ID`),
  KEY `ix_file_duplicate_original_del` (`ORIGINAL_ID`,`ORIGINAL_DELETED`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_file_duplicate` VALUES
(99, 48, 1, 'N'),
(101, 100, 1, 'N'),
(103, 102, 1, 'N'),
(106, 105, 1, 'N'),
(112, 48, 1, 'N'),
(113, 48, 1, 'N'),
(114, 48, 1, 'N'),
(115, 48, 1, 'N'),
(116, 48, 1, 'N'),
(117, 48, 1, 'N'),
(118, 48, 1, 'N'),
(119, 48, 1, 'N'),
(120, 48, 1, 'N'),
(121, 48, 1, 'N'),
(122, 48, 1, 'N'),
(123, 48, 1, 'N'),
(124, 48, 1, 'N'),
(125, 48, 1, 'N'),
(128, 17, 1, 'N'),
(135, 18, 1, 'N'),
(139, 16, 1, 'N'),
(141, 129, 1, 'N'),
(146, 145, 1, 'Y'),
(194, 126, 1, 'Y'),
(211, 210, 1, 'N'),
(215, 161, 1, 'Y'),
(216, 48, 1, 'N'),
(220, 219, 1, 'N'),
(222, 221, 1, 'N'),
(224, 223, 1, 'N'),
(248, 201, 1, 'Y'),
(251, 217, 1, 'Y'),
(307, 306, 1, 'Y'),
(311, 310, 1, 'N'),
(312, 22, 1, 'N'),
(313, 23, 1, 'N'),
(315, 314, 1, 'N'),
(316, 24, 1, 'N'),
(317, 25, 1, 'N'),
(319, 318, 1, 'N'),
(320, 26, 1, 'N'),
(321, 27, 1, 'N'),
(343, 204, 1, 'Y'),
(403, 402, 1, 'N'),
(422, 421, 1, 'N'),
(432, 416, 1, 'N'),
(434, 417, 1, 'N'),
(435, 418, 1, 'N'),
(436, 419, 1, 'N'),
(437, 420, 1, 'N'),
(438, 409, 1, 'N'),
(439, 410, 1, 'N'),
(440, 411, 1, 'N'),
(441, 412, 1, 'N'),
(442, 413, 1, 'N'),
(443, 414, 1, 'N'),
(444, 415, 1, 'N'),
(469, 409, 1, 'N'),
(470, 410, 1, 'N'),
(471, 411, 1, 'N'),
(472, 412, 1, 'N'),
(473, 413, 1, 'N'),
(474, 414, 1, 'N'),
(475, 415, 1, 'N'),
(476, 416, 1, 'N'),
(477, 433, 1, 'N'),
(478, 417, 1, 'N'),
(479, 418, 1, 'N'),
(480, 419, 1, 'N'),
(481, 420, 1, 'N'),
(494, 430, 1, 'N'),
(500, 452, 1, 'N'),
(501, 460, 1, 'N'),
(502, 451, 1, 'N'),
(504, 462, 1, 'N'),
(511, 510, 1, 'N'),
(520, 517, 1, 'N'),
(521, 518, 1, 'N'),
(522, 519, 1, 'N'),
(547, 546, 1, 'N'),
(548, 536, 1, 'N'),
(549, 537, 1, 'N'),
(550, 538, 1, 'N'),
(551, 539, 1, 'N'),
(552, 540, 1, 'N'),
(553, 541, 1, 'N'),
(554, 542, 1, 'N'),
(555, 543, 1, 'N'),
(556, 544, 1, 'N'),
(557, 545, 1, 'N'),
(575, 572, 1, 'N'),
(576, 559, 1, 'N'),
(577, 560, 1, 'N'),
(579, 562, 1, 'N'),
(581, 563, 1, 'N'),
(582, 564, 1, 'N'),
(583, 565, 1, 'N'),
(584, 567, 1, 'N'),
(585, 568, 1, 'N'),
(587, 569, 1, 'N'),
(588, 570, 1, 'N'),
(619, 586, 1, 'N'),
(620, 568, 1, 'N'),
(621, 565, 1, 'N'),
(623, 578, 1, 'N'),
(624, 558, 1, 'N');
-- -----------------------------------
-- Dumping table b_file_hash
-- -----------------------------------
DROP TABLE IF EXISTS `b_file_hash`;
CREATE TABLE `b_file_hash` (
  `FILE_ID` int NOT NULL,
  `FILE_SIZE` bigint NOT NULL,
  `FILE_HASH` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`FILE_ID`),
  KEY `ix_file_hash_size_hash` (`FILE_SIZE`,`FILE_HASH`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_file_hash` VALUES
(1, 280316, 'a5b2603c7b690d296fdd157b42b3f4fb'),
(2, 400738, '4b7dd75f8a959e33c5cadabac06f3766'),
(3, 1695, 'e4ca914826bd7247bfc77d9c3f4564e8'),
(4, 683, '5de53c7a1f298eac397bf4bcf29e6f4f'),
(5, 1968, 'adecddf040ead2c1181802b643a57f78'),
(6, 1497, '839a6e04b9c22c58691828fa1e5ac1de'),
(7, 922, '8e30c7752deeb7c43dd283b74137857a'),
(8, 11240, '9eacd9c9cb4b4ae6cc42ccdf5499bbb2'),
(9, 2594, 'd4693eec500bfd2a76a9deb912d1fe39'),
(10, 8470, '724fc38391e0778fb33b76b68230540d'),
(11, 2780, 'adb30621fbf4cfa252377d8ff34e14ea'),
(12, 11993, '56628f23f4b4e39418e2186e10934dcc'),
(13, 6954, 'a96445e3d890cb9fd32dc64d53c5973f'),
(14, 13683, 'c95917f3ab81969702fb5759c2eaa82c'),
(15, 2964, 'aa1e9034a2c665ac281f5d079bf764b6'),
(16, 94489, 'd2af42e9876396e6b6365663cd7f7c2b'),
(17, 106334, 'a0754be2a34682f91806345f1cc27985'),
(18, 79182, '1c91fd99430804f7a99b6f0dfe630a9a'),
(19, 120111, '172847f99bc8e359a36a635c8f19c8f4'),
(20, 3531, '37acbb798eacf520b8e32d09ff4ab406'),
(21, 19661, '2d6f15ac70060a9effdfbd9cc5fef32f'),
(22, 7647, 'da1e93a1750412d7662f1478fa039404'),
(23, 23872, '1c50328bba74d4d2b821bd2e62000976'),
(24, 2656, '6080add14151cd16b9fd46e97bb1a42d'),
(25, 23715, '6deb1a2cba14b9a1b7821595b00a73c8'),
(26, 1440, 'a637a16bb88183260913536c916daec8'),
(27, 26056, '09a1dcfc01f567755755d45b2699531e'),
(48, 85929, '51a44f315e01ea569f04696490981c9d'),
(49, 183471, '14a0c8fb7ba0ef5f7e8326ece88ee508'),
(50, 32988, 'f087697d9031eb796c3a75b8399dc7af'),
(51, 740, 'ae9b0541ee14c4ad61ba918d1108cc57'),
(52, 1854, 'ea686f78a6e4ca8e23b342c714243d0f'),
(53, 1165, '540acbe5f25fa1ce45385e2247e4cdbe'),
(54, 838, '8a073ff1c7c05b1fea95906cf105759b'),
(55, 1343, '949016388df664401a0ab91f592114c9'),
(56, 1125, 'b47828d5404a26e5221ba153d2b810c2'),
(57, 931, 'b6cb8eae842f9be4ee74dce9c4879dd2'),
(58, 1007, 'b6968271faf2e3d19fd141d1d93d929c'),
(59, 925, '2c3b4226287c451e98ada2c79c57d4c8'),
(60, 719, '0eae88b4e098982d6ae7145c35a95680'),
(61, 664, 'd2dfe246cc1572745fb50a30c3d434c1'),
(62, 1268, 'bd4eba202de81183978018f2c1feab2e'),
(63, 2008, '53ed91d0e9d8cb1740cbe36d9e5de4e8'),
(64, 1029, 'cfe5c41d6b292f9032b8f978d4798838'),
(65, 910, 'e13207820c8c57f0a6df6870d957ea1f'),
(66, 1403, '2590ae7f4c12b8a67d7b801494280b1d'),
(67, 1777, '03bee183888091422a058ed173df36f6'),
(68, 520560, '2182ef6de9b117fec41f523f7afd3ea1'),
(69, 616882, 'ddbd2329811b954b714b6566f0967293'),
(70, 370023, '162915b8cfaa1ad3f11c3534340a7835'),
(71, 394965, '2a2fb59b21019f6e4f6220c1ff5fd392'),
(72, 294621, 'cf79874d19aad68292bd410709781525'),
(73, 262229, 'd59ba062d98dfccd17d9d20a3eecf087'),
(74, 228777, 'fd64f94dbe49a3cb4dce4be1bab8260b'),
(75, 168583, '5644756da9d75a33150d3175b16c4cb9'),
(76, 1402440, 'dae413bb459a440797332698c7fa2629'),
(77, 400299, '857641124968ab78a5a70b92437a27a2'),
(78, 756277, 'a12ab4d142b40616f082e2c2d6532287'),
(79, 328235, 'f97c0aa2dfb0fea9bf7151047e5d7100'),
(80, 437725, '5d3934680be241530a034440261cde14'),
(81, 293564, 'bcf4657a6816633b929d0e1d0913d55e'),
(82, 175239, '68be15017568234ff3705aadd55057a2'),
(83, 703000, 'c9e2b69f3ee631a13154f8cc5b625b18'),
(84, 237702, '4e424dbe233f8086adf9d0b8e95579cb'),
(85, 428709, 'd39f78a3a861e0d6bb1ce4dce1b751da'),
(86, 199557, 'f79518c255788551b1393ca631885275'),
(87, 249410, '36268adbde922577c976e03d8783ae6f'),
(88, 171954, 'f67ef6a3b0acd61a5eb80a77f187a3e1'),
(89, 132490, '5bf2dcb6107402e181fe18d10a96553d'),
(90, 700253, '10dc04948b5fa69d20e535fa7b3d6fd8'),
(91, 72436, 'db5105f7799e907d349af133cec0e244'),
(92, 79627, '4fd64c62bd8e9a2954a509a7e2cc57fa'),
(93, 14866, 'aa61570b6da616c8cc047060d5a949c8'),
(94, 37059, '12719ec996aae5d87253d672a5420470'),
(95, 20140, '3857d0f8291d201ca384d361f2254ea7'),
(96, 64031, 'dc27b4e7f7cadb5abeec2c9a25528ed3'),
(97, 23253, 'fee7ec1103c2377b963f0e1a296a6e8f'),
(98, 1221, 'dcb161dabc70cbcf626070d12cbf4583'),
(100, 3084, 'e24081c3a7c50a71c9eabb700e6fb8a9'),
(102, 1464, '162111f08606c40658686a6e8e9c64db'),
(104, 1805, '7cf6424e7c65eb94ef73be20989f4ff3'),
(105, 1328, 'c5f8fc8857adc4bebcd559d823a66886'),
(107, 2081, 'e98e5159bd5ffc247eed03c18777944c'),
(108, 1142, 'b31e39439ea489cf9be14ab3da96057a'),
(109, 1846, '734f6791044b8441d49861c3c87eec74'),
(110, 1224, '9c5c378c65aca36a86cbdaa271527c00'),
(111, 2477, '5d0af7e763423b731bd5cbb29961a1a3'),
(126, 38639, '04739fa66f235c689f34eaaf1f6332cf'),
(127, 70576, '3de87e330166898f5098413f54363bff'),
(129, 86721, 'f6f2d300d661c6017b593af56502eb8e'),
(132, 81442, '64bc9ea6084281d14757b98e81e653fd'),
(133, 129104, '85dde421e699645593cb412816429e1e'),
(134, 55202, 'e45a9f89b6c729d046ccf1a3793e7432'),
(136, 61186, 'b934228186ecdf8e5bcf2dcd47687657'),
(137, 89972, '567e1e8d3791417d798a5690344a6090'),
(138, 66206, '4d25f64b7259638e80cb04ec75deb0de'),
(140, 87315, '4947dcf4e83aadf9292e4f9f5983df54'),
(142, 156546, 'c3cd5a52e93b2e0450a19d3979963696'),
(143, 87855, 'f7912f9770f0912feba0ade6297230f8'),
(144, 197244, '7ba435cacd38fb02183a121d9c070974'),
(145, 1226140, '50b33c9944d7d39303128f5fdd34af8e'),
(148, 528882, 'febc0cbda824679f8265ac9353b611c3'),
(149, 192019, '2e286b1b139a9fef8a2dc76320cf823e'),
(150, 422422, '933922678c51f4721c8f3473a3eb3ef9'),
(151, 236113, 'bde92e4c55b0fef423412d389794a391'),
(152, 164094, '931475b9b0743f285488146b23a751af'),
(153, 125303, '9102a0d5e0bfc4497e6946587fd903f9'),
(161, 15813, 'ea8e83bc0f87db349ad4413638d3c64b'),
(168, 3288, '19bc4963b129cc849182cdf504982158'),
(169, 1402, 'd1d0cf627d3127051aaa541c19d32af0'),
(170, 1446, '8c80c7c8c9fd9a5223178c2c601f3a31'),
(171, 105298, '4788bfc5553e50ce69fc94d290fbb43a'),
(172, 1716, '10e2041bc63d7705661fb6c6578f0c0d'),
(173, 2891, '35eb9320ee9f5f70dc2931295a6d7127'),
(174, 2623, '60fac5658028c1f00f4c3049fb70273d'),
(175, 1694, '1266edc2ae7bc2ee46f3f99e8863ded2'),
(179, 152620, 'b954ebd8db2afb9896d6b8b81abd0370'),
(180, 165655, 'ea245b5277041e1a4d6a29af243b69e6'),
(181, 121174, '73928c9a705e66c88aed286e26c2e60b'),
(182, 110167, '61ca15bd5656cfa9ec62593d28ba0931'),
(183, 143129, '677d0ea7fced009e646ad4d4febfed7f'),
(184, 221008, 'f9636949fade60155c78c444be997ff8'),
(187, 310676, 'f61d2642608a02fe322db2d77051f55a'),
(189, 152024, 'c6fddd7f427b6ba0fa10018498a0aa8d'),
(190, 63927, 'ed64881dab6812bdf7443c5b040d3d36'),
(191, 274956, 'd8cf046eac1dd29263a3e5558cde1fe2'),
(192, 105672, 'd72c3fbc10878e0aa7e73cb1a2a147f0'),
(195, 38730, '854acaedbe1900355c0a8a85ab7b35a0'),
(196, 158335, '49b66640d23116d5c992a7d83783d839'),
(199, 134029, '80491e815c3bc22b9d9bbedcac04210f'),
(200, 220982, 'edf4d8880632b296911e9d6b31940249'),
(201, 194033, 'c42335d44aa4dd371d9f40a040bae841'),
(204, 670339, '889d746b70ce9c9ee9e2050af2b8e91b'),
(205, 34726, '6af7a4e7d7dfe4b7135c4bd15b0ce1f1'),
(206, 35535, 'c7b5f3bab6d0da1599db6063a0084fe8'),
(208, 31438, '39818312264f0c9127d23dba88831083'),
(209, 41520, '57c83f4e372cfe90d743985ed5e36f2d'),
(210, 34223, '1c5ef09897764879da7f224e0c40b904'),
(212, 36910, '0f74629f289ea814357a777187c09cc6'),
(213, 28521, '4582a456af7a3b87e9c075989636054a'),
(214, 28232, '3fd3b4f6f6f237973f4d528e830cb702'),
(217, 454408, '3bee9d324e236548eb14c6c76b920ce7'),
(219, 364702, 'b3ea410747201059972427230b1b5b58'),
(221, 254504, '749473a9ff5ee4e58ffb114bdc14e262'),
(223, 453029, '1d68e1ed4ada1b596f947a5d49350bf7'),
(225, 198992, 'eb4f9f45829ba3e44ce190f72fff60c7'),
(226, 117786, '4553cfcfc171b49950cf3f4ef217ab4f'),
(227, 5318, '7d9f21caa75056f4822bd54d6e89fed8'),
(228, 28574, '71398e27666db7af442cf7c5c672f9de'),
(229, 178261, '902df5cb0c8fc3697623c99410be11d5'),
(230, 457704, '65cf402ab9429268b0af8a50ede7a56c'),
(231, 4390, '0b240f5718ae72ba5399e99234400ba8'),
(232, 30861, 'ac07c72bdf84d061edcc6d39b7b2e65c'),
(233, 242521, 'ef357b8dbee228ebf6e19517f7c3e15f'),
(234, 125253, '96eacfb6728d5b62b440835d9216d537'),
(235, 4116, '60443e40db942c9503e8c890975c1ece'),
(236, 26668, 'b016971b68f087b74c577f5ecc05e83f'),
(237, 243867, '0b58a78e08a1ed5aea6703847f89cf7f'),
(238, 751206, '1d48aca04a4a4b376cfb0759b8fc750e'),
(239, 2249, '56e535b26861d5097ca1aa39be7664d2'),
(240, 32648, 'ac6da7e72466bd4be0818b50fed939a0'),
(241, 210987, '179975bd30fb74f6e6dd15eb02a40835'),
(242, 372619, 'f4ffcb37f1a6b4b20b7c3f3bf2bd9410'),
(243, 22397, 'fd5d7134eb824d727ca42915c56438a1'),
(244, 3990, '8e46f065bf410af1749538477f829332'),
(245, 250186, 'c6768398e8fbb17dde54317a44f23960'),
(246, 506920, 'b0eca7a52e1fa6355f5031291cf091be'),
(247, 17046, '58f01f1f0280135a6ea7d4932db05729'),
(249, 1649, '87e8a6607a648a3ae3fcb83a9f698020'),
(250, 189191, 'c5c72d8749ab572369d6a1e2adad1493'),
(252, 22523, '784eb003a0e33d2e0a382b08ce701962'),
(253, 2941, '6b8f0967da0b9d60ef9f41eb81ad910f'),
(254, 169379, 'd65a23dd7389372d5fdf015b5f0fc9f2'),
(255, 355405, 'fc1d41f13a9306d3cac9a9bc398a0e5b'),
(256, 26662, '02242dad49c285ef69c870fa0d1973bc'),
(257, 5838, 'bff6220e02bd4a262e037b690b7e649c'),
(258, 128234, 'b145456411e57210329b8b06ad0fa5b1'),
(259, 261340, '76c0f36a5e53f37bd9923d6ed5050c04'),
(260, 32360, '2c3bfac32bee5a34a43e09c7702b7f18'),
(261, 6087, '3abb0a461fa70f49a2bcc73a9b1142de'),
(262, 139975, 'b0fc2519dbc76c65900a82b3d2890bf8'),
(263, 297278, '74d9cc300deae75226c1be3bfabccf65'),
(264, 31772, '5b8a34b97383ffac5556fe60c42886b8'),
(265, 4141, 'e5c0ee81b4739a4dcbf6824bf45000df'),
(266, 218602, '1652d2651e7e2493bd0f3e475ef4ab5e'),
(267, 357833, 'bb9719de9631f7cdfe6989226b0bf43e'),
(268, 23188, 'f93d516d9312841e5528b91a94a93b3f'),
(269, 8696, 'dd428c46075c0d18e3d7d683214cfb65'),
(270, 119889, 'fc20844e38a9de6af1458e23ea84e5a1'),
(271, 249862, 'e57ce044935c4598dc2c56d0351e7e67'),
(272, 34718, '09907f58e70226f2a7dc3d55ea5ade6a'),
(273, 8864, '2f2161899383f56d08d7e6fe5d2734fd'),
(274, 214213, '01fd31a0e9fb94e806fe1da0eb0270d8'),
(275, 430998, 'b826e91feb2875fb3e59ff5150bdbbb7'),
(276, 18798, '3f12db7ec6a41ffd654f7cf918af5e5e'),
(277, 3760, '7570781f35fd6d591557d63aae393589'),
(278, 265659, 'afad6e0fec490e2ff7fce2a7daec8a14'),
(279, 469865, '3cb1a256d24f9d2f855995c8e04d52a3'),
(281, 7351, '966ba5db665270da4e7197147a1c35e5'),
(282, 162255, '49d82d072c9c097aebcfb66d0fa60dda'),
(283, 297409, '543a957d1ed514d1e31cb481393d8e27'),
(284, 25372, '3b7226b9967c37a85f9c63dd685808af'),
(285, 4079, '8fbca20d38e5214e4cc17bc5fe7e5553'),
(286, 216884, '97fbb58be2f8c997c806329c04bf3a98'),
(287, 433458, '768d59e5b744b54b292beb654aba4963'),
(288, 17161, 'b05092458e554a2b45108fe272216f74'),
(289, 3506, 'dc64543af72c9dfe28066df496e0997c'),
(290, 242298, '9eeaf0bb987651c7de434aef2c3ed69a'),
(291, 479608, '51ec82be478938f84ba95de07db18eea'),
(292, 23784, '5201ca99375be9b8ecd05a686a591e0a'),
(293, 4693, 'b03aa727c3b9e2d786fbd3095cba3437'),
(294, 178875, 'a5a44dcb27027afab57705b9c0299df8'),
(295, 402279, '660e6527e2010ab5ef20dbc8296b8cda'),
(296, 34727, 'ea6ebccfc731e0046883df826dc66134'),
(297, 4681, '99928c370722fbe35151b6f19f31045d'),
(298, 227629, '5e2608974501ece0ad6a71c323a6b79a'),
(299, 844288, '504237a618eb0dc8eadb337751745ee3'),
(300, 25058, '905efed0048a7055c1e1c32e9f996315'),
(301, 4849, 'caf1da833305f6cc5564ea952aa28bc5'),
(302, 190501, '65398decba56e1f7c864c5da519195b6'),
(303, 459477, '6229a37feb7e9c89fec41d48b11775f7'),
(304, 23256, '4ae2a43daf1a09867ad0bc62e0aaffe2'),
(305, 2724, 'ab7f0cd5798c5843f973335bf4395f27'),
(306, 191297, '96a6abae61a69a8cb8027d9c15a55134'),
(308, 2361, '745d31ed35a0f59110ff1ed634774ee2'),
(309, 20503, 'd72d60865302ccd7f65a28bbc0c66f5e'),
(310, 285432, 'ec0f866fbb60c16b476747012da6f4e8'),
(314, 218238, '470cf267a97a5cb9e83d05309ba7c6b0'),
(318, 408070, '222f566752a030cce9518501fc5c7d46'),
(327, 103288, 'b78d82f2ea5fde8446d634fbb6a49d3c'),
(328, 499710, 'a4f95eb1eba3e972738547bf81d93426'),
(333, 188480, '486844a7c38de8f8c32e27ba0759c9a8'),
(334, 741965, '9f7df6505133865c4e40fe5f2c4e5faf'),
(335, 184948, '45d5113a1052707846a5c53ec9e6b53c'),
(336, 748198, '02a7135a77df9b1158e311bba634b6f9'),
(337, 209181, '81f9c8f19336c0f7bc9f1365a0952d2d'),
(338, 809907, '962265cd86866c847bca922a7b2f1e99'),
(339, 202754, '0716edf58ef015f4a7d1b38c1ed5ba61'),
(340, 769463, '081f38702fd111a109acb5c65f682007'),
(341, 188843, '4c83793e0cf4c80fdfd5e3184bdf30b6'),
(342, 613721, '8781c506ac35726680a34d2b73b6843e'),
(344, 207474, '37f9e1cc8174a36a28c03327197514c1'),
(345, 731717, '476e2e3119b409cf90b9f2e8231fe761'),
(346, 133297, '58796c0705ccb492d8717bf3639a83d6'),
(347, 472401, '6bc8815518dd3f6ac00e1b00170aed50'),
(348, 539538, '0dc64245568164d170c8a1317b349719'),
(349, 675401, 'a8fc9ec697839af5c7ea073113cf866c'),
(350, 628302, '580bf4f0f31f183bab218f0fad470c8d'),
(351, 880149, '4849874906f6d80cb808381399997ad4'),
(352, 163935, '40f891a6f49ca4d19eeab0234ab6697d'),
(353, 611224, '1f802a81fa958cf7ae8947437c9490c0'),
(354, 186675, 'cd0e4e23f34ae92953f67b0d5578f078'),
(355, 632105, '11caae605e291b72b0beae0d0bab2e70'),
(356, 181679, 'aa7b0c12d926140db4457ee7291c7cd0'),
(357, 695563, '1f48d34f6477be33737d1e47325d5567'),
(358, 599130, '8c0ba4078d750969b92b5ad807c8a0e8'),
(359, 604779, '4eaddb36185fc6abb547ca7a45c98467'),
(360, 175366, '4b63136736cb61e1ee413778424ebbbd'),
(361, 715999, '2b3e9a884fb45ea339b281e1a0cc116b'),
(362, 46317, 'b5bdbc340910f2cd3b0927391d3dcd36'),
(363, 183668, 'bd76137bcc7bca37c9bb162c7617c607'),
(364, 105893, '0bf7ff10f4b0f4bbf79f025dda6c81d5'),
(365, 43993, '9ce03aea141301ee1cd935c2faafea1c'),
(366, 148005, '0f466a146970b51f2cb3309854314142'),
(367, 41077, '9342cc1e8585fe7d970c6bf36bddb6cd'),
(368, 85880, 'eec515ebe2dc5ed4894784d68cd3a2a4'),
(369, 83425, '1a24dbf1afd6ba52d5f3a22a1a5f4820'),
(370, 278924, '994dc11058298c6d61c76a117202d372'),
(371, 291713, 'e5ac7d2a52cc36d753be78f480423ba9'),
(372, 202833, '50b1d4039568a393ea53b2fa2dbd9fed'),
(373, 280169, '59ab9220b497103c3233cb8644c06166'),
(374, 250673, '2a87fbf7498c0b2f9f932fe2f920fda0'),
(375, 135076, 'b124b880cfa8b4d9e08aa63c751491d5'),
(376, 162109, '4936d7c3a5d7065117e8c72760d12c44'),
(386, 167482, 'd87ff0ed3c59601ba779aeb1eb0355c9'),
(389, 120746, 'dd4eca8a7061b1e2df3acdd4781734d8'),
(390, 117472, '34694ab131b354961d0c415d1682ad3f'),
(391, 176772, 'e7cd3310e0177ad03fb3eb38aab27c14'),
(392, 107650, '20d15f2ad169180a59ad2790ab2f6efb'),
(393, 177406, '273eb2cd7b96450a2d08bb3c077248d7'),
(394, 62453, 'b48614de74b3610d0d28c54032593c97'),
(395, 189506, '260450592224771dc5d888189ca418aa'),
(396, 67454, 'b98abc7332adb4df9da3234b5d4fae09'),
(397, 104663, '4e0da23221aa49ee549608d0af00ceef'),
(399, 44311, 'd1f029abc8ec048a5c72aa9dd77bbcb1'),
(400, 80563, '4bdc389edf100dd177ccce69cd180a2a'),
(401, 103974, '7967456f1477b63f1741e66380399c70'),
(402, 205937, '61051c3668e06fd1b1cbcb0a9280a6d9'),
(404, 109321, '2b781c073ded328397779d61c8d0d8f8'),
(405, 205805, 'ae13e8a5a3db580896814470c8d3beac'),
(408, 368506, '2d1836137a20dce53f7f3d26b7a590ad'),
(409, 1918695, '979474ea2b6cf081788712a2856a5b4e'),
(410, 1863271, '0d1c421a4c101f2fe52c3c3fb8c15f15'),
(411, 1824161, '7789144eead01f90594146d39e961e07'),
(412, 1950902, '13946872dc97dd9da41b977fd6207228'),
(413, 1891178, '4d568abc629cd8f68da3c317b884022e'),
(414, 1765638, '2c668f417c909b20107fe7b47083c495'),
(415, 1600601, '39cb45cff11bb26916035289edc2609c'),
(416, 1766897, '3456458f4de1f6bdf905292c7683d2b1'),
(417, 1798626, '4391d600c3da9df13ccaf69de1eae6d2'),
(418, 1668465, '28e49384dec637c12c66564953b55b8b'),
(419, 1573766, '86caa2a5146a705790b22326d12aa493'),
(420, 1878703, '0b90e51b8fc09103a7a3925f2a9f55b7'),
(421, 564568, '1f60da85b8643335244c56144fe8a3a4'),
(423, 136351, 'f2a4c86d26c9b195643e2d0cb153ea69'),
(424, 284585, 'e22569a6f62957e463a51790c916b96f'),
(427, 481118, 'fe4022797e45cd32f84fae4b7b4e97df'),
(428, 139713, '46dd3c6bdddff8c72e049c774bcdc3cf'),
(429, 106591, 'df040caafe5fff4596906255bd75d2e6'),
(430, 349932, 'd8cb8cb8bea10ea64c24b51cadd75c74'),
(431, 79082, 'e79935b76561f45470ef84acdef55970'),
(433, 1985091, '5a1f2ca5a16ebf7e1e3b424e62faa431'),
(445, 3607365, 'ef5e585fd0ad56fa6895b4932c4e89a7'),
(446, 2346918, '05659a9e1bb7ebb01c3c611ecbd42e9a'),
(447, 2645262, '23a64f14dbb6069fe48041f79cefd9c7'),
(448, 1324924, '87d305d408b5fa83fd009bffecee4775'),
(449, 72488, '7d2bab42bf55c149696394c414983ac4'),
(450, 2263907, '55be865a2a4735fc5b65b1d13607dda7'),
(451, 2310934, '87fa38ef00262dd4f66398a880f468ac'),
(452, 2365149, '8795661c678eee2e45603cc1f30043e0'),
(453, 3161828, '63ef3084e2a46fa6d886c98c85368455'),
(454, 2966813, '5571db0256ca497a06062bf718273435'),
(455, 2689137, '7e2a06bfdb41fc8cde60a965270e89bb'),
(456, 465895, '1b33a4c500cc46dd31443af7706ae636'),
(457, 4049593, '2df507531975991463151e6826b96ad2'),
(458, 3446606, '1e623b4c8cc04163711abc5f18b5f45b'),
(459, 71037, '1ca2d773f2cb8e689429ed5ceb29052c'),
(460, 2961849, '2700d456a964650f3b43be05f1bafd7e'),
(461, 1796305, '61c01ec176730648e15a4d34a5a49f4d'),
(462, 4087157, 'a63a233ded9b10fab5bc4fe5f4e333dd'),
(463, 3294752, '96057ae9b133388d13d1c3e0c80f2b8c'),
(464, 3481903, 'd2fe52519b47691aa204ada5ab72032a'),
(465, 3334892, 'a8d8e98a5d94792194696251e97ae488'),
(466, 1942577, 'ce1f0f6b7d00e00dbefa1ac5db0d0cc1'),
(467, 2145787, '1a16b5d24214cb3bcde59ed048fbb04c'),
(468, 1842105, 'a77d89b69cb5dd789267e42fc07c9a27'),
(482, 5564, '91f04644b435bb73f27167ac88ce21cc'),
(485, 5564, '1fe3e81bc553cb30b362d866e60f43d0'),
(488, 398, '14e69fba96cfa4b31c27903e154ea87e'),
(491, 197112, '92fc0cd4e5a61b2d11ea1320b18935d5'),
(492, 578174, 'd085cbde1f1dcc8d90a429b3a3408f54'),
(493, 57094, '1f5dba5ce320d3e0316542d27b98932a'),
(495, 2217535, 'ee43c3a9ddd64f606660404a16ae54e3'),
(496, 2374654, '5c736281d8107a2e08b683958057e044'),
(497, 2342547, '444c0d76f758f6384162da085609a74d'),
(498, 60800, 'a35ef077f01f7de01c22df2a3793c5b9'),
(499, 395866, '35a9a9b5ee40d6be28740ee7993568f1'),
(503, 2317677, '6154e168c59a9f5c4b77fe5b0875dc0d'),
(505, 1791289, '260b3702ae4b266643681fddba2ea197'),
(506, 3011078, 'aafe9437fc268e7b0a266bde502983d4'),
(507, 570163, '02363e8f393890cfd23b6e23b4dca433'),
(508, 958427, 'b50dd5da0d18c586c6e43f324a9a5e4e'),
(509, 105505, '82ed202894e70996c1e0ad230180fd7a'),
(510, 77501, 'a0deb94d9e13f94e030f933d59aa3f5e'),
(514, 646421, 'c90d41ef500c2df0e3b538eef95881cf'),
(515, 2012614, '8b5dd25888e14ea9c55573080bd11fa9'),
(516, 3471608, '21ff5b66dc69dbad3244b038709b06ee'),
(517, 1945045, '063055bda660d1b5cb21ffda14bc6888'),
(518, 1912049, '67037e6d6163f29a4d60307001a2a218'),
(519, 2338207, 'e7edd66fa4b4d1e9b310da68dc8afcae'),
(523, 161193, '87ff670145129ce333354bf2608a13f5'),
(524, 573029, '227e81ccf9e79574aeda429a6ff3d433'),
(525, 2234813, '43f7932ed12169e21540825e2f1f5a4e'),
(526, 2064705, 'b171f195b85a9d2122224f3765f2788d'),
(527, 2187370, '3ce992c10fbf53f45827de3706aaee60'),
(528, 2048339, 'fddd7dcf24153f5275edc111c9b15047'),
(529, 2140934, '43fe6cf7084dc28f995082da39810768'),
(530, 2102338, '7ff37b53a7ec5edaba3376018e6c1ff0'),
(531, 1878320, '8617089065a971b8eab4ea77c4ca7f6d'),
(532, 2080471, '82ab4e594e81789601276d847e9cec5e'),
(533, 2094724, 'bcf8623f1f7695be209550ed18516468'),
(534, 103376, '27faa0e2baa1c51050352333fe21f46a'),
(535, 360482, 'c941e25f7ea858389731f58914e2f347'),
(536, 1057077, '75a961d69779fe53654167c7983012a9'),
(537, 1473164, 'd22345b749d1208a8087a96e3b149114'),
(538, 1196691, '11f8711ae4d51cc0a1eeeb02ab0492e9'),
(539, 2053646, '6601e191a9548698b95b578c79503b45'),
(540, 2098581, '6b5f1f69372281ac41bea59825c8f5cc'),
(541, 2168647, '87dbc1cc2d5bae5ae9d6964a09b40d85'),
(542, 2032832, '636a9aa408a9eed993d74c7f02702a8e'),
(543, 2080649, 'aee979b357ff1155bcf15d6e47fb54a8'),
(544, 2011517, 'fff596f83e62e74211019cd6a906160f'),
(545, 1744690, '040f22a832d3834f5dd083ac21aed723'),
(546, 1711414, '97fcf2cf242a9f274c3977b9c95d23ae'),
(558, 4462326, '40769ff15227b0787b59e718d291a343'),
(559, 5357496, '8f5d8fe3eea42545e9e9b3e0243f4e1f'),
(560, 5078046, '25c61a1254b8bdacb956fd02c17a9c97'),
(561, 6333149, '1463b692c42dbfa06de7065ab35f9b2d'),
(562, 6711403, 'd59e6105b38939a981a0027aeebe9050'),
(563, 5579063, 'b9c149e92076050e4b11c3a0102cbd4f'),
(564, 5106259, 'e53fecfd281e07e504cca559ab1ae969'),
(565, 6377975, 'd457697b21329ddfe65c5892d30c6d8e'),
(566, 6407033, '5a9a9cebe4a533acb2cb1b429333a137'),
(567, 4299996, 'f116f65e14c87539b654775e8636c1ce'),
(568, 5191995, '4cfef56db111f4c8f241b9ec1c93351b'),
(569, 5491294, '828a397dcfe0bc7508253179701eceb5'),
(570, 5594432, '5d74c8ee9d0de6b2cc5b294dae93b7e3'),
(571, 6173902, '322f7eba65ea71df770f356fa6757556'),
(572, 5687070, '2a98e4460e0307da3c20fbad6d837987'),
(573, 58753, 'bfc0ae6ba4cef3b29beb84ffe6b03a12'),
(574, 247681, 'f249184547eb05e61a8ff3f2de7f05dc'),
(578, 5716029, 'fb135f8a32a8546d6c06c7c51c45b93a'),
(580, 5171666, 'b174e7c42cd8b6be02405402d5888b53'),
(586, 5786632, '79abfc79804908b5ba61207fbe101f95'),
(589, 2093484, '11f4178c4efaa567da1953b68deac2e3'),
(590, 2089197, '8b5a0b9cbe5fd24469a984b273454783'),
(591, 2235726, '2f150d3d83ce3ae157df2cef3435d161'),
(592, 2329422, '74397151de0bb46e66a697f58859aa66'),
(593, 1757202, 'd937434f577f6c505a3af40ccbc1804c'),
(594, 2017453, '9464f23016ec255f093cbba04b9e823d'),
(595, 1836876, '3ef015c56e4006b480642d64d80c6fe0'),
(596, 2279208, '59a0db762ebb882ee8d1381f68b5858d'),
(597, 2325724, '3a12ba627a2abe4e43577dbd91a6b6d8'),
(598, 1945881, 'e02bb54a89b2f8606921c35890fc3ec7'),
(599, 82005, '14de66322d2b5adba793e0d67bec4d5f'),
(600, 572719, 'e50ab5b9f3b028f1969c3390e16109b8'),
(602, 46864, '520820f694c069febcb4eb12194708fe'),
(604, 46864, 'd7bcf9d2f5bbc7462da535a34e235fa1'),
(606, 46864, 'ad9028e2b37c979419078c684dae8f7e'),
(608, 46864, 'bc4499224091951e339f716eb3884a24'),
(610, 46864, 'a421bcb37b7b79e0724d178eb885489a'),
(612, 46864, '86d1e6c163f6e596f329709305cee35d'),
(614, 46864, '0f682fb2f1519247adb21ed2646663bb'),
(616, 46864, '6ef647dbfc320562ba584f3f36d616a0'),
(617, 106436, '8d54f3b516f56f6e143351ccf964a0c0'),
(618, 309654, '7a6b705991f6e0cd7a3fd169e7627e39'),
(622, 5978472, '9354a44d19867e91f3ed0c71bdbad76f');
-- -----------------------------------
-- Dumping table b_file_preview
-- -----------------------------------
DROP TABLE IF EXISTS `b_file_preview`;
CREATE TABLE `b_file_preview` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FILE_ID` int NOT NULL,
  `PREVIEW_ID` int DEFAULT NULL,
  `PREVIEW_IMAGE_ID` int DEFAULT NULL,
  `CREATED_AT` datetime NOT NULL,
  `TOUCHED_AT` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FILE_PL_TOUCH` (`TOUCHED_AT`),
  KEY `IX_B_FILE_PL_FILE` (`FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_file_search
-- -----------------------------------
DROP TABLE IF EXISTS `b_file_search`;
CREATE TABLE `b_file_search` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SESS_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `F_PATH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `B_DIR` int NOT NULL DEFAULT '0',
  `F_SIZE` int NOT NULL DEFAULT '0',
  `F_TIME` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_file_version
-- -----------------------------------
DROP TABLE IF EXISTS `b_file_version`;
CREATE TABLE `b_file_version` (
  `ORIGINAL_ID` int NOT NULL,
  `VERSION_ID` int NOT NULL,
  `META` text,
  PRIMARY KEY (`ORIGINAL_ID`),
  UNIQUE KEY `ux_file_version_version` (`VERSION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_filters
-- -----------------------------------
DROP TABLE IF EXISTS `b_filters`;
CREATE TABLE `b_filters` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `FILTER_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FIELDS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `COMMON` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PRESET` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LANGUAGE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PRESET_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SORT` int DEFAULT NULL,
  `SORT_FIELD` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_finder_dest
-- -----------------------------------
DROP TABLE IF EXISTS `b_finder_dest`;
CREATE TABLE `b_finder_dest` (
  `USER_ID` int NOT NULL,
  `CODE` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CODE_USER_ID` int DEFAULT NULL,
  `CODE_TYPE` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CONTEXT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LAST_USE_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`USER_ID`,`CODE`,`CONTEXT`),
  KEY `IX_FINDER_DEST` (`CODE_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form
-- -----------------------------------
DROP TABLE IF EXISTS `b_form`;
CREATE TABLE `b_form` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `BUTTON` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `C_SORT` int DEFAULT '100',
  `FIRST_SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IMAGE_ID` int DEFAULT NULL,
  `USE_CAPTCHA` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DESCRIPTION_TYPE` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'html',
  `FORM_TEMPLATE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USE_DEFAULT_TEMPLATE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `SHOW_TEMPLATE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MAIL_EVENT_TYPE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SHOW_RESULT_TEMPLATE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PRINT_RESULT_TEMPLATE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EDIT_RESULT_TEMPLATE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FILTER_RESULT_TEMPLATE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `TABLE_RESULT_TEMPLATE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USE_RESTRICTIONS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  `RESTRICT_USER` int DEFAULT '0',
  `RESTRICT_TIME` int DEFAULT '0',
  `RESTRICT_STATUS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STAT_EVENT1` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STAT_EVENT2` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STAT_EVENT3` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_SID` (`SID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form` VALUES
(1, '2024-11-29 00:22:31', 'Оформление заказа', 'aspro_allcorp3resort_order_page_s1', 'Отправить', 300, NULL, NULL, 'N', 'Заполните простую форму и наши менеджеры свяжуться с вами, ответят на любые вопросы и подготовят счет на оплату', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_order_page_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(2, '2024-11-29 00:22:31', 'Написать директору', 'aspro_allcorp3resort_director_s1', 'Отправить', 300, NULL, NULL, 'N', 'Если у вас возникли вопросы по поводу работы наших сотрудников или компании в целом, а также если вы хотите сказать слова благодарности, напишите сообщение и оно придет директору лично', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_director_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(3, '2024-11-29 00:22:31', 'Забронировать', 'aspro_allcorp3resort_order_product_s1', 'Отправить', 300, NULL, NULL, 'N', NULL, 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_order_product_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(4, '2024-11-29 00:22:31', 'Заказать проект', 'aspro_allcorp3resort_order_project_s1', 'Отправить', 300, NULL, NULL, 'N', NULL, 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_order_project_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(5, '2024-11-29 00:22:31', 'Заказать услугу', 'aspro_allcorp3resort_order_services_s1', 'Отправить', 300, NULL, NULL, 'N', NULL, 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_order_services_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(6, '2024-11-29 00:22:31', 'Отправить резюме', 'aspro_allcorp3resort_resume_s1', 'Отправить', 300, NULL, NULL, 'N', NULL, 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_resume_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(7, '2024-11-29 00:22:31', 'Задать вопрос', 'aspro_allcorp3resort_question_s1', 'Отправить', 300, NULL, NULL, 'N', 'Менеджеры базы отдыха подробно расскажут об условиях проживания, услугах, ценах и акциях. Ответят на любые ваши вопросы. ', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_question_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(8, '2024-11-29 00:22:31', 'Заказать звонок', 'aspro_allcorp3resort_callback_s1', 'Отправить', 300, NULL, NULL, 'N', 'Представьтесь, мы вам перезвоним.', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_callback_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(9, '2024-11-29 00:22:31', 'Написать сотруднику', 'aspro_allcorp3resort_callstaff_s1', 'Отправить', 300, NULL, NULL, 'N', '', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_callstaff_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(10, '2024-11-29 00:22:31', 'Оставить отзыв', 'aspro_allcorp3resort_feedback_s1', 'Отправить', 300, NULL, NULL, 'N', '', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_feedback_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(11, '2024-11-29 00:22:31', 'Купить в 1 клик', 'aspro_allcorp3resort_quick_buy_s1', 'Отправить', 300, NULL, NULL, 'N', NULL, 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_quick_buy_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL),
(12, '2024-11-29 00:22:31', 'Забронировать тур', 'aspro_allcorp3resort_tour_s1', 'Отправить', 300, NULL, NULL, 'N', 'Менеджеры базы отдыха подробно расскажут об условиях проживания, услугах, ценах и акциях. Ответят на любые ваши вопросы. ', 'text', NULL, 'Y', NULL, 'FORM_FILLING_aspro_allcorp3resort_tour_s1', NULL, NULL, NULL, NULL, NULL, 'N', 0, 0, NULL, 'form', '', NULL);
-- -----------------------------------
-- Dumping table b_form_2_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_2_group`;
CREATE TABLE `b_form_2_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `GROUP_ID` int NOT NULL DEFAULT '0',
  `PERMISSION` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_2_group` VALUES
(1, 1, 2, 10),
(2, 2, 2, 10),
(3, 3, 2, 10),
(4, 4, 2, 10),
(5, 5, 2, 10),
(6, 6, 2, 10),
(7, 7, 2, 10),
(8, 8, 2, 10),
(9, 9, 2, 10),
(10, 10, 2, 10),
(11, 11, 2, 10),
(12, 12, 2, 10);
-- -----------------------------------
-- Dumping table b_form_2_mail_template
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_2_mail_template`;
CREATE TABLE `b_form_2_mail_template` (
  `FORM_ID` int NOT NULL DEFAULT '0',
  `MAIL_TEMPLATE_ID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`FORM_ID`,`MAIL_TEMPLATE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_2_mail_template` VALUES
(1, 51),
(2, 52),
(3, 53),
(4, 54),
(5, 55),
(6, 56),
(7, 57),
(8, 58),
(9, 59),
(10, 60),
(11, 61),
(12, 62);
-- -----------------------------------
-- Dumping table b_form_2_site
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_2_site`;
CREATE TABLE `b_form_2_site` (
  `FORM_ID` int NOT NULL DEFAULT '0',
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`FORM_ID`,`SITE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_2_site` VALUES
(1, 's1'),
(2, 's1'),
(3, 's1'),
(4, 's1'),
(5, 's1'),
(6, 's1'),
(7, 's1'),
(8, 's1'),
(9, 's1'),
(10, 's1'),
(11, 's1'),
(12, 's1');
-- -----------------------------------
-- Dumping table b_form_answer
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_answer`;
CREATE TABLE `b_form_answer` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FIELD_ID` int NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `MESSAGE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `C_SORT` int NOT NULL DEFAULT '100',
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FIELD_TYPE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `FIELD_WIDTH` int DEFAULT NULL,
  `FIELD_HEIGHT` int DEFAULT NULL,
  `FIELD_PARAM` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `IX_FIELD_ID` (`FIELD_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_answer` VALUES
(1, 1, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(2, 2, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(3, 3, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(4, 4, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(5, 5, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(6, 6, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(7, 7, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(8, 8, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'hidden', 0, 0, ''),
(9, 9, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'hidden', 0, 0, ''),
(10, 10, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(11, 11, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(12, 12, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(13, 13, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, 'col-6'),
(14, 14, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\" col-6'),
(15, 15, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'date', 0, 0, 'col-6'),
(16, 16, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'date', 0, 0, 'col-6'),
(17, 17, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, 'col-6'),
(18, 18, '2023-04-27 00:10:28', '1', 100, 'Y', '', 'dropdown', 0, 0, 'col-6'),
(19, 18, '2023-04-27 00:10:28', '2', 100, 'Y', '', 'dropdown', 0, 0, 'col-6'),
(20, 18, '2023-04-27 00:10:28', '3', 100, 'Y', '', 'dropdown', 0, 0, 'col-6'),
(21, 18, '2023-04-27 00:10:28', '4', 100, 'Y', '', 'dropdown', 0, 0, 'col-6'),
(22, 19, '2023-04-27 00:10:28', 'Экскурсия', 100, 'Y', '', 'checkbox', 0, 0, ''),
(23, 19, '2023-04-27 00:10:28', 'Питание', 100, 'Y', '', 'checkbox', 0, 0, ''),
(24, 19, '2023-04-27 00:10:28', 'Трансфер', 100, 'Y', '', 'checkbox', 0, 0, ''),
(25, 19, '2023-04-27 00:10:28', 'Санузел / душ', 100, 'Y', '', 'checkbox', 0, 0, ''),
(26, 20, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(27, 21, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(28, 22, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(29, 23, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(30, 24, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(31, 25, '2023-04-27 00:10:28', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(32, 26, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(33, 27, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(34, 28, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(35, 29, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(36, 30, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(37, 31, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(38, 32, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(39, 33, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(40, 34, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(41, 35, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(42, 36, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'file', 0, 0, ''),
(43, 37, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(44, 38, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(45, 39, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(46, 40, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(47, 41, '2023-04-27 00:10:29', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(48, 42, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(49, 43, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(50, 44, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(51, 45, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(52, 46, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(53, 47, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(54, 48, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'hidden', 0, 0, ''),
(55, 49, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(56, 50, '2023-04-27 00:10:30', ' ', 1, 'Y', '', 'text', 0, 0, ''),
(57, 51, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(58, 52, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(59, 53, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(60, 54, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(61, 55, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'file', 0, 0, ''),
(62, 56, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'file', 0, 0, ''),
(63, 57, '2023-04-27 00:10:30', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(64, 58, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(65, 59, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(66, 60, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(67, 61, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'hidden', 0, 0, ''),
(68, 62, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'hidden', 0, 0, ''),
(69, 63, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'textarea', 0, 0, ''),
(70, 64, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(71, 65, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'text', 0, 0, 'class=\"phone\"'),
(72, 66, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'email', 0, 0, ''),
(73, 67, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'text', 0, 0, ''),
(74, 68, '2023-04-27 00:10:31', ' ', 100, 'Y', '', 'textarea', 0, 0, '');
-- -----------------------------------
-- Dumping table b_form_crm
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_crm`;
CREATE TABLE `b_form_crm` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'Y',
  `URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `AUTH_HASH` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form_crm_field
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_crm_field`;
CREATE TABLE `b_form_crm_field` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_ID` int NOT NULL DEFAULT '0',
  `FIELD_ID` int DEFAULT '0',
  `FIELD_ALT` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '',
  `CRM_FIELD` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `ix_b_form_crm_field_1` (`LINK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form_crm_link
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_crm_link`;
CREATE TABLE `b_form_crm_link` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `CRM_ID` int NOT NULL DEFAULT '0',
  `LINK_TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'M',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ux_b_form_crm_link_1` (`FORM_ID`,`CRM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form_field
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_field`;
CREATE TABLE `b_form_field` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `TITLE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `TITLE_TYPE` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `SID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `C_SORT` int NOT NULL DEFAULT '100',
  `ADDITIONAL` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `REQUIRED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_FILTER` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_RESULTS_TABLE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IN_EXCEL_TABLE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `FIELD_TYPE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IMAGE_ID` int DEFAULT NULL,
  `COMMENTS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `FILTER_TITLE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `RESULTS_TABLE_TITLE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`),
  KEY `IX_SID` (`SID`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_field` VALUES
(1, 1, '2023-04-27 00:10:28', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(2, 1, '2023-04-27 00:10:28', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(3, 1, '2023-04-27 00:10:28', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(4, 1, '2023-04-27 00:10:28', 'Y', 'Название компании', 'text', 'COMPANY', 400, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(5, 1, '2023-04-27 00:10:28', 'Y', 'Адрес доставки', 'text', 'ADDRESS', 500, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(6, 1, '2023-04-27 00:10:28', 'Y', 'Комментарий к заказу', 'text', 'MESSAGE', 600, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(7, 1, '2023-04-27 00:10:28', 'Y', 'Состав заказа', 'text', 'ORDER_LIST', 600, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(8, 1, '2023-04-27 00:10:28', 'Y', 'SESSION_ID', 'text', 'SESSION_ID', 600, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(9, 1, '2023-04-27 00:10:28', 'Y', 'TOTAL_SUMM ', 'text', 'TOTAL_SUMM', 600, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(10, 2, '2023-04-27 00:10:28', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(11, 2, '2023-04-27 00:10:28', 'Y', 'Тема', 'text', 'TITLE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(12, 2, '2023-04-27 00:10:28', 'Y', 'Сообщение', 'text', 'MESSAGE', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(13, 3, '2023-04-27 00:10:28', 'Y', 'Имя и фамилия', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(14, 3, '2023-04-27 00:10:28', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(15, 3, '2023-04-27 00:10:28', 'Y', 'Дата приезда', 'text', 'FROM', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(16, 3, '2023-04-27 00:10:28', 'Y', 'Дата отъезда', 'text', 'TO', 400, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(17, 3, '2023-04-27 00:10:28', 'Y', 'Тип проживания', 'text', 'PRODUCT', 500, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(18, 3, '2023-04-27 00:10:28', 'Y', 'Количество человек', 'text', 'NUMBERS', 600, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(19, 3, '2023-04-27 00:10:28', 'Y', 'Дополнительные услуги', 'text', 'SERVICES', 700, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(20, 3, '2023-04-27 00:10:28', 'Y', 'Сообщение', 'text', 'MESSAGE', 800, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(21, 4, '2023-04-27 00:10:28', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(22, 4, '2023-04-27 00:10:28', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(23, 4, '2023-04-27 00:10:28', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(24, 4, '2023-04-27 00:10:28', 'Y', 'Проект', 'text', 'PROJECT', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(25, 4, '2023-04-27 00:10:28', 'Y', 'Сообщение', 'text', 'MESSAGE', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(26, 5, '2023-04-27 00:10:29', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(27, 5, '2023-04-27 00:10:29', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(28, 5, '2023-04-27 00:10:29', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(29, 5, '2023-04-27 00:10:29', 'Y', 'Услуга', 'text', 'SERVICE', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(30, 5, '2023-04-27 00:10:29', 'Y', 'Сообщение', 'text', 'MESSAGE', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(31, 6, '2023-04-27 00:10:29', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(32, 6, '2023-04-27 00:10:29', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(33, 6, '2023-04-27 00:10:29', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(34, 6, '2023-04-27 00:10:29', 'Y', 'Желаемая должность', 'text', 'POST', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(35, 6, '2023-04-27 00:10:29', 'Y', 'Дополнительная информация', 'text', 'MESSAGE', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(36, 6, '2023-04-27 00:10:29', 'Y', 'Файл с резюме', 'text', 'FILE', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(37, 7, '2023-04-27 00:10:29', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(38, 7, '2023-04-27 00:10:29', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(39, 7, '2023-04-27 00:10:29', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(40, 7, '2023-04-27 00:10:29', 'Y', 'Интересующий товар/услуга', 'text', 'NEED_PRODUCT', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(41, 7, '2023-04-27 00:10:29', 'Y', 'Сообщение', 'text', 'MESSAGE', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(42, 8, '2023-04-27 00:10:30', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(43, 8, '2023-04-27 00:10:30', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(44, 9, '2023-04-27 00:10:30', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(45, 9, '2023-04-27 00:10:30', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(46, 9, '2023-04-27 00:10:30', 'Y', 'E-mail', 'text', 'EMAIL', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(47, 9, '2023-04-27 00:10:30', 'Y', 'Сотрудник', 'text', 'STAFF', 200, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(48, 9, '2023-04-27 00:10:30', 'Y', 'Email сотрудника', 'text', 'STAFF_EMAIL_HIDDEN', 200, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(49, 9, '2023-04-27 00:10:30', 'Y', 'Сообщение', 'text', 'MESSAGE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(50, 10, '2023-04-27 00:10:30', 'Y', 'Ваша оценка', 'text', 'RATING', 1, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(51, 10, '2023-04-27 00:10:30', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(52, 10, '2023-04-27 00:10:30', 'Y', 'Телефон', 'text', 'PHONE', 310, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(53, 10, '2023-04-27 00:10:30', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(54, 10, '2023-04-27 00:10:30', 'Y', 'Должность', 'text', 'POST', 110, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(55, 10, '2023-04-27 00:10:30', 'Y', 'Файл', 'text', 'FILE', 10, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(56, 10, '2023-04-27 00:10:30', 'Y', 'Ваша фотография', 'text', 'PHOTO', 8, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(57, 10, '2023-04-27 00:10:30', 'Y', 'Сообщение', 'text', 'MESSAGE', 2, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(58, 11, '2023-04-27 00:10:31', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(59, 11, '2023-04-27 00:10:31', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(60, 11, '2023-04-27 00:10:31', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(61, 11, '2023-04-27 00:10:31', 'Y', 'Продукт', 'text', 'PRODUCT_NAME', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(62, 11, '2023-04-27 00:10:31', 'Y', 'Цена продукта', 'text', 'PRODUCT_PRICE', 400, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(63, 11, '2023-04-27 00:10:31', 'Y', 'Сообщение', 'text', 'MESSAGE', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(64, 12, '2023-04-27 00:10:31', 'Y', 'Ваше имя', 'text', 'NAME', 100, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(65, 12, '2023-04-27 00:10:31', 'Y', 'Телефон', 'text', 'PHONE', 200, 'N', 'Y', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(66, 12, '2023-04-27 00:10:31', 'Y', 'E-mail', 'text', 'EMAIL', 300, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(67, 12, '2023-04-27 00:10:31', 'Y', 'Тур', 'text', 'PRODUCT', 400, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL),
(68, 12, '2023-04-27 00:10:31', 'Y', 'Сообщение', 'text', 'MESSAGE', 500, 'N', 'N', 'N', 'N', 'Y', NULL, NULL, NULL, NULL, NULL);
-- -----------------------------------
-- Dumping table b_form_field_filter
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_field_filter`;
CREATE TABLE `b_form_field_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FIELD_ID` int NOT NULL DEFAULT '0',
  `PARAMETER_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FILTER_TYPE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FIELD_ID` (`FIELD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form_field_validator
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_field_validator`;
CREATE TABLE `b_form_field_validator` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `FIELD_ID` int NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'y',
  `C_SORT` int DEFAULT '100',
  `VALIDATOR_SID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `PARAMS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`),
  KEY `IX_FIELD_ID` (`FIELD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_form_menu
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_menu`;
CREATE TABLE `b_form_menu` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `MENU` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_menu` VALUES
(1, 1, 'ru', 'Оформление заказа'),
(2, 2, 'ru', 'Написать директору'),
(3, 3, 'ru', 'Забронировать'),
(4, 4, 'ru', 'Заказать проект'),
(5, 5, 'ru', 'Заказать услугу'),
(6, 6, 'ru', 'Отправить резюме'),
(7, 7, 'ru', 'Задать вопрос'),
(8, 8, 'ru', 'Заказать звонок'),
(9, 9, 'ru', 'Написать сотруднику'),
(10, 10, 'ru', 'Оставить отзыв'),
(11, 11, 'ru', 'Купить в 1 клик'),
(12, 12, 'ru', 'Забронировать тур');
-- -----------------------------------
-- Dumping table b_form_result
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_result`;
CREATE TABLE `b_form_result` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `STATUS_ID` int NOT NULL DEFAULT '0',
  `FORM_ID` int NOT NULL DEFAULT '0',
  `USER_ID` int DEFAULT NULL,
  `USER_AUTH` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `STAT_GUEST_ID` int DEFAULT NULL,
  `STAT_SESSION_ID` int DEFAULT NULL,
  `SENT_TO_CRM` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'N',
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`),
  KEY `IX_STATUS_ID` (`STATUS_ID`),
  KEY `IX_SENT_TO_CRM` (`SENT_TO_CRM`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_result` VALUES
(1, '2023-12-29 08:47:46', '2023-12-29 08:47:46', 7, 7, 0, 'N', 0, 0, 'N'),
(2, '2024-01-09 14:56:34', '2024-01-09 14:56:34', 7, 7, 0, 'N', 0, 0, 'N'),
(3, '2024-02-21 11:45:52', '2024-02-21 11:45:52', 3, 3, 0, 'N', 0, 0, 'N'),
(4, '2024-02-26 14:08:23', '2024-02-26 14:08:23', 3, 3, 0, 'N', 0, 0, 'N'),
(5, '2024-02-28 18:31:32', '2024-02-28 18:31:32', 7, 7, 0, 'N', 0, 0, 'N'),
(6, '2024-02-29 10:52:55', '2024-02-29 10:52:55', 3, 3, 0, 'N', 0, 0, 'N'),
(7, '2024-03-02 22:40:45', '2024-03-02 22:40:45', 7, 7, 0, 'N', 0, 0, 'N'),
(8, '2024-03-07 11:54:33', '2024-03-07 11:54:33', 7, 7, 0, 'N', 0, 0, 'N'),
(9, '2024-03-15 15:01:38', '2024-03-15 15:01:38', 7, 7, 0, 'N', 0, 0, 'N'),
(10, '2024-04-04 14:12:30', '2024-04-04 14:12:30', 7, 7, 0, 'N', 0, 0, 'N'),
(11, '2024-04-04 14:13:31', '2024-04-04 14:13:31', 8, 8, 0, 'N', 0, 0, 'N'),
(12, '2024-04-04 14:14:26', '2024-04-04 14:14:26', 3, 3, 0, 'N', 0, 0, 'N'),
(13, '2024-04-22 15:28:54', '2024-04-22 15:28:54', 7, 7, 0, 'N', 0, 0, 'N'),
(14, '2024-04-24 16:01:05', '2024-04-24 16:01:05', 3, 3, 0, 'N', 0, 0, 'N'),
(15, '2024-04-25 17:50:37', '2024-04-25 17:50:37', 3, 3, 0, 'N', 0, 0, 'N'),
(16, '2024-05-04 18:19:32', '2024-05-04 18:19:32', 7, 7, 0, 'N', 0, 0, 'N'),
(17, '2024-05-12 12:03:20', '2024-05-12 12:03:20', 3, 3, 0, 'N', 0, 0, 'N'),
(18, '2024-05-15 16:27:56', '2024-05-15 16:27:56', 3, 3, 0, 'N', 0, 0, 'N'),
(19, '2024-05-19 14:13:00', '2024-05-19 14:13:00', 3, 3, 0, 'N', 0, 0, 'N'),
(20, '2024-05-23 14:31:08', '2024-05-23 14:31:08', 3, 3, 0, 'N', 0, 0, 'N'),
(21, '2024-06-01 18:22:37', '2024-06-01 18:22:37', 3, 3, 0, 'N', 0, 0, 'N'),
(22, '2024-06-07 13:47:06', '2024-06-07 13:47:06', 3, 3, 0, 'N', 0, 0, 'N'),
(23, '2024-06-08 13:39:40', '2024-06-08 13:39:40', 3, 3, 0, 'N', 0, 0, 'N'),
(24, '2024-06-12 15:19:54', '2024-06-12 15:19:54', 3, 3, 0, 'N', 0, 0, 'N'),
(25, '2024-06-15 12:52:07', '2024-06-15 12:52:07', 7, 7, 0, 'N', 0, 0, 'N'),
(26, '2024-06-17 07:28:43', '2024-06-17 07:28:43', 7, 7, 0, 'N', 0, 0, 'N'),
(27, '2024-06-18 18:58:54', '2024-06-18 18:58:54', 3, 3, 0, 'N', 0, 0, 'N'),
(28, '2024-06-27 16:24:12', '2024-06-27 16:24:12', 7, 7, 0, 'N', 0, 0, 'N'),
(29, '2024-06-27 16:28:31', '2024-06-27 16:28:31', 3, 3, 0, 'N', 0, 0, 'N'),
(30, '2024-07-02 14:12:01', '2024-07-02 14:12:01', 8, 8, 0, 'N', 0, 0, 'N'),
(31, '2024-07-04 11:41:21', '2024-07-04 11:41:21', 3, 3, 0, 'N', 0, 0, 'N'),
(32, '2024-07-07 08:00:23', '2024-07-07 08:00:23', 3, 3, 0, 'N', 0, 0, 'N'),
(33, '2024-07-08 07:34:30', '2024-07-08 07:34:30', 3, 3, 0, 'N', 0, 0, 'N'),
(34, '2024-07-08 18:30:06', '2024-07-08 18:30:06', 3, 3, 0, 'N', 0, 0, 'N'),
(35, '2024-07-10 23:10:18', '2024-07-10 23:10:18', 3, 3, 0, 'N', 0, 0, 'N'),
(36, '2024-07-15 19:09:29', '2024-07-15 19:09:29', 3, 3, 0, 'N', 0, 0, 'N'),
(37, '2024-07-16 15:29:12', '2024-07-16 15:29:12', 8, 8, 0, 'N', 0, 0, 'N'),
(38, '2024-07-17 08:45:14', '2024-07-17 08:45:14', 8, 8, 0, 'N', 0, 0, 'N'),
(39, '2024-07-18 21:02:35', '2024-07-18 21:02:35', 3, 3, 0, 'N', 0, 0, 'N'),
(40, '2024-07-20 14:41:13', '2024-07-20 14:41:13', 3, 3, 0, 'N', 0, 0, 'N'),
(41, '2024-07-20 22:08:27', '2024-07-20 22:08:27', 7, 7, 0, 'N', 0, 0, 'N'),
(42, '2024-07-26 22:29:26', '2024-07-26 22:29:26', 3, 3, 0, 'N', 0, 0, 'N'),
(43, '2024-08-05 16:06:38', '2024-08-05 16:06:38', 3, 3, 0, 'N', 0, 0, 'N'),
(44, '2024-08-08 22:00:10', '2024-08-08 22:00:10', 7, 7, 0, 'N', 0, 0, 'N'),
(45, '2024-08-09 12:47:32', '2024-08-09 12:47:32', 3, 3, 0, 'N', 0, 0, 'N'),
(46, '2024-08-09 13:34:57', '2024-08-09 13:34:57', 8, 8, 0, 'N', 0, 0, 'N'),
(47, '2024-08-09 18:00:58', '2024-08-09 18:00:58', 8, 8, 0, 'N', 0, 0, 'N'),
(48, '2024-08-10 07:21:43', '2024-08-10 07:21:43', 3, 3, 0, 'N', 0, 0, 'N'),
(49, '2024-08-13 14:42:08', '2024-08-13 14:42:08', 3, 3, 0, 'N', 0, 0, 'N'),
(50, '2024-08-13 23:55:04', '2024-08-13 23:55:04', 3, 3, 0, 'N', 0, 0, 'N'),
(51, '2024-08-14 11:30:11', '2024-08-14 11:30:11', 8, 8, 0, 'N', 0, 0, 'N'),
(52, '2024-08-14 22:14:58', '2024-08-14 22:14:58', 7, 7, 0, 'N', 0, 0, 'N'),
(53, '2024-08-22 11:40:42', '2024-08-22 11:40:42', 7, 7, 0, 'N', 0, 0, 'N'),
(54, '2024-08-29 09:59:04', '2024-08-29 09:59:04', 3, 3, 0, 'N', 0, 0, 'N'),
(55, '2025-01-03 20:31:55', '2025-01-03 20:31:55', 8, 8, 0, 'N', 0, 0, 'N'),
(56, '2025-01-10 17:40:35', '2025-01-10 17:40:35', 3, 3, 0, 'N', 0, 0, 'N'),
(57, '2025-01-10 17:42:27', '2025-01-10 17:42:27', 3, 3, 0, 'N', 0, 0, 'N'),
(58, '2025-01-10 17:43:33', '2025-01-10 17:43:33', 8, 8, 0, 'N', 0, 0, 'N'),
(59, '2025-01-15 10:50:53', '2025-01-15 10:50:53', 7, 7, 0, 'N', 0, 0, 'N');
-- -----------------------------------
-- Dumping table b_form_result_answer
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_result_answer`;
CREATE TABLE `b_form_result_answer` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `RESULT_ID` int NOT NULL DEFAULT '0',
  `FORM_ID` int NOT NULL DEFAULT '0',
  `FIELD_ID` int NOT NULL DEFAULT '0',
  `ANSWER_ID` int DEFAULT NULL,
  `ANSWER_TEXT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `ANSWER_TEXT_SEARCH` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `ANSWER_VALUE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ANSWER_VALUE_SEARCH` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USER_TEXT` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USER_TEXT_SEARCH` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USER_DATE` datetime DEFAULT NULL,
  `USER_FILE_ID` int DEFAULT NULL,
  `USER_FILE_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_FILE_IS_IMAGE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_FILE_HASH` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_FILE_SUFFIX` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USER_FILE_SIZE` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_RESULT_ID` (`RESULT_ID`),
  KEY `IX_FIELD_ID` (`FIELD_ID`),
  KEY `IX_ANSWER_ID` (`ANSWER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=381 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_result_answer` VALUES
(1, 1, 7, 37, 43, '', NULL, '', NULL, 'ксения', 'КСЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 1, 7, 38, 44, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 1, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(4, 1, 7, 40, 46, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 1, 7, 41, 47, '', NULL, '', NULL, 'Хочу забронировать дом на 01.07.2024 на 7 дней,\r\nесть свободные домики?', 'ХОЧУ ЗАБРОНИРОВАТЬ ДОМ НА 01.07.2024 НА 7 ДНЕЙ,\r\nЕСТЬ СВОБОДНЫЕ ДОМИКИ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 2, 7, 37, 43, '', NULL, '', NULL, 'Кузнецова Наталия Юрьевна', 'КУЗНЕЦОВА НАТАЛИЯ ЮРЬЕВНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, 2, 7, 38, 44, '', NULL, '', NULL, '+7 (921) 357-77-17', '+7 (921) 357-77-17', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 2, 7, 39, 45, '', NULL, '', NULL, 'kuzik0502@yandex.ru', 'KUZIK0502@YANDEX.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(9, 2, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(10, 2, 7, 41, 47, '', NULL, '', NULL, 'Отдых для 2- х взрослых и 2- х детей (14 лет и 5 лет)\r\nКонец июля (26-29 июля) на 13 дней ', 'ОТДЫХ ДЛЯ 2- Х ВЗРОСЛЫХ И 2- Х ДЕТЕЙ (14 ЛЕТ И 5 ЛЕТ)\r\nКОНЕЦ ИЮЛЯ (26-29 ИЮЛЯ) НА 13 ДНЕЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(11, 3, 3, 13, 13, '', NULL, '', NULL, 'Елена Бабаева', 'ЕЛЕНА БАБАЕВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(12, 3, 3, 14, 14, '', NULL, '', NULL, '+7 (977) 962-35-42', '+7 (977) 962-35-42', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(13, 3, 3, 15, 15, '', NULL, '', NULL, '16.08.2024 10:0', '16.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(14, 3, 3, 16, 16, '', NULL, '', NULL, '30.08.2024 10:8', '30.08.2024 10:8', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(15, 3, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(16, 3, 3, 18, 20, '3', '3', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(17, 3, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(18, 3, 3, 20, 26, '', NULL, '', NULL, 'Добрый день, подскажите стоимость (2 вз+1 ребенок 13 лет)', 'ДОБРЫЙ ДЕНЬ, ПОДСКАЖИТЕ СТОИМОСТЬ (2 ВЗ+1 РЕБЕНОК 13 ЛЕТ)', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(19, 4, 3, 13, 13, '', NULL, '', NULL, 'нурадилова ксения', 'НУРАДИЛОВА КСЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(20, 4, 3, 14, 14, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(21, 4, 3, 15, 15, '', NULL, '', NULL, '01.07.2024 12:0', '01.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(22, 4, 3, 16, 16, '', NULL, '', NULL, '10.07.2024 12:0', '10.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(23, 4, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(24, 4, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(25, 4, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(26, 4, 3, 20, 26, '', NULL, '', NULL, 'сообщите о статусе бронирования, и хотела бы добавть питание', 'СООБЩИТЕ О СТАТУСЕ БРОНИРОВАНИЯ, И ХОТЕЛА БЫ ДОБАВТЬ ПИТАНИЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(27, 5, 7, 37, 43, '', NULL, '', NULL, 'Гамзаева Лейла', 'ГАМЗАЕВА ЛЕЙЛА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(28, 5, 7, 38, 44, '', NULL, '', NULL, '+7 (926) 148-87-20', '+7 (926) 148-87-20', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(29, 5, 7, 39, 45, '', NULL, '', NULL, 'Leyla_gamzaeva@mail.ru', 'LEYLA_GAMZAEVA@MAIL.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(30, 5, 7, 40, 46, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(31, 5, 7, 41, 47, '', NULL, '', NULL, 'Подскажите стоимость проживания в августе ', 'ПОДСКАЖИТЕ СТОИМОСТЬ ПРОЖИВАНИЯ В АВГУСТЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(32, 6, 3, 13, 13, '', NULL, '', NULL, 'Лейла', 'ЛЕЙЛА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(33, 6, 3, 14, 14, '', NULL, '', NULL, '+7 (926) 148-87-20', '+7 (926) 148-87-20', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(34, 6, 3, 15, 15, '', NULL, '', NULL, '08.08.2024 10:0', '08.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(35, 6, 3, 16, 16, '', NULL, '', NULL, '22.08.2024 12:0', '22.08.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(36, 6, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(37, 6, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(38, 6, 3, 20, 26, '', NULL, '', NULL, 'Аренда коттеджа', 'АРЕНДА КОТТЕДЖА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(39, 7, 7, 37, 43, '', NULL, '', NULL, 'Виктория ', 'ВИКТОРИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(40, 7, 7, 38, 44, '', NULL, '', NULL, '+7 (925) 480-83-80', '+7 (925) 480-83-80', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(41, 7, 7, 39, 45, '', NULL, '', NULL, '07armadas_yellows@icloud.com', '07ARMADAS_YELLOWS@ICLOUD.COM', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(42, 7, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(43, 7, 7, 41, 47, '', NULL, '', NULL, 'Здравствуйте! Хотела бы уточнить, стоимость и есть ли свободные домики с 12 по 18 августа на двоих? Есть домики на двоих?', 'ЗДРАВСТВУЙТЕ! ХОТЕЛА БЫ УТОЧНИТЬ, СТОИМОСТЬ И ЕСТЬ ЛИ СВОБОДНЫЕ ДОМИКИ С 12 ПО 18 АВГУСТА НА ДВОИХ? ЕСТЬ ДОМИКИ НА ДВОИХ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(44, 8, 7, 37, 43, '', NULL, '', NULL, 'Лиля', 'ЛИЛЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(45, 8, 7, 38, 44, '', NULL, '', NULL, '+7 (927) 036-88-81', '+7 (927) 036-88-81', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(46, 8, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(47, 8, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(48, 8, 7, 41, 47, '', NULL, '', NULL, 'Как с вами можно связаться? Недоступен телефон.', 'КАК С ВАМИ МОЖНО СВЯЗАТЬСЯ? НЕДОСТУПЕН ТЕЛЕФОН.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(49, 9, 7, 37, 43, '', NULL, '', NULL, 'ксения', 'КСЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(50, 9, 7, 38, 44, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(51, 9, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(52, 9, 7, 40, 46, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(53, 9, 7, 41, 47, '', NULL, '', NULL, 'хочу забронировать дом в июле', 'ХОЧУ ЗАБРОНИРОВАТЬ ДОМ В ИЮЛЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(54, 10, 7, 37, 43, '', NULL, '', NULL, 'Алавдин', 'АЛАВДИН', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(55, 10, 7, 38, 44, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(56, 10, 7, 39, 45, '', NULL, '', NULL, 'ksysha898214@mail.ru', 'KSYSHA898214@MAIL.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(57, 10, 7, 40, 46, '', NULL, '', NULL, 'Бронирование город моря ', 'БРОНИРОВАНИЕ ГОРОД МОРЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(58, 10, 7, 41, 47, '', NULL, '', NULL, 'Хочу забронировать дом с 01.07. на 10 дней ', 'ХОЧУ ЗАБРОНИРОВАТЬ ДОМ С 01.07. НА 10 ДНЕЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(59, 11, 8, 42, 48, '', NULL, '', NULL, 'алавдин', 'АЛАВДИН', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(60, 11, 8, 43, 49, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(61, 12, 3, 13, 13, '', NULL, '', NULL, 'ксения', 'КСЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(62, 12, 3, 14, 14, '', NULL, '', NULL, '+7 (982) 140-80-08', '+7 (982) 140-80-08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(63, 12, 3, 15, 15, '', NULL, '', NULL, '01.07.2024 12:0', '01.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(64, 12, 3, 16, 16, '', NULL, '', NULL, '10.07.2024 10:0', '10.07.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(65, 12, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(66, 12, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(67, 12, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(68, 12, 3, 20, 26, '', NULL, '', NULL, 'завтраки ', 'ЗАВТРАКИ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(69, 13, 7, 37, 43, '', NULL, '', NULL, 'Алёна', 'АЛЁНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(70, 13, 7, 38, 44, '', NULL, '', NULL, '+7 (926) 433-26-86', '+7 (926) 433-26-86', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(71, 13, 7, 39, 45, '', NULL, '', NULL, 'alenaalpeeva1994@mail.ru', 'ALENAALPEEVA1994@MAIL.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(72, 13, 7, 40, 46, '', NULL, '', NULL, 'город моря', 'ГОРОД МОРЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(73, 13, 7, 41, 47, '', NULL, '', NULL, 'Добрый день, подскажите пожалуйста стоимость проживания на базе отдыха \"Город моря\" с 20.06 по 28.06 в номерах эконом, комфорт и коттедж, для 2-х взрослых и ребенка 5-ти лет.', 'ДОБРЫЙ ДЕНЬ, ПОДСКАЖИТЕ ПОЖАЛУЙСТА СТОИМОСТЬ ПРОЖИВАНИЯ НА БАЗЕ ОТДЫХА \"ГОРОД МОРЯ\" С 20.06 ПО 28.06 В НОМЕРАХ ЭКОНОМ, КОМФОРТ И КОТТЕДЖ, ДЛЯ 2-Х ВЗРОСЛЫХ И РЕБЕНКА 5-ТИ ЛЕТ.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(74, 14, 3, 13, 13, '', NULL, '', NULL, 'Аполлонова Татьяна', 'АПОЛЛОНОВА ТАТЬЯНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(75, 14, 3, 14, 14, '', NULL, '', NULL, '+7 (903) 132-06-20', '+7 (903) 132-06-20', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(76, 14, 3, 15, 15, '', NULL, '', NULL, '19.08.2024 10:0', '19.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(77, 14, 3, 16, 16, '', NULL, '', NULL, '27.08.2024 10:0', '27.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(78, 14, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(79, 14, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(80, 14, 3, 19, 22, 'Экскурсия', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(81, 14, 3, 19, 23, 'Питание', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(82, 14, 3, 19, 24, 'Трансфер', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(83, 14, 3, 19, 25, 'Санузел / душ', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(84, 14, 3, 20, 26, '', NULL, '', NULL, 'Добрый день. Предварительная бронь номера, возможно потребуется еще один номер, билеты еще не куплены, поэтому даты могут изменится. Есть возможность ознакомиться с меню?', 'ДОБРЫЙ ДЕНЬ. ПРЕДВАРИТЕЛЬНАЯ БРОНЬ НОМЕРА, ВОЗМОЖНО ПОТРЕБУЕТСЯ ЕЩЕ ОДИН НОМЕР, БИЛЕТЫ ЕЩЕ НЕ КУПЛЕНЫ, ПОЭТОМУ ДАТЫ МОГУТ ИЗМЕНИТСЯ. ЕСТЬ ВОЗМОЖНОСТЬ ОЗНАКОМИТЬСЯ С МЕНЮ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(85, 15, 3, 13, 13, '', NULL, '', NULL, 'Илья Ведерников', 'ИЛЬЯ ВЕДЕРНИКОВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(86, 15, 3, 14, 14, '', NULL, '', NULL, '+7 (987) 927-62-96', '+7 (987) 927-62-96', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(87, 15, 3, 15, 15, '', NULL, '', NULL, '25.04.2024 2:0', '25.04.2024 2:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(88, 15, 3, 16, 16, '', NULL, '', NULL, '26.04.2024 10:9', '26.04.2024 10:9', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(89, 15, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(90, 15, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(91, 15, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(92, 15, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(93, 15, 3, 20, 26, '', NULL, '', NULL, '1 взрослый и ребенок 8 лет', '1 ВЗРОСЛЫЙ И РЕБЕНОК 8 ЛЕТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(94, 16, 7, 37, 43, '', NULL, '', NULL, 'Сергей', 'СЕРГЕЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(95, 16, 7, 38, 44, '', NULL, '', NULL, '+7 (902) 781-15-60', '+7 (902) 781-15-60', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(96, 16, 7, 39, 45, '', NULL, '', NULL, 'sergey.cymbalov@mail.ru', 'SERGEY.CYMBALOV@MAIL.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(97, 16, 7, 40, 46, '', NULL, '', NULL, 'отдых с 10 по 20.08.24г.', 'ОТДЫХ С 10 ПО 20.08.24Г.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(98, 16, 7, 41, 47, '', NULL, '', NULL, 'Сколько стоимость проживания', 'СКОЛЬКО СТОИМОСТЬ ПРОЖИВАНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(99, 17, 3, 13, 13, '', NULL, '', NULL, 'Маргарита Тарбаева ', 'МАРГАРИТА ТАРБАЕВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(100, 17, 3, 14, 14, '', NULL, '', NULL, '+7 (949) 376-15-81', '+7 (949) 376-15-81', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(101, 17, 3, 15, 15, '', NULL, '', NULL, '26.07.2024 10:0', '26.07.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(102, 17, 3, 16, 16, '', NULL, '', NULL, '31.07.2024 12:0', '31.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(103, 17, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(104, 17, 3, 18, 19, '2', '2', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(105, 17, 3, 19, 22, 'Экскурсия', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(106, 17, 3, 19, 23, 'Питание', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(107, 17, 3, 19, 25, 'Санузел / душ', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(108, 17, 3, 20, 26, '', NULL, '', NULL, 'Здравствуйте ', 'ЗДРАВСТВУЙТЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(109, 18, 3, 13, 13, '', NULL, '', NULL, 'Елена', 'ЕЛЕНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(110, 18, 3, 14, 14, '', NULL, '', NULL, '+7 (905) 570-27-22', '+7 (905) 570-27-22', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(111, 18, 3, 15, 15, '', NULL, '', NULL, '26.08.2024 12:5м', '26.08.2024 12:5М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(112, 18, 3, 16, 16, '', NULL, '', NULL, '08.09.2024 12:5м', '08.09.2024 12:5М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(113, 18, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(114, 18, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(115, 18, 3, 19, 23, 'Питание', 'ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(116, 18, 3, 19, 24, 'Трансфер', 'ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(117, 18, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(118, 18, 3, 20, 26, '', NULL, '', NULL, '2 взрослых +ребеноки5 лет ', '2 ВЗРОСЛЫХ +РЕБЕНОКИ5 ЛЕТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(119, 19, 3, 13, 13, '', NULL, '', NULL, 'Светлана Федотова', 'СВЕТЛАНА ФЕДОТОВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(120, 19, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 397-54-72', '+7 (916) 397-54-72', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(121, 19, 3, 15, 15, '', NULL, '', NULL, '23.05.2024 10:0', '23.05.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(122, 19, 3, 16, 16, '', NULL, '', NULL, '28.05.2024 10:0', '28.05.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(123, 19, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(124, 19, 3, 18, 18, '1', '1', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(125, 19, 3, 20, 26, '', NULL, '', NULL, 'О', 'О', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(126, 20, 3, 13, 13, '', NULL, '', NULL, 'Юрий Глазков', 'ЮРИЙ ГЛАЗКОВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(127, 20, 3, 14, 14, '', NULL, '', NULL, '+7 (928) 012-88-77', '+7 (928) 012-88-77', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(128, 20, 3, 15, 15, '', NULL, '', NULL, '29.06.2024 12:0', '29.06.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(129, 20, 3, 16, 16, '', NULL, '', NULL, '01.07.2024 12:0', '01.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(130, 20, 3, 17, 17, '', NULL, '', NULL, 'Комфорт', 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(131, 20, 3, 18, 19, '2', '2', '', NULL, NULL, 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(132, 20, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(133, 20, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(134, 20, 3, 20, 26, '', NULL, '', NULL, 'Добрый день! интересует номер комфорт на указанные даты. Время заезда и выезда примерно', 'ДОБРЫЙ ДЕНЬ! ИНТЕРЕСУЕТ НОМЕР КОМФОРТ НА УКАЗАННЫЕ ДАТЫ. ВРЕМЯ ЗАЕЗДА И ВЫЕЗДА ПРИМЕРНО', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(135, 21, 3, 13, 13, '', NULL, '', NULL, 'Виктор Бондаренко', 'ВИКТОР БОНДАРЕНКО', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(136, 21, 3, 14, 14, '', NULL, '', NULL, '+7 (923) 442-88-73', '+7 (923) 442-88-73', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(137, 21, 3, 15, 15, '', NULL, '', NULL, '29.06.2024 12:0', '29.06.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(138, 21, 3, 16, 16, '', NULL, '', NULL, '02.07.2024 12:0', '02.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(139, 21, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(140, 21, 3, 18, 18, '1', '1', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(141, 21, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(142, 21, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(143, 21, 3, 20, 26, '', NULL, '', NULL, 'Звонить с 9 утра до 19', 'ЗВОНИТЬ С 9 УТРА ДО 19', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(144, 22, 3, 13, 13, '', NULL, '', NULL, 'Юлия Пасечник', 'ЮЛИЯ ПАСЕЧНИК', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(145, 22, 3, 14, 14, '', NULL, '', NULL, '+7 (912) 439-25-68', '+7 (912) 439-25-68', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(146, 22, 3, 15, 15, '', NULL, '', NULL, '16.06.2024 10:0', '16.06.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(147, 22, 3, 16, 16, '', NULL, '', NULL, '28.06.2024 12:0', '28.06.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(148, 22, 3, 17, 17, '', NULL, '', NULL, 'Комфорт', 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(149, 22, 3, 18, 20, '3', '3', '', NULL, NULL, 'КОМФОРТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(150, 22, 3, 20, 26, '', NULL, '', NULL, 'Добрый день. Цель поездки отдых, 1 взрослый и двое детей 15 и 12 лет', 'ДОБРЫЙ ДЕНЬ. ЦЕЛЬ ПОЕЗДКИ ОТДЫХ, 1 ВЗРОСЛЫЙ И ДВОЕ ДЕТЕЙ 15 И 12 ЛЕТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(151, 23, 3, 13, 13, '', NULL, '', NULL, 'Диля Ефремова ', 'ДИЛЯ ЕФРЕМОВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(152, 23, 3, 14, 14, '', NULL, '', NULL, '+7 (909) 965-35-98', '+7 (909) 965-35-98', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(153, 23, 3, 15, 15, '', NULL, '', NULL, '06.07.2024 11:0', '06.07.2024 11:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(154, 23, 3, 16, 16, '', NULL, '', NULL, '14.07.2024 12:0', '14.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(155, 23, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(156, 23, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(157, 23, 3, 20, 26, '', NULL, '', NULL, 'Добрый день. Хочу забронировать номер, но не дает проставить даты. \r\nМне нужно с 06.07.2024 по  14.07.2024', 'ДОБРЫЙ ДЕНЬ. ХОЧУ ЗАБРОНИРОВАТЬ НОМЕР, НО НЕ ДАЕТ ПРОСТАВИТЬ ДАТЫ. \r\nМНЕ НУЖНО С 06.07.2024 ПО  14.07.2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(158, 24, 3, 13, 13, '', NULL, '', NULL, 'Андрей Ковнарев', 'АНДРЕЙ КОВНАРЕВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(159, 24, 3, 14, 14, '', NULL, '', NULL, '+7 (922) 248-25-16', '+7 (922) 248-25-16', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(160, 24, 3, 15, 15, '', NULL, '', NULL, '13.06.2024 12:59', '13.06.2024 12:59', '2024-06-13 12:59:00', NULL, NULL, NULL, NULL, NULL, NULL),
(161, 24, 3, 16, 16, '', NULL, '', NULL, '20.06.2024 10:0', '20.06.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(162, 24, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(163, 24, 3, 18, 19, '2', '2', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(164, 24, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(165, 24, 3, 20, 26, '', NULL, '', NULL, 'нужна консультация', 'НУЖНА КОНСУЛЬТАЦИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(166, 25, 7, 37, 43, '', NULL, '', NULL, 'Наиля', 'НАИЛЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(167, 25, 7, 38, 44, '', NULL, '', NULL, '+7 (917) 095-70-50', '+7 (917) 095-70-50', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(168, 25, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(169, 25, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(170, 25, 7, 41, 47, '', NULL, '', NULL, 'Добрый день. Еду я с ребенком 3 г. Какие варианты есть у вас для заселения и стоимость ? Интересует 7-10 июля', 'ДОБРЫЙ ДЕНЬ. ЕДУ Я С РЕБЕНКОМ 3 Г. КАКИЕ ВАРИАНТЫ ЕСТЬ У ВАС ДЛЯ ЗАСЕЛЕНИЯ И СТОИМОСТЬ ? ИНТЕРЕСУЕТ 7-10 ИЮЛЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(171, 26, 7, 37, 43, '', NULL, '', NULL, 'Варвара', 'ВАРВАРА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(172, 26, 7, 38, 44, '', NULL, '', NULL, '+7 (960) 969-29-82', '+7 (960) 969-29-82', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(173, 26, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(174, 26, 7, 40, 46, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(175, 26, 7, 41, 47, '', NULL, '', NULL, 'Здравствуйте!\r\nПриезжаем в отпуск с 20 по 29 июля. Хотели бы снять коттедж для 2-х взрослых и ребенка и номер комфорт для двух взрослых на базе отдыха \"Город моря\". Подскажите, есть такие варианты? ', 'ЗДРАВСТВУЙТЕ!\r\nПРИЕЗЖАЕМ В ОТПУСК С 20 ПО 29 ИЮЛЯ. ХОТЕЛИ БЫ СНЯТЬ КОТТЕДЖ ДЛЯ 2-Х ВЗРОСЛЫХ И РЕБЕНКА И НОМЕР КОМФОРТ ДЛЯ ДВУХ ВЗРОСЛЫХ НА БАЗЕ ОТДЫХА \"ГОРОД МОРЯ\". ПОДСКАЖИТЕ, ЕСТЬ ТАКИЕ ВАРИАНТЫ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(176, 27, 3, 13, 13, '', NULL, '', NULL, 'Бадалова Асият ', 'БАДАЛОВА АСИЯТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(177, 27, 3, 14, 14, '', NULL, '', NULL, '+7 (915) 001-54-49', '+7 (915) 001-54-49', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(178, 27, 3, 15, 15, '', NULL, '', NULL, '22.06.2024 11:0', '22.06.2024 11:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(179, 27, 3, 16, 16, '', NULL, '', NULL, '24.06.2024 12:0', '24.06.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(180, 27, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(181, 27, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(182, 27, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(183, 27, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(184, 27, 3, 20, 26, '', NULL, '', NULL, '.', '.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(185, 28, 7, 37, 43, '', NULL, '', NULL, 'Залина', 'ЗАЛИНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(186, 28, 7, 38, 44, '', NULL, '', NULL, '+7 (282) 653-00-00', '+7 (282) 653-00-00', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(187, 28, 7, 39, 45, '', NULL, '', NULL, 'zdzodzieva@yandex.ru', 'ZDZODZIEVA@YANDEX.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(188, 28, 7, 40, 46, '', NULL, '', NULL, 'Отдых в двухкомнатном домике', 'ОТДЫХ В ДВУХКОМНАТНОМ ДОМИКЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(189, 28, 7, 41, 47, '', NULL, '', NULL, 'Интересует отдых в августе, после 8 числа на неделю и более.... Какие есть свободные варианты?', 'ИНТЕРЕСУЕТ ОТДЫХ В АВГУСТЕ, ПОСЛЕ 8 ЧИСЛА НА НЕДЕЛЮ И БОЛЕЕ.... КАКИЕ ЕСТЬ СВОБОДНЫЕ ВАРИАНТЫ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(190, 29, 3, 13, 13, '', NULL, '', NULL, 'Залина', 'ЗАЛИНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(191, 29, 3, 14, 14, '', NULL, '', NULL, '+7 (282) 653-00-00', '+7 (282) 653-00-00', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(192, 29, 3, 15, 15, '', NULL, '', NULL, '10.08.2024 10:0', '10.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(193, 29, 3, 16, 16, '', NULL, '', NULL, '20.08.2024 10:0', '20.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(194, 29, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(195, 29, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(196, 29, 3, 20, 26, '', NULL, '', NULL, 'Добрый день! Какие возможные варианты для отдыха в коттедже данной категории в августе месяце для 6 человек? ', 'ДОБРЫЙ ДЕНЬ! КАКИЕ ВОЗМОЖНЫЕ ВАРИАНТЫ ДЛЯ ОТДЫХА В КОТТЕДЖЕ ДАННОЙ КАТЕГОРИИ В АВГУСТЕ МЕСЯЦЕ ДЛЯ 6 ЧЕЛОВЕК?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(197, 30, 8, 42, 48, '', NULL, '', NULL, 'Асия', 'АСИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(198, 30, 8, 43, 49, '', NULL, '', NULL, '+7 (915) 001-54-49', '+7 (915) 001-54-49', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(199, 31, 3, 13, 13, '', NULL, '', NULL, 'Жанна Ахмедова', 'ЖАННА АХМЕДОВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(200, 31, 3, 14, 14, '', NULL, '', NULL, '+7 (926) 586-59-90', '+7 (926) 586-59-90', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(201, 31, 3, 15, 15, '', NULL, '', NULL, '05.07.2024 12:0', '05.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(202, 31, 3, 16, 16, '', NULL, '', NULL, '06.07.2024 12:0', '06.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(203, 31, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(204, 31, 3, 18, 21, '4', '4', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(205, 31, 3, 19, 25, 'Санузел / душ', 'САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(206, 31, 3, 20, 26, '', NULL, '', NULL, '.', '.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(207, 32, 3, 13, 13, '', NULL, '', NULL, 'Анна ямковая', 'АННА ЯМКОВАЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(208, 32, 3, 14, 14, '', NULL, '', NULL, '+7 (913) 000-19-20', '+7 (913) 000-19-20', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(209, 32, 3, 15, 15, '', NULL, '', NULL, '16.07.2024 10:м', '16.07.2024 10:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(210, 32, 3, 16, 16, '', NULL, '', NULL, '19.07.2024 10:м', '19.07.2024 10:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(211, 32, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(212, 32, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(213, 32, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(214, 32, 3, 20, 26, '', NULL, '', NULL, 'Здравствуйте ', 'ЗДРАВСТВУЙТЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(215, 33, 3, 13, 13, '', NULL, '', NULL, 'Юлия Мосолова ', 'ЮЛИЯ МОСОЛОВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(216, 33, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 031-53-36', '+7 (916) 031-53-36', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(217, 33, 3, 15, 15, '', NULL, '', NULL, '11.07.2024 12:0', '11.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(218, 33, 3, 16, 16, '', NULL, '', NULL, '16.07.2024 12:0', '16.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(219, 33, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(220, 33, 3, 18, 18, '1', '1', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(221, 33, 3, 20, 26, '', NULL, '', NULL, 'Добрый день планируем отдых с 11.07 по 16.07', 'ДОБРЫЙ ДЕНЬ ПЛАНИРУЕМ ОТДЫХ С 11.07 ПО 16.07', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(222, 34, 3, 13, 13, '', NULL, '', NULL, 'Арсланбек  Тангатаров ', 'АРСЛАНБЕК  ТАНГАТАРОВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(223, 34, 3, 14, 14, '', NULL, '', NULL, '+7 (962) 410-55-22', '+7 (962) 410-55-22', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(224, 34, 3, 15, 15, '', NULL, '', NULL, '21.07.2024 10:0', '21.07.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(225, 34, 3, 16, 16, '', NULL, '', NULL, '22.07.2024 12:0', '22.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(226, 34, 3, 17, 17, '', NULL, '', NULL, 'Домик на двоих', 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(227, 34, 3, 18, 19, '2', '2', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(228, 34, 3, 19, 25, 'Санузел / душ', 'САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(229, 34, 3, 20, 26, '', NULL, '', NULL, 'Ждём звонка от вас', 'ЖДЁМ ЗВОНКА ОТ ВАС', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(230, 35, 3, 13, 13, '', NULL, '', NULL, 'Амина Шабанова ', 'АМИНА ШАБАНОВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(231, 35, 3, 14, 14, '', NULL, '', NULL, '+7 (989) 862-82-55', '+7 (989) 862-82-55', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(232, 35, 3, 15, 15, '', NULL, '', NULL, '27.07.2024 11:0', '27.07.2024 11:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(233, 35, 3, 16, 16, '', NULL, '', NULL, '28.07.2024 1ч:м', '28.07.2024 1Ч:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(234, 35, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(235, 35, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(236, 35, 3, 19, 23, 'Питание', 'ПИТАНИЕ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(237, 35, 3, 20, 26, '', NULL, '', NULL, '.', '.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(238, 36, 3, 13, 13, '', NULL, '', NULL, 'Умар Акмурзаев', 'УМАР АКМУРЗАЕВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(239, 36, 3, 14, 14, '', NULL, '', NULL, '+7 (928) 830-48-14', '+7 (928) 830-48-14', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(240, 36, 3, 15, 15, '', NULL, '', NULL, '30.07.2024 10:9', '30.07.2024 10:9', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(241, 36, 3, 16, 16, '', NULL, '', NULL, '02.08.2024 10:м', '02.08.2024 10:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(242, 36, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(243, 36, 3, 18, 21, '4', '4', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(244, 36, 3, 19, 25, 'Санузел / душ', 'САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(245, 36, 3, 20, 26, '', NULL, '', NULL, 'Меня зовут Умар, собираюсь отдохнуть на вашей базе, вместе со своей мамой, супругой, и ребенком!', 'МЕНЯ ЗОВУТ УМАР, СОБИРАЮСЬ ОТДОХНУТЬ НА ВАШЕЙ БАЗЕ, ВМЕСТЕ СО СВОЕЙ МАМОЙ, СУПРУГОЙ, И РЕБЕНКОМ!', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(246, 37, 8, 42, 48, '', NULL, '', NULL, 'Шамиль', 'ШАМИЛЬ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(247, 37, 8, 43, 49, '', NULL, '', NULL, '+7 (963) 583-01-05', '+7 (963) 583-01-05', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(248, 38, 8, 42, 48, '', NULL, '', NULL, 'Юрий', 'ЮРИЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(249, 38, 8, 43, 49, '', NULL, '', NULL, '+7 (926) 207-78-88', '+7 (926) 207-78-88', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(250, 39, 3, 13, 13, '', NULL, '', NULL, 'Сергей', 'СЕРГЕЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(251, 39, 3, 14, 14, '', NULL, '', NULL, '+7 (910) 877-53-90', '+7 (910) 877-53-90', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(252, 39, 3, 15, 15, '', NULL, '', NULL, '30.07.2024 12:0', '30.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(253, 39, 3, 16, 16, '', NULL, '', NULL, '02.08.2024 10:0', '02.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(254, 39, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(255, 39, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(256, 39, 3, 20, 26, '', NULL, '', NULL, 'Можно забронировать с 30.07 по 02.08 апартаменты', 'МОЖНО ЗАБРОНИРОВАТЬ С 30.07 ПО 02.08 АПАРТАМЕНТЫ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(257, 40, 3, 13, 13, '', NULL, '', NULL, 'Сергей', 'СЕРГЕЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(258, 40, 3, 14, 14, '', NULL, '', NULL, '+7 (920) 073-76-80', '+7 (920) 073-76-80', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(259, 40, 3, 15, 15, '', NULL, '', NULL, '30.07.2024 12:0', '30.07.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(260, 40, 3, 16, 16, '', NULL, '', NULL, '02.08.2024 12:0', '02.08.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(261, 40, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(262, 40, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(263, 40, 3, 19, 25, 'Санузел / душ', 'САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(264, 40, 3, 20, 26, '', NULL, '', NULL, 'Можно забронировать эконом с 30.07 по 02.08 для 2-х человек?', 'МОЖНО ЗАБРОНИРОВАТЬ ЭКОНОМ С 30.07 ПО 02.08 ДЛЯ 2-Х ЧЕЛОВЕК?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(265, 41, 7, 37, 43, '', NULL, '', NULL, 'Тамила ', 'ТАМИЛА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(266, 41, 7, 38, 44, '', NULL, '', NULL, '+7 (928) 053-42-48', '+7 (928) 053-42-48', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(267, 41, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(268, 41, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(269, 41, 7, 41, 47, '', NULL, '', NULL, 'Есть ли свободные места на 20 августа и цены ', 'ЕСТЬ ЛИ СВОБОДНЫЕ МЕСТА НА 20 АВГУСТА И ЦЕНЫ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(270, 42, 3, 13, 13, '', NULL, '', NULL, 'Ольга', 'ОЛЬГА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(271, 42, 3, 14, 14, '', NULL, '', NULL, '+7 (909) 757-31-71', '+7 (909) 757-31-71', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(272, 42, 3, 15, 15, '', NULL, '', NULL, '27.07.2024 1ч:м', '27.07.2024 1Ч:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(273, 42, 3, 16, 16, '', NULL, '', NULL, '28.07.2024 1ч:м', '28.07.2024 1Ч:М', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(274, 42, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(275, 42, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(276, 42, 3, 20, 26, '', NULL, '', NULL, '3 ребенка 7 лет ', '3 РЕБЕНКА 7 ЛЕТ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(277, 43, 3, 13, 13, '', NULL, '', NULL, 'Владислав Свиридов', 'ВЛАДИСЛАВ СВИРИДОВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(278, 43, 3, 14, 14, '', NULL, '', NULL, '+7 (908) 619-30-04', '+7 (908) 619-30-04', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(279, 43, 3, 15, 15, '', NULL, '', NULL, '09.08.2024 4:0', '09.08.2024 4:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(280, 43, 3, 16, 16, '', NULL, '', NULL, '11.08.2024 12:0', '11.08.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(281, 43, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(282, 43, 3, 18, 20, '3', '3', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(283, 43, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(284, 43, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(285, 43, 3, 20, 26, '', NULL, '', NULL, 'Здравствуйте. Не могу дозвониться. Хочу снять коттедж на 2 дня. Нужна информация.', 'ЗДРАВСТВУЙТЕ. НЕ МОГУ ДОЗВОНИТЬСЯ. ХОЧУ СНЯТЬ КОТТЕДЖ НА 2 ДНЯ. НУЖНА ИНФОРМАЦИЯ.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(286, 44, 7, 37, 43, '', NULL, '', NULL, 'Виолетта', 'ВИОЛЕТТА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(287, 44, 7, 38, 44, '', NULL, '', NULL, '+7 (913) 790-85-86', '+7 (913) 790-85-86', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(288, 44, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(289, 44, 7, 40, 46, '', NULL, '', NULL, 'Проживание', 'ПРОЖИВАНИЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(290, 44, 7, 41, 47, '', NULL, '', NULL, 'Добрый день. Интересуют свободные номера с 9.08 по 11.08', 'ДОБРЫЙ ДЕНЬ. ИНТЕРЕСУЮТ СВОБОДНЫЕ НОМЕРА С 9.08 ПО 11.08', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(291, 45, 3, 13, 13, '', NULL, '', NULL, 'Оксана Совицкая', 'ОКСАНА СОВИЦКАЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(292, 45, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 562-01-23', '+7 (916) 562-01-23', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(293, 45, 3, 15, 15, '', NULL, '', NULL, '01.09.2024 12:0', '01.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(294, 45, 3, 16, 16, '', NULL, '', NULL, '13.09.2024 12:0', '13.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(295, 45, 3, 17, 17, '', NULL, '', NULL, 'Домик на двоих', 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(296, 45, 3, 18, 19, '2', '2', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(297, 45, 3, 19, 22, 'Экскурсия', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(298, 45, 3, 19, 23, 'Питание', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(299, 45, 3, 19, 25, 'Санузел / душ', 'ЭКСКУРСИЯ ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(300, 45, 3, 20, 26, '', NULL, '', NULL, 'Здравствуйте , прилетаем 31.08. поздно , планируем добраться до вас 01.09.', 'ЗДРАВСТВУЙТЕ , ПРИЛЕТАЕМ 31.08. ПОЗДНО , ПЛАНИРУЕМ ДОБРАТЬСЯ ДО ВАС 01.09.', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(301, 46, 8, 42, 48, '', NULL, '', NULL, 'Оксана', 'ОКСАНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(302, 46, 8, 43, 49, '', NULL, '', NULL, '+7 (916) 562-01-23', '+7 (916) 562-01-23', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(303, 47, 8, 42, 48, '', NULL, '', NULL, 'Ольга', 'ОЛЬГА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(304, 47, 8, 43, 49, '', NULL, '', NULL, '+7 (917) 197-68-49', '+7 (917) 197-68-49', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(305, 48, 3, 13, 13, '', NULL, '', NULL, 'Оксана Александровна Бурыкина', 'ОКСАНА АЛЕКСАНДРОВНА БУРЫКИНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(306, 48, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 562-01-23', '+7 (916) 562-01-23', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(307, 48, 3, 15, 15, '', NULL, '', NULL, '01.09.2024 12:0', '01.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(308, 48, 3, 16, 16, '', NULL, '', NULL, '13.09.2024 12:0', '13.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(309, 48, 3, 17, 17, '', NULL, '', NULL, 'Домик на двоих', 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(310, 48, 3, 18, 18, '1', '1', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(311, 48, 3, 19, 22, 'Экскурсия', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(312, 48, 3, 19, 23, 'Питание', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(313, 48, 3, 19, 24, 'Трансфер', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(314, 48, 3, 19, 25, 'Санузел / душ', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ДОМИК НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(315, 48, 3, 20, 26, '', NULL, '', NULL, 'Заселение с 01 . 09 по13. 09 номер на двоих', 'ЗАСЕЛЕНИЕ С 01 . 09 ПО13. 09 НОМЕР НА ДВОИХ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(316, 49, 3, 13, 13, '', NULL, '', NULL, 'Оксана', 'ОКСАНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(317, 49, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 562-01-23', '+7 (916) 562-01-23', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(318, 49, 3, 15, 15, '', NULL, '', NULL, '01.09.2024 12:0', '01.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(319, 49, 3, 16, 16, '', NULL, '', NULL, '13.09.2024 12:0', '13.09.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(320, 49, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(321, 49, 3, 18, 19, '2', '2', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(322, 49, 3, 19, 22, 'Экскурсия', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(323, 49, 3, 19, 23, 'Питание', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(324, 49, 3, 19, 24, 'Трансфер', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(325, 49, 3, 19, 25, 'Санузел / душ', 'ЭКСКУРСИЯ ПИТАНИЕ ТРАНСФЕР САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(326, 49, 3, 20, 26, '', NULL, '', NULL, 'в номере есть душ и туалет?', 'В НОМЕРЕ ЕСТЬ ДУШ И ТУАЛЕТ?', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(327, 50, 3, 13, 13, '', NULL, '', NULL, 'Михаил Корнеев', 'МИХАИЛ КОРНЕЕВ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(328, 50, 3, 14, 14, '', NULL, '', NULL, '+7 (916) 340-59-92', '+7 (916) 340-59-92', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(329, 50, 3, 15, 15, '', NULL, '', NULL, '14.08.2024 12:0', '14.08.2024 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(330, 50, 3, 16, 16, '', NULL, '', NULL, '15.08.2024 8:0', '15.08.2024 8:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(331, 50, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(332, 50, 3, 18, 21, '4', '4', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(333, 50, 3, 20, 26, '', NULL, '', NULL, 'Здравствуйте! Прошу подтвердить бронь!', 'ЗДРАВСТВУЙТЕ! ПРОШУ ПОДТВЕРДИТЬ БРОНЬ!', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(334, 51, 8, 42, 48, '', NULL, '', NULL, 'Михаил', 'МИХАИЛ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(335, 51, 8, 43, 49, '', NULL, '', NULL, '+7 (916) 340-59-92', '+7 (916) 340-59-92', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(336, 52, 7, 37, 43, '', NULL, '', NULL, 'Дмитрий', 'ДМИТРИЙ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(337, 52, 7, 38, 44, '', NULL, '', NULL, '+7 (928) 008-12-31', '+7 (928) 008-12-31', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(338, 52, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(339, 52, 7, 40, 46, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(340, 52, 7, 41, 47, '', NULL, '', NULL, 'Здравствуйте.\r\nНа сколько человек рассчитан  коттедж', 'ЗДРАВСТВУЙТЕ.\r\nНА СКОЛЬКО ЧЕЛОВЕК РАССЧИТАН  КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(341, 53, 7, 37, 43, '', NULL, '', NULL, 'Анастасия ', 'АНАСТАСИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(342, 53, 7, 38, 44, '', NULL, '', NULL, '+7 (912) 635-57-78', '+7 (912) 635-57-78', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(343, 53, 7, 39, 45, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(344, 53, 7, 40, 46, '', NULL, '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(345, 53, 7, 41, 47, '', NULL, '', NULL, 'Здравствуйте, интересует база отдыха «Город моря»', 'ЗДРАВСТВУЙТЕ, ИНТЕРЕСУЕТ БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(346, 54, 3, 13, 13, '', NULL, '', NULL, 'Ольга', 'ОЛЬГА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(347, 54, 3, 14, 14, '', NULL, '', NULL, '+7 (926) 762-95-13', '+7 (926) 762-95-13', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(348, 54, 3, 15, 15, '', NULL, '', NULL, '14.08.2024 10:0', '14.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(349, 54, 3, 16, 16, '', NULL, '', NULL, '20.08.2024 10:0', '20.08.2024 10:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(350, 54, 3, 17, 17, '', NULL, '', NULL, 'Коттедж', 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(351, 54, 3, 18, 18, '1', '1', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(352, 54, 3, 19, 25, 'Санузел / душ', 'САНУЗЕЛ / ДУШ', '', NULL, NULL, 'КОТТЕДЖ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(353, 54, 3, 20, 26, '', NULL, '', NULL, 'Нужна консультация ', 'НУЖНА КОНСУЛЬТАЦИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(354, 55, 8, 42, 48, '', NULL, '', NULL, 'Марина ', 'МАРИНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(355, 55, 8, 43, 49, '', NULL, '', NULL, '+7 (906) 525-73-66', '+7 (906) 525-73-66', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(356, 56, 3, 13, 13, '', NULL, '', NULL, 'Евгения кулиева ', 'ЕВГЕНИЯ КУЛИЕВА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(357, 56, 3, 14, 14, '', NULL, '', NULL, '+7 (925) 568-86-36', '+7 (925) 568-86-36', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(358, 56, 3, 15, 15, '', NULL, '', NULL, '16.07.2025 12:0', '16.07.2025 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(359, 56, 3, 16, 16, '', NULL, '', NULL, '26.07.2025 12:0', '26.07.2025 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(360, 56, 3, 17, 17, '', NULL, '', NULL, 'Эконом', 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(361, 56, 3, 18, 18, '1', '1', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(362, 56, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(363, 56, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'ЭКОНОМ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(364, 56, 3, 20, 26, '', NULL, '', NULL, '2 взрослых и 2 ребенка ', '2 ВЗРОСЛЫХ И 2 РЕБЕНКА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(365, 57, 3, 13, 13, '', NULL, '', NULL, 'Евгения', 'ЕВГЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(366, 57, 3, 14, 14, '', NULL, '', NULL, '+7 (925) 568-86-36', '+7 (925) 568-86-36', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(367, 57, 3, 15, 15, '', NULL, '', NULL, '16.07.2025 12:0', '16.07.2025 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(368, 57, 3, 16, 16, '', NULL, '', NULL, '26.07.2025 12:0', '26.07.2025 12:0', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL),
(369, 57, 3, 17, 17, '', NULL, '', NULL, 'Номер в отеле', 'НОМЕР В ОТЕЛЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(370, 57, 3, 18, 18, '1', '1', '', NULL, NULL, 'НОМЕР В ОТЕЛЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(371, 57, 3, 19, 23, 'Питание', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'НОМЕР В ОТЕЛЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(372, 57, 3, 19, 25, 'Санузел / душ', 'ПИТАНИЕ САНУЗЕЛ / ДУШ', '', NULL, NULL, 'НОМЕР В ОТЕЛЕ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(373, 57, 3, 20, 26, '', NULL, '', NULL, '2 взрослых 2 ребенка ', '2 ВЗРОСЛЫХ 2 РЕБЕНКА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(374, 58, 8, 42, 48, '', NULL, '', NULL, 'Евгения', 'ЕВГЕНИЯ', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(375, 58, 8, 43, 49, '', NULL, '', NULL, '+7 (925) 568-86-36', '+7 (925) 568-86-36', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(376, 59, 7, 37, 43, '', NULL, '', NULL, 'Ирина ', 'ИРИНА', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(377, 59, 7, 38, 44, '', NULL, '', NULL, '+7 (919) 486-94-03', '+7 (919) 486-94-03', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(378, 59, 7, 39, 45, '', NULL, '', NULL, 'irka_p_2008@bk.ru', 'IRKA_P_2008@BK.RU', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(379, 59, 7, 40, 46, '', NULL, '', NULL, 'База отдыха «Город Моря»', 'БАЗА ОТДЫХА «ГОРОД МОРЯ»', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(380, 59, 7, 41, 47, '', NULL, '', NULL, 'Домик на 5 человек с 14.08-19.08', 'ДОМИК НА 5 ЧЕЛОВЕК С 14.08-19.08', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
-- -----------------------------------
-- Dumping table b_form_status
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_status`;
CREATE TABLE `b_form_status` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORM_ID` int NOT NULL DEFAULT '0',
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `C_SORT` int NOT NULL DEFAULT '100',
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DEFAULT_VALUE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `CSS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'statusgreen',
  `HANDLER_OUT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HANDLER_IN` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MAIL_EVENT_TYPE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_ID` (`FORM_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_status` VALUES
(1, 1, '2023-04-27 00:10:28', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(2, 2, '2023-04-27 00:10:28', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(3, 3, '2023-04-27 00:10:28', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(4, 4, '2023-04-27 00:10:28', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(5, 5, '2023-04-27 00:10:29', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(6, 6, '2023-04-27 00:10:29', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(7, 7, '2023-04-27 00:10:29', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(8, 8, '2023-04-27 00:10:30', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(9, 9, '2023-04-27 00:10:30', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(10, 10, '2023-04-27 00:10:30', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(11, 11, '2023-04-27 00:10:31', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL),
(12, 12, '2023-04-27 00:10:31', 'Y', 100, 'DEFAULT', NULL, 'Y', 'statusgreen', NULL, NULL, NULL);
-- -----------------------------------
-- Dumping table b_form_status_2_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_status_2_group`;
CREATE TABLE `b_form_status_2_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `STATUS_ID` int NOT NULL DEFAULT '0',
  `GROUP_ID` int NOT NULL DEFAULT '0',
  `PERMISSION` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORM_STATUS_GROUP` (`STATUS_ID`,`GROUP_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_form_status_2_group` VALUES
(1, 1, 2, 'VIEW'),
(2, 1, 2, 'MOVE'),
(3, 1, 2, 'EDIT'),
(4, 1, 2, 'DELETE'),
(5, 2, 2, 'VIEW'),
(6, 2, 2, 'MOVE'),
(7, 2, 2, 'EDIT'),
(8, 2, 2, 'DELETE'),
(9, 3, 2, 'VIEW'),
(10, 3, 2, 'MOVE'),
(11, 3, 2, 'EDIT'),
(12, 3, 2, 'DELETE'),
(13, 4, 2, 'VIEW'),
(14, 4, 2, 'MOVE'),
(15, 4, 2, 'EDIT'),
(16, 4, 2, 'DELETE'),
(17, 5, 2, 'VIEW'),
(18, 5, 2, 'MOVE'),
(19, 5, 2, 'EDIT'),
(20, 5, 2, 'DELETE'),
(21, 6, 2, 'VIEW'),
(22, 6, 2, 'MOVE'),
(23, 6, 2, 'EDIT'),
(24, 6, 2, 'DELETE'),
(25, 7, 2, 'VIEW'),
(26, 7, 2, 'MOVE'),
(27, 7, 2, 'EDIT'),
(28, 7, 2, 'DELETE'),
(29, 8, 2, 'VIEW'),
(30, 8, 2, 'MOVE'),
(31, 8, 2, 'EDIT'),
(32, 8, 2, 'DELETE'),
(33, 9, 2, 'VIEW'),
(34, 9, 2, 'MOVE'),
(35, 9, 2, 'EDIT'),
(36, 9, 2, 'DELETE'),
(37, 10, 2, 'VIEW'),
(38, 10, 2, 'MOVE'),
(39, 10, 2, 'EDIT'),
(40, 10, 2, 'DELETE'),
(41, 11, 2, 'VIEW'),
(42, 11, 2, 'MOVE'),
(43, 11, 2, 'EDIT'),
(44, 11, 2, 'DELETE'),
(45, 12, 2, 'VIEW'),
(46, 12, 2, 'MOVE'),
(47, 12, 2, 'EDIT'),
(48, 12, 2, 'DELETE');
-- -----------------------------------
-- Dumping table b_form_status_2_mail_template
-- -----------------------------------
DROP TABLE IF EXISTS `b_form_status_2_mail_template`;
CREATE TABLE `b_form_status_2_mail_template` (
  `STATUS_ID` int NOT NULL DEFAULT '0',
  `MAIL_TEMPLATE_ID` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`STATUS_ID`,`MAIL_TEMPLATE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum`;
CREATE TABLE `b_forum` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORUM_GROUP_ID` int DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `SORT` int NOT NULL DEFAULT '150',
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_HTML` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ALLOW_ANCHOR` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_BIU` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_IMG` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_VIDEO` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_LIST` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_QUOTE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_CODE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_FONT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_SMILES` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_UPLOAD` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ALLOW_TABLE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ALLOW_ALIGN` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_UPLOAD_EXT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ALLOW_MOVE_TOPIC` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ALLOW_TOPIC_TITLED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ALLOW_NL2BR` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ALLOW_SIGNATURE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `PATH2FORUM_MESSAGE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ASK_GUEST_EMAIL` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `USE_CAPTCHA` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `INDEXATION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `DEDUPLICATION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `MODERATION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `ORDER_BY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'P',
  `ORDER_DIRECTION` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'DESC',
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'ru',
  `TOPICS` int NOT NULL DEFAULT '0',
  `POSTS` int NOT NULL DEFAULT '0',
  `LAST_POSTER_ID` int DEFAULT NULL,
  `LAST_POSTER_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LAST_POST_DATE` datetime DEFAULT NULL,
  `LAST_MESSAGE_ID` bigint DEFAULT NULL,
  `POSTS_UNAPPROVED` int DEFAULT '0',
  `ABS_LAST_POSTER_ID` int DEFAULT NULL,
  `ABS_LAST_POSTER_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ABS_LAST_POST_DATE` datetime DEFAULT NULL,
  `ABS_LAST_MESSAGE_ID` bigint DEFAULT NULL,
  `EVENT1` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'forum',
  `EVENT2` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'message',
  `EVENT3` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HTML` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORUM_SORT` (`SORT`),
  KEY `IX_FORUM_ACTIVE` (`ACTIVE`),
  KEY `IX_FORUM_GROUP_ID` (`FORUM_GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum2site
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum2site`;
CREATE TABLE `b_forum2site` (
  `FORUM_ID` int NOT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PATH2FORUM_MESSAGE` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`FORUM_ID`,`SITE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_dictionary
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_dictionary`;
CREATE TABLE `b_forum_dictionary` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TYPE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_forum_dictionary` VALUES
(1, '[ru] Словарь слов', 'W'),
(2, '[ru] Словарь транслита', 'T'),
(3, '[en] Bad words', 'W'),
(4, '[en] Transliteration', 'T');
-- -----------------------------------
-- Dumping table b_forum_email
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_email`;
CREATE TABLE `b_forum_email` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `EMAIL_FORUM_ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `FORUM_ID` int NOT NULL,
  `SOCNET_GROUP_ID` int DEFAULT NULL,
  `MAIL_FILTER_ID` int NOT NULL,
  `EMAIL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `USE_EMAIL` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EMAIL_GROUP` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SUBJECT_SUF` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USE_SUBJECT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `URL_TEMPLATES_MESSAGE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `NOT_MEMBER_POST` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_EMAIL_FORUM_SOC` (`FORUM_ID`,`SOCNET_GROUP_ID`),
  KEY `IX_B_FORUM_EMAIL_FILTER_ID` (`MAIL_FILTER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_file
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_file`;
CREATE TABLE `b_forum_file` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORUM_ID` int DEFAULT NULL,
  `TOPIC_ID` int DEFAULT NULL,
  `MESSAGE_ID` int DEFAULT NULL,
  `FILE_ID` int NOT NULL,
  `USER_ID` int DEFAULT NULL,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `HITS` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORUM_FILE_FILE` (`FILE_ID`),
  KEY `IX_FORUM_FILE_FORUM` (`FORUM_ID`),
  KEY `IX_FORUM_FILE_TOPIC` (`TOPIC_ID`),
  KEY `IX_FORUM_FILE_MESSAGE` (`MESSAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_filter
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_filter`;
CREATE TABLE `b_forum_filter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DICTIONARY_ID` int DEFAULT NULL,
  `WORDS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PATTERN` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `REPLACEMENT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `USE_IT` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PATTERN_CREATE` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_FILTER_2` (`USE_IT`),
  KEY `IX_B_FORUM_FILTER_3` (`PATTERN_CREATE`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_forum_filter` VALUES
(1, 1, '*пизд*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])([^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*([ПпPp]+)([ИиIi]+)([ЗзZz3]+)([ДдDd]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(2, 1, '*пизж*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])([^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*([ПпPp]+)([ИиIi]+)([ЗзZz3]+)([ЖжGg]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(3, 1, '*сра%', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])([^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*([СсCc]+)([РрPpRr]+)([АаAa]+)([[Цц]+([Аа]+|[Оо]+)]+|[[Тт]+([Ьь]+|)[Сс]+[Яя]+]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(4, 1, 'анобляд*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([АаAa]+)([НнNn]+)([ОоOo]+)([БбBb]+)([ЛлLl]+)([Яя]+)([ДдDd]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(5, 1, 'взъеб*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвVv]+)([ЗзZz3]+)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(6, 1, 'бля', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([БбBb]+)([ЛлLl]+)([Яя]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(7, 1, 'долбоеб*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ДдDd]+)([ОоOo]+)([ЛлLl]+)([БбBb]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(8, 1, 'дуроеб*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ДдDd]+)([УуUu]+)([РрPpRr]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(9, 1, 'еби', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ИиIi]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(10, 1, 'ебисти*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([СсCc]+)([ТтTt]+)([ИиIi]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(11, 1, 'ебическ*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([Чч]+)([ЁёЕеEe]+)([СсCc]+)([КкKk]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(12, 1, 'еблив*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ЛлLl]+)([ИиIi]+)([ВвVv]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(13, 1, 'ебло*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ЛлLl]+)([ОоOo]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(14, 1, 'еблыс*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ЛлLl]+)([Ыы]+)([СсCc]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(15, 1, 'ебля', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([ЛлLl]+)([Яя]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(16, 1, 'ебс', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([СсCc]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(17, 1, 'ебукент*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([УуUu]+)([КкKk]+)([ЁёЕеEe]+)([НнNn]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(18, 1, 'ебурген*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ЁёЕеEe]+)([БбBb]+)([УуUu]+)([РрPpRr]+)([Гг]+)([ЁёЕеEe]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(19, 1, 'коноебит*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([КкKk]+)([ОоOo]+)([НнNn]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(20, 1, 'мозгоеб*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([МмMm]+)([ОоOo]+)([ЗзZz3]+)([Гг]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(21, 1, 'мудоеб*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([МмMm]+)([УуUu]+)([ДдDd]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(22, 1, 'однохуйствен*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ОоOo]+)([ДдDd]+)([НнNn]+)([ОоOo]+)([ХхXx]+)([УуUu]+)([ЙйИиYy]+)([СсCc]+)([ТтTt]+)([ВвVv]+)([ЁёЕеEe]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(23, 1, 'охуе*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ОоOo]+)([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(24, 1, 'охуи*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ОоOo]+)([ХхXx]+)([УуUu]+)([ИиIi]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(25, 1, 'охуя*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ОоOo]+)([ХхXx]+)([УуUu]+)([Яя]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(26, 1, 'разъеба*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([РрPpRr]+)([АаAa]+)([ЗзZz3]+)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([АаAa]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(27, 1, 'распиздон*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([РрPpRr]+)([АаAa]+)([СсCc]+)([ПпPp]+)([ИиIi]+)([ЗзZz3]+)([ДдDd]+)([ОоOo]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(28, 1, 'расхуюж*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([РрPpRr]+)([АаAa]+)([СсCc]+)([ХхXx]+)([УуUu]+)([Юю]+|[[Йй]+[Оо]+]+)([ЖжGg]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(29, 1, 'худоебин*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ДдDd]+)([ОоOo]+)([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(30, 1, 'хуе', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЁёЕеEe]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(31, 1, 'хуебрат*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([БбBb]+)([РрPpRr]+)([АаAa]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(32, 1, 'хуеглот*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([Гг]+)([ЛлLl]+)([ОоOo]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(33, 1, 'хуеплёт*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([ПпPp]+)([ЛлLl]+)([ЁёЕеEe]+|[[Йй]+[Оо]+]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(34, 1, 'хует*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(35, 1, 'хуила', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ИиIi]+)([ЛлLl]+)([АаAa]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(36, 1, 'хул?', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([ЛлLl]+).?)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(37, 1, 'хуя', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ХхXx]+)([УуUu]+)([Яя]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(38, 1, '^бляд*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([БбBb]+)([ЛлLl]+)([Яя]+)([ДдDd]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(39, 1, '^пидор*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ПпPp]+)([ИиIi]+)([ДдDd]+)([ОоOo]+)([РрPpRr]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(40, 1, '^хуев*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([ВвVv]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(41, 1, '^хуем*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([ЁёЕеEe]+)([МмMm]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(42, 1, '^хуй*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([ЙйИиYy]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(43, 1, '^хуяк*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([Яя]+)([КкKk]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(44, 1, '^хуям*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([Яя]+)([МмMm]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(45, 1, '^хуяр*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([Яя]+)([РрPpRr]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(46, 1, '^хуяч*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ХхXx]+)([УуUu]+)([Яя]+)([Чч]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(47, 1, '^ъебал*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([АаAa]+)([ЛлLl]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(48, 1, '^ъебан*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([АаAa]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(49, 1, '^ъебар*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([АаAa]+)([РрPpRr]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(50, 1, '^ъебат*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([АаAa]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(51, 1, '^ъебен*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([ЁёЕеEe]+)([НнNn]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(52, 1, '^ъеби', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([ИиIi]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(53, 1, '^ъебис*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([СсCc]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(54, 1, '^ъебит*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([ИиIi]+)([ТтTt]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(55, 1, '^ъёбля*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+|[[Йй]+[Оо]+]+)([БбBb]+)([ЛлLl]+)([Яя]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(56, 1, '^ъёбну*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+|[[Йй]+[Оо]+]+)([БбBb]+)([НнNn]+)([УуUu]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(57, 1, '^ъебу', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([УуUu]+))(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(58, 1, '^ъебуч*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([УуUu]+)([Чч]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(59, 1, '^ъебыв*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(([ВвЗзСс]+|[ВвЫы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)+|)([ЪъЬь\"\']+|)([ЁёЕеEe]+)([БбBb]+)([Ыы]+)([ВвVv]+)[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(60, 1, '/(?<=[s.,;:!?-#*|[]()])(?![Вв][ЕеЁё][Бб])(([ВвЗзСс]+|[Ввы]+|[ДдОо]+|[ЗзАа]+|[ИиЗзСс]+|[НнАа]+|[НнЕе]+|[ОоТт]+|([Пп]*[Ее]+[Рр]+[Ее]+)|)([ЬьЪъ]+|)([ЁёЕеEe]+|[Йй]+[Оо]+|[Yy]+[Oo]+)([BbБб]+))(?=[s.,;:!?-#*|[]()])/is', '', '', '', 'Y', 'PTTRN'),
(61, 3, 'angry', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(a+n+g+r+y+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(62, 3, 'ass', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(a+s+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(63, 3, 'asshole', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(a+s+s+h+o+l+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(64, 3, 'banger', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+a+n+g+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(65, 3, 'bastard', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+a+s+t+a+r+d+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(66, 3, 'batter', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+a+t+t+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(67, 3, 'bicho', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+i+c+h+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(68, 3, 'bisexual', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+i+s+e+x+u+a+l+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(69, 3, 'bitch', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+i+t+c+h+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(70, 3, 'blumpkin', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+l+u+m+p+k+i+n+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(71, 3, 'booger', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+o+o+g+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(72, 3, 'bugger*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+g+g+e+r+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(73, 3, 'bukakke', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+k+a+k+k+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(74, 3, 'bull', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+l+l+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(75, 3, 'bulldyke', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+l+l+d+y+k+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(76, 3, 'bullshit', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+l+l+s+h+i+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(77, 3, 'bunny', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+n+n+y+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(78, 3, 'bunnyfuck', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(b+u+n+n+y+f+u+c+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(79, 3, 'chocha', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+h+o+c+h+a+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(80, 3, 'chode', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+h+o+d+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(81, 3, 'clap', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+l+a+p+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(82, 3, 'coconuts', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+c+o+n+u+t+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(83, 3, 'cohones', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+h+o+n+e+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(84, 3, 'cojones', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+j+o+n+e+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(85, 3, 'coon', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+o+n+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(86, 3, 'cootch', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+o+t+c+h+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(87, 3, 'cooter', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+o+t+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(88, 3, 'cornhole', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+o+r+n+h+o+l+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(89, 3, 'cracka', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+r+a+c+k+a+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(90, 3, 'crap', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+r+a+p+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(91, 3, 'cum', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+u+m+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(92, 3, 'cunnilingus', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+u+n+n+i+l+i+n+g+u+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(93, 3, 'cunt*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(c+u+n+t+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(94, 3, 'damn*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+a+m+n+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(95, 3, 'dark*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+a+r+k+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(96, 3, 'dick', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+c+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(97, 3, 'dickhead', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+c+k+h+e+a+d+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(98, 3, 'diddle', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+d+d+l+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(99, 3, 'dildo', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+l+d+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(100, 3, 'dilhole', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+l+h+o+l+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(101, 3, 'dingleberry', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+i+n+g+l+e+b+e+r+r+y+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(102, 3, 'doodle', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+o+o+d+l+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(103, 3, 'dork', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+o+r+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(104, 3, 'dumpster', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(d+u+m+p+s+t+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(105, 3, 'faggot', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(f+a+g+g+o+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(106, 3, 'fart', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(f+a+r+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(107, 3, 'frig', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(f+r+i+g+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(108, 3, 'fuck*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(f+u+c+k+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(109, 3, 'fucker', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(f+u+c+k+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(110, 3, 'giz', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(g+i+z+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(111, 3, 'goatse', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(g+o+a+t+s+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(112, 3, 'gook', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(g+o+o+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(113, 3, 'gringo', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(g+r+i+n+g+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(114, 3, 'hobo', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(h+o+b+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(115, 3, 'honky', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(h+o+n+k+y+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(116, 3, 'jackass', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(j+a+c+k+a+s+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(117, 3, 'jackoff', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(j+a+c+k+o+f+f+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(118, 3, 'jerkoff', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(j+e+r+k+o+f+f+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(119, 3, 'jiggaboo', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(j+i+g+g+a+b+o+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(120, 3, 'jizz', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(j+i+z+z+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(121, 3, 'kike', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(k+i+k+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(122, 3, 'mayo', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(m+a+y+o+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(123, 3, 'moose', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(m+o+o+s+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(124, 3, 'nigg*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(n+i+g+g+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(125, 3, 'paki', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+a+k+i+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(126, 3, 'pecker', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+e+c+k+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(127, 3, 'piss', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+i+s+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(128, 3, 'poonanni', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+o+o+n+a+n+n+i+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(129, 3, 'poontang', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+o+o+n+t+a+n+g+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(130, 3, 'prick', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+r+i+c+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(131, 3, 'punch', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(p+u+n+c+h+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(132, 3, 'queef', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(q+u+e+e+f+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(133, 3, 'rogue', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(r+o+g+u+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(134, 3, 'sanchez', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+a+n+c+h+e+z+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(135, 3, 'schlong', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+c+h+l+o+n+g+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(136, 3, 'shit', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+h+i+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(137, 3, 'skank', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+k+a+n+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(138, 3, 'spaz', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+p+a+z+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(139, 3, 'spic', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(s+p+i+c+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(140, 3, 'teabag*', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(t+e+a+b+a+g+[^\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)]*)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(141, 3, 'tits', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(t+i+t+s+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(142, 3, 'twat', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(t+w+a+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(143, 3, 'twot', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(t+w+o+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(144, 3, 'vart', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(v+a+r+t+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(145, 3, 'wanker', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+a+n+k+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(146, 3, 'waste', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+a+s+t+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(147, 3, 'wetback', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+e+t+b+a+c+k+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(148, 3, 'whore', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+h+o+r+e+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(149, 3, 'wigger', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+i+g+g+e+r+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(150, 3, 'wog', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+o+g+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL'),
(151, 3, 'wop', '/(?<=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])(w+o+p+)(?=[\\s.,;:!?\\#\\-\\*\\|\\[\\]\\(\\)])/isu', '', '', 'Y', 'TRNSL');
-- -----------------------------------
-- Dumping table b_forum_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_group`;
CREATE TABLE `b_forum_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SORT` int NOT NULL DEFAULT '150',
  `PARENT_ID` int DEFAULT NULL,
  `LEFT_MARGIN` int DEFAULT NULL,
  `RIGHT_MARGIN` int DEFAULT NULL,
  `DEPTH_LEVEL` int DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_group_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_group_lang`;
CREATE TABLE `b_forum_group_lang` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORUM_GROUP_ID` int NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_GROUP` (`FORUM_GROUP_ID`,`LID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_letter
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_letter`;
CREATE TABLE `b_forum_letter` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DICTIONARY_ID` int DEFAULT '0',
  `LETTER` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `REPLACEMENT` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_forum_letter` VALUES
(1, 2, 'а', 'АаAa'),
(2, 2, 'б', 'БбBb'),
(3, 2, 'в', 'ВвVv'),
(4, 2, 'г', 'Гг'),
(5, 2, 'д', 'ДдDd'),
(6, 2, 'е', 'ЁёЕеEe'),
(7, 2, 'ё', 'ЁёЕеEe, [Йй]+[Оо]+'),
(8, 2, 'ж', 'ЖжGg'),
(9, 2, 'з', 'ЗзZz3'),
(10, 2, 'и', 'ИиIi'),
(11, 2, 'й', 'ЙйИиYy'),
(12, 2, 'к', 'КкKk'),
(13, 2, 'л', 'ЛлLl'),
(14, 2, 'м', 'МмMm'),
(15, 2, 'н', 'НнNn'),
(16, 2, 'о', 'ОоOo'),
(17, 2, 'п', 'ПпPp'),
(18, 2, 'р', 'РрPpRr'),
(19, 2, 'с', 'СсCc'),
(20, 2, 'т', 'ТтTt'),
(21, 2, 'у', 'УуUu'),
(22, 2, 'ф', 'ФфFf'),
(23, 2, 'х', 'ХхXx'),
(24, 2, 'ц', 'ЦцCc'),
(25, 2, 'ч', 'Чч'),
(26, 2, 'ш', 'Шш'),
(27, 2, 'щ', 'Щщ'),
(28, 2, 'ь', 'ЪъЬь\"\','),
(29, 2, 'ы', 'Ыы'),
(30, 2, 'ъ', 'ЪъЬь\"\','),
(31, 2, 'э', 'Ээ'),
(32, 2, 'ю', 'Юю, [Йй]+[Оо]+'),
(33, 2, 'я', 'Яя'),
(34, 2, '%', '[Цц]+([Аа]+|[Оо]+), [Тт]+([Ьь]+|)[Сс]+[Яя]+'),
(35, 2, '^', ',ВвЗзСс,ВвЫы,ДдОо,ЗзАа,ИиЗзСс,НнАа,НнЕе,ОоТт,([Пп]*[Ее]+[Рр]+[Ее]+)'),
(36, 2, 'тся', '%'),
(37, 2, 'ться', '%');
-- -----------------------------------
-- Dumping table b_forum_message
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_message`;
CREATE TABLE `b_forum_message` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `FORUM_ID` int NOT NULL,
  `TOPIC_ID` bigint NOT NULL,
  `USE_SMILES` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `NEW_TOPIC` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `APPROVED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SOURCE_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'WEB',
  `POST_DATE` datetime NOT NULL,
  `POST_MESSAGE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `POST_MESSAGE_HTML` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `POST_MESSAGE_FILTER` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `POST_MESSAGE_CHECK` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ATTACH_IMG` int DEFAULT NULL,
  `PARAM1` varchar(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PARAM2` int DEFAULT NULL,
  `AUTHOR_ID` int DEFAULT NULL,
  `AUTHOR_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_EMAIL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_IP` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AUTHOR_REAL_IP` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `GUEST_ID` int DEFAULT NULL,
  `EDITOR_ID` int DEFAULT NULL,
  `EDITOR_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EDITOR_EMAIL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EDIT_REASON` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `EDIT_DATE` datetime DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HTML` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `MAIL_HEADER` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `SERVICE_TYPE` tinyint DEFAULT NULL,
  `SERVICE_DATA` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `IX_FORUM_MESSAGE_FORUM` (`FORUM_ID`,`APPROVED`),
  KEY `IX_FORUM_MESSAGE_FORUM_TOPIC` (`FORUM_ID`,`TOPIC_ID`),
  KEY `IX_FORUM_MESSAGE_TOPIC` (`TOPIC_ID`,`APPROVED`),
  KEY `IX_FORUM_MESSAGE_AUTHOR` (`AUTHOR_ID`,`APPROVED`,`FORUM_ID`),
  KEY `IX_FORUM_MESSAGE_APPROVED` (`APPROVED`),
  KEY `IX_FORUM_MESSAGE_PARAM2` (`PARAM2`),
  KEY `IX_FORUM_MESSAGE_XML_ID` (`XML_ID`),
  KEY `IX_FORUM_MESSAGE_DATE_AUTHOR_ID` (`POST_DATE`,`AUTHOR_ID`),
  KEY `IX_FORUM_MESSAGE_AUTHOR_TOPIC_ID` (`AUTHOR_ID`,`TOPIC_ID`),
  KEY `IX_FORUM_MESSAGE_AUTHOR_FORUM_ID` (`AUTHOR_ID`,`FORUM_ID`,`ID`,`APPROVED`,`TOPIC_ID`),
  KEY `IX_FORUM_MESSAGE_SERVICE_TYPE` (`SERVICE_TYPE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_perms
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_perms`;
CREATE TABLE `b_forum_perms` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `FORUM_ID` int NOT NULL,
  `GROUP_ID` int NOT NULL,
  `PERMISSION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'M',
  PRIMARY KEY (`ID`),
  KEY `IX_FORUM_PERMS_FORUM` (`FORUM_ID`,`GROUP_ID`),
  KEY `IX_FORUM_PERMS_GROUP` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_pm_folder
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_pm_folder`;
CREATE TABLE `b_forum_pm_folder` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `USER_ID` int NOT NULL,
  `SORT` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_PM_FOLDER_USER_IST` (`USER_ID`,`ID`,`SORT`,`TITLE`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_forum_pm_folder` VALUES
(1, 'SYSTEM_FOLDER_1', 0, 0),
(2, 'SYSTEM_FOLDER_2', 0, 0),
(3, 'SYSTEM_FOLDER_3', 0, 0),
(4, 'SYSTEM_FOLDER_4', 0, 0);
-- -----------------------------------
-- Dumping table b_forum_points
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_points`;
CREATE TABLE `b_forum_points` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `MIN_POINTS` int NOT NULL,
  `CODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `VOTES` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_P_MP` (`MIN_POINTS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_points2post
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_points2post`;
CREATE TABLE `b_forum_points2post` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `MIN_NUM_POSTS` int NOT NULL,
  `POINTS_PER_POST` decimal(18,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_P2P_MNP` (`MIN_NUM_POSTS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_points_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_points_lang`;
CREATE TABLE `b_forum_points_lang` (
  `POINTS_ID` int NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`POINTS_ID`,`LID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_private_message
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_private_message`;
CREATE TABLE `b_forum_private_message` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `AUTHOR_ID` int DEFAULT '0',
  `RECIPIENT_ID` int DEFAULT '0',
  `POST_DATE` datetime DEFAULT NULL,
  `POST_SUBJ` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `POST_MESSAGE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `USER_ID` int NOT NULL,
  `FOLDER_ID` int NOT NULL,
  `IS_READ` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `REQUEST_IS_READ` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `USE_SMILES` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_PM_AFR` (`AUTHOR_ID`,`FOLDER_ID`,`IS_READ`),
  KEY `IX_B_FORUM_PM_UFP` (`USER_ID`,`FOLDER_ID`,`POST_DATE`),
  KEY `IX_B_FORUM_PM_POST_DATE` (`POST_DATE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_rank
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_rank`;
CREATE TABLE `b_forum_rank` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CODE` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `MIN_NUM_POSTS` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_rank_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_rank_lang`;
CREATE TABLE `b_forum_rank_lang` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `RANK_ID` int NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_RANK` (`RANK_ID`,`LID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_service_deleted_message
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_service_deleted_message`;
CREATE TABLE `b_forum_service_deleted_message` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `FORUM_ID` int NOT NULL,
  `TOPIC_ID` bigint NOT NULL,
  `MESSAGE_ID` bigint NOT NULL,
  `NEW_TOPIC` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `APPROVED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `PARAM1` varchar(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PARAM2` int DEFAULT NULL,
  `AUTHOR_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_MESSAGE_DELETED_ID` (`MESSAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_service_statistic_queue
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_service_statistic_queue`;
CREATE TABLE `b_forum_service_statistic_queue` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `ENTITY_TYPE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ENTITY_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_SERVICE_STATISTIC` (`ENTITY_TYPE`,`ENTITY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_stat
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_stat`;
CREATE TABLE `b_forum_stat` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `IP_ADDRESS` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PHPSESSID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LAST_VISIT` datetime DEFAULT NULL,
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `FORUM_ID` smallint NOT NULL DEFAULT '0',
  `TOPIC_ID` int DEFAULT NULL,
  `SHOW_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_STAT_SITE_ID` (`SITE_ID`,`LAST_VISIT`),
  KEY `IX_B_FORUM_STAT_TOPIC_ID` (`TOPIC_ID`,`LAST_VISIT`),
  KEY `IX_B_FORUM_STAT_FORUM_ID` (`FORUM_ID`,`LAST_VISIT`),
  KEY `IX_B_FORUM_STAT_PHPSESSID` (`PHPSESSID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_subscribe
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_subscribe`;
CREATE TABLE `b_forum_subscribe` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `FORUM_ID` int NOT NULL,
  `TOPIC_ID` int DEFAULT NULL,
  `START_DATE` datetime NOT NULL,
  `LAST_SEND` int DEFAULT NULL,
  `NEW_TOPIC_ONLY` char(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SITE_ID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'ru',
  `SOCNET_GROUP_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UX_FORUM_SUBSCRIBE_USER` (`USER_ID`,`FORUM_ID`,`TOPIC_ID`,`SOCNET_GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_topic
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_topic`;
CREATE TABLE `b_forum_topic` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `FORUM_ID` int NOT NULL,
  `TOPIC_ID` bigint DEFAULT NULL,
  `TITLE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TITLE_SEO` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TAGS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ICON` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `STATE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `APPROVED` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SORT` int NOT NULL DEFAULT '150',
  `VIEWS` int NOT NULL DEFAULT '0',
  `USER_START_ID` int DEFAULT NULL,
  `USER_START_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `START_DATE` datetime NOT NULL,
  `POSTS` int NOT NULL DEFAULT '0',
  `POSTS_SERVICE` int NOT NULL DEFAULT '0',
  `LAST_POSTER_ID` int DEFAULT NULL,
  `LAST_POSTER_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LAST_POST_DATE` datetime NOT NULL,
  `LAST_MESSAGE_ID` bigint DEFAULT NULL,
  `POSTS_UNAPPROVED` int DEFAULT '0',
  `ABS_LAST_POSTER_ID` int DEFAULT NULL,
  `ABS_LAST_POSTER_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ABS_LAST_POST_DATE` datetime DEFAULT NULL,
  `ABS_LAST_MESSAGE_ID` bigint DEFAULT NULL,
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `HTML` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `SOCNET_GROUP_ID` int DEFAULT NULL,
  `OWNER_ID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_FORUM_TOPIC_FORUM` (`FORUM_ID`,`APPROVED`),
  KEY `IX_FORUM_TOPIC_APPROVED` (`APPROVED`),
  KEY `IX_FORUM_TOPIC_ABS_L_POST_DATE` (`ABS_LAST_POST_DATE`),
  KEY `IX_FORUM_TOPIC_LAST_POST_DATE` (`LAST_POST_DATE`),
  KEY `IX_FORUM_TOPIC_USER_START_ID` (`USER_START_ID`),
  KEY `IX_FORUM_TOPIC_LAST_POSTER_ID` (`LAST_POSTER_ID`),
  KEY `IX_FORUM_TOPIC_DATE_USER_START_ID` (`START_DATE`,`USER_START_ID`),
  KEY `IX_FORUM_TOPIC_XML_ID` (`XML_ID`),
  KEY `IX_FORUM_TOPIC_TITLE_SEO` (`FORUM_ID`,`TITLE_SEO`),
  KEY `IX_FORUM_TOPIC_TITLE_SEO2` (`TITLE_SEO`),
  KEY `IX_FORUM_OWNER_ID` (`OWNER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_user
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_user`;
CREATE TABLE `b_forum_user` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `USER_ID` int NOT NULL,
  `ALIAS` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IP_ADDRESS` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `AVATAR` int DEFAULT NULL,
  `NUM_POSTS` int DEFAULT '0',
  `INTERESTS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `LAST_POST` int DEFAULT NULL,
  `ALLOW_POST` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `LAST_VISIT` datetime NOT NULL,
  `DATE_REG` date NOT NULL,
  `REAL_IP_ADDRESS` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SIGNATURE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SHOW_NAME` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `RANK_ID` int DEFAULT NULL,
  `POINTS` int NOT NULL DEFAULT '0',
  `HIDE_FROM_ONLINE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SUBSC_GROUP_MESSAGE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SUBSC_GET_MY_MESSAGE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IX_FORUM_USER_USER6` (`USER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_forum_user` VALUES
(1, 1, NULL, '', NULL, NULL, 0, '', NULL, 'Y', '2023-04-28 18:47:23', '2023-04-28', NULL, '', 'Y', NULL, 0, 'N', 'N', 'N'),
(3, 3, NULL, '', NULL, NULL, 0, '', NULL, 'Y', '2024-12-01 11:58:21', '2024-12-01', NULL, '', 'Y', NULL, 0, 'N', 'N', 'N');
-- -----------------------------------
-- Dumping table b_forum_user_forum
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_user_forum`;
CREATE TABLE `b_forum_user_forum` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `FORUM_ID` int DEFAULT NULL,
  `LAST_VISIT` datetime DEFAULT NULL,
  `MAIN_LAST_VISIT` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IX_B_FORUM_USER_FORUM_ID1` (`USER_ID`,`FORUM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_user_points
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_user_points`;
CREATE TABLE `b_forum_user_points` (
  `FROM_USER_ID` int NOT NULL,
  `TO_USER_ID` int NOT NULL,
  `POINTS` int NOT NULL DEFAULT '0',
  `DATE_UPDATE` datetime DEFAULT NULL,
  PRIMARY KEY (`FROM_USER_ID`,`TO_USER_ID`),
  KEY `IX_B_FORUM_USER_POINTS_TO_USER` (`TO_USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_forum_user_topic
-- -----------------------------------
DROP TABLE IF EXISTS `b_forum_user_topic`;
CREATE TABLE `b_forum_user_topic` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `TOPIC_ID` int NOT NULL,
  `USER_ID` int NOT NULL,
  `FORUM_ID` int DEFAULT NULL,
  `LAST_VISIT` datetime DEFAULT NULL,
  PRIMARY KEY (`TOPIC_ID`,`USER_ID`),
  KEY `ID` (`ID`),
  KEY `IX_B_FORUM_USER_FORUM_ID2` (`USER_ID`,`FORUM_ID`,`TOPIC_ID`),
  KEY `IX_B_FORUM_USER_FORUM_ID3` (`FORUM_ID`,`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_geoip_handlers
-- -----------------------------------
DROP TABLE IF EXISTS `b_geoip_handlers`;
CREATE TABLE `b_geoip_handlers` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SORT` int NOT NULL DEFAULT '100',
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `CLASS_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CONFIG` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_geoip_handlers` VALUES
(1, 90, 'Y', '\\Bitrix\\Main\\Service\\GeoIp\\Extension', NULL),
(2, 100, 'N', '\\Bitrix\\Main\\Service\\GeoIp\\MaxMind', NULL),
(3, 110, 'Y', '\\Bitrix\\Main\\Service\\GeoIp\\SypexGeo', NULL),
(4, 80, 'Y', '\\Bitrix\\Main\\Service\\GeoIp\\GeoIP2', NULL);
-- -----------------------------------
-- Dumping table b_geoname
-- -----------------------------------
DROP TABLE IF EXISTS `b_geoname`;
CREATE TABLE `b_geoname` (
  `ID` bigint unsigned NOT NULL,
  `LANGUAGE_CODE` varchar(35) NOT NULL,
  `NAME` varchar(600) DEFAULT NULL,
  PRIMARY KEY (`ID`,`LANGUAGE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- -----------------------------------
-- Dumping table b_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_group`;
CREATE TABLE `b_group` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `C_SORT` int NOT NULL DEFAULT '100',
  `ANONYMOUS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `IS_SYSTEM` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECURITY_POLICY` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `STRING_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_group` VALUES
(1, '2024-11-28 12:20:08', 'Y', 1, 'N', 'Y', 'Администраторы', 'Полный доступ к управлению сайтом.', 'a:18:{s:15:\"SESSION_TIMEOUT\";s:2:\"15\";s:15:\"SESSION_IP_MASK\";s:15:\"255.255.255.255\";s:13:\"MAX_STORE_NUM\";s:1:\"2\";s:13:\"STORE_IP_MASK\";s:15:\"255.255.255.255\";s:13:\"STORE_TIMEOUT\";s:5:\"10080\";s:17:\"CHECKWORD_TIMEOUT\";s:2:\"60\";s:15:\"PASSWORD_LENGTH\";s:2:\"10\";s:18:\"PASSWORD_UPPERCASE\";s:1:\"Y\";s:18:\"PASSWORD_LOWERCASE\";s:1:\"Y\";s:15:\"PASSWORD_DIGITS\";s:1:\"Y\";s:20:\"PASSWORD_PUNCTUATION\";s:1:\"Y\";s:19:\"PASSWORD_CHECK_WEAK\";s:1:\"Y\";s:21:\"PASSWORD_CHECK_POLICY\";s:1:\"Y\";s:20:\"PASSWORD_CHANGE_DAYS\";s:2:\"0\";s:21:\"PASSWORD_UNIQUE_COUNT\";s:1:\"3\";s:14:\"LOGIN_ATTEMPTS\";s:1:\"3\";s:20:\"BLOCK_LOGIN_ATTEMPTS\";s:1:\"0\";s:10:\"BLOCK_TIME\";s:1:\"0\";}', ''),
(2, '2023-04-27 00:03:08', 'Y', 2, 'Y', 'Y', 'Все пользователи (в том числе неавторизованные)', 'Все пользователи, включая неавторизованных.', NULL, NULL),
(3, '2023-04-27 00:03:08', 'Y', 3, 'N', 'Y', 'Пользователи, имеющие право голосовать за рейтинг', 'В эту группу пользователи добавляются автоматически.', NULL, 'RATING_VOTE'),
(4, '2023-04-27 00:03:08', 'Y', 4, 'N', 'Y', 'Пользователи имеющие право голосовать за авторитет', 'В эту группу пользователи добавляются автоматически.', NULL, 'RATING_VOTE_AUTHORITY');
-- -----------------------------------
-- Dumping table b_group_collection_task
-- -----------------------------------
DROP TABLE IF EXISTS `b_group_collection_task`;
CREATE TABLE `b_group_collection_task` (
  `GROUP_ID` int NOT NULL,
  `TASK_ID` int NOT NULL,
  `COLLECTION_ID` int NOT NULL,
  PRIMARY KEY (`GROUP_ID`,`TASK_ID`,`COLLECTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_group_subordinate
-- -----------------------------------
DROP TABLE IF EXISTS `b_group_subordinate`;
CREATE TABLE `b_group_subordinate` (
  `ID` int NOT NULL,
  `AR_SUBGROUP_ID` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_group_task
-- -----------------------------------
DROP TABLE IF EXISTS `b_group_task`;
CREATE TABLE `b_group_task` (
  `GROUP_ID` int NOT NULL,
  `TASK_ID` int NOT NULL,
  `EXTERNAL_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '',
  PRIMARY KEY (`GROUP_ID`,`TASK_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_hlbd_complectservices
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlbd_complectservices`;
CREATE TABLE `b_hlbd_complectservices` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `UF_NAME` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_XML_ID` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_PRICE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_PRICE_OLD` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_FILTER_PRICE` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_CURRENCY` int DEFAULT NULL,
  `UF_SORT` double DEFAULT NULL,
  `UF_DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_FULL_DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlbd_complectservices` VALUES
(1, 'Аренда двух шале со скидкой', 'RENT', '17 000 #CURRENCY#/сут', '18 800#CURRENCY#/сут', '17000', 2, 100, 'Аренда посуточно для вашего торжества', NULL);
-- -----------------------------------
-- Dumping table b_hlbd_sposobyoplaty
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlbd_sposobyoplaty`;
CREATE TABLE `b_hlbd_sposobyoplaty` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `UF_ICON_CLASS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_NAME` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_SORT` double DEFAULT NULL,
  `UF_XML_ID` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_LINK` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_FULL_DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_DEF` int DEFAULT NULL,
  `UF_FILE` int DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlbd_sposobyoplaty` VALUES
(1, NULL, 'Visa', 100, 'zrtkk8xV', NULL, NULL, NULL, 0, 3),
(2, NULL, 'MasterCard', 200, 'mc', NULL, NULL, NULL, 0, 4),
(3, NULL, 'Наличные', 300, 'cach', NULL, NULL, NULL, 0, 5),
(4, NULL, 'Карты МИР', 400, 'mir', NULL, NULL, NULL, 0, 6);
-- -----------------------------------
-- Dumping table b_hlblock_entity
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlblock_entity`;
CREATE TABLE `b_hlblock_entity` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TABLE_NAME` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlblock_entity` VALUES
(1, 'ProductMarkingCodeGroup', 'b_hlsys_marking_code_group'),
(2, 'AsproAllcorp3ResortContactReference', 'b_hlbd_sposobyoplaty'),
(3, 'AsproAllcorp3ResortServices', 'b_hlbd_complectservices');
-- -----------------------------------
-- Dumping table b_hlblock_entity_lang
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlblock_entity_lang`;
CREATE TABLE `b_hlblock_entity_lang` (
  `ID` int unsigned NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlblock_entity_lang` VALUES
(1, 'en', 'Product type groups'),
(1, 'ru', 'Типы групп товаров');
-- -----------------------------------
-- Dumping table b_hlblock_entity_rights
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlblock_entity_rights`;
CREATE TABLE `b_hlblock_entity_rights` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `HL_ID` int unsigned NOT NULL,
  `TASK_ID` int unsigned NOT NULL,
  `ACCESS_CODE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlblock_entity_rights` VALUES
(1, 1, 39, 'G1'),
(2, 1, 38, 'G2');
-- -----------------------------------
-- Dumping table b_hlsys_marking_code_group
-- -----------------------------------
DROP TABLE IF EXISTS `b_hlsys_marking_code_group`;
CREATE TABLE `b_hlsys_marking_code_group` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `UF_XML_ID` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `UF_NAME` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hlsys_marking_code_group` VALUES
(1, '02', 'изделия из меха'),
(2, '03', 'лекарственные препараты'),
(3, '05', 'табачные изделия'),
(4, '17485', 'обувь'),
(5, '8258', 'духи и туалетная вода'),
(6, '8721', 'шины и покрышки пневматические резиновые новые'),
(7, '9840', 'фотокамеры (кроме кинокамер), фотовспышки и лампы-вспышки'),
(8, '06', 'алкоголь'),
(9, '5010', 'белье постельное, столовое, туалетное и кухонное'),
(10, '5137', 'предметы одежды, включая рабочую одежду, изготовленные из натуральной или композиционной кожи'),
(11, '5139', 'пальто, полупальто, накидки, плащи, куртки (включая лыжные), ветровки, штормовки и аналогичные изделия мужские или для мальчиков (женские или для девочек)'),
(12, '5140', 'блузки, блузы и блузоны трикотажные машинного или ручного вязания, женские или для девочек');
-- -----------------------------------
-- Dumping table b_hot_keys
-- -----------------------------------
DROP TABLE IF EXISTS `b_hot_keys`;
CREATE TABLE `b_hot_keys` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `KEYS_STRING` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CODE_ID` int NOT NULL,
  `USER_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ix_b_hot_keys_co_u` (`CODE_ID`,`USER_ID`),
  KEY `ix_hot_keys_user` (`USER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hot_keys` VALUES
(1, 'Ctrl+Alt+85', 139, 0),
(2, 'Ctrl+Alt+80', 17, 0),
(3, 'Ctrl+Alt+70', 120, 0),
(4, 'Ctrl+Alt+68', 117, 0),
(5, 'Ctrl+Alt+81', 3, 0),
(6, 'Ctrl+Alt+75', 106, 0),
(7, 'Ctrl+Alt+79', 133, 0),
(8, 'Ctrl+Alt+70', 121, 0),
(9, 'Ctrl+Alt+69', 118, 0),
(10, 'Ctrl+Shift+83', 87, 0),
(11, 'Ctrl+Shift+88', 88, 0),
(12, 'Ctrl+Shift+76', 89, 0),
(13, 'Ctrl+Alt+85', 139, 1),
(14, 'Ctrl+Alt+80', 17, 1),
(15, 'Ctrl+Alt+70', 120, 1),
(16, 'Ctrl+Alt+68', 117, 1),
(17, 'Ctrl+Alt+81', 3, 1),
(18, 'Ctrl+Alt+75', 106, 1),
(19, 'Ctrl+Alt+79', 133, 1),
(20, 'Ctrl+Alt+70', 121, 1),
(21, 'Ctrl+Alt+69', 118, 1),
(22, 'Ctrl+Shift+83', 87, 1),
(23, 'Ctrl+Shift+88', 88, 1),
(24, 'Ctrl+Shift+76', 89, 1),
(25, 'Ctrl+Alt+85', 139, 3),
(26, 'Ctrl+Alt+80', 17, 3),
(27, 'Ctrl+Alt+70', 120, 3),
(28, 'Ctrl+Alt+68', 117, 3),
(29, 'Ctrl+Alt+81', 3, 3),
(30, 'Ctrl+Alt+75', 106, 3),
(31, 'Ctrl+Alt+79', 133, 3),
(32, 'Ctrl+Alt+70', 121, 3),
(33, 'Ctrl+Alt+69', 118, 3),
(34, 'Ctrl+Shift+83', 87, 3),
(35, 'Ctrl+Shift+88', 88, 3),
(36, 'Ctrl+Shift+76', 89, 3);
-- -----------------------------------
-- Dumping table b_hot_keys_code
-- -----------------------------------
DROP TABLE IF EXISTS `b_hot_keys_code`;
CREATE TABLE `b_hot_keys_code` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CLASS_NAME` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CODE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `COMMENTS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TITLE_OBJ` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `IS_CUSTOM` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `ix_hot_keys_code_cn` (`CLASS_NAME`),
  KEY `ix_hot_keys_code_url` (`URL`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_hot_keys_code` VALUES
(3, 'CAdminTabControl', 'NextTab();', 'HK_DB_CADMINTC', 'HK_DB_CADMINTC_C', 'tab-container', '', 0),
(5, 'btn_new', 'var d=BX (\'btn_new\'); if (d) location.href = d.href;', 'HK_DB_BUT_ADD', 'HK_DB_BUT_ADD_C', 'btn_new', '', 0),
(6, 'btn_excel', 'var d=BX(\'btn_excel\'); if (d) location.href = d.href;', 'HK_DB_BUT_EXL', 'HK_DB_BUT_EXL_C', 'btn_excel', '', 0),
(7, 'btn_settings', 'var d=BX(\'btn_settings\'); if (d) location.href = d.href;', 'HK_DB_BUT_OPT', 'HK_DB_BUT_OPT_C', 'btn_settings', '', 0),
(8, 'btn_list', 'var d=BX(\'btn_list\'); if (d) location.href = d.href;', 'HK_DB_BUT_LST', 'HK_DB_BUT_LST_C', 'btn_list', '', 0),
(9, 'Edit_Save_Button', 'var d=BX .findChild(document, {attribute: {\'name\': \'save\'}}, true );  if (d) d.click();', 'HK_DB_BUT_SAVE', 'HK_DB_BUT_SAVE_C', 'Edit_Save_Button', '', 0),
(10, 'btn_delete', 'var d=BX(\'btn_delete\'); if (d) location.href = d.href;', 'HK_DB_BUT_DEL', 'HK_DB_BUT_DEL_C', 'btn_delete', '', 0),
(12, 'CAdminFilter', 'var d=BX .findChild(document, {attribute: {\'name\': \'find\'}}, true ); if (d) d.focus();', 'HK_DB_FLT_FND', 'HK_DB_FLT_FND_C', 'find', '', 0),
(13, 'CAdminFilter', 'var d=BX .findChild(document, {attribute: {\'name\': \'set_filter\'}}, true );  if (d) d.click();', 'HK_DB_FLT_BUT_F', 'HK_DB_FLT_BUT_F_C', 'set_filter', '', 0),
(14, 'CAdminFilter', 'var d=BX .findChild(document, {attribute: {\'name\': \'del_filter\'}}, true );  if (d) d.click();', 'HK_DB_FLT_BUT_CNL', 'HK_DB_FLT_BUT_CNL_C', 'del_filter', '', 0),
(15, 'bx-panel-admin-button-help-icon-id', 'var d=BX(\'bx-panel-admin-button-help-icon-id\'); if (d) location.href = d.href;', 'HK_DB_BUT_HLP', 'HK_DB_BUT_HLP_C', 'bx-panel-admin-button-help-icon-id', '', 0),
(17, 'Global', 'BXHotKeys.ShowSettings();', 'HK_DB_SHW_L', 'HK_DB_SHW_L_C', 'bx-panel-hotkeys', '', 0),
(19, 'Edit_Apply_Button', 'var d=BX .findChild(document, {attribute: {\'name\': \'apply\'}}, true );  if (d) d.click();', 'HK_DB_BUT_APPL', 'HK_DB_BUT_APPL_C', 'Edit_Apply_Button', '', 0),
(20, 'Edit_Cancel_Button', 'var d=BX .findChild(document, {attribute: {\'name\': \'cancel\'}}, true );  if (d) d.click();', 'HK_DB_BUT_CANCEL', 'HK_DB_BUT_CANCEL_C', 'Edit_Cancel_Button', '', 0),
(54, 'top_panel_org_fav', '', '-=AUTONAME=-', NULL, 'top_panel_org_fav', NULL, 0),
(55, 'top_panel_module_settings', '', '-=AUTONAME=-', NULL, 'top_panel_module_settings', '', 0),
(56, 'top_panel_interface_settings', '', '-=AUTONAME=-', NULL, 'top_panel_interface_settings', '', 0),
(57, 'top_panel_help', '', '-=AUTONAME=-', NULL, 'top_panel_help', '', 0),
(58, 'top_panel_bizproc_tasks', '', '-=AUTONAME=-', NULL, 'top_panel_bizproc_tasks', '', 0),
(59, 'top_panel_add_fav', '', '-=AUTONAME=-', NULL, 'top_panel_add_fav', NULL, 0),
(60, 'top_panel_create_page', '', '-=AUTONAME=-', NULL, 'top_panel_create_page', '', 0),
(62, 'top_panel_create_folder', '', '-=AUTONAME=-', NULL, 'top_panel_create_folder', '', 0),
(63, 'top_panel_edit_page', '', '-=AUTONAME=-', NULL, 'top_panel_edit_page', '', 0),
(64, 'top_panel_page_prop', '', '-=AUTONAME=-', NULL, 'top_panel_page_prop', '', 0),
(65, 'top_panel_edit_page_html', '', '-=AUTONAME=-', NULL, 'top_panel_edit_page_html', '', 0),
(67, 'top_panel_edit_page_php', '', '-=AUTONAME=-', NULL, 'top_panel_edit_page_php', '', 0),
(68, 'top_panel_del_page', '', '-=AUTONAME=-', NULL, 'top_panel_del_page', '', 0),
(69, 'top_panel_folder_prop', '', '-=AUTONAME=-', NULL, 'top_panel_folder_prop', '', 0),
(70, 'top_panel_access_folder_new', '', '-=AUTONAME=-', NULL, 'top_panel_access_folder_new', '', 0),
(71, 'main_top_panel_struct_panel', '', '-=AUTONAME=-', NULL, 'main_top_panel_struct_panel', '', 0),
(72, 'top_panel_cache_page', '', '-=AUTONAME=-', NULL, 'top_panel_cache_page', '', 0),
(73, 'top_panel_cache_comp', '', '-=AUTONAME=-', NULL, 'top_panel_cache_comp', '', 0),
(74, 'top_panel_cache_not', '', '-=AUTONAME=-', NULL, 'top_panel_cache_not', '', 0),
(75, 'top_panel_edit_mode', '', '-=AUTONAME=-', NULL, 'top_panel_edit_mode', '', 0),
(76, 'top_panel_templ_site_css', '', '-=AUTONAME=-', NULL, 'top_panel_templ_site_css', '', 0),
(77, 'top_panel_templ_templ_css', '', '-=AUTONAME=-', NULL, 'top_panel_templ_templ_css', '', 0),
(78, 'top_panel_templ_site', '', '-=AUTONAME=-', NULL, 'top_panel_templ_site', '', 0),
(81, 'top_panel_debug_time', '', '-=AUTONAME=-', NULL, 'top_panel_debug_time', '', 0),
(82, 'top_panel_debug_incl', '', '-=AUTONAME=-', NULL, 'top_panel_debug_incl', '', 0),
(83, 'top_panel_debug_sql', '', '-=AUTONAME=-', NULL, 'top_panel_debug_sql', NULL, 0),
(84, 'top_panel_debug_compr', '', '-=AUTONAME=-', NULL, 'top_panel_debug_compr', '', 0),
(85, 'MTP_SHORT_URI1', '', '-=AUTONAME=-', NULL, 'MTP_SHORT_URI1', '', 0),
(86, 'MTP_SHORT_URI_LIST', '', '-=AUTONAME=-', NULL, 'MTP_SHORT_URI_LIST', '', 0),
(87, 'FMST_PANEL_STICKER_ADD', '', '-=AUTONAME=-', NULL, 'FMST_PANEL_STICKER_ADD', '', 0),
(88, 'FMST_PANEL_STICKERS_SHOW', '', '-=AUTONAME=-', NULL, 'FMST_PANEL_STICKERS_SHOW', '', 0),
(89, 'FMST_PANEL_CUR_STICKER_LIST', '', '-=AUTONAME=-', NULL, 'FMST_PANEL_CUR_STICKER_LIST', '', 0),
(90, 'FMST_PANEL_ALL_STICKER_LIST', '', '-=AUTONAME=-', NULL, 'FMST_PANEL_ALL_STICKER_LIST', '', 0),
(91, 'top_panel_menu', 'var d=BX(\"bx-panel-menu\"); if (d) d.click();', '-=AUTONAME=-', NULL, 'bx-panel-menu', '', 0),
(92, 'top_panel_admin', 'var d=BX(\'bx-panel-admin-tab\'); if (d) location.href = d.href;', '-=AUTONAME=-', NULL, 'bx-panel-admin-tab', '', 0),
(93, 'admin_panel_site', 'var d=BX(\'bx-panel-view-tab\'); if (d) location.href = d.href;', '-=AUTONAME=-', NULL, 'bx-panel-view-tab', '', 0),
(94, 'admin_panel_admin', 'var d=BX(\'bx-panel-admin-tab\'); if (d) location.href = d.href;', '-=AUTONAME=-', NULL, 'bx-panel-admin-tab', '', 0),
(96, 'top_panel_folder_prop_new', '', '-=AUTONAME=-', NULL, 'top_panel_folder_prop_new', '', 0),
(97, 'main_top_panel_structure', '', '-=AUTONAME=-', NULL, 'main_top_panel_structure', '', 0),
(98, 'top_panel_clear_cache', '', '-=AUTONAME=-', NULL, 'top_panel_clear_cache', '', 0),
(99, 'top_panel_templ', '', '-=AUTONAME=-', NULL, 'top_panel_templ', '', 0),
(100, 'top_panel_debug', '', '-=AUTONAME=-', NULL, 'top_panel_debug', '', 0),
(101, 'MTP_SHORT_URI', '', '-=AUTONAME=-', NULL, 'MTP_SHORT_URI', '', 0),
(102, 'FMST_PANEL_STICKERS', '', '-=AUTONAME=-', NULL, 'FMST_PANEL_STICKERS', '', 0),
(103, 'top_panel_settings', '', '-=AUTONAME=-', NULL, 'top_panel_settings', '', 0),
(104, 'top_panel_fav', '', '-=AUTONAME=-', NULL, 'top_panel_fav', '', 0),
(106, 'Global', 'location.href=\'/bitrix/admin/hot_keys_list.php?lang=ru\';', 'HK_DB_SHW_HK', '', '', '', 0),
(107, 'top_panel_edit_new', '', '-=AUTONAME=-', NULL, 'top_panel_edit_new', '', 0),
(108, 'FLOW_PANEL_CREATE_WITH_WF', '', '-=AUTONAME=-', NULL, 'FLOW_PANEL_CREATE_WITH_WF', '', 0),
(109, 'FLOW_PANEL_EDIT_WITH_WF', '', '-=AUTONAME=-', NULL, 'FLOW_PANEL_EDIT_WITH_WF', '', 0),
(110, 'FLOW_PANEL_HISTORY', '', '-=AUTONAME=-', NULL, 'FLOW_PANEL_HISTORY', '', 0),
(111, 'top_panel_create_new', '', '-=AUTONAME=-', NULL, 'top_panel_create_new', '', 0),
(112, 'top_panel_create_folder_new', '', '-=AUTONAME=-', NULL, 'top_panel_create_folder_new', '', 0),
(116, 'bx-panel-toggle', '', '-=AUTONAME=-', NULL, 'bx-panel-toggle', '', 0),
(117, 'bx-panel-small-toggle', '', '-=AUTONAME=-', NULL, 'bx-panel-small-toggle', '', 0),
(118, 'bx-panel-expander', 'var d=BX(\'bx-panel-expander\'); if (d) BX.fireEvent(d, \'click\');', '-=AUTONAME=-', NULL, 'bx-panel-expander', '', 0),
(119, 'bx-panel-hider', 'var d=BX(\'bx-panel-hider\'); if (d) d.click();', '-=AUTONAME=-', NULL, 'bx-panel-hider', '', 0),
(120, 'search-textbox-input', 'var d=BX(\'search-textbox-input\'); if (d) { d.click(); d.focus();}', '-=AUTONAME=-', '', 'search', '', 0),
(121, 'bx-search-input', 'var d=BX(\'bx-search-input\'); if (d) { d.click(); d.focus(); }', '-=AUTONAME=-', '', 'bx-search-input', '', 0),
(133, 'bx-panel-logout', 'var d=BX(\'bx-panel-logout\'); if (d) location.href = d.href;', '-=AUTONAME=-', '', 'bx-panel-logout', '', 0),
(135, 'CDialog', 'var d=BX(\'cancel\'); if (d) d.click();', 'HK_DB_D_CANCEL', '', 'cancel', '', 0),
(136, 'CDialog', 'var d=BX(\'close\'); if (d) d.click();', 'HK_DB_D_CLOSE', '', 'close', '', 0),
(137, 'CDialog', 'var d=BX(\'savebtn\'); if (d) d.click();', 'HK_DB_D_SAVE', '', 'savebtn', '', 0),
(138, 'CDialog', 'var d=BX(\'btn_popup_save\'); if (d) d.click();', 'HK_DB_D_EDIT_SAVE', '', 'btn_popup_save', '', 0),
(139, 'Global', 'location.href=\'/bitrix/admin/user_admin.php?lang=\'+phpVars.LANGUAGE_ID;', 'HK_DB_SHW_U', '', '', '', 0);
-- -----------------------------------
-- Dumping table b_iblock
-- -----------------------------------
DROP TABLE IF EXISTS `b_iblock`;
CREATE TABLE `b_iblock` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `IBLOCK_TYPE_ID` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LID` char(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CODE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `API_CODE` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `REST_ON` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `SORT` int NOT NULL DEFAULT '500',
  `LIST_PAGE_URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `DETAIL_PAGE_URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECTION_PAGE_URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CANONICAL_PAGE_URL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PICTURE` int DEFAULT NULL,
  `DESCRIPTION` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DESCRIPTION_TYPE` char(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `RSS_TTL` int NOT NULL DEFAULT '24',
  `RSS_ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `RSS_FILE_ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `RSS_FILE_LIMIT` int DEFAULT NULL,
  `RSS_FILE_DAYS` int DEFAULT NULL,
  `RSS_YANDEX_ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TMP_ID` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `INDEX_ELEMENT` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `INDEX_SECTION` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `WORKFLOW` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `BIZPROC` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `SECTION_CHOOSER` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `LIST_MODE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `RIGHTS_MODE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECTION_PROPERTY` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `PROPERTY_INDEX` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `VERSION` int NOT NULL DEFAULT '1',
  `LAST_CONV_ELEMENT` int NOT NULL DEFAULT '0',
  `SOCNET_GROUP_ID` int DEFAULT NULL,
  `EDIT_FILE_BEFORE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `EDIT_FILE_AFTER` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECTIONS_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `SECTION_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ELEMENTS_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `ELEMENT_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ix_iblock_api_code` (`API_CODE`),
  KEY `ix_iblock` (`IBLOCK_TYPE_ID`,`LID`,`ACTIVE`),
  KEY `ix_iblock_code` (`CODE`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_iblock` VALUES
(1, '2023-04-27 00:09:26', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_complects', NULL, 'N', 'Комплекты', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_complects_s1', '2f2275bd3533937d69acd925ee9f6fdf', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(2, '2023-04-27 00:09:27', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_front_tizers', NULL, 'N', 'Тизеры', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_front_tizers_s1', 'aee21a43311d374c9a51f9fd4bbd52d8', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(3, '2023-04-27 00:09:29', 'aspro_allcorp3resort_regionality', 's1', 'aspro_allcorp3resort_regions', NULL, 'N', 'Регионы', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_regions_s1', '6b7de8c21ed43e24e84a037a319bc590', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Города', 'Город'),
(4, '2023-04-27 00:09:30', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_megamenu', NULL, 'N', 'Мегаменю', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_megamenu_s1', '028dbe0c4ffadbf26ab0ea7e875247ff', 'N', 'N', 'N', 'N', 'L', NULL, 'S', NULL, NULL, 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(5, '2023-04-27 00:09:33', 'aspro_allcorp3resort_mainblocks', 's1', 'aspro_allcorp3resort_mainblocks', NULL, 'N', 'Дополнительные блоки на главной', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_mainblocks_s1', 'e66cede68d49fa560d082edd9dd14023', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', NULL, NULL, 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(6, '2023-04-27 00:09:34', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_banner_types', NULL, 'N', 'Типы баннеров', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_banner_types_s1', '0e58c4a76b6dd9905aedaa64292a0387', 'N', 'N', 'N', 'N', 'L', NULL, 'S', NULL, NULL, 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Типы баннеров', 'Тип баннеров'),
(7, '2023-04-27 00:09:35', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_gallery', NULL, 'N', 'Галерея', 'Y', 500, '#SITE_DIR#/gallery/', '#SITE_DIR#/gallery/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', '#SITE_DIR#/gallery/#SECTION_CODE_PATH#', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_gallery_s1', 'b5985682cae3c34212a2fa1200a67229', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Альбом', 'Альбом'),
(8, '2023-04-27 00:09:36', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_docs', NULL, 'N', 'Документы', 'Y', 500, '#SITE_DIR#company/docs/', '#SITE_DIR#company/docs/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_docs_s1', '6a430572ab6359f3b5f7c0f0fff98605', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Документы', 'Документ'),
(9, '2023-04-27 00:09:37', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_example', NULL, 'N', 'Пример формы', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Описание примера формы.', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_example_s1', '1719b98fdc1cc2d8acb15d551b3f6b2f', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(10, '2023-04-27 00:09:38', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_order_project', NULL, 'N', 'Заказать проект', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_order_project_s1', 'cf87fe9b01996cc069c5f5bee39bc962', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(11, '2023-04-27 00:09:38', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_order_product', NULL, 'N', 'Забронировать', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Менеджеры базы отдыха подробно расскажут об условиях проживания, услугах, ценах и акциях. Ответят на любые ваши вопросы', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_order_product_s1', '8c48eec96514140b4c6bd693cc6fcdac', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(12, '2023-04-27 00:09:39', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_order_services', NULL, 'N', 'Заказать услугу', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_order_services_s1', '47114e0492a8b47d4ceb9d15f6ddac1b', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(13, '2023-04-27 00:09:40', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_resume', NULL, 'N', 'Отправить резюме', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_resume_s1', '1a62e9e1f38a905230a8fffc57407995', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(14, '2023-04-27 00:09:40', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_question', NULL, 'N', 'Задать вопрос', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Менеджеры базы отдыха подробно расскажут об условиях проживания, услугах, ценах и акциях. Ответят на любые ваши вопросы', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_question_s1', '5d1506250f019054c6162b4609f11395', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(15, '2023-04-27 00:09:41', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_callback', NULL, 'N', 'Обратный звонок', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Представьтесь, мы вам перезвоним.', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_callback_s1', 'e1ff4e17e597fcc0a21649de4c949c06', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(16, '2023-04-27 00:09:42', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_order_page', NULL, 'N', 'Оформление заказа', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Заполните простую форму, и наши менеджеры свяжутся с вами, ответят на любые вопросы и подготовят счет на оплату', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_order_page_s1', '402cc649fe3d1b5d6dcb5594103c5f6e', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(17, '2023-04-27 00:09:42', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_director', NULL, 'N', 'Написать директору', 'Y', 500, NULL, NULL, NULL, NULL, NULL, 'Если у вас возникли вопросы по поводу работы наших сотрудников или компании в целом, а также если вы хотите сказать слова благодарности, напишите сообщение и оно придет директору лично', 'html', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_director_s1', '9b5d970d6d8af51b08bb94fe007fefb1', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(18, '2023-04-27 00:09:43', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_callstaff', NULL, 'N', 'Написать сотруднику', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_callstaff_s1', '4b22cff5ce4d9a14d4afb962733bf27f', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(19, '2023-04-27 00:09:43', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_feedback', NULL, 'N', 'Оставить отзыв', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_feedback_s1', 'e29bc79df1185b3a06cb6f0fc483d2f2', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Результаты', 'Результат'),
(20, '2023-04-27 00:09:44', 'aspro_allcorp3resort_form', 's1', 'aspro_allcorp3resort_quick_buy', NULL, 'N', 'Купить в 1 клик', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_quick_buy_s1', '2eb084063ad03461163e2336e4477f90', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(21, '2023-04-27 00:09:45', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_sku', NULL, 'N', 'Торговые предложения', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_sku_s1', '181cc1c7e75134be769b8a85d6d93a83', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(22, '2023-04-27 00:09:46', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_bottom_icons', NULL, 'N', 'Нижняя панель с иконками', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_bottom_icons_s1', '28f866527b590a3660bbcbb60c2cd60e', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(23, '2023-04-27 00:09:48', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_advtbig', NULL, 'N', 'Большие баннеры', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_advtbig_s1', '0c72a74ce0151b8a34c9ff11da00868c', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Банеры', 'Банер'),
(24, '2023-04-27 00:09:49', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_banners', NULL, 'N', 'Баннерные позиции', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_banners_s1', 'b659c6e58191d6655c2865d397a9ba5a', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(25, '2023-04-27 00:09:50', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_vacancy', NULL, 'N', 'Вакансии', 'Y', 500, '#SITE_DIR#company/vacancy/', '#SITE_DIR#company/vacancy/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_vacancy_s1', '6452c8301a1fffe77ac2b84071c14765', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Вакансии', 'Вакансия'),
(26, '2023-04-27 00:09:51', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_faq', NULL, 'N', 'Вопросы и ответы', 'Y', 500, '#SITE_DIR#info/faq/', NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_faq_s1', '65c0fcd901f294c2c59b46912e3ae897', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Вопросы', 'Вопрос'),
(27, '2023-06-30 21:48:24', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_price', NULL, 'N', 'Цены', 'Y', 500, '#SITE_DIR#price/', '#SITE_DIR#price/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', '#SITE_DIR#price/#SECTION_CODE_PATH#/', '#SITE_DIR#price/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_price_s1', '4a76f00bd0e60cbc2b9847dc47448c87', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Цены', 'Цена'),
(28, '2023-04-27 00:09:54', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_brands', NULL, 'N', 'Представительства', 'Y', 500, '#SITE_DIR#company/brands/', '#SITE_DIR#company/brands/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_brands_s1', 'db7957cf325ea93687ebb1364ba87d45', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Производители', 'Производитель'),
(29, '2023-04-27 00:09:55', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_licenses', NULL, 'N', 'Лицензии и сертификаты', 'Y', 500, '#SITE_DIR#company/licenses/', '#SITE_DIR#company/licenses/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_licenses_s1', '511dbc8765b95ea142795e4c66e1c08d', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Лицензии', 'Лицензия'),
(30, '2023-04-27 00:09:56', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_history', NULL, 'N', 'История', 'Y', 500, '#SITE_DIR#company/history/', NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_history_s1', '8f3a7162b6f59a0e1196c27befc34c78', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(31, '2023-07-07 11:54:23', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_contact', NULL, 'N', 'Контакты', 'Y', 500, NULL, '#SITE_DIR#/contacts/#SECTION_CODE#/#ELEMENT_ID#/', '#SITE_DIR#/contacts/#SECTION_CODE#/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_contact_s1', 'da4cabfd159c889c59dbffd6d17e852e', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(32, '2023-04-27 00:09:58', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_adv_content', NULL, 'N', 'Реклама - Баннеры картинками', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_adv_content_s1', '41d4b8711dd3785a43c780aece6a69c1', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(33, '2023-04-27 00:09:59', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_company', NULL, 'N', 'О компании', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_company_s1', 'e45ba1d6bf8fa8364155d6673966ddac', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(34, '2023-04-27 00:10:00', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_banners_fon', NULL, 'N', 'Реклама - Баннеры с фоном', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_banners_fon_s1', 'e7a52c6923f256586194dbd6f5e45320', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(35, '2023-04-27 00:10:02', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_reviews', NULL, 'N', 'Отзывы клиентов', 'Y', 500, '#SITE_DIR#company/reviews/', NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_reviews_s1', '4a3ec9842566a3972724c1d770e577f2', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Отзывы', 'Отзыв'),
(36, '2023-04-27 00:10:27', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_tarifs', NULL, 'N', 'Туры', 'Y', 500, '#SITE_DIR#tours/', '#SITE_DIR#tours/#ELEMENT_CODE#/', '#SITE_DIR#tours/#SECTION_CODE_PATH#/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_tarifs_s1', 'b872d6ea92ad7b7be540814ad651a729', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Тариф', 'Тариф'),
(37, '2023-04-27 00:10:08', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_partners', NULL, 'N', 'Туроператоры', 'Y', 500, '#SITE_DIR#company/partners/', '#SITE_DIR#company/partners/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_partners_s1', '7db34a23d3dc8e472ef89b05151cd73e', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Партнеры', 'Партнер'),
(38, '2023-07-06 00:05:38', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_articles', NULL, 'N', 'Статьи', 'Y', 500, '#SITE_DIR#articles/', '#SITE_DIR#articles/#SECTION_CODE#/#ELEMENT_CODE#/', '#SITE_DIR#articles/#SECTION_CODE#/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_articles_s1', '14957475e80f08406a535e4196118594', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Статьи', 'Статья'),
(39, '2023-04-27 00:10:27', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_news', NULL, 'N', 'События', 'Y', 500, '#SITE_DIR#news/', '#SITE_DIR#news/#ELEMENT_CODE#/', '#SITE_DIR#news/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_news_s1', '294545369e04446b2e8e9dc33f073498', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Новости', 'Новость'),
(40, '2023-04-27 00:10:27', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_sales', NULL, 'N', 'Акции', 'Y', 500, '#SITE_DIR#sales/', '#SITE_DIR#sales/#ELEMENT_CODE#/', '#SITE_DIR#sales/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_sales_s1', '545135b4119a0339951ea0a07cffd55d', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Акции', 'Акция'),
(41, '2023-07-07 18:14:45', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_staff', NULL, 'N', 'Сотрудники', 'Y', 500, '#SITE_DIR#company/staff/', '#SITE_DIR#company/staff/#ELEMENT_CODE#/', NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_staff_s1', '5bb3bb91b2a4a9e11f79a0219b144d01', 'Y', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Сотрудники', 'Сотрудник'),
(42, '2023-04-27 00:10:27', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_projects', NULL, 'N', 'Карта', 'Y', 500, '#SITE_DIR#map/', '#SITE_DIR#map/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', '#SITE_DIR#map/#SECTION_CODE_PATH#/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_projects_s1', '5be4a9ab7d415e6532d52d8c59c18495', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Проекты', 'Проект'),
(43, '2023-07-05 22:50:39', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_services', NULL, 'N', 'Услуги', 'Y', 500, '#SITE_DIR#services/', '#SITE_DIR#services/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', '#SITE_DIR#services/#SECTION_CODE_PATH#/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_services_s1', '45cc3820592c7a3d525dd360b3ae09f8', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Услуги', 'Услуга'),
(44, '2024-06-20 14:16:01', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_catalog', NULL, 'N', 'Проживание', 'Y', 500, '#SITE_DIR#product/', '#SITE_DIR#product/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', '#SITE_DIR#product/#SECTION_CODE_PATH#/', '#SITE_DIR#product/#SECTION_CODE_PATH#/#ELEMENT_CODE#/', NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_catalog_s1', '1e91822f83f2030d39c4b14dc1792c03', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Варианта', 'Элемент'),
(45, '2023-04-27 00:10:22', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_catalog_info', NULL, 'N', 'Посадочные в каталоге', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_catalog_info_s1', '8d61a240930f135ee12b8726bdbf2d06', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(46, '2023-04-27 00:10:27', 'aspro_allcorp3resort_content', 's1', 'aspro_allcorp3resort_news_personal', NULL, 'N', 'Новости в личном кабинете', 'Y', 500, '#SITE_DIR#cabinet/news/', '#SITE_DIR#cabinet/news/#ELEMENT_CODE#/', '#SITE_DIR#cabinet/news/', NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_news_personal_s1', '31737de757c14b91b55046012e65ac88', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'I', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Новости', 'Новость'),
(47, '2023-04-27 00:10:24', 'aspro_allcorp3resort_catalog', 's1', 'aspro_allcorp3resort_landing', NULL, 'N', 'Обзоры', 'Y', 500, '#SITE_DIR#landings/', '#SITE_DIR#landings/#ELEMENT_CODE#/', '#SITE_DIR#landings/', '#SITE_DIR#landings/#ELEMENT_CODE#/', NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_landing_s1', '8df34f436be51b9d53f57fbf8d2ba03f', 'Y', 'Y', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(48, '2023-04-27 00:10:25', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_marketings', NULL, 'N', 'Маркетинговые окна', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_marketings_s1', 'f446cc1089f42e50c3857e864429bf23', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент'),
(49, '2023-04-27 00:10:26', 'aspro_allcorp3resort_adv', 's1', 'aspro_allcorp3resort_banners_with_text', NULL, 'N', 'Реклама - Баннеры с текстом', 'Y', 500, NULL, NULL, NULL, NULL, NULL, NULL, 'text', 24, 'Y', 'N', NULL, NULL, 'N', 'aspro_allcorp3resort_banners_with_text_s1', '2c3c105af7a626a95262fe5f0ee78dd6', 'N', 'N', 'N', 'N', 'L', NULL, 'S', 'Y', 'N', 1, 0, NULL, NULL, NULL, 'Разделы', 'Раздел', 'Элементы', 'Элемент');
-- -----------------------------------
-- Dumping table b_iblock_cache
-- -----------------------------------
DROP TABLE IF EXISTS `b_iblock_cache`;
CREATE TABLE `b_iblock_cache` (
  `CACHE_KEY` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CACHE` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CACHE_DATE` datetime NOT NULL,
  PRIMARY KEY (`CACHE_KEY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- -----------------------------------
-- Dumping table b_iblock_element
-- -----------------------------------
DROP TABLE IF EXISTS `b_iblock_element`;
CREATE TABLE `b_iblock_element` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TIMESTAMP_X` datetime DEFAULT NULL,
  `MODIFIED_BY` int DEFAULT NULL,
  `DATE_CREATE` datetime DEFAULT NULL,
  `CREATED_BY` int DEFAULT NULL,
  `IBLOCK_ID` int NOT NULL DEFAULT '0',
  `IBLOCK_SECTION_ID` int DEFAULT NULL,
  `ACTIVE` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'Y',
  `ACTIVE_FROM` datetime DEFAULT NULL,
  `ACTIVE_TO` datetime DEFAULT NULL,
  `SORT` int NOT NULL DEFAULT '500',
  `NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PREVIEW_PICTURE` int DEFAULT NULL,
  `PREVIEW_TEXT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `PREVIEW_TEXT_TYPE` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `DETAIL_PICTURE` int DEFAULT NULL,
  `DETAIL_TEXT` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `DETAIL_TEXT_TYPE` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'text',
  `SEARCHABLE_CONTENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `WF_STATUS_ID` int DEFAULT '1',
  `WF_PARENT_ELEMENT_ID` int DEFAULT NULL,
  `WF_NEW` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `WF_LOCKED_BY` int DEFAULT NULL,
  `WF_DATE_LOCK` datetime DEFAULT NULL,
  `WF_COMMENTS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `IN_SECTIONS` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'N',
  `XML_ID` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `CODE` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TAGS` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `TMP_ID` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `WF_LAST_HISTORY_ID` int DEFAULT NULL,
  `SHOW_COUNTER` int DEFAULT NULL,
  `SHOW_COUNTER_START` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ix_iblock_element_1` (`IBLOCK_ID`,`IBLOCK_SECTION_ID`),
  KEY `ix_iblock_element_4` (`IBLOCK_ID`,`XML_ID`,`WF_PARENT_ELEMENT_ID`),
  KEY `ix_iblock_element_3` (`WF_PARENT_ELEMENT_ID`),
  KEY `ix_iblock_element_code` (`IBLOCK_ID`,`CODE`),
  KEY `ix_iblock_element_name` (`IBLOCK_ID`,`NAME`)
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `b_iblock_element` VALUES
(1, '2023-04-27 00:09:26', 1, '2023-04-27 00:09:26', 1, 1, NULL, 'Y', NULL, NULL, 80, 'Классическое шале «Лесной мишка» + Немецкое шале «Три грозы»', NULL, '', 'text', NULL, '', 'text', 'КЛАССИЧЕСКОЕ ШАЛЕ «ЛЕСНОЙ МИШКА» + НЕМЕЦКОЕ ШАЛЕ «ТРИ ГРОЗЫ»\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '854', '', '', '1831461373', NULL, NULL, NULL),
(2, '2023-06-29 21:03:25', 1, '2023-04-27 00:09:27', 1, 2, 3, 'Y', NULL, NULL, 390, 'Комфортное проживание', 7, '100%', 'text', 8, 'Ухоженные апартаменты<br>с включенным завтраком\r\n', 'html', 'КОМФОРТНОЕ ПРОЖИВАНИЕ\r\n100%\r\nУХОЖЕННЫЕ АПАРТАМЕНТЫ\r\nС ВКЛЮЧЕННЫМ ЗАВТРАКОМ', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1508', '', '', '0', NULL, NULL, NULL),
(3, '2023-04-27 00:09:27', 1, '2023-04-27 00:09:27', 1, 2, 3, 'Y', NULL, NULL, 390, 'Безопасный отдых', NULL, '5 км<sup>2</sup>', 'html', 10, 'Территория базы огорожена <br>и хорошо охраняется\r\n', 'html', 'БЕЗОПАСНЫЙ ОТДЫХ\r\n5 КМ2\r\nТЕРРИТОРИЯ БАЗЫ ОГОРОЖЕНА \r\nИ ХОРОШО ОХРАНЯЕТСЯ', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1909', '', '', '2108325052', NULL, NULL, NULL),
(4, '2023-04-27 00:09:27', 1, '2023-04-27 00:09:27', 1, 2, 3, 'Y', NULL, NULL, 390, 'Вежливый персонал', NULL, '24/7', 'text', 12, 'Гарантируем качественное <br>\r\nобслуживание отдыхающих', 'html', 'ВЕЖЛИВЫЙ ПЕРСОНАЛ\r\n24/7\r\nГАРАНТИРУЕМ КАЧЕСТВЕННОЕ \r\nОБСЛУЖИВАНИЕ ОТДЫХАЮЩИХ', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1910', '', '', '1568562143', NULL, NULL, NULL),
(5, '2023-04-27 00:09:28', 1, '2023-04-27 00:09:28', 1, 2, 3, 'Y', NULL, NULL, 390, 'Регулярные мероприятия', NULL, '15 лет', 'text', 14, 'Организуем на базе эстафеты, <br>конкурсы и вечеринки', 'html', 'РЕГУЛЯРНЫЕ МЕРОПРИЯТИЯ\r\n15 ЛЕТ\r\nОРГАНИЗУЕМ НА БАЗЕ ЭСТАФЕТЫ, \r\nКОНКУРСЫ И ВЕЧЕРИНКИ', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1911', '', '', '-2068186281', NULL, NULL, NULL),
(6, '2023-04-27 00:09:29', 1, '2023-04-27 00:09:29', 1, 3, 6, 'Y', NULL, NULL, 500, 'Москва', NULL, '<p>\r\n	 Любители активного отдыха восхищаются нашим горнолыжным комплексом, трассами для мотокросса и регулярными спортивными мероприятиями. В санатории предусмотрены полезные лечебно-оздоровительные программы и мангальные зоны для комфортного досуга наших гостей.\r\n</p>\r\n<p>\r\n	 Обычно у нас отдыхают от недели до месяца, но приезжают и просто на выходные. Вы можете расположиться в номере нашей гостиницы или горном шале на 6-14 человек. Желающим стать одним целым с природой мы предлагаем безопасные площадки для кемпинга. Если при этом вы нуждаетесь в комфорте — глэмпинговые лагеря к вашим услугам!\r\n</p>', 'html', NULL, 'База отдыха Аспро: Курорт 2.0 располагается на берегу Талбецкого озера в южной части Босмерских гор. К нам приезжают всей семьей, чтобы отдохнуть от городской суеты, почувствовать единение с природой в лесу и на горных склонах.\r\n\r\n', 'html', 'МОСКВА\r\nЛЮБИТЕЛИ АКТИВНОГО ОТДЫХА ВОСХИЩАЮТСЯ \r\nНАШИМ ГОРНОЛЫЖНЫМ КОМПЛЕКСОМ, ТРАССАМИ ДЛЯ МОТОКРОССА И РЕГУЛЯРНЫМИ СПОРТИВНЫМИ МЕРОПРИЯТИЯМИ. В САНАТОРИИ ПРЕДУСМОТРЕНЫ ПОЛЕЗНЫЕ ЛЕЧЕБНО-ОЗДОРОВИТЕЛЬНЫЕ ПРОГРАММЫ И МАНГАЛЬНЫЕ ЗОНЫ ДЛЯ КОМФОРТНОГО ДОСУГА НАШИХ ГОСТЕЙ. \r\n\r\nОБЫЧНО У НАС ОТДЫХАЮТ ОТ НЕДЕЛИ ДО МЕСЯЦА, \r\nНО ПРИЕЗЖАЮТ И ПРОСТО НА ВЫХОДНЫЕ. ВЫ МОЖЕТЕ РАСПОЛОЖИТЬСЯ В НОМЕРЕ НАШЕЙ ГОСТИНИЦЫ ИЛИ ГОРНОМ ШАЛЕ НА 6-14 ЧЕЛОВЕК. ЖЕЛАЮЩИМ СТАТЬ ОДНИМ ЦЕЛЫМ С ПРИРОДОЙ МЫ ПРЕДЛАГАЕМ БЕЗОПАСНЫЕ ПЛОЩАДКИ ДЛЯ КЕМПИНГА. ЕСЛИ ПРИ ЭТОМ ВЫ НУЖДАЕТЕСЬ В КОМФОРТЕ — ГЛЭМПИНГОВЫЕ ЛАГЕРЯ К ВАШИМ УСЛУГАМ!\r\nБАЗА ОТДЫХА АСПРО: КУРОРТ 2.0 РАСПОЛАГАЕТСЯ \r\nНА БЕРЕГУ ТАЛБЕЦКОГО ОЗЕРА В ЮЖНОЙ ЧАСТИ БОСМЕРСКИХ ГОР. К НАМ ПРИЕЗЖАЮТ ВСЕЙ СЕМЬЕЙ, ЧТОБЫ ОТДОХНУТЬ ОТ ГОРОДСКОЙ СУЕТЫ, ПОЧУВСТВОВАТЬ ЕДИНЕНИЕ С ПРИРОДОЙ В ЛЕСУ И НА ГОРНЫХ СКЛОНАХ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '3212', '', '', '762449090', NULL, NULL, NULL),
(7, '2023-04-27 00:09:29', 1, '2023-04-27 00:09:29', 1, 3, 9, 'Y', NULL, NULL, 50, 'Челябинск', NULL, '<p>\r\n	 Любители активного отдыха восхищаются нашим горнолыжным комплексом, трассами для мотокросса и регулярными спортивными мероприятиями. В санатории предусмотрены полезные лечебно-оздоровительные программы и мангальные зоны для комфортного досуга наших гостей.\r\n</p>\r\n<p>\r\n	 Обычно у нас отдыхают от недели до месяца, но приезжают и просто на выходные. Вы можете расположиться в номере нашей гостиницы или горном шале на 6-14 человек. Желающим стать одним целым с природой мы предлагаем безопасные площадки для кемпинга. Если при этом вы нуждаетесь в комфорте — глэмпинговые лагеря к вашим услугам!\r\n</p>\r\n<ul>\r\n</ul>\r\n<p>\r\n	 Развивайте бизнес, масштабируйте и выстраивайте крепкие отношения с клиентами.\r\n</p>', 'html', NULL, 'База отдыха Аспро: Курорт 2.0 располагается на берегу Талбецкого озера в южной части Босмерских гор. К нам приезжают всей семьей, чтобы отдохнуть от городской суеты, почувствовать единение с природой в лесу и на горных склонах.', 'html', 'ЧЕЛЯБИНСК\r\nЛЮБИТЕЛИ АКТИВНОГО ОТДЫХА ВОСХИЩАЮТСЯ \r\nНАШИМ ГОРНОЛЫЖНЫМ КОМПЛЕКСОМ, ТРАССАМИ ДЛЯ МОТОКРОССА И РЕГУЛЯРНЫМИ СПОРТИВНЫМИ МЕРОПРИЯТИЯМИ. В САНАТОРИИ ПРЕДУСМОТРЕНЫ ПОЛЕЗНЫЕ ЛЕЧЕБНО-ОЗДОРОВИТЕЛЬНЫЕ ПРОГРАММЫ И МАНГАЛЬНЫЕ ЗОНЫ ДЛЯ КОМФОРТНОГО ДОСУГА НАШИХ ГОСТЕЙ. \r\n\r\nОБЫЧНО У НАС ОТДЫХАЮТ ОТ НЕДЕЛИ ДО МЕСЯЦА, \r\nНО ПРИЕЗЖАЮТ И ПРОСТО НА ВЫХОДНЫЕ. ВЫ МОЖЕТЕ РАСПОЛОЖИТЬСЯ В НОМЕРЕ НАШЕЙ ГОСТИНИЦЫ ИЛИ ГОРНОМ ШАЛЕ НА 6-14 ЧЕЛОВЕК. ЖЕЛАЮЩИМ СТАТЬ ОДНИМ ЦЕЛЫМ С ПРИРОДОЙ МЫ ПРЕДЛАГАЕМ БЕЗОПАСНЫЕ ПЛОЩАДКИ ДЛЯ КЕМПИНГА. ЕСЛИ ПРИ ЭТОМ ВЫ НУЖДАЕТЕСЬ В КОМФОРТЕ — ГЛЭМПИНГОВЫЕ ЛАГЕРЯ К ВАШИМ УСЛУГАМ! \r\n \r\n\r\nРАЗВИВАЙТЕ БИЗНЕС, МАСШТАБИРУЙТЕ И ВЫСТРАИВАЙТЕ \r\nКРЕПКИЕ ОТНОШЕНИЯ С КЛИЕНТАМИ.\r\nБАЗА ОТДЫХА АСПРО: КУРОРТ 2.0 РАСПОЛАГАЕТСЯ \r\nНА БЕРЕГУ ТАЛБЕЦКОГО ОЗЕРА В ЮЖНОЙ ЧАСТИ БОСМЕРСКИХ ГОР. К НАМ ПРИЕЗЖАЮТ ВСЕЙ СЕМЬЕЙ, ЧТОБЫ ОТДОХНУТЬ ОТ ГОРОДСКОЙ СУЕТЫ, ПОЧУВСТВОВАТЬ ЕДИНЕНИЕ С ПРИРОДОЙ В ЛЕСУ И НА ГОРНЫХ СКЛОНАХ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '3213', '', '', '1471296004', NULL, NULL, NULL),
(8, '2023-04-27 00:09:29', 1, '2023-04-27 00:09:29', 1, 3, 8, 'Y', NULL, NULL, 500, 'Екатеринбург', NULL, '<p>\r\n	 Любители активного отдыха восхищаются нашим горнолыжным комплексом, трассами для мотокросса и регулярными спортивными мероприятиями. В санатории предусмотрены полезные лечебно-оздоровительные программы и мангальные зоны для комфортного досуга наших гостей.\r\n</p>\r\n<p>\r\n	 Обычно у нас отдыхают от недели до месяца, но приезжают и просто на выходные. Вы можете расположиться в номере нашей гостиницы или горном шале на 6-14 человек. Желающим стать одним целым с природой мы предлагаем безопасные площадки для кемпинга. Если при этом вы нуждаетесь в комфорте — глэмпинговые лагеря к вашим услугам!\r\n</p>', 'html', NULL, 'База отдыха Аспро: Курорт 2.0 располагается на берегу Талбецкого озера в южной части Босмерских гор. К нам приезжают всей семьей, чтобы отдохнуть от городской суеты, почувствовать единение с природой в лесу и на горных склонах.', 'html', 'ЕКАТЕРИНБУРГ\r\nЛЮБИТЕЛИ АКТИВНОГО ОТДЫХА ВОСХИЩАЮТСЯ \r\nНАШИМ ГОРНОЛЫЖНЫМ КОМПЛЕКСОМ, ТРАССАМИ ДЛЯ МОТОКРОССА И РЕГУЛЯРНЫМИ СПОРТИВНЫМИ МЕРОПРИЯТИЯМИ. В САНАТОРИИ ПРЕДУСМОТРЕНЫ ПОЛЕЗНЫЕ ЛЕЧЕБНО-ОЗДОРОВИТЕЛЬНЫЕ ПРОГРАММЫ И МАНГАЛЬНЫЕ ЗОНЫ ДЛЯ КОМФОРТНОГО ДОСУГА НАШИХ ГОСТЕЙ. \r\n\r\nОБЫЧНО У НАС ОТДЫХАЮТ ОТ НЕДЕЛИ ДО МЕСЯЦА, \r\nНО ПРИЕЗЖАЮТ И ПРОСТО НА ВЫХОДНЫЕ. ВЫ МОЖЕТЕ РАСПОЛОЖИТЬСЯ В НОМЕРЕ НАШЕЙ ГОСТИНИЦЫ ИЛИ ГОРНОМ ШАЛЕ НА 6-14 ЧЕЛОВЕК. ЖЕЛАЮЩИМ СТАТЬ ОДНИМ ЦЕЛЫМ С ПРИРОДОЙ МЫ ПРЕДЛАГАЕМ БЕЗОПАСНЫЕ ПЛОЩАДКИ ДЛЯ КЕМПИНГА. ЕСЛИ ПРИ ЭТОМ ВЫ НУЖДАЕТЕСЬ В КОМФОРТЕ — ГЛЭМПИНГОВЫЕ ЛАГЕРЯ К ВАШИМ УСЛУГАМ!\r\nБАЗА ОТДЫХА АСПРО: КУРОРТ 2.0 РАСПОЛАГАЕТСЯ \r\nНА БЕРЕГУ ТАЛБЕЦКОГО ОЗЕРА В ЮЖНОЙ ЧАСТИ БОСМЕРСКИХ ГОР. К НАМ ПРИЕЗЖАЮТ ВСЕЙ СЕМЬЕЙ, ЧТОБЫ ОТДОХНУТЬ ОТ ГОРОДСКОЙ СУЕТЫ, ПОЧУВСТВОВАТЬ ЕДИНЕНИЕ С ПРИРОДОЙ В ЛЕСУ И НА ГОРНЫХ СКЛОНАХ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '3214', '', '', '-808978729', NULL, NULL, NULL),
(9, '2023-04-27 00:09:29', 1, '2023-04-27 00:09:29', 1, 3, 9, 'Y', NULL, NULL, 500, 'Магнитогорск', NULL, '<p>\r\n	 Любители активного отдыха восхищаются нашим горнолыжным комплексом, трассами для мотокросса и регулярными спортивными мероприятиями. В санатории предусмотрены полезные лечебно-оздоровительные программы и мангальные зоны для комфортного досуга наших гостей.\r\n</p>\r\n<p>\r\n	 Обычно у нас отдыхают от недели до месяца, но приезжают и просто на выходные. Вы можете расположиться в номере нашей гостиницы или горном шале на 6-14 человек. Желающим стать одним целым с природой мы предлагаем безопасные площадки для кемпинга. Если при этом вы нуждаетесь в комфорте — глэмпинговые лагеря к вашим услугам!\r\n</p>', 'html', NULL, 'База отдыха Аспро: Курорт 2.0 располагается на берегу Талбецкого озера в южной части Босмерских гор. К нам приезжают всей семьей, чтобы отдохнуть от городской суеты, почувствовать единение с природой в лесу и на горных склонах.\r\n\r\n', 'html', 'МАГНИТОГОРСК\r\nЛЮБИТЕЛИ АКТИВНОГО ОТДЫХА ВОСХИЩАЮТСЯ \r\nНАШИМ ГОРНОЛЫЖНЫМ КОМПЛЕКСОМ, ТРАССАМИ ДЛЯ МОТОКРОССА И РЕГУЛЯРНЫМИ СПОРТИВНЫМИ МЕРОПРИЯТИЯМИ. В САНАТОРИИ ПРЕДУСМОТРЕНЫ ПОЛЕЗНЫЕ ЛЕЧЕБНО-ОЗДОРОВИТЕЛЬНЫЕ ПРОГРАММЫ И МАНГАЛЬНЫЕ ЗОНЫ ДЛЯ КОМФОРТНОГО ДОСУГА НАШИХ ГОСТЕЙ. \r\n\r\nОБЫЧНО У НАС ОТДЫХАЮТ ОТ НЕДЕЛИ ДО МЕСЯЦА, \r\nНО ПРИЕЗЖАЮТ И ПРОСТО НА ВЫХОДНЫЕ. ВЫ МОЖЕТЕ РАСПОЛОЖИТЬСЯ В НОМЕРЕ НАШЕЙ ГОСТИНИЦЫ ИЛИ ГОРНОМ ШАЛЕ НА 6-14 ЧЕЛОВЕК. ЖЕЛАЮЩИМ СТАТЬ ОДНИМ ЦЕЛЫМ С ПРИРОДОЙ МЫ ПРЕДЛАГАЕМ БЕЗОПАСНЫЕ ПЛОЩАДКИ ДЛЯ КЕМПИНГА. ЕСЛИ ПРИ ЭТОМ ВЫ НУЖДАЕТЕСЬ В КОМФОРТЕ — ГЛЭМПИНГОВЫЕ ЛАГЕРЯ К ВАШИМ УСЛУГАМ!\r\nБАЗА ОТДЫХА АСПРО: КУРОРТ 2.0 РАСПОЛАГАЕТСЯ \r\nНА БЕРЕГУ ТАЛБЕЦКОГО ОЗЕРА В ЮЖНОЙ ЧАСТИ БОСМЕРСКИХ ГОР. К НАМ ПРИЕЗЖАЮТ ВСЕЙ СЕМЬЕЙ, ЧТОБЫ ОТДОХНУТЬ ОТ ГОРОДСКОЙ СУЕТЫ, ПОЧУВСТВОВАТЬ ЕДИНЕНИЕ С ПРИРОДОЙ В ЛЕСУ И НА ГОРНЫХ СКЛОНАХ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '3215', '', '', '-1123135033', NULL, NULL, NULL),
(10, '2023-04-27 00:09:33', 1, '2023-04-27 00:09:33', 1, 5, 17, 'Y', NULL, NULL, 500, 'Текст', NULL, '', 'text', NULL, '', 'text', 'ТЕКСТ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '2103', 'text', '', '301353302', NULL, NULL, NULL),
(11, '2023-04-27 00:09:33', 1, '2023-04-27 00:09:33', 1, 5, 17, 'Y', NULL, NULL, 500, 'О компании', NULL, '', 'text', NULL, '', 'text', 'О КОМПАНИИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '2104', 'about_company', '', '1306625944', NULL, NULL, NULL),
(12, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 301, 'На главной, основной банер', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, ОСНОВНОЙ БАНЕР\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '10661', 'TOP', '', '-382386381', NULL, NULL, NULL),
(13, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, баннеры слева/справа от основного баннера', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, БАННЕРЫ СЛЕВА/СПРАВА ОТ ОСНОВНОГО БАННЕРА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3234', 'TOP_SMALL_BANNER', '', '-123950147', NULL, NULL, NULL),
(14, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, добавочные баннеры под основным баннером', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, ДОБАВОЧНЫЕ БАННЕРЫ ПОД ОСНОВНЫМ БАННЕРОМ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3373', 'ADDITIONAL_BANNERS', '', '787394134', NULL, NULL, NULL),
(15, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, баннеры картинками', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, БАННЕРЫ КАРТИНКАМИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3391', 'BANNER_IMG_TYPE1', '', '-1093949392', NULL, NULL, NULL),
(16, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, баннеры картинками (широкие)', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, БАННЕРЫ КАРТИНКАМИ (ШИРОКИЕ)\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3393', 'BANNER_IMG_WIDE', '', '-1186271377', NULL, NULL, NULL),
(17, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'В широком меню', NULL, '', 'text', NULL, '', 'text', 'В ШИРОКОМ МЕНЮ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1898', 'HEADER_WIDE_MENU', '', '-225697818', NULL, NULL, NULL),
(18, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'В бургерном меню', NULL, '', 'text', NULL, '', 'text', 'В БУРГЕРНОМ МЕНЮ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1901', 'MEGA_MENU', '', '1390643469', NULL, NULL, NULL),
(19, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, баннеры с фоном (тип1)', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, БАННЕРЫ С ФОНОМ (ТИП1)\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1942', 'BANNER_IMG_FON1', '', '1111867270', NULL, NULL, NULL),
(20, '2023-04-27 00:09:34', 1, '2023-04-27 00:09:34', 1, 6, NULL, 'Y', NULL, NULL, 500, 'На главной, баннеры с фоном (тип2)', NULL, '', 'text', NULL, '', 'text', 'НА ГЛАВНОЙ, БАННЕРЫ С ФОНОМ (ТИП2)\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1943', 'BANNER_IMG_FON2', '', '1298873988', NULL, NULL, NULL),
(25, '2023-04-27 00:09:36', 1, '2023-04-27 00:09:36', 1, 8, 18, 'Y', NULL, NULL, 500, 'Лицензия на оказание услуг', NULL, '<p>\r\n	Лицензия на оказание услуг выдается базам отдыха и используется для туристических услуг. Эта лицензия также&nbsp;подтверждает, что продукция соответствует требованиям основных нормативно-технических документов, установленных для данных услуг.\r\n</p>', 'html', NULL, '', 'text', 'ЛИЦЕНЗИЯ НА ОКАЗАНИЕ УСЛУГ\r\nЛИЦЕНЗИЯ НА ОКАЗАНИЕ УСЛУГ ВЫДАЕТСЯ БАЗАМ \r\nОТДЫХА И ИСПОЛЬЗУЕТСЯ ДЛЯ ТУРИСТИЧЕСКИХ УСЛУГ. ЭТА ЛИЦЕНЗИЯ ТАКЖЕ&NBSP;ПОДТВЕРЖДАЕТ, ЧТО ПРОДУКЦИЯ СООТВЕТСТВУЕТ ТРЕБОВАНИЯМ ОСНОВНЫХ НОРМАТИВНО-ТЕХНИЧЕСКИХ ДОКУМЕНТОВ, УСТАНОВЛЕННЫХ ДЛЯ ДАННЫХ УСЛУГ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '41', 'litsenziya-na-okazanie-uslug', '', '-1312430491', NULL, NULL, NULL),
(26, '2023-04-27 00:09:36', 1, '2023-04-27 00:09:36', 1, 8, 18, 'Y', NULL, NULL, 500, 'Сертификат соответствия', NULL, 'Сертификат соответствия – документ, подтверждающий соответствие продукции требованиям качества и безопасности, установленными для нее действующими стандартами и правилами (ГОСТ, ГОСТ Р, ГОСТ Р МЭК, ТУ, Технический регламент и пр.). ', 'text', NULL, '', 'text', 'СЕРТИФИКАТ СООТВЕТСТВИЯ\r\nСЕРТИФИКАТ СООТВЕТСТВИЯ – ДОКУМЕНТ, ПОДТВЕРЖДАЮЩИЙ СООТВЕТСТВИЕ ПРОДУКЦИИ ТРЕБОВАНИЯМ КАЧЕСТВА И БЕЗОПАСНОСТИ, УСТАНОВЛЕННЫМИ ДЛЯ НЕЕ ДЕЙСТВУЮЩИМИ СТАНДАРТАМИ И ПРАВИЛАМИ (ГОСТ, ГОСТ Р, ГОСТ Р МЭК, ТУ, ТЕХНИЧЕСКИЙ РЕГЛАМЕНТ И ПР.). \r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '44', 'sertifikat-sootvetstviya2', '', '1049368149', NULL, NULL, NULL),
(27, '2023-04-27 00:09:36', 1, '2023-04-27 00:09:36', 1, 8, 18, 'Y', NULL, NULL, 500, 'Лицензия на деятельность по защите информации', NULL, '', 'html', NULL, '', 'html', 'ЛИЦЕНЗИЯ НА ДЕЯТЕЛЬНОСТЬ ПО ЗАЩИТЕ ИНФОРМАЦИИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1761', '123123', '', '316080747', NULL, NULL, NULL),
(28, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 10, 'Главная', NULL, '', 'text', NULL, '', 'text', 'ГЛАВНАЯ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3783', '', '', '1488324037', NULL, NULL, NULL),
(29, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 20, 'Кабинет', NULL, '', 'text', NULL, '', 'text', 'КАБИНЕТ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3784', '', '', '511803782', NULL, NULL, NULL),
(30, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Каталог', NULL, '', 'text', NULL, '', 'text', 'КАТАЛОГ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3788', '', '', '555765369', NULL, NULL, NULL),
(31, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Акции', NULL, '', 'text', NULL, '', 'text', 'АКЦИИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3789', '', '', '2104343411', NULL, NULL, NULL),
(32, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Контакты', NULL, '', 'text', NULL, '', 'text', 'КОНТАКТЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3790', '', '', '1361555255', NULL, NULL, NULL),
(33, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Услуги', NULL, '', 'text', NULL, '', 'text', 'УСЛУГИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3791', '', '', '-2089186939', NULL, NULL, NULL),
(34, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Новости', NULL, '', 'text', NULL, '', 'text', 'НОВОСТИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3796', '', '', '1531264004', NULL, NULL, NULL),
(35, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Сотрудники', NULL, '', 'text', NULL, '', 'text', 'СОТРУДНИКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3797', '', '', '-1342757821', NULL, NULL, NULL),
(36, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Отзывы', NULL, '', 'text', NULL, '', 'text', 'ОТЗЫВЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3798', '', '', '446144430', NULL, NULL, NULL),
(37, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'FAQ', NULL, '', 'text', NULL, '', 'text', 'FAQ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3803', '', '', '371680783', NULL, NULL, NULL),
(38, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 40, 'Регион', NULL, '', 'text', NULL, '', 'text', 'РЕГИОН\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2134', '', '', '-458742306', NULL, NULL, NULL),
(39, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 50, 'Поиск', NULL, '', 'text', NULL, '', 'text', 'ПОИСК\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2135', '', '', '2048680231', NULL, NULL, NULL),
(40, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Блог', NULL, '', 'text', NULL, '', 'text', 'БЛОГ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2139', '', '', '1172363925', NULL, NULL, NULL),
(41, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Туры', NULL, '', 'text', NULL, '', 'text', 'ТУРЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2142', '', '', '802945663', NULL, NULL, NULL),
(42, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Галерея', NULL, '', 'text', NULL, '', 'text', 'ГАЛЕРЕЯ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2143', '', '', '358212377', NULL, NULL, NULL),
(43, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 500, 'Цены', NULL, '', 'text', NULL, '', 'text', 'ЦЕНЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2144', '', '', '208295184', NULL, NULL, NULL),
(44, '2023-04-27 00:09:46', 1, '2023-04-27 00:09:46', 1, 22, NULL, 'Y', NULL, NULL, 40, 'Виджет', NULL, '', 'text', NULL, '', 'text', 'ВИДЖЕТ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '501', '', '', '521233725', NULL, NULL, NULL),
(45, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, NULL, 'Y', NULL, NULL, 500, 'Для мега меню', NULL, '', 'html', 68, 'Аренда строительной и дорожной техники', 'html', 'ДЛЯ МЕГА МЕНЮ\r\n\r\nАРЕНДА СТРОИТЕЛЬНОЙ И ДОРОЖНОЙ ТЕХНИКИ', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1902', 'tekst', '', '-38729852', NULL, NULL, NULL),
(46, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, 21, 'Y', NULL, NULL, 200, 'Стильный и уютный<br>глэмпинг', 69, 'Совмещайте комфорт и единение с природой в глэмпинговых лагерях нашей базы отдыха.', 'html', 70, '', 'html', 'СТИЛЬНЫЙ И УЮТНЫЙ<BR>ГЛЭМПИНГ\r\nСОВМЕЩАЙТЕ КОМФОРТ И ЕДИНЕНИЕ С ПРИРОДОЙ \r\nВ ГЛЭМПИНГОВЫХ ЛАГЕРЯХ НАШЕЙ БАЗЫ ОТДЫХА.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '378', '', '', '1443955577', NULL, NULL, NULL),
(47, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, 21, 'Y', NULL, NULL, 300, 'Горнолыжные трассы <br>любой сложности', 76, '<div>\n	 Прокат лыж, сноубордов и спецодежды высокого качества.<br>\n	 Приобретайте ски-пасс для экономии на подъемниках и наслаждайтесь активным отдыхом.\n</div>\n<br>', 'html', 77, '', 'text', 'ГОРНОЛЫЖНЫЕ ТРАССЫ <BR>ЛЮБОЙ СЛОЖНОСТИ\r\nПРОКАТ ЛЫЖ, СНОУБОРДОВ И СПЕЦОДЕЖДЫ ВЫСОКОГО \r\nКАЧЕСТВА.\r\nПРИОБРЕТАЙТЕ СКИ-ПАСС ДЛЯ ЭКОНОМИИ НА ПОДЪЕМНИКАХ \r\nИ НАСЛАЖДАЙТЕСЬ АКТИВНЫМ ОТДЫХОМ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '379', '', '', '-1377855379', NULL, NULL, NULL),
(48, '2024-04-15 22:23:01', 1, '2023-04-27 00:09:48', 1, 23, 21, 'Y', NULL, NULL, 100, 'Открытие пляжного сезона', 83, '<div>\r\n	 Отдыхайте на нашей базе \"Город моря\" с пользой для здоровья! <br>\r\n	 На нашем пляже вы найдете шезлонги, навесы, чистый плях ,<br>\r\n	 золотой песок и яркое солнце!\r\n</div>\r\n <br>', 'html', 84, '', 'text', 'ОТКРЫТИЕ ПЛЯЖНОГО СЕЗОНА\r\nОТДЫХАЙТЕ НА НАШЕЙ БАЗЕ \"ГОРОД МОРЯ\" С ПОЛЬЗОЙ \r\nДЛЯ ЗДОРОВЬЯ! \r\nНА НАШЕМ ПЛЯЖЕ ВЫ НАЙДЕТЕ ШЕЗЛОНГИ, НАВЕСЫ, \r\nЧИСТЫЙ ПЛЯХ ,\r\nЗОЛОТОЙ ПЕСОК И ЯРКОЕ СОЛНЦЕ!\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '380', '', '', '0', NULL, NULL, NULL),
(49, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, 20, 'Y', NULL, NULL, 500, 'Скидка на мототехнику постоянным посетителям!', 90, '', 'text', NULL, '', 'text', 'СКИДКА НА МОТОТЕХНИКУ ПОСТОЯННЫМ ПОСЕТИТЕЛЯМ!\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '577', '', '', '1418488520', NULL, NULL, NULL),
(50, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, 19, 'Y', NULL, NULL, 500, 'Для влюбленных', 91, '', 'text', NULL, '', 'text', 'ДЛЯ ВЛЮБЛЕННЫХ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '578', '', '', '1052766444', NULL, NULL, NULL),
(51, '2023-04-27 00:09:48', 1, '2023-04-27 00:09:48', 1, 23, 19, 'Y', NULL, NULL, 500, '-30% на аренду мототехники при повторном визите турбазы', 92, '', 'text', NULL, '', 'text', '-30% НА АРЕНДУ МОТОТЕХНИКИ ПРИ ПОВТОРНОМ ВИЗИТЕ ТУРБАЗЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '579', '', '', '517889157', NULL, NULL, NULL),
(52, '2023-04-27 00:09:49', 1, '2023-04-27 00:09:49', 1, 24, NULL, 'Y', NULL, NULL, 500, 'Сверху над шапкой', 93, '', 'text', 94, '', 'text', 'СВЕРХУ НАД ШАПКОЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '959', '', '', '-1149945922', NULL, NULL, NULL),
(53, '2023-04-27 00:09:49', 1, '2023-04-27 00:09:49', 1, 24, NULL, 'Y', NULL, NULL, 500, 'Сверху под шапкой', 95, '', 'text', NULL, '', 'text', 'СВЕРХУ ПОД ШАПКОЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '963', '', '', '1450510396', NULL, NULL, NULL),
(54, '2023-04-27 00:09:49', 1, '2023-04-27 00:09:49', 1, 24, NULL, 'Y', NULL, NULL, 500, 'Под контентом', 96, '', 'text', NULL, '', 'text', 'ПОД КОНТЕНТОМ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '965', '', '', '1493128966', NULL, NULL, NULL),
(55, '2023-04-27 00:09:49', 1, '2023-04-27 00:09:49', 1, 24, NULL, 'Y', NULL, NULL, 500, 'Внизу страницы', 97, '', 'text', NULL, '', 'text', 'ВНИЗУ СТРАНИЦЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'N', '966', '', '', '-903792662', NULL, NULL, NULL),
(56, '2023-08-23 12:38:43', 1, '2023-04-27 00:09:50', 1, 25, 23, 'Y', NULL, NULL, 500, 'Официант', NULL, 'Ищем надежного, опрятного и вежливого человека для работы в кафе на базе отдыха \"Город моря\".', 'text', NULL, '<p>\r\n <span style=\"font-weight: 700;\"><b>Обязанности:</b></span>\r\n</p>\r\n<p>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Сервировка столов, уборка столов;</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Работа с гостями заведения, консультации по выбору блюда;</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Обслуживание гостей за столом: подача блюд, разливание напитков и т.д.;</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Расчет гостей , работа с кассовым аппаратом.</span> </li>\r\n</ul>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Требования:</b></span>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Грамотная речь.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Медицинская книжка.</span> </li>\r\n	<li>&nbsp;Рассматриваем кандидатов без опыта работы</li>\r\n</ul>\r\n<p>\r\n</p>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Условия:</b></span>\r\n</p>\r\n<ul>\r\n	<li>&nbsp;Трансфер с города Махачкалы на базу \"Город моря\"<span style=\"font-weight: 400;\">.</span> </li>\r\n	<li>&nbsp;Для иногородних предоставим жилье.</li>\r\n</ul>', 'html', 'ОФИЦИАНТ\r\nИЩЕМ НАДЕЖНОГО, ОПРЯТНОГО И ВЕЖЛИВОГО ЧЕЛОВЕКА ДЛЯ РАБОТЫ В КАФЕ НА БАЗЕ ОТДЫХА \"ГОРОД МОРЯ\".\r\nОБЯЗАННОСТИ: \r\n\r\n \r\n\r\n- СЕРВИРОВКА СТОЛОВ, УБОРКА СТОЛОВ; \r\n- РАБОТА С ГОСТЯМИ ЗАВЕДЕНИЯ, КОНСУЛЬТАЦИИ \r\nПО ВЫБОРУ БЛЮДА; \r\n- ОБСЛУЖИВАНИЕ ГОСТЕЙ ЗА СТОЛОМ: ПОДАЧА \r\nБЛЮД, РАЗЛИВАНИЕ НАПИТКОВ И Т.Д.; \r\n- РАСЧЕТ ГОСТЕЙ , РАБОТА С КАССОВЫМ АППАРАТОМ. \r\n\r\nТРЕБОВАНИЯ: \r\n\r\n- ГРАМОТНАЯ РЕЧЬ. \r\n- МЕДИЦИНСКАЯ КНИЖКА. \r\n- &NBSP;РАССМАТРИВАЕМ КАНДИДАТОВ БЕЗ ОПЫТА \r\nРАБОТЫ \r\n\r\n \r\n\r\nУСЛОВИЯ: \r\n\r\n- &NBSP;ТРАНСФЕР С ГОРОДА МАХАЧКАЛЫ НА БАЗУ \r\n\"ГОРОД МОРЯ\". \r\n- &NBSP;ДЛЯ ИНОГОРОДНИХ ПРЕДОСТАВИМ ЖИЛЬЕ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '52', 'ofitsiant', '', '0', NULL, NULL, NULL),
(57, '2023-08-23 12:39:16', 1, '2023-04-27 00:09:50', 1, 25, 23, 'Y', NULL, NULL, 500, 'Горничная', NULL, 'Ищем трудолюбивого человека, который умеет быстро наводить порядок в номерах отеля и коттеджей.', 'html', NULL, '<p>\r\n <span style=\"font-weight: 700;\"><b>Обязанности:</b></span>\r\n</p>\r\n<p>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"color: var(--basic_text_black);\">Наводить порядок в номерах и домиках.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Менять постельное белье.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Помогать проживающим по бытовым вопросам.</span> </li>\r\n</ul>\r\n<p>\r\n</p>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Требования:</b></span>\r\n</p>\r\n<p>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Аккуратность и чистоплотность.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Вежливость и доброжелательность.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Ответственное отношение к своему делу.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Наличие санитарной книжки.</span> </li>\r\n</ul>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Условия:</b></span>\r\n</p>\r\n<p>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Официальное трудоустройство.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">График работы 2/2.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Возможность регулярно выезжать загород.</span> </li>\r\n</ul>', 'html', 'ГОРНИЧНАЯ\r\nИЩЕМ ТРУДОЛЮБИВОГО ЧЕЛОВЕКА, КОТОРЫЙ УМЕЕТ \r\nБЫСТРО НАВОДИТЬ ПОРЯДОК В НОМЕРАХ ОТЕЛЯ И КОТТЕДЖЕЙ.\r\nОБЯЗАННОСТИ: \r\n\r\n \r\n\r\n- НАВОДИТЬ ПОРЯДОК В НОМЕРАХ И ДОМИКАХ. \r\n- МЕНЯТЬ ПОСТЕЛЬНОЕ БЕЛЬЕ. \r\n- ПОМОГАТЬ ПРОЖИВАЮЩИМ ПО БЫТОВЫМ ВОПРОСАМ. \r\n\r\n \r\n\r\nТРЕБОВАНИЯ: \r\n\r\n \r\n\r\n- АККУРАТНОСТЬ И ЧИСТОПЛОТНОСТЬ. \r\n- ВЕЖЛИВОСТЬ И ДОБРОЖЕЛАТЕЛЬНОСТЬ. \r\n- ОТВЕТСТВЕННОЕ ОТНОШЕНИЕ К СВОЕМУ ДЕЛУ. \r\n- НАЛИЧИЕ САНИТАРНОЙ КНИЖКИ. \r\n\r\nУСЛОВИЯ: \r\n\r\n \r\n\r\n- ОФИЦИАЛЬНОЕ ТРУДОУСТРОЙСТВО. \r\n- ГРАФИК РАБОТЫ 2/2. \r\n- ВОЗМОЖНОСТЬ РЕГУЛЯРНО ВЫЕЗЖАТЬ ЗАГОРОД.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '934', 'voditel-ekspeditor', '', '0', NULL, NULL, NULL),
(59, '2023-08-23 12:28:54', 1, '2023-04-27 00:09:50', 1, 25, 22, 'Y', NULL, NULL, 500, 'Аниматор', NULL, '<p>\r\n	 Ищем общительного человека, который умеет проводить конкурсы и мероприятия для взрослых и детей на пляже, спортивных площадках и ресторанах.\r\n</p>', 'html', NULL, '<p>\r\n <span style=\"font-weight: 700;\"><b>Обязанности:</b></span>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Проводить мероприятия: соревнования, эстафеты и конкурсы.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\"> Развлекать отдыхающих базы.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Помогать гостям санатория в проведении досуга.</span> </li>\r\n</ul>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Требования:</b></span>\r\n</p>\r\n<ul>\r\n	<li> <span style=\"font-weight: 400;\">Высокие коммуникативные навыки.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Стрессоустойчивость и умение работать с детьми.</span></li>\r\n	<li> <span style=\"font-weight: 400;\">Умение импровизировать и экспериментировать.</span>&nbsp;</li>\r\n	<li><span style=\"font-weight: 400;\">Креативный подход к делу.</span> </li>\r\n</ul>\r\n<p>\r\n <span style=\"font-weight: 700;\"><b>Условия:</b></span>\r\n</p>\r\n<ul>\r\n	<li>\r\n <span style=\"font-weight: 400;\">Официальное трудоустройство.</span>\r\n	</li>\r\n	<li>\r\n		<span style=\"color: var(--basic_text_black);\">График работы 5/2.</span>\r\n	</li>\r\n	<li> <span style=\"font-weight: 400;\">Возможность постоянного выезда загород.</span> </li>\r\n	<li> <span style=\"font-weight: 400;\">Участие в мероприятиях.</span> </li>\r\n</ul>\r\n<ul>\r\n</ul>', 'html', 'АНИМАТОР\r\nИЩЕМ ОБЩИТЕЛЬНОГО ЧЕЛОВЕКА, КОТОРЫЙ УМЕЕТ \r\nПРОВОДИТЬ КОНКУРСЫ И МЕРОПРИЯТИЯ ДЛЯ ВЗРОСЛЫХ И ДЕТЕЙ НА ПЛЯЖЕ, СПОРТИВНЫХ ПЛОЩАДКАХ И РЕСТОРАНАХ.\r\nОБЯЗАННОСТИ: \r\n\r\n- ПРОВОДИТЬ МЕРОПРИЯТИЯ: СОРЕВНОВАНИЯ, \r\nЭСТАФЕТЫ И КОНКУРСЫ. \r\n- РАЗВЛЕКАТЬ ОТДЫХАЮЩИХ БАЗЫ. \r\n- ПОМОГАТЬ ГОСТЯМ САНАТОРИЯ В ПРОВЕДЕНИИ \r\nДОСУГА. \r\n\r\nТРЕБОВАНИЯ: \r\n\r\n- ВЫСОКИЕ КОММУНИКАТИВНЫЕ НАВЫКИ. \r\n- СТРЕССОУСТОЙЧИВОСТЬ И УМЕНИЕ РАБОТАТЬ \r\nС ДЕТЬМИ. \r\n- УМЕНИЕ ИМПРОВИЗИРОВАТЬ И ЭКСПЕРИМЕНТИРОВАТЬ.&NBSP; \r\n- КРЕАТИВНЫЙ ПОДХОД К ДЕЛУ. \r\n\r\nУСЛОВИЯ: \r\n\r\n- ОФИЦИАЛЬНОЕ ТРУДОУСТРОЙСТВО. \r\n- ГРАФИК РАБОТЫ 5/2. \r\n- ВОЗМОЖНОСТЬ ПОСТОЯННОГО ВЫЕЗДА ЗАГОРОД. \r\n- УЧАСТИЕ В МЕРОПРИЯТИЯХ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '936', 'spetsialist-po-kontekstnoy-reklame', '', '0', NULL, NULL, NULL),
(60, '2023-07-03 20:45:54', 1, '2023-04-27 00:09:51', 1, 26, 25, 'Y', NULL, NULL, 300, 'Можно ли к вам с животными?', NULL, 'К сожалению мы не можем принять вашего любимца и не потому, что он плохой друг, а все потому, что условия содержания домашних животных у нас не предусмотрены. Возможно в скором будущем мы придем к какому-то решению и вы сможете посетить нас с своим четвероногим другом!', 'html', NULL, '', 'text', 'МОЖНО ЛИ К ВАМ С ЖИВОТНЫМИ?\r\nК СОЖАЛЕНИЮ МЫ НЕ МОЖЕМ ПРИНЯТЬ ВАШЕГО \r\nЛЮБИМЦА И НЕ ПОТОМУ, ЧТО ОН ПЛОХОЙ ДРУГ, А ВСЕ ПОТОМУ, ЧТО УСЛОВИЯ СОДЕРЖАНИЯ ДОМАШНИХ ЖИВОТНЫХ У НАС НЕ ПРЕДУСМОТРЕНЫ. ВОЗМОЖНО В СКОРОМ БУДУЩЕМ МЫ ПРИДЕМ К КАКОМУ-ТО РЕШЕНИЮ И ВЫ СМОЖЕТЕ ПОСЕТИТЬ НАС С СВОИМ ЧЕТВЕРОНОГИМ ДРУГОМ!\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '3', 'mozhno-li-k-vam-s-zhivotnymi', '', '0', NULL, NULL, NULL),
(61, '2024-08-21 23:00:41', 1, '2023-04-27 00:09:51', 1, 26, 26, 'Y', NULL, NULL, 200, 'Какое питание в вашей базе отдыха?', NULL, '<p>\r\n	 В наших базах отдыха завтраки не входят в бронь. На территории имеются кафе и рестораны, которые позволят вам покушать со вкусом. Меню у нас разнообразное и вы обязательно найдете то, что вам будет по душе. Есть пожелания по меню? Сообщите об этом нашим поварам. \r\n</p>\r\n<p>\r\n	 Также вы всегда можете заказать еду и ее доставят для вас в указанное вами время.\r\n</p>', 'html', NULL, '', 'html', 'КАКОЕ ПИТАНИЕ В ВАШЕЙ БАЗЕ ОТДЫХА?\r\nВ НАШИХ БАЗАХ ОТДЫХА ЗАВТРАКИ НЕ ВХОДЯТ \r\nВ БРОНЬ. НА ТЕРРИТОРИИ ИМЕЮТСЯ КАФЕ И РЕСТОРАНЫ, КОТОРЫЕ ПОЗВОЛЯТ ВАМ ПОКУШАТЬ СО ВКУСОМ. МЕНЮ У НАС РАЗНООБРАЗНОЕ И ВЫ ОБЯЗАТЕЛЬНО НАЙДЕТЕ ТО, ЧТО ВАМ БУДЕТ ПО ДУШЕ. ЕСТЬ ПОЖЕЛАНИЯ ПО МЕНЮ? СООБЩИТЕ ОБ ЭТОМ НАШИМ ПОВАРАМ. \r\n\r\nТАКЖЕ ВЫ ВСЕГДА МОЖЕТЕ ЗАКАЗАТЬ ЕДУ И ЕЕ \r\nДОСТАВЯТ ДЛЯ ВАС В УКАЗАННОЕ ВАМИ ВРЕМЯ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '5', 'kakoe-pitanie-v-vashey-baze-otdykha', '', '0', NULL, NULL, NULL),
(62, '2023-06-29 21:11:38', 1, '2023-04-27 00:09:51', 1, 26, 26, 'Y', NULL, NULL, 100, 'Как доехать до вашей базы отдыха?', NULL, '<p>\r\n	Наши базы отдыха находятся в разных областях Дагестана. Путь проходит по федеральной трассе с указателями. Вы можете добраться до нас на своей машине, междугороднем автобусе или заказать трансфер до выбранной базы отдыха.\r\n</p>\r\n<p>\r\n	 Позвоните на номер 8 (989) 666-66-01. Мы подробно проконсультируем вас по условиям трансфера или отправим геолокацию для вашей лучшей навигации.\r\n</p>', 'html', NULL, '', 'text', 'КАК ДОЕХАТЬ ДО ВАШЕЙ БАЗЫ ОТДЫХА?\r\nНАШИ БАЗЫ ОТДЫХА НАХОДЯТСЯ В РАЗНЫХ ОБЛАСТЯХ \r\nДАГЕСТАНА. ПУТЬ ПРОХОДИТ ПО ФЕДЕРАЛЬНОЙ ТРАССЕ С УКАЗАТЕЛЯМИ. ВЫ МОЖЕТЕ ДОБРАТЬСЯ ДО НАС НА СВОЕЙ МАШИНЕ, МЕЖДУГОРОДНЕМ АВТОБУСЕ ИЛИ ЗАКАЗАТЬ ТРАНСФЕР ДО ВЫБРАННОЙ БАЗЫ ОТДЫХА. \r\n\r\nПОЗВОНИТЕ НА НОМЕР 8 (989) 666-66-01. МЫ ПОДРОБНО \r\nПРОКОНСУЛЬТИРУЕМ ВАС ПО УСЛОВИЯМ ТРАНСФЕРА ИЛИ ОТПРАВИМ ГЕОЛОКАЦИЮ ДЛЯ ВАШЕЙ ЛУЧШЕЙ НАВИГАЦИИ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '209', 'kak-doekhat-do-vashey-bazy-otdykha', '', '0', NULL, NULL, NULL),
(63, '2023-06-29 21:23:08', 1, '2023-04-27 00:09:51', 1, 26, 25, 'Y', NULL, NULL, 400, 'Можно ли у вас провести торжественное мероприятие?', NULL, 'Наши базы отдыха позволяют провести торжественное мероприятие пусть то будет день рождения или свадьба. Мы всячески поспособствуем организации фуршета. Наши шеф повара помогут вам подобрать меню на любое количество гостей и подать это все в изысканном виде.', 'html', NULL, '', 'html', 'МОЖНО ЛИ У ВАС ПРОВЕСТИ ТОРЖЕСТВЕННОЕ МЕРОПРИЯТИЕ?\r\nНАШИ БАЗЫ ОТДЫХА ПОЗВОЛЯЮТ ПРОВЕСТИ ТОРЖЕСТВЕННОЕ \r\nМЕРОПРИЯТИЕ ПУСТЬ ТО БУДЕТ ДЕНЬ РОЖДЕНИЯ ИЛИ СВАДЬБА. МЫ ВСЯЧЕСКИ ПОСПОСОБСТВУЕМ ОРГАНИЗАЦИИ ФУРШЕТА. НАШИ ШЕФ ПОВАРА ПОМОГУТ ВАМ ПОДОБРАТЬ МЕНЮ НА ЛЮБОЕ КОЛИЧЕСТВО ГОСТЕЙ И ПОДАТЬ ЭТО ВСЕ В ИЗЫСКАННОМ ВИДЕ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '571', 'mozhno-li-u-vas-provesti-torzhestvennoe-meropriyatie', '', '0', NULL, NULL, NULL),
(64, '2023-06-30 21:49:09', 1, '2023-04-27 00:09:53', 1, 27, 78, 'Y', NULL, NULL, 100, 'Аренда ресторана', NULL, '', 'text', NULL, '', 'text', 'АРЕНДА РЕСТОРАНА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '502', 'ski', '', '0', NULL, 98, '2023-06-29 19:39:33'),
(65, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 31, 'Y', NULL, NULL, 600, 'Палки', NULL, '', 'text', NULL, '', 'text', 'ПАЛКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '503', 'palki', '', '-1763155697', NULL, 129, '2023-06-29 19:39:32'),
(66, '2023-06-30 21:49:09', 1, '2023-04-27 00:09:53', 1, 27, 78, 'Y', NULL, NULL, 200, 'Аренда кафе', NULL, '', 'text', NULL, '', 'text', 'АРЕНДА КАФЕ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '504', 'arenda-kafe', '', '0', NULL, 107, '2023-06-29 19:39:32'),
(67, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 31, 'Y', NULL, NULL, 300, 'Шлем', NULL, '', 'text', NULL, '', 'text', 'ШЛЕМ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '505', 'shlem', '', '1651237942', NULL, 121, '2023-06-29 19:39:31'),
(68, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 31, 'Y', NULL, NULL, 800, 'Тюбинг', NULL, '', 'text', NULL, '', 'text', 'ТЮБИНГ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '506', 'tyubing', '', '-371856648', NULL, 119, '2023-06-29 19:39:36'),
(69, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 31, 'Y', NULL, NULL, 400, 'Очки', NULL, '', 'text', NULL, '', 'text', 'ОЧКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '507', 'ochki', '', '563776964', NULL, 82, '2023-06-29 19:39:34'),
(70, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 31, 'Y', NULL, NULL, 500, 'Горнолыжный костюм', NULL, '', 'text', NULL, '', 'text', 'ГОРНОЛЫЖНЫЙ КОСТЮМ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '508', 'gornolyzhnyy-kostyum', '', '1150834061', NULL, 96, '2023-06-29 19:39:35'),
(71, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 30, 'Y', NULL, NULL, 100, 'Ленточный', NULL, '', 'text', NULL, '', 'text', 'ЛЕНТОЧНЫЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '509', 'lentochnyy', '', '1789523960', NULL, 111, '2023-06-29 19:47:46'),
(72, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 30, 'Y', NULL, NULL, 200, 'Бугельный', NULL, '', 'text', NULL, '', 'text', 'БУГЕЛЬНЫЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '510', 'bugelnyy', '', '98419311', NULL, 105, '2023-06-29 19:43:38'),
(73, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 30, 'Y', NULL, NULL, 300, 'Кресельный', NULL, '', 'text', NULL, '', 'text', 'КРЕСЕЛЬНЫЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '511', 'kreselnyy', '', '-1533868883', NULL, 108, '2023-06-29 19:48:07'),
(74, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 30, 'Y', NULL, NULL, 400, 'Гондольный', NULL, '', 'text', NULL, '', 'text', 'ГОНДОЛЬНЫЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '512', 'gondolnyy', '', '-660418247', NULL, 132, '2023-06-20 07:36:16'),
(75, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 30, 'Y', NULL, NULL, 500, 'Кабинный', NULL, '', 'text', NULL, '', 'text', 'КАБИННЫЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '513', 'kabinnyy', '', '-1467142241', NULL, 89, '2023-06-29 19:39:37'),
(76, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 29, 'Y', NULL, NULL, 100, '1 индивидуальное занятие', NULL, '', 'text', NULL, '', 'text', '1 ИНДИВИДУАЛЬНОЕ ЗАНЯТИЕ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '514', '1-individualnoe-zanyatie', '', '1388614727', NULL, 169, '2023-06-29 19:39:31'),
(77, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 29, 'Y', NULL, NULL, 200, 'Абонемент на 3 индивидуальных занятия', NULL, '', 'text', NULL, '', 'text', 'АБОНЕМЕНТ НА 3 ИНДИВИДУАЛЬНЫХ ЗАНЯТИЯ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '515', 'abonement-na-3-individualnykh-zanyatiya', '', '1423979809', NULL, 89, '2023-06-29 19:39:37'),
(78, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 29, 'Y', NULL, NULL, 3, 'Абонемент на 8 индивидуальных занятий', NULL, '', 'text', NULL, '', 'text', 'АБОНЕМЕНТ НА 8 ИНДИВИДУАЛЬНЫХ ЗАНЯТИЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '516', 'abonement-na-8-individualnykh-zanyatiy', '', '518925472', NULL, 117, '2023-06-29 19:39:30'),
(79, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 29, 'Y', NULL, NULL, 400, '1 групповое занятие (от 3 человек)', NULL, '', 'text', NULL, '', 'text', '1 ГРУППОВОЕ ЗАНЯТИЕ (ОТ 3 ЧЕЛОВЕК)\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '517', '1-gruppovoe-zanyatie', '', '-5627794', NULL, 116, '2023-06-29 19:39:30'),
(80, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Ручная заточка канта', NULL, '', 'text', NULL, '', 'text', 'РУЧНАЯ ЗАТОЧКА КАНТА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '518', 'ruchnaya-zatochka-kanta', '', '174755170', NULL, 94, '2023-06-29 19:39:34'),
(81, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Машинная заточка канта', NULL, '', 'text', NULL, '', 'text', 'МАШИННАЯ ЗАТОЧКА КАНТА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '519', 'mashinnaya-zatochka-kanta', '', '1648524172', NULL, 90, '2023-09-05 11:20:43'),
(82, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Накатка', NULL, '', 'text', NULL, '', 'text', 'НАКАТКА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '520', 'nakatka', '', '-698385282', NULL, 164, '2023-06-29 19:39:33'),
(83, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Шлифовка скользящей поверхности', NULL, '', 'text', NULL, '', 'text', 'ШЛИФОВКА СКОЛЬЗЯЩЕЙ ПОВЕРХНОСТИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '521', 'shlifovka-skolzyashchey-poverkhnosti', '', '-1282936141', NULL, 91, '2023-06-29 19:39:30'),
(84, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Ремонт лыж', NULL, '', 'text', NULL, '', 'text', 'РЕМОНТ ЛЫЖ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '522', 'remont-lyzh', '', '816807395', NULL, 92, '2023-06-29 19:40:40'),
(85, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Ремонт сноуборда', NULL, '', 'text', NULL, '', 'text', 'РЕМОНТ СНОУБОРДА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '523', 'remont-snouborda', '', '1147323854', NULL, 90, '2023-06-29 19:43:54'),
(86, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Установка креплений', NULL, '', 'text', NULL, '', 'text', 'УСТАНОВКА КРЕПЛЕНИЙ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '524', 'ustanovka-krepleniy', '', '1501614315', NULL, 82, '2023-06-11 23:58:18'),
(87, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 28, 'Y', NULL, NULL, 500, 'Комплексная подготовка лыж и сноубордов', NULL, '', 'text', NULL, '', 'text', 'КОМПЛЕКСНАЯ ПОДГОТОВКА ЛЫЖ И СНОУБОРДОВ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '525', 'kompleksnaya-podgotovka-lyzh-i-snoubordov', '', '81988603', NULL, 104, '2023-06-29 19:39:35'),
(88, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 37, 'Y', NULL, NULL, 500, 'Массаж спины', NULL, '', 'text', NULL, '', 'text', 'МАССАЖ СПИНЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '526', 'massazh-spiny', '', '275503097', NULL, 95, '2023-06-14 08:57:28'),
(89, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 37, 'Y', NULL, NULL, 500, 'Массаж головы/стоп', NULL, '', 'text', NULL, '', 'text', 'МАССАЖ ГОЛОВЫ/СТОП\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '527', 'massazh-golovy-stop', '', '-698961173', NULL, 83, '2023-07-01 06:09:13'),
(90, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 37, 'Y', NULL, NULL, 500, 'Массаж горячими камнями', NULL, '', 'text', NULL, '', 'text', 'МАССАЖ ГОРЯЧИМИ КАМНЯМИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '528', 'massazh-goryachimi-kamnyami', '', '-790083654', NULL, 94, '2023-07-01 06:09:14'),
(91, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 37, 'Y', NULL, NULL, 500, 'Гавайский массаж', NULL, '', 'text', NULL, '', 'text', 'ГАВАЙСКИЙ МАССАЖ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '529', 'gavayskiy-massazh', '', '-1979355939', NULL, 94, '2023-07-01 06:09:40'),
(92, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 37, 'Y', NULL, NULL, 500, 'Детский общий массаж', NULL, '', 'text', NULL, '', 'text', 'ДЕТСКИЙ ОБЩИЙ МАССАЖ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '530', 'detskiy-obshchiy-massazh', '', '1749654122', NULL, 141, '2023-07-01 06:08:50'),
(93, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 38, 'Y', NULL, NULL, 100, '20 минут', NULL, '', 'text', NULL, '', 'text', '20 МИНУТ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '531', '20-minut', '', '1231520025', NULL, 92, '2023-07-01 06:09:23'),
(94, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 38, 'Y', NULL, NULL, 200, '40 минут', NULL, '', 'text', NULL, '', 'text', '40 МИНУТ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '532', '40-minut', '', '717281011', NULL, 85, '2023-07-01 06:08:50'),
(95, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 38, 'Y', NULL, NULL, 300, '1 час', NULL, '', 'text', NULL, '', 'text', '1 ЧАС\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '534', '1-chas', '', '532278937', NULL, 114, '2023-07-01 06:08:50'),
(96, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 35, 'Y', NULL, NULL, 500, 'Для лица и волос', NULL, '', 'text', NULL, '', 'text', 'ДЛЯ ЛИЦА И ВОЛОС\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '535', 'dlya-litsa-i-volos', '', '1777810988', NULL, 96, '2023-04-27 00:57:05'),
(97, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 35, 'Y', NULL, NULL, 500, 'Программа «Славянская культура»', NULL, '', 'text', NULL, '', 'text', 'ПРОГРАММА «СЛАВЯНСКАЯ КУЛЬТУРА»\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '536', 'programma-slavyanskaya-kultura', '', '1705939673', NULL, 88, '2023-07-01 06:09:25'),
(98, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 35, 'Y', NULL, NULL, 500, 'Программа «Восточный релакс»', NULL, '', 'text', NULL, '', 'text', 'ПРОГРАММА «ВОСТОЧНЫЙ РЕЛАКС»\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '537', 'programma-vostochnyy-relaks', '', '-1868321960', NULL, 94, '2023-07-01 06:09:22'),
(99, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Индивидуальный курс (по назначению врача)', NULL, '', 'text', NULL, '', 'text', 'ИНДИВИДУАЛЬНЫЙ КУРС (ПО НАЗНАЧЕНИЮ ВРАЧА)\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '538', 'individualnyy-kurs-po-naznacheniyu-vracha', '', '-380374275', NULL, 98, '2023-07-01 06:09:36'),
(100, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Групповой курс', NULL, '', 'text', NULL, '', 'text', 'ГРУППОВОЙ КУРС\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '539', 'gruppovoy-kurs', '', '1922341007', NULL, 97, '2023-07-01 06:09:43'),
(101, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Утренняя гимнастика', NULL, '', 'text', NULL, '', 'text', 'УТРЕННЯЯ ГИМНАСТИКА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '540', 'utrennyaya-gimnastika', '', '698662074', NULL, 94, '2023-07-01 06:08:51'),
(102, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Занятия в тренажерном зале', NULL, '', 'text', NULL, '', 'text', 'ЗАНЯТИЯ В ТРЕНАЖЕРНОМ ЗАЛЕ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '541', 'zanyatiya-v-trenazhernom-zale', '', '1790914724', NULL, 99, '2023-07-01 06:10:57'),
(103, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Гидрокинезотерапия', NULL, '', 'text', NULL, '', 'text', 'ГИДРОКИНЕЗОТЕРАПИЯ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '542', 'gidrokinezoterapiya', '', '830804091', NULL, 98, '2023-07-01 06:11:19'),
(104, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 36, 'Y', NULL, NULL, 500, 'Велотренировки', NULL, '', 'text', NULL, '', 'text', 'ВЕЛОТРЕНИРОВКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '543', 'velotrenirovki', '', '-802350424', NULL, 95, '2023-06-14 18:04:32'),
(105, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 33, 'Y', NULL, NULL, 500, 'Шампуры', NULL, '', 'text', NULL, '', 'text', 'ШАМПУРЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '544', 'shampury', '', '-936994087', NULL, 90, '2023-06-29 19:43:51'),
(106, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 33, 'Y', NULL, NULL, 500, 'Шпажки', NULL, '', 'text', NULL, '', 'text', 'ШПАЖКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '545', 'shpazhki', '', '-1766756376', NULL, 92, '2023-06-29 19:44:11'),
(107, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 33, 'Y', NULL, NULL, 500, 'Щипцы', NULL, '', 'text', NULL, '', 'text', 'ЩИПЦЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '546', 'shchiptsy', '', '1448784138', NULL, 93, '2023-06-29 19:43:53'),
(108, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 33, 'Y', NULL, NULL, 500, 'Подставка под мангал', NULL, '', 'text', NULL, '', 'text', 'ПОДСТАВКА ПОД МАНГАЛ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '547', 'podstavka-pod-mangal', '', '-292390695', NULL, 145, '2023-06-29 19:43:53'),
(109, '2023-04-27 00:09:53', 1, '2023-04-27 00:09:53', 1, 27, 33, 'Y', NULL, NULL, 500, 'Решетка барбекю', NULL, '', 'text', NULL, '', 'text', 'РЕШЕТКА БАРБЕКЮ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '548', 'reshetka-barbekyu', '', '180278115', NULL, 114, '2023-06-29 19:43:52'),
(110, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Rey', 98, 'Производитель мебели и строительных материалов в России', 'html', NULL, '<p>Rey — производитель мебели и строительных материалов в России. Производитель предоставляет широкий объем выпускаемой продукции, способной на равных конкурировать со многими европейскими брендами. А все благодаря тому, что за всем этим увеличением объемов и видов выпускаемых строительных смесей и материалов в компании не забыли об основной идее, с которой все и началось, — современное производство со стабильно высоким качеством.</p>\r\n<p>Качество продукции отслеживается на всех стадиях производства — от контроля входного сырья до выхода готовой продукции, для чего применяются все более совершенные системы и оборудование. Rey имеют 15 высокотехнологичных производственных линий на основном производстве в Московской области, 4 филиала на территории России. Все это и является залогом успеха!</p>', 'html', 'REY\r\nПРОИЗВОДИТЕЛЬ МЕБЕЛИ И СТРОИТЕЛЬНЫХ МАТЕРИАЛОВ \r\nВ РОССИИ\r\nREY — ПРОИЗВОДИТЕЛЬ МЕБЕЛИ И СТРОИТЕЛЬНЫХ \r\nМАТЕРИАЛОВ В РОССИИ. ПРОИЗВОДИТЕЛЬ ПРЕДОСТАВЛЯЕТ ШИРОКИЙ ОБЪЕМ ВЫПУСКАЕМОЙ ПРОДУКЦИИ, СПОСОБНОЙ НА РАВНЫХ КОНКУРИРОВАТЬ СО МНОГИМИ ЕВРОПЕЙСКИМИ БРЕНДАМИ. А ВСЕ БЛАГОДАРЯ ТОМУ, ЧТО ЗА ВСЕМ ЭТИМ УВЕЛИЧЕНИЕМ ОБЪЕМОВ И ВИДОВ ВЫПУСКАЕМЫХ СТРОИТЕЛЬНЫХ СМЕСЕЙ И МАТЕРИАЛОВ В КОМПАНИИ НЕ ЗАБЫЛИ ОБ ОСНОВНОЙ ИДЕЕ, С КОТОРОЙ ВСЕ И НАЧАЛОСЬ, — СОВРЕМЕННОЕ ПРОИЗВОДСТВО СО СТАБИЛЬНО ВЫСОКИМ КАЧЕСТВОМ. \r\n\r\nКАЧЕСТВО ПРОДУКЦИИ ОТСЛЕЖИВАЕТСЯ НА ВСЕХ \r\nСТАДИЯХ ПРОИЗВОДСТВА — ОТ КОНТРОЛЯ ВХОДНОГО СЫРЬЯ ДО ВЫХОДА ГОТОВОЙ ПРОДУКЦИИ, ДЛЯ ЧЕГО ПРИМЕНЯЮТСЯ ВСЕ БОЛЕЕ СОВЕРШЕННЫЕ СИСТЕМЫ И ОБОРУДОВАНИЕ. REY ИМЕЮТ 15 ВЫСОКОТЕХНОЛОГИЧНЫХ ПРОИЗВОДСТВЕННЫХ ЛИНИЙ НА ОСНОВНОМ ПРОИЗВОДСТВЕ В МОСКОВСКОЙ ОБЛАСТИ, 4 ФИЛИАЛА НА ТЕРРИТОРИИ РОССИИ. ВСЕ ЭТО И ЯВЛЯЕТСЯ ЗАЛОГОМ УСПЕХА!', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1621', 'rey', '', '-1996336364', NULL, 9, '2023-09-05 11:26:04'),
(111, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'TDS', 100, 'Профессиональное оборудование для медицинских центров', 'text', 101, '<p>TDS — профессиональное оборудование для медицинских центров французского бренда. Производитель представляет широкий спектр моделей. От простых нагревателей воска и парафина до многофункциональных комбайнов с большим набором функций.</p>\r\n<p>TDS предлагает оборудование, отвечающее современным требованиям: аппараты ультразвуковой чистки, фонофореза и микромассажа, микротоковой терапии, броссажа, ионофореза, электроэпиляции и с другими функциями, что позволяет профессионалам выбрать оборудование, максимально подходящее для работы. Европейское качество по приятным ценам.</p>', 'html', 'TDS\r\nПРОФЕССИОНАЛЬНОЕ ОБОРУДОВАНИЕ ДЛЯ МЕДИЦИНСКИХ ЦЕНТРОВ\r\nTDS — ПРОФЕССИОНАЛЬНОЕ ОБОРУДОВАНИЕ ДЛЯ \r\nМЕДИЦИНСКИХ ЦЕНТРОВ ФРАНЦУЗСКОГО БРЕНДА. ПРОИЗВОДИТЕЛЬ ПРЕДСТАВЛЯЕТ ШИРОКИЙ СПЕКТР МОДЕЛЕЙ. ОТ ПРОСТЫХ НАГРЕВАТЕЛЕЙ ВОСКА И ПАРАФИНА ДО МНОГОФУНКЦИОНАЛЬНЫХ КОМБАЙНОВ С БОЛЬШИМ НАБОРОМ ФУНКЦИЙ. \r\n\r\nTDS ПРЕДЛАГАЕТ ОБОРУДОВАНИЕ, ОТВЕЧАЮЩЕЕ \r\nСОВРЕМЕННЫМ ТРЕБОВАНИЯМ: АППАРАТЫ УЛЬТРАЗВУКОВОЙ ЧИСТКИ, ФОНОФОРЕЗА И МИКРОМАССАЖА, МИКРОТОКОВОЙ ТЕРАПИИ, БРОССАЖА, ИОНОФОРЕЗА, ЭЛЕКТРОЭПИЛЯЦИИ И С ДРУГИМИ ФУНКЦИЯМИ, ЧТО ПОЗВОЛЯЕТ ПРОФЕССИОНАЛАМ ВЫБРАТЬ ОБОРУДОВАНИЕ, МАКСИМАЛЬНО ПОДХОДЯЩЕЕ ДЛЯ РАБОТЫ. ЕВРОПЕЙСКОЕ КАЧЕСТВО ПО ПРИЯТНЫМ ЦЕНАМ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1622', 'tds', '', '-399841616', NULL, 11, '2023-09-05 11:26:11'),
(112, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Fasa', 102, 'Производитель воздуховодов и комплектующих для вентиляции', 'html', 103, '<p>\r\n	 FASA — компания, которая производит воздуховоды, шумоглушители, диффузоры и другие товары для системы вентиляции. Создана в 1996 году. Сейчас представлена 18 филиалами по всей стране. Команда состоит из 2669 сотрудников.\r\n</p>\r\n<p>\r\n	 При создании товаров компания использует новейшие технологии и гарантирует качество изделий. Помимо производства и продажи товаров для вентиляции организация предлагает услуги по доставке заказов.\r\n</p>', 'html', 'FASA\r\nПРОИЗВОДИТЕЛЬ ВОЗДУХОВОДОВ И КОМПЛЕКТУЮЩИХ \r\nДЛЯ ВЕНТИЛЯЦИИ\r\nFASA — КОМПАНИЯ, КОТОРАЯ ПРОИЗВОДИТ ВОЗДУХОВОДЫ, \r\nШУМОГЛУШИТЕЛИ, ДИФФУЗОРЫ И ДРУГИЕ ТОВАРЫ ДЛЯ СИСТЕМЫ ВЕНТИЛЯЦИИ. СОЗДАНА В 1996 ГОДУ. СЕЙЧАС ПРЕДСТАВЛЕНА 18 ФИЛИАЛАМИ ПО ВСЕЙ СТРАНЕ. КОМАНДА СОСТОИТ ИЗ 2669 СОТРУДНИКОВ. \r\n\r\nПРИ СОЗДАНИИ ТОВАРОВ КОМПАНИЯ ИСПОЛЬЗУЕТ \r\nНОВЕЙШИЕ ТЕХНОЛОГИИ И ГАРАНТИРУЕТ КАЧЕСТВО ИЗДЕЛИЙ. ПОМИМО ПРОИЗВОДСТВА И ПРОДАЖИ ТОВАРОВ ДЛЯ ВЕНТИЛЯЦИИ ОРГАНИЗАЦИЯ ПРЕДЛАГАЕТ УСЛУГИ ПО ДОСТАВКЕ ЗАКАЗОВ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1980', 'fasa', '', '-709794425', NULL, 8, '2023-09-05 11:26:05'),
(113, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Misterio', 104, 'Системы видеонаблюдения и контроля доступа', 'html', NULL, '<p>Misterio— оптово-розничная компания, занимающаяся производством оборудования для систем безопасности. Уже 5 лет занимает позицию лидера отечественного рынка. Выпускает продукцию, которая отличается высокими технологическими показателями.</p>\r\n<p>Является надежным поставщиком продукции, поэтому мы с уверенностью используем товары бренда в каждом проекте. Поставляет для продажи оборудование по низким ценам.</p>', 'html', 'MISTERIO\r\nСИСТЕМЫ ВИДЕОНАБЛЮДЕНИЯ И КОНТРОЛЯ ДОСТУПА\r\nMISTERIO— ОПТОВО-РОЗНИЧНАЯ КОМПАНИЯ, ЗАНИМАЮЩАЯСЯ \r\nПРОИЗВОДСТВОМ ОБОРУДОВАНИЯ ДЛЯ СИСТЕМ БЕЗОПАСНОСТИ. УЖЕ 5 ЛЕТ ЗАНИМАЕТ ПОЗИЦИЮ ЛИДЕРА ОТЕЧЕСТВЕННОГО РЫНКА. ВЫПУСКАЕТ ПРОДУКЦИЮ, КОТОРАЯ ОТЛИЧАЕТСЯ ВЫСОКИМИ ТЕХНОЛОГИЧЕСКИМИ ПОКАЗАТЕЛЯМИ. \r\n\r\nЯВЛЯЕТСЯ НАДЕЖНЫМ ПОСТАВЩИКОМ ПРОДУКЦИИ, \r\nПОЭТОМУ МЫ С УВЕРЕННОСТЬЮ ИСПОЛЬЗУЕМ ТОВАРЫ БРЕНДА В КАЖДОМ ПРОЕКТЕ. ПОСТАВЛЯЕТ ДЛЯ ПРОДАЖИ ОБОРУДОВАНИЕ ПО НИЗКИМ ЦЕНАМ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1981', 'misterio', '', '-183509383', NULL, 7, '2023-09-05 11:26:09'),
(114, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Kolleri', 105, 'Ведущий производитель инженерного оборудования', 'html', 106, '<p>\r\n	 Kolleri — перспективная итальянская компания, которая специализируется на производстве товаров для инженерных систем. Отличается использованием передовых технологий и долговечностью изделий.\r\n</p>\r\n<p>\r\n	 Оборудование марки Kolleri оснащено новейшими разработками и создано для максимальной безопасности в эксплуатации. А за счет подробной документации оно легко и быстро монтируется.\r\n</p>', 'html', 'KOLLERI\r\nВЕДУЩИЙ ПРОИЗВОДИТЕЛЬ ИНЖЕНЕРНОГО ОБОРУДОВАНИЯ\r\nKOLLERI — ПЕРСПЕКТИВНАЯ ИТАЛЬЯНСКАЯ КОМПАНИЯ, \r\nКОТОРАЯ СПЕЦИАЛИЗИРУЕТСЯ НА ПРОИЗВОДСТВЕ ТОВАРОВ ДЛЯ ИНЖЕНЕРНЫХ СИСТЕМ. ОТЛИЧАЕТСЯ ИСПОЛЬЗОВАНИЕМ ПЕРЕДОВЫХ ТЕХНОЛОГИЙ И ДОЛГОВЕЧНОСТЬЮ ИЗДЕЛИЙ. \r\n\r\nОБОРУДОВАНИЕ МАРКИ KOLLERI ОСНАЩЕНО НОВЕЙШИМИ \r\nРАЗРАБОТКАМИ И СОЗДАНО ДЛЯ МАКСИМАЛЬНОЙ БЕЗОПАСНОСТИ В ЭКСПЛУАТАЦИИ. А ЗА СЧЕТ ПОДРОБНОЙ ДОКУМЕНТАЦИИ ОНО ЛЕГКО И БЫСТРО МОНТИРУЕТСЯ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1985', 'kolleri', '', '957450536', NULL, 4, '2023-09-05 11:26:20'),
(115, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'KMI', 107, 'Итальянский бренд строительных материалов', 'text', NULL, '<p>Основанный в 1978 году он завоевал сердца клиентов своим новым видением материалов для строительства. Создатели посещали другие страны и изучали культуру, затем создали свой, абсолютно новый необычный дизайн изделий из ДПК и каминов.</p>\r\n<p>По сей день, компания продолжает свою деятельность и пользуется спросом в России. Привлекаются молодые специалисты, которые не боятся экспериментировать и пробовать себя в новых направлениях.</p>', 'html', 'KMI\r\nИТАЛЬЯНСКИЙ БРЕНД СТРОИТЕЛЬНЫХ МАТЕРИАЛОВ\r\nОСНОВАННЫЙ В 1978 ГОДУ ОН ЗАВОЕВАЛ СЕРДЦА \r\nКЛИЕНТОВ СВОИМ НОВЫМ ВИДЕНИЕМ МАТЕРИАЛОВ ДЛЯ СТРОИТЕЛЬСТВА. СОЗДАТЕЛИ ПОСЕЩАЛИ ДРУГИЕ СТРАНЫ И ИЗУЧАЛИ КУЛЬТУРУ, ЗАТЕМ СОЗДАЛИ СВОЙ, АБСОЛЮТНО НОВЫЙ НЕОБЫЧНЫЙ ДИЗАЙН ИЗДЕЛИЙ ИЗ ДПК И КАМИНОВ. \r\n\r\nПО СЕЙ ДЕНЬ, КОМПАНИЯ ПРОДОЛЖАЕТ СВОЮ ДЕЯТЕЛЬНОСТЬ \r\nИ ПОЛЬЗУЕТСЯ СПРОСОМ В РОССИИ. ПРИВЛЕКАЮТСЯ МОЛОДЫЕ СПЕЦИАЛИСТЫ, КОТОРЫЕ НЕ БОЯТСЯ ЭКСПЕРИМЕНТИРОВАТЬ И ПРОБОВАТЬ СЕБЯ В НОВЫХ НАПРАВЛЕНИЯХ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '1997', 'kmi', '', '410220192', NULL, 8, '2023-09-05 11:12:36'),
(116, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Нереус', 108, 'Гигант в сфере производства товаров для системы безопасности', 'text', NULL, '<p>\r\n	 Нереус — оптово-розничная компания, занимающаяся производством оборудования для систем безопасности. Уже 5 лет занимает позицию лидера отечественного рынка. Выпускает продукцию, которая отличается высокими технологическими показателями.\r\n</p>\r\n<p>\r\n	 Является надежным поставщиком продукции, поэтому мы с уверенностью используем товары бренда в каждом проекте. Поставляет для продажи оборудование по низким ценам.\r\n</p>', 'html', 'НЕРЕУС\r\nГИГАНТ В СФЕРЕ ПРОИЗВОДСТВА ТОВАРОВ ДЛЯ СИСТЕМЫ БЕЗОПАСНОСТИ\r\nНЕРЕУС — ОПТОВО-РОЗНИЧНАЯ КОМПАНИЯ, ЗАНИМАЮЩАЯСЯ \r\nПРОИЗВОДСТВОМ ОБОРУДОВАНИЯ ДЛЯ СИСТЕМ БЕЗОПАСНОСТИ. УЖЕ 5 ЛЕТ ЗАНИМАЕТ ПОЗИЦИЮ ЛИДЕРА ОТЕЧЕСТВЕННОГО РЫНКА. ВЫПУСКАЕТ ПРОДУКЦИЮ, КОТОРАЯ ОТЛИЧАЕТСЯ ВЫСОКИМИ ТЕХНОЛОГИЧЕСКИМИ ПОКАЗАТЕЛЯМИ. \r\n\r\nЯВЛЯЕТСЯ НАДЕЖНЫМ ПОСТАВЩИКОМ ПРОДУКЦИИ, \r\nПОЭТОМУ МЫ С УВЕРЕННОСТЬЮ ИСПОЛЬЗУЕМ ТОВАРЫ БРЕНДА В КАЖДОМ ПРОЕКТЕ. ПОСТАВЛЯЕТ ДЛЯ ПРОДАЖИ ОБОРУДОВАНИЕ ПО НИЗКИМ ЦЕНАМ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2550', 'nereus', '', '-1883084236', NULL, 8, '2023-09-05 11:10:35'),
(117, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Lindros', 109, 'Надежный производитель спецтехники', 'text', NULL, '<p>\r\n	 Lindros — профессиональная спецтехника для строительных мероприятий любой сложности. Производитель представляет широкий спектр моделей. В каталоге вы найдете автокраны, манипуляторы, самосвалы и экскаваторы.\r\n</p>\r\n<p>\r\n	 Lindros предлагает оборудование, отвечающее современным требованиям.&nbsp;Весь товарный ряд приобретен после 2019 года, поэтому вы можете быть уверены в исправности машин и качестве их работы. В сезон строительных работ (апрель-октябрь) просим делать заказ минимум за 7 дней до начала работ.\r\n</p>', 'html', 'LINDROS\r\nНАДЕЖНЫЙ ПРОИЗВОДИТЕЛЬ СПЕЦТЕХНИКИ\r\nLINDROS — ПРОФЕССИОНАЛЬНАЯ СПЕЦТЕХНИКА ДЛЯ \r\nСТРОИТЕЛЬНЫХ МЕРОПРИЯТИЙ ЛЮБОЙ СЛОЖНОСТИ. ПРОИЗВОДИТЕЛЬ ПРЕДСТАВЛЯЕТ ШИРОКИЙ СПЕКТР МОДЕЛЕЙ. В КАТАЛОГЕ ВЫ НАЙДЕТЕ АВТОКРАНЫ, МАНИПУЛЯТОРЫ, САМОСВАЛЫ И ЭКСКАВАТОРЫ. \r\n\r\nLINDROS ПРЕДЛАГАЕТ ОБОРУДОВАНИЕ, ОТВЕЧАЮЩЕЕ \r\nСОВРЕМЕННЫМ ТРЕБОВАНИЯМ.&NBSP;ВЕСЬ ТОВАРНЫЙ РЯД ПРИОБРЕТЕН ПОСЛЕ 2019 ГОДА, ПОЭТОМУ ВЫ МОЖЕТЕ БЫТЬ УВЕРЕНЫ В ИСПРАВНОСТИ МАШИН И КАЧЕСТВЕ ИХ РАБОТЫ. В СЕЗОН СТРОИТЕЛЬНЫХ РАБОТ (АПРЕЛЬ-ОКТЯБРЬ) ПРОСИМ ДЕЛАТЬ ЗАКАЗ МИНИМУМ ЗА 7 ДНЕЙ ДО НАЧАЛА РАБОТ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2551', 'lindros', '', '-407491092', NULL, 7, '2023-09-05 11:06:07'),
(118, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Losk', 110, 'Российский бренд дизайнерской мебели', 'text', NULL, '<p>\r\n	 Кровати, тумбы и стеллажи выполнены из дуба&nbsp;– крепкого и долговечного материала, который отделан шпоном драгоценного американского ореха. В мастерской творят 15 ювелиров и 5 дизайнеров с опытом работы 7 лет и больше. Атмосфера пропитана искусством.\r\n</p>\r\n<p>\r\n	Losk стал победителем в номинации «Прорыв года» на конкурсе «Бриллиантовая лоза». Этот момент стал точкой роста и новых открытий. Сейчас мебель продается в 30 городах России, а доставка работает по всему миру.\r\n</p>', 'html', 'LOSK\r\nРОССИЙСКИЙ БРЕНД ДИЗАЙНЕРСКОЙ МЕБЕЛИ\r\nКРОВАТИ, ТУМБЫ И СТЕЛЛАЖИ ВЫПОЛНЕНЫ ИЗ \r\nДУБА&NBSP;– КРЕПКОГО И ДОЛГОВЕЧНОГО МАТЕРИАЛА, КОТОРЫЙ ОТДЕЛАН ШПОНОМ ДРАГОЦЕННОГО АМЕРИКАНСКОГО ОРЕХА. В МАСТЕРСКОЙ ТВОРЯТ 15 ЮВЕЛИРОВ И 5 ДИЗАЙНЕРОВ С ОПЫТОМ РАБОТЫ 7 ЛЕТ И БОЛЬШЕ. АТМОСФЕРА ПРОПИТАНА ИСКУССТВОМ. \r\n\r\nLOSK СТАЛ ПОБЕДИТЕЛЕМ В НОМИНАЦИИ «ПРОРЫВ \r\nГОДА» НА КОНКУРСЕ «БРИЛЛИАНТОВАЯ ЛОЗА». ЭТОТ МОМЕНТ СТАЛ ТОЧКОЙ РОСТА И НОВЫХ ОТКРЫТИЙ. СЕЙЧАС МЕБЕЛЬ ПРОДАЕТСЯ В 30 ГОРОДАХ РОССИИ, А ДОСТАВКА РАБОТАЕТ ПО ВСЕМУ МИРУ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2552', 'losk', '', '-1999414433', NULL, 8, '2023-09-05 11:13:31'),
(119, '2023-04-27 00:09:54', 1, '2023-04-27 00:09:54', 1, 28, NULL, 'Y', NULL, NULL, 500, 'Rosei', 111, 'Отечественный бренд строительных материалов', 'text', NULL, '<p>\r\n	 Rosei — отечественный бренд, который занимается производством и продажей строительных товаров на любой вкус и бюджет. Компания появилась в 2012 году, но за это время успела зарекомендовать себя с лучшей стороны. Является востребованным брендом на рынке.\r\n</p>\r\n<p>\r\n	 Стройматериалы Rosei привлекают своей разноплановостью и демократичностью цен. В ассортиментной линейке можно найти модели различных форм, габаритов и оснастки.\r\n</p>', 'html', 'ROSEI\r\nОТЕЧЕСТВЕННЫЙ БРЕНД СТРОИТЕЛЬНЫХ МАТЕРИАЛОВ\r\nROSEI — ОТЕЧЕСТВЕННЫЙ БРЕНД, КОТОРЫЙ ЗАНИМАЕТСЯ \r\nПРОИЗВОДСТВОМ И ПРОДАЖЕЙ СТРОИТЕЛЬНЫХ ТОВАРОВ НА ЛЮБОЙ ВКУС И БЮДЖЕТ. КОМПАНИЯ ПОЯВИЛАСЬ В 2012 ГОДУ, НО ЗА ЭТО ВРЕМЯ УСПЕЛА ЗАРЕКОМЕНДОВАТЬ СЕБЯ С ЛУЧШЕЙ СТОРОНЫ. ЯВЛЯЕТСЯ ВОСТРЕБОВАННЫМ БРЕНДОМ НА РЫНКЕ. \r\n\r\nСТРОЙМАТЕРИАЛЫ ROSEI ПРИВЛЕКАЮТ СВОЕЙ РАЗНОПЛАНОВОСТЬЮ \r\nИ ДЕМОКРАТИЧНОСТЬЮ ЦЕН. В АССОРТИМЕНТНОЙ ЛИНЕЙКЕ МОЖНО НАЙТИ МОДЕЛИ РАЗЛИЧНЫХ ФОРМ, ГАБАРИТОВ И ОСНАСТКИ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '2553', 'rosei', '', '1200610998', NULL, 11, '2023-09-05 11:11:08'),
(120, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 40, 'Y', NULL, NULL, 500, 'Лицензия на розничную продажу алкогольной продукции', 112, 'Согласно Федеральному закону выдача лицензий на розничную продажу алкогольной продукции относится к полномочиям органов государственной власти субъектов Российской Федерации.', 'text', 113, '', 'text', 'ЛИЦЕНЗИЯ НА РОЗНИЧНУЮ ПРОДАЖУ АЛКОГОЛЬНОЙ ПРОДУКЦИИ\r\nСОГЛАСНО ФЕДЕРАЛЬНОМУ ЗАКОНУ ВЫДАЧА ЛИЦЕНЗИЙ НА РОЗНИЧНУЮ ПРОДАЖУ АЛКОГОЛЬНОЙ ПРОДУКЦИИ ОТНОСИТСЯ К ПОЛНОМОЧИЯМ ОРГАНОВ ГОСУДАРСТВЕННОЙ ВЛАСТИ СУБЪЕКТОВ РОССИЙСКОЙ ФЕДЕРАЦИИ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '37', 'razreshenie-na-okhotu-na-dikikh-zverey-i-ptits', '', '987649651', NULL, NULL, NULL),
(121, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 40, 'Y', NULL, NULL, 500, 'Лицензия на осуществление медицинской деятельности', 114, 'Положение определяет порядок лицензирования медицинской деятельности, осуществляемой на территории Российской Федерации медицинскими и иными организациями, а также индивидуальными предпринимателями.', 'text', 115, '', 'text', 'ЛИЦЕНЗИЯ НА ОСУЩЕСТВЛЕНИЕ МЕДИЦИНСКОЙ ДЕЯТЕЛЬНОСТИ\r\nПОЛОЖЕНИЕ ОПРЕДЕЛЯЕТ ПОРЯДОК ЛИЦЕНЗИРОВАНИЯ МЕДИЦИНСКОЙ ДЕЯТЕЛЬНОСТИ, ОСУЩЕСТВЛЯЕМОЙ НА ТЕРРИТОРИИ РОССИЙСКОЙ ФЕДЕРАЦИИ МЕДИЦИНСКИМИ И ИНЫМИ ОРГАНИЗАЦИЯМИ, А ТАКЖЕ ИНДИВИДУАЛЬНЫМИ ПРЕДПРИНИМАТЕЛЯМИ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '38', 'litsenziya-na-provedenie-ekspertizy', '', '710960941', NULL, NULL, NULL),
(122, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 40, 'Y', NULL, NULL, 500, 'Лицензия на перевозку пассажиров в автобусах', 116, 'Следует учитывать, что лишение права управления транспортными средствами предусматривает, что гражданин, в отношении которого применено такое наказание, теряет именно само право управления, а не документ под названием «водительское удостоверение», которое изымают лишь для обеспечения исполнения наказания.', 'text', 117, '', 'text', 'ЛИЦЕНЗИЯ НА ПЕРЕВОЗКУ ПАССАЖИРОВ В АВТОБУСАХ\r\nСЛЕДУЕТ УЧИТЫВАТЬ, ЧТО ЛИШЕНИЕ ПРАВА УПРАВЛЕНИЯ ТРАНСПОРТНЫМИ СРЕДСТВАМИ ПРЕДУСМАТРИВАЕТ, ЧТО ГРАЖДАНИН, В ОТНОШЕНИИ КОТОРОГО ПРИМЕНЕНО ТАКОЕ НАКАЗАНИЕ, ТЕРЯЕТ ИМЕННО САМО ПРАВО УПРАВЛЕНИЯ, А НЕ ДОКУМЕНТ ПОД НАЗВАНИЕМ «ВОДИТЕЛЬСКОЕ УДОСТОВЕРЕНИЕ», КОТОРОЕ ИЗЫМАЮТ ЛИШЬ ДЛЯ ОБЕСПЕЧЕНИЯ ИСПОЛНЕНИЯ НАКАЗАНИЯ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '39', 'litsenziya-na-proektirovanie-zdaniy', '', '-1546044639', NULL, NULL, NULL),
(123, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 39, 'Y', NULL, NULL, 500, 'Сертификат соответствия ГОСТ', 118, 'Сертификат соответствия Госстроя, выдается на продукцию, используемую в туризме, и подтверждающий, что услуги санатория соответствуют требованиям основных нормативно-технических документов, установленных для данных услуг.', 'text', 119, '', 'text', 'СЕРТИФИКАТ СООТВЕТСТВИЯ ГОСТ\r\nСЕРТИФИКАТ СООТВЕТСТВИЯ ГОССТРОЯ, ВЫДАЕТСЯ НА ПРОДУКЦИЮ, ИСПОЛЬЗУЕМУЮ В ТУРИЗМЕ, И ПОДТВЕРЖДАЮЩИЙ, ЧТО УСЛУГИ САНАТОРИЯ СООТВЕТСТВУЮТ ТРЕБОВАНИЯМ ОСНОВНЫХ НОРМАТИВНО-ТЕХНИЧЕСКИХ ДОКУМЕНТОВ, УСТАНОВЛЕННЫХ ДЛЯ ДАННЫХ УСЛУГ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '41', 'sertifikat-sootvetstviya-gost', '', '-131121722', NULL, NULL, NULL),
(124, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 39, 'Y', NULL, NULL, 500, 'Сертификат пожарной безопасности', 120, 'Сертификат пожарной безопасности (пожарный сертификат) — это документ, подтверждающий, что продукция соответствует требованиям пожарной безопасности.', 'text', 121, '', 'text', 'СЕРТИФИКАТ ПОЖАРНОЙ БЕЗОПАСНОСТИ\r\nСЕРТИФИКАТ ПОЖАРНОЙ БЕЗОПАСНОСТИ (ПОЖАРНЫЙ СЕРТИФИКАТ) — ЭТО ДОКУМЕНТ, ПОДТВЕРЖДАЮЩИЙ, ЧТО ПРОДУКЦИЯ СООТВЕТСТВУЕТ ТРЕБОВАНИЯМ ПОЖАРНОЙ БЕЗОПАСНОСТИ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '42', 'sertifikat-pozharnoy-bezopasnosti', '', '-12294230', NULL, NULL, NULL),
(125, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 39, 'Y', NULL, NULL, 500, 'Свидетельство о государственной регистрации', 122, 'Свидетельство о государственной регистрации или письмо о соответствии продукции Единым санитарно-эпидемиологическим и гигиеническим требованиям — документ, подтверждающий, что продукция и услуги соответствуют установленным Единым гигиеническим нормам.', 'text', 123, '', 'text', 'СВИДЕТЕЛЬСТВО О ГОСУДАРСТВЕННОЙ РЕГИСТРАЦИИ\r\nСВИДЕТЕЛЬСТВО О ГОСУДАРСТВЕННОЙ РЕГИСТРАЦИИ ИЛИ ПИСЬМО О СООТВЕТСТВИИ ПРОДУКЦИИ ЕДИНЫМ САНИТАРНО-ЭПИДЕМИОЛОГИЧЕСКИМ И ГИГИЕНИЧЕСКИМ ТРЕБОВАНИЯМ — ДОКУМЕНТ, ПОДТВЕРЖДАЮЩИЙ, ЧТО ПРОДУКЦИЯ И УСЛУГИ СООТВЕТСТВУЮТ УСТАНОВЛЕННЫМ ЕДИНЫМ ГИГИЕНИЧЕСКИМ НОРМАМ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '43', 'svidetelstvo-o-gosudarstvennoy-registratsii', '', '-1918781983', NULL, NULL, NULL),
(126, '2023-04-27 00:09:55', 1, '2023-04-27 00:09:55', 1, 29, 39, 'Y', NULL, NULL, 100, 'Сертификат соответствия', 124, 'Сертификат соответствия — документ, подтверждающий соответствие санитарным и пожарным правилам используемой территории, здания, строений, оборудований и транспортных средств.', 'text', 125, '', 'text', 'СЕРТИФИКАТ СООТВЕТСТВИЯ\r\nСЕРТИФИКАТ СООТВЕТСТВИЯ — ДОКУМЕНТ, ПОДТВЕРЖДАЮЩИЙ СООТВЕТСТВИЕ САНИТАРНЫМ И ПОЖАРНЫМ ПРАВИЛАМ ИСПОЛЬЗУЕМОЙ ТЕРРИТОРИИ, ЗДАНИЯ, СТРОЕНИЙ, ОБОРУДОВАНИЙ И ТРАНСПОРТНЫХ СРЕДСТВ.\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '44', 'sertifikat-sootvetstviya2', '', '-88273466', NULL, NULL, NULL),
(127, '2024-08-22 20:27:20', 1, '2023-04-27 00:09:56', 1, 30, NULL, 'Y', NULL, NULL, 2023, '2023', NULL, 'К началу мая 2023 года наш проект достиг важной стадии - мы успешно открыли пляжный сезон. Гордо объявляем, что наш комплекс приветствует гостей с готовыми 12 коттеджами, оснащенными всем необходимым для комфортного проживания. В этот момент нашей командой было проделано огромное количество работы, чтобы создать уютное и современное пространство для отдыха и развлечений.', 'html', NULL, '<p>\r\n <span style=\"color: var(--basic_text_black);\">Наши усилия также привели к возникновению разнообразных объектов для отдыха и развлечений на территории. Кафе с уникальной атмосферой, детская площадка, гастрономический уголок и два бассейна (один из которых предназначен для детей, а другой - для взрослых) - все это было создано с целью обеспечить незабываемое пребывание для наших гостей.</span>\r\n</p>\r\n<p>\r\n	 Наш успех - результат тщательного планирования, упорства и коллективной работы. Открытие пляжного сезона стало важным шагом в нашем стремлении предоставить высококачественный опыт отдыха, сочетая комфорт, уют и разнообразие развлечений на прибрежной территории.\r\n</p>', 'html', '2023\r\nК НАЧАЛУ МАЯ 2023 ГОДА НАШ ПРОЕКТ ДОСТИГ ВАЖНОЙ \r\nСТАДИИ - МЫ УСПЕШНО ОТКРЫЛИ ПЛЯЖНЫЙ СЕЗОН. ГОРДО ОБЪЯВЛЯЕМ, ЧТО НАШ КОМПЛЕКС ПРИВЕТСТВУЕТ ГОСТЕЙ С ГОТОВЫМИ 12 КОТТЕДЖАМИ, ОСНАЩЕННЫМИ ВСЕМ НЕОБХОДИМЫМ ДЛЯ КОМФОРТНОГО ПРОЖИВАНИЯ. В ЭТОТ МОМЕНТ НАШЕЙ КОМАНДОЙ БЫЛО ПРОДЕЛАНО ОГРОМНОЕ КОЛИЧЕСТВО РАБОТЫ, ЧТОБЫ СОЗДАТЬ УЮТНОЕ И СОВРЕМЕННОЕ ПРОСТРАНСТВО ДЛЯ ОТДЫХА И РАЗВЛЕЧЕНИЙ.\r\nНАШИ УСИЛИЯ ТАКЖЕ ПРИВЕЛИ К ВОЗНИКНОВЕНИЮ \r\nРАЗНООБРАЗНЫХ ОБЪЕКТОВ ДЛЯ ОТДЫХА И РАЗВЛЕЧЕНИЙ НА ТЕРРИТОРИИ. КАФЕ С УНИКАЛЬНОЙ АТМОСФЕРОЙ, ДЕТСКАЯ ПЛОЩАДКА, ГАСТРОНОМИЧЕСКИЙ УГОЛОК И ДВА БАССЕЙНА (ОДИН ИЗ КОТОРЫХ ПРЕДНАЗНАЧЕН ДЛЯ ДЕТЕЙ, А ДРУГОЙ - ДЛЯ ВЗРОСЛЫХ) - ВСЕ ЭТО БЫЛО СОЗДАНО С ЦЕЛЬЮ ОБЕСПЕЧИТЬ НЕЗАБЫВАЕМОЕ ПРЕБЫВАНИЕ ДЛЯ НАШИХ ГОСТЕЙ. \r\n\r\nНАШ УСПЕХ - РЕЗУЛЬТАТ ТЩАТЕЛЬНОГО ПЛАНИРОВАНИЯ, \r\nУПОРСТВА И КОЛЛЕКТИВНОЙ РАБОТЫ. ОТКРЫТИЕ ПЛЯЖНОГО СЕЗОНА СТАЛО ВАЖНЫМ ШАГОМ В НАШЕМ СТРЕМЛЕНИИ ПРЕДОСТАВИТЬ ВЫСОКОКАЧЕСТВЕННЫЙ ОПЫТ ОТДЫХА, СОЧЕТАЯ КОМФОРТ, УЮТ И РАЗНООБРАЗИЕ РАЗВЛЕЧЕНИЙ НА ПРИБРЕЖНОЙ ТЕРРИТОРИИ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '63', '', '', '0', NULL, NULL, NULL),
(128, '2024-08-22 20:27:06', 1, '2023-04-27 00:09:56', 1, 30, NULL, 'Y', NULL, NULL, 2022, '2022', NULL, 'К концу августа 2022 года мы успешно завершили возведение всех необходимых сооружений на прибрежной зоне. С этим важным этапом справились благодаря усилиям нашей команды и тщательному планированию. Теперь перед нами стояла новая задача - освоить дизайнерский проект, связанный с интерьерными работами.', 'text', NULL, '<p>\r\n <span style=\"color: var(--basic_text_black);\">Наша цель заключалась в том, чтобы создать уникальную и гармоничную атмосферу внутри каждого сооружения. Мы подошли к этой задаче с творческим подходом и вниманием к деталям. В рамках дизайнерского проекта мы разработали концепцию для каждого помещения, подбирая цветовую палитру, мебель, декор и освещение, чтобы каждое пространство соответствовало общей идее комплекса.</span>\r\n</p>\r\n<p>\r\n	 Благодаря профессиональным навыкам наших дизайнеров и тесному сотрудничеству с клиентом, мы создали интерьеры, отражающие его уникальный стиль и вписывающиеся в общую концепцию прибрежного комплекса. Это позволило нам добиться высокого уровня комфорта, эстетики и функциональности внутри каждого объекта.\r\n</p>', 'html', '2022\r\nК КОНЦУ АВГУСТА 2022 ГОДА МЫ УСПЕШНО ЗАВЕРШИЛИ ВОЗВЕДЕНИЕ ВСЕХ НЕОБХОДИМЫХ СООРУЖЕНИЙ НА ПРИБРЕЖНОЙ ЗОНЕ. С ЭТИМ ВАЖНЫМ ЭТАПОМ СПРАВИЛИСЬ БЛАГОДАРЯ УСИЛИЯМ НАШЕЙ КОМАНДЫ И ТЩАТЕЛЬНОМУ ПЛАНИРОВАНИЮ. ТЕПЕРЬ ПЕРЕД НАМИ СТОЯЛА НОВАЯ ЗАДАЧА - ОСВОИТЬ ДИЗАЙНЕРСКИЙ ПРОЕКТ, СВЯЗАННЫЙ С ИНТЕРЬЕРНЫМИ РАБОТАМИ.\r\nНАША ЦЕЛЬ ЗАКЛЮЧАЛАСЬ В ТОМ, ЧТОБЫ СОЗДАТЬ \r\nУНИКАЛЬНУЮ И ГАРМОНИЧНУЮ АТМОСФЕРУ ВНУТРИ КАЖДОГО СООРУЖЕНИЯ. МЫ ПОДОШЛИ К ЭТОЙ ЗАДАЧЕ С ТВОРЧЕСКИМ ПОДХОДОМ И ВНИМАНИЕМ К ДЕТАЛЯМ. В РАМКАХ ДИЗАЙНЕРСКОГО ПРОЕКТА МЫ РАЗРАБОТАЛИ КОНЦЕПЦИЮ ДЛЯ КАЖДОГО ПОМЕЩЕНИЯ, ПОДБИРАЯ ЦВЕТОВУЮ ПАЛИТРУ, МЕБЕЛЬ, ДЕКОР И ОСВЕЩЕНИЕ, ЧТОБЫ КАЖДОЕ ПРОСТРАНСТВО СООТВЕТСТВОВАЛО ОБЩЕЙ ИДЕЕ КОМПЛЕКСА. \r\n\r\nБЛАГОДАРЯ ПРОФЕССИОНАЛЬНЫМ НАВЫКАМ НАШИХ \r\nДИЗАЙНЕРОВ И ТЕСНОМУ СОТРУДНИЧЕСТВУ С КЛИЕНТОМ, МЫ СОЗДАЛИ ИНТЕРЬЕРЫ, ОТРАЖАЮЩИЕ ЕГО УНИКАЛЬНЫЙ СТИЛЬ И ВПИСЫВАЮЩИЕСЯ В ОБЩУЮ КОНЦЕПЦИЮ ПРИБРЕЖНОГО КОМПЛЕКСА. ЭТО ПОЗВОЛИЛО НАМ ДОБИТЬСЯ ВЫСОКОГО УРОВНЯ КОМФОРТА, ЭСТЕТИКИ И ФУНКЦИОНАЛЬНОСТИ ВНУТРИ КАЖДОГО ОБЪЕКТА.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '64', '', '', '0', NULL, NULL, NULL),
(129, '2024-08-22 20:26:51', 1, '2023-04-27 00:09:56', 1, 30, NULL, 'Y', NULL, NULL, 2021, '2021', 491, 'Далее мы перешли к реализации дизайнерского проекта, который включал в себя разнообразные объекты: коттеджи, отель, ресторан, кафе, бассейны и другие. Наша команда столкнулась с задачей прокладки электропроводки и коммуникаций под каждый из этих объектов. Это требовало тщательного планирования и согласования, чтобы обеспечить эффективное и безопасное функционирование каждого элемента комплекса.', 'text', NULL, 'Мы разработали интегрированный план, учитывая потребности каждого объекта. Прокладка электропроводки и коммуникаций была осуществлена с учетом современных стандартов энергоэффективности и безопасности. Это позволило нам обеспечить надежное энергоснабжение, а также связь между различными частями комплекса.\r\nБлагодаря слаженной работе нашей команды и профессиональному подходу к каждому этапу проекта, мы успешно справились с задачей и создали функциональное и современное пространство, способное в полной мере удовлетворить потребности наших клиентов и посетителей.', 'html', '2021\r\nДАЛЕЕ МЫ ПЕРЕШЛИ К РЕАЛИЗАЦИИ ДИЗАЙНЕРСКОГО ПРОЕКТА, КОТОРЫЙ ВКЛЮЧАЛ В СЕБЯ РАЗНООБРАЗНЫЕ ОБЪЕКТЫ: КОТТЕДЖИ, ОТЕЛЬ, РЕСТОРАН, КАФЕ, БАССЕЙНЫ И ДРУГИЕ. НАША КОМАНДА СТОЛКНУЛАСЬ С ЗАДАЧЕЙ ПРОКЛАДКИ ЭЛЕКТРОПРОВОДКИ И КОММУНИКАЦИЙ ПОД КАЖДЫЙ ИЗ ЭТИХ ОБЪЕКТОВ. ЭТО ТРЕБОВАЛО ТЩАТЕЛЬНОГО ПЛАНИРОВАНИЯ И СОГЛАСОВАНИЯ, ЧТОБЫ ОБЕСПЕЧИТЬ ЭФФЕКТИВНОЕ И БЕЗОПАСНОЕ ФУНКЦИОНИРОВАНИЕ КАЖДОГО ЭЛЕМЕНТА КОМПЛЕКСА.\r\nМЫ РАЗРАБОТАЛИ ИНТЕГРИРОВАННЫЙ ПЛАН, УЧИТЫВАЯ \r\nПОТРЕБНОСТИ КАЖДОГО ОБЪЕКТА. ПРОКЛАДКА ЭЛЕКТРОПРОВОДКИ И КОММУНИКАЦИЙ БЫЛА ОСУЩЕСТВЛЕНА С УЧЕТОМ СОВРЕМЕННЫХ СТАНДАРТОВ ЭНЕРГОЭФФЕКТИВНОСТИ И БЕЗОПАСНОСТИ. ЭТО ПОЗВОЛИЛО НАМ ОБЕСПЕЧИТЬ НАДЕЖНОЕ ЭНЕРГОСНАБЖЕНИЕ, А ТАКЖЕ СВЯЗЬ МЕЖДУ РАЗЛИЧНЫМИ ЧАСТЯМИ КОМПЛЕКСА. БЛАГОДАРЯ СЛАЖЕННОЙ РАБОТЕ НАШЕЙ КОМАНДЫ И ПРОФЕССИОНАЛЬНОМУ ПОДХОДУ К КАЖДОМУ ЭТАПУ ПРОЕКТА, МЫ УСПЕШНО СПРАВИЛИСЬ С ЗАДАЧЕЙ И СОЗДАЛИ ФУНКЦИОНАЛЬНОЕ И СОВРЕМЕННОЕ ПРОСТРАНСТВО, СПОСОБНОЕ В ПОЛНОЙ МЕРЕ УДОВЛЕТВОРИТЬ ПОТРЕБНОСТИ НАШИХ КЛИЕНТОВ И ПОСЕТИТЕЛЕЙ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '65', '', '', '0', NULL, NULL, NULL),
(130, '2024-08-22 20:26:40', 1, '2023-04-27 00:09:56', 1, 30, NULL, 'Y', NULL, NULL, 2020, '2020', NULL, 'Были произведены первые работы по благоустройству территории', 'html', NULL, 'Когда мы приступили к выполнению проекта, в нашей команде насчитывалось 17 высококвалифицированных сотрудников. Одной из ключевых задач, стоявших перед нами, было обозначение и ограждение прибрежной территории. Мы взялись за это с особой ответственностью, учитывая важность сохранения окружающей среды и обеспечения безопасности наших клиентов. Путем тщательного планирования и координации усилий нашей команды мы успешно разработали и реализовали стратегию ограждения, что позволило обеспечить как безопасность, так и сохранность природных ресурсов данной территории.', 'text', '2020\r\nБЫЛИ ПРОИЗВЕДЕНЫ ПЕРВЫЕ РАБОТЫ ПО БЛАГОУСТРОЙСТВУ \r\nТЕРРИТОРИИ\r\nКОГДА МЫ ПРИСТУПИЛИ К ВЫПОЛНЕНИЮ ПРОЕКТА, В НАШЕЙ КОМАНДЕ НАСЧИТЫВАЛОСЬ 17 ВЫСОКОКВАЛИФИЦИРОВАННЫХ СОТРУДНИКОВ. ОДНОЙ ИЗ КЛЮЧЕВЫХ ЗАДАЧ, СТОЯВШИХ ПЕРЕД НАМИ, БЫЛО ОБОЗНАЧЕНИЕ И ОГРАЖДЕНИЕ ПРИБРЕЖНОЙ ТЕРРИТОРИИ. МЫ ВЗЯЛИСЬ ЗА ЭТО С ОСОБОЙ ОТВЕТСТВЕННОСТЬЮ, УЧИТЫВАЯ ВАЖНОСТЬ СОХРАНЕНИЯ ОКРУЖАЮЩЕЙ СРЕДЫ И ОБЕСПЕЧЕНИЯ БЕЗОПАСНОСТИ НАШИХ КЛИЕНТОВ. ПУТЕМ ТЩАТЕЛЬНОГО ПЛАНИРОВАНИЯ И КООРДИНАЦИИ УСИЛИЙ НАШЕЙ КОМАНДЫ МЫ УСПЕШНО РАЗРАБОТАЛИ И РЕАЛИЗОВАЛИ СТРАТЕГИЮ ОГРАЖДЕНИЯ, ЧТО ПОЗВОЛИЛО ОБЕСПЕЧИТЬ КАК БЕЗОПАСНОСТЬ, ТАК И СОХРАННОСТЬ ПРИРОДНЫХ РЕСУРСОВ ДАННОЙ ТЕРРИТОРИИ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '66', '', '', '0', NULL, NULL, NULL),
(131, '2023-07-07 12:03:51', 1, '2023-04-27 00:09:57', 1, 31, 42, 'Y', NULL, NULL, 50, 'База отдыха \"Город Моря\"', 127, '', 'text', 128, 'Наша компания имеет широкую сеть региональных представительств. Вы можете обратиться в ближайший к Вам офис для получения консультаций и бронирования номеров. ', 'html', 'БАЗА ОТДЫХА \"ГОРОД МОРЯ\"\r\n\r\nНАША КОМПАНИЯ ИМЕЕТ ШИРОКУЮ СЕТЬ РЕГИОНАЛЬНЫХ \r\nПРЕДСТАВИТЕЛЬСТВ. ВЫ МОЖЕТЕ ОБРАТИТЬСЯ В БЛИЖАЙШИЙ К ВАМ ОФИС ДЛЯ ПОЛУЧЕНИЯ КОНСУЛЬТАЦИЙ И БРОНИРОВАНИЯ НОМЕРОВ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1027', 'g-makhachkala', '', '0', NULL, 1, '2024-06-20 17:12:45'),
(133, '2023-07-07 11:53:36', 1, '2023-04-27 00:09:57', 1, 31, 48, 'N', NULL, NULL, 500, 'г. Екатеринбург', 132, '', 'text', 133, 'Предоставляем широкий спектр услуг в Екатеринбурге: от проектирования инженерных систем до поставок медицинского оборудования. Вы можете заказать услуги по изготовлению, монтажу металлических изделий, взять в аренду спецтехнику для строительных, погрузочно-разгрузочных работ и многое другое. Приходите в любой из наших офисов или звоните по телефону +7 (000) 000-00-00. Проконсультируем и ответим на все вопросы.', 'html', 'Г. ЕКАТЕРИНБУРГ\r\n\r\nПРЕДОСТАВЛЯЕМ ШИРОКИЙ СПЕКТР УСЛУГ В ЕКАТЕРИНБУРГЕ: \r\nОТ ПРОЕКТИРОВАНИЯ ИНЖЕНЕРНЫХ СИСТЕМ ДО ПОСТАВОК МЕДИЦИНСКОГО ОБОРУДОВАНИЯ. ВЫ МОЖЕТЕ ЗАКАЗАТЬ УСЛУГИ ПО ИЗГОТОВЛЕНИЮ, МОНТАЖУ МЕТАЛЛИЧЕСКИХ ИЗДЕЛИЙ, ВЗЯТЬ В АРЕНДУ СПЕЦТЕХНИКУ ДЛЯ СТРОИТЕЛЬНЫХ, ПОГРУЗОЧНО-РАЗГРУЗОЧНЫХ РАБОТ И МНОГОЕ ДРУГОЕ. ПРИХОДИТЕ В ЛЮБОЙ ИЗ НАШИХ ОФИСОВ ИЛИ ЗВОНИТЕ ПО ТЕЛЕФОНУ +7 (000) 000-00-00. ПРОКОНСУЛЬТИРУЕМ И ОТВЕТИМ НА ВСЕ ВОПРОСЫ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1029', '', '', '65419118', NULL, NULL, NULL),
(134, '2023-07-07 11:53:36', 1, '2023-04-27 00:09:57', 1, 31, 48, 'N', NULL, NULL, 500, 'г. Екатеринбург', 134, '', 'text', 135, 'Предоставляем широкий спектр услуг в Екатеринбурге: от проектирования инженерных систем до поставок медицинского оборудования. Вы можете заказать услуги по изготовлению, монтажу металлических изделий, взять в аренду спецтехнику для строительных, погрузочно-разгрузочных работ и многое другое. Приходите в любой из наших офисов или звоните по телефону +7 (000) 000-00-00. Проконсультируем и ответим на все вопросы.', 'html', 'Г. ЕКАТЕРИНБУРГ\r\n\r\nПРЕДОСТАВЛЯЕМ ШИРОКИЙ СПЕКТР УСЛУГ В ЕКАТЕРИНБУРГЕ: \r\nОТ ПРОЕКТИРОВАНИЯ ИНЖЕНЕРНЫХ СИСТЕМ ДО ПОСТАВОК МЕДИЦИНСКОГО ОБОРУДОВАНИЯ. ВЫ МОЖЕТЕ ЗАКАЗАТЬ УСЛУГИ ПО ИЗГОТОВЛЕНИЮ, МОНТАЖУ МЕТАЛЛИЧЕСКИХ ИЗДЕЛИЙ, ВЗЯТЬ В АРЕНДУ СПЕЦТЕХНИКУ ДЛЯ СТРОИТЕЛЬНЫХ, ПОГРУЗОЧНО-РАЗГРУЗОЧНЫХ РАБОТ И МНОГОЕ ДРУГОЕ. ПРИХОДИТЕ В ЛЮБОЙ ИЗ НАШИХ ОФИСОВ ИЛИ ЗВОНИТЕ ПО ТЕЛЕФОНУ +7 (000) 000-00-00. ПРОКОНСУЛЬТИРУЕМ И ОТВЕТИМ НА ВСЕ ВОПРОСЫ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1030', '', '', '171206616', NULL, NULL, NULL),
(135, '2023-07-07 11:52:59', 1, '2023-04-27 00:09:57', 1, 31, 46, 'N', NULL, NULL, 500, 'г. Москва', 136, '', 'text', 137, '', 'html', 'Г. МОСКВА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1031', '', '', '-1913879061', NULL, NULL, NULL),
(136, '2023-07-07 11:52:59', 1, '2023-04-27 00:09:57', 1, 31, 46, 'N', NULL, NULL, 500, 'г. Москва', 138, '', 'text', 139, '', 'html', 'Г. МОСКВА\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1033', '', '', '89816556', NULL, NULL, NULL),
(137, '2023-07-07 11:53:18', 1, '2023-04-27 00:09:57', 1, 31, NULL, 'N', NULL, NULL, 500, 'Казань', NULL, '', 'text', NULL, 'Наша компания имеет широкую сеть региональных представительств. Вы можете обратиться в ближайший к Вам офис для получения консультаций и бронирования номеров.', 'text', 'КАЗАНЬ\r\n\r\nНАША КОМПАНИЯ ИМЕЕТ ШИРОКУЮ СЕТЬ РЕГИОНАЛЬНЫХ ПРЕДСТАВИТЕЛЬСТВ. ВЫ МОЖЕТЕ ОБРАТИТЬСЯ В БЛИЖАЙШИЙ К ВАМ ОФИС ДЛЯ ПОЛУЧЕНИЯ КОНСУЛЬТАЦИЙ И БРОНИРОВАНИЯ НОМЕРОВ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '588', 'kazan', '', '1496042520', NULL, NULL, NULL),
(138, '2023-04-27 00:09:58', 1, '2023-04-27 00:09:58', 1, 32, 49, 'Y', NULL, NULL, 500, 'Прокат современной мототехники', 142, '', 'text', NULL, '', 'text', 'ПРОКАТ СОВРЕМЕННОЙ МОТОТЕХНИКИ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '580', 'mototekhnika', '', '2092841193', NULL, NULL, NULL),
(139, '2023-04-27 00:09:58', 1, '2023-04-27 00:09:58', 1, 32, 49, 'Y', NULL, NULL, 500, 'Полезные SPA-процедуры', 143, '', 'text', NULL, '', 'text', 'ПОЛЕЗНЫЕ SPA-ПРОЦЕДУРЫ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '581', 'spa', '', '1234193138', NULL, NULL, NULL),
(140, '2023-04-27 00:09:58', 1, '2023-04-27 00:09:58', 1, 32, 50, 'Y', NULL, NULL, 500, 'Уютное шале в немецком стиле', 144, '', 'text', NULL, '', 'text', 'УЮТНОЕ ШАЛЕ В НЕМЕЦКОМ СТИЛЕ\r\n\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '582', '', '', '-1690259573', NULL, NULL, NULL),
(141, '2023-09-04 14:51:20', 1, '2023-04-27 00:09:59', 1, 33, NULL, 'Y', NULL, NULL, 500, 'О компании', 510, 'Наша холдинговая компания \"Grand Kavkaz\" является ведущей компанией в сфере отдыха и туризма, предлагающей уникальные возможности для любителей активного отдыха и путешествий. Мы специализируемся на организации туров в горы, на море, а также предлагаем уникальные программы фермерского и фруктового туризма.', 'html', 146, 'Любители активного отдыха восхищаются нашим горнолыжным комплексом, трассами для мотокросса и регулярными спортивными мероприятиями. В санатории предусмотрены полезные лечебно-оздоровительные программы и мангальные зоны для комфортного досуга наших гостей.\r\n<br>\r\n<br>\r\nОбычно у нас отдыхают от недели до месяца, но приезжают и просто на выходные. Вы можете расположиться в номере нашей гостиницы или горном шале на 6-14 человек. Желающим стать одним целым с природой мы предлагаем безопасные площадки для кемпинга. Если при этом вы нуждаетесь в комфорте — глэмпинговые лагеря к вашим услугам!\r\n\r\n', 'html', 'О КОМПАНИИ\r\nНАША ХОЛДИНГОВАЯ КОМПАНИЯ \"GRAND KAVKAZ\" ЯВЛЯЕТСЯ \r\nВЕДУЩЕЙ КОМПАНИЕЙ В СФЕРЕ ОТДЫХА И ТУРИЗМА, ПРЕДЛАГАЮЩЕЙ УНИКАЛЬНЫЕ ВОЗМОЖНОСТИ ДЛЯ ЛЮБИТЕЛЕЙ АКТИВНОГО ОТДЫХА И ПУТЕШЕСТВИЙ. МЫ СПЕЦИАЛИЗИРУЕМСЯ НА ОРГАНИЗАЦИИ ТУРОВ В ГОРЫ, НА МОРЕ, А ТАКЖЕ ПРЕДЛАГАЕМ УНИКАЛЬНЫЕ ПРОГРАММЫ ФЕРМЕРСКОГО И ФРУКТОВОГО ТУРИЗМА.\r\nЛЮБИТЕЛИ АКТИВНОГО ОТДЫХА ВОСХИЩАЮТСЯ \r\nНАШИМ ГОРНОЛЫЖНЫМ КОМПЛЕКСОМ, ТРАССАМИ ДЛЯ МОТОКРОССА И РЕГУЛЯРНЫМИ СПОРТИВНЫМИ МЕРОПРИЯТИЯМИ. В САНАТОРИИ ПРЕДУСМОТРЕНЫ ПОЛЕЗНЫЕ ЛЕЧЕБНО-ОЗДОРОВИТЕЛЬНЫЕ ПРОГРАММЫ И МАНГАЛЬНЫЕ ЗОНЫ ДЛЯ КОМФОРТНОГО ДОСУГА НАШИХ ГОСТЕЙ. \r\n\r\nОБЫЧНО У НАС ОТДЫХАЮТ ОТ НЕДЕЛИ ДО МЕСЯЦА, \r\nНО ПРИЕЗЖАЮТ И ПРОСТО НА ВЫХОДНЫЕ. ВЫ МОЖЕТЕ РАСПОЛОЖИТЬСЯ В НОМЕРЕ НАШЕЙ ГОСТИНИЦЫ ИЛИ ГОРНОМ ШАЛЕ НА 6-14 ЧЕЛОВЕК. ЖЕЛАЮЩИМ СТАТЬ ОДНИМ ЦЕЛЫМ С ПРИРОДОЙ МЫ ПРЕДЛАГАЕМ БЕЗОПАСНЫЕ ПЛОЩАДКИ ДЛЯ КЕМПИНГА. ЕСЛИ ПРИ ЭТОМ ВЫ НУЖДАЕТЕСЬ В КОМФОРТЕ — ГЛЭМПИНГОВЫЕ ЛАГЕРЯ К ВАШИМ УСЛУГАМ!', 1, NULL, NULL, NULL, NULL, NULL, 'N', '3403', 'front_company_item', '', '0', NULL, 10440, '2023-04-27 00:10:36'),
(142, '2023-04-27 00:10:00', 1, '2023-04-27 00:10:00', 1, 34, 51, 'Y', NULL, NULL, 300, 'Любите отдыхать активно?', 148, 'Прокат велосипедов, квадроциклов и вейкбордов – от 500 рублей в сутки!\r\n', 'html', 149, '', 'text', 'ЛЮБИТЕ ОТДЫХАТЬ АКТИВНО?\r\nПРОКАТ ВЕЛОСИПЕДОВ, КВАДРОЦИКЛОВ И ВЕЙКБОРДОВ \r\n– ОТ 500 РУБЛЕЙ В СУТКИ!\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1939', '', '', '-1755717549', NULL, NULL, NULL),
(143, '2023-04-27 00:10:00', 1, '2023-04-27 00:10:00', 1, 34, 51, 'Y', NULL, NULL, 400, 'Уютные мангальные зоны', 150, 'Поможем устроить пикник на двоих или для большой компании. Берём на себя полную организацию и предоставляем всё необходимое для шашлыка и барбекю', 'text', 151, '', 'text', 'УЮТНЫЕ МАНГАЛЬНЫЕ ЗОНЫ\r\nПОМОЖЕМ УСТРОИТЬ ПИКНИК НА ДВОИХ ИЛИ ДЛЯ БОЛЬШОЙ КОМПАНИИ. БЕРЁМ НА СЕБЯ ПОЛНУЮ ОРГАНИЗАЦИЮ И ПРЕДОСТАВЛЯЕМ ВСЁ НЕОБХОДИМОЕ ДЛЯ ШАШЛЫКА И БАРБЕКЮ\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1940', '', '', '-1995844262', NULL, NULL, NULL),
(144, '2023-04-27 00:10:00', 1, '2023-04-27 00:10:00', 1, 34, 52, 'Y', NULL, NULL, 300, 'Любите отдыхать активно?', 152, 'Прокат велосипедов, квадроциклов и вейкбордов – от 500 рублей в сутки!', 'html', NULL, '', 'text', 'ЛЮБИТЕ ОТДЫХАТЬ АКТИВНО?\r\nПРОКАТ ВЕЛОСИПЕДОВ, КВАДРОЦИКЛОВ И ВЕЙКБОРДОВ \r\n– ОТ 500 РУБЛЕЙ В СУТКИ!\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1941', '', '', '-363915848', NULL, NULL, NULL),
(145, '2023-04-27 00:10:00', 1, '2023-04-27 00:10:00', 1, 34, 52, 'Y', NULL, NULL, 400, 'Уютные мангальные зоны', 153, 'Поможем устроить пикник на двоих или для большой компании. Берём на себя полную организацию и предоставляем всё необходимое для шашлыка и барбекю\r\n', 'html', NULL, '', 'text', 'УЮТНЫЕ МАНГАЛЬНЫЕ ЗОНЫ\r\nПОМОЖЕМ УСТРОИТЬ ПИКНИК НА ДВОИХ ИЛИ ДЛЯ \r\nБОЛЬШОЙ КОМПАНИИ. БЕРЁМ НА СЕБЯ ПОЛНУЮ ОРГАНИЗАЦИЮ И ПРЕДОСТАВЛЯЕМ ВСЁ НЕОБХОДИМОЕ ДЛЯ ШАШЛЫКА И БАРБЕКЮ\r\n', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1944', '', '', '-474536650', NULL, NULL, NULL),
(146, '2023-06-29 21:06:56', 1, '2023-04-27 00:10:02', 1, 35, NULL, 'Y', '2020-08-13 12:54:00', NULL, 200, 'Мухаммад Загидов', NULL, 'Лучший курорт на лето если не сюдо то дома\r\n', 'html', NULL, 'Мухаммад, Спасибо за ваш отзыв о нашем курорте! Мы очень рады, что вам понравилось у нас. Мы стремимся создать лучшие условия для отдыха на лето, чтобы каждый гость чувствовал себя комфортно и наслаждался прекрасным времяпрепровождением. ', 'text', 'МУХАММАД ЗАГИДОВ\r\nЛУЧШИЙ КУРОРТ НА ЛЕТО ЕСЛИ НЕ СЮДО ТО ДОМА\r\nМУХАММАД, СПАСИБО ЗА ВАШ ОТЗЫВ О НАШЕМ КУРОРТЕ! МЫ ОЧЕНЬ РАДЫ, ЧТО ВАМ ПОНРАВИЛОСЬ У НАС. МЫ СТРЕМИМСЯ СОЗДАТЬ ЛУЧШИЕ УСЛОВИЯ ДЛЯ ОТДЫХА НА ЛЕТО, ЧТОБЫ КАЖДЫЙ ГОСТЬ ЧУВСТВОВАЛ СЕБЯ КОМФОРТНО И НАСЛАЖДАЛСЯ ПРЕКРАСНЫМ ВРЕМЯПРЕПРОВОЖДЕНИЕМ. ', 1, NULL, NULL, NULL, NULL, NULL, 'N', '155', '', '', '0', NULL, NULL, NULL),
(147, '2023-06-29 21:07:23', 1, '2023-04-27 00:10:02', 1, 35, NULL, 'Y', '2023-06-17 10:52:00', NULL, 300, ' Гузель Тимонина', NULL, 'Безумно красиво ,уютно,чисто ,всё новое…на террасе нас ждал казан , пакет углей и шампура . Красивый и ухоженный пляж -со всем комфортом.Вежливый персонал …нам очень понравилось …вкусная кухня', 'html', NULL, 'Гузель, Благодарим вас за отзыв! Мы очень рады, что вам понравилось у нас. Мы стараемся создавать и поддерживать красивую и уютную атмосферу, а также высокую степень чистоты и комфорта. Благодарим вас за отметку о нашей заботе о гостях.', 'html', ' ГУЗЕЛЬ ТИМОНИНА\r\nБЕЗУМНО КРАСИВО ,УЮТНО,ЧИСТО ,ВСЁ НОВОЕ…НА \r\nТЕРРАСЕ НАС ЖДАЛ КАЗАН , ПАКЕТ УГЛЕЙ И ШАМПУРА . КРАСИВЫЙ И УХОЖЕННЫЙ ПЛЯЖ -СО ВСЕМ КОМФОРТОМ.ВЕЖЛИВЫЙ ПЕРСОНАЛ …НАМ ОЧЕНЬ ПОНРАВИЛОСЬ …ВКУСНАЯ КУХНЯ\r\nГУЗЕЛЬ, БЛАГОДАРИМ ВАС ЗА ОТЗЫВ! МЫ ОЧЕНЬ \r\nРАДЫ, ЧТО ВАМ ПОНРАВИЛОСЬ У НАС. МЫ СТАРАЕМСЯ СОЗДАВАТЬ И ПОДДЕРЖИВАТЬ КРАСИВУЮ И УЮТНУЮ АТМОСФЕРУ, А ТАКЖЕ ВЫСОКУЮ СТЕПЕНЬ ЧИСТОТЫ И КОМФОРТА. БЛАГОДАРИМ ВАС ЗА ОТМЕТКУ О НАШЕЙ ЗАБОТЕ О ГОСТЯХ.', 1, NULL, NULL, NULL, NULL, NULL, 'N', '931', '', '', '0', NULL, 2, '2024-05-10 14:44:21'),
(148, '2023-06-26 14:17:44', 1, '2023-04-27 00:10:02', 1, 35, NULL, 'Y', '2023-06-19 12:51:00', NULL, 400, ' Патимат Абдулатипова', NULL, 'Красивое место! Для отдыха на берегу моря лучшее место не найти!!! Чистый ухоженный берег, вкусная еда. Уютное место для семейного отдыха!!!', 'html', NULL, 'Патимат, Спасибо большое за ваш отзыв! Мы рады, что вам понравилось отдыхать у нас. Мы действительно делаем все возможное, чтобы обеспечить нашим гостям незабываемый отдых, а чистый и ухоженный берег и вкусную еду - это неотъемлемая часть. Радует, что вам понравилась атмосфера и уют созданный нами ради наших гостей. Мы будем рады видеть вас снова и сделаем все возможное, чтобы ваше следующее посещение было еще более приятным!', 'html', ' ПАТИМАТ АБДУЛАТИПОВА\r\nКРАСИВОЕ МЕСТО! ДЛЯ ОТДЫХА НА БЕРЕГУ МОРЯ \r\nЛУЧШЕЕ МЕСТО НЕ НАЙТИ!!! ЧИСТЫЙ УХОЖЕННЫЙ БЕРЕГ, ВКУСНАЯ ЕДА. УЮТНОЕ МЕСТО ДЛЯ СЕМЕЙНОГО ОТДЫХА!!!\r\nПАТИМАТ, СПАСИБО БОЛЬШОЕ ЗА ВАШ ОТЗЫВ! МЫ \r\nРАДЫ, ЧТО ВАМ ПОНРАВИЛОСЬ ОТДЫХАТЬ У НАС. МЫ ДЕЙСТВИТЕЛЬНО ДЕЛАЕМ ВСЕ ВОЗМОЖНОЕ, ЧТОБЫ ОБЕСПЕЧИТЬ НАШИМ ГОСТЯМ НЕЗАБЫВАЕМЫЙ ОТДЫХ, А ЧИСТЫЙ И УХОЖЕННЫЙ БЕРЕГ И ВКУСНУЮ ЕДУ - ЭТО НЕОТЪЕМЛЕМАЯ ЧАСТЬ. РАДУЕТ, ЧТО ВАМ ПОНРАВИЛАСЬ АТМОСФЕРА И УЮТ СОЗДАННЫЙ НАМИ РАДИ НАШИХ ГОСТЕЙ. МЫ БУДЕМ РАДЫ ВИДЕТЬ ВАС СНОВА И СДЕЛАЕМ ВСЕ ВОЗМОЖНОЕ, ЧТОБЫ ВАШЕ СЛЕДУЮЩЕЕ ПОСЕЩЕНИЕ БЫЛО ЕЩЕ БОЛЕЕ ПРИЯТНЫМ!', 1, NULL, NULL, NULL, NULL, NULL, 'N', '932', '', '', '0', NULL, NULL, NULL),
(149, '2023-06-29 21:06:20', 1, '2023-04-27 00:10:02', 1, 35, NULL, 'Y', '2023-06-25 00:00:00', NULL, 100, 'Людмила Курбанкадиева', NULL, 'Красиво, чисто, аккуратно очень добрый отзывчивый администратор зовут её Амина вежливый персонал, ооочень вкусная еда.\r\nСоветую всем кто хочет комфортно отдохнуть', 'html', NULL, '<p>Людмила, благодарим за отзыв!</p>\r\n<p>\r\nРады, что нам удалось сделать ваш отдых впечатляющим. Надеемся еще раз встретиться! </p>', 'html', 'ЛЮДМИЛА КУРБАНКАДИЕВА\r\nКРАСИВО, ЧИСТО, АККУРАТНО ОЧЕНЬ ДОБРЫЙ \r\nОТЗЫВЧИВЫЙ АДМИНИСТРАТОР ЗОВУТ ЕЁ АМИНА ВЕЖЛИВЫЙ ПЕРСОНАЛ, ОООЧЕНЬ ВКУСНАЯ ЕДА. СОВЕТУЮ ВСЕМ КТО ХОЧЕТ КОМФОРТНО ОТДОХНУТЬ\r\nЛЮДМИЛА, БЛАГОДАРИМ ЗА ОТЗЫВ! \r\n\r\nРАДЫ, ЧТО НАМ УДАЛОСЬ СДЕЛАТЬ ВАШ ОТДЫХ \r\nВПЕЧАТЛЯЮЩИМ. НАДЕЕМСЯ ЕЩЕ РАЗ ВСТРЕТИТЬСЯ!', 1, NULL, NULL, NULL, NULL, NULL, 'N', '933', 'elena-shiprova', '', '0', NULL, 4, '2024-04-24 22:47:37'),
(154, '2023-07-08 23:33:13', 1, '2023-04-27 00:10:08', 1, 37, 53, 'Y', NULL, NULL, 500, 'Русский поезд', 168, 'Один из самых известных российских туроператоров.', 'text', 169, '<p>\r\n	 Туроператор «Русский поезд» знает, что нужно туристам в путешествии. Компания занимает лидирующие позиции в туристической отрасли и позиционируется как бренд надежности и качества.\r\n</p>\r\n<p>\r\n	 Миссия туроператора «Русский поезд» заключается в том, чтобы максимально способствовать созданию цивилизованного рынка туризма, чтобы отношения с клиентами основывались на доверии и уважении.\r\n</p>', 'html', 'РУССКИЙ ПОЕЗД\r\nОДИН ИЗ САМЫХ ИЗВЕСТНЫХ РОССИЙСКИХ ТУРОПЕРАТОРОВ.\r\nТУРОПЕРАТОР «РУССКИЙ ПОЕЗД» ЗНАЕТ, ЧТО \r\nНУЖНО ТУРИСТАМ В ПУТЕШЕСТВИИ. КОМПАНИЯ ЗАНИМАЕТ ЛИДИРУЮЩИЕ ПОЗИЦИИ В ТУРИСТИЧЕСКОЙ ОТРАСЛИ И ПОЗИЦИОНИРУЕТСЯ КАК БРЕНД НАДЕЖНОСТИ И КАЧЕСТВА. \r\n\r\nМИССИЯ ТУРОПЕРАТОРА «РУССКИЙ ПОЕЗД» ЗАКЛЮЧАЕТСЯ \r\nВ ТОМ, ЧТОБЫ МАКСИМАЛЬНО СПОСОБСТВОВАТЬ СОЗДАНИЮ ЦИВИЛИЗОВАННОГО РЫНКА ТУРИЗМА, ЧТОБЫ ОТНОШЕНИЯ С КЛИЕНТАМИ ОСНОВЫВАЛИСЬ НА ДОВЕРИИ И УВАЖЕНИИ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '27', 'russian-train', '', '0', NULL, 104, '2023-06-13 17:11:50'),
(155, '2023-07-08 23:32:59', 1, '2023-04-27 00:10:08', 1, 37, 53, 'Y', NULL, NULL, 500, 'RestTour', 170, 'RestTour — главный туроператор Приволжского федерального округа. Компания предоставляет все, что нужно для комфортного и уютного отдыха.', 'html', NULL, '<p>\r\n	 Туроператор RestTour всегда анализирует потребности отдыхающих и организует самые интересные программы. Подготавливает все информационные материалы о туристских продуктах.\r\n</p>\r\n<p>\r\n	 Программы RestTour привлекают своей разноплановостью и демократичностью цен. Наша база отдыха сотрудничает с компанией уже 8 лет. Всем рекомендуем Puck Tour.\r\n</p>', 'html', 'RESTTOUR\r\nRESTTOUR — ГЛАВНЫЙ ТУРОПЕРАТОР ПРИВОЛЖСКОГО \r\nФЕДЕРАЛЬНОГО ОКРУГА. КОМПАНИЯ ПРЕДОСТАВЛЯЕТ ВСЕ, ЧТО НУЖНО ДЛЯ КОМФОРТНОГО И УЮТНОГО ОТДЫХА.\r\nТУРОПЕРАТОР RESTTOUR ВСЕГДА АНАЛИЗИРУЕТ ПОТРЕБНОСТИ \r\nОТДЫХАЮЩИХ И ОРГАНИЗУЕТ САМЫЕ ИНТЕРЕСНЫЕ ПРОГРАММЫ. ПОДГОТАВЛИВАЕТ ВСЕ ИНФОРМАЦИОННЫЕ МАТЕРИАЛЫ О ТУРИСТСКИХ ПРОДУКТАХ. \r\n\r\nПРОГРАММЫ RESTTOUR ПРИВЛЕКАЮТ СВОЕЙ РАЗНОПЛАНОВОСТЬЮ \r\nИ ДЕМОКРАТИЧНОСТЬЮ ЦЕН. НАША БАЗА ОТДЫХА СОТРУДНИЧАЕТ С КОМПАНИЕЙ УЖЕ 8 ЛЕТ. ВСЕМ РЕКОМЕНДУЕМ PUCK TOUR.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '1907', 'rest-tour', '', '0', NULL, 208, '2023-06-20 08:45:50'),
(156, '2023-07-08 23:33:27', 1, '2023-04-27 00:10:08', 1, 37, 53, 'Y', NULL, NULL, 600, 'Tour Sun Management', 172, '<p>\r\n	 Национальный туроператор для комфортного отдыха в России и Беларуси.\r\n</p>', 'html', NULL, '<p>\r\n	 Бренд TSM известен россиянам уже более 25 лет. Это одна из первых компаний, которая внедрила собственную систему онлайн-бронирования на сайте.\r\n</p>\r\n<p>\r\n	 Специалисты TSM тщательно изучают рынок и прогнозируют дальнейшие направления развития спроса на туризм. Компания с каждым кварталом организует все большее количество туров по интересным местам России и Беларуси.\r\n</p>', 'html', 'TOUR SUN MANAGEMENT\r\nНАЦИОНАЛЬНЫЙ ТУРОПЕРАТОР ДЛЯ КОМФОРТНОГО \r\nОТДЫХА В РОССИИ И БЕЛАРУСИ.\r\nБРЕНД TSM ИЗВЕСТЕН РОССИЯНАМ УЖЕ БОЛЕЕ 25 \r\nЛЕТ. ЭТО ОДНА ИЗ ПЕРВЫХ КОМПАНИЙ, КОТОРАЯ ВНЕДРИЛА СОБСТВЕННУЮ СИСТЕМУ ОНЛАЙН-БРОНИРОВАНИЯ НА САЙТЕ. \r\n\r\nСПЕЦИАЛИСТЫ TSM ТЩАТЕЛЬНО ИЗУЧАЮТ РЫНОК \r\nИ ПРОГНОЗИРУЮТ ДАЛЬНЕЙШИЕ НАПРАВЛЕНИЯ РАЗВИТИЯ СПРОСА НА ТУРИЗМ. КОМПАНИЯ С КАЖДЫМ КВАРТАЛОМ ОРГАНИЗУЕТ ВСЕ БОЛЬШЕЕ КОЛИЧЕСТВО ТУРОВ ПО ИНТЕРЕСНЫМ МЕСТАМ РОССИИ И БЕЛАРУСИ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '572', 'tsm', '', '0', NULL, 97, '2023-07-01 06:09:54'),
(157, '2023-07-08 23:32:09', 1, '2023-04-27 00:10:08', 1, 37, 53, 'N', NULL, NULL, 700, 'Звездная тропа', 173, '<p>\r\n	«Звездная тропа» по праву считается лидером среди компаний, организующих отдых на курортах в странах СНГ.\r\n</p>', 'html', NULL, '<p>\r\n	История компании началась в далеком 1994 году. С тех пор турфирма выросла до представительств в России, Украине, Беларуси, Казахстане и Азербайджане. Список открытых направлений постоянно увеличивается. Поэтому туристы могут отправиться в любую из 60 санаториев в любое время.\r\n</p>', 'html', 'ЗВЕЗДНАЯ ТРОПА\r\n«ЗВЕЗДНАЯ ТРОПА» ПО ПРАВУ СЧИТАЕТСЯ ЛИДЕРОМ \r\nСРЕДИ КОМПАНИЙ, ОРГАНИЗУЮЩИХ ОТДЫХ НА КУРОРТАХ В СТРАНАХ СНГ.\r\nИСТОРИЯ КОМПАНИИ НАЧАЛАСЬ В ДАЛЕКОМ 1994 \r\nГОДУ. С ТЕХ ПОР ТУРФИРМА ВЫРОСЛА ДО ПРЕДСТАВИТЕЛЬСТВ В РОССИИ, УКРАИНЕ, БЕЛАРУСИ, КАЗАХСТАНЕ И АЗЕРБАЙДЖАНЕ. СПИСОК ОТКРЫТЫХ НАПРАВЛЕНИЙ ПОСТОЯННО УВЕЛИЧИВАЕТСЯ. ПОЭТОМУ ТУРИСТЫ МОГУТ ОТПРАВИТЬСЯ В ЛЮБУЮ ИЗ 60 САНАТОРИЕВ В ЛЮБОЕ ВРЕМЯ.', 1, NULL, NULL, NULL, NULL, NULL, 'Y', '573', 'star-road', '', '-362191098', NULL, 1, '2023-07-01 06:09:53'),
(158, '2023-07-08 23:32:09', 1, '2023-04-27 00:10:08', 1, 37, 53, 'N', NULL, NULL, 800, 'O\'Gasauto Group', 174, '<p>\r\n	 Лучший туроператор 2018 года по мнению журнала «Современные достопримечательности».\r\n</p>', 'html', NULL, '<p>\r\n	 O\'Gasauto Group сотрудничает с крупными перевозчиками и надежными страховыми компаниями. Благодаря внимательному подходу туроператора клиенты могут не беспокоиться о безопасности отдыха.\r\n</p>\r\n<p>\r\n	 Компания продолжает открывать для туристов самые необычные направления, маршруты и типы отдыха. Фирма всегда стремится предоставить комфортный и уютный сервис отдыхающим.\r\n</p>', 'html', 'O\'GASAUTO GROUP\r\nЛУЧШИЙ ТУРОПЕРАТОР 2018 ГОДА ПО МНЕНИЮ ЖУРНАЛА \r\n«СОВРЕМЕННЫЕ ДОСТОПРИМЕЧАТЕЛЬНОСТИ».\r\nO\'GASAUTO GROUP СОТРУДНИЧАЕТ 