(function(){"use strict";BX.namespace("BX.Grid");BX.Grid.ColsSortable=function(t){this.parent=null;this.dragItem=null;this.targetItem=null;this.rowsList=null;this.colsList=null;this.dragRect=null;this.offset=null;this.startDragOffset=null;this.dragColumn=null;this.targetColumn=null;this.isDrag=null;this.init(t)};BX.Grid.ColsSortable.prototype={init:function(t){this.parent=t;this.colsList=this.getColsList();this.rowsList=this.getRowsList();if(!this.inited){this.inited=true;BX.addCustomEvent("Grid::updated",BX.proxy(this.reinit,this));BX.addCustomEvent("Grid::headerUpdated",BX.proxy(this.reinit,this))}this.registerObjects()},destroy:function(){BX.removeCustomEvent("Grid::updated",BX.proxy(this.reinit,this));this.unregisterObjects()},reinit:function(){this.unregisterObjects();this.reset();this.init(this.parent)},reset:function(){this.dragItem=null;this.targetItem=null;this.rowsList=null;this.colsList=null;this.dragRect=null;this.offset=null;this.startDragOffset=null;this.dragColumn=null;this.targetColumn=null;this.isDrag=null;this.fixedTableColsList=null},isActive:function(){return this.isDrag},registerObjects:function(){this.unregisterObjects();this.getColsList().forEach(this.register,this);this.getFixedHeaderColsList().forEach(this.register,this)},unregisterObjects:function(){this.getColsList().forEach(this.unregister,this);this.getFixedHeaderColsList().forEach(this.unregister,this)},unregister:function(t){jsDD.unregisterObject(t)},register:function(t){t.onbxdragstart=BX.proxy(this._onDragStart,this);t.onbxdrag=BX.proxy(this._onDrag,this);t.onbxdragstop=BX.proxy(this._onDragEnd,this);jsDD.registerObject(t)},getColsList:function(){if(!this.colsList){this.colsList=BX.Grid.Utils.getByTag(this.parent.getRows().getHeadFirstChild().getNode(),"th");this.colsList=this.colsList.filter(function(t){return!this.isStatic(t)},this)}return this.colsList},getFixedHeaderColsList:function(){if(!this.fixedTableColsList&&this.parent.getParam("ALLOW_PIN_HEADER")){this.fixedTableColsList=BX.Grid.Utils.getByTag(this.parent.getPinHeader().getFixedTable(),"th");this.fixedTableColsList=this.fixedTableColsList.filter(function(t){return!this.isStatic(t)},this)}return this.fixedTableColsList||[]},getRowsList:function(){var t=this.parent.getRows().getSourceRows();if(this.parent.getParam("ALLOW_PIN_HEADER")){t=t.concat(BX.Grid.Utils.getByTag(this.parent.getPinHeader().getFixedTable(),"tr"))}return t},isStatic:function(t){return BX.hasClass(t,this.parent.settings.get("classCellStatic"))&&!BX.hasClass(t,"main-grid-fixed-column")},getDragOffset:function(){var t=this.parent.getScrollContainer().scrollLeft-this.startScrollOffset;return jsDD.x-this.startDragOffset-this.dragRect.left+t},getColumn:function(t){var i=[];if(t instanceof HTMLTableCellElement){i=this.rowsList.map(function(i){return i.cells[t.cellIndex]})}return i},_onDragStart:function(){if(this.parent.getParam("ALLOW_PIN_HEADER")&&this.parent.getPinHeader().isPinned()){this.colsList=this.getFixedHeaderColsList()}else{this.colsList=this.getColsList()}this.startScrollOffset=this.parent.getScrollContainer().scrollLeft;this.isDrag=true;this.dragItem=jsDD.current_node;this.dragRect=this.dragItem.getBoundingClientRect();this.offset=Math.ceil(this.dragRect.width);this.startDragOffset=jsDD.start_x-this.dragRect.left;this.dragColumn=this.getColumn(this.dragItem);this.dragIndex=BX.Grid.Utils.getIndex(this.colsList,this.dragItem);this.parent.preventSortableClick=true},isDragToRight:function(t,i){var s=t.getBoundingClientRect();var e=Math.ceil(s.left+s.width/2+BX.scrollLeft(window));var r=this.dragIndex;var n=jsDD.x;return i>r&&n>e},isDragToLeft:function(t,i){var s=t.getBoundingClientRect();var e=Math.ceil(s.left+s.width/2+BX.scrollLeft(window));var r=this.dragIndex;var n=jsDD.x;return i<r&&n<e},isDragToBack:function(t,i){var s=t.getBoundingClientRect();var e=Math.ceil(s.left+s.width/2+BX.scrollLeft(window));var r=this.dragIndex;var n=jsDD.x;return i>r&&n<e||i<r&&n>e},isMovedToRight:function(t){return t.style.transform==="translate3d("+-this.offset+"px, 0px, 0px)"},isMovedToLeft:function(t){return t.style.transform==="translate3d("+this.offset+"px, 0px, 0px)"},isMoved:function(t){return t.style.transform!=="translate3d(0px, 0px, 0px)"&&t.style.transform!==""},moveColumn:function(t,i,s){s=BX.type.isNumber(s)?s:300;BX.Grid.Utils.styleForEach(t,{transition:s+"ms",transform:"translate3d("+i+"px, 0px, 0px)"})},_onDrag:function(){this.dragOffset=this.getDragOffset();this.targetItem=this.targetItem||this.dragItem;this.targetColumn=this.targetColumn||this.dragColumn;var t=-this.offset;var i=this.offset;var s=0;var e=0;this.moveColumn(this.dragColumn,this.dragOffset,e);[].forEach.call(this.colsList,function(e,r){if(e&&!e.classList.contains("main-grid-cell-static")){if(this.isDragToRight(e,r)&&!this.isMovedToRight(e)){this.targetColumn=this.getColumn(e);this.moveColumn(this.targetColumn,t)}if(this.isDragToLeft(e,r)&&!this.isMovedToLeft(e)){this.targetColumn=this.getColumn(e);this.moveColumn(this.targetColumn,i)}if(this.isDragToBack(e,r)&&this.isMoved(e)){this.targetColumn=this.getColumn(e);this.moveColumn(this.targetColumn,s)}}},this)},_onDragEnd:function(){[].forEach.call(this.dragColumn,function(t,i){BX.Grid.Utils.collectionSort(t,this.targetColumn[i])},this);this.rowsList.forEach(function(t){BX.Grid.Utils.styleForEach(t.cells,{transition:"",transform:""})});this.reinit();var t=this.colsList.map(function(t){return BX.data(t,"name")});this.parent.getUserOptions().setColumns(t);BX.onCustomEvent(this.parent.getContainer(),"Grid::columnMoved",[this.parent]);setTimeout(function(){this.parent.preventSortableClick=false}.bind(this),10)}}})();