(function(){"use strict";BX.namespace("BX.Grid");BX.Grid.Row=function(t,e){this.node=null;this.checkbox=null;this.sort=null;this.actions=null;this.settings=null;this.index=null;this.actionsButton=null;this.parent=null;this.depth=null;this.parentId=null;this.editData=null;this.custom=null;this.init(t,e)};BX.Grid.Row.prototype={init:function(t,e){if(BX.type.isDomNode(e)){this.node=e;this.parent=t;this.settings=new BX.Grid.Settings;this.bindNodes=[];if(this.isBodyChild()){this.bindNodes=[].slice.call(this.node.parentNode.querySelectorAll('tr[data-bind="'+this.getId()+'"]'));if(this.bindNodes.length){this.node.addEventListener("mouseover",this.onMouseOver.bind(this));this.node.addEventListener("mouseleave",this.onMouseLeave.bind(this));this.bindNodes.forEach(function(t){t.addEventListener("mouseover",this.onMouseOver.bind(this));t.addEventListener("mouseleave",this.onMouseLeave.bind(this));t.addEventListener("click",function(){if(this.isSelected()){this.unselect()}else{this.select()}}.bind(this))},this)}}if(this.parent.getParam("ALLOW_CONTEXT_MENU")){BX.bind(this.getNode(),"contextmenu",BX.delegate(this._onRightClick,this))}}},onMouseOver:function(){this.node.classList.add("main-grid-row-over");this.bindNodes.forEach(function(t){t.classList.add("main-grid-row-over")})},onMouseLeave:function(){this.node.classList.remove("main-grid-row-over");this.bindNodes.forEach(function(t){t.classList.remove("main-grid-row-over")})},isCustom:function(){if(this.custom===null){this.custom=BX.hasClass(this.getNode(),this.parent.settings.get("classRowCustom"))}return this.custom},_onRightClick:function(t){t.preventDefault();this.showActionsMenu(t)},getDefaultAction:function(){return BX.data(this.getNode(),"default-action")},editGetValues:function(){var t=this;var e=this.getCells();var i={};var s;[].forEach.call(e,function(e){s=t.getCellEditorValue(e);if(BX.type.isArray(s)){s.forEach(function(t){i[t.NAME]=t.VALUE!==undefined?t.VALUE:"";if(t.hasOwnProperty("RAW_NAME")&&t.hasOwnProperty("RAW_VALUE")){i[t.NAME+"_custom"]=i[t.NAME+"_custom"]||{};i[t.NAME+"_custom"][t.RAW_NAME]=i[t.NAME+"_custom"][t.RAW_NAME]||t.RAW_VALUE}})}else if(s){i[s.NAME]=s.VALUE!==undefined?s.VALUE:""}});return i},getCellEditorValue:function(t){var e=BX.Grid.Utils.getByClass(t,this.parent.settings.get("classEditor"),true);var i=null;if(BX.type.isDomNode(e)){if(BX.hasClass(e,"main-grid-editor-checkbox")){i={NAME:e.getAttribute("name"),VALUE:e.checked?"Y":"N"}}else if(BX.hasClass(e,"main-grid-editor-custom")){i=this.getCustomValue(e)}else{i=this.getImageValue(e)}}return i},isEdit:function(){return BX.hasClass(this.getNode(),"main-grid-row-edit")},hide:function(){BX.addClass(this.getNode(),this.parent.settings.get("classHide"))},show:function(){BX.removeClass(this.getNode(),this.parent.settings.get("classHide"))},isShown:function(){return!BX.hasClass(this.getNode(),this.parent.settings.get("classHide"))},isNotCount:function(){return BX.hasClass(this.getNode(),this.parent.settings.get("classNotCount"))},getContentContainer:function(t){var e=null;if(!BX.hasClass(t,this.parent.settings.get("classCellContainer"))){if(t.nodeName==="TD"||t.nodeName==="TR"){e=BX.Grid.Utils.getByClass(t,this.parent.settings.get("classCellContainer"),true)}else{e=BX.findParent(t,{className:this.parent.settings.get("classCellContainer")},true,false)}}else{e=t}return e},getContent:function(t){var e=this.getContentContainer(t);var i;if(BX.type.isDomNode(e)){i=BX.html(e)}return i},getCustomValue:function(t){var e=new Map,i=t.getAttribute("data-name");var s=[].slice.call(t.querySelectorAll("input, select, checkbox, textarea"));s.forEach(function(t){var s={NAME:i,RAW_NAME:t.name,RAW_VALUE:t.value,VALUE:t.value};switch(t.tagName){case"SELECT":if(t.multiple){var n=[];t.querySelectorAll("option").forEach(function(t){if(t.selected){n.push(t.value)}});s["RAW_VALUE"]=n;s["VALUE"]=n;e.set(t.name,s)}else{e.set(t.name,s)}break;case"INPUT":switch(t.type.toUpperCase()){case"RADIO":if(t.checked){s["RAW_VALUE"]=t.value;s["VALUE"]=t.value;e.set(t.name,s)}break;case"CHECKBOX":s["RAW_VALUE"]=t.checked?t.value:"";s["VALUE"]=t.checked?t.value:"";e.set(t.name,s);break;case"FILE":s["RAW_VALUE"]=t.files[0];s["VALUE"]=t.files[0];e.set(t.name,s);break;default:e.set(t.name,s)}break;default:e.set(t.name,s)}});var n=[];e.forEach(function(t){n.push(t)});return n},getImageValue:function(t){var e=null;if(BX.hasClass(t,"main-grid-image-editor")){var i=t.querySelector(".main-grid-image-editor-file-input");if(i){e={NAME:i.name,VALUE:i.files[0]}}else{var s=t.querySelector(".main-grid-image-editor-fake-file-input");if(s){e={NAME:s.name,VALUE:s.value}}}}else if(t.value){e={NAME:t.getAttribute("name"),VALUE:t.value}}else{e={NAME:t.getAttribute("name"),VALUE:BX.data(t,"value")}}return e},getEditorContainer:function(t){return BX.Grid.Utils.getByClass(t,this.parent.settings.get("classEditorContainer"),true)},getCollapseButton:function(){if(!this.collapseButton){this.collapseButton=BX.Grid.Utils.getByClass(this.getNode(),this.parent.settings.get("classCollapseButton"),true)}return this.collapseButton},stateLoad:function(){BX.addClass(this.getNode(),this.parent.settings.get("classRowStateLoad"))},stateUnload:function(){BX.removeClass(this.getNode(),this.parent.settings.get("classRowStateLoad"))},stateExpand:function(){BX.addClass(this.getNode(),this.parent.settings.get("classRowStateExpand"))},stateCollapse:function(){BX.removeClass(this.getNode(),this.parent.settings.get("classRowStateExpand"))},getParentId:function(){if(this.parentId===null){this.parentId=BX.data(this.getNode(),"parent-id");if(typeof this.parentId!=="undefined"&&this.parentId!==null){this.parentId=this.parentId.toString()}}return this.parentId},getDataset:function(){return this.getNode().dataset},getDepth:function(){if(this.depth===null){this.depth=BX.data(this.getNode(),"depth")}return this.depth},setDepth:function(t){t=parseInt(t);if(BX.type.isNumber(t)){var e=t-parseInt(this.getDepth());var i=this.parent.getRows();this.getDataset().depth=t;this.getShiftCells().forEach(function(e){BX.data(e,"depth",t);BX.style(e,"padding-left",t*20+"px")},this);i.getRowsByParentId(this.getId(),true).forEach(function(t){var i=parseInt(e)+parseInt(t.getDepth());t.getDataset().depth=i;t.getShiftCells().forEach(function(t){BX.data(t,"depth",i);BX.style(t,"padding-left",i*20+"px")})})}},setParentId:function(t){this.getDataset()["parentId"]=t},getShiftCells:function(){return BX.Grid.Utils.getBySelector(this.getNode(),'td[data-shift="true"]')},showChildRows:function(){var t=this.getChildren();var e=this.isCustom();t.forEach(function(t){t.show();if(!e&&t.isExpand()){t.showChildRows()}});this.parent.updateCounterDisplayed();this.parent.updateCounterSelected();this.parent.adjustCheckAllCheckboxes();this.parent.adjustRows()},getChildren:function(){var t=this.isCustom()?"getRowsByGroupId":"getRowsByParentId";var e=this.isCustom()?this.getGroupId():this.getId();return this.parent.getRows()[t](e,true)},hideChildRows:function(){var t=this.getChildren();t.forEach(function(t){t.hide()});this.parent.updateCounterDisplayed();this.parent.updateCounterSelected();this.parent.adjustCheckAllCheckboxes();this.parent.adjustRows()},isChildsLoaded:function(){if(!BX.type.isBoolean(this.childsLoaded)){this.childsLoaded=this.isCustom()||BX.data(this.getNode(),"child-loaded")==="true"}return this.childsLoaded},expand:function(){var t=this;this.stateExpand();if(this.isChildsLoaded()){this.showChildRows()}else{this.stateLoad();this.loadChildRows(function(e){e.reverse().forEach(function(e){BX.insertAfter(e,t.getNode())});t.parent.getRows().reset();t.parent.bindOnRowEvents();if(t.parent.getParam("ALLOW_ROWS_SORT")){t.parent.getRowsSortable().reinit()}if(t.parent.getParam("ALLOW_COLUMNS_SORT")){t.parent.getColsSortable().reinit()}t.stateUnload();BX.data(t.getNode(),"child-loaded","true");t.parent.updateCounterDisplayed();t.parent.updateCounterSelected();t.parent.adjustCheckAllCheckboxes()})}},collapse:function(){this.stateCollapse();this.hideChildRows()},isExpand:function(){return BX.hasClass(this.getNode(),this.parent.settings.get("classRowStateExpand"))},toggleChildRows:function(){if(!this.isExpand()){this.expand()}else{this.collapse()}},loadChildRows:function(t){if(BX.type.isFunction(t)){var e=this;var i=parseInt(this.getDepth());var s=this.parent.getUserOptions().getAction("GRID_GET_CHILD_ROWS");i=BX.type.isNumber(i)?i+1:1;this.parent.getData().request("","POST",{action:s,parent_id:this.getId(),depth:i},null,function(){var i=this.getRowsByParentId(e.getId());t.apply(null,[i])})}},update:function(t,e,i){t=!!t?t:"";var s=this.parent.getUserOptions().getAction("GRID_UPDATE_ROW");var n=this.getDepth();var a=this.getId();var o=this.getParentId();var r={id:a,parentId:o,action:s,depth:n,data:t};var d=this;this.stateLoad();this.parent.getData().request(e,"POST",r,null,function(){var e=this.getBodyRows();d.parent.getUpdater().updateBodyRows(e);d.stateUnload();d.parent.getRows().reset();d.parent.getUpdater().updateFootRows(this.getFootRows());d.parent.getUpdater().updatePagination(this.getPagination());d.parent.getUpdater().updateMoreButton(this.getMoreButton());d.parent.getUpdater().updateCounterTotal(this.getCounterTotal());d.parent.bindOnRowEvents();d.parent.adjustEmptyTable(e);d.parent.bindOnMoreButtonEvents();d.parent.bindOnClickPaginationLinks();d.parent.updateCounterDisplayed();d.parent.updateCounterSelected();if(d.parent.getParam("ALLOW_COLUMNS_SORT")){d.parent.colsSortable.reinit()}if(d.parent.getParam("ALLOW_ROWS_SORT")){d.parent.rowsSortable.reinit()}BX.onCustomEvent(window,"Grid::rowUpdated",[{id:a,data:t,grid:d.parent,response:this}]);BX.onCustomEvent(window,"Grid::updated",[d.parent]);if(BX.type.isFunction(i)){i({id:a,data:t,grid:d.parent,response:this})}})},remove:function(t,e,i){t=!!t?t:"";var s=this.parent.getUserOptions().getAction("GRID_DELETE_ROW");var n=this.getDepth();var a=this.getId();var o=this.getParentId();var r={id:a,parentId:o,action:s,depth:n,data:t};var d=this;this.stateLoad();this.parent.getData().request(e,"POST",r,null,function(){var e=this.getBodyRows();d.parent.getUpdater().updateBodyRows(e);d.stateUnload();d.parent.getRows().reset();d.parent.getUpdater().updateFootRows(this.getFootRows());d.parent.getUpdater().updatePagination(this.getPagination());d.parent.getUpdater().updateMoreButton(this.getMoreButton());d.parent.getUpdater().updateCounterTotal(this.getCounterTotal());d.parent.bindOnRowEvents();d.parent.adjustEmptyTable(e);d.parent.bindOnMoreButtonEvents();d.parent.bindOnClickPaginationLinks();d.parent.updateCounterDisplayed();d.parent.updateCounterSelected();if(d.parent.getParam("ALLOW_COLUMNS_SORT")){d.parent.colsSortable.reinit()}if(d.parent.getParam("ALLOW_ROWS_SORT")){d.parent.rowsSortable.reinit()}BX.onCustomEvent(window,"Grid::rowRemoved",[{id:a,data:t,grid:d.parent,response:this}]);BX.onCustomEvent(window,"Grid::updated",[d.parent]);if(BX.type.isFunction(i)){i({id:a,data:t,grid:d.parent,response:this})}})},editCancel:function(){var t=this.getCells();var e=this;var i;[].forEach.call(t,function(t){i=e.getEditorContainer(t);if(BX.type.isDomNode(i)){BX.remove(e.getEditorContainer(t));BX.show(e.getContentContainer(t))}});BX.removeClass(this.getNode(),"main-grid-row-edit")},getCellByIndex:function(t){return this.getCells()[t]},getEditDataByCellIndex:function(index){return eval(BX.data(this.getCellByIndex(index),"edit"))},getCellNameByCellIndex:function(t){return BX.data(this.getCellByIndex(t),"name")},getEditData:function(){if(this.editData===null){var t=this.parent.getParam("EDITABLE_DATA");var e=this.getId();if(BX.type.isPlainObject(t)&&e in t){this.editData=t[e]}else{this.editData={}}}return this.editData},getCellEditDataByCellIndex:function(t){var e=this.getEditData();var i=null;t=parseInt(t);if(BX.type.isNumber(t)&&BX.type.isPlainObject(e)){var s=this.parent.getRows().getHeadFirstChild().getEditDataByCellIndex(t);if(BX.type.isPlainObject(s)){i=s;i.VALUE=e[s.NAME]}}return i},edit:function(){var t=this.getCells();var e=this;var i,s,n,a;[].forEach.call(t,function(t,o){if(t.dataset.editable==="true"){try{i=e.getCellEditDataByCellIndex(o)}catch(t){throw new Error(t)}if(e.parent.getEditor().validateEditObject(i)){a=e.getContentContainer(t);n=BX.height(a);s=e.parent.getEditor().getEditor(i,n);if(!e.getEditorContainer(t)&&BX.type.isDomNode(s)){t.appendChild(s);BX.hide(a)}}}});BX.addClass(this.getNode(),"main-grid-row-edit")},setDraggable:function(t){if(!t){BX.addClass(this.getNode(),this.parent.settings.get("classDisableDrag"));this.parent.getRowsSortable().unregister(this.getNode())}else{BX.removeClass(this.getNode(),this.parent.settings.get("classDisableDrag"));this.parent.getRowsSortable().register(this.getNode())}},isDraggable:function(){return!BX.hasClass(this.getNode(),this.parent.settings.get("classDisableDrag"))},getNode:function(){return this.node},getIndex:function(){return this.getNode().rowIndex},getId:function(){return BX.data(this.getNode(),"id").toString()},getGroupId:function(){return BX.data(this.getNode(),"group-id").toString()},getObserver:function(){return BX.Grid.observer},getCheckbox:function(){if(!this.checkbox){this.checkbox=BX.Grid.Utils.getByClass(this.getNode(),this.settings.get("classRowCheckbox"),true)}return this.checkbox},getActionsMenu:function(){if(!this.actionsMenu){var t=this.getActionsButton().getBoundingClientRect();this.actionsMenu=BX.PopupMenu.create("main-grid-actions-menu-"+this.getId(),this.getActionsButton(),this.getMenuItems(),{autoHide:true,offsetTop:-(t.height/2+26),offsetLeft:30,angle:{position:"left",offset:t.height/2-8},events:{onPopupClose:BX.delegate(this._onCloseMenu,this),onPopupShow:BX.delegate(this._onPopupShow,this)}});BX.addCustomEvent("Grid::updated",function(){if(this.actionsMenu){this.actionsMenu.destroy();this.actionsMenu=null}}.bind(this));BX.bind(this.actionsMenu.popupWindow.popupContainer,"click",BX.delegate(function(t){var e=this.getActionsMenu();if(e){var i=BX.getEventTarget(t);var s=BX.findParent(i,{className:"menu-popup-item"},10);if(!s||!s.dataset.preventCloseContextMenu){e.close()}}},this))}return this.actionsMenu},_onCloseMenu:function(){},_onPopupShow:function(t){t.setBindElement(this.getActionsButton())},actionsMenuIsShown:function(){return this.getActionsMenu().popupWindow.isShown()},showActionsMenu:function(t){BX.fireEvent(document.body,"click");this.getActionsMenu().popupWindow.show();if(t){this.getActionsMenu().popupWindow.popupContainer.style.top=t.pageY-25+BX.PopupWindow.getOption("offsetTop")+"px";this.getActionsMenu().popupWindow.popupContainer.style.left=t.pageX+20+BX.PopupWindow.getOption("offsetLeft")+"px"}else{var e=BX.pos(this.getActionsButton());e.forceBindPosition=true;this.getActionsMenu().popupWindow.adjustPosition(e)}},closeActionsMenu:function(){if(this.actionsMenu){if(this.actionsMenu.popupWindow){this.actionsMenu.popupWindow.close()}}},getMenuItems:function(){return this.getActions()||[]},getActions:function(){try{this.actions=this.actions||eval(BX.data(this.getActionsButton(),this.settings.get("dataActionsKey")))}catch(t){this.actions=null}return this.actions},getActionsButton:function(){if(!this.actionsButton){this.actionsButton=BX.Grid.Utils.getByClass(this.getNode(),this.settings.get("classRowActionButton"),true)}return this.actionsButton},initSelect:function(){if(this.isSelected()&&!BX.hasClass(this.getNode(),this.settings.get("classCheckedRow"))){BX.addClass(this.getNode(),this.settings.get("classCheckedRow"))}},getParentNode:function(){var t;try{t=this.getNode().parentNode}catch(e){t=null}return t},getParentNodeName:function(){var t;try{t=this.getParentNode().nodeName}catch(e){t=null}return t},select:function(){var t;if(!this.isEdit()&&!this.parent.getRows().hasEditable()){t=this.getCheckbox();if(t){if(!BX.data(t,"disabled")){BX.addClass(this.getNode(),this.settings.get("classCheckedRow"));this.bindNodes.forEach(function(t){BX.addClass(t,this.settings.get("classCheckedRow"))},this);t.checked=true}}}},unselect:function(){if(!this.isEdit()){BX.removeClass(this.getNode(),this.settings.get("classCheckedRow"));this.bindNodes.forEach(function(t){BX.removeClass(t,this.settings.get("classCheckedRow"))},this);if(this.getCheckbox()){this.getCheckbox().checked=false}}},getCells:function(){return this.getNode().cells},isSelected:function(){return this.getCheckbox()&&this.getCheckbox().checked||BX.hasClass(this.getNode(),this.settings.get("classCheckedRow"))},isHeadChild:function(){return this.getParentNodeName()==="THEAD"&&BX.hasClass(this.getNode(),this.settings.get("classHeadRow"))},isBodyChild:function(){return BX.hasClass(this.getNode(),this.settings.get("classBodyRow"))&&!BX.hasClass(this.getNode(),this.settings.get("classEmptyRows"))},isFootChild:function(){return this.getParentNodeName()==="TFOOT"&&BX.hasClass(this.getNode(),this.settings.get("classFootRow"))}}})();
//# sourceMappingURL=row.map.js