(function(){"use strict";BX.namespace("BX.Fileman.Map");var e={};BX.Fileman.Map.AddressSearch=function(t,s){e[t]=this;this.node=s.node;this.tplRoles={INPUT:"search-input"};this.parts={INPUT:[]};this.searchInput=[];this.resultDisplay=[];this.map=s.map;this.map.setEditMode(false);BX.ready(BX.delegate(this.init,this))};BX.Fileman.Map.AddressSearch.get=function(t){return e[t]};BX.Fileman.Map.AddressSearch.prototype.init=function(){var e;for(e in this.tplRoles){if(this.tplRoles.hasOwnProperty(e)){var t=BX.findChild(this.node,{attribute:{"data-role":this.tplRoles[e]}},true);if(BX.type.isArray(this.parts[e])){this.parts[e].push(t)}else{this.parts[e]=t}}}for(e=0;e<this.parts.INPUT.length;e++){this.searchInput[e]=new BX.Fileman.Map.AddressSearchInput(this,this.parts.INPUT[e],e)}};BX.Fileman.Map.AddressSearch.prototype.setGeoCoder=function(e){this.geoCoder=e};BX.Fileman.Map.AddressSearch.prototype.getGeoCoder=function(){if(this.geoCoder===null){this.setGeoCoder(new BX.Fileman.Map.GoogleGeoCoder)}return this.geoCoder};BX.Fileman.Map.AddressSearch.prototype.setResultDisplay=function(e,t){this.resultDisplay[e]=t};BX.Fileman.Map.AddressSearch.prototype.getResultDisplay=function(e){if(typeof this.resultDisplay[e]==="undefined"){this.setResultDisplay(e,new BX.Fileman.Map.AddressSearchResult(this,{bindNode:this.parts.INPUT[e],callback:BX.proxy(this.addResult,this)},e))}return this.resultDisplay[e]};BX.Fileman.Map.AddressSearch.prototype.addResult=function(e,t){BX.onCustomEvent(this,"onAddressSearchResultSelect",[t]);this.parts.INPUT[e].value=t.text};BX.Fileman.Map.AddressSearchInput=function(e,t,s){this.parent=e;this.input=t;this.index=s;var o=BX.debounce(this.onChangeValue,300,this);BX.bind(this.input,"focus",o);BX.bind(this.input,"bxchange",o);BX.unbind(this.input,"blur",o);BX.unbind(this.input,"change",o)};BX.Fileman.Map.AddressSearchInput.prototype.onChangeValue=function(e){this.parent.getGeoCoder().search(this.input.value,BX.proxy(this.searchCallback,this))};BX.Fileman.Map.AddressSearchInput.prototype.searchCallback=function(e){BX.onCustomEvent(this,"onAddressSearchResult",[e]);this.parent.getResultDisplay(this.index).display(e)};BX.Fileman.Map.AddressSearchResult=function(e,t,s){this.parent=e;this.bindNode=t.bindNode;this.callback=t.callback;this.index=s;this.popup=null;this.point=null;BX.bind(document,"click",BX.proxy(this.close,this));this.resultNode=null};BX.Fileman.Map.AddressSearchResult.prototype.display=function(e,t){BX.cleanNode(this.getResultNode());if(e.length>0){this.getResultNode().appendChild(this.createResultRow(e[0]));if(!!this.parent.map&&!t){this.setPoint(e[0].coords)}}else{this.getResultNode().innerHTML="Nothing found!"}this.adjustResultNode()};BX.Fileman.Map.AddressSearchResult.prototype.setPoint=function(e){var t=new google.maps.LatLng(e[0],e[1]);if(this.point===null){this.point=this.parent.map.addPoint(t);BX.addCustomEvent(window,"onGoogleMapPointChanged",BX.proxy(this.pointChangeHandler,this))}else{this.parent.map.movePoint(this.point,t)}this.parent.map.panTo(t)};BX.Fileman.Map.AddressSearchResult.prototype.pointChangeHandler=function(e,t){this.parent.getGeoCoder().search(t,BX.proxy(this.updateResult,this))};BX.Fileman.Map.AddressSearchResult.prototype.updateResult=function(e){this.parent.getResultDisplay(this.index).display(e,true)};BX.Fileman.Map.AddressSearchResult.prototype.close=function(){this.getPopup().close()};BX.Fileman.Map.AddressSearchResult.prototype.adjustResultNode=function(){this.getPopup().show()};BX.Fileman.Map.AddressSearchResult.prototype.createResultRow=function(e){return BX.create("DIV",{text:e.text,style:{cursor:"pointer",borderBottom:"dotted 1px gray",margin:"10px"},events:{click:BX.proxy(this.resultClickHandler(e),this)}})};BX.Fileman.Map.AddressSearchResult.prototype.resultClickHandler=function(e){return function(t){this.callback(this.index,e);this.close();return(t||window.event).preventDefault()}};BX.Fileman.Map.AddressSearchResult.prototype.getResultNode=function(){if(this.resultNode===null){this.resultNode=this.bindNode.parentNode.insertBefore(BX.create("DIV",{}),this.bindNode)}return this.resultNode};BX.Fileman.Map.AddressSearchResult.prototype.getPopup=function(){if(this.popup===null){this.popup=new BX.PopupWindow("google_search_result_"+this.index,this.bindNode,{closeIcon:true,content:this.getResultNode(),angle:{position:"top"}})}return this.popup};BX.Fileman.Map.GoogleGeoCoder=function(){this.geocoder=null};BX.Fileman.Map.GoogleGeoCoder.prototype.search=function(e,t){if(e!==""){if(this.geocoder===null){this.geocoder=new google.maps.Geocoder}var s={language:BX.message("LANGUAGE_ID")};if(e instanceof google.maps.LatLng){s.latLng=e}else{s.address=e}this.geocoder.geocode(s,BX.delegate(this.processResult(t),this))}};BX.Fileman.Map.GoogleGeoCoder.prototype.processResult=function(e){return function(t,s){var o=[];if(s!==google.maps.GeocoderStatus.OK&&s!==google.maps.GeocoderStatus.ZERO_RESULTS){this.throwError(s)}else{for(var i=0;i<t.length;i++){o.push({text:t[i].formatted_address,components:t[i].address_components,coords:[t[i].geometry.location.lat(),t[i].geometry.location.lng()],viewport:[[t[i].geometry.viewport.getNorthEast().lat(),t[i].geometry.viewport.getNorthEast().lng()],[t[i].geometry.viewport.getSouthWest().lat(),t[i].geometry.viewport.getSouthWest().lng()]]})}}e(o)}};BX.Fileman.Map.GoogleGeoCoder.prototype.throwError=function(e){console.error(e?e.message:"Google error!")}})();
//# sourceMappingURL=script.map.js