(function(){"use strict";BX.namespace("BX.UI");BX.UI.ToolbarManager={toolbars:{},create:function(t){var e=new BX.UI.Toolbar(t);if(this.get(e.getId())){throw new Error("The toolbar instance with the same 'id' already exists.")}this.toolbars[e.getId()]=e;return e},getDefaultToolbar:function(){return this.get("default-toolbar")},get:function(t){return t in this.toolbars?this.toolbars[t]:null}};BX.UI.Toolbar=function(t){t=BX.type.isPlainObject(t)?t:{};this.titleMinWidth=BX.type.isNumber(t.titleMinWidth)?t.titleMinWidth:158;this.titleMaxWidth=BX.type.isNumber(t.titleMaxWidth)?t.titleMaxWidth:"";this.filterMinWidth=BX.type.isNumber(t.filterMinWidth)?t.filterMinWidth:300;this.filterMaxWidth=BX.type.isNumber(t.filterMaxWidth)?t.filterMaxWidth:748;this.id=BX.Type.isStringFilled(t.id)?t.id:BX.Text.getRandom();this.toolbarContainer=t.target;if(!BX.Type.isDomNode(this.toolbarContainer)){throw new Error('BX.UI.Toolbar: "target" parameter is required.')}this.titleContainer=this.toolbarContainer.querySelector(".ui-toolbar-title-box");this.filterContainer=this.toolbarContainer.querySelector(".ui-toolbar-filter-box");this.filterButtons=this.toolbarContainer.querySelector(".ui-toolbar-filter-buttons");this.rightButtons=this.toolbarContainer.querySelector(".ui-toolbar-right-buttons");this.afterTitleButtons=this.toolbarContainer.querySelector(".ui-toolbar-after-title-buttons");if(!this.filterContainer){this.filterMinWidth=0;this.filterMaxWidth=0}this.buttons=Object.create(null);this.buttonIds=BX.Type.isArray(t.buttonIds)?t.buttonIds:[];if(!this.buttonIds.length){return}this.buttonIds.forEach((function(t){var e=BX.UI.ButtonManager.createByUniqId(t);if(e){e.getContainer().originalWidth=e.getContainer().offsetWidth;if(!e.getIcon()&&!BX.Type.isStringFilled(e.getDataSet()["toolbarCollapsedIcon"])){if(e.getColor()===BX.UI.ButtonColor.PRIMARY){e.setDataSet({toolbarCollapsedIcon:BX.UI.ButtonIcon.ADD})}else{console.warn('BX.UI.Toolbar: the button "'+e.getText()+'" '+"doesn't have an icon for collapsed mode. "+'Use the "data-toolbar-collapsed-icon" attribute.')}}this.buttons[t]=e}else{console.warn('BX.UI.Toolbar: the button "'+t+"\" wasn't initialized.")}}),this);this.windowWidth=document.body.offsetWidth;this.reduceItemsWidth();window.addEventListener("resize",function(){if(this.isWindowIncreased()){this.increaseItemsWidth()}else{this.reduceItemsWidth()}}.bind(this))};BX.UI.Toolbar.prototype={getButtons:function(){return this.buttons},getButton:function(t){return t in this.buttons?this.buttons[t]:null},getId:function(){return this.id},isWindowIncreased:function(){var t=this.windowWidth;var e=document.body.offsetWidth;this.windowWidth=e;return e>t},getContainerSize:function(){return this.toolbarContainer.offsetWidth},getInnerTotalWidth:function(){return this.toolbarContainer.scrollWidth},reduceItemsWidth:function(){if(this.getInnerTotalWidth()<=this.getContainerSize()){return}var t=Object.values(this.getButtons());for(var e=t.length-1;e>=0;e--){var i=t[e];if(!i.getIcon()&&!BX.Type.isStringFilled(i.getDataSet()["toolbarCollapsedIcon"])){continue}if(i.isCollapsed()){continue}i.setCollapsed(true);if(!i.getIcon()){i.setIcon(i.getDataSet()["toolbarCollapsedIcon"])}if(this.getInnerTotalWidth()<=this.getContainerSize()){return}}},increaseItemsWidth:function(){var t=Object.values(this.getButtons());for(var e=0;e<t.length;e++){var i=t[e];var o=i.getContainer();if(!i.isCollapsed()){continue}var n=this.titleMinWidth+this.filterMinWidth+(this.afterTitleButtons?this.afterTitleButtons.offsetWidth:0)+(this.filterButtons?this.filterButtons.offsetWidth:0)+(this.rightButtons?this.rightButtons.offsetWidth:0)+(o.originalWidth-o.offsetWidth);if(n>this.getContainerSize()){break}i.setCollapsed(false);if(i.getIcon()===i.getDataSet()["toolbarCollapsedIcon"]){const t=BX.Type.isStringFilled(i.options.icon)?i.options.icon:null;i.setIcon(t)}}}};BX.UI.Toolbar.Star=function(){this.initialized=false;this.currentPageInMenu=false;this.starContNode=null;BX.ready(function(){this.init()}.bind(this));BX.addCustomEvent("onFrameDataProcessed",function(){this.init()}.bind(this))};BX.UI.Toolbar.Star.prototype={init:function(){this.starContNode=document.getElementById("uiToolbarStar");if(!this.starContNode){return false}if(this.initialized){return false}this.initialized=true;var t=this.starContNode.getAttribute("data-bx-url");if(!BX.type.isNotEmptyString(t)){t=document.location.pathname+document.location.search}t=BX.Uri.removeParam(t,["IFRAME","IFRAME_TYPE"]);top.BX.addCustomEvent("BX.Bitrix24.LeftMenuClass:onSendMenuItemData",function(t){this.processMenuItemData(t)}.bind(this));top.BX.addCustomEvent("BX.Bitrix24.LeftMenuClass:onStandardItemChangedSuccess",function(t){this.onStandardItemChangedSuccess(t)}.bind(this));top.BX.onCustomEvent("UI.Toolbar:onRequestMenuItemData",[{currentFullPath:t,context:window}]);return true},processMenuItemData:function(t){if(t.context&&t.context!==window){return}this.currentPageInMenu=t.currentPageInMenu;if(BX.type.isNotEmptyObject(t.currentPageInMenu)){BX.addClass(this.starContNode,"ui-toolbar-star-active")}this.starContNode.title=BX.message(this.starContNode.classList.contains("ui-toolbar-star-active")?"UI_TOOLBAR_DELETE_PAGE_FROM_LEFT_MENU":"UI_TOOLBAR_ADD_PAGE_TO_LEFT_MENU");if(BX.type.isDomNode(this.currentPageInMenu)&&this.currentPageInMenu.getAttribute("data-type")!=="standard"){this.starContNode.title=BX.message("UI_TOOLBAR_STAR_TITLE_DEFAULT_PAGE");BX.bind(this.starContNode,"click",function(){this.showMessage(BX.message("UI_TOOLBAR_STAR_TITLE_DEFAULT_PAGE_DELETE_ERROR"))}.bind(this));return true}BX.bind(this.starContNode,"click",function(){var t=document.getElementById("pagetitle").innerText;var e=this.starContNode.getAttribute("data-bx-title-template");if(BX.type.isNotEmptyString(e)){t=e.replace(/#page_title#/i,t)}var i=this.starContNode.getAttribute("data-bx-url");if(!BX.type.isNotEmptyString(i)){i=document.location.pathname+document.location.search}i=BX.Uri.removeParam(i,["IFRAME","IFRAME_TYPE"]);top.BX.onCustomEvent("UI.Toolbar:onStarClick",[{isActive:BX.hasClass(this.starContNode,"ui-toolbar-star-active"),context:window,pageTitle:t,pageLink:i}])}.bind(this))},onStandardItemChangedSuccess:function(t){if(!BX.type.isBoolean(t.isActive)||!this.starContNode){return}if(t.context&&t.context!==window){return}if(t.isActive){this.showMessage(BX.message("UI_TOOLBAR_ITEM_WAS_ADDED_TO_LEFT"));this.starContNode.title=BX.message("UI_TOOLBAR_DELETE_PAGE_FROM_LEFT_MENU");BX.addClass(this.starContNode,"ui-toolbar-star-active")}else{this.showMessage(BX.message("UI_TOOLBAR_ITEM_WAS_DELETED_FROM_LEFT"));this.starContNode.title=BX.message("UI_TOOLBAR_ADD_PAGE_TO_LEFT_MENU");BX.removeClass(this.starContNode,"ui-toolbar-star-active")}},showMessage:function(t){var e=BX.PopupWindowManager.create("left-menu-message",this.starContNode,{content:t,darkMode:true,offsetTop:2,offsetLeft:0,angle:true,events:{onPopupClose:function(){if(e){e.destroy();e=null}}},autoHide:true});e.show();setTimeout((function(){if(e){e.destroy();e=null}}),3e3)}}})();
//# sourceMappingURL=script.map.js