/**!
 * Sortable
 * @author	RubaXa   <trash@rubaxa.org>
 * @license MIT
 */
!function sortableModule(factory){"use strict";"function"==typeof define&&define.amd?define(factory):"undefined"!=typeof module&&void 0!==module.exports?module.exports=factory():window.Sortable=factory()}((function sortableFactory(){"use strict";if("undefined"==typeof window||!window.document)return function sortableError(){throw new Error("Sortable.js requires a window with a document")};var dragEl,parentEl,ghostEl,cloneEl,rootEl,nextEl,lastDownEl,scrollEl,scrollParentEl,scrollCustomFn,lastEl,lastCSS,lastParentCSS,oldIndex,newIndex,activeGroup,putSortable,autoScroll={},tapEvt,touchEvt,moved,R_SPACE=/\s+/g,R_FLOAT=/left|right|inline/,expando="Sortable"+(new Date).getTime(),win=window,document=win.document,parseInt=win.parseInt,$=win.jQuery||win.Zepto,Polymer=win.Polymer,captureMode=!1,supportDraggable=!!("draggable"in document.createElement("div")),supportCssPointerEvents=!navigator.userAgent.match(/Trident.*rv[ :]?11\./)&&((el=document.createElement("x")).style.cssText="pointer-events:auto","auto"===el.style.pointerEvents),_silent=!1,abs=Math.abs,min=Math.min,savedInputChecked=[],touchDragOverListeners=[],_autoScroll=_throttle((function(evt,options,rootEl){if(rootEl&&options.scroll){var _this=rootEl[expando],el,rect,sens=options.scrollSensitivity,speed=options.scrollSpeed,x=evt.clientX,y=evt.clientY,winWidth=window.innerWidth,winHeight=window.innerHeight,vx,vy,scrollOffsetX,scrollOffsetY;if(scrollParentEl!==rootEl&&(scrollEl=options.scroll,scrollParentEl=rootEl,scrollCustomFn=options.scrollFn,!0===scrollEl)){scrollEl=rootEl;do{if(scrollEl.offsetWidth<scrollEl.scrollWidth||scrollEl.offsetHeight<scrollEl.scrollHeight)break}while(scrollEl=scrollEl.parentNode)}scrollEl&&(el=scrollEl,rect=scrollEl.getBoundingClientRect(),vx=(abs(rect.right-x)<=sens)-(abs(rect.left-x)<=sens),vy=(abs(rect.bottom-y)<=sens)-(abs(rect.top-y)<=sens)),vx||vy||(vy=(winHeight-y<=sens)-(y<=sens),((vx=(winWidth-x<=sens)-(x<=sens))||vy)&&(el=win)),autoScroll.vx===vx&&autoScroll.vy===vy&&autoScroll.el===el||(autoScroll.el=el,autoScroll.vx=vx,autoScroll.vy=vy,clearInterval(autoScroll.pid),el&&(autoScroll.pid=setInterval((function(){if(scrollOffsetY=vy?vy*speed:0,scrollOffsetX=vx?vx*speed:0,"function"==typeof scrollCustomFn)return scrollCustomFn.call(_this,scrollOffsetX,scrollOffsetY,evt);el===win?win.scrollTo(win.pageXOffset+scrollOffsetX,win.pageYOffset+scrollOffsetY):(el.scrollTop+=scrollOffsetY,el.scrollLeft+=scrollOffsetX)}),24)))}}),30),_prepareGroup=function(options){function toFn(value,pull){return void 0!==value&&!0!==value||(value=group.name),"function"==typeof value?value:function(to,from){var fromGroup=from.options.group.name;return pull?value:value&&(value.join?value.indexOf(fromGroup)>-1:fromGroup==value)}}var group={},originalGroup=options.group;originalGroup&&"object"==typeof originalGroup||(originalGroup={name:originalGroup}),group.name=originalGroup.name,group.checkPull=toFn(originalGroup.pull,!0),group.checkPut=toFn(originalGroup.put),group.revertClone=originalGroup.revertClone,options.group=group},el;function Sortable(el,options){if(!el||!el.nodeType||1!==el.nodeType)throw"Sortable: `el` must be HTMLElement, and not "+{}.toString.call(el);this.el=el,this.options=options=_extend({},options),el[expando]=this;var defaults={group:Math.random(),sort:!0,disabled:!1,store:null,handle:null,scroll:!0,scrollSensitivity:30,scrollSpeed:10,draggable:/[uo]l/i.test(el.nodeName)?"li":">*",ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,setData:function(dataTransfer,dragEl){dataTransfer.setData("Text",dragEl.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0}};for(var name in defaults)!(name in options)&&(options[name]=defaults[name]);for(var fn in _prepareGroup(options),this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this));this.nativeDraggable=!options.forceFallback&&supportDraggable,_on(el,"mousedown",this._onTapStart),_on(el,"touchstart",this._onTapStart),_on(el,"pointerdown",this._onTapStart),this.nativeDraggable&&(_on(el,"dragover",this),_on(el,"dragenter",this)),touchDragOverListeners.push(this._onDragOver),options.store&&this.sort(options.store.get(this))}function _cloneHide(sortable,state){"clone"!==sortable.lastPullMode&&(state=!0),cloneEl&&cloneEl.state!==state&&(_css(cloneEl,"display",state?"none":""),state||cloneEl.state&&(sortable.options.group.revertClone?(rootEl.insertBefore(cloneEl,nextEl),sortable._animate(dragEl,cloneEl)):rootEl.insertBefore(cloneEl,dragEl)),cloneEl.state=state)}function _closest(el,selector,ctx){if(el){ctx=ctx||document;do{if(">*"===selector&&el.parentNode===ctx||_matches(el,selector))return el}while(el=_getParentOrHost(el))}return null}function _getParentOrHost(el){var parent=el.host;return parent&&parent.nodeType?parent:el.parentNode}function _globalDragOver(evt){evt.dataTransfer&&(evt.dataTransfer.dropEffect="move"),evt.preventDefault()}function _on(el,event,fn){el.addEventListener(event,fn,captureMode)}function _off(el,event,fn){el.removeEventListener(event,fn,captureMode)}function _toggleClass(el,name,state){if(el)if(el.classList)el.classList[state?"add":"remove"](name);else{var className=(" "+el.className+" ").replace(R_SPACE," ").replace(" "+name+" "," ");el.className=(className+(state?" "+name:"")).replace(R_SPACE," ")}}function _css(el,prop,val){var style=el&&el.style;if(style){if(void 0===val)return document.defaultView&&document.defaultView.getComputedStyle?val=document.defaultView.getComputedStyle(el,""):el.currentStyle&&(val=el.currentStyle),void 0===prop?val:val[prop];prop in style||(prop="-webkit-"+prop),style[prop]=val+("string"==typeof val?"":"px")}}function _find(ctx,tagName,iterator){if(ctx){var list=ctx.getElementsByTagName(tagName),i=0,n=list.length;if(iterator)for(;i<n;i++)iterator(list[i],i);return list}return[]}function _dispatchEvent(sortable,rootEl,name,targetEl,fromEl,startIndex,newIndex){sortable=sortable||rootEl[expando];var evt=document.createEvent("Event"),options=sortable.options,onName="on"+name.charAt(0).toUpperCase()+name.substr(1);evt.initEvent(name,!0,!0),evt.to=rootEl,evt.from=fromEl||rootEl,evt.item=targetEl||rootEl,evt.clone=cloneEl,evt.oldIndex=startIndex,evt.newIndex=newIndex,rootEl.dispatchEvent(evt),options[onName]&&options[onName].call(sortable,evt)}function _onMove(fromEl,toEl,dragEl,dragRect,targetEl,targetRect,originalEvt,willInsertAfter){var evt,sortable=fromEl[expando],onMoveFn=sortable.options.onMove,retVal;return(evt=document.createEvent("Event")).initEvent("move",!0,!0),evt.to=toEl,evt.from=fromEl,evt.dragged=dragEl,evt.draggedRect=dragRect,evt.related=targetEl||toEl,evt.relatedRect=targetRect||toEl.getBoundingClientRect(),evt.willInsertAfter=willInsertAfter,fromEl.dispatchEvent(evt),onMoveFn&&(retVal=onMoveFn.call(sortable,evt,originalEvt)),retVal}function _disableDraggable(el){el.draggable=!1}function _unsilent(){_silent=!1}function _ghostIsLast(el,evt){var lastEl,rect=el.lastElementChild.getBoundingClientRect();return evt.clientY-(rect.top+rect.height)>5||evt.clientX-(rect.left+rect.width)>5}function _generateId(el){for(var str=el.tagName+el.className+el.src+el.href+el.textContent,i=str.length,sum=0;i--;)sum+=str.charCodeAt(i);return sum.toString(36)}function _index(el,selector){var index=0;if(!el||!el.parentNode)return-1;for(;el&&(el=el.previousElementSibling);)"TEMPLATE"===el.nodeName.toUpperCase()||">*"!==selector&&!_matches(el,selector)||index++;return index}function _matches(el,selector){if(el){var tag=(selector=selector.split(".")).shift().toUpperCase(),re=new RegExp("\\s("+selector.join("|")+")(?=\\s)","g");return!(""!==tag&&el.nodeName.toUpperCase()!=tag||selector.length&&((" "+el.className+" ").match(re)||[]).length!=selector.length)}return!1}function _throttle(callback,ms){var args,_this;return function(){void 0===args&&(args=arguments,_this=this,setTimeout((function(){1===args.length?callback.call(_this,args[0]):callback.apply(_this,args),args=void 0}),ms))}}function _extend(dst,src){if(dst&&src)for(var key in src)src.hasOwnProperty(key)&&(dst[key]=src[key]);return dst}function _clone(el){return $?$(el).clone(!0)[0]:Polymer&&Polymer.dom?Polymer.dom(el).cloneNode(!0):el.cloneNode(!0)}function _saveInputCheckedState(root){for(var inputs=root.getElementsByTagName("input"),idx=inputs.length;idx--;){var el=inputs[idx];el.checked&&savedInputChecked.push(el)}}Sortable.prototype={constructor:Sortable,_onTapStart:function(evt){var _this=this,el=this.el,options=this.options,preventOnFilter=options.preventOnFilter,type=evt.type,touch=evt.touches&&evt.touches[0],target=(touch||evt).target,originalTarget=evt.target.shadowRoot&&evt.path&&evt.path[0]||target,filter=options.filter,startIndex;if(!dragEl&&!(/mousedown|pointerdown/.test(type)&&0!==evt.button||options.disabled)&&(target=_closest(target,options.draggable,el))&&lastDownEl!==target){if(startIndex=_index(target,options.draggable),"function"==typeof filter){if(filter.call(this,evt,target,this))return _dispatchEvent(_this,originalTarget,"filter",target,el,startIndex),void(preventOnFilter&&evt.preventDefault())}else if(filter&&(filter=filter.split(",").some((function(criteria){if(criteria=_closest(originalTarget,criteria.trim(),el))return _dispatchEvent(_this,criteria,"filter",target,el,startIndex),!0}))))return void(preventOnFilter&&evt.preventDefault());options.handle&&!_closest(originalTarget,options.handle,el)||this._prepareDragStart(evt,touch,target,startIndex)}},_prepareDragStart:function(evt,touch,target,startIndex){var _this=this,el=_this.el,options=_this.options,ownerDocument=el.ownerDocument,dragStartFn;target&&!dragEl&&target.parentNode===el&&(tapEvt=evt,rootEl=el,parentEl=(dragEl=target).parentNode,nextEl=dragEl.nextSibling,lastDownEl=target,activeGroup=options.group,oldIndex=startIndex,this._lastX=(touch||evt).clientX,this._lastY=(touch||evt).clientY,dragEl.style["will-change"]="transform",dragStartFn=function(){_this._disableDelayedDrag(),dragEl.draggable=_this.nativeDraggable,_toggleClass(dragEl,options.chosenClass,!0),_this._triggerDragStart(evt,touch),_dispatchEvent(_this,rootEl,"choose",dragEl,rootEl,oldIndex)},options.ignore.split(",").forEach((function(criteria){_find(dragEl,criteria.trim(),_disableDraggable)})),_on(ownerDocument,"mouseup",_this._onDrop),_on(ownerDocument,"touchend",_this._onDrop),_on(ownerDocument,"touchcancel",_this._onDrop),_on(ownerDocument,"pointercancel",_this._onDrop),_on(ownerDocument,"selectstart",_this),options.delay?(_on(ownerDocument,"mouseup",_this._disableDelayedDrag),_on(ownerDocument,"touchend",_this._disableDelayedDrag),_on(ownerDocument,"touchcancel",_this._disableDelayedDrag),_on(ownerDocument,"mousemove",_this._disableDelayedDrag),_on(ownerDocument,"touchmove",_this._disableDelayedDrag),_on(ownerDocument,"pointermove",_this._disableDelayedDrag),_this._dragStartTimer=setTimeout(dragStartFn,options.delay)):dragStartFn())},_disableDelayedDrag:function(){var ownerDocument=this.el.ownerDocument;clearTimeout(this._dragStartTimer),_off(ownerDocument,"mouseup",this._disableDelayedDrag),_off(ownerDocument,"touchend",this._disableDelayedDrag),_off(ownerDocument,"touchcancel",this._disableDelayedDrag),_off(ownerDocument,"mousemove",this._disableDelayedDrag),_off(ownerDocument,"touchmove",this._disableDelayedDrag),_off(ownerDocument,"pointermove",this._disableDelayedDrag)},_triggerDragStart:function(evt,touch){(touch=touch||("touch"==evt.pointerType?evt:null))?(tapEvt={target:dragEl,clientX:touch.clientX,clientY:touch.clientY},this._onDragStart(tapEvt,"touch")):this.nativeDraggable?(_on(dragEl,"dragend",this),_on(rootEl,"dragstart",this._onDragStart)):this._onDragStart(tapEvt,!0);try{document.selection?setTimeout((function(){document.selection.empty()})):window.getSelection().removeAllRanges()}catch(err){}},_dragStarted:function(){if(rootEl&&dragEl){var options=this.options;_toggleClass(dragEl,options.ghostClass,!0),_toggleClass(dragEl,options.dragClass,!1),Sortable.active=this,_dispatchEvent(this,rootEl,"start",dragEl,rootEl,oldIndex)}else this._nulling()},_emulateDragOver:function(){if(touchEvt){if(this._lastX===touchEvt.clientX&&this._lastY===touchEvt.clientY)return;this._lastX=touchEvt.clientX,this._lastY=touchEvt.clientY,supportCssPointerEvents||_css(ghostEl,"display","none");var target=document.elementFromPoint(touchEvt.clientX,touchEvt.clientY),parent=target,i=touchDragOverListeners.length;if(parent)do{if(parent[expando]){for(;i--;)touchDragOverListeners[i]({clientX:touchEvt.clientX,clientY:touchEvt.clientY,target:target,rootEl:parent});break}target=parent}while(parent=parent.parentNode);supportCssPointerEvents||_css(ghostEl,"display","")}},_onTouchMove:function(evt){if(tapEvt){var options=this.options,fallbackTolerance=options.fallbackTolerance,fallbackOffset=options.fallbackOffset,touch=evt.touches?evt.touches[0]:evt,dx=touch.clientX-tapEvt.clientX+fallbackOffset.x,dy=touch.clientY-tapEvt.clientY+fallbackOffset.y,translate3d=evt.touches?"translate3d("+dx+"px,"+dy+"px,0)":"translate("+dx+"px,"+dy+"px)";if(!Sortable.active){if(fallbackTolerance&&min(abs(touch.clientX-this._lastX),abs(touch.clientY-this._lastY))<fallbackTolerance)return;this._dragStarted()}this._appendGhost(),moved=!0,touchEvt=touch,_css(ghostEl,"webkitTransform",translate3d),_css(ghostEl,"mozTransform",translate3d),_css(ghostEl,"msTransform",translate3d),_css(ghostEl,"transform",translate3d),evt.preventDefault()}},_appendGhost:function(){if(!ghostEl){var rect=dragEl.getBoundingClientRect(),css=_css(dragEl),options=this.options,ghostRect;_toggleClass(ghostEl=dragEl.cloneNode(!0),options.ghostClass,!1),_toggleClass(ghostEl,options.fallbackClass,!0),_toggleClass(ghostEl,options.dragClass,!0),_css(ghostEl,"top",rect.top-parseInt(css.marginTop,10)),_css(ghostEl,"left",rect.left-parseInt(css.marginLeft,10)),_css(ghostEl,"width",rect.width),_css(ghostEl,"height",rect.height),_css(ghostEl,"opacity","0.8"),_css(ghostEl,"position","fixed"),_css(ghostEl,"zIndex","100000"),_css(ghostEl,"pointerEvents","none"),options.fallbackOnBody&&document.body.appendChild(ghostEl)||rootEl.appendChild(ghostEl),ghostRect=ghostEl.getBoundingClientRect(),_css(ghostEl,"width",2*rect.width-ghostRect.width),_css(ghostEl,"height",2*rect.height-ghostRect.height)}},_onDragStart:function(evt,useFallback){var dataTransfer=evt.dataTransfer,options=this.options;this._offUpEvents(),activeGroup.checkPull(this,this,dragEl,evt)&&((cloneEl=_clone(dragEl)).draggable=!1,cloneEl.style["will-change"]="",_css(cloneEl,"display","none"),_toggleClass(cloneEl,this.options.chosenClass,!1),rootEl.insertBefore(cloneEl,dragEl),_dispatchEvent(this,rootEl,"clone",dragEl)),_toggleClass(dragEl,options.dragClass,!0),useFallback?("touch"===useFallback?(_on(document,"touchmove",this._onTouchMove),_on(document,"touchend",this._onDrop),_on(document,"touchcancel",this._onDrop),_on(document,"pointermove",this._onTouchMove),_on(document,"pointerup",this._onDrop)):(_on(document,"mousemove",this._onTouchMove),_on(document,"mouseup",this._onDrop)),this._loopId=setInterval(this._emulateDragOver,50)):(dataTransfer&&(dataTransfer.effectAllowed="move",options.setData&&options.setData.call(this,dataTransfer,dragEl)),_on(document,"drop",this),setTimeout(this._dragStarted,0))},_onDragOver:function(evt){var el=this.el,target,dragRect,targetRect,revert,options=this.options,group=options.group,activeSortable=Sortable.active,isOwner=activeGroup===group,isMovingBetweenSortable=!1,canSort=options.sort;if(void 0!==evt.preventDefault&&(evt.preventDefault(),!options.dragoverBubble&&evt.stopPropagation()),!dragEl.animated&&(moved=!0,activeSortable&&!options.disabled&&(isOwner?canSort||(revert=!rootEl.contains(dragEl)):putSortable===this||(activeSortable.lastPullMode=activeGroup.checkPull(this,activeSortable,dragEl,evt))&&group.checkPut(this,activeSortable,dragEl,evt))&&(void 0===evt.rootEl||evt.rootEl===this.el))){if(_autoScroll(evt,options,this.el),_silent)return;if(target=_closest(evt.target,options.draggable,el),dragRect=dragEl.getBoundingClientRect(),putSortable!==this&&(putSortable=this,isMovingBetweenSortable=!0),revert)return _cloneHide(activeSortable,!0),parentEl=rootEl,void(cloneEl||nextEl?rootEl.insertBefore(dragEl,cloneEl||nextEl):canSort||rootEl.appendChild(dragEl));if(0===el.children.length||el.children[0]===ghostEl||el===evt.target&&_ghostIsLast(el,evt)){if(0!==el.children.length&&el.children[0]!==ghostEl&&el===evt.target&&(target=el.lastElementChild),target){if(target.animated)return;targetRect=target.getBoundingClientRect()}_cloneHide(activeSortable,isOwner),!1!==_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt)&&(dragEl.contains(el)||(el.appendChild(dragEl),parentEl=el),this._animate(dragRect,dragEl),target&&this._animate(targetRect,target))}else if(target&&!target.animated&&target!==dragEl&&void 0!==target.parentNode[expando]){lastEl!==target&&(lastEl=target,lastCSS=_css(target),lastParentCSS=_css(target.parentNode));var width=(targetRect=target.getBoundingClientRect()).right-targetRect.left,height=targetRect.bottom-targetRect.top,floating=R_FLOAT.test(lastCSS.cssFloat+lastCSS.display)||"flex"==lastParentCSS.display&&0===lastParentCSS["flex-direction"].indexOf("row"),isWide=target.offsetWidth>dragEl.offsetWidth,isLong=target.offsetHeight>dragEl.offsetHeight,halfway=(floating?(evt.clientX-targetRect.left)/width:(evt.clientY-targetRect.top)/height)>.5,nextSibling=target.nextElementSibling,after=!1;if(floating){var elTop=dragEl.offsetTop,tgTop=target.offsetTop;after=elTop===tgTop?target.previousElementSibling===dragEl&&!isWide||halfway&&isWide:target.previousElementSibling===dragEl||dragEl.previousElementSibling===target?(evt.clientY-targetRect.top)/height>.5:tgTop>elTop}else isMovingBetweenSortable||(after=nextSibling!==dragEl&&!isLong||halfway&&isLong);var moveVector=_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,after);!1!==moveVector&&(1!==moveVector&&-1!==moveVector||(after=1===moveVector),_silent=!0,setTimeout(_unsilent,30),_cloneHide(activeSortable,isOwner),dragEl.contains(el)||(after&&!nextSibling?el.appendChild(dragEl):target.parentNode.insertBefore(dragEl,after?nextSibling:target)),parentEl=dragEl.parentNode,this._animate(dragRect,dragEl),this._animate(targetRect,target))}}},_animate:function(prevRect,target){var ms=this.options.animation;if(ms){var currentRect=target.getBoundingClientRect();1===prevRect.nodeType&&(prevRect=prevRect.getBoundingClientRect()),_css(target,"transition","none"),_css(target,"transform","translate3d("+(prevRect.left-currentRect.left)+"px,"+(prevRect.top-currentRect.top)+"px,0)"),target.offsetWidth,_css(target,"transition","all "+ms+"ms"),_css(target,"transform","translate3d(0,0,0)"),clearTimeout(target.animated),target.animated=setTimeout((function(){_css(target,"transition",""),_css(target,"transform",""),target.animated=!1}),ms)}},_offUpEvents:function(){var ownerDocument=this.el.ownerDocument;_off(document,"touchmove",this._onTouchMove),_off(document,"pointermove",this._onTouchMove),_off(ownerDocument,"mouseup",this._onDrop),_off(ownerDocument,"touchend",this._onDrop),_off(ownerDocument,"pointerup",this._onDrop),_off(ownerDocument,"touchcancel",this._onDrop),_off(ownerDocument,"pointercancel",this._onDrop),_off(ownerDocument,"selectstart",this)},_onDrop:function(evt){var el=this.el,options=this.options;clearInterval(this._loopId),clearInterval(autoScroll.pid),clearTimeout(this._dragStartTimer),_off(document,"mousemove",this._onTouchMove),this.nativeDraggable&&(_off(document,"drop",this),_off(el,"dragstart",this._onDragStart)),this._offUpEvents(),evt&&(moved&&(evt.preventDefault(),!options.dropBubble&&evt.stopPropagation()),ghostEl&&ghostEl.parentNode&&ghostEl.parentNode.removeChild(ghostEl),rootEl!==parentEl&&"clone"===Sortable.active.lastPullMode||cloneEl&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl),dragEl&&(this.nativeDraggable&&_off(dragEl,"dragend",this),_disableDraggable(dragEl),dragEl.style["will-change"]="",_toggleClass(dragEl,this.options.ghostClass,!1),_toggleClass(dragEl,this.options.chosenClass,!1),_dispatchEvent(this,rootEl,"unchoose",dragEl,rootEl,oldIndex),rootEl!==parentEl?(newIndex=_index(dragEl,options.draggable))>=0&&(_dispatchEvent(null,parentEl,"add",dragEl,rootEl,oldIndex,newIndex),_dispatchEvent(this,rootEl,"remove",dragEl,rootEl,oldIndex,newIndex),_dispatchEvent(null,parentEl,"sort",dragEl,rootEl,oldIndex,newIndex),_dispatchEvent(this,rootEl,"sort",dragEl,rootEl,oldIndex,newIndex)):dragEl.nextSibling!==nextEl&&(newIndex=_index(dragEl,options.draggable))>=0&&(_dispatchEvent(this,rootEl,"update",dragEl,rootEl,oldIndex,newIndex),_dispatchEvent(this,rootEl,"sort",dragEl,rootEl,oldIndex,newIndex)),Sortable.active&&(null!=newIndex&&-1!==newIndex||(newIndex=oldIndex),_dispatchEvent(this,rootEl,"end",dragEl,rootEl,oldIndex,newIndex),this.save()))),this._nulling()},_nulling:function(){rootEl=dragEl=parentEl=ghostEl=nextEl=cloneEl=lastDownEl=scrollEl=scrollParentEl=tapEvt=touchEvt=moved=newIndex=lastEl=lastCSS=putSortable=activeGroup=Sortable.active=null,savedInputChecked.forEach((function(el){el.checked=!0})),savedInputChecked.length=0},handleEvent:function(evt){switch(evt.type){case"drop":case"dragend":this._onDrop(evt);break;case"dragover":case"dragenter":dragEl&&(this._onDragOver(evt),_globalDragOver(evt));break;case"selectstart":evt.preventDefault()}},toArray:function(){for(var order=[],el,children=this.el.children,i=0,n=children.length,options=this.options;i<n;i++)_closest(el=children[i],options.draggable,this.el)&&order.push(el.getAttribute(options.dataIdAttr)||_generateId(el));return order},sort:function(order){var items={},rootEl=this.el;this.toArray().forEach((function(id,i){var el=rootEl.children[i];_closest(el,this.options.draggable,rootEl)&&(items[id]=el)}),this),order.forEach((function(id){items[id]&&(rootEl.removeChild(items[id]),rootEl.appendChild(items[id]))}))},save:function(){var store=this.options.store;store&&store.set(this)},closest:function(el,selector){return _closest(el,selector||this.options.draggable,this.el)},option:function(name,value){var options=this.options;if(void 0===value)return options[name];options[name]=value,"group"===name&&_prepareGroup(options)},destroy:function(){var el=this.el;el[expando]=null,_off(el,"mousedown",this._onTapStart),_off(el,"touchstart",this._onTapStart),_off(el,"pointerdown",this._onTapStart),this.nativeDraggable&&(_off(el,"dragover",this),_off(el,"dragenter",this)),Array.prototype.forEach.call(el.querySelectorAll("[draggable]"),(function(el){el.removeAttribute("draggable")})),touchDragOverListeners.splice(touchDragOverListeners.indexOf(this._onDragOver),1),this._onDrop(),this.el=el=null}},_on(document,"touchmove",(function(evt){Sortable.active&&evt.preventDefault()}));try{window.addEventListener("test",null,Object.defineProperty({},"passive",{get:function(){captureMode={capture:!1,passive:!1}}}))}catch(err){}return Sortable.utils={on:_on,off:_off,css:_css,find:_find,is:function(el,selector){return!!_closest(el,selector,el)},extend:_extend,throttle:_throttle,closest:_closest,toggleClass:_toggleClass,clone:_clone,index:_index},Sortable.create=function(el,options){return new Sortable(el,options)},Sortable.version="1.6.1",Sortable}));