(function(){"use strict";BX.namespace("BX.Landing");BX.Landing.Utils=function(){};BX.Landing.Utils.Show=function(n){return new Promise((function(e){if(!!n&&!BX.Landing.Utils.isShown(n)){BX.Landing.Utils.onAnimationEnd(n).then((function(t){n.dataset.isShown=true;e(t)}));n.hidden=false;n.classList.remove("landing-ui-hide");n.classList.add("landing-ui-show")}else{e()}}))};BX.Landing.Utils.isShown=function(n){return n.dataset.isShown==="true"};BX.Landing.Utils.Hide=function(n){return new Promise((function(e){if(!!n&&BX.Landing.Utils.isShown(n)){BX.Landing.Utils.onAnimationEnd(n).then((function(t){n.hidden=true;n.dataset.isShown=false;e(t)}));n.classList.remove("landing-ui-show");n.classList.add("landing-ui-hide")}else{e()}}))};BX.Landing.Utils.isValidElementId=function(n){var e=new RegExp("^[A-Za-z]+[\\w\\-\\:\\.]*$");return e.test(n)};BX.Landing.Utils.ignorePromiseDecorator=function(n){var e=function(){};return function(){n.apply(null,arguments).then(e)}};BX.Landing.Utils.appendHTML=function(n,e){n.innerHTML=n.innerHTML+e};BX.Landing.Utils.getCSSSelector=function(n){var e=[];while(n.parentNode){if(n.id){e.unshift("#"+n.id);break}else{if(n===n.ownerDocument.documentElement){e.unshift(n.tagName.toLowerCase())}else{for(var t=1,i=n;i.previousElementSibling;i=i.previousElementSibling,t++){}e.unshift(n.tagName.toLowerCase()+":nth-child("+t+")")}n=n.parentNode}}return e.join(" > ")};BX.Landing.Utils.onTransitionEnd=function(n){n=BX.type.isArray(n)?n:[n];return Promise.all(n.map((function(n){return new Promise((function(e){n.addEventListener("webkitTransitionEnd",e);n.addEventListener("transitionend",e);n.addEventListener("msTransitionEnd",e);n.addEventListener("oTransitionEnd",e);return e})).then((function(e){n.removeEventListener("webkitTransitionEnd",e);n.removeEventListener("transitionend",e);n.removeEventListener("msTransitionEnd",e);n.removeEventListener("oTransitionEnd",e)}))})))};BX.Landing.Utils.onAnimationEnd=function(n,e){return new Promise((function(t){var i=function(r){if(!e||r.animationName===e){t(r);n.removeEventListener("animationend",i);n.removeEventListener("oAnimationEnd",i);n.removeEventListener("webkitAnimationEnd",i)}};n.addEventListener("animationend",i);n.addEventListener("oAnimationEnd",i);n.addEventListener("webkitAnimationEnd",i)}))};BX.Landing.Utils.htmlToElement=function(n){return BX.create("div",{html:n}).firstElementChild};BX.Landing.Utils.htmlToFragment=function(n){var e=BX.create("div",{html:n});var t=document.createDocumentFragment();[].slice.call(e.children).forEach((function(n){t.appendChild(n)}));return t};BX.Landing.Utils.deepFreeze=function(n){Object.freeze(n);Object.keys(n).forEach((function(e){if(!!n[e]&&(typeof n[e]==="object"||typeof n[e]==="function")){BX.Landing.Utils.deepFreeze(n[e])}}));return n};BX.Landing.Utils.insert=function(n,e,t){if(t===0){BX.prepend(e,n)}else if(t>0&&t<=n.children.length-1){n.insertBefore(e,n.children[t])}else{n.appendChild(e)}};BX.Landing.Utils.Matchers={youtube:new RegExp("(youtube\\.com|youtu\\.be|youtube\\-nocookie\\.com)\\/((watch\\?(.*&)?v=|v\\/|u\\/|embed\\/?)|(shorts\\/))?(videoseries\\?list=(.*)|[\\w-]{11}|\\?listType=(.*)&list=(.*))(.*)"),vimeo:new RegExp("^.+vimeo.com\\/(.*\\/)?([\\d]+)(.*)?"),vine:new RegExp("vine.co\\/v\\/([a-zA-Z0-9\\?\\=\\-]+)"),instagram:new RegExp("(instagr\\.am|instagram\\.com)\\/p\\/([a-zA-Z0-9_\\-]+)\\/?"),rutube:new RegExp("rutube\\.ru\\/video\\/(private\\/)?([a-zA-Z0-9]+)\\/?"),vk:new RegExp("vk\\.(com|ru)\\/.*(video|clip)(-?\\d+_\\d+)\\/?"),googleMapsSearch:new RegExp("(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(maps\\/search\\/)(.*)","i"),googleMapsPlace:new RegExp("(maps\\.)?google\\.([a-z]{2,3}(\\.[a-z]{2})?)\\/(((maps\\/(place\\/(.*)\\/)?\\@(.*),(\\d+.?\\d+?)z))|(\\?ll=))(.*)?","i"),headerTag:new RegExp("^H[1-6]$"),russianText:new RegExp("[\u0400-\u04ff]"),facebookPages:new RegExp("(?:http://)?(?:www.)?facebook.com/(?:(?:w)*#!/)?(?:pages/)?(?:[w-]*/)*([w-]*)"),facebookPosts:new RegExp("^https://www.facebook.com/(photo(.php|s)|permalink.php|media|questions|notes|[^/]+/(activity|posts))[/?].*$"),facebookVideos:new RegExp("^(?:(?:https?:)?//)?(?:www.)?facebook.com/[a-z0-9.]+/videos/(?:[a-z0-9.]+/)?([0-9]+)/?(?:\\?.*)?$")};BX.Landing.Utils.getURLPreview=function(n){return BX.Landing.Backend.getInstance().action("Utils::getUrlPreview",{url:n})};BX.Landing.Utils.HTMLToElement=function(n){return BX.create("div",{html:n}).firstElementChild};BX.Landing.Utils.getQueryParams=function(n){var e={};if(typeof n==="string"){var t=n.split("?")[1];if(t){var i=t.split("&");for(var r=0;r<i.length;r++){var a=i[r].split("=");if(typeof e[a[0]]==="undefined"){e[a[0]]=decodeURIComponent(a[1])}else if(typeof e[a[0]]==="string"){e[a[0]]=[e[a[0]],decodeURIComponent(a[1])]}else{e[a[0]].push(decodeURIComponent(a[1]))}}}}return e};BX.Landing.Utils.escapeHtml=function(n){return BX.util.htmlspecialchars(BX.util.htmlspecialcharsback(""+n))};BX.Landing.Utils.escapeText=function(n){var e=n;if(typeof n==="number"||typeof n==="boolean"){e=""+n}else if(!!n&&typeof n==="object"){e=JSON.stringify(n)}return BX.Landing.Utils.escapeHtml(e)};BX.Landing.Utils.escapeAttributeValue=function(n){if(BX.Landing.Utils.isPlainObject(n)||BX.Landing.Utils.isArray(n)){n=JSON.stringify(n)}return BX.util.jsencode(""+n)};BX.Landing.Utils.setTextContent=function(n,e,t=""){var i=BX.Landing.Utils.addClass;if(typeof e==="string"){var r=n.firstChild;var a=document.createElement("div");if(r&&r===n.lastChild&&r.nodeType===Node.TEXT_NODE){r.nodeValue=e;if(t.length>0){i(a,t);a.textContent=n.innerText;n.innerText="";BX.Dom.append(a,n)}return}}n.textContent=e;if(t.length>0){i(a,t);a.textContent=n.innerText;n.innerText="";BX.Dom.append(a,n)}};BX.Landing.Utils.encodeDataValue=function(n){if(BX.Landing.Utils.isPlainObject(n)||BX.Landing.Utils.isArray(n)){n=JSON.stringify(n)}else{if(BX.Landing.Utils.isString(n)){n=BX.Landing.Utils.escapeHtml(n)}}return""+n};BX.Landing.Utils.decodeDataValue=function(n){var e=n;try{e=JSON.parse(n)}catch(t){e=n}if(BX.Landing.Utils.isString(e)){e=BX.util.htmlspecialcharsback(e)}return e};BX.Landing.Utils.data=function(n,e,t){var i=BX.Landing.Utils.decodeDataValue;var r=BX.Landing.Utils.encodeDataValue;var a=BX.Landing.Utils.isPlainObject;var o=BX.Landing.Utils.isString;var s=new RegExp("^data-");if(!n){throw new TypeError("Element is required")}if(!e){var l={};[].forEach.call(n.attributes,(function(n){if(s.test(n.name)){l[n.name]=i(n.value)}}));return l}if(o(e)){e=!s.test(e)?"data-"+e:e;if(t===undefined){return i(n.getAttribute(e))}if(t===null){return n.removeAttribute(e)}return n.setAttribute(e,r(t))}if(a(e)){Object.keys(e).forEach((function(t){BX.Landing.Utils.data(n,t,e[t])}))}};function n(n){n=n||document.body;var e=n.ownerDocument||document;var t=e.createTreeWalker(n,NodeFilter.SHOW_TEXT,null,false);var i=[];var r;while(r=t.nextNode()){i.push(r)}return i}function e(n,e){return n.compareBoundaryPoints(Range.END_TO_START,e)===-1&&n.compareBoundaryPoints(Range.START_TO_END,e)===1}function t(n){var e=n.ownerDocument.createRange();try{e.selectNode(n)}catch(t){e.selectNodeContents(n)}return e}function i(n,i){if(n.intersectsNode){return n.intersectsNode(i)}else{return e(n,t(i))}}function r(e){var t=e.commonAncestorContainer;var r=n(t.parentNode||t);return r.filter((function(n){return i(e,n)&&a(n)}))}function a(n){return n.textContent.length>0}function o(n){if(n.parentNode){n.parentNode.removeChild(n)}}function s(n,e){o(n);e.parentNode.insertBefore(n,e);o(e)}function l(n){var e=document.createRange();e.selectNodeContents(n);s(e.extractContents(),n)}function u(n){n.forEach((function(n){var e=n.parentNode;l(n);e.normalize()}))}function d(n,e){var t=e.startContainer;var i=e.endContainer;var r=e.startOffset;var a=e.endOffset;return function e(o){var s=document.createRange();var l=n;s.selectNodeContents(o);if(o===t&&t.nodeType===3){s.setStart(o,r);t=l;r=0}if(o===i&&i.nodeType===3){s.setEnd(o,a);i=l;a=1}s.surroundContents(l);return l}}BX.Landing.Utils.wrapSelection=function(n,e){var t;var i;var a={};if(typeof e==="undefined"){e=window.getSelection().getRangeAt(0)}if(e.isCollapsed){return[]}if(typeof n==="undefined"){n="span"}if(typeof n==="string"){n=document.createElement(n)}i=d(n,e);t=r(e);t=t.map(i);a.nodes=t;a.unwrap=function(){if(this.nodes.length){u(this.nodes);this.nodes=[]}};return a};BX.Landing.Utils.createRangeFromNode=t;BX.Landing.Utils.createSelectionRange=function(e,t,i){var r;if(document.createRange&&window.getSelection){r=document.createRange();r.selectNodeContents(e);var a=n(e);var o=false;var s=0,l;for(var u=0,d;d=a[u++];){l=s+d.length;if(!o&&t>=s&&(t<l||t===l&&u<=a.length)){r.setStart(d,t-s);o=true}if(o&&i<=l){r.setEnd(d,i-s);break}s=l}}else if(document.selection&&document.body.createTextRange){r=document.body.createTextRange();r.moveToElementText(e);r.collapse(true);r.moveEnd("character",i);r.moveStart("character",t)}return r};BX.Landing.Utils.style=function(n,e){return new Promise((function(t){if(e===null){requestAnimationFrame((function(){n.style=null;t()}))}if(!!e&&typeof e==="object"){requestAnimationFrame((function(){Object.keys(e).forEach((function(t){n.style.setProperty(t,e[t])}));t()}))}}))};BX.Landing.Utils.translateY=function(n,e){return BX.Landing.Utils.translate("y",n,e)};BX.Landing.Utils.translateX=function(n,e){return BX.Landing.Utils.translate("x",n,e)};BX.Landing.Utils.translate=function(n,e,t){void BX.Landing.Utils.style(e,{transition:"transform 200ms ease",transform:"translate"+n.toUpperCase()+"("+t+"px) translateZ(0)"});return BX.Landing.Utils.onTransitionEnd(e)};BX.Landing.Utils.insertBefore=function(n,e){e.parentElement.insertBefore(n,e)};BX.Landing.Utils.rect=function(n){return n.getBoundingClientRect()};BX.Landing.Utils.nextSibling=function(n,e){return e?BX.findNextSibling(n,{className:e}):n.nextElementSibling};BX.Landing.Utils.prevSibling=function(n,e){return e?BX.findPreviousSibling(n,{className:e}):n.previousElementSibling};BX.Landing.Utils.join=function(){return[].slice.call(arguments).join("")};BX.Landing.Utils.slice=function(n){return[].slice.call(n)};BX.Landing.Utils.attr=function(n,e,t){if(BX.Landing.Utils.isString(e)){if(typeof t==="undefined"){return n.getAttribute(e)}n.setAttribute(e,BX.Landing.Utils.encodeDataValue(t))}if(BX.Landing.Utils.isPlainObject(e)){Object.keys(e).forEach((function(t){if(e[t]===null){n.removeAttribute(t)}else{n.setAttribute(t,BX.Landing.Utils.encodeDataValue(e[t]))}}))}};BX.Landing.Utils.removePanels=function(n){[].slice.call(n.querySelectorAll(".landing-ui-panel")).forEach((function(n){BX.remove(n)}));return n};BX.Landing.Utils.getFileExtension=function(n){var e="fm";var t=new RegExp("[?&]"+e+"(=([^&#]*)|&|#|$)");var i=t.exec(n);if(!i||!i[2]){return""}return decodeURIComponent(i[2].replace(/\+/g," "))};BX.Landing.Utils.key={isUp:function(n){return n.keyCode===38},isDown:function(n){return n.keyCode===40},isRight:function(n){return n.keyCode===39},isLeft:function(n){return n.keyCode===37},isEnter:function(n){return n.keyCode===13},isEscape:function(n){return n.keyCode===27}};BX.Landing.Utils.makeFilterablePopupMenu=function(n){var e=BX.Landing.Utils.append;var t=BX.Landing.Utils.prepend;var i=BX.Landing.Utils.onCustomEvent;var r=BX.Landing.Utils.create;var a=BX.Landing.Utils.addClass;function o(n){return n.some((function(n){return!n.layout.item.hidden}))}function s(e){var t=e.currentTarget.value.toLowerCase();n.menuItems.forEach((function(n){n.layout.item.hidden=!n.text.toLowerCase().includes(t)}));d.hidden=o(n.menuItems)}var l=r("div",{props:{className:"landing-ui-popup-filter"}});var u=r("input",{props:{className:"landing-ui-popup-filter-input"},attrs:{placeholder:BX.Landing.Loc.getMessage("LANDING_MENU_ITEM_FILTER")},events:{input:s}});var d=r("div",{props:{className:"landing-ui-popup-filter-empty"},children:[r("span",{props:{className:"landing-ui-popup-filter-empty-text"},html:BX.Landing.Loc.getMessage("LANDING_MENU_ITEM_FILTER_EMPTY")})],attrs:{hidden:true}});e(u,l);t(l,n.popupWindow.contentContainer);e(d,n.popupWindow.contentContainer);a(n.popupWindow.popupContainer,"landing-ui-popup-filterable");u.focus();i(n.popupWindow,"onAfterPopupShow",(function(){requestAnimationFrame((function(){u.focus()}))}))};BX.Landing.Utils.makeSelectablePopupMenu=function(n){var e=BX.Landing.Utils.addClass;var t=BX.Landing.Utils.removeClass;var i=BX.Landing.Utils.hasClass;var r=BX.Landing.Utils.bind;var a=BX.Landing.Utils.key;var o=null;var s=-1;function l(n){e(n.layout.item,"landing-ui-select")}function u(n){t(n.layout.item,"landing-ui-select")}function d(n){n.forEach(u)}function c(n){return n.find((function(n){return i(n.layout.item,"landing-ui-select")}))}function f(n,e){return n.findIndex((function(n){return e===n}))}function g(n){return n.find((function(n){return!n.layout.item.hidden}))}function p(n){if(o){s=f(n,o)}var e=n.find((function(n,e){return e>s&&!n.layout.item.hidden}));if(e){o=e;return e}e=g(n);o=e;return e}function m(n){var e=BX.Landing.Utils.key;return e.isLeft(n)||e.isRight(n)||e.isUp(n)||e.isDown(n)||e.isEnter(n)}function B(n){n.forEach((function(n){n.closeSubMenu();var e=n.getSubMenu();if(e){d(e.menuItems)}}))}var X=false;r(n.popupWindow.popupContainer,"keydown",(function(e){var t=n;if(o&&o.menuWindow.popupWindow.isShown()){t=o.menuWindow}if(m(e)){var i=c(t.menuItems);if(a.isDown(e)&&X&&t===n){X=false;t.menuItems=t.menuItems.reverse()}if(a.isUp(e)&&!X&&t===n){X=true;t.menuItems=t.menuItems.reverse()}if(a.isRight(e)){if(i){i.showSubMenu();if(i.hasSubMenu()){var r=i.getSubMenu();d(r.menuItems);l(r.menuItems[0]);o=r.menuItems[0]}}return}if(a.isLeft(e)){B(n.menuItems);o=c(n.menuItems);return}if(a.isEnter(e)){if(i){BX.fireEvent(i.layout.item,"click");return}}d(t.menuItems);var s=p(t.menuItems);if(s){l(s);return}}if(a.isEscape(e)){t.close()}B(n.menuItems)}))};BX.Landing.Utils.delay=function(n,e){return new Promise((function(t){setTimeout(t.bind(null,e),n)}))};BX.Landing.Utils.highlight=function(n,e,t){var i;if(e){var r=document.createRange();r.selectNodeContents(n);i=r.getBoundingClientRect()}else{i=n.getBoundingClientRect()}if(t){i={top:i.bottom,left:i.left,right:i.right,bottom:i.bottom+1,height:20,width:i.width}}return BX.Landing.History.Highlight.getInstance().show(n,i)};BX.Landing.Utils.scrollTo=function(n){return BX.Landing.PageObject.getInstance().view().then((function(e){return BX.Landing.UI.Panel.Content.scrollTo(e,n).then((function(){return new Promise((function(n){setTimeout(n,50)}))}))}))};BX.Landing.Utils.offsetTop=function(n,e){var t=n.getBoundingClientRect();var i=e.getBoundingClientRect();var r=e.scrollTop;var a=parseInt(BX.style(e,"border-top-width"));a=a===a?a:0;return t.top+r-i.top-a};BX.Landing.Utils.offsetLeft=function(n,e){var t=n.getBoundingClientRect();var i=e.getBoundingClientRect();var r=e.scrollLeft;return t.left+r-i.left};BX.Landing.Utils.isArrayLike=function(n){var e=BX.Landing.Utils.isBoolean;var t=BX.Landing.Utils.isNumber;var i=BX.Landing.Utils.isFunction;return n!==null&&!i(n)&&!e(n)&&!t(n)&&n.length>0&&n.length<=Number.MAX_SAFE_INTEGER};BX.Landing.Utils.isArguments=function(n){var e=BX.Landing.Utils.isArrayLike;return e(n)&&n.toString()==="[object Arguments]"};BX.Landing.Utils.isEmpty=function(n){var e=BX.Landing.Utils.isArrayLike;if(n==null){return true}if(e(n)){return!n.length}for(var t in n){if(n.hasOwnProperty(t)){return false}}return true};BX.Landing.Utils.randomInt=function(n,e){e+=1;return Math.floor(Math.random()*(e-n))+n};BX.Landing.Utils.intersection=function(){var n=BX.Landing.Utils.slice;return n(arguments).reduce((function(n,e){return n.filter((function(n){return e.includes(n)}))}))};BX.Landing.Utils.difference=function(){var n=BX.Landing.Utils.slice;return n(arguments).reduce((function(n,e){return n.filter((function(n){return!e.includes(n)}))}))};BX.Landing.Utils.changeTagName=function(n,e){if(!n||!e){return null}var t=BX.Landing.Utils.slice;var i=BX.Landing.Utils.create;var r=t(n.attributes);var a=i(e);var o=n.innerHTML;r.forEach((function(n){a.setAttribute(n.nodeName,n.nodeValue)}));a.innerHTML=o;n.parentElement.replaceChild(a,n);return a};BX.Landing.Utils.hash=function(n){if(BX.Landing.Utils.isArray(n)||BX.Landing.Utils.isPlainObject(n)){n=JSON.stringify(BX.Landing.Utils.sortObject(n))}return""+BX.util.hashCode(n)};BX.Landing.Utils.sortObject=function(n){return Object.keys(n).sort().reduce((function(e,t){return e[t]=n[t],e}),{})};BX.Landing.Utils.capitalize=function(n){return n.charAt(0).toUpperCase()+n.slice(1)};BX.Landing.Utils.textToPlaceholders=function(n){var e=new RegExp('<span[^>]*data-placeholder="(\\w+)"[^>]*>(.+?)<\\/span>',"gm");var t=e.exec(n);if(t){return n.replace(e,"{{"+t[1]+"}}")}return n};BX.Landing.Utils.changeExtension=function(n,e){return!!n?n.replace(/\.[^\.]+$/,"."+e):n};BX.Landing.Utils.rename2x=function(n){n=n.replace(/@2x/,"");let e=BX.util.getExtension(n);if(e.length>4){e=e.split("_").pop()}return!!n?n.replace(/\.[^\.]+$/,"@2x."+e):n};BX.Landing.Utils.getDeltaFromEvent=function(n){var e=n.deltaX;var t=-1*n.deltaY;if(typeof e==="undefined"||typeof t==="undefined"){e=-1*n.wheelDeltaX/6;t=n.wheelDeltaY/6}if(n.deltaMode&&n.deltaMode===1){e*=10;t*=10}if(n.deltaMode&&n.deltaMode===1){e*=10;t*=10}if(e!==e&&t!==t){e=0;t=n.wheelDelta}return{x:e,y:t}};BX.Landing.Utils.urlToBlob=function(n){if(!BX.type.isString(n)){return Promise.resolve(n)}return new Promise((function(e,t){try{var i=BX.ajax.xhr();i.open("GET",n);i.responseType="blob";i.onerror=function(){t("Network error.")};i.onload=function(){if(i.status===200){e(i.response)}else{t("Loading error:"+i.statusText)}};i.send()}catch(n){t(n.message)}}))};BX.Landing.Utils.getFileName=function(n){return n.split("\\").pop().split("/").pop()};BX.Landing.Utils.getSelectedElement=function(n){const e=typeof n!=="undefined"&&n.nodeType===Node.DOCUMENT_NODE?n:document;let t;let i;let r;if(e.selection){t=e.selection.createRange();return t.parentElement()}else{i=e.defaultView.getSelection();if(i.getRangeAt){if(i.rangeCount>0){t=i.getRangeAt(0)}}else{t=e.createRange();t.setStart(i.anchorNode,i.anchorOffset);t.setEnd(i.focusNode,i.focusOffset);if(t.collapsed!==i.isCollapsed){t.setStart(i.focusNode,i.focusOffset);t.setEnd(i.anchorNode,i.anchorOffset)}}if(t){r=t["endContainer"];return r.nodeType===3?r.parentNode:r}}};BX.Landing.Utils.fireCustomEvent=function(n,e,t){try{BX.onCustomEvent(n,e,t)}catch(n){console.error(e,n)}};BX.Landing.Utils.onCustomEvent=BX.addCustomEvent;BX.Landing.Utils.removeCustomEvent=BX.removeCustomEvent;BX.Landing.Utils.insertAfter=BX.insertAfter;BX.Landing.Utils.isPlainObject=BX.type.isPlainObject;BX.Landing.Utils.append=BX.append;BX.Landing.Utils.prepend=BX.prepend;BX.Landing.Utils.isBoolean=BX.type.isBoolean;BX.Landing.Utils.isNumber=BX.type.isNumber;BX.Landing.Utils.isString=BX.type.isString;BX.Landing.Utils.isArray=BX.type.isArray;BX.Landing.Utils.isFunction=BX.type.isFunction;BX.Landing.Utils.addClass=BX.addClass;BX.Landing.Utils.removeClass=BX.removeClass;BX.Landing.Utils.toggleClass=BX.toggleClass;BX.Landing.Utils.hasClass=BX.hasClass;BX.Landing.Utils.debounce=BX.debounce;BX.Landing.Utils.throttle=BX.throttle;BX.Landing.Utils.bind=BX.bind;BX.Landing.Utils.unbind=BX.unbind;BX.Landing.Utils.getClass=BX.getClass;BX.Landing.Utils.pos=BX.pos;BX.Landing.Utils.assign=Object.assign||BX.util.objectMerge;BX.Landing.Utils.clone=BX.clone;BX.Landing.Utils.create=BX.create;BX.Landing.Utils.remove=BX.remove;BX.Landing.Utils.trim=BX.util.trim;BX.Landing.Utils.random=BX.util.getRandomString;BX.Landing.Utils.findParent=BX.findParent;BX.Landing.Utils.proxy=BX.proxy;BX.Landing.Utils.arrayUnique=BX.util.array_unique;BX.Landing.Utils.keys=Object.keys;BX.Landing.Utils.fireEvent=BX.fireEvent;BX.Landing.Utils.addQueryParams=BX.util.add_url_param.bind(BX.util)})();
//# sourceMappingURL=utils.map.js