(function(){"use strict";BX.namespace("BX.ColorPicker");BX.ColorPicker=function(t){t=BX.type.isPlainObject(t)?t:{};this.popupWindow=null;this.popupOptions={angle:true,autoHide:true,closeByEsc:true,noAllPaddings:true};this.layout={preview:null,customColor:null,defaultColor:null,actions:null,customColorInput:null,customColorTextBox:null};if(BX.type.isPlainObject(t.popupOptions)){BX.mergeEx(this.popupOptions,t.popupOptions)}this.bindElement=null;this.colors=[];this.selectedColor=null;this.defaultColor=null;this.allowCustomColor=true;this.colorPreview=true;this.onColorSelected=null;this.setOptions(t)};BX.ColorPicker.prototype={open:function(t){this.setOptions(t);var o=this.getPopupWindow();o.setContent(this.getPopupContent());this.getPopupWindow().show()},close:function(){this.getPopupWindow().close()},setOptions:function(t){if(!BX.type.isPlainObject(t)){return}if(BX.type.isArray(t.colors)){this.setColors(t.colors)}if("bindElement"in t){this.bindElement=t.bindElement;this.getPopupWindow().setBindElement(this.bindElement)}if(BX.type.isFunction(t.onColorSelected)){this.onColorSelected=t.onColorSelected}this.setSelectedColor(t.selectedColor);this.setDefaultColor(t.defaultColor);if(BX.type.isBoolean(t.allowCustomColor)){this.allowCustomColor=t.allowCustomColor}if(BX.type.isBoolean(t.colorPreview)){this.colorPreview=t.colorPreview}},getPopupWindow:function(){if(this.popupWindow){return this.popupWindow}var t="main-color-picker-"+BX.util.getRandomString(5);this.popupWindow=new BX.PopupWindow(t,this.bindElement,this.popupOptions);return this.popupWindow},setColors:function(t){if(!BX.type.isArray(t)){return}this.colors=[];t.forEach(function(t){if(!BX.type.isArray(t)){return}var o=[];t.forEach(function(t){t=this.getFullColorCode(t);if(t!==null){o.push(t)}},this);if(o.length){this.colors.push(o)}},this)},getColors:function(){return this.colors.length?this.colors:this.getDefaultColors()},getDefaultColors:function(){return[["#aae9fc","#bbecf1","#98e1dc","#e3f299","#ffee95","#ffdd93","#dfd3b6","#e3c6bb","#ffad97","#ffbdbb","#ffcbd8","#ffc4e4","#c4baed","#dbdde0","#bfc5cd","#a2a8b0"],["#ffffff","#2eceff","#10e5fc","#a5de00","#eec200","#ffa801","#ad8f47","#b57051","#ff5b55","#ef3000","#f968b6","#6b52cc","#06bab1","#5cd1df","#a1a6ac","#949da9"],["#ffb79f","#ffbf99","#f3e27c","#e7d35d","#00ff00","#00a64c","#48dfdf","#b02fb0","#ff00ff","#ef008b","#0000ff","#ebebeb","#acacac","#898989","#555555","#000000"],["#f89675","#fdad7e","#fec788","#fff893","#c5e099","#a3d49b","#8ed1a8","#7ecb9c","#78cdca","#67cef9","#7aa5da","#887fc0","#a284bf","#bd8bc0","#f69ac1","#f6989c"],["#f26b47","#f78d4d","#fdb051","#fff55a","#abd46c","#7bc56f","#00bbb4","#00bef6","#00bdb5","#3fb2cd","#3f8bcd","#5471b9","#865daa","#a861ab","#f16ca8","#f26b7b"],["#f11716","#f36509","#f99500","#fff300","#8ec82f","#2fb644","#00a74c","#00a99d","#00adf2","#0070bf","#0052a7","#2e2d93","#662793","#922091","#f0008c","#f10057"],["#9e0502","#a34100","#a46200","#aba100","#578520","#107c2c","#007333","#00736a","#0075a6","#004982","#003172","#1c0d64","#460663","#630060","#a0005c","#9f0037"]]},getPopupContent:function(){var t=BX.create("div",{props:{className:"main-color-picker-container"},events:{click:this.handleContainerClick.bind(this)}});var o=BX.create("div",{props:{className:"main-color-picker-palette"},events:{click:this.handleBoxClick.bind(this),mouseover:this.isPreviewVisible()?this.handleBoxOver.bind(this):null}});this.getColors().forEach(function(t){var e=BX.create("div",{props:{className:"main-color-picker-row"}});o.appendChild(e);t.forEach(function(t){if(!BX.type.isNotEmptyString(t)){return}t=t.toLowerCase();var o=BX.create("div",{attrs:{className:"main-color-picker-box","data-color":t},style:{backgroundColor:t}});if(this.getSelectedColor()===t){o.classList.add("main-color-picker-box-selected")}if(t==="#ffffff"){o.classList.add("main-color-picker-box-white")}e.appendChild(o)},this)},this);t.appendChild(o);var e=this.getActions();if(e){t.appendChild(e)}return t},getActions:function(){this.layout.customColor=null;this.layout.defaultColor=null;this.layout.preview=null;this.layout.actions=null;if(!this.isPreviewVisible()){return null}var t=!this.isCustomColorAllowed()||this.getDefaultColor()===null;this.layout.actions=BX.create("div",{props:{className:"main-color-picker-actions"+(t?" main-color-picker-single-action":"")},children:[this.layout.preview=BX.create("div",{props:{className:"main-color-picker-preview"}})]});if(this.isCustomColorAllowed()){this.layout.customColor=BX.create("div",{props:{className:"main-color-picker-custom"},children:[BX.create("span",{props:{className:"main-color-picker-custom-action"},text:BX.message("MAIN_COLORPICKER_SPECIFY_HEX_COLOR"),events:{click:this.handleCustomColorClick.bind(this)}}),BX.create("span",{props:{className:"main-color-picker-custom-form"},children:[BX.create("span",{props:{className:"main-color-picker-custom-label"},text:BX.message("MAIN_COLORPICKER_HEX_COLOR")+":"}),this.layout.customColorTextBox=BX.create("span",{props:{className:"main-color-picker-custom-textbox"},children:[this.layout.customColorInput=BX.create("input",{props:{className:"main-color-picker-custom-input"},attrs:{maxlength:6},events:{keypress:this.handleCustomInputKeyPress.bind(this),keyup:this.handleCustomInputKeyUp.bind(this),paste:this.handleCustomInputPaste.bind(this)}})]}),BX.create("span",{props:{className:"main-color-picker-custom-button"},events:{click:this.applyEditMode.bind(this)}})]})]});this.layout.actions.appendChild(this.layout.customColor)}if(this.getDefaultColor()!==null){this.layout.defaultColor=BX.create("div",{props:{className:"main-color-picker-default"},children:[BX.create("span",{props:{className:"main-color-picker-default-action"},text:BX.message("MAIN_COLORPICKER_BY_DEFAULT"),events:{click:this.handleDefaultActionClick.bind(this)}})]});this.layout.actions.appendChild(this.layout.defaultColor)}return this.layout.actions},isCustomColorAllowed:function(){return this.allowCustomColor},isPreviewVisible:function(){return this.colorPreview||this.getDefaultColor()!==null||this.isCustomColorAllowed()},getSelectedColor:function(){return this.selectedColor},setSelectedColor:function(t){if(this.isValidColor(t)){this.selectedColor=this.getFullColorCode(t.toLowerCase())}else if(t===null){this.selectedColor=null}},getDefaultColor:function(){return this.defaultColor},setDefaultColor:function(t){if(this.isValidColor(t)){this.defaultColor=this.getFullColorCode(t.toLowerCase())}else if(t===null){this.defaultColor=null}},handleContainerClick:function(t){if(this.isEditMode()&&t.target!==this.layout.customColorInput){var o=BX.util.trim(this.layout.customColorInput.value);if(!o.length){this.resetEditMode();this.resetError()}}},handleCustomColorClick:function(t){this.switchToEditMode();t.stopPropagation()},handleBoxClick:function(t){var o=t.target;if(!BX.type.isDomNode(o)||!o.dataset.color){return}var e=o.dataset.color;o.classList.add("main-color-picker-box-selected");this.applyColor(e)},applyColor:function(t){if(this.isValidColor(t)){this.setSelectedColor(t);if(this.onColorSelected){this.onColorSelected(this.getSelectedColor(),this)}}this.close()},handleDefaultActionClick:function(t){var o=this.getDefaultColor();this.applyColor(o)},handleBoxOver:function(t){var o=t.target;if(!BX.type.isDomNode(o)||!o.dataset.color){return}this.previewColor(o.dataset.color)},handleCustomInputKeyPress:function(t){if(!t.key.match("[A-Fa-f0-9]")&&!t.ctrlKey&&!t.metaKey){t.preventDefault()}this.resetError();if(t.keyCode===13){this.applyEditMode()}},handleCustomInputKeyUp:function(t){this.previewColor("#"+this.layout.customColorInput.value)},handleCustomInputPaste:function(t){var o=t.clipboardData||window.clipboardData||null;if(o){var e=o.getData("text");var i=BX.util.trim(e).replace(/#/g,"");if(this.isValidColor("#"+i)){this.layout.customColorInput.value=i}t.preventDefault()}},switchToEditMode:function(){if(this.layout.actions){this.layout.actions.classList.add("main-color-picker-edit-mode")}this.focusCustomInput()},resetEditMode:function(){if(this.layout.actions){this.layout.actions.classList.remove("main-color-picker-edit-mode")}},isEditMode:function(){return this.layout.actions&&this.layout.actions.classList.contains("main-color-picker-edit-mode")},applyEditMode:function(){var t=BX.util.trim(this.layout.customColorInput.value);t=t.replace(/#/g,"");t="#"+t;if(!this.isValidColor(t)){this.highlightError();this.focusCustomInput();return}this.applyColor(t)},previewColor:function(t){if(this.layout.preview&&this.isValidColor(t)){this.layout.preview.style.backgroundColor=t}},focusCustomInput:function(){if(this.layout.customColorInput){this.layout.customColorInput.focus()}},highlightError:function(){if(this.layout.customColorTextBox){this.layout.customColorTextBox.classList.add("main-color-picker-custom-textbox-error")}},resetError:function(){if(this.layout.customColorTextBox){this.layout.customColorTextBox.classList.remove("main-color-picker-custom-textbox-error")}},isValidColor:function(t){return BX.type.isNotEmptyString(t)&&t.match(/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/)},getFullColorCode:function(t){if(!this.isValidColor(t)){return null}if(t.length===4){return t.replace(/([a-f0-9])/gi,"$1$1")}return t}}})();
//# sourceMappingURL=colorpicker.map.js