(function(){"use strict";BX.namespace("BX.Kanban");BX.Kanban.Column=function(t){t=t||{};if(!BX.Kanban.Utils.isValidId(t.id)){throw new Error("BX.Kanban.Column: 'id' parameter is not valid.")}this.id=t.id;this.name=null;this.color=null;this.data=Object.create(null);this.total=null;this.isTotalFrozen=false;this.animate=t.animate||null;this.canEdit=null;this.canSort=null;this.canRemove=null;this.canAddItem=null;this.droppable=true;this.setOptions(t);this.items=[];this.draftItem=null;this.grid=null;this.selectedItems=[];this.page=1;this.layout={container:null,items:null,dragTarget:null,title:null,subTitle:null,subTitleAddButton:null,subTitleAddButtonText:null,subTitleAddButtonTextWrapper:null,total:null,name:null,titleArrow:null,color:null,editForm:null,fillColorButton:null,titleTextBox:null,addColumnButton:null,addColumnButtonAfter:null,addColumnButtonBefore:null,editButton:null,removeButton:null,ahaItem:null};this.rectArea=null;this.dragColumnOffset=null;this.dragColumnIndex=null;this.dragTargetColumn=null;this.confirmDialog=null;this.textBoxTimeout=null;this.colorChanged=false;this.hasBeenEdt=null;this.addItemTitleText=null;this.pagination=new BX.Kanban.Pagination(this);this.handleScrollWithThrottle=BX.Runtime.throttle(this.handleScroll,100,this)};BX.Kanban.Column.DEFAULT_COLOR="ace9fb";BX.Kanban.Column.prototype={getId:function(){return this.id},setOptions:function(t){if(!t){return}this.setName(t.name);this.setTotal(t.total);this.setColor(t.color);this.setData(t.data);var e=["canEdit","canSort","canRemove","canAddItem","droppable"];e.forEach((function(e){if(BX.type.isBoolean(t[e])){this[e]=t[e]}}),this)},setColor:function(t){if(BX.Kanban.Utils.isValidColor(t)){this.color=t.toLowerCase()}},getColor:function(){return this.color!==null?this.color:BX.Kanban.Column.DEFAULT_COLOR},setGrid:function(t){this.grid=t;BX.onCustomEvent(this,"Kanban.Column:onAddedToGrid",[this])},getGrid:function(){return this.grid},getPagination:function(){return this.pagination},addSelectedItems:function(){},addItem:function(t,e){if(!(t instanceof BX.Kanban.Item)){throw new Error("item must be an instance of BX.Kanban.Item")}t.setColumnId(this.getId());var i=BX.util.array_search(e,this.items);if(i>=0){this.items.splice(i,0,t)}else{this.items.push(t)}if(t.isCountable()){this.incrementTotal()}if(this.getGrid().isRendered()){this.render()}},addItems:function(t,e){this.selectedItems=t;for(var i in this.selectedItems){var n=this.selectedItems[i];n.setColumnId(this.getId());var a=BX.util.array_search(e,this.items);if(a>=0){this.items.splice(a,0,n)}else{this.items.push(n)}if(n.isCountable()){this.incrementTotal()}}if(this.getGrid().isRendered()){this.render();this.getGrid().cleanSelectedItems();this.getGrid().adjustMultiSelectMode()}},getItems:function(){return this.items},getItemsCount:function(){return this.items.reduce((function(t,e){return e.isCountable()&&e.isVisible()?t+1:t}),0)},getFirstItem:function(t){var e=this.getItems();for(var i=0;i<e.length;i++){var n=e[i];if(n.isVisible()||t===false){return n}}return null},getLastItem:function(t){var e=this.getItems();for(var i=e.length-1;i>=0;i--){var n=e[i];if(n.isVisible()||t===false){return n}}return null},getNextItemSibling:function(t,e){t=this.getGrid().getItem(t);var i=this.getItems();var n=BX.util.array_search(t,i);if(n===-1||!i[n+1]){return null}for(var a=n+1;a<i.length;a++){var o=i[a];if(o.isVisible()||e===false){return o}}return null},getPreviousItemSibling:function(t,e){t=this.getGrid().getItem(t);var i=this.getItems();var n=BX.util.array_search(t,i);if(n===-1||!i[n-1]){return null}for(var a=n-1;a>=0;a--){var o=i[a];if(o.isVisible()||e===false){return o}}return null},removeItem:function(t){var e=false;this.items=this.items.filter((function(i){if(i===t){e=true;return false}return true}));if(e){if(t.isCountable()&&t.isVisible()){this.decrementTotal()}if(this.getGrid().isRendered()){this.render()}}},removeSelectedItems:function(t){var e=false;for(var i in t){var n=t[i];this.items=this.items.filter((function(t){if(t===n){e=true;return false}return true}));if(e){if(n.isCountable()&&n.isVisible()){this.decrementTotal()}}}if(this.getGrid().isRendered()){this.render()}},removeItems:function(){this.items=[];this.total=null;BX.cleanNode(this.layout.items);this.render()},setName:function(t){if(BX.type.isNotEmptyString(t)){this.name=t}},getName:function(){return this.name},getData:function(){return this.data},setData:function(t){if(BX.type.isPlainObject(t)){this.data=t}},getGridData:function(){return this.getGrid().getData()},isEditable:function(){return this.canEdit!==null?this.canEdit:this.getGrid().canEditColumns()},isSortable:function(){return this.canSort!==null?this.canSort:this.getGrid().canSortColumns()},isRemovable:function(){return this.canRemove!==null?this.canRemove:this.getGrid().canRemoveColumns()},canAddItems:function(){return this.canAddItem!==null?this.canAddItem:this.getGrid().canAddItems()},getTotal:function(){return this.total!==null?this.total:this.getItemsCount()},incrementTotal:function(t){if(this.total!==null&&this.getGrid().isRendered()&&!this.isTotalFrozen){t=BX.type.isNumber(t)?t:1;this.total=Math.max(this.total+t,this.getItemsCount())}},decrementTotal:function(t){if(this.total!==null&&this.getGrid().isRendered()&&!this.isTotalFrozen){t=BX.type.isNumber(t)?t:1;this.total=Math.max(this.total-t,this.getItemsCount())}},freezeTotal:function(){this.isTotalFrozen=true},unfreezeTotal:function(){this.isTotalFrozen=false},setTotal:function(t){if(BX.type.isNumber(t)&&t>=0){this.total=t}},refreshTotal:function(){if(this.total!==null&&this.total<this.getItemsCount()){this.total=this.getItemsCount();this.renderTitle()}},hasLoading:function(){return this.total!==null&&this.total>this.getItemsCount()},getIndex:function(){return this.getGrid().getColumnIndex(this)},render:function(){var t=this.getTitleContainer();BX.cleanNode(t);t.appendChild(this.renderTitle());if(this.getGrid().canAddColumns()){t.appendChild(this.getAddColumnButton())}var e=this.getSubTitle();BX.cleanNode(e);var i=this.renderSubTitle();if(i!==null){e.appendChild(i)}this.cleanLayoutItems();var n=true;var a=document.createDocumentFragment();for(var o=0;o<this.items.length;o++){var s=this.items[o];if(s.isVisible()){n=false;a.appendChild(s.renderLayout())}}if(!n){this.layout.items.appendChild(a)}var r=this.getContainer();r.classList[n?"add":"remove"]("main-kanban-column-empty");r.classList[this.isDroppable()?"add":"remove"]("main-kanban-column-droppable");if(!this.getGrid().firstRenderComplete){this.hasBeenEdt=true}if((this.getContainer().classList.contains("main-kanban-column-droppable")||this.getContainer().classList.contains("main-kanban-column-draggable"))&&this.getGrid().firstRenderComplete&&!this.hasBeenEdt){t.classList.add("--animate-complete");var l=function(){t.classList.remove("--animate-complete");t.removeEventListener("animationend",l)}.bind(this);t.addEventListener("animationend",l);this.hasBeenEdt=true}if(this.getGrid().isRendered()){this.getPagination().adjust();this.getGrid().adjustEmptyStub()}BX.onCustomEvent(this.getGrid(),"Kanban.Column:render",[this]);return r},renderTitle:function(){var t=this.getDefaultTitleLayout();var e=BX.Kanban.Utils.isDarkColor(this.getColor());t.classList[e?"add":"remove"]("main-kanban-column-title-dark");this.layout.nameInner.textContent=this.getName();this.layout.total.textContent=this.getTotal();this.layout.color.style.backgroundColor="#"+this.getColor();this.layout.titleArrow.style.background="transparent url(data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%"+"20width%3D%2213%22%20height%3D%2232%22%20viewBox%3D%220%200%2013%2032%22%3E%3Cpath%20fill%3D%22%23"+this.getColor()+"%22%20fill-opacity%3D%221%22%20d%3D%22M0%200h3c2.8%200%204%203%204%203l6%2013-6%2013s-1.06%203-"+"4%203H0V0z%22/%3E%3C/svg%3E) no-repeat";return t},getDefaultTitleLayout:function(){if(this.layout.titleBody){return this.layout.titleBody}var t=this.getCustomTitleButtons();if(BX.type.isDomNode(t)){t=[t]}else if(!BX.type.isArray(t)){t=[]}this.layout.titleBody=BX.create("div",{attrs:{className:"main-kanban-column-title-wrapper"},children:[this.layout.color=BX.create("div",{attrs:{className:"main-kanban-column-title-bg",style:"background: #"+this.getColor()}}),this.layout.info=BX.create("div",{attrs:{className:"main-kanban-column-title-info"},children:[this.layout.name=BX.create("div",{attrs:{className:"main-kanban-column-title-text"},children:[this.getColumnTitle(),this.getTotalItem()]}),this.isEditable()?this.getEditButton():null].concat(t)}),this.isEditable()?this.getEditForm():null,this.layout.titleArrow=BX.create("span",{attrs:{className:"main-kanban-column-title-right"}})]});return this.layout.titleBody},getColumnTitle:function(){return this.layout.nameInner=BX.create("div",{attrs:{className:"main-kanban-column-title-text-inner"}})},getTotalItem:function(){return this.layout.total=BX.create("div",{attrs:{className:"main-kanban-column-total-item"}})},getEditButton:function(){if(this.layout.editButton){return this.layout.editButton}this.layout.editButton=BX.create("div",{attrs:{className:"main-kanban-column-edit"},events:{click:this.switchToEditMode.bind(this)}});return this.layout.editButton},getCustomTitleButtons:function(){return null},getRemoveButton:function(){if(this.layout.removeButton){return this.layout.removeButton}this.layout.removeButton=BX.create("div",{attrs:{className:"main-kanban-column-remove-button"},events:{click:this.handleRemoveButtonClick.bind(this)}});return this.layout.removeButton},getEditForm:function(){if(this.layout.editForm){return this.layout.editForm}this.layout.editForm=BX.create("div",{attrs:{className:"main-kanban-column-title-block-edit"},children:[this.getTitleTextBox(),this.getFillColorButton(),this.isRemovable()?this.getRemoveButton():null]});return this.layout.editForm},getTitleTextBox:function(){if(this.layout.titleTextBox){return this.layout.titleTextBox}this.layout.titleTextBox=BX.create("input",{attrs:{className:"main-kanban-column-title-input-edit",type:"text",placeholder:this.getGrid().getMessage("COLUMN_TITLE_PLACEHOLDER2"),autocomplete:"off",disabled:true},events:{blur:this.handleTextBoxBlur.bind(this),keydown:this.handleTextBoxKeyDown.bind(this)}});return this.layout.titleTextBox},getFillColorButton:function(){if(this.layout.fillColorButton){return this.layout.fillColorButton}this.layout.fillColorButton=BX.create("div",{attrs:{className:"main-kanban-column-color"},events:{click:this.showColorPicker.bind(this)}});return this.layout.fillColorButton},switchToEditMode:function(){this.disableDragging();this.getContainer().classList.add("main-kanban-column-edit-mode");this.getTitleTextBox().disabled=false;this.getTitleTextBox().value=this.getName();this.focusTextBox()},isEditModeEnabled:function(){return this.getContainer().classList.contains("main-kanban-column-edit-mode")},applyEditMode:function(){if(!this.isEditModeEnabled()){return}var t=BX.util.trim(this.getTitleTextBox().value);var e=false;if(t.length>0&&this.getName()!==t){e=true}if(e||this.colorChanged){if(e){this.setName(t)}BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onColumnUpdated",[this]);this.render()}this.colorChanged=false;this.enableDragging();this.getTitleTextBox().disabled=true;this.getContainer().classList.remove("main-kanban-column-edit-mode")},cleanAnimate:function(){if(!this.animate){return}this.animate=null;this.getContainer().classList.remove("--animate-"+this.animate);this.getContainer().removeEventListener("animationend")},handleTextBoxBlur:function(t){this.textBoxTimeout=setTimeout(function(){this.applyEditMode();this.textBoxTimeout=null}.bind(this),250)},stopTextBoxBlur:function(){if(this.textBoxTimeout){clearTimeout(this.textBoxTimeout)}},focusTextBox:function(){this.getTitleTextBox().focus()},handleTextBoxKeyDown:function(t){if(t.keyCode===13){this.applyEditMode()}},handleRemoveButtonClick:function(t){this.showRemoveConfirmDialog()},handleScroll(t){BX.Event.EventEmitter.emit(this.getGrid(),"Kanban.Column:onScroll",{event:t})},showColorPicker:function(){this.stopTextBoxBlur();this.getColorPicker().open()},getColorPicker:function(){if(this.colorPicker){return this.colorPicker}this.colorPicker=new BX.ColorPicker({bindElement:this.getFillColorButton(),onColorSelected:this.onColorSelected.bind(this),popupOptions:{events:{onPopupClose:this.focusTextBox.bind(this)}}});return this.colorPicker},onColorSelected:function(t){this.setColor(t.substr(1));this.colorChanged=true;this.render()},getConfirmDialog:function(){if(this.confirmDialog){return this.confirmDialog}this.confirmDialog=new BX.PopupWindow("main-kanban-confirm-"+BX.util.getRandomString(5),null,{titleBar:this.getGrid().getMessage("REMOVE_COLUMN_CONFIRM_TITLE"),content:this.getGrid().getMessage("REMOVE_COLUMN_CONFIRM_DESC"),width:400,autoHide:false,overlay:true,closeByEsc:true,closeIcon:true,draggable:{restrict:true},buttons:[new BX.PopupWindowButton({text:this.getGrid().getMessage("REMOVE_BUTTON"),id:"main-kanban-confirm-remove-button",className:"popup-window-button-create",events:{click:this.handleConfirmButtonClick.bind(this)}}),new BX.PopupWindowButtonLink({text:this.getGrid().getMessage("CANCEL_BUTTON"),className:"popup-window-button-link-cancel",events:{click:function(){this.popupWindow.close()}}})],events:{onPopupClose:function(){this.focusTextBox();this.confirmDialog.destroy();this.confirmDialog=null}.bind(this)}});return this.confirmDialog},handleConfirmButtonClick:function(){var t=this.getConfirmDialog();var e=t.getButton("main-kanban-confirm-remove-button");if(e.getContainer().classList.contains("popup-window-button-wait")){return}e.addClassName("popup-window-button-wait");var i=this.getGrid().getEventPromise("Kanban.Grid:onColumnRemovedAsync",null,function(i){this.getGrid().removeColumn(this);e.removeClassName("popup-window-button-wait");t.close()}.bind(this),function(i){t.setContent(i);e.getContainer().style.display="none"}.bind(this));i.fulfill(this)},showRemoveConfirmDialog:function(){this.stopTextBoxBlur();var t=this.getConfirmDialog();t.show()},handleAddColumnButtonClick:function(t){var e=this.getGrid().addColumn({id:"kanban-new-column-"+BX.util.getRandomString(5),type:"BX.Kanban.DraftColumn",canSort:false,canAddItem:false,droppable:false,targetId:this.getGrid().getNextColumnSibling(this)});e.switchToEditMode()},renderSubTitle:function(){if(this.layout.subTitleAddButton){return this.layout.subTitleAddButton}var t;this.layout.subTitleAddButton=BX.create("div",{attrs:{className:"main-kanban-column-subtitle-box"},children:[this.canAddItems()?t=BX.create("div",{attrs:{className:"main-kanban-column-add-item-button"},events:{click:this.handleAddItemButtonClick.bind(this)},children:[this.getGrid().getAddItemTitleText()?this.subTitleAddButtonTextWrapper=BX.create("div",{props:{className:"main-kanban-column-add-item-button-text"},children:[this.subTitleAddButtonText=BX.create("span",{text:this.getGrid().getAddItemTitleText()})]}):null]}):null]});return this.layout.subTitleAddButton},handleAddItemButtonClick:function(t){var e=this.getFirstItem(false);if(e){var i=e.getId().indexOf("kanban-new-item-")===0;if(i){e.applyDraftEditMode();return}}this.addDraftItem(e)},cleanLayoutItems:function(){BX.cleanNode(this.layout.items)},getDraftItem:function(){return this.draftItem},addDraftItem:function(t){var e="kanban-new-item-"+this.getId();if(this.getGrid().getItem(e)){return null}if(!t){t=this.getFirstItem(false)}var i=null;if(t instanceof BX.Kanban.Item&&t.getColumn()===this){i=t}this.draftItem=this.getGrid().addItem({id:e,type:"BX.Kanban.DraftItem",columnId:this.getId(),draggable:false,droppable:false,countable:false,targetId:i});if(this.draftItem){this.draftItem.focusDraftTextArea()}return this.draftItem},removeDraftItem:function(){if(this.draftItem!==null){this.getGrid().removeItem(this.draftItem);this.draftItem=null}},getContainer:function(){if(this.layout.container!==null){return this.layout.container}this.layout.container=BX.create("div",{attrs:{className:this.animate?"main-kanban-column"+" --animate-"+this.animate:"main-kanban-column"},children:[this.getHeader(),this.getBody()],events:{mouseenter:function(){if(this.subTitleAddButtonText&&this.subTitleAddButtonTextWrapper){this.subTitleAddButtonTextWrapper.style.width=this.subTitleAddButtonText.offsetWidth+"px"}}.bind(this),mouseleave:function(){if(this.subTitleAddButtonText&&this.subTitleAddButtonTextWrapper){this.subTitleAddButtonTextWrapper.style.width=null}}.bind(this)}});this.makeDraggable();this.makeDroppable();return this.layout.container},getHeader:function(){if(this.layout.header){return this.layout.header}this.layout.header=BX.create("div",{attrs:{className:"main-kanban-column-header"},children:[this.getTitleContainer(),this.getSubTitle()]});return this.layout.header},getBody:function(){if(this.layout.body){return this.layout.body}this.layout.body=BX.create("div",{attrs:{className:"main-kanban-column-body","data-id":this.getId(),"data-type":"column"},events:{wheel:BX.delegate(this.blockPageScroll,this),scroll:this.handleScrollWithThrottle.bind(this)},children:[this.getItemsContainer(),this.getDragTarget()]});return this.layout.body},getTitleContainer:function(t){if(this.layout.title){return this.layout.title}this.layout.title=BX.create("div",{attrs:{className:"main-kanban-column-title"}});return this.layout.title},getSubTitle:function(){if(!this.layout.subTitle){this.layout.subTitle=BX.create("div",{attrs:{className:"main-kanban-column-subtitle"}})}return this.layout.subTitle},getAddColumnButton:function(){if(this.layout.addColumnButton){return this.layout.addColumnButton}this.layout.addColumnButton=BX.create("div",{attrs:{className:"main-kanban-column-title-add-column"},children:[this.layout.addColumnButtonBefore=BX.create("div",{props:{className:"main-kanban-column-title-add-column-before"}}),this.layout.addColumnButtonAfter=BX.create("div",{props:{className:"main-kanban-column-title-add-column-after"}})],events:{click:this.handleAddColumnButtonClick.bind(this)}});return this.layout.addColumnButton},handlerHoverClass:function(t){if(!t){return}t.addEventListener("mouseenter",(function(){t.classList.add("--hover")}));t.addEventListener("mouseleave",(function(){t.classList.remove("--hover")}))},getItemsContainer:function(){if(!this.layout.items){this.layout.items=BX.create("div",{attrs:{className:"main-kanban-column-items"}})}return this.layout.items},onAhaMode:function(){this.getBody().appendChild(this.getAhaItem())},offAhaMode:function(){this.getBody().removeChild(this.getAhaItem())},getAhaItem:function(){if(!this.layout.ahaItem){this.layout.ahaItem=BX.create("div",{props:{className:"main-kanban-item-aha"}})}return this.layout.ahaItem},getDragTarget:function(){if(!this.layout.dragTarget){this.layout.dragTarget=BX.create("div",{attrs:{className:"main-kanban-column-drag-target"}})}return this.layout.dragTarget},blockPageScroll:function(t){var e=this.getBody();if(e.scrollHeight>e.offsetHeight){var i=t.deltaY||t.detail||t.wheelDelta;if(i<0&&e.scrollTop===0){t.preventDefault()}if(i>0&&e.scrollHeight-e.clientHeight-e.scrollTop<=1){t.preventDefault()}}},makeDraggable:function(){if(!this.isSortable()){return}var t=this.getTitleContainer();t.onbxdragstart=BX.delegate(this.onColumnDragStart,this);t.onbxdrag=BX.delegate(this.onColumnDrag,this);t.onbxdragstop=BX.delegate(this.onColumnDragStop,this);this.enableDragging()},makeDroppable:function(){if(!this.isDroppable()){return}var t=this.getBody();t.onbxdestdraghover=BX.delegate(this.onDragEnter,this);t.onbxdestdraghout=BX.delegate(this.onDragLeave,this);t.onbxdestdragfinish=BX.delegate(this.onDragDrop,this);t.onbxdestdragstop=BX.delegate(this.onItemDragEnd,this);jsDD.registerDest(t,40);this.disableDropping()},disableDragging:function(){if(this.isSortable()){jsDD.unregisterObject(this.getTitleContainer())}},enableDragging:function(){if(this.isSortable()){jsDD.registerObject(this.getTitleContainer())}},disableDropping:function(){if(this.isDroppable()){jsDD.disableDest(this.getBody())}},enableDropping:function(){if(this.isDroppable()){jsDD.enableDest(this.getBody())}},isDraggable:function(){return this.isSortable()},isDroppable:function(){return this.droppable},onDragEnter:function(t,e,i){var n=this.getGrid().getItemByElement(t);this.showDragTarget(n.getBodyContainer().offsetHeight)},onDragLeave:function(t,e,i){this.hideDragTarget()},onDragDrop:function(t,e,i){if(this.getGrid().getSelectedItems().length>0){this.onDragDropMulti(this.getGrid().getSelectedItems());return}this.hideDragTarget();var n=this.getGrid().getItemByElement(t);var a=new BX.Kanban.DragEvent;a.setItem(n);a.setTargetColumn(this);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onBeforeItemMoved",[a]);if(!a.isActionAllowed()){return}var o=this.getGrid().moveItem(n,this);if(o){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemMoved",[n,this,null])}},onDragDropMulti:function(t,e,i){this.hideDragTarget();var n=t;var a=new BX.Kanban.DragEvent;a.setItems(n);a.setTargetColumn(this);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onBeforeItemMoved",[a]);if(!a.isActionAllowed()){return}var o=this.getGrid().moveItems(n,this);if(o){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemsMoved",[n,this,null])}},onItemDragEnd:function(t,e,i){this.disableDropping()},onColumnDragStart:function(){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onColumnDragStart",[this]);this.getContainer().classList.add("main-kanban-column-draggable");this.dragColumnOffset=jsDD.start_x-this.getRectArea().left;this.dragColumnIndex=this.getIndex();this.dragTargetColumn=this.dragTargetColumn||this},onColumnDrag:function(t,e){this.getContainer().style.transform="translateX("+(t-this.dragColumnOffset-this.getRectArea().left)+"px)";var i=this.getGrid().getColumns();var n=this.getRectArea().width;for(var a in i){var o=i[a];if(o===this||!o.isSortable()){continue}var s=o.getContainer();var r=o.getRectArea();var l=r.middle;if(t>l&&a>this.dragColumnIndex&&s.style.transform!=="translateX("+-n+"px)"){s.style.transition="300ms";s.style.transform="translateX("+-n+"px)";this.dragTargetColumn=this.getGrid().getNextColumnSibling(o);o.resetRectArea()}if(t<l&&a<this.dragColumnIndex&&s.style.transform!=="translateX("+n+"px)"){s.style.transition="300ms";s.style.transform="translateX("+n+"px)";this.dragTargetColumn=o;o.resetRectArea()}var u=t<l&&a>this.dragColumnIndex&&s.style.transform!==""&&s.style.transform!=="translateX(0px)";var d=t>l&&a<this.dragColumnIndex&&s.style.transform!==""&&s.style.transform!=="translateX(0px)";if(d||u){s.style.transition="300ms";s.style.transform="translateX(0px)";this.dragTargetColumn=u?o:this.getGrid().getNextColumnSibling(o);o.resetRectArea()}}},onColumnDragStop:function(t,e){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onColumnDragStop",[this]);var i=this.getGrid().moveColumn(this,this.dragTargetColumn);if(i){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onColumnMoved",[this,this.getGrid().getNextColumnSibling(this)])}this.getContainer().classList.remove("main-kanban-column-draggable");var n=this.getGrid().getColumns();for(var a in n){var o=n[a];var s=o.getContainer();o.resetRectArea();s.style.removeProperty("transition");s.style.removeProperty("transform")}this.getGrid().adjustEars()},getRectArea:function(){if(!this.rectArea){this.rectArea=BX.pos(this.getContainer());this.rectArea.middle=this.rectArea.left+this.rectArea.width/2}return this.rectArea},resetRectArea:function(){this.rectArea=null},showDragTarget:function(t){this.getContainer().classList.add("main-kanban-column-target-shown");this.getDragTarget().style.height=t+"px"},hideDragTarget:function(){this.getContainer().classList.remove("main-kanban-column-target-shown");this.getDragTarget().style.removeProperty("height")}};BX.Kanban.DraftColumn=function(t){BX.Kanban.Column.apply(this,arguments);this.asyncEventStarted=false;BX.addCustomEvent(this,"Kanban.Column:onAddedToGrid",this.onAddedToGrid.bind(this))};BX.Kanban.DraftColumn.lastColorIndex=-1;BX.Kanban.DraftColumn.prototype={__proto__:BX.Kanban.Column.prototype,constructor:BX.Kanban.DraftColumn,applyEditMode:function(){if(this.asyncEventStarted){return}var t=BX.util.trim(this.getTitleTextBox().value);if(!t.length){t=this.getGrid().getMessage("COLUMN_TITLE_PLACEHOLDER")}this.setName(t);this.getContainer().classList.add("main-kanban-column-disabled");this.getTitleTextBox().disabled=true;this.asyncEventStarted=true;var e=this.getGrid().getEventPromise("Kanban.Grid:onColumnAddedAsync",null,function(t){if(!BX.Kanban.Utils.isValidId(t.targetId)){var e=this.getGrid().getNextColumnSibling(this);if(e){t.targetId=e.getId()}}this.getGrid().removeColumn(this);this.getGrid().addColumn(t)}.bind(this),function(t){this.getGrid().removeColumn(this)}.bind(this));e.fulfill(this)},handleRemoveButtonClick:function(t){this.stopTextBoxBlur();this.getGrid().removeColumn(this)},onAddedToGrid:function(){this.setColor(this.getNextColor())},getNextColor:function(){var t=BX.Kanban.Utils.getDefaultColors();if(!t.length){return null}if(BX.Kanban.DraftColumn.lastColorIndex===-1){var e=this.getGrid().getColumns();for(var i=e.length-1;i>=0;i--){var n=e[i];var a=BX.util.array_search(n.getColor(),t);if(a!==-1){BX.Kanban.DraftColumn.lastColorIndex=a;break}}}BX.Kanban.DraftColumn.lastColorIndex=t[BX.Kanban.DraftColumn.lastColorIndex+1]?BX.Kanban.DraftColumn.lastColorIndex+1:0;return t[BX.Kanban.DraftColumn.lastColorIndex]}};BX.Kanban.Pagination=function(t){this.column=t;this.timer=null;this.page=1;this.loadingInProgress=false;this.layout={topButton:null,bottomButton:null,loader:null};BX.addCustomEvent(t,"Kanban.Column:onAddedToGrid",this.init.bind(this))};BX.Kanban.Pagination.prototype={init:function(){var t=this.getColumn();var e=t.getContainer();var i=t.getBody();e.appendChild(this.getTopButton());e.appendChild(this.getBottomButton());i.appendChild(this.getLoader());var n=BX.delegate(this.adjust,this);BX.bind(i,"scroll",BX.throttle(n,150));BX.bind(window,"scroll",BX.throttle(n,150));BX.addCustomEvent("Kanban.Grid:onFirstRender",n)},adjust:function(){var t=this.getColumn();var e=t.getContainer();var i=t.getBody();var n=i.scrollHeight;var a=i.offsetHeight;var o=i.scrollTop;var s=i.scrollTop>0;var r=n>a+o;e.classList[s?"add":"remove"]("main-kanban-column-top-button-shown");e.classList[r?"add":"remove"]("main-kanban-column-bottom-button-shown");if(e.classList.contains("main-kanban-column-top-button-shown")){this.getTopButton().style.top=this.getColumn().getBody().offsetTop+"px"}jsDD.refreshDestArea();var l=this.getLoader();if(!this.loadingInProgress&&t.hasLoading()&&l.offsetTop<o+a){this.showLoader();this.loadItems()}},loadItems:function(){this.loadingInProgress=true;var t=this.getColumn().getGrid().getEventPromise("Kanban.Grid:onColumnLoadAsync",null,this.onPromiseFulfilled.bind(this),this.onPromiseRejected.bind(this));t.fulfill(this.getColumn())},onPromiseFulfilled:function(t){this.hideLoader();this.processPromiseResult(t)},onPromiseRejected:function(t){this.hideLoader()},processPromiseResult:function(t){if(!BX.type.isArray(t)||!t.length){return}var e=this.getColumn();e.freezeTotal();e.getGrid().setRenderStatus(false);var i=e.getBody().scrollTop;for(var n=0;n<t.length;n++){var a=t[n];e.getGrid().addItem(a)}e.render();e.getBody().scrollTop=i;e.getGrid().setRenderStatus(true);e.unfreezeTotal();e.refreshTotal();this.page++;this.loadingInProgress=false;this.adjust()},getColumn:function(){return this.column},getPage:function(){return this.page},getTopButton:function(){if(this.layout.topButton){return this.layout.topButton}this.layout.topButton=BX.create("div",{attrs:{className:"main-kanban-column-top-button"},events:{mouseenter:BX.delegate(this.scrollUp,this),mouseleave:BX.delegate(this.stopScroll,this)}});return this.layout.topButton},getBottomButton:function(){if(this.layout.bottomButton){return this.layout.bottomButton}this.layout.bottomButton=BX.create("div",{attrs:{className:"main-kanban-column-bottom-button"},events:{mouseenter:BX.delegate(this.scrollDown,this),mouseleave:BX.delegate(this.stopScroll,this)}});return this.layout.bottomButton},getLoader:function(){if(this.layout.loader){return this.layout.loader}this.layout.loader=BX.create("div",{attrs:{className:"main-kanban-loader"},html:'<div class="main-kanban-loader-outer">'+'<div class="main-kanban-loader-inner">'+'<svg class="main-kanban-loader-circle" viewBox="25 25 50 50">'+"<circle "+'class="main-kanban-loader-path" cx="50" cy="50" r="20" fill="none" '+'stroke-width="1" stroke-miterlimit="10"'+"/>"+"</svg>"+"</div>"+"</div>"});return this.layout.loader},showLoader:function(){this.getLoader().classList.add("main-kanban-loader-shown")},hideLoader:function(){this.getLoader().classList.remove("main-kanban-loader-shown")},scrollUp:function(){if(this.getColumn().getGrid().getDragMode()!==BX.Kanban.DragMode.ITEM){return}this.timer=setInterval(BX.delegate((function(){this.getColumn().getBody().scrollTop-=10}),this),20)},scrollDown:function(){if(this.getColumn().getGrid().getDragMode()!==BX.Kanban.DragMode.ITEM){return}this.timer=setInterval(BX.delegate((function(){this.getColumn().getBody().scrollTop+=10}),this),20)},stopScroll:function(){clearInterval(this.timer)}}})();
//# sourceMappingURL=column.map.js