(function(){"use strict";BX.namespace("BX.Kanban");BX.Kanban.Grid=function(t){if(!BX.type.isPlainObject(t)){throw new Error("BX.Kanban.Grid: 'options' is not an object.")}this.options=t;if(!BX.type.isDomNode(t.renderTo)){throw new Error("BX.Kanban.Grid: 'renderTo' is not a DOMNode.")}this.renderTo=t.renderTo;this.rendered=false;this.layout={outerContainer:null,innerContainer:null,gridContainer:null,earLeft:null,earRight:null,emptyStub:null,loader:null,leftShadow:null,rightShadow:null};this.emptyStubItems=t.emptyStubItems;this.itemType=this.getItemType(t.itemType);this.columnType=this.getColumnType(t.columnType);this.messages=BX.type.isPlainObject(t.messages)?t.messages:Object.create(null);this.columns=Object.create(null);this.columnsOrder=[];this.items=Object.create(null);this.data=BX.type.isPlainObject(t.data)?t.data:Object.create(null);this.bgColor=BX.Kanban.Utils.isValidColor(t.bgColor)||t.bgColor==="transparent"?t.bgColor:"ffffff";this.earTimer=null;this.firstRenderComplete=null;this.dragMode=BX.Kanban.DragMode.NONE;this.multiSelect=t.multiSelect;this.ahaMode=null;this.selectedItems=[];this.addItemTitleText=t.addItemTitleText;this.addDraftItemInfo=t.addDraftItemInfo;this.columnsRevert=t.columnsRevert;this.canAddColumn=false;this.canEditColumn=false;this.canSortColumn=false;this.canRemoveColumn=false;this.canAddItem=false;this.canSortItem=false;this.dropZoneArea=new BX.Kanban.DropZoneArea(this,{dropZoneType:t.dropZoneType,dropZoneTimeout:t.dropZoneTimeout});this.data=Object.create(null);this.setData(t.data);this.loadData(t);if(t.events){for(var e in t.events){if(t.events.hasOwnProperty(e)){BX.addCustomEvent(this,e,t.events[e])}}}this.bindEvents();BX.addCustomEvent(this,"Kanban.Grid:onItemDragStart",BX.delegate(this.onItemDragStart,this));BX.addCustomEvent(this,"Kanban.Grid:onItemsDragStart",BX.delegate(this.onItemDragStart,this));BX.addCustomEvent(this,"Kanban.Grid:onItemDragStop",BX.delegate(this.onItemDragStop,this));BX.addCustomEvent(this,"Kanban.Grid:onColumnDragStart",BX.delegate(this.onColumnDragStart,this));BX.addCustomEvent(this,"Kanban.Grid:onColumnDragStop",BX.delegate(this.onColumnDragStop,this));if(this.multiSelect){BX.addCustomEvent(this,"Kanban.Item:select",this.addSelectedItem.bind(this));BX.addCustomEvent(this,"Kanban.Item:select",this.adjustMultiSelectMode.bind(this));BX.addCustomEvent(this,"Kanban.Item:unSelect",this.removeSelectedItem.bind(this));BX.addCustomEvent(this,"Kanban.Item:unSelect",this.adjustMultiSelectMode.bind(this));window.addEventListener("keydown",function(t){if(BX.Kanban.Utils.getKeyDownName(t.keyCode)==="Escape"&&this.getSelectedItems().length>0){this.cleanSelectedItems();this.adjustMultiSelectMode();BX.PreventDefault(t)}}.bind(this));window.addEventListener("click",function(t){if(BX.findParent(t.target,{attr:{"data-element":"kanban-element"}})||t.target.getAttribute("data-element")==="kanban-element"){return}this.cleanSelectedItems();this.adjustMultiSelectMode()}.bind(this))}};BX.Kanban.DragMode={NONE:0,ITEM:1,COLUMN:2};BX.Kanban.Grid.prototype={addColumn:function(t){t=t||{};if(this.getColumn(t.id)!==null){return null}var e=this.getColumnType(t.type);var n=new e(t);if(!(n instanceof BX.Kanban.Column)){throw new Error("Column type must be an instance of BX.Kanban.Column")}n.setGrid(this);this.columns[n.getId()]=n;var i=this.getColumn(t.targetId);var a=BX.util.array_search(i,this.columnsOrder);if(a>=0){this.columnsOrder.splice(a,0,n)}else{this.columnsOrder.push(n)}if(this.isRendered()){if(i){this.getGridContainer().insertBefore(n.render(),i.getContainer())}else{this.getGridContainer().appendChild(n.render())}}return n},getAddItemTitleText:function(){return this.addItemTitleText},getAddDraftItemInfo:function(){return this.addDraftItemInfo},isAhaMode:function(){return this.ahaMode},onAhaMode:function(){this.getGridContainer().classList.add("main-kanban-aha");this.ahaMode=true},offAhaMode:function(){this.getGridContainer().classList.remove("main-kanban-aha");this.ahaMode=false},removeColumn:function(t){t=this.getColumn(t);if(!t){return false}this.removeColumnItems(t);this.columnsOrder=this.columnsOrder.filter((function(e){return t!==e}));delete this.columns[t.getId()];BX.remove(t.getContainer());return true},bindEvents:function(){},updateColumn:function(t,e){t=this.getColumn(t);if(!t){return false}t.setOptions(e);t.render();return true},getNextColumnSibling:function(t){var e=this.getColumnIndex(t);var n=this.getColumns();return e!==-1&&n[e+1]?n[e+1]:null},getPreviousColumnSibling:function(t){var e=this.getColumnIndex(t);var n=this.getColumns();return e>0&&n[e-1]?n[e-1]:null},adjustMultiSelectMode:function(){if(this.selectedItems.length>0){this.onMultiSelect()}else{this.offMultiSelect()}},addSelectedItem:function(t){if(!(t instanceof BX.Kanban.Item)){throw new Error("Item type must be an instance of BX.Kanban.Item")}this.selectedItems.push(t)},removeSelectedItem:function(t){if(!(t instanceof BX.Kanban.Item)){throw new Error("Item type must be an instance of BX.Kanban.Item")}if(this.selectedItems.indexOf(t)>=0){this.selectedItems.splice(this.selectedItems.indexOf(t),1)}},addItem:function(t){t=t||{};var e=this.getColumn(t.columnId);if(!e){return null}var n=this.getItemType(t.type);var i=new n(t);if(!(i instanceof BX.Kanban.Item)){throw new Error("Item type must be an instance of BX.Kanban.Item")}if(this.items[i.getId()]){return null}i.setGrid(this);this.items[i.getId()]=i;var a=this.getItem(t.targetId);e.addItem(i,a);t.type==="BX.Kanban.DraftItem"?BX.onCustomEvent(this,"Kanban.Grid:addDraftItem",[i]):BX.onCustomEvent(this,"Kanban.Grid:addItem",[i]);return i},removeItem:function(t){var e=this.getItem(t);if(e){var n=e.getColumn();delete this.items[e.getId()];n.removeItem(e);e.dispose()}return e},removeColumnItems:function(t){t=this.getColumn(t);var e=t.getItems();t.removeItems();e.forEach((function(t){this.removeItem(t)}),this)},removeItems:function(){this.getColumns().forEach((function(t){this.removeColumnItems(t)}),this)},updateItem:function(t,e){t=this.getItem(t);if(!t){return false}if(BX.Kanban.Utils.isValidId(e.columnId)&&e.columnId!==t.getColumn().getId()){this.moveItem(t,this.getColumn(e.columnId),this.getItem(e.targetId))}var n=["UPDATE",{task:t,options:e}];BX.onCustomEvent(window,"tasksTaskEvent",n);t.setOptions(e);t.render();return true},hideItem:function(t){t=this.getItem(t);if(!t||!t.isVisible()){return false}t.setOptions({visible:false});if(t.isCountable()){t.getColumn().decrementTotal()}t.getColumn().render();return true},unhideItem:function(t){t=this.getItem(t);if(!t||t.isVisible()){return false}t.setOptions({visible:true});if(t.isCountable()){t.getColumn().incrementTotal()}t.getColumn().render();return true},getSelectedItems:function(){return this.selectedItems},cleanSelectedItems:function(){for(var t=0;t<this.getSelectedItems().length;t++){this.getSelectedItems()[t].unSelect(true)}this.selectedItems=[]},isMultiSelect:function(){return this.multiSelect},onMultiSelect:function(){this.getGridContainer().classList.add("main-kanban-multiselect-mode")},offMultiSelect:function(){this.getGridContainer().classList.remove("main-kanban-multiselect-mode")},getColumn:function(t){var e=t instanceof BX.Kanban.Column?t.getId():t;return this.columns[e]?this.columns[e]:null},getColumns:function(){return this.columnsOrder},getColumnsCount:function(){return this.columnsOrder.length},getColumnIndex:function(t){t=this.getColumn(t);return BX.util.array_search(t,this.getColumns())},getItem:function(t){var e=t instanceof BX.Kanban.Item?t.getId():t;return this.items[e]?this.items[e]:null},getItemByElement:function(t){if(BX.type.isDomNode(t)&&t.dataset.id&&t.dataset.type==="item"){return this.getItem(t.dataset.id)}return null},getItems:function(){return this.items},getItemType:function(t){var e=BX.Kanban.Utils.getClass(t);if(BX.type.isFunction(e)){return e}return this.itemType||BX.Kanban.Item},getColumnType:function(t){var e=BX.Kanban.Utils.getClass(t);if(BX.type.isFunction(e)){return e}return this.columnType||BX.Kanban.Column},getDropZoneArea:function(){return this.dropZoneArea},getData:function(){return this.data},setData:function(t){if(BX.type.isPlainObject(t)){this.data=t}},getBgColor:function(){return this.bgColor},getBgColorStyle:function(){return this.getBgColor()==="transparent"?this.getBgColor():"#"+this.getBgColor()},getOptions:function(){return this.options},loadData:function(t){var e=this.isRendered();this.setRenderStatus(false);var n=["canAddColumn","canEditColumn","canSortColumn","canRemoveColumn","canAddItem","canSortItem"];n.forEach((function(e){if(BX.type.isBoolean(t[e])){this[e]=t[e]}}),this);if(BX.type.isArray(t.columns)){t.columns.forEach((function(t){if(t&&BX.Kanban.Utils.isValidId(t.id)&&this.getColumn(t.id)){this.updateColumn(t.id,t)}else{this.addColumn(t)}}),this)}if(BX.type.isArray(t.items)){t.items.forEach((function(t){if(t&&BX.Kanban.Utils.isValidId(t.id)&&this.getItem(t.id)){this.updateItem(t.id,t)}else{this.addItem(t)}}),this)}if(BX.type.isArray(t.dropZones)){t.dropZones.forEach((function(t){if(t&&BX.Kanban.Utils.isValidId(t.id)&&this.getDropZoneArea().getDropZone(t.id)){this.getDropZoneArea().updateDropZone(t.id,t)}else{this.getDropZoneArea().addDropZone(t)}}),this)}if(e){this.draw()}},draw:function(){var t=document.createDocumentFragment();var e=this.getColumns();for(var n=0;n<e.length;n++){var i=e[n];t.appendChild(i.render())}BX.cleanNode(this.getGridContainer());this.getGridContainer().appendChild(t);this.getDropZoneArea().render();if(!this.isRendered()){this.renderLayout();this.adjustLayout();this.setRenderStatus(true);BX.onCustomEvent(this,"Kanban.Grid:onFirstRender",[this])}else{this.adjustLayout()}this.adjustEmptyStub();BX.onCustomEvent(this,"Kanban.Grid:onRender",[this]);this.firstRenderComplete=true;if(this.isAhaMode()){this.renderTo.classList.add("main-kanban-aha-mode")}},renderLayout:function(){if(this.getOuterContainer().parentNode){return}var t=this.getInnerContainer();t.appendChild(this.getEmptyStub());t.appendChild(this.getLeftEar());t.appendChild(this.getRightEar());t.appendChild(this.getDropZoneArea().getContainer());t.appendChild(this.getLoader());t.appendChild(this.getGridContainer());var e=this.getOuterContainer();e.appendChild(t);this.renderTo.appendChild(this.getOuterContainer());BX.bind(window,"resize",this.adjustLayout.bind(this));BX.bind(window,"scroll",this.adjustHeight.bind(this))},isRendered:function(){return this.rendered},setRenderStatus:function(t){if(BX.type.isBoolean(t)){this.rendered=t}},getLeftEar:function(){if(this.layout.earLeft){return this.layout.earLeft}this.layout.earLeft=BX.create("div",{attrs:{className:"main-kanban-ear-left"},events:{mouseenter:this.scrollToLeft.bind(this),mouseleave:this.stopAutoScroll.bind(this)}});return this.layout.earLeft},getRightEar:function(){if(this.layout.earRight){return this.layout.earRight}this.layout.earRight=BX.create("div",{attrs:{className:"main-kanban-ear-right"},events:{mouseenter:this.scrollToRight.bind(this),mouseleave:this.stopAutoScroll.bind(this)}});return this.layout.earRight},getRenderToContainer:function(){return this.renderTo},getOuterContainer:function(){if(this.layout.outerContainer){return this.layout.outerContainer}this.layout.outerContainer=BX.create("div",{props:{className:this.columnsRevert?"main-kanban --columns-revert":"main-kanban"},style:{backgroundColor:this.getBgColorStyle()}});return this.layout.outerContainer},getInnerContainer:function(){if(this.layout.innerContainer){return this.layout.innerContainer}this.layout.innerContainer=BX.create("div",{props:{className:"main-kanban-inner"},children:[this.getLeftShadowContainer(),this.getRightShadowContainer()],style:{backgroundColor:this.getBgColorStyle()}});return this.layout.innerContainer},getRightShadowContainer:function(){if(!this.layout.rightShadow){this.layout.rightShadow=BX.create("div",{props:{className:"main-kanban-inner-shadow main-kanban-inner-shadow-right"}})}return this.layout.rightShadow},getLeftShadowContainer:function(){if(!this.layout.leftShadow){this.layout.leftShadow=BX.create("div",{props:{className:"main-kanban-inner-shadow main-kanban-inner-shadow-left"}})}return this.layout.leftShadow},getGridContainer:function(){if(!this.layout.gridContainer){this.layout.gridContainer=BX.create("div",{props:{className:"main-kanban-grid"},events:{scroll:this.adjustEars.bind(this)}})}return this.layout.gridContainer},getEmptyStub:function(){if(this.layout.emptyStub){return this.layout.emptyStub}if(this.emptyStubItems&&typeof this.emptyStubItems==="object"){this.layout.emptyStub=BX.create("div",{attrs:{className:"main-kanban-no-data"},children:[BX.create("div",{attrs:{className:"main-kanban-no-data-inner"},children:[BX.create("div",{attrs:{className:"main-kanban-no-data-title"},text:this.emptyStubItems["title"]}),BX.create("div",{attrs:{className:"main-kanban-no-data-description"},text:this.emptyStubItems["description"]})]})]});return this.layout.emptyStub}this.layout.emptyStub=BX.create("div",{attrs:{className:"main-kanban-no-data"},children:[BX.create("div",{attrs:{className:"main-kanban-no-data-inner"},children:[BX.create("div",{attrs:{className:"main-kanban-no-data-image"}}),BX.create("div",{attrs:{className:"main-kanban-no-data-text"},text:this.getMessage("NO_DATA")})]})]});return this.layout.emptyStub},getLoader:function(){if(this.layout.loader){return this.layout.loader}this.layout.loader=BX.create("div",{props:{className:"main-kanban-loader-container"},html:'<svg class="main-kanban-loader-circular" viewBox="25 25 50 50">'+'<circle class="main-kanban-loader-path" cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"/>'+"</svg>"});return this.layout.loader},adjustLayout:function(){this.adjustWidth();this.adjustHeight();this.adjustEars()},adjustEars:function(){var t=this.getGridContainer();var e=t.scrollLeft;var n=e>0;var i=t.scrollWidth>Math.round(e+t.offsetWidth);this.getOuterContainer().classList[n?"add":"remove"]("main-kanban-left-ear-shown");this.getOuterContainer().classList[i?"add":"remove"]("main-kanban-right-ear-shown")},adjustWidth:function(){this.getOuterContainer().style.width=this.renderTo.offsetWidth+"px"},adjustHeight:function(){var t=this.getOuterContainer();var e=this.getInnerContainer();if(t.getBoundingClientRect().top>=15){var n=document.documentElement.clientHeight-e.getBoundingClientRect().top;e.style.height=n+"px";if(e.classList.contains("main-kanban-fixed")){BX.onCustomEvent(this,"Kanban.Grid:onFixedModeEnd",[this])}t.style.minHeight=document.documentElement.clientHeight+"px";e.style.removeProperty("top");e.style.removeProperty("left");e.style.removeProperty("width");e.classList.remove("main-kanban-fixed")}else{if(!e.classList.contains("main-kanban-fixed")){BX.onCustomEvent(this,"Kanban.Grid:onFixedModeStart",[this])}var i=this.renderTo.getBoundingClientRect();e.style.left=i.left+"px";e.style.width=i.width+"px";e.style.removeProperty("height");e.classList.add("main-kanban-fixed")}},adjustEmptyStub:function(){var t=true;var e=this.getItems();for(var n in e){var i=e[n];if(i.isVisible()){t=false;break}}this.getInnerContainer().classList[t?"add":"remove"]("main-kanban-no-data-mode")},moveSelectedItems:function(t,e){t=this.getColumn(t);e=this.getItem(e);if(this.selectedItems.length>0||!t||!e){return false}t.addSelectedItems(this.selectedItems,e)},moveItem:function(t,e,n){t=this.getItem(t);e=this.getColumn(e);n=this.getItem(n);if(!t||!e||t===n){return false}var i=t.getColumn();i.removeItem(t);e.addItem(t,n);return true},moveItems:function(t,e,n){var i=[];for(var a in t){var s=this.getColumn(t[a].columnId);if(i.indexOf(s)===-1){i.push(s)}}for(var r in i){var o=[];for(var l in t){if(i[r].getId()===t[l].getColumnId()){o.push(t[l])}}i[r].removeSelectedItems(o)}e.addItems(t,n);return true},moveColumn:function(t,e){t=this.getColumn(t);e=this.getColumn(e);if(!t||t===e){return false}var n=BX.util.array_search(t,this.columnsOrder);this.columnsOrder.splice(n,1);var i=BX.util.array_search(e,this.columnsOrder);if(i>=0){this.columnsOrder.splice(i,0,t);if(this.isRendered()){t.getContainer().parentNode.insertBefore(t.getContainer(),e.getContainer())}}else{this.columnsOrder.push(t);if(this.isRendered()){t.getContainer().parentNode.appendChild(t.getContainer())}}return true},canAddColumns:function(){return this.canAddColumn},canEditColumns:function(){return this.canEditColumn},canSortColumns:function(){return this.canSortColumn},canRemoveColumns:function(){return this.canRemoveColumn},canAddItems:function(){return this.canAddItem},canSortItems:function(){return this.canSortItem},scrollToRight:function(){this.earTimer=setInterval(function(){this.getGridContainer().scrollLeft+=10}.bind(this),20)},scrollToLeft:function(){this.earTimer=setInterval(function(){this.getGridContainer().scrollLeft-=10}.bind(this),20)},stopAutoScroll:function(){clearInterval(this.earTimer);jsDD.refreshDestArea()},getDragMode:function(){return this.dragMode},getDragModeCode:function(t){for(var e in BX.Kanban.DragMode){if(BX.Kanban.DragMode[e]===t){return e}}return null},setDragMode:function(t){var e=this.getDragModeCode(t);if(e!==null){this.getOuterContainer().classList.add("main-kanban-drag-mode-"+e.toLowerCase());this.dragMode=t}},resetDragMode:function(){var t=this.getDragModeCode(this.getDragMode());if(t!==null){this.getOuterContainer().classList.remove("main-kanban-drag-mode-"+t.toLowerCase())}this.dragMode=BX.Kanban.DragMode.NONE},onItemDragStart:function(t){if(this.multiSelect&&this.selectedItems.length>0){for(var t in this.selectedItems){this.selectedItems[t].disabledItem()}}this.setDragMode(BX.Kanban.DragMode.ITEM);var e=this.getItems();for(var n in e){e[n].enableDropping()}this.getColumns().forEach((function(t){t.enableDropping()}));this.getDropZoneArea().emptyAll();this.getDropZoneArea().show()},onItemDragStop:function(t){if(this.multiSelect&&this.selectedItems.length>0){for(var t in this.selectedItems){this.selectedItems[t].unDisabledItem()}}this.resetDragMode();this.getDropZoneArea().hide()},onColumnDragStart:function(t){this.setDragMode(BX.Kanban.DragMode.COLUMN)},onColumnDragStop:function(t){this.resetDragMode()},getEventPromise:function(t,e,n,i){var a=[];e=BX.type.isArray(e)?e:[];BX.onCustomEvent(this,t,[a].concat(e));var s=new BX.Promise;var r=s;for(var o=0;o<a.length;o++){s=s.then(a[o])}s.then(BX.type.isFunction(n)?n:null,BX.type.isFunction(i)?i:null);return r},fadeOut:function(){this.getOuterContainer().classList.add("main-kanban-faded")},fadeIn:function(){this.getOuterContainer().classList.remove("main-kanban-faded")},getMessage:function(t){return t in this.messages?this.messages[t]:BX.message("MAIN_KANBAN_"+t)}};BX.Kanban.DragEvent=function(t){this.item=null;this.items=[];this.targetColumn=null;this.targetItem=null;this.action=true};BX.Kanban.DragEvent.prototype={allowAction:function(){this.action=true},denyAction:function(){this.action=false},isActionAllowed:function(){return this.action},setItems:function(t){this.items=t},setItem:function(t){this.item=t},getItem:function(){return this.item},setTargetItem:function(t){this.targetItem=t},getTargetItem:function(){return this.targetItem},setTargetColumn:function(t){this.targetColumn=t},getTargetColumn:function(){return this.targetColumn}}})();
//# sourceMappingURL=grid.map.js