(function(){"use strict";BX.namespace("BX.Kanban");BX.Kanban.Item=function(t){if(!BX.type.isPlainObject(t)){throw new Error("BX.Kanban.Item: 'options' is not an object.")}this.options=t;if(!BX.Kanban.Utils.isValidId(t.id)){throw new Error("BX.Kanban.Item: 'id' parameter is not valid.")}this.id=t.id;this.grid=null;this.columnId=null;this.layout={container:null,dragTarget:null,bodyContainer:null,checkbox:null,cursor:null};this.dragElement=null;this.draggable=true;this.droppable=true;this.countable=true;this.visible=true;this.selected=null;this.data=Object.create(null);this.setOptions(t)};BX.Kanban.Item.prototype={getId:function(){return this.id},getColumnId:function(){return this.columnId},setColumnId:function(t){this.columnId=t},getColumn:function(){if(this.getGrid()){return this.getGrid().getColumn(this.getColumnId())}return null},setGrid:function(t){if(t instanceof BX.Kanban.Grid){this.grid=t}},getGrid:function(){return this.grid},setOptions:function(t){if(!t){return}this.setData(t.data);this.droppable=BX.type.isBoolean(t.droppable)?t.droppable:this.droppable;this.draggable=BX.type.isBoolean(t.draggable)?t.draggable:this.draggable;this.countable=BX.type.isBoolean(t.countable)?t.countable:this.countable;this.visible=BX.type.isBoolean(t.visible)?t.visible:this.visible},getData:function(){return this.data},setData:function(t){if(BX.type.isPlainObject(t)){this.data=t}},isCountable:function(){return this.countable},isVisible:function(){return this.visible},getGridData:function(){return this.getGrid().getData()},renderLayout:function(){var t=this.getBodyContainer();BX.cleanNode(t);if(this.getGrid().isMultiSelect()){t.appendChild(this.getCheckbox())}t.appendChild(this.render());return this.getContainer()},getContainer:function(){if(this.layout.container!==null){return this.layout.container}this.layout.container=BX.create("div",{attrs:{className:"main-kanban-item","data-id":this.getId(),"data-type":"item","data-element":"kanban-element"},children:[this.getDragTarget(),this.getBodyContainer()],events:{click:function(){if(this.getGrid().isMultiSelect()){this.adjustSelection()}}.bind(this)}});if(this.grid.firstRenderComplete&&!this.draftContainer){this.layout.container.classList.add("main-kanban-item-new")}this.makeDraggable();this.makeDroppable();return this.layout.container},handleClick:function(){},adjustSelection:function(){if(this.selected){this.unSelect()}else{this.select()}},isSelected:function(){return this.selected},select:function(t){this.selected=true;this.getContainer().classList.add("main-kanban-item-selected");if(!t){BX.onCustomEvent(this.getGrid(),"Kanban.Item:select",[this])}},unSelect:function(t){this.selected=null;this.getContainer().classList.remove("main-kanban-item-selected");if(!t){BX.onCustomEvent(this.getGrid(),"Kanban.Item:unSelect",[this])}},getDragTarget:function(){if(!this.layout.dragTarget){this.layout.dragTarget=BX.create("div",{attrs:{className:"main-kanban-item-drag-target"}})}return this.layout.dragTarget},getDragElement:function(){return this.dragElement},getBodyContainer:function(){if(!this.layout.bodyContainer){this.layout.bodyContainer=BX.create("div",{attrs:{className:"main-kanban-item-wrapper"}})}return this.layout.bodyContainer},getCheckbox:function(){if(!this.layout.checkbox){this.layout.checkbox=BX.create("div",{props:{className:"main-kanban-item-checkbox"}})}return this.layout.checkbox},animateAha:function(){this.getContainer().classList.add("--aha-drag");this.getContainer().appendChild(this.getAhaCursor());this.getColumn().getBody().style.overflow="visible";this.getColumn().getContainer().style.zIndex="99"},unsetAnimateAha:function(){if(!this.getContainer().classList.contains("--aha-drag")){return}this.getContainer().classList.remove("--aha-drag");this.getColumn().getBody().style.overflow=null;this.getColumn().getContainer().style.zIndex=null;this.getAhaCursor().parentNode.removeChild(this.getAhaCursor())},getAhaCursor:function(){if(this.layout.cursor){return this.layout.cursor}this.layout.cursor=BX.create("div",{props:{className:"main-kanban-item-aha-cursor"},children:[BX.create("div",{props:{className:"main-kanban-item-aha-cursor-round"}})]});return this.layout.cursor},render:function(){if(!this.layout.content){this.layout.content=BX.create("div",{props:{className:"main-kanban-item-default"}})}this.layout.content.style.borderLeft="2px solid #"+this.getColumn().getColor();this.layout.content.textContent="#"+this.getId();return this.layout.content},disabledItem:function(){this.getContainer().classList.add("main-kanban-item-disabled")},unDisabledItem:function(){this.getContainer().classList.remove("main-kanban-item-disabled")},dispose:function(){jsDD.unregisterDest(this.getContainer());jsDD.unregisterObject(this.getContainer())},makeDraggable:function(){if(!this.isDraggable()){return}var t=this.getContainer();t.onbxdragstart=BX.delegate(this.onDragStart,this);t.onbxdrag=BX.delegate(this.onDrag,this);t.onbxdragstop=BX.delegate(this.onDragStop,this);jsDD.registerObject(t)},makeDroppable:function(){if(!this.isDroppable()){return}var t=this.getContainer();t.onbxdestdraghover=BX.delegate(this.onDragEnter,this);t.onbxdestdraghout=BX.delegate(this.onDragLeave,this);t.onbxdestdragfinish=BX.delegate(this.onDragDrop,this);t.onbxdestdragstop=BX.delegate(this.onItemDragEnd,this);jsDD.registerDest(t,30);if(this.getGrid().getDragMode()!==BX.Kanban.DragMode.ITEM){this.disableDropping()}},disableDragging:function(){if(this.isDraggable()){jsDD.unregisterObject(this.getContainer())}},enableDragging:function(){if(this.isDraggable()){jsDD.registerObject(this.getContainer())}},disableDropping:function(){if(this.isDroppable()){jsDD.disableDest(this.getContainer())}},enableDropping:function(){if(this.isDroppable()){jsDD.enableDest(this.getContainer())}},isDraggable:function(){return this.draggable&&this.getGrid().canSortItems()},isDroppable:function(){return this.droppable},onDragStart:function(){if(!this.isSelected()){this.getGrid().cleanSelectedItems();this.getGrid().offMultiSelect()}if(this.getGrid().isMultiSelect()&&this.getGrid().getSelectedItems().length>0){this.onDragStartMulti();return}this.disabledItem();this.unsetAnimateAha();if(!this.dragElement){var t=this.getContainer();var e=this.getBodyContainer();this.dragElement=t.cloneNode(true);this.dragElement.style.position="absolute";this.dragElement.style.width=e.offsetWidth+"px";this.dragElement.className="main-kanban-item main-kanban-item-drag";document.body.appendChild(this.dragElement)}BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStart",[this])},onDragStartMulti:function(){var t=this.getGrid().getSelectedItems();this.dragElement=BX.create("div",{props:{className:"main-kanban-item-drag-multi"}});for(var e=0;e<t.length&&e<=2;e++){var i=t[e];if(e===0){i=this}var n=i.getContainer().cloneNode(true);n.style.width=i.getContainer().offsetWidth+"px";this.getContainer().maxHeight=this.getContainer().offsetHeight+"px";n.classList.remove("main-kanban-item-disabled");n.classList.remove("main-kanban-item-selected");this.dragElement.appendChild(n)}document.body.appendChild(this.dragElement);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemsDragStart",[t])},onDragStop:function(t,e){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStop",[this]);this.unDisabledItem();BX.remove(this.dragElement);this.dragElement=null},onDrag:function(t,e){if(this.dragElement){this.dragElement.style.left=t+"px";this.dragElement.style.top=e+"px"}},onDragEnter:function(t,e,i){var n=this.getGrid().getItemByElement(t);this.showDragTarget(n.getBodyContainer().offsetHeight)},onDragLeave:function(t,e,i){this.hideDragTarget()},onDragDrop:function(t,e,i){if(this.getGrid().getSelectedItems().length>0){this.onDragDropMulti(this.getGrid().getSelectedItems());return}this.hideDragTarget();var n=this.getGrid().getItemByElement(t);var a=new BX.Kanban.DragEvent;a.setItem(n);a.setTargetColumn(this.getColumn());a.setTargetItem(this);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onBeforeItemMoved",[a]);if(!a.isActionAllowed()){return}var r=this.getGrid().moveItem(n,this.getColumn(),this);if(r){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemMoved",[n,this.getColumn(),this])}},onDragDropMulti:function(t,e,i){this.hideDragTarget();var n=t;var a=this;var r=new BX.Kanban.DragEvent;r.setItems(n);r.setTargetColumn(this.getColumn());r.setTargetItem(this);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onBeforeItemMoved",[r]);if(!r.isActionAllowed()){return}var s=BX.util.array_search(a,n);if(s>=0){var o=this.getColumn().getItems();for(var d=0;d<n.length;d++){var l=BX.util.array_search(a,o);a=o[l+1];if(BX.util.array_search(a,n)===-1)break}}var h=this.getGrid().moveItems(n,this.getColumn(),a);if(h){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemsMoved",[n,this.getColumn(),a])}},onItemDragEnd:function(t,e,i){this.disableDropping()},showDragTarget:function(t){this.getContainer().classList.add("main-kanban-item-target-shown");this.getDragTarget().style.height=t+"px"},hideDragTarget:function(){this.getContainer().classList.remove("main-kanban-item-target-shown");this.getDragTarget().style.removeProperty("height")}};BX.Kanban.DraftItem=function(t){BX.Kanban.Item.apply(this,arguments);this.asyncEventStarted=false;this.draftContainer=null;this.draftTextArea=null;this.draftContainerText=null};BX.Kanban.DraftItem.prototype={__proto__:BX.Kanban.Item.prototype,constructor:BX.Kanban.DraftItem,render:function(){if(this.draftContainer){return this.draftContainer}this.draftContainer=BX.create("div",{props:{className:"main-kanban-item-draft"},children:[this.getDraftTextArea(),this.getGrid().getAddDraftItemInfo()?this.getDraftInfoText():null]});return this.draftContainer},getDraftInfoText:function(){if(this.draftContainerText){return this.draftContainerText}this.draftContainerText=BX.create("div",{props:{className:"main-kanban-item-draft-info"},html:this.getGrid().getAddDraftItemInfo()});return this.draftContainerText},setGrid:function(t){BX.Kanban.Item.prototype.setGrid.apply(this,arguments);BX.addCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStart",BX.proxy(this.applyDraftEditMode,this))},getDraftTextArea:function(){if(this.draftTextArea){return this.draftTextArea}this.draftTextArea=BX.create("textarea",{attrs:{className:"main-kanban-item-draft-textarea",placeholder:this.getGrid().getMessage("ITEM_TITLE_PLACEHOLDER")},events:{blur:this.handleDraftTextAreaBlur.bind(this),keydown:this.handleDraftTextAreaKeyDown.bind(this)}});BX.bind(window,"click",this.handleDraftTextAreaKeyDown.bind(this));return this.draftTextArea},applyDraftEditMode:function(){if(this.asyncEventStarted){return}this.asyncEventStarted=true;var t=BX.util.trim(this.getDraftTextArea().value);if(!t.length){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:closeDraftItem",[this]);this.removeDraftItem();return}this.setData({title:t});this.getContainer().classList.add("main-kanban-item-draft-disabled");this.getDraftTextArea().disabled=true;var e=this.getGrid().getEventPromise("Kanban.Grid:onItemAddedAsync",null,this.onItemAddedFulfilled.bind(this),this.onItemAddedRejected.bind(this));e.fulfill(this)},onItemAddedFulfilled:function(t){if(!BX.type.isPlainObject(t)){this.removeDraftItem();return}if(!BX.Kanban.Utils.isValidId(t.targetId)){var e=this.getColumn().getNextItemSibling(this);if(e){t.targetId=e.getId()}}this.removeDraftItem();var i=this.getGrid().addItem(t);if(i&&this.getGrid().getDragMode()===BX.Kanban.DragMode.NONE){var n=this.getGrid().getColumns().some((function(t){return t.getDraftItem()!==null}));if(!n){var a=i.getColumn().getPreviousItemSibling(i);i.getColumn().addDraftItem(a)}}},onItemAddedRejected:function(t){this.removeDraftItem()},removeDraftItem:function(){this.asyncEventStarted=true;BX.removeCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStart",BX.proxy(this.applyDraftEditMode,this));this.getColumn().removeDraftItem()},focusDraftTextArea:function(){this.getDraftTextArea().focus()},handleDraftTextAreaBlur:function(t){setTimeout(function(){if(!this.draftTextArea.value.length){this.applyDraftEditMode()}}.bind(this),0)},handleDraftTextAreaKeyDown:function(t){if(t.key==="Enter"){this.applyDraftEditMode()}else if(t.key==="Escape"){this.removeDraftItem();BX.onCustomEvent(this.getGrid(),"Kanban.Grid:removeDraftItemByEsc",[this]);t.stopPropagation()}}}})();
//# sourceMappingURL=item.map.js