(function(){"use strict";BX.SpotLight=function(t){this.container=null;this.popup=null;this.id="spotlight-"+BX.util.getRandomString().toLowerCase();this.options={};this.targetElement=null;this.targetElementRect=null;this.targetVertex="top-left";this.content=null;this.title=null;this.top=0;this.left=0;this.lightMode=false;this.autoSave=false;this.zIndex=null;this.color=null;this.observerTimeoutId=null;this.observerTimeout=1e3;this.setOptions(t);if(!this.targetElement){throw new Error("BX.SpotLight: 'targetElement' is not a DOMNode.")}this.handlePageResize=this.handlePageResize.bind(this)};BX.SpotLight.prototype={setOptions:function(t){t=BX.type.isPlainObject(t)?t:{};this.options=t;this.setTargetElement(t.renderTo);this.setTargetElement(t.targetElement);this.setTargetVertex(t.targetVertex);this.setZindex(t.zIndex);this.setLightMode(t.lightMode);this.setContent(t.content);this.setTitle(t.title);this.setColor(t.color);this.setOffsetLeft(t.left);this.setOffsetTop(t.top);this.setAutoSave(t.autoSave);this.setObserverTimeout(t.observerTimeout);this.setId(t.id)},bindEvents:function(t){if(!BX.type.isPlainObject(t)){return}for(var e in t){var i=BX.type.isFunction(t[e])?t[e]:BX.getClass(t[e]);if(i){BX.addCustomEvent(this,this.getFullEventName(e),i)}}},unbindEvents:function(t){if(!BX.type.isPlainObject(t)){return}for(var e in t){var i=BX.type.isFunction(t[e])?t[e]:BX.getClass(t[e]);if(i){BX.removeCustomEvent(this,this.getFullEventName(e),i)}}},getOptions:function(){return this.options},getId:function(){return this.id},setId:function(t){if(BX.type.isNotEmptyString(t)){this.id=t}},getZindex:function(){if(this.zIndex!==null){return this.zIndex}return this.getGlobalIndex(this.getTargetElement())+1},getGlobalIndex:function(t){var e=0;do{var i=BX.style(t,"z-index");if(i!=="auto"){e=BX.type.stringToInt(i)}t=t.parentNode}while(t&&t.tagName!=="BODY");return e},setZindex:function(t){if(BX.type.isNumber(t)||t===null){this.zIndex=t}},isFixedPosition:function(t){let e=t;while(e&&e.tagName!=="BODY"){const t=window.getComputedStyle(e).getPropertyValue("position");if(t==="fixed"){return true}e=e.parentNode}return false},getContent:function(){return this.content},setContent:function(t){if(BX.type.isNotEmptyString(t)||BX.type.isDomNode(t)||t===null){this.content=t}},getTitle:function(){return this.title},setTitle:function(t){if(BX.Type.isStringFilled(t)||t===null){this.title=t}},getTargetElement:function(){return this.targetElement},setTargetElement:function(t){if(BX.type.isNotEmptyString(t)){t=document.querySelector(t)||BX(t)}if(BX.type.isDomNode(t)){this.targetElement=t;this.renderTo=t}},getOffsetLeft:function(){return this.left},setOffsetLeft:function(t){if(BX.type.isNumber(t)){this.left=t}},getOffsetTop:function(){return this.top},setOffsetTop:function(t){if(BX.type.isNumber(t)){this.top=t}},getLightMode:function(){return this.lightMode},setLightMode:function(t){if(BX.type.isBoolean(t)){this.lightMode=t}},getColor:function(){return this.color},setColor:function(t){this.color=t;if(BX.type.isDomNode(this.container)){this.container.style.color=this.getColor()}},getAutoSave:function(){return this.autoSave},setAutoSave:function(t){if(BX.type.isBoolean(t)){this.autoSave=t}},getObserverTimeout:function(){return this.observerTimeout},setObserverTimeout:function(t){if(BX.type.isNumber(t)&&t>=0){this.observerTimeout=t}},getTargetVertex:function(){return this.targetVertex},setTargetVertex:function(t){if(BX.type.isNotEmptyString(t)){this.targetVertex=t}},getPopup:function(){if(this.popup){return this.popup}const t=BX.UI.Dialogs.MessageBox.create({message:this.getContent(),title:this.getTitle(),modal:true,okCaption:BX.message("MAIN_SPOTLIGHT_UNDERSTAND"),onOk:()=>{this.fireEvent("onPopupAccept");BX.onCustomEvent(this,"spotLightOk",[this.getTargetElement(),this]);this.close()},buttons:BX.UI.Dialogs.MessageBoxButtons.OK,popupOptions:{bindElement:this.container,offsetTop:10,angle:{position:"top"},animation:{showClassName:"main-spot-light-popup-animation",closeAnimationType:"animation"},closeByEsc:true,fixed:this.container.style.position==="fixed",events:{onPopupShow:()=>{this.fireEvent("onPopupShow")},onPopupClose:()=>{this.fireEvent("onPopupClose");this.close()}}}});this.popup=t.getPopupWindow();return this.popup},getTargetContainer:function(){if(this.container){return this.container}this.container=BX.create("div",{attrs:{className:this.getLightMode()?"main-spot-light main-spot-light-white":"main-spot-light"},events:{mouseenter:this.handleTargetMouseEnter.bind(this),mouseleave:this.handleTargetMouseLeave.bind(this)},styles:{color:this.getColor()}});if("ontouchstart"in window){BX.bind(this.container,"touchstart",this.handleTargetMouseEnter.bind(this))}return this.container},adjustPosition:function(){var t=this.getTargetElement();const e=this.isFixedPosition(t);this.targetElementRect=e?t.getBoundingClientRect():BX.pos(t);var i=(t.offsetWidth>0||t.offsetHeight>0||t.getClientRects().length>0)&&BX.Dom.style(t,"visibility")!=="hidden";if(!i){this.container.hidden=true;return}var n=0;var s=0;var o=this.getTargetVertex();switch(o){case"top-left":default:n=this.targetElementRect.left;s=this.targetElementRect.top;break;case"top-center":n=this.targetElementRect.left+this.targetElementRect.width/2;s=this.targetElementRect.top;break;case"top-right":n=this.targetElementRect.right;s=this.targetElementRect.top;break;case"middle-left":n=this.targetElementRect.left;s=this.targetElementRect.top+this.targetElementRect.height/2;break;case"middle-center":n=this.targetElementRect.left+this.targetElementRect.width/2;s=this.targetElementRect.top+this.targetElementRect.height/2;break;case"middle-right":n=this.targetElementRect.right;s=this.targetElementRect.top+this.targetElementRect.height/2;break;case"bottom-left":n=this.targetElementRect.left;s=this.targetElementRect.bottom;break;case"bottom-center":n=this.targetElementRect.left+this.targetElementRect.width/2;s=this.targetElementRect.bottom;break;case"bottom-right":n=this.targetElementRect.right;s=this.targetElementRect.bottom;break}this.container.hidden=false;this.container.style.left=n+this.getOffsetLeft()+"px";this.container.style.top=s+this.getOffsetTop()+"px";this.container.style.zIndex=this.getZindex();this.container.style.color=this.getColor();this.container.style.position=e?"fixed":"block";if(this.popup&&(this.popup.isFixed()&&!e||!this.popup.isFixed()&&e)){this.popup.setFixed(e);this.popup.adjustPosition()}},handlePageResize:function(){this.adjustPosition()},handleTargetMouseEnter:function(){this.fireEvent("onTargetEnter");if(this.getContent()){this.getPopup().show()}if(this.getAutoSave()){this.save()}},handleTargetMouseLeave:function(){this.fireEvent("onTargetLeave")},handleTargetElementResize:function(){var t=BX.pos(this.getTargetElement());if(t.left!==this.targetElementRect.left||t.right!==this.targetElementRect.right||t.top!==this.targetElementRect.top||t.bottom!==this.targetElementRect.bottom){this.adjustPosition()}},show:function(){if(!this.getTargetContainer().parentNode){BX.bind(window,"resize",this.handlePageResize);BX.bind(window,"load",this.handlePageResize);BX.addCustomEvent("onFrameDataProcessed",this.handlePageResize);this.bindEvents(this.getOptions().events);document.body.appendChild(this.getTargetContainer());if(this.getObserverTimeout()){this.observerTimeoutId=setInterval(this.handleTargetElementResize.bind(this),this.getObserverTimeout())}}this.fireEvent("onShow");this.adjustPosition()},close:function(){this.fireEvent("onClose");if(this.popup){this.popup.destroy();this.popup=null}if(this.observerTimeoutId){clearInterval(this.observerTimeoutId);this.observerTimeoutId=null}BX.unbind(window,"resize",this.handlePageResize);BX.unbind(window,"load",this.handlePageResize);BX.removeCustomEvent("onFrameDataProcessed",this.handlePageResize);this.unbindEvents(this.getOptions().events);BX.remove(this.container);this.container=null},save:function(){var t="view_date_"+this.getId();BX.userOptions.save("spotlight",t,null,Math.floor(Date.now()/1e3));BX.userOptions.send(null)},fireEvent:function(t){if(BX.type.isNotEmptyString(t)){BX.onCustomEvent(this,this.getFullEventName(t),[this])}},getFullEventName:function(t){return"BX.SpotLight:"+t}};BX.SpotLight.Manager={spotlights:{},create:function(t){t=BX.type.isPlainObject(t)?t:{};var e=t.id;if(!BX.type.isNotEmptyString(e)){throw new Error("'id' parameter is required.")}if(this.get(e)){throw new Error("The spotlight instance with the same 'id' already exists.")}var i=new BX.SpotLight(t);this.spotlights[e]=i;return i},get:function(t){return t in this.spotlights?this.spotlights[t]:null},remove:function(t){delete this.spotlights[t]}}})();
//# sourceMappingURL=spotlight.map.js