BX.namespace("BX.Sale.Input");BX.Sale.Input=function(){"use strict";var Module={};Module.Manager=function(){var t={};return{Editor:function(e,n,i){var l=n.TYPE;if(!t.hasOwnProperty(l))throw"invalid input type: "+l;var r=new t[l](e,n,i,this);this.getType=function(){return l}},register:function(e,n){if(t.hasOwnProperty(e))throw"duplicate input type: "+e;t[e]=n}}}();var Utils={};Module.Utils=Utils;Utils.asSingle=function(t){if(t===undefined||t===null||t===""){return null}else if(t.constructor===Array){var e=0,n=t.length,i;for(;e<n;e++){i=t[e];if(i!==undefined&&i!==null&&i!=="")return i}return null}else{return t}};Utils.asMultiple=function(t){if(t===undefined||t===null||t===""){return[]}else if(t.constructor===Array){var e=0,n=t.length,i;for(;e<n;){i=t[e];if(i===undefined||i===null||i===""){t.splice(e,1);--n}else{++e}}return t}else{return[t]}};Utils.applyTo=function(t,e,n,i){if(n.constructor===Array){var l=0,r=n.length;for(;l<r;l++)t[e](n[l],i)}else{t[e](n,i)}};if(window.addEventListener){Utils.addEventTo=function(t,e,n){return t.addEventListener(e,n,false)};Utils.removeEventFrom=function(t,e,n){return t.removeEventListener(e,n)}}else{Utils.addEventTo=function(t,e,n){return t.attachEvent("on"+e,n)};Utils.removeEventFrom=function(t,e,n){return t.detachEvent("on"+e,n)}}Utils.stopElementEvents=function(t){if(t&&t.preventDefault){t.preventDefault();t.stopPropagation()}else if(t=window.event){t.returnValue=false;t.cancelBubble=true}return false};Utils.applyAttributesTo=function(t,e){var n=t[0],i=t[1],l=2,r=t.length,o,s;for(;l<r;l++){o=t[l];delete o.REQUIRED;for(s in i)if(i.hasOwnProperty(s)&&o.hasOwnProperty(s))e(n,s.toLowerCase(),i[s],o[s])}};Utils.globalBooleanAttributes={CONTENTEDITABLE:"",DRAGGABLE:"true",SPELLCHECK:"",TRANSLATE:"yes"};Utils.applyBooleanAttributesTo=function(){var t=function(t,e,n,i){if(n=="Y"||n===true)t.setAttribute(e,i)};return function(){Utils.applyAttributesTo(arguments,t)}}();Utils.globalValueAttributes={ACCESSKEY:1,CLASS:1,CONTEXTMENU:1,DIR:1,DROPZONE:1,LANG:1,STYLE:1,TABINDEX:1,TITLE:1,DATA:1,"XML:LANG":1,"XML:SPACE":1,"XML:BASE":1};Utils.applyValueAttributesTo=function(){var t=function(t,e,n,i){if(n){if(e=="DATA"){if(n!==null&&typeof n==="object"){var l;for(l in n)if(n.hasOwnProperty(l))t.setAttribute("data-"+l,n[l])}}else{t.setAttribute(e,n)}}};return function(){Utils.applyAttributesTo(arguments,t)}}();Utils.globalEventAttributes={ONABORT:1,ONBLUR:1,ONCANPLAY:1,ONCANPLAYTHROUGH:1,ONCHANGE:1,ONCLICK:1,ONCONTEXTMENU:1,ONDBLCLICK:1,ONDRAG:1,ONDRAGEND:1,ONDRAGENTER:1,ONDRAGLEAVE:1,ONDRAGOVER:1,ONDRAGSTART:1,ONDROP:1,ONDURATIONCHANGE:1,ONEMPTIED:1,ONENDED:1,ONERROR:1,ONFOCUS:1,ONINPUT:1,ONINVALID:1,ONKEYDOWN:1,ONKEYPRESS:1,ONKEYUP:1,ONLOAD:1,ONLOADEDDATA:1,ONLOADEDMETADATA:1,ONLOADSTART:1,ONMOUSEDOWN:1,ONMOUSEMOVE:1,ONMOUSEOUT:1,ONMOUSEOVER:1,ONMOUSEUP:1,ONMOUSEWHEEL:1,ONPAUSE:1,ONPLAY:1,ONPLAYING:1,ONPROGRESS:1,ONRATECHANGE:1,ONREADYSTATECHANGE:1,ONRESET:1,ONSCROLL:1,ONSEEKED:1,ONSEEKING:1,ONSELECT:1,ONSHOW:1,ONSTALLED:1,ONSUBMIT:1,ONSUSPEND:1,ONTIMEUPDATE:1,ONVOLUMECHANGE:1,ONWAITING:1};Utils.extend=function(t,e){for(var n in e){if(e.hasOwnProperty(n))t[n]=e[n]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t};Module.BaseInput=BaseInput;function BaseInput(t,e,n,i){this.name=t;this.settings=e;this.publicO=i;this.multiple=e.MULTIPLE==="Y";this.disabled=e.DISABLED==="Y";this.required=e.REQUIRED==="Y";this.form=e.FORM;if(e.MULTITAG)this.multitag=e.MULTITAG;this.createEditor(n===undefined?e.VALUE:n);var l=this;i.getName=function(){return t};i.appendTo=function(t){l.parentNode=t;l.applyTo(t,"appendChild")};i.insertTo=function(t,e){l.parentNode=t;l.applyTo(t,"insertBefore",e)};i.remove=function(){if(l.parentNode){l.applyTo(l.parentNode,"removeChild");l.parentNode=null}};i.getParentNode=function(){return l.parentNode};i.isMultiple=function(){return l.multiple};i.isRequired=function(){return l.required};i.getValue=function(){return l.getValue()};i.setValue=function(t){l.setValue(t)};i.isDisabled=function(){return l.disabled};i.setDisabled=function(t){if(l.disabled!==t){l.disabled=t;l.setDisabled(t)}};i.addEvent=function(t,e){l.addEvent(t,e)}}BaseInput.prototype.multitag="div";BaseInput.prototype.createEditor=function(t){if(this.multiple){t=Utils.asMultiple(t);var e=[],n=this.name,i=0,l=t.length;for(;i<l;i++)e.push(this.createEditorSingleItem(n+"["+i+"]",t[i]));this.items=e;this.insertor=this.createEditorInsertor()}else{this.items=this.createEditorSingle(this.name,Utils.asSingle(t))}};BaseInput.prototype.createEditorSingle=function(t,e){throw"you must override "+this.settings.TYPE+".appendEditorSingle"};BaseInput.prototype.createEditorSingleDeletor=function(t){var e=this;var n=document.createElement("input");n.type="checkbox";n.disabled=this.disabled;if(this.form)n.setAttribute("form",this.form);Utils.addEventTo(n,"click",function(){e.setDisabledSingle(t,n.checked)});var i=document.createElement("label");i.appendChild(document.createTextNode(" "+BX.message("INPUT_DELETE")+" "));i.appendChild(n);i.appendChild(document.createTextNode(" "));i.getValue=function(){return n.checked};i.setDisabled=function(t){n.disabled=t};i.setName=function(t){n.name=t};return i};BaseInput.prototype.createEditorSingleItem=function(t,e){var n=this.createEditorSingle(t,e),i=n.deletor,l=this.multitag,r=this.events;if(r){for(var o in r){if(r.hasOwnProperty(o)){var s=r[o],a=0,u=s.length;for(;a<u;a++)this.addEventSingle(n,o,s[a])}}}if(!i&&(i=this.createEditorSingleDeletor(n))){n.deletor=i;n.push(i)}if(l){var p=document.createElement(l);Utils.applyTo(p,"appendChild",n);p.deletor=i;return p}else{return n}};BaseInput.prototype.createEditorInsertor=function(){var t=this;var e=document.createElement("input");e.type="button";e.value=BX.message("INPUT_ADD");e.disabled=this.disabled;if(this.form)e.setAttribute("form",this.form);Utils.addEventTo(e,"click",function(){var n=t.items,i=t.parentNode,l=t.createEditorSingleItem(t.name+"["+n.length+"]",null);n.push(l);if(i)Utils.applyTo(i,"insertBefore",l,e);t.afterEditorSingleInsert(t.multitag?l.childNodes:l)});return e};BaseInput.prototype.afterEditorSingleInsert=function(t){};BaseInput.prototype.setValue=function(t){if(this.multiple){t=Utils.asMultiple(t);var e=this.name,n=this.multitag,i=this.parentNode,l=0,r=this.items,o=t.length,s=r.length;if(o==s){for(;l<s;l++)this.setValueSingle(n?r[l].childNodes:r[l],Utils.asSingle(t[l]))}else if(o>s){for(;l<s;l++)this.setValueSingle(n?r[l].childNodes:r[l],Utils.asSingle(t[l]));var a,u=this.insertor;for(;l<o;l++){a=this.createEditorSingleItem(e+"["+l+"]",t[l]);r.push(a);if(i)Utils.applyTo(i,"insertBefore",a,u)}}else{for(;l<o;l++)this.setValueSingle(n?r[l].childNodes:r[l],Utils.asSingle(t[l]));var p=l;if(i)for(;l<s;l++)Utils.applyTo(i,"removeChild",r[l]);r.splice(p,s-p)}}else{this.setValueSingle(this.items,Utils.asSingle(t))}};BaseInput.prototype.setValueSingle=function(t,e){throw"you must override "+this.settings.TYPE+".setValueSingle"};BaseInput.prototype.getValue=function(){if(this.multiple){var t=[],e=this.items,n=this.multitag,i=0,l=e.length,r;for(;i<l;i++){r=this.getValueSingle(n?e[i].childNodes:e[i]);if(r!==undefined&&r!==null&&r!=="")t.push(r)}return t}else{return this.getValueSingle(this.items)}};BaseInput.prototype.getValueSingle=function(t){throw"you must override "+this.settings.TYPE+".getValueSingle"};BaseInput.prototype.setDisabled=function(t){if(this.multiple){var e=this.items,n=this.multitag,i=0,l=e.length,r=this.insertor,o,s;for(;i<l;i++){o=e[i];s=o.deletor;if(n)o=o.childNodes;if(s){s.setDisabled(t);if(!s.getValue())this.setDisabledSingle(o,t)}else{this.setDisabledSingle(o,t)}}if(r)r.disabled=t}else{this.setDisabledSingle(this.items,t)}};BaseInput.prototype.setDisabledSingle=function(t,e){throw"you must override "+this.settings.TYPE+".setDisabledSingle"};BaseInput.prototype.createEventHandler=function(t){var e=this.publicO;return function(n){t.call(this,n,e)}};BaseInput.prototype.events=false;BaseInput.prototype.addEvent=function(t,e){e=this.createEventHandler(e);var n=this.events;if(!n)n=this.events={};if(n.hasOwnProperty(t))n[t].push(e);else n[t]=[e];if(this.multiple){var i=this.items,l=this.multitag,r=0,o=i.length;for(;r<o;r++)this.addEventSingle(l?i[r].childNodes:i[r],t,e)}else{this.addEventSingle(this.items,t,e)}};BaseInput.prototype.addEventSingle=function(t,e,n){throw"you must override "+this.settings.TYPE+".addEventSingle"};BaseInput.prototype.applyEventAttributesTo=function(){var privateO=this;Utils.applyAttributesTo(arguments,function(element,name,value,whiteValue){if(value){var eventHandler=privateO.createEventHandler(eval("(function(event, input){"+value+"})"));if(window.addEventListener){Utils.addEventTo(element,name.substring(2),eventHandler)}else{Utils.addEventTo(element,name.substring(2),function(){return eventHandler.call(element)})}}})};BaseInput.prototype.applyTo=function(t,e,n){if(this.multiple){var i=this.items,l=0,r=i.length,o=this.insertor;for(;l<r;l++)Utils.applyTo(t,e,i[l],n);if(o)t[e](o,n)}else{Utils.applyTo(t,e,this.items,n)}};Module.StringInput=StringInput;Utils.extend(StringInput,BaseInput);Module.Manager.register("STRING",StringInput);function StringInput(t,e,n,i){StringInput.__super__.constructor.call(this,t,e,n,i)}StringInput.prototype.createEditorSingle=function(t,e){var n,i=this.settings;if(i.MULTILINE=="Y"){n=document.createElement("textarea");if(!i.ROWS&&!i.COLS){i.ROWS=4;i.COLS=40}Utils.applyBooleanAttributesTo(n,i,Utils.globalBooleanAttributes,{DISABLED:"",READONLY:"",AUTOFOCUS:"",REQUIRED:""});Utils.applyValueAttributesTo(n,i,Utils.globalValueAttributes,{FORM:1,MAXLENGTH:1,PLACEHOLDER:1,DIRNAME:1,ROWS:1,COLS:1,WRAP:1});this.applyEventAttributesTo(n,i,Utils.globalEventAttributes)}else{n=document.createElement("input");n.type="text";if(!i.SIZE){i.SIZE=30}if(i.PATTERN&&i.PATTERN.length>0&&i.PATTERN[0]===i.PATTERN[i.PATTERN.length-1]){var l=i.PATTERN.substr(1,i.PATTERN.length-2);if(l&&l.length){i.PATTERN=l}}Utils.applyBooleanAttributesTo(n,i,Utils.globalBooleanAttributes,{DISABLED:"",READONLY:"",AUTOFOCUS:"",REQUIRED:"",AUTOCOMPLETE:"on"});Utils.applyValueAttributesTo(n,i,Utils.globalValueAttributes,{FORM:1,MAXLENGTH:1,PLACEHOLDER:1,DIRNAME:1,SIZE:1,LIST:1,PATTERN:1});this.applyEventAttributesTo(n,i,Utils.globalEventAttributes)}n.name=t;n.value=e||"";var r=[n];if(i.MULTIPLE=="Y"){var o=this.createEditorSingleDeletor(r);o.setName(t+"[DELETE]");r.deletor=o;r.push(o)}return r};StringInput.prototype.afterEditorSingleInsert=function(t){t[0].focus()};StringInput.prototype.setValueSingle=function(t,e){t[0].value=e};StringInput.prototype.getValueSingle=function(t){var e=t[0];return e.disabled?null:e.value};StringInput.prototype.setDisabledSingle=function(t,e){t[0].disabled=e};StringInput.prototype.addEventSingle=function(t,e,n){Utils.addEventTo(t[0],e,n)};Module.NumberInput=NumberInput;Utils.extend(NumberInput,BaseInput);Module.Manager.register("NUMBER",NumberInput);function NumberInput(t,e,n,i){NumberInput.__super__.constructor.call(this,t,e,n,i)}NumberInput.prototype.createEditorSingle=function(t,e){var n,i=5,l=this.settings;if((n=l.MIN)&&n.toString().length>i)i=n.toString().length;if((n=l.MAX)&&n.toString().length>i)i=n.toString().length;if((n=l.STEP)&&n.toString().length>i)i=n.toString().length;if(i>30)i=30;var r=document.createElement("input");r.type="text";r.name=t;r.value=e;r.size=i;Utils.applyBooleanAttributesTo(r,l,Utils.globalBooleanAttributes,{DISABLED:"",READONLY:"",AUTOFOCUS:"",REQUIRED:"",AUTOCOMPLETE:"on"});Utils.applyValueAttributesTo(r,l,Utils.globalValueAttributes,{FORM:1,LIST:1,PLACEHOLDER:1});this.applyEventAttributesTo(r,l,Utils.globalEventAttributes);return[r]};NumberInput.prototype.afterEditorSingleInsert=function(t){t[0].focus()};NumberInput.prototype.setValueSingle=function(t,e){t[0].value=e};NumberInput.prototype.getValueSingle=function(t){var e=t[0];return e.disabled?null:e.value};NumberInput.prototype.setDisabledSingle=function(t,e){t[0].disabled=e};NumberInput.prototype.addEventSingle=function(t,e,n){Utils.addEventTo(t[0],e,n)};Module.EitherYNInput=EitherYNInput;Utils.extend(EitherYNInput,BaseInput);Module.Manager.register("Y/N",EitherYNInput);function EitherYNInput(t,e,n,i){EitherYNInput.__super__.constructor.call(this,t,e,n,i)}EitherYNInput.prototype.createEditorSingle=function(t,e){var n=this.settings;var i=document.createElement("input");i.type="hidden";i.name=t;i.value="N";i.disabled=this.disabled;if(this.form)i.setAttribute("form",this.form);var l=document.createElement("input");l.type="checkbox";l.name=t;l.value="Y";l.checked=e==="Y";Utils.applyBooleanAttributesTo(l,n,Utils.globalBooleanAttributes,{DISABLED:"",AUTOFOCUS:"",REQUIRED:""});Utils.applyValueAttributesTo(l,n,Utils.globalValueAttributes,{FORM:1});this.applyEventAttributesTo(l,n,Utils.globalEventAttributes);return[i,l]};EitherYNInput.prototype.afterEditorSingleInsert=function(t){t[1].focus()};EitherYNInput.prototype.setValueSingle=function(t,e){t[1].checked=e==="Y"};EitherYNInput.prototype.getValueSingle=function(t){var e=t[1];return e.disabled?null:e.checked?"Y":"N"};EitherYNInput.prototype.setDisabledSingle=function(t,e){t[0].disabled=e;t[1].disabled=e};EitherYNInput.prototype.addEventSingle=function(t,e,n){Utils.addEventTo(t[1],e,n)};Module.EnumInput=EnumInput;Utils.extend(EnumInput,BaseInput);Module.Manager.register("ENUM",EnumInput);function EnumInput(t,e,n,i){this.multielement=e.MULTIELEMENT==="Y";EnumInput.__super__.constructor.call(this,t,e,n,i)}EnumInput.prototype.getValueObject=function(t){t=Utils.asMultiple(t);var e={},n=0,i=t.length,l;for(;n<i;n++){l=t[n];if(l!==undefined)e[l]=true}return e};EnumInput.prototype.createEditor=function(t){var e=[],n=this.name,i=this.settings,l=[];if(BX.type.isPlainObject(i.OPTIONS)){for(var r in i.OPTIONS_SORT){var o=i.OPTIONS_SORT[r];if(BX.type.isNotEmptyString(i.OPTIONS[o]))l.push(i.OPTIONS[o])}}else if(BX.type.isArray(i.OPTIONS)){l=i.OPTIONS}if(l===undefined||l===null||l.constructor!==Object&&l.constructor!==Array||l.length===0){this.variants=[];this.items=[document.createTextNode(BX.message("INPUT_ENUM_OPTIONS_ERROR"))];return}t=this.getValueObject(t);if(this.multielement){var s="radio",a=this,u=this.multitag,p=[];if(this.multiple){s="checkbox";n+="[]"}this.createEditorOptions(null,l,t,function(t){var e=document.createElement("legend");e.appendChild(document.createTextNode(t));var n=document.createElement("fieldset");n.appendChild(e);p.push(n);return n},function(t,l,r,o){var d=document.createElement("input");d.type=s;d.name=n;d.value=l;d.checked=r;d.disabled=a.disabled;if(a.form)d.setAttribute("form",a.form);a.applyEventAttributesTo(d,i,Utils.globalEventAttributes);var c=document.createElement("label");c.appendChild(d);c.appendChild(document.createTextNode(" "+o+" "));var E;if(u){E=document.createElement(u);E.appendChild(c)}else{E=c}if(t)t.appendChild(E);else p.push(E);e.push(d)});this.items=p}else{var d=document.createElement("select");if(this.multiple){d.name=n+"[]";d.multiple=true}else{d.name=n}Utils.applyBooleanAttributesTo(d,i,Utils.globalBooleanAttributes,{DISABLED:"",AUTOFOCUS:"",REQUIRED:""});Utils.applyValueAttributesTo(d,i,Utils.globalValueAttributes,{FORM:1,SIZE:1});this.applyEventAttributesTo(d,i,Utils.globalEventAttributes);this.createEditorOptions(d,l,t,function(t){var e=document.createElement("optgroup");e.label=t;d.appendChild(e);return e},function(t,n,i,l){var r=document.createElement("option");r.text=l;r.value=n;r.selected=i;t.appendChild(r);e.push(r)});if(i.REQUIRED=="N"){var c=document.createElement("option");c.text=BX.message("INPUT_ENUM_EMPTY_OPTION");c.value="";if(Object.keys(t).length===0)c.selected="selected";d.insertBefore(c,d.firstChild);e.push(c)}this.items=[d]}this.variants=e};EnumInput.prototype.createEditorOptions=function(t,e,n,i,l){var r,o,s;for(r in e){if(e.hasOwnProperty(r)){o=e[r];s=this.settings.OPTIONS_SORT[r];if(o.constructor===Object)this.createEditorOptions(i(s),o,n,i,l);else l(t,s,n.hasOwnProperty(s),o||s)}}};EnumInput.prototype.setValue=function(t){t=this.getValueObject(t);var e=this.variants,n=this.multielement,i=0,l=e.length,r;for(;i<l;i++){r=e[i];r[n?"checked":"selected"]=t.hasOwnProperty(r.value)}};EnumInput.prototype.getValue=function(){var t=[],e=this.variants,n=this.multielement,i=0,l=e.length,r;for(;i<l;i++){r=e[i];if(r[n?"checked":"selected"])t.push(r.value)}return this.multiple?t:Utils.asSingle(t)};EnumInput.prototype.setDisabled=function(t){if(this.multielement){var e=this.variants,n=0,i=e.length;for(;n<i;n++)e[n].disabled=t}else{this.items[0].disabled=t}};EnumInput.prototype.addEvent=function(t,e){e=this.createEventHandler(e);if(this.multielement){var n=this.variants,i=0,l=n.length;for(;i<l;i++)Utils.addEventTo(n[i],t,e)}else{Utils.addEventTo(this.items[0],t,e)}};Module.FileInput=FileInput;Utils.extend(FileInput,BaseInput);Module.Manager.register("FILE",FileInput);function FileInput(t,e,n,i){FileInput.__super__.constructor.call(this,t,e,n,i)}FileInput.prototype.createEditorSingle=function(t,e){var n=this,i=this.settings;var l=document.createElement("a");var r=document.createElement("input");r.type="hidden";r.name=t+"[ID]";r.disabled=this.disabled;if(this.form)r.setAttribute("form",this.form);var o=document.createElement("input");o.type="file";o.name=t;o.style.position="absolute";o.style.visibility="hidden";Utils.applyBooleanAttributesTo(o,i,Utils.globalBooleanAttributes,{DISABLED:"",AUTOFOCUS:"",REQUIRED:""});Utils.applyValueAttributesTo(o,i,Utils.globalValueAttributes,{FORM:1,ACCEPT:1});this.applyEventAttributesTo(o,i,Utils.globalEventAttributes);var s=function(t){o.value="";n.setAnchor(l,l.value);Utils.removeEventFrom(l,"click",s);return Utils.stopElementEvents(t)};Utils.addEventTo(o,"change",function(){var t=o.value;if(t){var e=l.firstChild;if(e)l.removeChild(e);l.removeAttribute("href");l.title=BX.message("INPUT_FILE_RESET");l.appendChild(document.createTextNode(t.split(/(\\|\/)/g).pop()));Utils.addEventTo(l,"click",s)}else{s()}});var a=document.createElement("input");a.type="button";a.value=BX.message("INPUT_FILE_BROWSE");a.style.margin="5px 10px";Utils.addEventTo(a,"click",function(){o.click()});var u=[l,r,o,a];this.setValueSingle(u,e);var p=this.createEditorSingleDeletor(u);p.setName(t+"[DELETE]");u.deletor=p;u.push(p);return u};FileInput.prototype.setAnchor=function(t,e){var n=t.firstChild,i=e.SRC,l=e.ID;if(n){t.removeChild(n);n=null}if(i){t.href=i;t.target="_blank";t.title=BX.message("INPUT_FILE_DOWNLOAD");switch(i.split(".").pop()){case"jpg":case"bmp":case"jpeg":case"jpe":case"gif":case"png":n=document.createElement("img");n.src=i;n.style.maxWidth="100px";n.style.maxHeight="100px";t.appendChild(n)}}else{t.removeAttribute("href");t.removeAttribute("target");t.removeAttribute("title")}if(!n&&l){t.appendChild(document.createTextNode(e.ORIGINAL_NAME||e.FILE_NAME||l))}};FileInput.prototype.setValueSingle=function(t,e){if(e%1===0){e={ID:e}}else if(!e.hasOwnProperty("ID")){e={}}var n=t[0];n.value=e;this.setAnchor(n,e);var i=t[1];i.value=e.ID};FileInput.prototype.getValueSingle=function(t){var e=t[1];return e.disabled?null:e.value};FileInput.prototype.setDisabledSingle=function(t,e){var n=t[2],i=t[3];n.disabled=e;i.disabled=e};FileInput.prototype.addEventSingle=function(t,e,n){var i=t[2];Utils.addEventTo(i,e,n)};FileInput.prototype.afterEditorSingleInsert=function(t){var e=t[3];e.focus()};Module.DateInput=DateInput;Utils.extend(DateInput,BaseInput);Module.Manager.register("DATE",DateInput);function DateInput(t,e,n,i){DateInput.__super__.constructor.call(this,t,e,n,i)}DateInput.prototype.createEditorSingle=function(t,e){var n=this.settings,i=n.TIME=="Y";var l=document.createElement("input");l.type="text";l.name=t;l.value=e;Utils.applyBooleanAttributesTo(l,n,Utils.globalBooleanAttributes,{DISABLED:"",READONLY:"",AUTOFOCUS:"",REQUIRED:"",AUTOCOMPLETE:"on"});Utils.applyValueAttributesTo(l,n,Utils.globalValueAttributes,{FORM:1,LIST:1});this.applyEventAttributesTo(l,n,Utils.globalEventAttributes);l.setAttribute("size",i?"20":"10");var r=document.createElement("input");r.type="button";r.value=BX.message("INPUT_DATE_SELECT");r.disabled=this.disabled;r.style.margin="0 10px";Utils.addEventTo(r,"click",function(){BX.calendar({node:r,field:t,form:"",bTime:i,bHideTime:false})});return[l,r]};DateInput.prototype.afterEditorSingleInsert=function(t){t[0].focus()};DateInput.prototype.setValueSingle=function(t,e){t[0].value=e};DateInput.prototype.getValueSingle=function(t){var e=t[0];return e.disabled?null:e.value};DateInput.prototype.setDisabledSingle=function(t,e){t[0].disabled=e;t[1].disabled=e};DateInput.prototype.addEventSingle=function(t,e,n){Utils.addEventTo(t[0],e,n)};Module.LocationInput=LocationInput;Utils.extend(LocationInput,BaseInput);Module.Manager.register("LOCATION",LocationInput);function LocationInput(t,e,n,i){LocationInput.__super__.constructor.call(this,t,e,n,i);var l=this;i.getValuePath=function(){return l.getValuePath()}}LocationInput.prototype.getValuePath=function(){if(this.multiple){var t=[],e=this.items,n=this.multitag,i=0,l=e.length,r;for(;i<l;i++){r=this.getValuePathSingle(n?e[i].childNodes:e[i]);if(r!==undefined&&r!==null&&r!=="")t.push(r)}return t}else{return this.getValuePathSingle(this.items)}};LocationInput.prototype.createEditorSingle=function(t,e){return BX.Sale.InputManager.locationLoader.display({properties:{INPUT_NAME:t,CODE:e},parent:this})};LocationInput.prototype.setValueSingle=function(t,e){var n=BX.data(t[0],"sale-location-property-link");n.setValueByLocationCode(e)};LocationInput.prototype.getValueSingle=function(t){var e=BX.data(t[0],"sale-location-property-link");if(!e){BX.debug("loc undefined!");return null}return e.getValue()};LocationInput.prototype.getValuePathSingle=function(t){var e=BX.data(t[0],"sale-location-property-link");if(!e){BX.debug("loc undefined!");return null}return e.getSelectedPath()};LocationInput.prototype.setDisabledSingle=function(t,e){var n=BX.data(t[0],"sale-location-property-link");n[e?"disable":"enable"]()};LocationInput.prototype.addEventSingle=function(t,e,n){if(e!="change")throw new Error("action is not supported");var i=BX.data(t[0],"sale-location-property-link");if(!i){BX.debug("loc undefined!");return false}i.bindEvent("after-select-item",n);i.bindEvent("after-deselect-item",n);return true};Module.AddressInput=AddressInput;Utils.extend(AddressInput,BaseInput);Module.Manager.register("ADDRESS",AddressInput);function AddressInput(t,e,n,i){AddressInput.__super__.constructor.call(this,t,e,n,i)}AddressInput.prototype.getValuePath=function(){};AddressInput.prototype.createEditorSingle=function(t,e){if(!BX.Sale.AddressControlConstructor){return[document.createElement("span")]}var n=new BX.Sale.AddressControlConstructor({propsData:{name:t,initValue:e?JSON.stringify(e):null,isLocked:false}});n.$mount();return[n.$el]};AddressInput.prototype.setValueSingle=function(t,e){};AddressInput.prototype.getValueSingle=function(t){};AddressInput.prototype.setDisabledSingle=function(t,e){};AddressInput.prototype.addEventSingle=function(t,e,n){};Module.UserFieldInput=UserFieldInput;Utils.extend(UserFieldInput,BaseInput);Module.Manager.register("UF",UserFieldInput);function UserFieldInput(t,e,n,i){UserFieldInput.__super__.constructor.call(this,t,e,n,i)}UserFieldInput.prototype.createEditor=function(t){var e=document.createElement("div");if(BX.type.isNotEmptyString(this.settings.EDIT_HTML))e.innerHTML=this.settings.EDIT_HTML;this.items=[e]};UserFieldInput.prototype.afterEditorSingleInsert=function(t){t[0].focus()};UserFieldInput.prototype.setValueSingle=function(t,e){t[0].value=e};UserFieldInput.prototype.getValueSingle=function(t){var e=t[0];return e.disabled?null:e.value};UserFieldInput.prototype.setDisabledSingle=function(t,e){t[0].disabled=e};UserFieldInput.prototype.addEventSingle=function(t,e,n){Utils.addEventTo(t[0],e,n)};return Module}();BX.Sale.InputManager={};BX.Sale.InputManager.locationLoader=function(){};BX.Sale.InputManager.locationLoader.etalon=null;BX.Sale.InputManager.locationLoader.spawn=function(t){var e=this;var n=e.etalon.spawn(t.scope,{useSpawn:false,initializeByGlobalEvent:false});n.clearSelected();n.setTargetInputName(t.properties.INPUT_NAME);if(typeof t.properties.CODE!="undefined"&&t.properties.CODE!=null){n.setValueByLocationCode(t.properties.CODE)}BX.data(t.scope,"sale-location-property-link",n);return n};BX.Sale.InputManager.locationLoader.preload=function(t,e){var n=this;if(this.etalon!=null){if(BX.type.isFunction(e.success))e.success();return}BX.ajax({url:"/bitrix/tools/sale_location_loader.php",method:"post",dataType:"html",async:true,processData:false,emulateOnload:true,start:true,data:t,onsuccess:function(t){var i=BX.create("div",{style:{display:"none"}});BX.append(i,document.getElementsByTagName("body")[0]);BX.html(i,t,{htmlFirst:true,callback:function(){n.etalon=BX.locationSelectors["SALE_LOCATION_SELECTOR_RESOURCES"];BX.onCustomEvent(n,"bx-sale-location-preloaded",[n.etalon,null]);if(BX.type.isFunction(e.success))e.success()}})},onfailure:function(t,i){if(BX.type.isFunction(e.fail))e.fail.apply(n,arguments);BX.onCustomEvent(n,"bx-sale-location-preloaded",[null,arguments])}})};BX.Sale.InputManager.locationLoader.display=function(t){var e=this;if(typeof BX.locationSelectors!="undefined"&&typeof BX.locationSelectors["SALE_LOCATION_SELECTOR_RESOURCES"]!="undefined")e.etalon=BX.locationSelectors["SALE_LOCATION_SELECTOR_RESOURCES"];t.scope=BX.create("div");if(this.etalon!=null){t.parent.loc=e.spawn(t)}else{e.preload(t.properties,{success:function(){t.parent.loc=e.spawn(t)},fail:function(){t.scope.innerHTML="Network failure"}})}return[t.scope]};
//# sourceMappingURL=input.map.js