(function(){"use strict";BX.namespace("BX.UI");BX.UI.ActionPanel=function(t){this.groupActions=t.groupActions;this.layout={container:null,itemContainer:null,more:null,reset:null,totalSelected:null,totalSelectedItem:null};this.itemContainer=null;this.className=t.className;this.renderTo=t.renderTo;this.darkMode=t.darkMode;this.floatMode=typeof t.floatMode==="undefined"?true:t.floatMode;this.alignItems=t.alignItems;this.items=[];this.hiddenItems=[];this.grid=null;this.tileGrid=null;this.maxHeight=t.maxHeight;this.params=t.params||{};this.parentPosition=t.parentPosition;this.mutationObserver=null;this.panelIsFixed=null;this.removeLeftPosition=t.removeLeftPosition;this.pinnedMode=typeof t.pinnedMode==="undefined"?false:t.pinnedMode;this.autoHide=typeof t.autoHide==="undefined"?true:t.autoHide;this.showTotalSelectedBlock=typeof t.showTotalSelectedBlock==="undefined"?true:t.showTotalSelectedBlock;this.showResetAllBlock=typeof t.showResetAllBlock==="undefined"?this.pinnedMode?false:true:t.showResetAllBlock;this.buildPanelContainer();if(this.pinnedMode){this.buildPanelByGroup()}BX.onCustomEvent("BX.UI.ActionPanel:created",[this])};BX.UI.ActionPanel.prototype={bindEvents:function(){if(this.params.tileGridId){BX.addCustomEvent("BX.TileGrid.Grid::ready",this.handleTileGridReady.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:selectItem",this.handleTileSelectItem.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:checkItem",this.handleTileSelectItem.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:unSelectItem",this.handleTileUnSelectItem.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:redraw",this.hidePanel.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:defineEscapeKey",this.hidePanel.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:lastSelectedItem",this.hidePanel.bind(this));BX.addCustomEvent(window,"BX.TileGrid.Grid:multiSelectModeOff",this.hidePanel.bind(this))}if(this.params.gridId){BX.addCustomEvent("Grid::ready",this.handleGridReady.bind(this));BX.addCustomEvent("Grid::thereSelectedRows",this.handleGridSelectItem.bind(this));BX.addCustomEvent("Grid::allRowsSelected",this.handleGridSelectItem.bind(this));BX.addCustomEvent("Grid::updated",this.hidePanel.bind(this));BX.addCustomEvent("Grid::noSelectedRows",this.hidePanel.bind(this));BX.addCustomEvent("Grid::allRowsUnselected",this.hidePanel.bind(this))}if(this.autoHide){BX.bind(window,"click",this.handleOuterClick.bind(this))}if(this.floatMode){BX.bind(window,"scroll",BX.throttle(this.handleScroll,50,this))}BX.addCustomEvent(this,"BX.UI.ActionPanel:clickResetAllBlock",this.hidePanel.bind(this));BX.bind(window,"resize",BX.throttle(this.handleResize,20,this));this.getMutationObserver().observe(document.body,this.getMutationObserverParam())},getMutationObserver:function(){if(this.mutationObserver)return this.mutationObserver;this.mutationObserver=new MutationObserver(BX.throttle(this.adjustPanelStyle,20,this));return this.mutationObserver},getMutationObserverParam:function(){return{attributes:true,characterData:true,childList:true,subtree:true,attributeOldValue:true,characterDataOldValue:true}},getItemById:function(t){return this.items.find((function(e){return e.id===t}))},addItems:function(t){t.forEach(function(t){this.appendItem(t)}.bind(this));this.fillHiddenItems();if(this.hiddenItems.length>0&&!this.layout.more){this.appendMoreBlock()}else if(this.layout.more){this.removeMoreBlock()}},buildItem:function(t){t.actionPanel=this;return new BX.UI.ActionPanel.Item(t)},appendItem:function(t){if(t.hiddenInPanel!==true){var e=this.buildItem(t);this.items.push(e);this.layout.itemContainer.appendChild(e.render())}},addHiddenItem:function(t){this.hiddenItems.push(t)},removeHiddenItem:function(t){for(var e=0;e<this.hiddenItems.length;e++){if(this.hiddenItems[e].id===t.id){delete this.hiddenItems[e];this.hiddenItems.splice(e,1);return}}},fillHiddenItems:function(){this.hiddenItems=[];this.items.forEach((function(t){if(t.isNotFit()){this.addHiddenItem(t)}}),this)},removeItems:function(){this.items.forEach((function(t){t.destroy()}));this.items=[];this.hiddenItems=[]},getMoreBlock:function(){if(!this.layout.more){this.layout.more=BX.create("div",{props:{className:"ui-action-panel-more"},text:BX.message("JS_UI_ACTIONPANEL_MORE_BLOCK"),events:{click:this.handleClickMoreBlock.bind(this)}})}return this.layout.more},appendMoreBlock:function(){this.layout.container.appendChild(this.getMoreBlock());this.fillHiddenItems()},getResetAllBlock:function(){this.layout.reset=BX.create("div",{props:{className:"ui-action-panel-reset"}});this.removeLeftPosition?BX.addClass(this.layout.reset,"ui-action-panel-reset-ordert-first"):null;BX.bind(this.layout.reset,"click",function(){BX.onCustomEvent(this,"BX.UI.ActionPanel:clickResetAllBlock");this.resetAllSection()}.bind(this));return this.layout.reset},resetAllSection:function(){if(this.grid){this.grid.getRows().unselectAll();this.grid.adjustCheckAllCheckboxes()}else if(this.tileGrid){this.tileGrid.resetSetMultiSelectMode();this.tileGrid.resetSelectAllItems();this.tileGrid.resetFromToItems()}},handleScroll:function(){if(this.getDistanceFromTop()>0){if(this.panelIsFixed)this.unfixPanel()}else{if(!this.panelIsFixed)this.fixPanel()}var t=BX.PopupMenu.getMenuById("ui-action-panel-item-popup-menu");if(t){t.popupWindow.adjustPosition()}},handleOuterClick:function(t){var e=BX.getEventTarget(t);if(BX.hasClass(e,"ui-action-panel")){return}if(BX.findParent(e,{className:"ui-action-panel"})){return}if(BX.findParent(e,{className:"main-grid-container"})){return}if(BX.findParent(e,{className:"ui-grid-tile-item"})){return}if(BX.findParent(e,{className:"main-kanban-item"})){return}this.hidePanel();if(this.grid){this.resetAllSection()}},handleClickMoreBlock:function(t){for(var e=0;e<this.hiddenItems.length;e++){if(this.hiddenItems[e].buttonIconClass&&this.hiddenItems[e].text.length===0){this.hiddenItems[e].className="menu-popup-no-icon ui-btn ui-btn-link "+this.hiddenItems[e].buttonIconClass;this.hiddenItems[e].html="<span></span>"}}var i=new BX.PopupMenuWindow({bindElement:this.getMoreBlock(),className:"ui-action-panel-item-popup-menu",angle:true,offsetLeft:this.getMoreBlock().offsetWidth/2,closeByEsc:true,items:this.hiddenItems,events:{onPopupShow:function(){BX.bind(i.popupWindow.popupContainer,"click",(function(t){var e=BX.getEventTarget(t);var n=BX.findParent(e,{className:"menu-popup-item"},10);if(!n||!n.dataset.preventCloseContextMenu){i.close()}}))},onPopupClose:function(){i.destroy();BX.removeClass(this.getMoreBlock(),"ui-action-panel-item-active")}.bind(this)}});i.layout.menuContainer.setAttribute("data-tile-grid","tile-grid-stop-close");i.show()},removeMoreBlock:function(){if(!this.layout.more)return;this.layout.more.parentNode.removeChild(this.layout.more);this.layout.more=null},getDistanceFromTop:function(){return this.resolveRenderContainer().getBoundingClientRect().top},fixPanel:function(){BX.addClass(this.layout.container,"ui-action-panel-fixed");this.panelIsFixed=true},unfixPanel:function(){BX.removeClass(this.layout.container,"ui-action-panel-fixed");this.panelIsFixed=null},buildPanelContainer:function(){this.layout.container=BX.create("div",{attrs:{className:["ui-action-panel",this.darkMode?"ui-action-panel-darkmode":"",this.className].join(" ")},dataset:{tileGrid:"tile-grid-stop-close"},children:[this.showTotalSelectedBlock?this.getTotalSelectedBlock():null,this.getItemContainer(),this.showResetAllBlock?this.getResetAllBlock():null]});this.maxHeight?this.layout.container.style.maxHeight=this.maxHeight+"px":null},getItemContainer:function(){return this.layout.itemContainer=BX.create("div",{props:{className:"ui-action-panel-wrapper"},style:{textAlign:this.alignItems?this.alignItems:null}})},getTotalSelectedBlock:function(){return this.layout.totalSelected=BX.create("div",{props:{className:this.removeLeftPosition?"ui-action-panel-total ui-action-panel-total-without-border":"ui-action-panel-total"},dataset:{role:"action-panel-total"},children:[BX.create("span",{props:{className:"ui-action-panel-total-label"},text:BX.message("JS_UI_ACTIONPANEL_IS_SELECTED")}),this.layout.totalSelectedItem=BX.create("span",{props:{className:"ui-action-panel-total-param"},dataset:{role:"action-panel-total-param"}})]})},getPanelContainer:function(){return this.layout.container},adjustPanelStyle:function(){var t=BX.pos(this.resolveRenderContainer());var e=0;if(this.maxHeight){e=t.height-this.maxHeight}this.layout.container.style.width=t.width+"px";this.layout.container.style.top=t.top+e+"px";this.panelIsFixed?this.layout.container.style.left=this.resolveRenderContainer().getBoundingClientRect().left+"px":this.layout.container.style.left=t.left+"px"},handleResize:function(){this.adjustPanelStyle();this.fillHiddenItems();if(this.hiddenItems.length>0){this.layout.more||this.appendMoreBlock()}else{!this.layout.more||this.removeMoreBlock()}},handleGridReady:function(t){if(!this.grid&&t.getContainerId()===this.params.gridId){this.grid=t}},handleTileGridReady:function(t){if(!this.tileGrid&&t.getId()===this.params.tileGridId){this.tileGrid=t}},handleGridUnSelectItem:function(t,e){if(e.getRows().getSelectedIds().length===1){this.buildPanelByItem(e.getRows().getSelected().pop())}},handleTileUnSelectItem:function(t,e){if(this.showTotalSelectedBlock){this.setTotalSelectedItems(e.getSelectedItems().length)}if(e.getSelectedItems().length===1){this.buildPanelByItem(e.getSelectedItems().pop())}},handleGridSelectItem:function(){if(this.showTotalSelectedBlock){this.setTotalSelectedItems(this.grid.getRows().getSelectedIds().length)}if(this.grid.getRows().getSelectedIds().length>1){this.buildPanelByGroup()}else{this.buildPanelByItem(this.grid.getRows().getSelected().pop())}},handleTileSelectItem:function(t,e){if(this.showTotalSelectedBlock){this.setTotalSelectedItems(e.getSelectedItems().length)}if(e.isMultiSelectMode()&&e.getSelectedItems().length>1){this.buildPanelByGroup()}else{this.buildPanelByItem(t)}},buildPanelByItem:function(t){var e=t.getActions();var i=[];e.forEach(function(t){if(!t.hideInActionPanel){i.push(t)}}.bind(this));this.removeItems();this.addItems(i);this.showPanel();if(this.hiddenItems.length<=0)this.removeMoreBlock()},buildPanelByGroup:function(){if(!this.groupActions){return}var t=this.extractButtonsFromGroupActions(this.groupActions);this.removeItems();this.addItems(t);this.showPanel()},setTotalSelectedItems:function(t){if(this.layout.totalSelectedItem){this.layout.totalSelectedItem.innerHTML=t}},extractButtonsFromGroupActions:function(t){var e=BX.clone(t);if(!e["GROUPS"]||!e["GROUPS"][0]||!e["GROUPS"][0]["ITEMS"]){return[]}var i=[];var n=e["GROUPS"][0]["ITEMS"];n.forEach((function(t){if(t.TYPE==="BUTTON"){var e=t.ONCHANGE.pop();if(e&&e.ACTION==="CALLBACK"){var n=e.DATA.pop();i.push({id:t.ID||t.VALUE,text:t.TEXT||t.NAME,title:t.TITLE,iconOnly:t.ICON_ONLY,additionalClassForPanel:t.ADDITIONAL_CLASS_FOR_PANEL,hiddenInPanel:t.HIDDEN_IN_PANEL,icon:t.ICON,disabled:t.DISABLED,onclick:n.JS})}}else if(t.TYPE==="DROPDOWN"){i.push({id:t.ID||t.VALUE,text:t.TEXT||t.NAME,title:t.TITLE,iconOnly:t.ICON_ONLY,additionalClassForPanel:t.ADDITIONAL_CLASS_FOR_PANEL,hiddenInPanel:t.HIDDEN_IN_PANEL,icon:t.ICON,submenuOptions:t.SUBMENU_OPTIONS||{},disabled:t.DISABLED,items:t.ITEMS})}}));return i},showPanel:function(){BX.onCustomEvent(this,"BX.UI.ActionPanel:showPanel",[this]);if(this.pinnedMode){this.activatePanelItems()}if(BX.hasClass(this.layout.container,"ui-action-panel-show"))return;BX.addClass(this.layout.container,"ui-action-panel-show");BX.addClass(this.layout.container,"ui-action-panel-show-animate");var t=BX.pos(this.resolveRenderContainer());this.layout.container.style.setProperty("height",t.height+"px");BX.addClass(document.body,"ui-action-panel-shown");setTimeout(function(){BX.removeClass(this.layout.container,"ui-action-panel-show-animate")}.bind(this),300)},disableActionItems:function(){this.items.forEach((function(t){this.disableItem(t)}),this)},hidePanel:function(){BX.onCustomEvent(this,"BX.UI.ActionPanel:hidePanel",[this]);if(this.pinnedMode){this.disablePanelItems();return}BX.removeClass(this.layout.container,"ui-action-panel-show");BX.removeClass(this.layout.container,"ui-action-panel-show-animate");BX.addClass(this.layout.container,"ui-action-panel-hide-animate");BX.removeClass(document.body,"ui-action-panel-shown");setTimeout(function(){BX.removeClass(this.layout.container,"ui-action-panel-hide-animate")}.bind(this),300)},activatePanelItems:function(){if(this.layout.totalSelected){this.layout.totalSelected.classList.remove("ui-action-panel-item-is-disabled")}},disablePanelItems:function(){this.disableActionItems();if(this.layout.totalSelected){this.layout.totalSelected.classList.add("ui-action-panel-item-is-disabled")}var t=document.querySelector('[data-role="action-panel-total-param"]');if(t){t.textContent="0"}},resolveRenderContainer:function(){if(BX.type.isDomNode(this.renderTo)){return this.renderTo}if(BX.type.isFunction(this.renderTo)){var t=this.renderTo.call();if(BX.type.isDomNode(t)){return t}}throw new Error("BX.UI.ActionPanel: 'this.renderTo' has to be DomNode or function which returns DomNode")},draw:function(){this.bindEvents();document.body.appendChild(this.getPanelContainer());this.adjustPanelStyle();if(this.pinnedMode){this.disablePanelItems()}setTimeout(function(){this.handleResize()}.bind(this))},disableItem:function(t){if(t){t.disable()}}}})();
//# sourceMappingURL=panel.map.js