/* eslint-disable */
this.BX = this.BX || {};
this.BX.UI = this.BX.UI || {};
(function (exports,main_core) {
	'use strict';

	/**
	 * @namespace {BX.UI.IconSet}
	 */

	const Actions = Object.freeze({
	  ARROW_RIGHT: 'arrow-right',
	  ARROW_LEFT: 'arrow-left',
	  ARROW_TOP: 'arrow-top',
	  ARROW_DOWN: 'arrow-down',
	  CHEVRON_RIGHT: 'chevron-right',
	  CHEVRON_LEFT: 'chevron-left',
	  CHEVRON_UP: 'chevron-up',
	  CHEVRON_DOWN: 'chevron-down',
	  LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW_2: 'left-semicircular-anticlockwise-arrow-2',
	  EXPAND_1: 'expand-1',
	  EXPAND_DIAGONAL: 'expand-diagonal',
	  COLLAPSE: 'collapse',
	  COLLAPSE_DIAGONAL: 'collapse-diagonal',
	  AGENDA_GAP: 'agenda-gap',
	  EXPAND_TO_FULL_SCREEN: 'expand-to-full-screen',
	  CURVED_ARROW_LEFT: 'curved-arrow-left',
	  FORWARD: 'forward',
	  FORWARD_2: 'forward-2',
	  ARROW_DOWNLOAD: 'arrow-download',
	  PAUSE: 'pause',
	  STOP: 'stop',
	  PLAY: 'play',
	  LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW_1: 'left-semicircular-anticlockwise-arrow-1',
	  DOUBLE_SHEVRONS_RIGHT: 'double-shevrons-right',
	  NEXT: 'next',
	  DOWNLOAD_3: 'download-3',
	  UPLOAD: 'upload',
	  SWAP: 'swap',
	  SORT: 'sort',
	  LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW_3: 'left-semicircular-anticlockwise-arrow-3',
	  LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW_4: 'left-semicircular-anticlockwise-arrow-4',
	  DOWNLOAD: 'download',
	  DOWNLOAD_2: 'download-2',
	  DOWNLOAD_DOUBLE: 'download-double',
	  ARROW_TOP_2: 'arrow-top-2',
	  CONVERSION_1: 'conversion-1',
	  CONVERSION_2: 'conversion-2',
	  FORWARD_3: 'forward-3',
	  REPLY: 'reply',
	  FORWARD_2_1: 'forward-2-1',
	  REPLAY_ALL: 'replay-all',
	  OPEN_IN_50: 'open-in-50',
	  OPEN_IN_40: 'open-in-40',
	  OPEN_IN_30: 'open-in-30',
	  REFRESH_1: 'refresh-1',
	  REFRESH_2: 'refresh-2',
	  REFRESH_3: 'refresh-3',
	  REFRESH_4: 'refresh-4',
	  REDO_1: 'redo-1',
	  UNDO_1: 'undo-1',
	  REFRESH_5: 'refresh-5',
	  REDO_2: 'redo-2',
	  REFRESH_6: 'refresh-6',
	  REFRESH_7: 'refresh-7',
	  REFRESH_8: 'refresh-8',
	  SYNC_SETTINGS: 'sync-settings',
	  REFRESH_CLOSED: 'refresh-closed',
	  REFRESH_10: 'refresh-10',
	  CROSS_CIRCLE_50: 'cross-circle-50',
	  CROSS_CIRCLE_60: 'cross-circle-60',
	  CROSS_CIRCLE_70: 'cross-circle-70',
	  CROSS_20: 'cross-20',
	  CROSS_25: 'cross-25',
	  CROSS_30: 'cross-30',
	  CROSS_40: 'cross-40',
	  CROSS_45: 'cross-45',
	  CROSS_50: 'cross-50',
	  CROSS_55: 'cross-55',
	  CROSS_60: 'cross-60',
	  PLUS_IN_CIRCLE: 'plus-in-circle',
	  MINUS_IN_CIRCLE: 'minus-in-circle',
	  MINUS_20: 'minus-20',
	  MINUS_30: 'minus-30',
	  MINUS_40: 'minus-40',
	  MINUS_50: 'minus-50',
	  MINUS_60: 'minus-60',
	  LINE: 'line',
	  PLUS_20: 'plus-20',
	  PLUS_30: 'plus-30',
	  PLUS_40: 'plus-40',
	  PLUS_50: 'plus-50',
	  PLUS_60: 'plus-60',
	  MORE_9_CUBES: 'more-9-cubes',
	  MORE_9_CUBES_2: 'more-9-cubes-2',
	  CUBES_4_1: '4-cubes-1',
	  CUBES_4_2: '4-cubes-2',
	  MORE: 'more',
	  SETTINGS_1: 'settings-1',
	  SETTINGS_2: 'settings-2',
	  SETTINGS_3: 'settings-3',
	  SETTINGS_4: 'settings-4',
	  COPY_PLATES: 'copy-plates',
	  PLATES: 'plates',
	  NUMERABLE_LIST: 'numerable-list',
	  LINES: 'lines',
	  PENCIL_DRAW: 'pencil-draw',
	  PENCIL_60: 'pencil-60',
	  PENCIL_50: 'pencil-50',
	  PENCIL_40: 'pencil-40',
	  BRUSH: 'brush',
	  PEN: 'pen',
	  KEYBOARD: 'keyboard',
	  KEYBOARD_2: 'keyboard-2',
	  CONNECTION: 'connection',
	  DISCONNECTION: 'disconnection'
	});
	const Social = Object.freeze({
	  CLOUD_SIFRE: 'cloud-sifre',
	  SKYPE: 'skype',
	  VK_LISTS: 'vk-lists',
	  TELEGRAM_IN_CIRCLE_1: 'telegram-in-circle-1',
	  TELEGRAM: 'telegram',
	  TELEGRAM_IN_CIRCLE: 'telegram-in-circle',
	  INSTAGRAM: 'instagram',
	  INSTAGRAM_FACEBOOK: 'instagram-facebook',
	  INSTAGRAM_DIRECT: 'instagram-direct',
	  SNOWFLAKE: 'snowflake',
	  GLOBE: 'globe',
	  FACEBOOK: 'facebook',
	  FACEBOOK_CHATS: 'facebook-chats',
	  VK: 'vk',
	  VIBER: 'viber',
	  AVITO: 'avito',
	  ODNOKLASSNIKI: 'odnoklassniki',
	  WHATSAPP: 'whatsapp',
	  SHAPE_1: 'shape-1',
	  KIK: 'kik',
	  SLACK: 'slack',
	  MESSENGER_META: 'messenger-meta',
	  MESSENGER: 'messenger',
	  VK_SHOP: 'vk-shop',
	  WINDOWS: 'windows',
	  CALL_INFOMATION: 'call-infomation',
	  EVERNOTE: 'evernote',
	  GOOGLE_ADS: 'google-ads',
	  SHAPE: 'shape',
	  WINDOW_SCREEN: 'window-screen',
	  EDNA: 'edna',
	  CHATS_24: 'chats-24',
	  CHATS_COMPUTER: 'chats-computer',
	  APPLE_AND_IOS: 'apple-and-ios',
	  ANDROID: 'android',
	  ZOOM: 'zoom',
	  LINUX: 'linux'
	});
	const Main = Object.freeze({
	  PERSON_LOCATION: 'person-location',
	  PERSONS_HAND: 'persons-hand',
	  PERSON_ARROW_DOWN: 'person-arrow-down',
	  PERSON: 'person',
	  PERSON_CAMERA: 'person-camera',
	  PERSON_PLUS: 'person-plus',
	  PERSONS_DENY: 'persons-deny',
	  PERSON_CLOCK: 'person-clock',
	  PERSON_CLOCK_2: 'person-clock-2',
	  PERSONS_2: 'persons-2',
	  PERSONS_3: 'persons-3',
	  PERSON_LETTER: 'person-letter',
	  PERSON_MESSAGE: 'person-message',
	  PERSON_ARROW_LEFT_1: 'person-arrow-left-1',
	  PERSON_ARROW_RIGHT: 'person-arrow-right',
	  PERSON_ARROW_LEFT_2: 'person-arrow-left-2',
	  PERSON_FLAG: 'person-flag',
	  PERSON_HANDSET: 'person-handset',
	  PERSON_MESSAGE_ARROW_1: 'person-message-arrow-1',
	  PERSON_CHECK: 'person-check',
	  PERSON_MESSAGE_ARROW_2: 'person-message-arrow-2',
	  PERSONS_STORAGE: 'persons-storage',
	  PERSON_CALL: 'person-call',
	  PERSON_PHONE: 'person-phone',
	  PERSON_DESCENDING: 'person-descending',
	  PERSON_3_STICKS: 'person-3-sticks',
	  PERSON_2_CHECKS: 'person-2-checks',
	  PERSON_PLUS_3: 'person-plus-3',
	  CLOUD_SYNC: 'cloud-sync',
	  CLOUD_TRANSFER_DATA: 'cloud-transfer-data',
	  CLOUD_PAUSE: 'cloud-pause',
	  CLOUD_ERROR: 'cloud-error',
	  CLOUD_CLOCK: 'cloud-clock',
	  CLOUD_EMPTY: 'cloud-empty',
	  CLOUD_CLOUD: 'cloud-cloud',
	  CLOUD_LETTER_POST: 'cloud-letter-post',
	  CLOUD_SSO: 'cloud-sso',
	  TELEPHONY_HANDSET_1: 'telephony-handset-1',
	  TELEPHONY_HANDSET_2: 'telephony-handset-2',
	  TELEPHONY_HANDSET_3: 'telephony-handset-3',
	  TELEPHONY_HANDSET_4: 'telephony-handset-4',
	  TELEPHONY_HANDSET_5: 'telephony-handset-5',
	  TELEPHONY_HANDSET_6: 'telephony-handset-6',
	  OUTGOING_CALL: 'outgoing-call',
	  INCOMING_CALL: 'incoming-call',
	  TELEPHONY_PHONEBOOK: 'telephony-phonebook',
	  telephony_phonebook_2: 'telephony-phonebook-2',
	  CALL_CHAT: 'call-chat',
	  CHATS_1: 'chats-1',
	  CHATS_2: 'chats-2',
	  CHAT_MESSAGE: 'chat-message',
	  CHATS_WITH_CHECK: 'chats-with-check',
	  CHATS_3: 'chats-3',
	  MESSAGE_CHAT_WITH_POINT: 'message-chat-with-point',
	  MESSAGE_CHAT_WITH_ARROW: 'message-chat-with-arrow',
	  CHAT_BUTTON: 'chat-button',
	  FEEDBACK: 'feedback',
	  ADD_CHAT: 'add-chat',
	  BOOKMARK_1: 'bookmark-1',
	  FOLDER_CURVED_ARROW: 'folder-curved-arrow',
	  FOLDER_24: 'folder-24',
	  FOLDER_PLUS: 'folder-plus',
	  FOLDER_EMPTY: 'folder-empty',
	  FOLDER_LEFT_ARROW: 'folder-left-arrow',
	  FOLDER_INFO: 'folder-info',
	  FOLDER_RIGHT_ARROW: 'folder-right-arrow',
	  NOTE_CIRCLE: 'note-circle',
	  WARNING_CIRCLE: 'warning-circle',
	  INFO_CIRCLE: 'info-circle',
	  WARNING: 'warning',
	  INFO: 'info',
	  HELP: 'help',
	  SMS: 'sms',
	  FILE: 'file',
	  LIST: 'list',
	  BLACK_LIST: 'black-list',
	  SHIELD_2_PLAIN: 'shield-2-plain',
	  SHIELD_2_CONTOUR: 'shield-2-contour',
	  SHIELD_2_CHECKED: 'shield-2-checked',
	  SHIELD_2_ATTENTION: 'shield-2-attention',
	  SHIELD_2_MENU: 'shield-2-menu',
	  SHIELD_2_TIME: 'shield-2-time',
	  SHIELD_2_DEFENDED: 'shield-2-defended',
	  SHIELD_2_UPDATE: 'shield-2-update',
	  SHIELD_2_CORE_PROBLEM: 'shield-2-core-problem',
	  FILE_UPLOAD: 'file-upload',
	  FILE_SYNC: 'file-sync',
	  FILE_ARROW_TOP: 'file-arrow-top',
	  FILE_DELETE: 'file-delete',
	  FILE_CHECK: 'file-check',
	  FILE_2: 'file-2',
	  FILE_DOWNLOAD: 'file-download',
	  FILE_ARROW_DOWN: 'file-arrow-down',
	  FILE_3: 'file-3',
	  HOURGLASS_SANDGLASS: 'hourglass-sandglass',
	  CLOCK_1: 'clock-1',
	  CLOCK_2: 'clock-2',
	  CLOCK_WITH_ARROW: 'clock-with-arrow',
	  STOPWATCH: 'stopwatch',
	  ALARM: 'alarm',
	  BLACK_CLOCK: 'black-clock',
	  SPEED_METER: 'speed-meter',
	  WATCH: 'watch',
	  SMART_PROCESS: 'smart-process',
	  SEARCH_1: 'search-1',
	  SEARCH_2: 'search-2',
	  RESTORE_PASSWORD: 'restore-password',
	  TASKS: 'tasks',
	  WINDOW_ARROW: 'window-arrow',
	  WINDOW_DOUBLE_CHECK_1: 'window-double-check-1',
	  WINDOW_RING: 'window-ring',
	  WINDOW_DOUBLE_CHECK_2: 'window-double-check-2',
	  WINDOW_CHECK_PENCIL: 'window-check-pencil',
	  WINDOW_CHECK_LINK: 'window-check-link',
	  WINDOW_FLAG: 'window-flag',
	  WINDOW_CHECK_WITH_FOLDER: 'window-check-with-folder',
	  WINDOW_WITH_POINT: 'window-with-point',
	  WINDOW_CHECK_ARROW: 'window-check-arrow',
	  VIDEO_1: 'video-1',
	  VIDEO_3: 'video-3',
	  VIDEO_AND_CHAT: 'video-and-chat',
	  NO_VIDEO: 'no-video',
	  PICTURE: 'picture',
	  MICROPHONE_ON: 'microphone-on',
	  CAMERA: 'camera',
	  ATTACH_PICTURE: 'attach-picture',
	  SOUND_ON: 'sound-on',
	  SOUND_OFF: 'sound-off',
	  SOUND_2: 'sound-2',
	  VIDEO_2: 'video-2',
	  SPEAKERPHONE: 'speakerphone',
	  HEADSET: 'headset',
	  MICROPHONE_OFF: 'microphone-off',
	  MUSIC_NOTE_2: 'music-note-2',
	  MUSIC_NOTE_3: 'music-note-3',
	  MUSIC_NOTE_1: 'music-note-1',
	  MARKET_1: 'market-1',
	  COPILOT_AI: 'copilot-ai',
	  COPILOT_AI_1: 'copilot-ai-1',
	  COPILOT_AI_2: 'copilot-ai-2',
	  LIST_AI: 'list-ai',
	  INFO_CIRCLE_PLUS: 'info-circle-plus',
	  SCREEN_BLACK_WHITE: 'screen-black-white',
	  BELL_1: 'bell-1',
	  HEART: 'heart',
	  SYNC_CIRCLE: 'sync-circle',
	  LIKE: 'like',
	  DISLIKE: 'dislike',
	  RULER_AND_PENCIL: 'ruler-and-pencil',
	  KEY: 'key',
	  MOBILE_2: 'mobile-2',
	  LOCK: 'lock',
	  PULSE: 'pulse',
	  ATTACH: 'attach',
	  FLAG_2: 'flag-2',
	  FAVORITE_0: 'favorite-0',
	  FAVORITE_1: 'favorite-1',
	  PULSE_CIRCLE: 'pulse-circle',
	  CROWN_2: 'crown-2',
	  CROWN_1: 'crown-1',
	  HOME: 'home',
	  SEND: 'send',
	  SUITCASE: 'suitcase',
	  SPANNER: 'spanner',
	  IDEA_LAMP: 'idea-lamp',
	  BOOK_CLOSED: 'book-closed',
	  EDIT_PENCIL: 'edit-pencil',
	  COMPASS: 'compass',
	  CHECK: 'check',
	  FUNNEL: 'funnel',
	  BRIGHTNESS: 'brightness',
	  EARTH_LANGUAGE: 'earth-language',
	  OBSERVER: 'observer',
	  OBSERVER_CLOSED: 'observer-closed',
	  BARCODE_1: 'barcode-1',
	  DOOR_OPENED: 'door-opened',
	  SHIELD: 'shield',
	  TRASH_BIN: 'trash-bin',
	  SUNGLASSES: 'sunglasses',
	  DEVICE_ROTATE: 'device-rotate',
	  PLAY_CIRCLE: 'play-circle',
	  CUT: 'cut',
	  CIRCLE_MINUS: 'circle-minus',
	  CIRCLE_CHECK: 'circle-check',
	  CIRCLE_PLUS: 'circle-plus',
	  UNAVAILABLE: 'unavailable',
	  CALENDAR_2: 'calendar-2',
	  LOCATION_1: 'location-1',
	  LOCATION_2: 'location-2',
	  LOCATION_PLUS: 'location-plus',
	  TIME_PICKER: 'time-picker',
	  MAP: 'map',
	  PIN_2: 'pin-2',
	  DOUBLE_RHOMBUS: 'double-rhombus',
	  FIRE: 'fire',
	  LIGHT_BOLD_SPARKLE: 'light-bold-sparkle',
	  LIGHT_BOLD: 'light-bold',
	  BOX: 'box',
	  DELIVERY_1: 'delivery-1',
	  DELIVERY_2: 'delivery-2',
	  CUBES_3: 'cubes-3',
	  DRAWER: 'drawer',
	  CUBE_PLUS: 'cube-plus',
	  CALENDAR_SLOTS: 'calendar-slots',
	  PAYMENT_TERMINAL: 'payment-terminal',
	  CALENDAR_SHARING: 'calendar-sharing',
	  TARGET_TIMER: 'target-timer',
	  TARGET: 'target',
	  MARKET_2: 'market-2',
	  BELL: 'bell',
	  SALE_TAG: 'sale-tag',
	  OPEN_LINES: 'open-lines',
	  CHEMISTRY: 'chemistry',
	  GRADUATION_CAP: 'graduation-cap',
	  PAINT_1: 'paint-1',
	  PAINT_2: 'paint-2',
	  FLAG_1: 'flag-1',
	  CREDIT_DEBIT_CARD: 'credit-debit-card',
	  LIGHTNING_PLUS: 'lightning-plus',
	  DONATION: 'donation',
	  B_24: 'b-24',
	  TAG: 'tag',
	  SPEAKER_MOUTHPIECE: 'speaker-mouthpiece',
	  OPENED_EYE: 'opened-eye',
	  CROSSED_EYE: 'crossed-eye',
	  LINKS_3: 'links-3',
	  IMPLEMENTATION_REQUEST: 'implementation-request',
	  GROUP: 'group',
	  DOCUMENT_STREAM: 'document-stream',
	  BOOK_OPEN_1: 'book-open-1',
	  FOLDERS: 'folders',
	  QR_CODE_1: 'qr-code-1',
	  QR_CODE_2: 'qr-code-2',
	  DESCENDING_SORT: 'descending-sort',
	  ASCENDING_SORT: 'ascending-sort',
	  CHATS_PERSONS: 'chats-persons',
	  MARKETING: 'marketing',
	  SIGMA_SUMM_A: 'sigma-summ-a',
	  SIGMA_SUMM: 'sigma-summ',
	  SMILE: 'smile',
	  GANTT_GRAPHS: 'gantt-graphs',
	  FILTER_PLUS: 'filter-plus',
	  BACKSPACE: 'backspace',
	  ELEMENTS: 'elements',
	  BOOK_OPENED_WITH_ARROW: 'book-opened-with-arrow',
	  DOUBLE_ARROW_COUNTER_CLOCKWISE_SCRUM: 'double-arrow-counter-clockwise-scrum',
	  BARCODE: 'barcode',
	  SAD_BOLD_EMOJI: 'sad-bold-emoji',
	  BRIGHTNESS_BOLD_EMOJI: 'brightness-bold-emoji',
	  SUN: 'sun',
	  FILIAL_NETWORK: 'filial-network',
	  ARROW_LINE: 'arrow-line',
	  IP: 'ip',
	  FILTER_1: 'filter-1',
	  FILTER_2: 'filter-2',
	  SCREEN_1: 'screen-1',
	  SCREEN_2: 'screen-2',
	  PRINT_1: 'print-1',
	  PRINT_2: 'print-2',
	  DISK: 'disk',
	  SHINING: 'shining',
	  SHINING_2: 'shining-2',
	  PLUG: 'plug',
	  PASTE: 'paste',
	  CROSSED_EYE_2: 'crossed-eye-2',
	  FILTER_BY_NAME: 'filter-by-name',
	  DESCENDING_SORT_NAMES: 'descending-sort-names',
	  TABLE: 'table',
	  FEED: 'feed',
	  MOBILE_WITH_STAR: 'mobile-with-star',
	  ROCKET: 'rocket',
	  CITY: 'city',
	  MAGIC_WAND: 'magic-wand',
	  MAGIC_IMAGE: 'magic-image',
	  AI: 'ai',
	  EARTH: 'earth',
	  SHARE_1: 'share-1',
	  SHARE_2: 'share-2',
	  MAIL: 'mail',
	  ERASER: 'eraser',
	  DEMONSTRATION_ON_1: 'demonstration-on-1',
	  DEMONSTRATION_OFF: 'demonstration-off',
	  FILE_CHECK_1: 'file-check-1',
	  DELETE_HYPERLINK: 'delete-hyperlink',
	  INSERT_HYPERLINK: 'insert-hyperlink',
	  LINK_3: 'link-3',
	  SCREEN_ARROW: 'screen-arrow',
	  OPENED_LETTER_MAIL: 'opened-letter-mail',
	  SITEMAP: 'sitemap',
	  NOTIFICATIONS_ON: 'notifications-on',
	  NOTIFICATIONS_OFF: 'notifications-off',
	  A_LETTER: 'a-letter',
	  TOPIC: 'topic',
	  FULL_BATTERY: 'full-battery',
	  BATTERY_2_STICKS: 'battery-2-sticks',
	  BATTERY_1_STICK: 'battery-1-stick',
	  LOW_BATTERY: 'low-battery',
	  DEAD_BATTERY: 'dead-battery',
	  DOCUMENT_PLUS: 'document-plus',
	  DEMONSTRATION_ON_2: 'demonstration-on-2',
	  RECEIPT_1: 'receipt-1',
	  RECEIPT_2: 'receipt-2',
	  CART_WITH_CURSOR: 'cart-with-cursor',
	  EXPAND: 'expand',
	  GIFT: 'gift',
	  MORE_POINTS: 'more-points',
	  PIN_1: 'pin-1',
	  MORE_INFORMATION: 'more-information',
	  MARKERS: 'markers',
	  FEED_BOLD: 'feed-bold',
	  STOP_HAND: 'stop-hand',
	  TARGET_1: 'target-1',
	  MAIL_OUT: 'mail-out',
	  MAIL_IN: 'mail-in',
	  MAIL_MONEY: 'mail-money',
	  UNPIN: 'unpin',
	  ATTENTION_I_CIRCLE: 'attention-i-circle',
	  INFO_1: 'info-1',
	  ATTENTION_I_BLACK: 'attention-i-black',
	  MENU: 'menu',
	  WAVES: 'waves',
	  MAIL_REPLY: 'mail-reply',
	  MAIL_2: 'mail-2',
	  MAIL_READ: 'mail-read',
	  QUOTE: 'quote',
	  NEW_MESSAGE_MAIL: 'new-message-mail',
	  INDENT: 'indent',
	  OUTDENT: 'outdent',
	  DISTRIBUTION: 'distribution',
	  MENU_POINT: 'menu-point',
	  LINES_TEXT: 'lines-text',
	  DIAMOND: 'diamond',
	  BOTTOM: 'bottom',
	  NUMBERS_123: 'numbers-123',
	  CURSOR_CLICK: 'cursor-click',
	  FLAG_WITH_CROSS: 'flag-with-cross',
	  TEMP_1: 'temp-1',
	  TEMP_2: 'temp-2',
	  CALENDAR_1: 'calendar-1',
	  CALENDAR_24: 'calendar-24',
	  WINDOW: 'window',
	  PLANNING: 'planning',
	  SORT_CALENDAR: 'sort-calendar',
	  CALENDAR_DEADLINE: 'calendar-deadline',
	  SORT_ACTIVITY: 'sort-activity',
	  PLANNING_2: 'planning-2',
	  MY_PLAN: 'my-plan',
	  CALENDAR_OFF: 'calendar-off',
	  SIGNAL_WIFI: 'signal-wifi',
	  SIGNAL_WIFI_OFF: 'signal-wifi-off',
	  IMG_FORMAT: 'img-format',
	  ATTACH_2: 'attach-2',
	  CRM: 'crm',
	  APPS: 'apps',
	  TEMPLATES: 'templates',
	  HR_AUTOMATION: 'hr-automation',
	  SITES_STORES: 'sites-stores',
	  C1: '1c',
	  REFRESH: 'refresh',
	  SUBSCRIPTION: 'subscription',
	  SETTINGS: 'settings',
	  SERVICES: 'services',
	  GRAPHS_DIAGRAM: 'graphs-diagram',
	  OPEN_BOOK: 'open-book',
	  ROBOT: 'robot',
	  DEVELOPER_RESOURCES: 'developer-resources',
	  CASH_TERMINAL: 'cash-terminal',
	  CLOCK_BLACK_WHITE: 'clock-black-white',
	  INVENTORY_MANAGEMENT: 'inventory-management',
	  COLLABORATION: 'collaboration',
	  DOCUMENT: 'document',
	  CHECK_RECEIPT: 'check-receipt',
	  CALCULATOR: 'calculator',
	  SWITCH: 'switch',
	  SEQUENTIAL_QUEUE: 'sequential-queue',
	  PARALLEL_QUEUE: 'parallel-queue',
	  CONDITION: 'condition',
	  COMPLETE: 'complete',
	  TRANSLATION: 'translation',
	  TORRENT: 'torrent',
	  ACTIVITY: 'activity',
	  ADD_TO_CHECKLIST: 'add-to-checklist',
	  BP: 'bp',
	  CLOSE_CHAT: 'close-chat',
	  CREATE_PROMPT: 'create-prompt',
	  DEVICES: 'devices',
	  DOCUMENT_SIGN: 'document-sign',
	  FAVOURITE_PROMPT: 'favourite-prompt',
	  LINES_VERTICAL: 'lines-vertical',
	  MAIN: 'main',
	  MOVE_TO_CHECKLIST: 'move-to-checklist',
	  OPEN_CHAT: 'open-chat',
	  PROMPT: 'prompt',
	  PROMPT_VAR: 'prompt-var',
	  PROMPTS_LIBRARY: 'prompts-library',
	  RECORD_VIDEO: 'record-video',
	  ROLES_LIBRARY: 'roles-library',
	  SAVE_PROMPT: 'save-prompt',
	  SCREEN_SHARE: 'screen-share',
	  SUB_POINT: 'sub-point',
	  UNSUB_POINT: 'unsub-point',
	  SUB_TASK: 'subtask',
	  COLLAB: 'collab',
	  NO_PICTURE: 'no-picture',
	  THREAD: 'thread',
	  THREAD_SINGLE: 'thread-single',
	  BUSINESS_PROCESS_1: 'business-process-1',
	  WAITING_POINTS: 'waiting-points',
	  WAITING_LIST: 'waiting-list',
	  LINK_BOLD: 'link-bold',
	  NOTE: 'note'
	});
	const ContactCenter = Object.freeze({
	  DIAL_5: 'dial-5',
	  DIAL_10: 'dial-10',
	  CALL_FORWARDING: 'call-forwarding',
	  MOBILE_STORE: 'mobile-store',
	  MAIL_SENT: 'mail-sent',
	  INCOMING_CALL_SOUND_ON: 'incoming-call-sound-on',
	  SEND_ATTACH_FILE: 'send-attach-file'
	});
	const Animated = Object.freeze({
	  LOADER_CLOCK: 'loader-clock',
	  LOADER_WAIT: 'loader-wait'
	});
	const CRM = Object.freeze({
	  SEND_CONTACT: 'send-contact',
	  BOOK_OPEN: 'book-open',
	  funnel_1: 'funnel-1',
	  CRM_SEARCH: 'crm-search',
	  REFRESH_9: 'refresh-9',
	  CHECK_IN_BOX: 'check-in-box',
	  ARROWS_MEET: 'arrows-meet',
	  CHAT_LINE: 'chat-line',
	  COMMERCIAL_OFFER: 'commercial-offer',
	  FUNNELS: 'funnels',
	  ITEM: 'item',
	  PROPOSAL_SETTINGS: 'proposal-settings',
	  PROPOSAL_DONE: 'proposal-done',
	  PROPOSAL: 'proposal',
	  CRM_GROUP: 'crm-group',
	  CONTACT: 'contact',
	  LEAD: 'lead',
	  INVOICE: 'invoice',
	  STAGES: 'stages',
	  EXCLUSION_LIST: 'exclusion-list',
	  OPEN_CHANNELS: 'open-channels',
	  APPROVED_LIST: 'approved-list crm-checked_1',
	  COMPANY: 'company',
	  COPY_FILE: 'copy-file',
	  GIRD: 'gird',
	  FUNNEL_2: 'funnel-2',
	  STAGE: 'stage',
	  CUSTOMER_CARD: 'customer-card',
	  SMART_ACTIVITIES: 'smart-activities',
	  CHOOSE: 'choose',
	  ADD_FROM_ADRESSBOOK: 'add-from-adressbook',
	  ADD_FILE: 'add-file',
	  RECEIVE_PAYMENT_SETTINGS: 'receive-payment-settings',
	  TIMELINE: 'timeline',
	  FORM_SETTINGS: 'form-settings',
	  CUSTOMER_CARDS: 'customer-cards',
	  SHOP_LIST: 'shop-list',
	  SHOP_SEEN: 'shop-seen',
	  ADD_FROM_CRM: 'add-from-crm',
	  PAYMENT_AND_DELIVERY: 'payment-and-delivery',
	  SMART_SORT: 'smart-sort',
	  CART_TEXT: 'cart-text',
	  CART: 'cart',
	  CART_IMAGE: 'cart-image',
	  COMMENT_PLUS: 'comment-plus',
	  DEAL_1: 'deal-1',
	  DEAL_PLUS_1: 'deal-plus-1',
	  TIMELINE_PLUS: 'timeline-plus',
	  PLUS_BASED_ON: 'plus-based-on',
	  DEAL: 'deal',
	  CUSTOMER_CARD_1: 'customer-card-1',
	  DEAL_PLUS: 'deal-plus',
	  PERSON_PLUS_2: 'person-plus-2',
	  CITY_PLUS: 'city-plus',
	  CUSTOMER_CARD_PLUS: 'customer-card-plus',
	  CHAT_1: 'chat-1',
	  DIALOGUE_1: 'dialogue-1',
	  BUSINESS_PROCESS: 'business-process',
	  FORM: 'form',
	  WALLET: 'wallet',
	  TAXI: 'taxi',
	  INTERCONNECTION: 'interconnection',
	  REDUCE: 'reduce',
	  DIALOGUE: 'dialogue',
	  DELIVERY_CAR: 'delivery-car',
	  CAR: 'car',
	  CRM_PAYMENT: 'crm-payment',
	  INSERT: 'insert',
	  SEND_FILE: 'send-file',
	  BITRIX_1C: 'bitrix-1c'
	});
	const Editor = Object.freeze({
	  BOLD: 'bold',
	  ITALIC: 'italic',
	  UNDERLINE: 'underline',
	  STRIKETHROUGH: 'strikethrough',
	  TEXT_COLOR: 'text-color',
	  REMOVE_FORMATTING: 'remove-formatting',
	  FONT_SIZE: 'font-size',
	  NUMBERED_LIST: 'numbered-list',
	  BULLETED_LIST: 'bulleted-list',
	  LEFT_ALIGN: 'left-align',
	  TEXT_AMOUNT: 'text-amount',
	  INCERT_IMAGE: 'incert-image',
	  INSERT_EMOJI: 'insert-emoji',
	  INSERT_SPOILER: 'insert-spoiler',
	  REMOVE_FONTSIZE: 'remove-fontsize',
	  VIEWMODE_WYSIWYG: 'viewmode-wysiwyg',
	  VIEWMODE_CODE: 'viewmode-code',
	  VIEWMODE_SPLIT_HOR: 'viewmode-split-hor',
	  VIEWMODE_SPLIT_VER: 'viewmode-split-ver',
	  UNDO: 'undo',
	  REDO: 'redo',
	  HEADER: 'header',
	  ERASER: 'eraser',
	  RULER_AND_PENCIL: 'ruler-and-pencil',
	  PAINT_BUCKET: 'paint-bucket',
	  SERVICE: 'service',
	  TEXT_CHECK: 'text-check',
	  PAINT_BUCKET_FORMATTING: 'paint-bucket-formatting',
	  NEW_FILE: 'new-file',
	  SETTINGS_5: 'settings-5',
	  ANCHOR: 'anchor',
	  SUPERSCRIPT: 'superscript',
	  SUBSCRIPT: 'subscript',
	  HR: 'hr',
	  SPECIAL_CHARACTERS: 'special-characters',
	  CHECK_GRAMMAR: 'check-grammar',
	  BREAKS: 'breaks',
	  PRINT: 'print',
	  UNION: 'union',
	  MENTION: 'mention',
	  ADD_TAG: 'add-tag',
	  ENCLOSE_TEXT_IN_CODE_TAG: 'enclose-text-in-code-tag',
	  TABLE_EDITOR: 'table-editor',
	  BB_CODE_MODE: 'bb-code-mode',
	  FULL_SCREEN: 'full-screen',
	  CENTER_ALIGN: 'center-align',
	  RIGHT_LIGN: 'right-align',
	  JUSTIFY: 'justify',
	  DECREASE_INDENT: 'decrease-indent',
	  INCREASE_INDENT: 'increase-indent',
	  PARAGRAPH_BACKGROUND_COLOUR: 'paragraph-background-colour',
	  FORMATTING: 'formatting',
	  INSERT_VIDEO: 'insert-video',
	  SPEED_0_5: 'speed-0-5',
	  SPEED_0_7: 'speed-0-7',
	  SPEED_1_0: 'speed-1-0',
	  SPEED_1_2: 'speed-1-2',
	  SPEED_1_5: 'speed-1-5',
	  SPEED_1_7: 'speed-1-7',
	  SPEED_2_0: 'speed-2-0',
	  MAKE_LONGER: 'make-longer',
	  MAKE_SHORTER: 'make-shorter'
	});
	const Special = Object.freeze({
	  // : '',
	});
	const Set = Object.freeze({
	  ...Actions,
	  ...Social,
	  ...Main,
	  ...ContactCenter,
	  ...CRM,
	  ...Editor,
	  ...Special,
	  ...Animated
	});

	let _ = t => t,
	  _t;
	class Icon {
	  constructor(params = {}) {
	    this.validateParams(params);
	    this.icon = params.icon;
	    this.size = params.size || null;
	    this.color = params.color || null;
	    this.iconElement = null;
	  }
	  validateParams(params) {
	    if (!params.icon) {
	      throw new Error('IconSet: property "icon" not set.');
	    }
	    if (!Object.values(Set).includes(params.icon)) {
	      throw new Error('IconSet: "icon" is not exist.');
	    }
	    if (params.size && !main_core.Type.isNumber(params.size)) {
	      throw new Error('IconSet: "size" is not a number.');
	    }
	    if (params.color && !main_core.Type.isString(params.color)) {
	      throw new Error('IconSet: "color" is not a string.');
	    }
	  }
	  renderTo(node) {
	    if (!main_core.Type.isElementNode(node)) {
	      throw new Error('IconSet: node is not a htmlElement.');
	    }
	    main_core.Dom.append(this.render(), node);
	  }
	  render() {
	    let className = 'ui-icon-set' + ` --${this.icon}`;
	    this.iconElement = main_core.Tag.render(_t || (_t = _`<div class="${0}"></div>`), className);
	    if (this.size) {
	      main_core.Dom.style(this.iconElement, '--ui-icon-set__icon-size', `${this.size}px`);
	    }
	    if (this.color) {
	      main_core.Dom.style(this.iconElement, `--ui-icon-set__icon-color`, `${this.color}`);
	    }
	    return this.iconElement;
	  }

	  /**
	   *
	   * @param color
	   */
	  setColor(color) {
	    main_core.Dom.style(this.iconElement, `--ui-icon-set__icon-color`, `${color}`);
	  }
	}

	exports.Icon = Icon;
	exports.Set = Set;
	exports.Actions = Actions;
	exports.Social = Social;
	exports.Main = Main;
	exports.ContactCenter = ContactCenter;
	exports.CRM = CRM;
	exports.Editor = Editor;
	exports.Special = Special;
	exports.Animated = Animated;

}((this.BX.UI.IconSet = this.BX.UI.IconSet || {}),BX));
//# sourceMappingURL=ui.icon-set.core.bundle.js.map
