(function(){"use strict";BX.namespace("BX.UI.ProgressBar");BX.UI.ProgressBar=function(t){this.options=BX.type.isPlainObject(t)?t:{};this.bar=null;this.container=null;this.status=null;this.statusPercent="0%";this.statusCounter="0 / 0";this.textBefore=null;this.textAfter=null;this.maxValue=100;this.value=0;this.statusType=BX.UI.ProgressBar.Status.PERCENT;this.color=BX.UI.ProgressBar.Color.PRIMARY;this.size=BX.UI.ProgressBar.Size.MEDIUM;this.setValue(t.value);this.setMaxValue(t.maxValue);this.setStatusType(t.statusType);this.setColor(t.color);this.setSize(t.size);this.setFill(t.fill);this.setColumn(t.column);this.setTextBefore(t.textBefore);this.setTextAfter(t.textAfter)};BX.UI.ProgressBar.Status={COUNTER:"COUNTER",PERCENT:"PERCENT",NONE:"NONE"};BX.UI.ProgressBar.Color={DANGER:"ui-progressbar-danger",SUCCESS:"ui-progressbar-success",PRIMARY:"ui-progressbar-primary",WARNING:"ui-progressbar-warning"};BX.UI.ProgressBar.Size={LARGE:"ui-progressbar-lg",MEDIUM:"ui-progressbar-md"};BX.UI.ProgressBar.prototype={getValue:function(){return this.value},setValue:function(t){if(BX.type.isNumber(t)){this.value=t>this.maxValue?this.maxValue:t}},getMaxValue:function(){return this.maxValue},setMaxValue:function(t){if(BX.type.isNumber(t)){this.maxValue=t}},setColor:function(t){if(BX.type.isNotEmptyString(t)){BX.removeClass(this.getContainer(),this.color);this.color=t;BX.addClass(this.getContainer(),this.color)}},setSize:function(t){if(BX.type.isNotEmptyString(t)){BX.removeClass(this.getContainer(),this.size);this.size=t;BX.addClass(this.getContainer(),this.size)}},setFill:function(t){if(t===true){BX.addClass(this.getContainer(),"ui-progressbar-bg")}else{BX.removeClass(this.getContainer(),"ui-progressbar-bg")}},setColumn:function(t){if(t===true){BX.addClass(this.getContainer(),"ui-progressbar-column")}else{BX.removeClass(this.getContainer(),"ui-progressbar-column")}},getTextBefore:function(){if(this.textBefore===null){this.textBefore=BX.create("div",{props:{className:"ui-progressbar-text-before"},html:this.options.textBefore})}return this.textBefore},setTextBefore:function(t){BX.adjust(this.textBefore,{html:t})},getTextAfter:function(){if(this.textAfter===null){this.textAfter=BX.create("div",{props:{className:"ui-progressbar-text-after"},html:this.options.textAfter})}return this.textAfter},setTextAfter:function(t){BX.adjust(this.textAfter,{html:t})},getStatus:function(){if(this.status===null){if(this.getStatusType()===BX.UI.ProgressBar.Status.COUNTER){this.status=BX.create("div",{props:{className:"ui-progressbar-status"},text:this.getStatusCounter()})}else if(this.getStatusType()===BX.UI.ProgressBar.Status.PERCENT){this.status=BX.create("div",{props:{className:"ui-progressbar-status-percent"},text:this.getStatusPercent()})}else{this.status=BX.create("span",{})}}return this.status},getStatusPercent:function(){this.statusPercent=Math.round(this.getValue()/(this.getMaxValue()/100));if(this.statusPercent>100){this.statusPercent=100}return this.statusPercent+"%"},getStatusCounter:function(){this.statusCounter=Math.round(this.getValue())+" / "+Math.round(this.getMaxValue());if(Math.round(this.getValue())>Math.round(this.getMaxValue())){this.statusCounter=Math.round(this.getMaxValue())+" / "+Math.round(this.getMaxValue())}return this.statusCounter},setStatus:function(){if(this.getStatusType()===BX.UI.ProgressBar.Status.COUNTER){BX.adjust(this.status,{text:this.getStatusCounter()})}else if(this.getStatusType()===BX.UI.ProgressBar.Status.PERCENT){BX.adjust(this.status,{text:this.getStatusPercent()})}},getStatusType:function(){return this.statusType},setStatusType:function(t){if(BX.type.isNotEmptyString(t)){this.statusType=t}},getBar:function(){if(this.bar===null){this.bar=BX.create("div",{props:{className:"ui-progressbar-bar"},style:{width:this.getStatusPercent()}})}return this.bar},update:function(t){this.setValue(t);this.setStatus();if(this.bar===null){this.getBar()}BX.adjust(this.bar,{style:{width:this.getStatusPercent()}})},getContainer:function(){if(this.container===null){this.container=BX.create("div",{props:{className:"ui-progressbar"},children:[this.getTextAfter(),this.getTextBefore(),this.getStatus(),BX.create("div",{props:{className:"ui-progressbar-track"},children:[this.getBar()]})]})}return this.container}}})();
//# sourceMappingURL=ui.progressbar.map.js