(function(){"use strict";BX.namespace("BX.UI.Viewer");BX.UI.Viewer.Item=function(t){t=t||{};this.controller=null;this.title=t.title;this.src=t.src;this.nakedActions=t.nakedActions;this.actions=t.actions;this.contentType=t.contentType;this.isLoaded=false;this.isLoading=false;this.isTransforming=false;this.isTransformationError=false;this.sourceNode=null;this.transformationTimeoutId=null;this.viewerGroupBy=null;this.isSeparate=false;this.transformationTimeout=t.transformationTimeout||22e3;this.layout={container:null};this.options=t;this.init()};BX.UI.Viewer.Item.prototype={setController:function(t){if(!(t instanceof BX.UI.Viewer.Controller)){throw new Error("BX.UI.Viewer.Item: 'controller' has to be instance of BX.UI.Viewer.Controller.")}this.controller=t},setPropertiesByNode:function(t){this.title=t.dataset.title||t.title||t.alt;this.src=t.dataset.src;this.viewerGroupBy=t.dataset.viewerGroupBy;this.isSeparate=t.dataset.viewerSeparateItem||false;this.nakedActions=t.dataset.actions?JSON.parse(t.dataset.actions):undefined},bindSourceNode:function(t){this.sourceNode=t},applyReloadOptions:function(t){},isSeparateItem:function(){return this.isSeparate},isPullConnected:function(){if(top.BX.PULL){if(BX.type.isFunction(top.BX.PULL.isConnected)){return top.BX.PULL.isConnected()}else{var t=top.BX.PULL.getDebugInfoArray();return t.connected}}return false},registerTransformationHandler:function(t){if(this.isLoaded){return}if(this.controller.getCurrentItem()===this){this.controller.setTextOnLoading(BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_IN_PROGRESS"))}if(this.isPullConnected()){BX.addCustomEvent("onPullEvent-main",function(t,e){if(t==="transformationComplete"&&this.isTransforming){this.loadData().then(function(){if(this.transformationPromise){this.transformationPromise.fulfill(this)}}.bind(this))}}.bind(this));console.log("BX.PULL.extendWatch");BX.PULL.extendWatch(t)}else{setTimeout(function(){BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:[{name:"BX-Viewer-check-transformation",value:null}]}).then(function(t){if(!t.data||!t.data.transformation){this.registerTransformationHandler()}else{this.loadData().then(function(){this.transformationPromise.fulfill(this)}.bind(this))}}.bind(this))}.bind(this),5e3)}this.transformationTimeoutId=setTimeout(function(){if(this.isLoading){console.log("Throw transformationTimeout");if(this._loadPromise){this._loadPromise.reject({status:"timeout",message:BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",this.getSrc()),item:this});this.isLoading=false;this.isTransformationError=true}}else{console.log("We don't have transformationTimeout :) ")}this.resetTransformationTimeout()}.bind(this),this.transformationTimeout)},resetTransformationTimeout:function(){if(this.transformationTimeoutId){clearTimeout(this.transformationTimeoutId)}this.transformationTimeoutId=null},init:function(){},load:function(){var t=new BX.Promise;if(this.isLoaded){t.fulfill(this);console.log("isLoaded");return t}if(this.isTransformationError){t.reject({item:this});return t}if(this.isLoading){console.log("isLoading");return this._loadPromise}this.isLoading=true;this._loadPromise=this.loadData().then(function(t){this.isLoaded=true;this.isLoading=false;this.isTransforming=false;return t}.bind(this)).catch(function(t){console.log("catch");this.isLoaded=false;this.isLoading=false;this.isTransforming=false;if(!t.item){t.item=this}var e=new BX.Promise;e.reject(t);return e}.bind(this));console.log("will load");return this._loadPromise},listContainerModifiers:function(){return[]},getSrc:function(){return this.src},hashCode:function(t){var e=0,i=t.length,r=0;if(i>0){while(r<i)e=(e<<5)-e+t.charCodeAt(r++)|0}return e},generateUniqueId:function(){return this.hashCode(this.getSrc()||"")+Math.floor(Math.random()*Math.floor(1e4))},getTitle:function(){return this.title},getGroupBy:function(){return this.viewerGroupBy},getNakedActions:function(){if(typeof this.nakedActions==="undefined"){return[{type:"download"}]}return this.nakedActions},setActions:function(t){this.actions=t},getActions:function(){return this.actions},loadData:function(){var t=new BX.Promise;t.setAutoResolve(true);t.fulfill(this);return t},render:function(){},getContentWidth:function(){},handleKeyPress:function(t){},asFirstToShow:function(){},afterRender:function(){},beforeHide:function(){}};BX.UI.Viewer.Image=function(t){t=t||{};BX.UI.Viewer.Item.apply(this,arguments);this.resizedSrc=t.resizedSrc;this.width=t.width;this.height=t.height;this.imageNode=null;this.layout={container:null}};BX.UI.Viewer.Image.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode:function(t){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.src=t.dataset.src||t.src;this.width=t.dataset.width;this.height=t.dataset.height},applyReloadOptions:function(t){this.controller.unsetCachedData(this.src)},tryToExportResizedSrcFromSourceNode:function(){var t=210;if(!(this.sourceNode instanceof Image)){return}if(!this.sourceNode.naturalWidth){return}var e=this.controller.getItemContainer().offsetHeight;var i=this.controller.getItemContainer().offsetWidth;var r=e/i;var s=e-t;var o=s/r;if(this.sourceNode.naturalWidth>=o||this.sourceNode.naturalHeight>=s){this.resizedSrc=this.sourceNode.src}},loadData:function(){var t=new BX.Promise;if(!this.shouldRunLocalResize()){this.resizedSrc=this.src}this.tryToExportResizedSrcFromSourceNode();if(this.controller.getCachedData(this.src)){this.resizedSrc=this.controller.getCachedData(this.src).resizedSrc}if(!this.resizedSrc){var e=new XMLHttpRequest;e.onreadystatechange=function(){if(e.readyState!==XMLHttpRequest.DONE){return}if((e.status===200||e.status===0)&&e.response){console.log("resize image");this.resizedSrc=URL.createObjectURL(e.response);this.imageNode=new Image;this.imageNode.src=this.resizedSrc;this.imageNode.onload=function(){t.fulfill(this)}.bind(this);this.controller.setCachedData(this.src,{resizedSrc:this.resizedSrc})}else{t.reject({item:this,type:"error"})}}.bind(this);e.open("GET",BX.util.add_url_param(this.src,{ts:"bxviewer"}),true);e.responseType="blob";e.setRequestHeader("BX-Viewer-image","x");e.send()}else{this.imageNode=new Image;this.imageNode.onload=function(){t.fulfill(this)}.bind(this);this.imageNode.onerror=this.imageNode.onabort=function(e){console.log("reject");t.reject({item:this,type:"error"})}.bind(this);this.imageNode.src=this.resizedSrc}return t},shouldRunLocalResize:function(){return!this.controller.isExternalLink(this.src)},render:function(){var t=document.createDocumentFragment();t.appendChild(this.imageNode);if(this.title){t.appendChild(BX.create("div",{props:{className:"viewer-inner-fullsize"},children:[BX.create("a",{props:{href:BX.util.add_url_param(this.src,{ts:"bxviewer",ibxShowImage:1}),target:"_blank"},text:BX.message("JS_UI_VIEWER_IMAGE_VIEW_FULL_SIZE"),events:{click:function(t){t.stopPropagation()}}})]}))}this.imageNode.alt=this.title;return t},getContentWidth:function(){var t=new BX.Promise;t.fulfill(this.imageNode.offsetWidth);return t},afterRender:function(){if(!window.chrome){setTimeout(function(){this.imageNode.removeAttribute("width");this.imageNode.removeAttribute("height")}.bind(this),200)}}};BX.UI.Viewer.PlainText=function(t){t=t||{};BX.UI.Viewer.Item.apply(this,arguments);this.content=t.content};BX.UI.Viewer.PlainText.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode:function(t){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.content=t.dataset.content},render:function(){var t=BX.create("span",{text:this.content});t.style.fontSize="14px";t.style.color="white";return t}};BX.UI.Viewer.Audio=function(t){t=t||{};BX.UI.Viewer.Item.apply(this,arguments);this.playerId="audio-playerId_"+this.generateUniqueId();this.svgMask=null};BX.UI.Viewer.Audio.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode:function(t){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.playerId="audio-playerId_"+this.generateUniqueId()},loadData:function(){var t=new BX.Promise;if(BX.getClass("BX.Fileman.Player")){t.fulfill(this);return t}var e=[{name:"BX-Viewer-src",value:this.src},{name:"BX-Viewer",value:"audio"}];var i=BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:e});i.then(function(e){if(!e||!e.data){var i=e?e.errors:[];t.reject({item:this,type:"error",errors:i||[]});return}if(e.data.html&&!BX.getClass("BX.Fileman.Player")){var r=BX.processHTML(e.data.html);BX.load(r.STYLE,function(){BX.ajax.processScripts(r.SCRIPT,undefined,function(){t.fulfill(this)}.bind(this))}.bind(this))}else{t.fulfill(this)}}.bind(this));return t},render:function(){this.player=new BX.Fileman.Player(this.playerId,{width:320,height:52,isAudio:true,skin:"vjs-viewer-audio-player-skin",sources:[{src:this.src,type:"audio/mp3"}],onInit:function(t){t.vjsPlayer.controlBar.removeChild("timeDivider");t.vjsPlayer.controlBar.removeChild("durationDisplay");t.vjsPlayer.controlBar.removeChild("fullscreenToggle");t.vjsPlayer.hasStarted(true)}});return this.player.createElement()},afterRender:function(){this.player.init()}};BX.UI.Viewer.HightlightCode=function(t){t=t||{};BX.UI.Viewer.Item.apply(this,arguments);this.content=t.content};BX.UI.Viewer.HightlightCode.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode:function(t){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.content=t.dataset.content},listContainerModifiers:function(){return["ui-viewer-document","ui-viewer-document-hlcode"]},loadData:function(){var t=new BX.Promise;BX.loadExt("ui.highlightjs").then(function(){if(!this.content){var e=new XMLHttpRequest;e.onreadystatechange=function(){if(e.readyState!==XMLHttpRequest.DONE){return}if((e.status===200||e.status===0)&&e.response){this.content=e.response;console.log("text content is loaded");this.controller.setCachedData(this.src,{content:this.content});t.fulfill(this)}else{t.reject({item:this,type:"error"})}}.bind(this);e.open("GET",BX.util.add_url_param(this.src,{ts:"bxviewerText"}),true);e.responseType="text";e.send()}else{t.fulfill(this)}}.bind(this));return t},render:function(){var t=this.getTitle().substring(this.getTitle().lastIndexOf(".")+1);return BX.create("div",{props:{tabIndex:2208},style:{width:"100%",height:"100%",paddingTop:"67px",background:"rgba(0, 0, 0, 0.1)",overflow:"auto"},children:[BX.create("pre",{children:[this.codeNode=BX.create("code",{props:{className:hljs.getLanguage(t)?t:"plaintext"},style:{fontSize:"14px",textAlign:"left"},text:this.content})]})]})},getContentWidth:function(){var t=new BX.Promise;t.fulfill(this.codeNode.offsetWidth);return t},afterRender:function(){hljs.highlightBlock(this.codeNode)}};BX.UI.Viewer.Unknown=function(t){BX.UI.Viewer.Item.apply(this,arguments)};BX.UI.Viewer.Unknown.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,render:function(){return BX.create("div",{props:{className:"ui-viewer-unsupported"},children:[BX.create("div",{props:{className:"ui-viewer-unsupported-title"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_TITLE")}),BX.create("div",{props:{className:"ui-viewer-unsupported-text"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_NOTICE")}),BX.create("a",{props:{className:"ui-btn ui-btn-light-border ui-btn-themes",href:this.getSrc(),target:"_blank"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_DOWNLOAD_ACTION")})]})}};BX.UI.Viewer.Video=function(t){t=t||{};BX.UI.Viewer.Item.apply(this,arguments);this.player=null;this.sources=[];this.contentNode=null;this.forceTransformation=false;this.videoWidth=null;this.playerId="playerId_"+this.generateUniqueId()};BX.UI.Viewer.Video.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode:function(t){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.playerId="playerId_"+this.generateUniqueId()},applyReloadOptions:function(t){if(t.forceTransformation){this.forceTransformation=true}},init:function(){BX.addCustomEvent("PlayerManager.Player:onAfterInit",this.handleAfterInit.bind(this));BX.addCustomEvent("PlayerManager.Player:onError",this.handleAfterInit.bind(this))},loadData:function(){var t=new BX.Promise;var e=[{name:"BX-Viewer-src",value:this.src}];e.push({name:this.forceTransformation?"BX-Viewer-force-transformation":"BX-Viewer",value:"video"});var i=BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:e});i.then(function(e){if(!e||!e.data){var i=e?e.errors:[];t.reject({item:this,type:"error",errors:i||[]});return}if(e.data.hasOwnProperty("pullTag")){if(!this.isTransforming){this.transformationPromise=t;this.registerTransformationHandler(e.data.pullTag)}this.isTransforming=true}else{this.isTransforming=false;if(e.data.data){this.width=e.data.data.width;this.height=e.data.data.height;this.sources=e.data.data.sources}if(e.data.html){var r=BX.processHTML(e.data.html);BX.load(r.STYLE,function(){BX.ajax.processScripts(r.SCRIPT,undefined,function(){t.fulfill(this)}.bind(this))}.bind(this))}}}.bind(this));return t},handleAfterInit:function(t){if(t.id!==this.playerId){return}if(this.handleVideoError(t)){return}if(t.vjsPlayer.videoWidth()>0&&t.vjsPlayer.videoHeight()>0){this.adjustVideo()}else{t.vjsPlayer.one("loadedmetadata",this.adjustVideo.bind(this))}},handleVideoError:function(t){if(t.id!==this.playerId){return false}if(t.vjsPlayer.error()&&!this.forceTransformation){console.log("forceTransformation");this.controller.reload(this,{forceTransformation:true});return true}return false},adjustVideo:function(){var t=this.contentNode;if(!t){return}if(!this.player.vjsPlayer){return}if(this.adjustVideoWidth(t,this.player.width,this.player.height,this.player.vjsPlayer.videoWidth(),this.player.vjsPlayer.videoHeight())){this.player.vjsPlayer.fluid(true)}BX.addClass(t,"player-loaded");BX.style(t,"opacity",1)},adjustVideoWidth:function(t,e,i,r,s){if(!BX.type.isDomNode(t)){return false}if(!e||!i||!r||!s){return false}if(s<i&&r<e){BX.width(t,r);this.videoWidth=r;if(!this.contentWidthPromise.state){this.contentWidthPromise.fulfill(this.videoWidth)}return true}else{i=window.innerHeight-250;var o=e/i;var n=r/s;var a=1;if(o>n){a=i/s}else{a=e/r}BX.width(t,Math.floor(r*a));this.videoWidth=Math.floor(r*a);if(!this.contentWidthPromise.state){this.contentWidthPromise.fulfill(this.videoWidth)}}return true},getContentWidth:function(){this.contentWidthPromise=new BX.Promise;if(this.videoWidth){this.contentWidthPromise.fulfill(this.videoWidth)}return this.contentWidthPromise},render:function(){this.player=new BX.Fileman.Player(this.playerId,{width:this.width,height:this.height,sources:this.sources});this.controller.showLoading();return this.contentNode=BX.create("div",{style:{opacity:0},children:[this.player.createElement()]})},asFirstToShow:function(){if(this.player){this.player.mute(true);this.player.play()}},afterRender:function(){this.player.init()}}})();
//# sourceMappingURL=ui.viewer.item.map.js