(function(){"use strict";BX.namespace("BX.UI.Viewer");BX.UI.Viewer.Controller=function(e){this.items=null;this.currentIndex=null;this.handlers={};this.baseContainer=e.baseContainer||document.body;this.setItems(e.items||[]);this.isBodyPaddingAdded=null;this.cycleMode=e.hasOwnProperty("cycleMode")?e.cycleMode:true;this.preload=e.hasOwnProperty("preload")?e.preload:3;this.stretch=e.hasOwnProperty("stretch")?e.stretch:false;this.cachedData={};this.optionsByGroup={};this.layout={container:null,content:null,inner:null,itemContainer:null,next:null,prev:null,close:null,error:null,loader:null,loaderContainer:null,loaderText:null,panel:null};this.actionPanel=new BX.UI.ActionPanel({darkMode:true,floatMode:false,autoHide:false,showTotalSelectedBlock:false,showResetAllBlock:false,alignItems:"center",renderTo:function(){return this.getPanelWrapper()}.bind(this)});this.eventsAlreadyBinded=false;this.init()};BX.UI.Viewer.Controller.prototype={buildItemListByNode:function(e){var t=new BX.Promise;var i=[];if(this.isSeparateItem(e)){i=[e]}else if(e.dataset.viewerGroupBy){i=[].slice.call(e.ownerDocument.querySelectorAll("[data-viewer][data-viewer-group-by='"+e.dataset.viewerGroupBy+"']"))}else{i=[e]}this.loadExtensions(this.collectExtensionsForItems(i)).then(function(){var e=i.map((function(e){return BX.UI.Viewer.buildItemByNode(e)}));t.fulfill(e)}.bind(this));return t},isSeparateItem:function(e){return e.dataset.viewerSeparateItem},shouldProcessSeparateMode:function(e){return e.length===1&&e[0].isSeparateItem()},shouldRunViewer:function(e){if(!BX.type.isDomNode(e)||!e.dataset){return false}if(!e.dataset.hasOwnProperty("viewer")){return false}return true},collectExtensionsForItems:function(e){var t=new Set;e.forEach((function(e){if(BX.type.isString(e.dataset.viewerExtension)){t.add(e.dataset.viewerExtension)}}));var i=[];t.forEach((function(e){if(shouldLoadExtensions(e)){i.push(e)}}));return i},extractTargetFromEvent:function(e){var t=BX.getEventTarget(e);var i=false;var n=8;do{if(this.shouldRunViewer(t)){i=true;break}t=t.parentNode;n--}while(n>0&&t);return i?t:null},handleDocumentClick:function(e){var t=this.extractTargetFromEvent(e);if(!t){return}if(t.tagName!=="A"&&t.closest('a[target="_blank"]')){return false}e.preventDefault();this.buildItemListByNode(t).then(function(i){if(i.length===0){return}if(this.shouldProcessSeparateMode(i)){this.setItems(i).then(function(){this.openSeparate(0)}.bind(this));return}if(BX.browser.IsMac()&&e.metaKey||e.ctrlKey){this.runActionByNode(t,"download")}else{this.setItems(i).then(function(){this.open(this.getIndexByNode(t))}.bind(this))}}.bind(this))},bindEvents:function(){if(this.eventsAlreadyBinded){return}this.eventsAlreadyBinded=true;this.handlers.keyPress=this.handleKeyPress.bind(this);this.handlers.touchStart=this.handleTouchStart.bind(this);this.handlers.touchEnd=this.handleTouchEnd.bind(this);this.handlers.resize=this.adjustViewerHeight.bind(this);this.handlers.showNext=this.showNext.bind(this);this.handlers.showPrev=this.showPrev.bind(this);this.handlers.close=this.close.bind(this);this.handlers.handleClickOnItemContainer=this.handleClickOnItemContainer.bind(this);this.handlers.handleSliderCloseByEsc=this.handleSliderCloseByEsc.bind(this);BX.bind(document,"keydown",this.handlers.keyPress);BX.bind(window,"resize",this.handlers.resize);BX.bind(this.getItemContainer(),"touchstart",this.handlers.touchStart);BX.bind(this.getItemContainer(),"touchend",this.handlers.touchEnd);BX.bind(this.getItemContainer(),"click",this.handlers.handleClickOnItemContainer);BX.bind(this.getNextButton(),"click",this.handlers.showNext);BX.bind(this.getPrevButton(),"click",this.handlers.showPrev);BX.bind(this.getCloseButton(),"click",this.handlers.close);BX.addCustomEvent("SidePanel.Slider:onCloseByEsc",this.handlers.handleSliderCloseByEsc)},handleVisibleControls:function(e){if(BX.browser.IsMobile()||BX.hasClass(document.documentElement,"bx-touch")){return}if(this._timerIdReadingMode){clearTimeout(this._timerIdReadingMode)}if(!this.cursorInPerimeter(e)||BX.findParent(e.target,{className:"ui-viewer-next"})||BX.findParent(e.target,{className:"ui-viewer-prev"})){this.disableReadingMode()}else{this._timerIdReadingMode=setTimeout(function(){this.enableReadingMode()}.bind(this),2800)}},enableReadingMode:function(e){if(BX.browser.IsMobile()||!this.isOnTop()){return}if(e){this._timerIdReadingMode=setTimeout(function(){this.layout.container.classList.add("ui-viewer-reading-mode")}.bind(this),5e3);return}this.layout.container.classList.add("ui-viewer-reading-mode")},disableReadingMode:function(){if(this._timerIdReadingMode){clearTimeout(this._timerIdReadingMode)}this.layout.container.classList.remove("ui-viewer-reading-mode")},cursorInPerimeter:function(e){var t=document.body.clientHeight/100*30;var i=document.body.clientWidth/100*30;i<300?i=300:null;t<300?t=300:null;if(e.y<t||e.y>document.body.clientHeight-t||e.x<i||e.x>document.body.clientWidth-i){return false}return true},handleSliderCloseByEsc:function(e){if(this.isOpen()&&this.getZindex()>e.getSlider().getZindex()){e.denyAction()}},adjustViewport:function(){var e=document.querySelector('[name="viewport"]');if(!e){return}this._viewportContent=e.getAttribute("content");e.setAttribute("content","width=device-width, user-scalable=no")},restoreViewport:function(){var e=document.querySelector('[name="viewport"]');if(!this._viewportContent||!e){return}e.setAttribute("content",this._viewportContent)},unbindEvents:function(){this.eventsAlreadyBinded=false;BX.unbind(document,"keydown",this.handlers.keyPress);BX.unbind(window,"resize",this.handlers.resize);BX.unbind(this.getItemContainer(),"touchstart",this.handlers.touchStart);BX.unbind(this.getItemContainer(),"touchend",this.handlers.touchEnd);BX.unbind(this.getItemContainer(),"click",this.handlers.handleClickOnItemContainer);BX.unbind(this.getNextButton(),"click",this.handlers.showNext);BX.unbind(this.getPrevButton(),"click",this.handlers.showPrev);BX.unbind(this.getCloseButton(),"click",this.handlers.close)},init:function(){},openByNode:function(e){this.buildItemListByNode(e).then(function(t){if(t.length===0){return}if(this.shouldProcessSeparateMode(t)){this.setItems(t).then(function(){this.openSeparate(0)}.bind(this));return}this.setItems(t).then(function(){this.open(this.getIndexByNode(e))}.bind(this))}.bind(this))},runActionByNode:function(e,t,i){this.buildItemListByNode(e).then(function(n){if(n.length===0){return}this.setItems(n).then(function(){this.runAction(this.getIndexByNode(e),t,i)}.bind(this))}.bind(this))},runAction:function(e,t,i){var n=this.getItemByIndex(e);var o=n.getActions().find((function(e){return e.id===t}));console.log("actionToRun",t,o);if(!BX.type.isFunction(o.action)){console.log("action is not a function");return}o.action.call(this,n,i)},getZindex:function(){var e=this.getViewerContainer();if(!e.parentNode){return 0}var t=BX.ZIndexManager.getComponent(e);return t.getZIndex()},setItems:function(e){if(!BX.type.isArray(e)){throw new Error("BX.UI.Viewer.Controller.setItems: 'items' has to be Array.")}BX.onCustomEvent("BX.UI.Viewer.Controller:onSetItems",[this,e]);this.items=e;this.items.forEach((function(e){e.setController(this)}),this);return this.loadExtensions(this.collectExtensionsForAction(e))},loadExtensions:function(e){return BX.loadExt(e)},collectExtensionsForAction:function(e){var t=new Set;e.forEach((function(e){var i=e.getActions()||[];i.forEach((function(e){if(!e.extension){return}if(!BX.type.isArray(e.extension)){e.extension=[e.extension]}e.extension.forEach((function(e){t.add(e)}))}))}));var i=[];t.forEach((function(e){if(shouldLoadExtensions(e)){i.push(e)}}));return i},appendItem:function(e){if(!(e instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.Controller.appendItem: 'item' has to be instance of BX.UI.Viewer.Item.")}e.setController(this);this.items.push(e)},reloadItem:function(e,t){t=t||{};if(!(e instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.Controller.reloadItem: 'item' has to be instance of BX.UI.Viewer.Item.")}var i=this.items.indexOf(e);if(i===-1){throw new Error("BX.UI.Viewer.Controller.reloadItem: there is no 'item' in items to reload.")}var n=null;if(e.sourceNode){n=BX.UI.Viewer.buildItemByNode(e.sourceNode)}else{n=new e.constructor(e.options)}n.setController(this);n.applyReloadOptions(t);this.items[i]=n},show:function(e,t){t=t||{};if(typeof e==="undefined"){e=0}BX.onCustomEvent("BX.UI.Viewer.Controller:onBeforeShow",[this,e]);var i=this.getItemByIndex(e);if(!i){return}this.hideErrorBlock();this.hideCurrentItem();this.disableReadingMode();this.showLoading();this.currentIndex=e;this.resetActionsInPanelByItem(this.getCurrentItem());i.load().then(function(e){if(this.getCurrentItem()===e){console.log("show item");this.processShowItem(e);if(t.asFirstToShow){e.asFirstToShow()}}}.bind(this)).catch(function(e){var t=e.item;console.log("catch viewer");BX.onCustomEvent("BX.UI.Viewer.Controller:onItemError",[this,e,t]);if(this.getCurrentItem()===t){this.processError(e,t)}BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterProcessItemError",[this,e,t])}.bind(this));this.processPreload(this.currentIndex);this.updateControls();this.lockScroll();this.adjustViewerHeight()},processPreload:function(e){if(!this.preload){return}var t=e+1;while(t<this.preload+e+1){var i=this.getItemByIndex(t);if(!i){break}console.log("Trying to preload",t);i.load();t++}},reload:function(e,t){var i=this.getCurrentItem()===e;this.reloadItem(e,t);if(i){console.log("reload");this.show(this.currentIndex)}},reloadCurrentItem:function(e){this.reload(this.getCurrentItem(),e||{})},processShowItem:function(e){this.hideCurrentItem();this.hideLoading();var t=BX.create("div",{props:{className:"ui-viewer-inner-content-wrapper"}});var i=document.createDocumentFragment();i.appendChild(e.render());var n=e.getTitle();if(n){i.appendChild(BX.create("div",{props:{className:"ui-viewer-inner-caption"},children:[BX.create("span",{text:n})]}))}t.appendChild(i);var o=this.layout.container.classList;var r=e.listContainerModifiers();if(r.length){o.add.apply(o,r)}this.layout.itemContainer.appendChild(t);e.afterRender();this.adjustControlsSize(e.getContentWidth());BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterShow",[this,e])},adjustControlsSize:function(e){this.getNextButton().style.width=null;this.getPrevButton().style.width=null;this.getNextButton().style.maxWidth=null;this.getPrevButton().style.maxWidth=null;if(e instanceof BX.Promise){e.then(function(e){var t=(document.body.offsetWidth-e)/2;this.getNextButton().style.width=t+"px";this.getPrevButton().style.width=t+"px";this.getNextButton().style.maxWidth="none";this.getPrevButton().style.maxWidth="none"}.bind(this))}},processError:function(e,t){e=e||{};var i=e.message||null;if(BX.type.isArray(e.errors)&&e.errors.length){if(e.errors[0].code===1e3&&!e.message){i=BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",t.getSrc())}}this.hideCurrentItem();this.hideLoading();var n=BX.create("div",{props:{className:"ui-viewer-inner-content-wrapper"}});var o=t.getTitle();if(o){n.appendChild(BX.create("div",{props:{className:"ui-viewer-inner-caption"},children:[BX.create("span",{html:o})]}))}var r={};if(i){r.title=i}if(e.description){r.description=e.description}n.appendChild(this.getErrorBlock(r,t));this.layout.itemContainer.appendChild(n)},hideErrorBlock:function(){if(this.layout.error){BX.remove(this.layout.error)}},getErrorBlock:function(e,t){this.hideErrorBlock();var i=BX.prop.getString(e,"viewType","info");var n=BX.prop.getString(e,"title",BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",t.getSrc()));var o=BX.prop.getString(e,"description",BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_HINT"));this.layout.error=BX.create("div",{props:{className:"ui-viewer-error"},style:{maxWidth:o?"440px":null},children:[BX.create("div",{props:{className:"ui-viewer-"+i+"-title"},html:n}),BX.create("div",{props:{className:"ui-viewer-"+i+"-text"},html:o})]});return this.layout.error},convertItemActionsToPanelItems:function(e){return e.getActions().map((function(t){if(t.id==="download"&&t.href){t.attributes={target:"_blank"}}if(!t.href&&BX.type.isFunction(t.action)){var i=t.action;t.onclick=function(t,n){i.call(this,e)}.bind(this)}return t}),this)},isExternalLink:function(e){var t=new RegExp("^([a-z]+://|//)","i");if(!t.test(e)){return false}if(!BX.getClass("URL")){return e.indexOf(location.hostname)===-1}try{return new URL(e).hostname!==location.hostname}catch(e){}return true},refineItemActions:function(item){var defaultActions={download:{id:"download",type:"download",text:BX.message("JS_UI_VIEWER_ITEM_ACTION_DOWNLOAD"),href:item.src,buttonIconClass:"ui-btn-icon-download"},edit:{id:"edit",type:"edit",text:BX.message("JS_UI_VIEWER_ITEM_ACTION_EDIT"),buttonIconClass:"ui-btn-icon-edit"},share:{id:"share",type:"share",text:BX.message("JS_UI_VIEWER_ITEM_ACTION_SHARE"),buttonIconClass:"ui-btn-icon-share"},print:{id:"print",type:"print",text:"",buttonIconClass:"ui-btn-icon-print ui-btn-disabled"},info:{id:"info",type:"info",text:"",buttonIconClass:"ui-btn-icon-info ui-action-panel-item-last"},delete:{id:"delete",type:"delete",text:BX.message("JS_UI_VIEWER_ITEM_ACTION_DELETE"),buttonIconClass:"ui-btn-icon-remove"}};return item.getNakedActions().map((function(action){if(defaultActions[action.type]){action=BX.mergeEx(defaultActions[action.type],action)}if(!action.id){action.id=action.type}if(!action.action&&action.href){action.action=function(){window.open(action.href,this.isExternalLink(action.href)?"_blank":"_self")}.bind(this)}if(BX.type.isArray(action.items)){action.items.forEach((function(e){if(BX.type.isString(e.onclick)){e.onclick=new Function("event","popupItem",e.onclick)}}))}if(BX.type.isString(action.action)){var params=action.params||{};var actionString=action.action;action.action=function(item,additionalParams){try{var fn=eval(actionString);fn.call(this,item,params,additionalParams)}catch(e){console.log(e)}}.bind(this)}return action}),this)},getLoader:function(e){if(!this.layout.loader){this.layout.loader=BX.create("div",{props:{className:"ui-viewer-loader"},style:{zIndex:-1},children:[this.layout.loaderContainer=BX.create("div",{props:{className:"ui-viewer-loader-container"}}),this.layout.loaderText=BX.create("div",{props:{className:"ui-viewer-loader-text"},text:""})]});var t=new BX.Loader({size:130});t.show(this.layout.loaderContainer)}return this.layout.loader},getPrevButton:function(){if(!this.layout.prev){this.layout.prev=BX.create("div",{props:{className:"ui-viewer-prev"},events:{mousewheel:function(e){this.handleMouseWheelOnControlButton(this.layout.prev,e)}.bind(this)}})}return this.layout.prev},getNextButton:function(){if(!this.layout.next){this.layout.next=BX.create("div",{props:{className:"ui-viewer-next"},events:{mousewheel:function(e){this.handleMouseWheelOnControlButton(this.layout.next,e)}.bind(this)}})}return this.layout.next},handleMouseWheelOnControlButton:function(e,t){if(this._timeoutIdMouseWheel){clearTimeout(this._timeoutIdMouseWheel)}e.style.pointerEvents="none";this._timeoutIdMouseWheel=setTimeout((function(){e.style.pointerEvents=null}),50)},getCloseButton:function(){if(!this.layout.close){this.layout.close=BX.create("div",{props:{className:"ui-viewer-close"},html:'<div class="ui-viewer-close-icon"></div>'})}return this.layout.close},isOpen:function(){return this._isOpen},addBodyPadding:function(){var e=window.innerWidth-document.documentElement.clientWidth;if(BX.getClass("BXIM.messenger.popupMessenger")||e===0){return}document.body.style.paddingRight=e+"px";var t=document.getElementById("bx-im-bar");if(t){var i="rgb(238, 242, 244)";if(document.body.classList.contains("bitrix24-light-theme")){i="rgba(255, 255, 255, .1)"}if(document.body.classList.contains("bitrix24-dark-theme")){i="rgba(82, 92, 105, .1)"}t.style.borderRight=e+"px solid "+i}this.isBodyPaddingAdded=true},removeBodyPadding:function(){document.body.style.removeProperty("padding-right");var e=document.getElementById("bx-im-bar");if(e){e.style.removeProperty("border-right")}this.isBodyPaddingAdded=false},openSeparate:function(e){var t=this.getItemByIndex(e);if(!t){return}t.load().then(function(e){}.bind(this)).catch(function(e){var t=e.item;console.log("catch viewer");BX.onCustomEvent("BX.UI.Viewer.Controller:onItemError",[this,e,t]);if(this.getCurrentItem()===t){this.processError(e,t)}BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterProcessItemError",[this,e,t])}.bind(this))},open:function(e){this.adjustViewport();this.addBodyPadding();var t=this.getViewerContainer();this.baseContainer.appendChild(t);BX.focus(t);this.showPanel();var i=BX.ZIndexManager.getComponent(t);if(!i){BX.ZIndexManager.register(t,{overlay:this.actionPanel.getPanelContainer(),overlayGap:1})}BX.ZIndexManager.bringToFront(t);this.show(e,{asFirstToShow:true});this.bindEvents();this._isOpen=true},getPanelWrapper:function(){if(!this.layout.panel){this.layout.panel=BX.create("div",{props:{className:"ui-viewer-panel"}})}return this.layout.panel},showPanel:function(){this.actionPanel.layout.container.style.background="none";this.actionPanel.draw();this.actionPanel.showPanel()},resetActionsInPanelByItem:function(e){this.actionPanel.removeItems();this.actionPanel.addItems(this.convertItemActionsToPanelItems(e))},hideCurrentItem:function(){if(this.getCurrentItem()){var e=this.layout.container.classList;var t=this.getCurrentItem().listContainerModifiers();if(t.length){e.remove.apply(e,t)}this.getCurrentItem().beforeHide()}BX.cleanNode(this.layout.itemContainer)},updateControls:function(){if(!this.allowToUseCycleMode()&&this.currentIndex+1>=this.items.length){BX.addClass(this.getNextButton(),"ui-viewer-navigation-hide")}else{BX.removeClass(this.getNextButton(),"ui-viewer-navigation-hide")}if(!this.allowToUseCycleMode()&&this.currentIndex===0){BX.addClass(this.getPrevButton(),"ui-viewer-navigation-hide")}else{BX.removeClass(this.getPrevButton(),"ui-viewer-navigation-hide")}},getCurrentItem:function(){return this.getItemByIndex(this.currentIndex)},getIndexByNode:function(e){var t=null;this.items.forEach((function(i,n){if(i.sourceNode===e){t=n}}));return t},getItemByIndex:function(e){e=parseInt(e,10);BX.onCustomEvent("BX.UI.Viewer.Controller:onGetItemByIndex",[this,e]);if(e<0||e-1>this.items.length){return null}return this.items[e]},handleClickOnItemContainer:function(e){if(this.getCurrentItem()instanceof BX.UI.Viewer.Image){this.showNext()}},allowToUseCycleMode:function(){var e=this.cycleMode;var t=this.getCurrentItem().getGroupBy();if(this.optionsByGroup[t]&&this.optionsByGroup[t].hasOwnProperty("cycleMode")){e=this.optionsByGroup[t].cycleMode}return this.items.length>1&&e},showNext:function(){var e=this.currentIndex+1;if(this.allowToUseCycleMode()&&e>=this.items.length){e=0}this.show(e)},showPrev:function(){var e=this.currentIndex-1;if(this.allowToUseCycleMode()&&e===-1){e=this.items.length-1}this.show(e)},close:function(){this._isOpen=false;BX.onCustomEvent("BX.UI.Viewer.Controller:onClose",[this]);BX.addClass(this.layout.container,"ui-viewer-hide");this.restoreViewport();this.hideCurrentItem();BX.bind(this.layout.container,"transitionend",function(){BX.ZIndexManager.unregister(this.layout.container);BX.remove(this.layout.container);BX.removeClass(this.layout.container,"ui-viewer-hide");BX.unbindAll(this.layout.container);this.actionPanel.hidePanel();this.unLockScroll();this.unbindEvents();this.disableReadingMode();if(this.isBodyPaddingAdded){this.removeBodyPadding()}}.bind(this))},showLoading:function(e){e=e||{};e.zIndex=BX.type.isNumber(e.zIndex)?e.zIndex:-1;this.layout.inner.appendChild(this.getLoader());this.setTextOnLoading(e.text||"");this.layout.loader.style.zIndex=e.zIndex},setTextOnLoading:function(e){this.layout.loaderText.textContent=e},hideLoading:function(){BX.remove(this.layout.loader)},lockScroll:function(){BX.addClass(document.body,"ui-viewer-lock-body")},unLockScroll:function(){BX.removeClass(document.body,"ui-viewer-lock-body")},adjustViewerHeight:function(){if(!this.layout.container||BX.browser.IsMobile())return;this.layout.container.style.height=document.documentElement.clientHeight+"px"},getViewerContainer:function(){if(!this.layout.container){this.layout.container=BX.create("div",{props:{className:"ui-viewer",tabIndex:22081990},style:{height:window.clientHeight+"px"},children:[this.layout.inner=BX.create("div",{props:{className:"ui-viewer-inner"},children:[this.getItemContainer()]}),this.getCloseButton(),this.getPrevButton(),this.getNextButton(),this.getPanelWrapper()]})}return this.layout.container},getItemContainer:function(){if(!this.layout.itemContainer){this.layout.itemContainer=BX.create("div",{props:{className:"ui-viewer-inner-content"}})}return this.layout.itemContainer},handleTouchStart:function(e){var t=e.changedTouches[0];this.swipeDirection=null;this.startX=t.pageX;this.startY=t.pageY;this.startTime=(new Date).getTime()},handleTouchEnd:function(e){var t=e.changedTouches[0];var i=300;var n=80;var o=100;var r=t.pageX-this.startX;var s=t.pageY-this.startY;var a=(new Date).getTime()-this.startTime;if(a<=i){if(Math.abs(r)>=n&&Math.abs(s)<=o){this.swipeDirection=r<0?"left":"right"}}switch(this.swipeDirection){case"left":this.showPrev();break;case"right":this.showNext();break}},isOnTop:function(){if(!this.isOpen()){return false}if(BX.getClass("BXIM.messenger")&&BXIM.messenger.popupMessenger){return true}if(!BX.getClass("BX.SidePanel.Instance")||!BX.SidePanel.Instance.getTopSlider()){return true}return this.getZindex()>BX.SidePanel.Instance.getTopSlider().getZindex()},handleKeyPress:function(e){if(!this.isOnTop()){return}if(e.metaKey){return}switch(e.code){case"Space":case"ArrowRight":this.showNext();e.preventDefault();e.stopPropagation();break;case"ArrowLeft":this.showPrev();e.preventDefault();e.stopPropagation();break;case"Escape":this.close();e.preventDefault();e.stopPropagation();break}this.getCurrentItem().handleKeyPress(e)},setOptionsByGroup:function(e,t){this.optionsByGroup[e]=t;return this},getCachedData:function(e){return this.cachedData[e]},setCachedData:function(e,t){this.cachedData[e]=t},unsetCachedData:function(e){this.cachedData[e]=null},addType:function(e,t){return BX.UI.Viewer.addType(e,t)}};BX.UI.Viewer.InlineController=function(e){e=e||{};BX.UI.Viewer.Controller.apply(this,arguments)};BX.UI.Viewer.InlineController.prototype={__proto__:BX.UI.Viewer.Controller.prototype,constructor:BX.UI.Viewer.Controller,adjustViewport:function(){},addBodyPadding:function(){},adjustZindex:function(){},showPanel:function(){},adjustViewerHeight:function(){},renderItemByNode:function(e){if(!e){return}this.buildItemListByNode(e).then(function(e){if(e.length===0){return}this.setItems(e).then(function(){this.open(0)}.bind(this))}.bind(this))},getViewerContainer:function(){if(!this.layout.container){this.layout.container=this.layout.inner=BX.create("div",{props:{className:"ui-viewer-inner"},children:[this.getItemContainer()]})}return this.layout.container},handleClickOnItemContainer:function(){},handleKeyPress:function(){}};BX.UI.Viewer.buildItemByTypeAndNode=function(e,t){var i=new e;if(!(i instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.buildItemByTypeAndNode: 'item' has to be instance of BX.UI.Viewer.Item.")}i.bindSourceNode(t);i.setPropertiesByNode(t);i.setActions(BX.UI.Viewer.Instance.refineItemActions(i));return i};BX.UI.Viewer.buildItemByNode=function(e){if(!BX.type.isDomNode(e)){throw new Error("BX.UI.Viewer.buildItemByNode: 'node' has to be DomNode.")}var t=e.dataset.viewerType;if(!t&&e.tagName.toLowerCase()==="img"){t="image"}BX.UI.Viewer.triggerEventToFindTypeClass(t);var i=types[t];if(i){return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(i),e)}if(e.dataset.viewerTypeClass){if(!BX.getClass(e.dataset.viewerTypeClass)){throw new Error("BX.UI.Viewer.buildItemByNode: could not find class "+e.dataset.viewerTypeClass)}return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(e.dataset.viewerTypeClass),e)}console.warn("BX.UI.Viewer.buildItemByNode: could not find class to build type {"+t+"}");return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(types.unknown),e)};var types={image:"BX.UI.Viewer.Image",plainText:"BX.UI.Viewer.PlainText",unknown:"BX.UI.Viewer.Unknown",video:"BX.UI.Viewer.Video",audio:"BX.UI.Viewer.Audio",document:"BX.UI.Viewer.Document",code:"BX.UI.Viewer.HightlightCode"};BX.UI.Viewer.addType=function(e,t){types[e]=t};BX.UI.Viewer.triggerEventToFindTypeClass=function(e){BX.onCustomEvent("BX.UI.Viewer.Controller:onFindType",[BX.UI.Viewer.Instance,e])};BX.UI.Viewer.bind=function(e,t){if(!BX.type.isDomNode(e)){throw new Error("BX.UI.Viewer.bind: 'container' has to be DomNode.")}if(!BX.type.isPlainObject(t)&&!BX.type.isFunction(t)){t=function(e){return BX.type.isElementNode(e)&&e.dataset.hasOwnProperty("viewer")}}BX.bindDelegate(e,"click",t,(function(i){var n=BX.findChildren(e,t,true);var o=0;var r=BX.getEventTarget(i);if(r.tagName!=="A"&&r.closest('a[target="_blank"]')){return false}var s=n.map((function(e,t){if(e===r){o=t}return BX.UI.Viewer.buildItemByNode(e)}));BX.UI.Viewer.Instance.setItems(s).then((function(){BX.UI.Viewer.Instance.open(o)}));i.preventDefault()}))};var shouldLoadExtensions=function(e){if(e==="disk.viewer.actions"&&BX.getClass("BX.Disk.Viewer.Actions")){return false}if(e==="disk.viewer.document-item"&&BX.getClass("BX.Disk.Viewer.DocumentItem")){return false}return true};var instance=null;Object.defineProperty(BX.UI.Viewer,"Instance",{enumerable:false,get:function(){if(window.top!==window&&BX.getClass("window.top.BX.UI.Viewer.Instance")){return window.top.BX.UI.Viewer.Instance}if(instance===null){instance=new BX.UI.Viewer.Controller({})}return instance}});window.document.addEventListener("click",(function(e){if(e.button!==0){return}if(window.top!==window&&!BX.getClass("window.top.BX.UI.Viewer.Instance")){top.BX.loadExt("ui.viewer").then((function(){top.BX.UI.Viewer.Instance.handleDocumentClick(e)}))}else{top.BX.UI.Viewer.Instance.handleDocumentClick(e)}}),true);if(window.top!==window&&!BX.getClass("window.top.BX.UI.Viewer.Instance")){top.BX.loadExt("ui.viewer")}})();
//# sourceMappingURL=ui.viewer.map.js