(function(t,e,i,r,a){"use strict";
/**
	 * Bitrix UI
	 * Audio player Vue component
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2021 Bitrix
	 */var s=Object.freeze({play:"play",pause:"pause",stop:"stop",none:"none"});r.BitrixVue.component("bx-audioplayer",{props:{id:{default:0},src:{default:""},autoPlayNext:{default:true},background:{default:"light"}},data:function t(){return{isDark:false,preload:"none",loaded:false,loading:false,playAfterLoad:false,state:s.none,progress:0,progressInPixel:0,seek:0,timeCurrent:0,timeTotal:0}},created:function t(){this.preloadRequestSent=false;this.registeredId=0;this.registerPlayer(this.id);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:play",this.onPlay);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:stop",this.onStop);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:pause",this.onPause);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:preload",this.onPreload);this.isDark=this.background==="dark"},mounted:function t(){this.getObserver().observe(this.$refs.body)},beforeDestroy:function t(){this.unregisterPlayer();this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:play",this.onPlay);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:stop",this.onStop);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:pause",this.onPause);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:preload",this.onPreload);this.getObserver().unobserve(this.$refs.body)},watch:{id:function t(e){this.registerPlayer(e)},progress:function t(e){if(e>70){this.preloadNext()}}},methods:{loadFile:function t(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;if(this.loaded){return true}if(this.loading&&!e){return true}this.preload="auto";if(e){this.loading=true;if(this.source()){this.source().play()}}return true},clickToButton:function t(){if(!this.src){return false}if(this.state===s.play){this.pause()}else{this.play()}},play:function t(){if(!this.loaded){this.loadFile(true);return false}this.source().play()},pause:function t(){this.source().pause()},stop:function t(){this.state=s.stop;this.source().pause()},setPosition:function t(e){if(!this.loaded){this.loadFile(true);return false}var i=this.$refs.track.offsetWidth/100;this.setProgress(this.seek/i,this.seek);if(this.state!==s.play){this.state=s.pause}this.play();this.source().currentTime=this.timeTotal/100*this.progress},seeking:function t(e){if(!this.loaded){return false}this.seek=e.offsetX>0?e.offsetX:0;return true},setProgress:function t(e){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:-1;this.progress=e;this.progressInPixel=i>0?i:Math.round(this.$refs.track.offsetWidth/100*e)},formatTime:function t(e){e=Math.floor(e);var i=Math.floor(e/60/60);if(i>0){e-=i*60*60}var r=Math.floor(e/60);if(r>0){e-=r*60}return(i>0?i+":":"")+(i>0?r.toString().padStart(2,"0")+":":r+":")+e.toString().padStart(2,"0")},registerPlayer:function t(e){var i=this;if(e<=0){return false}var r=this.$Bitrix.Data.get("ui-audioplayer-id",[]);r=babelHelpers.toConsumableArray(new Set([].concat(babelHelpers.toConsumableArray(r),[e]))).filter((function(t){return t!==i.registeredId})).sort((function(t,e){return t-e}));this.$Bitrix.Data.set("ui-audioplayer-id",r);this.registeredId=e;return true},unregisterPlayer:function t(){var e=this;if(!this.registeredId){return true}var i=this.$Bitrix.Data.get("ui-audioplayer-id",[]).filter((function(t){return t!==e.registeredId}));this.$Bitrix.Data.set("ui-audioplayer-id",i);this.registeredId=0;return true},playNext:function t(){var e=this;if(!this.registeredId||!this.autoPlayNext){return false}var i=this.$Bitrix.Data.get("ui-audioplayer-id",[]).filter((function(t){return t>e.registeredId})).slice(0,1)[0];if(i){this.$Bitrix.eventEmitter.emit("ui:audioplayer:play",{id:i,start:true})}return true},preloadNext:function t(){var e=this;if(this.preloadRequestSent){return true}if(!this.registeredId||!this.autoPlayNext){return false}this.preloadRequestSent=true;var i=this.$Bitrix.Data.get("ui-audioplayer-id",[]).filter((function(t){return t>e.registeredId})).slice(0,1)[0];if(i){this.$Bitrix.eventEmitter.emit("ui:audioplayer:preload",{id:i})}return true},onPlay:function t(e){var i=e.getData();if(i.id!==this.id){return false}if(i.start){this.stop()}this.play()},onStop:function t(e){var i=e.getData();if(i.initiator===this.id){return false}this.stop()},onPause:function t(e){var i=e.getData();if(i.initiator===this.id){return false}this.pause()},onPreload:function t(e){var i=e.getData();if(i.id!==this.id){return false}this.loadFile()},source:function t(){return this.$refs.source},audioEventRouter:function t(e,i){if(e==="durationchange"||e==="loadeddata"||e==="loadedmetadata"){this.timeTotal=this.source().duration}else if(e==="abort"||e==="error"){console.error("BxAudioPlayer: load failed",this.id,i);this.loading=false;this.state=s.none;this.timeTotal=0;this.preload="none"}else if(e==="canplaythrough"){this.loading=false;this.loaded=true}else if(e==="timeupdate"){if(!this.source()){return}this.timeCurrent=this.source().currentTime;this.setProgress(Math.round(100/this.timeTotal*this.timeCurrent));if(this.state===s.play&&this.timeCurrent>=this.timeTotal){this.playNext()}}else if(e==="pause"){if(this.state!==s.stop){this.state=s.pause}}else if(e==="play"){this.state=s.play;if(this.state===s.stop){this.progress=0;this.timeCurrent=0}if(this.id>0){this.$Bitrix.eventEmitter.emit("ui:audioplayer:pause",{initiator:this.id})}}},getObserver:function t(){var e=this;if(this.observer){return this.observer}this.observer=new IntersectionObserver((function(t,i){t.forEach((function(t){if(t.isIntersecting){if(e.preload==="none"){e.preload="metadata";e.observer.unobserve(t.target)}}}))}),{threshold:[0,1]});return this.observer}},computed:{State:function t(){return s},seekPosition:function t(){if(!this.loaded&&!this.seek||this.isMobile){return"display: none"}return"left: ".concat(this.seek,"px;")},progressPosition:function t(){if(!this.loaded||this.state===s.none){return"width: 100%;"}return"width: ".concat(this.progressInPixel,"px;")},labelTime:function t(){if(!this.loaded&&!this.timeTotal){return"--:--"}var e;if(this.state===s.play){e=this.timeTotal-this.timeCurrent}else{e=this.timeTotal}return this.formatTime(e)},isMobile:function t(){var e=navigator.userAgent.toLowerCase();return e.includes("android")||e.includes("iphone")||e.includes("ipad")||e.includes("bitrixmobile")}},template:'\n\t\t<div :class="[\'ui-vue-audioplayer-container\', {\n\t\t\t\t\'ui-vue-audioplayer-container-dark\': isDark,\n\t\t\t\t\'ui-vue-audioplayer-container-mobile\': isMobile,\n\t\t\t}]" ref="body">\n\t\t\t<div class="ui-vue-audioplayer-controls-container">\n\t\t\t\t<button :class="[\'ui-vue-audioplayer-control\', {\n\t\t\t\t\t\'ui-vue-audioplayer-control-loader\': loading,\n\t\t\t\t\t\'ui-vue-audioplayer-control-play\': !loading && state !== State.play,\n\t\t\t\t\t\'ui-vue-audioplayer-control-pause\': !loading && state === State.play,\n\t\t\t\t}]" @click="clickToButton"></button>\n\t\t\t</div>\n\t\t\t<div class="ui-vue-audioplayer-timeline-container">\n\t\t\t\t<div class="ui-vue-audioplayer-track-container" @click="setPosition" ref="track">\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-mask"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track" :style="progressPosition"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-seek" :style="seekPosition"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-event" @mousemove="seeking"></div>\n\t\t\t\t</div>\n\t\t\t\t<div class="ui-vue-audioplayer-timers-container">\n\t\t\t\t\t<div class="ui-vue-audioplayer-time-current">{{labelTime}}</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<audio v-if="src" :src="src" class="ui-vue-audioplayer-source" ref="source" :preload="preload"\n\t\t\t\t@abort="audioEventRouter(\'abort\', $event)"\n\t\t\t\t@error="audioEventRouter(\'error\', $event)"\n\t\t\t\t@suspend="audioEventRouter(\'suspend\', $event)"\n\t\t\t\t@canplay="audioEventRouter(\'canplay\', $event)"\n\t\t\t\t@canplaythrough="audioEventRouter(\'canplaythrough\', $event)"\n\t\t\t\t@durationchange="audioEventRouter(\'durationchange\', $event)"\n\t\t\t\t@loadeddata="audioEventRouter(\'loadeddata\', $event)"\n\t\t\t\t@loadedmetadata="audioEventRouter(\'loadedmetadata\', $event)"\n\t\t\t\t@timeupdate="audioEventRouter(\'timeupdate\', $event)"\n\t\t\t\t@play="audioEventRouter(\'play\', $event)"\n\t\t\t\t@playing="audioEventRouter(\'playing\', $event)"\n\t\t\t\t@pause="audioEventRouter(\'pause\', $event)"\n\t\t\t></audio>\n\t\t</div>\n\t'})})(this.window=this.window||{},BX,BX,BX,BX.Event);
//# sourceMappingURL=audioplayer.bundle.map.js