(function(t,e,i){"use strict";
/**
	 * Bitrix UI
	 * Base list element
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2020 Bitrix
	 */i.BitrixVue.component("bx-list-element",{props:["rawListItem","itemTypes"],computed:{imageStyle:function t(){return{}},imageClass:function t(){return"bx-vue-list-item-image"},avatarText:function t(){var e=this.listItem.title.value.split(" ");if(e.length>1){return e[0].charAt(0)+e[1].charAt(0)}else if(e.length===1){return e[0].charAt(0)}},listItemStyle:function t(){return{}},listItem:function t(){return this.rawListItem}},template:'\n\t\t<div class="bx-vue-list-item" :style="listItemStyle">\n\t\t\t<template v-if="listItem.template !== itemTypes.placeholder">\n\t\t\t\t<div v-if="listItem.avatar" class="bx-vue-list-item-image-wrap">\n\t\t\t\t\t<img v-if="listItem.avatar.url" :src="listItem.avatar.url" :style="imageStyle" :class="imageClass" alt="">\n\t\t\t\t\t<div v-else-if="!listItem.avatar.url" :style="imageStyle" class="bx-vue-list-item-image-text">{{ avatarText }}</div>\t\n\t\t\t\t\t<div v-if="listItem.avatar.topLeftIcon" :class="\'bx-vue-list-icon-avatar-top-left bx-vue-list-avatar-top-left-\' + listItem.avatar.topLeftIcon"></div>\n\t\t\t\t\t<div v-if="listItem.avatar.bottomRightIcon" :class="\'bx-vue-list-icon-avatar-bottom-right bx-vue-list-avatar-bottom-right-\' + listItem.avatar.bottomRightIcon"></div>\n\t\t\t\t</div>\n\t\t\t\t<div class="bx-vue-list-item-content">\n\t\t\t\t\t<div class="bx-vue-list-item-content-header">\n\t\t\t\t\t\t<div v-if="listItem.title" class="bx-vue-list-item-header-title">\n\t\t\t\t\t\t\t<div v-if="listItem.title.leftIcon" :class="\'bx-vue-list-icon-title-left bx-vue-list-icon-title-left-\' + listItem.title.leftIcon"></div>\n\t\t\t\t\t\t\t<span class="bx-vue-list-item-header-title-text">{{ listItem.title.value }}</span>\n\t\t\t\t\t\t\t<div v-if="listItem.title.rightIcon" :class="\'bx-vue-list-icon-title-right bx-vue-list-icon-title-right-\' + listItem.title.rightIcon"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div v-if="listItem.date" class="bx-vue-list-item-header-date">\n\t\t\t\t\t\t\t<div v-if="listItem.date.leftIcon" :class="\'bx-vue-list-icon-date-left bx-vue-list-icon-date-left-\' + listItem.date.leftIcon"></div>\n\t\t\t\t\t\t\t{{ listItem.date.value }}\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="bx-vue-list-item-content-bottom">\n\t\t\t\t\t\t<div v-if="listItem.subtitle" class="bx-vue-list-item-bottom-subtitle">\n\t\t\t\t\t\t\t<div v-if="listItem.subtitle.leftIcon" :class="\'bx-vue-list-icon-subtitle-left bx-vue-list-icon-subtitle-left-\' + listItem.subtitle.leftIcon"></div>\n\t\t\t\t\t\t\t<span class="bx-vue-list-item-bottom-subtitle-text">{{ listItem.subtitle.value }}</span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class="bx-vue-list-item-bottom-counter">\n\t\t\t\t\t\t\t<div v-if="listItem.counter.leftIcon" :class="\'bx-vue-list-icon-counter-left bx-vue-list-icon-counter-left-\' + listItem.counter.leftIcon"></div>\n\t\t\t\t\t\t\t<div v-if="listItem.counter.value > 0" class="bx-vue-list-item-bottom-counter-value">{{ listItem.counter.value }}</div>\n\t\t\t\t\t\t\t<div v-else-if="listItem.notification" class="bx-vue-list-item-bottom-counter-notification"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t\t<template v-else-if="listItem.template === itemTypes.placeholder">\n\t\t\t\t<div class="bx-vue-list-item-image-wrap"><img src="https://www.ischool.berkeley.edu/sites/default/files/default_images/avatar.jpeg" alt="" class="bx-vue-list-item-image"></div>\n\t\t\t\t<div class="bx-vue-list-item-content">\n\t\t\t\t\t<div class="bx-vue-list-item-content-header">\n\t\t\t\t\t\t<div class="bx-vue-list-item-placeholder-title"></div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="bx-vue-list-item-content-bottom">\n\t\t\t\t\t\t<div class="bx-vue-list-item-bottom-subtitle">\n\t\t\t\t\t\t\t<div class="bx-vue-list-item-placeholder-subtitle"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t</div>\n\t'});
/**
	 * Bitrix UI
	 * Base list
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2020 Bitrix
	 */i.BitrixVue.component("bx-list",{data:function t(){return{generalSectionName:"general",showSectionNames:true,resultList:{},itemTypes:{default:"default",placeholder:"placeholder"},cssPrefix:"",observer:null,elementComponent:"bx-list-element"}},created:function t(){},methods:{validateData:function t(e){var i=this;var l=[];e.items.forEach((function(t){l.push(i.validateItem(t))}));this.list=l;this.validateSections(e.sections)},validateItem:function t(e){var i={};if(typeof e.id==="number"||typeof e.id==="string"){i.id=e.id.toString()}if(typeof e.type!=="undefined"&&this.itemTypes[e.type]){i.type=e.type}else{i.type=this.itemTypes["default"]}if(typeof e.title!=="undefined"){i.title={};if(babelHelpers["typeof"](e.title)==="object"&&e.title){if(typeof e.title.value==="string"){i.title.value=e.title.value}if(typeof e.title.leftIcon==="string"){i.title.leftIcon=e.title.leftIcon}if(typeof e.title.rightIcon==="string"){i.title.rightIcon=e.title.rightIcon}}else if(typeof e.title==="string"){i.title.value=e.title}}if(typeof e.subtitle!=="undefined"){i.subtitle={};if(babelHelpers["typeof"](e.subtitle)==="object"&&e.subtitle){if(typeof e.subtitle.value==="string"){i.subtitle.value=e.subtitle.value}if(typeof e.subtitle.leftIcon==="string"){i.subtitle.leftIcon=e.subtitle.leftIcon}}else if(typeof e.subtitle==="string"){i.subtitle.value=e.subtitle}}if(typeof e.avatar!=="undefined"){i.avatar={};if(babelHelpers["typeof"](e.avatar)==="object"&&e.avatar){if(typeof e.avatar.url==="string"){i.avatar.url=e.avatar.url}if(typeof e.avatar.topLeftIcon==="string"){i.avatar.topLeftIcon=e.avatar.topLeftIcon}if(typeof e.avatar.bottomRightIcon==="string"){i.avatar.bottomRightIcon=e.avatar.bottomRightIcon}}else if(typeof e.avatar==="string"){i.avatar.url=e.avatar}}if(typeof e.date!=="undefined"){i.date={};if(babelHelpers["typeof"](e.date)==="object"&&e.date&&!(e.date instanceof Date)){if(e.date.value instanceof Date){i.date.value=this.formatDate(e.date.value)}if(typeof e.date.leftIcon==="string"){i.date.leftIcon=e.date.leftIcon}}else if(e.date instanceof Date){i.date.value=this.formatDate(e.date)}}if(typeof e.sectionCode==="string"){i.sectionCode=e.sectionCode}if(typeof e.counter==="number"){i.counter=this.formatCounter(e.counter)}if(typeof e.notification==="boolean"){i.notification=e.notification}return i},validateSections:function t(e){var i=this;if(e&&e.length>0){e.forEach((function(t){if(typeof t==="string"&&t.length>0){i.sections.push(t)}}))}if(this.sections.length===0){this.sections=[this.generalSectionName];this.list.map((function(t){t.sectionCode=i.generalSectionName;return t}))}},formatCounter:function t(e){if(e>999){e=999}else if(e<0){e=0}return e},onScroll:function t(e){},onClick:function t(e,i){},onDoubleClick:function t(e){}},computed:{wrapperStyle:function t(){return this.cssPrefix+" bx-vue-list-wrap"},list:function t(){return[]},sections:function t(){return[]},sectionedList:function t(){var e=this;this.sections.forEach((function(t){i.BitrixVue.set(e.resultList,t,[]);var l=e.list.filter((function(e){return e.sectionCode===t}));e.resultList[t]=babelHelpers.toConsumableArray(l)}));return this.resultList}},template:'\n\t\t<div :class="wrapperStyle" @scroll="onScroll">\n\t\t\t<template v-for="section in sections">\n\t\t\t\t<div v-if="sections.length > 1 && sectionedList[section].length > 0 && showSectionNames" class="bx-vue-list-section">{{ section }}</div>\n\t\t\t\t<div\n\t\t\t\t\tv-for="listItem in sectionedList[section]"\n\t\t\t\t\t:key="listItem.id"\n\t\t\t\t\t@click="onClick($event, listItem.id)"\n\t\t\t\t\t@click.right="onRightClick($event, listItem.id)"\n\t\t\t\t\t:data-id="listItem.id"\n\t\t\t\t>\n\t\t\t\t\t<component :is="elementComponent" :rawListItem="listItem" :itemTypes="itemTypes" @dblclick="onDoubleClick"/>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t</div>\n\t'})})(this.window=this.window||{},BX,BX);
//# sourceMappingURL=list.bundle.map.js