(function(t){"use strict";BX.Vue.component("bx-smiles",{data:function t(){return{smiles:[],sets:[]}},created:function t(){var s=this;this.setSelected=0;this.serverLoad=false;this.smilesController=new e(this.$root.$bitrixRestClient);this.smilesController.loadFromCache().then(function(t){if(s.serverLoad)return true;s.smiles=t.smiles;s.sets=t.sets.map(function(t,e){t.selected=s.setSelected===e;return t})});this.smilesController.loadFromServer().then(function(t){s.smiles=t.smiles;s.sets=t.sets.map(function(t,e){t.selected=s.setSelected===e;return t})})},methods:{selectSet:function t(e){var s=this;this.$emit("selectSet",{setId:e});this.smilesController.changeSet(e).then(function(t){s.smiles=t;s.sets.map(function(t){t.selected=t.id===e;if(t.selected){s.setSelected=e}return t});s.$refs.elements.scrollTop=0})},selectSmile:function t(e){this.$emit("selectSmile",{text:" "+e+" "})}},template:'\n\t\t<div class="bx-ui-smiles-box">\n\t\t\t<div class="bx-ui-smiles-elements-wrap" ref="elements">\n\t\t\t\t<template v-if="!smiles.length">\n\t\t\t\t\t<svg class="bx-ui-smiles-loading-circular" viewBox="25 25 50 50">\n\t\t\t\t\t\t<circle class="bx-ui-smiles-loading-path" cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"/>\n\t\t\t\t\t\t<circle class="bx-ui-smiles-loading-inner-path" cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"/>\n\t\t\t\t\t</svg>\n\t\t\t\t</template>\n\t\t\t\t<template v-else v-for="smile in smiles">\n\t\t\t\t\t<div class="bx-ui-smiles-smile">\n\t\t\t\t\t\t<img v-bx-lazyload :key="smile.id"\n\t\t\t\t\t\t\tclass="bx-ui-smiles-smile-icon"\n\t\t\t\t\t\t\t:data-lazyload-src="smile.image"\n\t\t\t\t\t\t\tdata-lazyload-error-class="bx-ui-smiles-smile-icon-error"\n\t\t\t\t\t\t\t:title="smile.name"\n\t\t\t\t\t\t\t:style="{height: (smile.originalHeight*0.5)+\'px\', width: (smile.originalWidth*0.5)+\'px\'}"\n\t\t\t\t\t\t\t@click="selectSmile(smile.typing)"\n\t\t\t\t\t\t/>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t\t<template v-if="sets.length > 1">\n\t\t\t\t<div class="bx-ui-smiles-sets">\n\t\t\t\t\t<template v-for="set in sets">\n\t\t\t\t\t\t<div :class="[\'bx-ui-smiles-set\', {\'bx-ui-smiles-set-selected\': set.selected}]">\n\t\t\t\t\t\t\t<img v-bx-lazyload :key="set.id"\n\t\t\t\t\t\t\t\tclass="bx-ui-smiles-set-icon"\n\t\t\t\t\t\t\t\t:data-lazyload-src="set.image"\n\t\t\t\t\t\t\t\tdata-lazyload-error-class="bx-ui-smiles-set-icon-error"\n\t\t\t\t\t\t\t\t:title="set.name"\n\t\t\t\t\t\t\t\t@click="selectSet(set.id)"\n\t\t\t\t\t\t\t/>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template>\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t</div>\n\t'});var e=function(){function t(e){babelHelpers.classCallCheck(this,t);if(typeof e!=="undefined"){this.restClient=e}else{this.restClient=new BX.RestClient}this.db=new BX.IndexedDB("bx-ui-smiles");this.db.version(1).stores({sets:"id, parentId, name, type, image",smiles:"id, setId, name, image, typing, width, height, originalWidth, originalHeight, definition"})}babelHelpers.createClass(t,[{key:"loadFromCache",value:function t(){var e=this;var s=new BX.Promise;var i=[];var n=[];this.db.transaction("r",this.db.sets,this.db.smiles,function(){e.db.sets.each(function(t){return e.db.smiles.where("setId").equals(t.id).first().then(function(e){i.push(babelHelpers.objectSpread({},t,{image:e.image}))}).catch(function(t){return s.reject(t)})}).then(function(){return e.db.smiles.where("setId").equals(i[0].id).each(function(t){n.push(t)})}).then(function(){var t={sets:i,smiles:n};s.resolve(t)}).catch(function(t){return s.reject(t)})});return s}},{key:"loadFromServer",value:function t(){var e=this;var s=new BX.Promise;this.restClient.callMethod("smile.get").then(function(t){var i=[];var n=[];var l=t.data();var r={};l.smiles=l.smiles.map(function(t){if(!r[t.setId]){r[t.setId]=t.image}var e=t.width;if(t.definition=="HD"){e=e*2}else if(t.definition=="UHD"){e=e*4}var s=t.height;if(t.definition=="HD"){s=s*2}else if(t.definition=="UHD"){s=s*4}return babelHelpers.objectSpread({},t,{originalWidth:e,originalHeight:s})});l.sets.forEach(function(t){i.push(babelHelpers.objectSpread({},t,{image:r[t.id]}))});l.smiles.forEach(function(t){if(t.setId==i[0].id){n.push(t)}});var a={sets:i,smiles:n};s.resolve(a);e.db.smiles.clear().then(function(){return e.db.sets.clear().then(function(){e.db.sets.bulkAdd(i);e.db.smiles.bulkAdd(l.smiles)}).catch(function(t){return s.reject(t)})}).catch(function(t){return s.reject(t)})}).catch(function(t){return s.reject(t)});return s}},{key:"changeSet",value:function t(e){var s=new BX.Promise;this.db.smiles.where("setId").equals(e).toArray(function(t){s.resolve(t)}).catch(function(t){return s.reject(t)});return s}}]);return t}()})(this.window=this.window||{});
//# sourceMappingURL=ui.vue.components.smiles.bundle.map.js