this.BX=this.BX||{};this.BX.Vue3=this.BX.Vue3||{};(function(t,e,i,s,r){"use strict";
/**
	 * Bitrix UI
	 * Audio player Vue component
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2021 Bitrix
	 */const a=Object.freeze({play:"play",pause:"pause",stop:"stop",none:"none"});const o=s.BitrixVue.mutableComponent("ui-audioplayer",{props:{id:{default:0},src:{default:""},autoPlayNext:{default:true},background:{default:"light"}},data(){return{isDark:false,preload:"none",loaded:false,loading:false,playAfterLoad:false,state:a.none,progress:0,progressInPixel:0,seek:0,timeCurrent:0,timeTotal:0}},created(){this.preloadRequestSent=false;this.registeredId=0;this.registerPlayer(this.id);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:play",this.onPlay);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:stop",this.onStop);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:pause",this.onPause);this.$Bitrix.eventEmitter.subscribe("ui:audioplayer:preload",this.onPreload);r.EventEmitter.subscribe("ui:audioplayer:pause",this.onPause);this.isDark=this.background==="dark"},mounted(){this.getObserver().observe(this.$refs.body)},beforeUnmount(){this.unregisterPlayer();this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:play",this.onPlay);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:stop",this.onStop);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:pause",this.onPause);this.$Bitrix.eventEmitter.unsubscribe("ui:audioplayer:preload",this.onPreload);r.EventEmitter.unsubscribe("ui:audioplayer:pause",this.onPause);this.getObserver().unobserve(this.$refs.body)},watch:{id(t){this.registerPlayer(t)},progress(t){if(t>70){this.preloadNext()}}},methods:{loadFile(t=false){if(this.loaded){return true}if(this.loading&&!t){return true}this.preload="auto";if(t){this.loading=true;if(this.source()){this.source().play()}}return true},clickToButton(){if(!this.src){return false}if(this.state===a.play){this.pause()}else{this.play()}},play(){if(!this.loaded){this.loadFile(true);return false}this.source().play()},pause(){this.source().pause()},stop(){this.state=a.stop;this.source().pause()},setPosition(t){if(!this.loaded){this.loadFile(true);return false}let e=this.$refs.track.offsetWidth/100;this.setProgress(this.seek/e,this.seek);if(this.state!==a.play){this.state=a.pause}this.play();this.source().currentTime=this.timeTotal/100*this.progress},seeking(t){if(!this.loaded){return false}this.seek=t.offsetX>0?t.offsetX:0;return true},setProgress(t,e=-1){this.progress=t;this.progressInPixel=e>0?e:Math.round(this.$refs.track.offsetWidth/100*t)},formatTime(t){t=Math.floor(t);const e=Math.floor(t/60/60);if(e>0){t-=e*60*60}const i=Math.floor(t/60);if(i>0){t-=i*60}return(e>0?e+":":"")+(e>0?i.toString().padStart(2,"0")+":":i+":")+t.toString().padStart(2,"0")},registerPlayer(t){if(t<=0){return false}this.unregisterPlayer();this.$Bitrix.Data.set("ui:audioplayer:id",[...new Set([...this.$Bitrix.Data.get("ui:audioplayer:id",[]),t])].sort(((t,e)=>t-e)));this.registeredId=t;return true},unregisterPlayer(){if(!this.registeredId){return true}this.$Bitrix.Data.get("ui:audioplayer:id",this.$Bitrix.Data.get("ui:audioplayer:id",[]).filter((t=>t!==this.registeredId)));this.registeredId=0;return true},playNext(){if(!this.registeredId||!this.autoPlayNext){return false}const t=this.$Bitrix.Data.get("ui:audioplayer:id",[]).filter((t=>t>this.registeredId)).slice(0,1)[0];if(t){this.$Bitrix.eventEmitter.emit("ui:audioplayer:play",{id:t,start:true})}return true},preloadNext(){if(this.preloadRequestSent){return true}if(!this.registeredId||!this.autoPlayNext){return false}this.preloadRequestSent=true;const t=this.$Bitrix.Data.get("ui:audioplayer:id",[]).filter((t=>t>this.registeredId)).slice(0,1)[0];if(t){this.$Bitrix.eventEmitter.emit("ui:audioplayer:preload",{id:t})}return true},onPlay(t){const e=t.getData();if(e.id!==this.id){return false}if(e.start){this.stop()}this.play()},onStop(t){const e=t.getData();if(e.initiator===this.id){return false}this.stop()},onPause(t){const e=t.getData();if(e.initiator===this.id){return false}this.pause()},onPreload(t){const e=t.getData();if(e.id!==this.id){return false}this.loadFile()},source(){return this.$refs.source},audioEventRouter(t,e){if(t==="durationchange"||t==="loadeddata"||t==="loadedmetadata"){if(!this.source()){return}this.timeTotal=this.source().duration}else if(t==="abort"||t==="error"){console.error("BxAudioPlayer: load failed",this.id,e);this.loading=false;this.state=a.none;this.timeTotal=0;this.preload="none"}else if(t==="canplaythrough"){this.loading=false;this.loaded=true}else if(t==="timeupdate"){if(!this.source()){return}this.timeCurrent=this.source().currentTime;this.setProgress(Math.round(100/this.timeTotal*this.timeCurrent));if(this.state===a.play&&this.timeCurrent>=this.timeTotal){this.playNext()}}else if(t==="pause"){if(this.state!==a.stop){this.state=a.pause}}else if(t==="play"){this.state=a.play;if(this.state===a.stop){this.progress=0;this.timeCurrent=0}if(this.id>0){this.$Bitrix.eventEmitter.emit("ui:audioplayer:pause",{initiator:this.id});r.EventEmitter.emit("ui:audioplayer:pause",{initiator:this.id})}}},getObserver(){if(this.observer){return this.observer}this.observer=new IntersectionObserver(((t,e)=>{t.forEach((t=>{if(t.isIntersecting){if(this.preload==="none"){this.preload="metadata";this.observer.unobserve(t.target)}}}))}),{threshold:[0,1]});return this.observer}},computed:{State:()=>a,seekPosition(){if(!this.loaded&&!this.seek||this.isMobile){return"display: none"}return`left: ${this.seek}px;`},progressPosition(){if(!this.loaded||this.state===a.none){return`width: 100%;`}return`width: ${this.progressInPixel}px;`},labelTime(){if(!this.loaded&&!this.timeTotal){return"--:--"}let t;if(this.state===a.play){t=this.timeTotal-this.timeCurrent}else{t=this.timeTotal}return this.formatTime(t)},isMobile(){const t=navigator.userAgent.toLowerCase();return t.includes("android")||t.includes("iphone")||t.includes("ipad")||t.includes("bitrixmobile")}},template:`\n\t\t<div :class="['ui-vue-audioplayer-container', {\n\t\t\t\t'ui-vue-audioplayer-container-dark': isDark,\n\t\t\t\t'ui-vue-audioplayer-container-mobile': isMobile,\n\t\t\t}]" ref="body">\n\t\t\t<div class="ui-vue-audioplayer-controls-container">\n\t\t\t\t<button :class="['ui-vue-audioplayer-control', {\n\t\t\t\t\t'ui-vue-audioplayer-control-loader': loading,\n\t\t\t\t\t'ui-vue-audioplayer-control-play': !loading && state !== State.play,\n\t\t\t\t\t'ui-vue-audioplayer-control-pause': !loading && state === State.play,\n\t\t\t\t}]" @click="clickToButton"></button>\n\t\t\t</div>\n\t\t\t<div class="ui-vue-audioplayer-timeline-container">\n\t\t\t\t<div class="ui-vue-audioplayer-track-container" @click="setPosition" ref="track">\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-mask"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track" :style="progressPosition"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-seek" :style="seekPosition"></div>\n\t\t\t\t\t<div class="ui-vue-audioplayer-track-event" @mousemove="seeking"></div>\n\t\t\t\t</div>\n\t\t\t\t<div class="ui-vue-audioplayer-timers-container">\n\t\t\t\t\t<div class="ui-vue-audioplayer-time-current">{{labelTime}}</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<audio v-if="src" :src="src" class="ui-vue-audioplayer-source" ref="source" :preload="preload"\n\t\t\t\t@abort="audioEventRouter('abort', $event)"\n\t\t\t\t@error="audioEventRouter('error', $event)"\n\t\t\t\t@suspend="audioEventRouter('suspend', $event)"\n\t\t\t\t@canplay="audioEventRouter('canplay', $event)"\n\t\t\t\t@canplaythrough="audioEventRouter('canplaythrough', $event)"\n\t\t\t\t@durationchange="audioEventRouter('durationchange', $event)"\n\t\t\t\t@loadeddata="audioEventRouter('loadeddata', $event)"\n\t\t\t\t@loadedmetadata="audioEventRouter('loadedmetadata', $event)"\n\t\t\t\t@timeupdate="audioEventRouter('timeupdate', $event)"\n\t\t\t\t@play="audioEventRouter('play', $event)"\n\t\t\t\t@playing="audioEventRouter('playing', $event)"\n\t\t\t\t@pause="audioEventRouter('pause', $event)"\n\t\t\t></audio>\n\t\t</div>\n\t`});t.AudioPlayerState=a;t.AudioPlayer=o})(this.BX.Vue3.Components=this.BX.Vue3.Components||{},BX,BX,BX.Vue3,BX.Event);
//# sourceMappingURL=audioplayer.bundle.map.js