this.BX=this.BX||{};this.BX.Vue3=this.BX.Vue3||{};(function(t,e,i,s,a){"use strict";
/**
	 * Bitrix UI
	 * Social Video Vue component
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2021 Bitrix
	 */const o=Object.freeze({play:"play",pause:"pause",stop:"stop",none:"none"});const n={name:"SocialVideo",directives:{lazyload:s.lazyload},props:{id:{type:[String,Number],default:0},src:{type:String,default:""},preview:{type:String,default:""},autoplay:{type:Boolean,default:true},containerClass:{type:String,default:null},containerStyle:{type:Object,default:null},elementStyle:{type:Object,default:null},showControls:{type:Boolean,default:true},playCallback:{type:[Function,null],default:null}},data(){return{preload:"none",previewLoaded:false,loaded:false,loading:false,playAfterLoad:false,enterFullscreen:false,playBeforeMute:2,state:o.none,progress:0,timeCurrent:0,timeTotal:0,muteFlag:true}},computed:{State:()=>o,autoPlayDisabled(){return!this.autoplay&&this.state===o.none},showStartButton(){return this.autoPlayDisabled&&this.previewLoaded},showInterface(){return this.previewLoaded&&!this.showStartButton},labelTime(){if(!this.loaded&&!this.timeTotal){return"--:--"}let t=0;if(this.state===o.play){t=this.timeTotal-this.timeCurrent}else{t=this.timeTotal}return this.formatTime(t)},isMobile(){const t=navigator.userAgent.toLowerCase();return t.includes("android")||t.includes("iphone")||t.includes("ipad")||t.includes("bitrixmobile")},source(){return this.$refs.source}},created(){if(!this.preview){this.previewLoaded=true;this.preload="metadata"}a.EventEmitter.subscribe("ui:socialvideo:play",this.onPlay);a.EventEmitter.subscribe("ui:socialvideo:stop",this.onStop);a.EventEmitter.subscribe("ui:socialvideo:pause",this.onPause)},mounted(){this.getObserver().observe(this.$refs.body)},beforeUnmount(){a.EventEmitter.unsubscribe("ui:socialvideo:play",this.onPlay);a.EventEmitter.unsubscribe("ui:socialvideo:stop",this.onStop);a.EventEmitter.unsubscribe("ui:socialvideo:pause",this.onPause);this.getObserver().unobserve(this.$refs.body)},methods:{loadFile(t=false){if(this.loaded){return true}if(this.loading){return true}this.preload="auto";this.loading=true;this.playAfterLoad=t;return true},clickToButton(t){if(!this.src){return}if(this.state===o.play){this.getObserver().unobserve(this.$refs.body);this.pause()}else{this.play()}t.stopPropagation()},clickToMute(){if(!this.src){return}if(this.muteFlag){this.unmute()}else{this.mute()}},click(t){if(this.autoPlayDisabled){this.play();t.stopPropagation();return}if(this.isMobile){if(this.source.webkitEnterFullscreen){this.unmute();this.enterFullscreen=true;this.source.webkitEnterFullscreen()}else if(this.source.requestFullscreen){this.unmute();this.enterFullscreen=true;this.source.requestFullscreen()}else{this.$emit("click",t)}}else{this.$emit("click",t)}t.stopPropagation()},play(t){if(this.playCallback){this.playCallback();return}if(!this.loaded){this.loadFile(true);return}if(!this.source){return}this.source.play()},pause(){if(!this.source){return}this.playAfterLoad=false;this.source.pause()},stop(){if(!this.source){return}this.state=o.stop;this.source.pause()},mute(){if(!this.source){return}this.muteFlag=true;this.playBeforeMute=2;this.source.muted=true},unmute(){if(!this.source){return}this.muteFlag=false;this.source.muted=false},setProgress(t){this.progress=t},formatTime(t){t=Math.floor(t);const e=Math.floor(t/60/60);if(e>0){t-=e*60*60}const i=Math.floor(t/60);if(i>0){t-=i*60}return(e>0?e+":":"")+(e>0?i.toString().padStart(2,"0")+":":i+":")+t.toString().padStart(2,"0")},onPlay(t){const e=t.getData();if(e.id!==this.id){return false}if(e.start){this.stop()}this.play()},onStop(t){const e=t.getData();if(e.initiator===this.id){return false}this.stop()},onPause(t){const e=t.getData();if(e.initiator===this.id){return false}this.pause()},videoEventRouter(t,e){if(t==="durationchange"||t==="loadeddata"){if(!this.source){return false}this.timeTotal=this.source.duration}else if(t==="loadedmetadata"){if(!this.source){return false}this.timeTotal=this.source.duration;this.loaded=true;if(this.playAfterLoad){this.play()}}else if(t==="abort"||t==="error"){console.error("BxSocialVideo: load failed",this.id,e);this.loading=false;this.state=o.none;this.timeTotal=0;this.preload="none"}else if(t==="canplaythrough"){this.loading=false;this.loaded=true;if(this.playAfterLoad){this.play()}}else if(t==="volumechange"){if(!this.source){return false}if(this.source.muted){this.mute()}else{this.unmute()}}else if(t==="timeupdate"){if(!this.source){return false}this.timeCurrent=this.source.currentTime;if(!this.muteFlag&&!this.enterFullscreen&&this.timeCurrent===0){if(this.playBeforeMute<=0){this.mute()}this.playBeforeMute-=1}this.setProgress(Math.round(100/this.timeTotal*this.timeCurrent))}else if(t==="pause"){if(this.state!==o.stop){this.state=o.pause}if(this.enterFullscreen){this.enterFullscreen=false;this.mute();this.play()}}else if(t==="play"){this.state=o.play;if(this.state===o.stop){this.progress=0;this.timeCurrent=0}if(this.enterFullscreen){this.enterFullscreen=false}}},getObserver(){if(this.observer){return this.observer}this.observer=new IntersectionObserver(((t,e)=>{if(this.autoPlayDisabled){return}t.forEach((t=>{if(t.isIntersecting){this.play()}else{this.pause()}}))}),{threshold:[0,1]});return this.observer},lazyLoadCallback(t){this.previewLoaded=t.state==="success"}},template:`\n\t\t<div :class="['ui-vue-socialvideo', containerClass, {\n\t\t\t\t'ui-vue-socialvideo-mobile': isMobile,\n\t\t\t}]" :style="containerStyle" @click="click">\n\t\t\t<transition name="ui-vue-socialvideo-animation-fade">\n\t\t\t\t<div v-if="showStartButton && showControls" class="ui-vue-socialvideo-button-start">\n\t\t\t\t\t<span class="ui-vue-socialvideo-button-start-icon"></span>\n\t\t\t\t</div>\n\t\t\t</transition>\n\t\t\t<transition name="ui-vue-socialvideo-animation-fade">\n\t\t\t\t<div v-if="showInterface && showControls" class="ui-vue-socialvideo-overlay-container">\n\t\t\t\t\t<div class="ui-vue-socialvideo-controls-container" @click="clickToButton">\n\t\t\t\t\t\t<button :class="['ui-vue-socialvideo-control', {\n\t\t\t\t\t\t\t'ui-vue-socialvideo-control-loader': loading,\n\t\t\t\t\t\t\t'ui-vue-socialvideo-control-play': !loading && state !== State.play,\n\t\t\t\t\t\t\t'ui-vue-socialvideo-control-pause': !loading && state === State.play,\n\t\t\t\t\t\t}]"></button>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="ui-vue-socialvideo-info-container" @click="clickToMute">\n\t\t\t\t\t\t<span class="ui-vue-socialvideo-time-current">{{labelTime}}</span>\n\t\t\t\t\t\t<span :class="['ui-vue-socialvideo-sound', {\n\t\t\t\t\t\t\t'ui-vue-socialvideo-sound-on': state !== State.none && !muteFlag,\n\t\t\t\t\t\t\t'ui-vue-socialvideo-sound-off': state !== State.none && muteFlag\n\t\t\t\t\t\t}]"></span>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</transition>\n\t\t\t<div v-if="!preview" class="ui-vue-socialvideo-background" :style="{position: (src? 'absolute': 'relative')}"></div>\n\t\t\t<div class="ui-vue-socialvideo-container" ref="body">\n\t\t\t\t<img\n\t\t\t\t\tv-lazyload="{callback: lazyLoadCallback}"\n\t\t\t\t\tdata-lazyload-dont-hide\n\t\t\t\t\tv-if="preview"\n\t\t\t\t\tclass="ui-vue-socialvideo-image-source"\n\t\t\t\t\t:data-lazyload-src="preview"\n\t\t\t\t\t:style="{position: (src? 'absolute': 'relative'), ...elementStyle}"\n\t\t\t\t/>\n\t\t\t\t<video\n\t\t\t\t\tv-if="src" :src="src"\n\t\t\t\t\tclass="ui-vue-socialvideo-source"\n\t\t\t\t\tref="source"\n\t\t\t\t\t:preload="preload"\n\t\t\t\t\tplaysinline\n\t\t\t\t\tloop\n\t\t\t\t\tmuted\n\t\t\t\t\t:style="{opacity: (loaded? 1: 0), ...elementStyle}"\n\t\t\t\t\t@abort="videoEventRouter('abort', $event)"\n\t\t\t\t\t@error="videoEventRouter('error', $event)"\n\t\t\t\t\t@suspend="videoEventRouter('suspend', $event)"\n\t\t\t\t\t@canplay="videoEventRouter('canplay', $event)"\n\t\t\t\t\t@canplaythrough="videoEventRouter('canplaythrough', $event)"\n\t\t\t\t\t@durationchange="videoEventRouter('durationchange', $event)"\n\t\t\t\t\t@loadeddata="videoEventRouter('loadeddata', $event)"\n\t\t\t\t\t@loadedmetadata="videoEventRouter('loadedmetadata', $event)"\n\t\t\t\t\t@volumechange="videoEventRouter('volumechange', $event)"\n\t\t\t\t\t@timeupdate="videoEventRouter('timeupdate', $event)"\n\t\t\t\t\t@play="videoEventRouter('play', $event)"\n\t\t\t\t\t@playing="videoEventRouter('playing', $event)"\n\t\t\t\t\t@pause="videoEventRouter('pause', $event)"\n\t\t\t\t></video>\n\t\t\t</div>\n\t\t</div>\n\t`};t.SocialVideoState=o;t.SocialVideo=n})(this.BX.Vue3.Components=this.BX.Vue3.Components||{},BX,BX,BX.Vue3.Directives,BX.Event);
//# sourceMappingURL=socialvideo.bundle.map.js