<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
$this->setFrameMode(true);

/**
 * @global CMain $APPLICATION
 * @var array $arParams
 * @var array $arResult
 * @var CatalogSectionComponent $component
 * @var CBitrixComponentTemplate $this
 * @var string $templateName
 * @var string $componentPath
 * @var string $templateFolder
 */

global $arTheme;
use \Bitrix\Main\Localization\Loc,
	\Aspro\Functions\CAsproAllcorp3Resort;

$bOrderViewBasket = $arParams['ORDER_VIEW'];
$basketURL = isset($arTheme['BASKET_PAGE_URL']) && strlen(trim($arTheme['BASKET_PAGE_URL']['VALUE'])) ? $arTheme['BASKET_PAGE_URL']['VALUE'] : SITE_DIR.'cart/';
$dataItem = $bOrderViewBasket ? CAllcorp3Resort::getDataItem($arResult) : false;
$bOrderButton = $arResult['PROPERTIES']['FORM_ORDER']['VALUE_XML_ID'] == 'YES';
$bAskButton = $arResult['PROPERTIES']['FORM_QUESTION']['VALUE_XML_ID'] == 'YES';
$bOcbButton = $arParams['SHOW_ONE_CLINK_BUY'] != 'N';
$bGalleryThmbVertical = $arParams['GALLERY_THUMB_POSITION'] == 'vertical';
$cntVisibleChars = intval($arParams['VISIBLE_PROP_COUNT']) > 0 ? intval($arParams['VISIBLE_PROP_COUNT']) : 6;

/*set array props for component_epilog*/
$templateData = array(
	'DETAIL_PAGE_URL' => $arResult['DETAIL_PAGE_URL'],
	'ORDER' => $bOrderViewBasket,
	'TIZERS' => array(
		'IBLOCK_ID' => $arResult['PROPERTIES']['LINK_TIZERS']['LINK_IBLOCK_ID'],
		'VALUE' => $arResult['TIZERS'],
	),
	'PRICES' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_PRICES')),
	'FAQ' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_FAQ')),
	'REVIEWS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_REVIEWS')),
	'VACANCY' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_VACANCY')),
	'PARTNERS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_PARTNERS')),
	'SALE' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_SALE'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'NEWS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_NEWS'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'STAFF' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_STAFF'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'ARTICLES' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_ARTICLES'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'PROJECTS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_PROJECTS'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'SERVICES' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_SERVICES'), array('LINK_GOODS', 'LINK_GOODS_FILTER')),
	'SKU' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_SKU')),
	'GOODS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_GOODS', 'LINK_GOODS_FILTER'), array('LINK_GOODS')),
	'TARIFFS' => CAsproAllcorp3Resort::getCrossLinkedItems($arResult, array('LINK_TARIF')),
);

$article = $arResult['DISPLAY_PROPERTIES']['ARTICLE']['VALUE'];
$status = $arResult['DISPLAY_PROPERTIES']['STATUS']['VALUE'];
$statusCode = $arResult['DISPLAY_PROPERTIES']['STATUS']['VALUE_XML_ID'];

/* sku replace start */
$arCurrentOffer = $arResult['SKU']['CURRENT'];

if ($arCurrentOffer) {
	$arResult['PARENT_IMG'] = '';
	if ($arResult['PREVIEW_PICTURE']) {
		$arResult['PARENT_IMG'] = $arResult['PREVIEW_PICTURE'];
	} elseif ($arResult['DETAIL_PICTURE']) {
		$arResult['PARENT_IMG'] = $arResult['DETAIL_PICTURE'];
	}

	$oid = \Bitrix\Main\Config\Option::get('aspro.allcorp3resort', 'CATALOG_OID', 'oid');
	if ($oid) {
		$arResult['DETAIL_PAGE_URL'].= '?'.$oid.'='.$arCurrentOffer['ID'];
		$arCurrentOffer['DETAIL_PAGE_URL'] = $arResult['DETAIL_PAGE_URL'];
	}
	if ($arParams['SHOW_GALLERY'] === 'Y') {
		$pictureID = $arCurrentOffer['DETAIL_PICTURE'] ?? $arCurrentOffer['PREVIEW_PICTURE'];
		if ($pictureID) {
			$arPicture = \CFile::GetFileArray($pictureID);

			$alt = $arParams['CHANGE_TITLE_ITEM_DETAIL'] === 'Y' ? $arCurrentOffer['NAME'] : $arResult['NAME'];
			$title = $arParams['CHANGE_TITLE_ITEM_DETAIL'] === 'Y' ? $arCurrentOffer['NAME'] : $arResult['NAME'];
			if ($arResult['ALT_TITLE_GET'] == 'SEO') {
				$alt = $arPicture['ALT'] ?: $alt;
				$title = $arPicture['TITLE'] ?: $title;
			}
			else {
				$alt = $arPicture['DESCRIPTION'] ?: $arPicture['ALT'] ?: $alt;
				$title = $arPicture['DESCRIPTION'] ?: $arPicture['TITLE'] ?: $title;
			}
			
			$arPicture['TITLE'] = $title;
			$arPicture['ALT'] = $alt;
			
			if (is_array($arResult['GALLERY'])) {
				array_unshift($arResult['GALLERY'], $arPicture);
				array_splice($arResult['GALLERY'], $arParams['MAX_GALLERY_ITEMS']);
			}
		}
	} else {
		if ($arCurrentOffer['PREVIEW_PICTURE'] || $arCurrentOffer['DETAIL_PICTURE']) {
			if ($arCurrentOffer['PREVIEW_PICTURE']) {
				$arResult['PREVIEW_PICTURE'] = $arCurrentOffer['PREVIEW_PICTURE'];
			} elseif ($arCurrentOffer['DETAIL_PICTURE']) {
				$arResult['PREVIEW_PICTURE'] = $arCurrentOffer['DETAIL_PICTURE'];
			}
		}
	}
	if (!$arCurrentOffer['PREVIEW_PICTURE'] && !$arCurrentOffer['DETAIL_PICTURE']) {
		if ($arResult['PREVIEW_PICTURE']) {
			$arCurrentOffer['PREVIEW_PICTURE'] = $arResult['PREVIEW_PICTURE'];
		} elseif ($arResult['DETAIL_PICTURE']) {
			$arCurrentOffer['PREVIEW_PICTURE'] = $arResult['DETAIL_PICTURE'];
		}
	}

	if ($arCurrentOffer["DISPLAY_PROPERTIES"]["ARTICLE"]["VALUE"]) {
		$article = $arCurrentOffer['DISPLAY_PROPERTIES']['ARTICLE']['VALUE'];
	}
	if ($arCurrentOffer["DISPLAY_PROPERTIES"]["STATUS"]["VALUE"]) {
		$status = $arCurrentOffer['DISPLAY_PROPERTIES']['STATUS']['VALUE'];
		$statusCode = $arCurrentOffer['DISPLAY_PROPERTIES']['STATUS']['VALUE_XML_ID'];
	}

	$arResult["DISPLAY_PROPERTIES"]["FORM_ORDER"] = $arCurrentOffer["DISPLAY_PROPERTIES"]["FORM_ORDER"];
	$arResult["DISPLAY_PROPERTIES"]["PRICE"] = $arCurrentOffer["DISPLAY_PROPERTIES"]["PRICE"];
	
	if ($arParams['SHOW_SKU_DESCRIPTION'] === 'Y') {
		if (strlen($arCurrentOffer["PREVIEW_TEXT"])) {
			$arResult["PREVIEW_TEXT"] = $arCurrentOffer["PREVIEW_TEXT"];
			$arResult["PREVIEW_TEXT_TYPE"] = $arCurrentOffer["PREVIEW_TEXT_TYPE"];
		}

		if (strlen($arCurrentOffer["DETAIL_TEXT"])) {
			$arResult["DETAIL_TEXT"] = $arCurrentOffer["DETAIL_TEXT"];
			$arResult["DETAIL_TEXT_TYPE"] = $arCurrentOffer["DETAIL_TEXT_TYPE"];
		}
	}

	$arResult['OFFER_PROP'] = CAllcorp3Resort::PrepareItemProps($arCurrentOffer['DISPLAY_PROPERTIES']);
	
	$dataItem = ($bOrderViewBasket ? CAllcorp3Resort::getDataItem($arCurrentOffer) : false);

	$templateData['CURRENT_SKU'] = [
		'ID' => $arCurrentOffer['ID'],
		'PAGE_TITLE' => $pageTitle = $arCurrentOffer['IPROPERTY_VALUES']['ELEMENT_PAGE_TITLE'] ?? $arCurrentOffer['NAME'],
		'META_TITLE' => $arCurrentOffer['IPROPERTY_VALUES']['ELEMENT_META_TITLE'] ?? $pageTitle,
	];

	if ($arParams['CHANGE_TITLE_ITEM_DETAIL'] === 'Y') {
		$arResult['NAME'] = $templateData['CURRENT_SKU']['PAGE_TITLE'];
		$arResult['IPROPERTY_VALUES']['ELEMENT_PAGE_TITLE'] = $arCurrentOffer['IPROPERTY_VALUES']['ELEMENT_PAGE_TITLE'];
	}
}

$bOrderButton = ($arResult["DISPLAY_PROPERTIES"]["FORM_ORDER"]["VALUE_XML_ID"] == "YES");
/* sku replace end */
?>

<?// top banner?>
<?$templateData['SECTION_BNR_CONTENT'] = isset($arResult['PROPERTIES']['BNR_TOP']) && $arResult['PROPERTIES']['BNR_TOP']['VALUE_XML_ID'] == 'YES' && !empty($arResult['PROPERTIES']['BNR_TOP_BG']['VALUE']);?>
<?if ($templateData['SECTION_BNR_CONTENT']):?>
	<?
	$templateData['SECTION_BNR_UNDER_HEADER'] = $arResult['PROPERTIES']['BNR_TOP_UNDER_HEADER']['VALUE_XML_ID'];
	$templateData['SECTION_BNR_COLOR'] = $arResult['PROPERTIES']['BNR_TOP_COLOR']['VALUE_XML_ID'];
	$atrTitle = $arResult['PROPERTIES']['BNR_TOP_BG']['DESCRIPTION'] ?: $arResult['PROPERTIES']['BNR_TOP_BG']['TITLE'] ?: $arResult['NAME'];
	$atrAlt = $arResult['PROPERTIES']['BNR_TOP_BG']['DESCRIPTION'] ?: $arResult['PROPERTIES']['BNR_TOP_BG']['ALT'] ?: $arResult['NAME'];
	$atrDop1 = $arResult['PROPERTIES']['BUTTON1ATTR']["VALUE"] ? $arResult['PROPERTIES']['BUTTON1ATTR']["VALUE"] : "";
	$atrDop2 = $arResult['PROPERTIES']['BUTTON2ATTR']["VALUE"] ? $arResult['PROPERTIES']['BUTTON2ATTR']["VALUE"] : "";

	//buttons
	$bannerButtons = [
		[
			'TITLE' => $arResult['PROPERTIES']['BUTTON1TEXT']['VALUE'] ?? '',
			'CLASS' => 'btn choise '.($arResult['PROPERTIES']['BUTTON1CLASS']['VALUE_XML_ID'] ?? 'btn-default').' '.($arResult['PROPERTIES']['BUTTON1COLOR']['VALUE_XML_ID'] ?? ''),
			'ATTR' => [
				($arResult['PROPERTIES']['BUTTON1TARGET']['VALUE_XML_ID'] === 'scroll' || !$arResult['PROPERTIES']['BUTTON1TARGET']['VALUE_XML_ID']
					? 'data-block=".right_block .detail"'
					: 'target="'.$arResult['PROPERTIES']['BUTTON1TARGET']['VALUE_XML_ID'].'"'),
					$atrDop1
			],
			'LINK' => $arResult['PROPERTIES']['BUTTON1LINK']['VALUE'],
			'TYPE' => $arResult['PROPERTIES']['BUTTON1TARGET']['VALUE_XML_ID'] === 'scroll' || !$arResult['PROPERTIES']['BUTTON1TARGET']['VALUE_XML_ID']
				? 'anchor'
				: 'link'
		]
	];

	if ($arResult['PROPERTIES']['BUTTON2TEXT']['VALUE'] && $arResult['PROPERTIES']['BUTTON2LINK']['VALUE']) {
		$bannerButtons[] = [
			'TITLE' => $arResult['PROPERTIES']['BUTTON2TEXT']['VALUE'],
			'CLASS' => 'btn choise '.($arResult['PROPERTIES']['BUTTON2CLASS']['VALUE_XML_ID'] ?? 'btn-default').' '.($arResult['PROPERTIES']['BUTTON2COLOR']['VALUE_XML_ID'] ?? ''),
			'ATTR' => [
				($arResult['PROPERTIES']['BUTTON2TARGET']['VALUE_XML_ID'] ? 'target="'.$arResult['PROPERTIES']['BUTTON2TARGET']['VALUE_XML_ID'].'"' : ''),
				$atrDop2
			],
			'LINK' => $arResult['PROPERTIES']['BUTTON2LINK']['VALUE'],
			'TYPE' => 'link',
		];
	}
	?>
	<?$this->SetViewTarget('section_bnr_content');?>
		<?\Aspro\Functions\CAsproAllcorp3Resort::showBlockHtml(array(
			'FILE' => '/images/detail_banner.php',
			'PARAMS' => array(
				'TITLE' => $arResult['NAME'],
				'COLOR' => $templateData['SECTION_BNR_COLOR'],
				'TEXT' => array(
					'TOP' => $arResult['SECTION'] ? reset($arResult['SECTION']['PATH'])['NAME'] : '',
					'PREVIEW' => array(
						'TYPE' => $arResult['PREVIEW_TEXT_TYPE'],
						'VALUE' => $arResult['PREVIEW_TEXT'],
					)
				),
				'PICTURES' => array(
					'BG' => CFile::GetFileArray($arResult['PROPERTIES']['BNR_TOP_BG']['VALUE']),
					'IMG' => CFile::GetFileArray($arResult['PROPERTIES']['BNR_TOP_IMG']['VALUE']),
				),
				'BUTTONS' => $bannerButtons,
				'ATTR' => array(
					'ALT' => $atrAlt,
					'TITLE' => $atrTitle,
				),
				'TOP_IMG' => $bTopImg
			),
		));?>
	<?$this->EndViewTarget();?>
<?elseif ($arResult['FIELDS']['DETAIL_PICTURE']):?>
	<?
	// single detail image
	$arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'] = (isset($arResult['PROPERTIES']['PHOTOPOS']) && !empty($arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID']) ? $arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'] : 'TOP_ON_HEAD');

	$templateData['BANNER_TOP_ON_HEAD'] = isset($arResult['PROPERTIES']['PHOTOPOS']) && $arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'] == 'TOP_ON_HEAD';
	$atrTitle = (strlen($arResult['DETAIL_PICTURE']['DESCRIPTION']) ? $arResult['DETAIL_PICTURE']['DESCRIPTION'] : (strlen($arResult['DETAIL_PICTURE']['TITLE']) ? $arResult['DETAIL_PICTURE']['TITLE'] : $arResult['NAME']));
	$atrAlt = (strlen($arResult['DETAIL_PICTURE']['DESCRIPTION']) ? $arResult['DETAIL_PICTURE']['DESCRIPTION'] : (strlen($arResult['DETAIL_PICTURE']['ALT']) ? $arResult['DETAIL_PICTURE']['ALT'] : $arResult['NAME']));

	$bTopImg = (strpos($arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'], 'TOP') !== false);
	$templateData['IMG_TOP_SIDE'] = isset($arResult['PROPERTIES']['PHOTOPOS']) && $arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'] == 'TOP_SIDE';
	?>
	<?if (!$templateData['IMG_TOP_SIDE']):?>
		<?if ($bTopImg):?>
			<?if ($templateData['BANNER_TOP_ON_HEAD']):?>
				<?$this->SetViewTarget('side-over-title');?>
			<?else:?>
				<?$this->SetViewTarget('top_section_filter_content');?>
			<?endif;?>
		<?endif;?>
		<?\Aspro\Functions\CAsproAllcorp3Resort::showBlockHtml([
			'FILE' => '/images/detail_single.php',
			'PARAMS' => [
				'TYPE' => $arResult['PROPERTIES']['PHOTOPOS']['VALUE_XML_ID'],
				'URL' => $arResult['DETAIL_PICTURE']['SRC'],
				'ALT' => $atrAlt,
				'TITLE' => $atrTitle,
				'TOP_IMG' => $bTopImg
			],
		]);?>

		<?if ($bTopImg):?>
			<?if (!empty($arResult["SPECIAL_PROPERTIES"])):?>
				<div class="props-block-special">
					<div class="maxwidth-theme">
						<div class="props-block-special__wrapp char-side">
							<?foreach ($arResult["SPECIAL_PROPERTIES"] as $prop):?>
								<div class="props-block-special__item">
									<div class="prop-item-title banner-light-text"><?=$prop['NAME'];?></div>
									<div class="prop-item-value banner-light-text"><?=$prop['VALUE'];?></div>
								</div>
							<?endforeach;?>
							<span class="props-block-special__item more-char-link">
								<span class="choise dotted banner-light-text" data-block="char"><?=GetMessage("MORE_CHAR_BOTTOM");?></span>
							</span>
						</div>
					</div>
				</div>
			<?endif;?>	
			<?$this->EndViewTarget();?>
		<?endif;?>
	<?endif;?>

<?endif;?>

<?// detail description?>
<?$templateData['DETAIL_TEXT'] = boolval(strlen($arResult['DETAIL_TEXT']));?>
<?if (strlen($arResult['DETAIL_TEXT'])):?>
	<?$this->SetViewTarget('PRODUCT_DETAIL_TEXT_INFO');?>
		<div class="content catalog-detail__detailtext" itemprop="description">
			<?=$arResult['DETAIL_TEXT'];?>
		</div>
	<?$this->EndViewTarget();?>
<?endif;?>

<?// props content?>
<?$templateData['CHARACTERISTICS'] = boolval($arResult['CHARACTERISTICS']);?>
<?if ($arResult['CHARACTERISTICS']):?>
	<?$this->SetViewTarget('PRODUCT_PROPS_INFO');?>
		<?$strGrupperType = $arParams["GRUPPER_PROPS"];?>
		<?if ($strGrupperType == "GRUPPER"):?>
			<div class="props_block bordered rounded-4">
				<div class="props_block__wrapper">
					<?$APPLICATION->IncludeComponent(
						"redsign:grupper.list",
						"",
						Array(
							"CACHE_TIME" => "3600000",
							"CACHE_TYPE" => "A",
							"COMPOSITE_FRAME_MODE" => "A",
							"COMPOSITE_FRAME_TYPE" => "AUTO",
							"DISPLAY_PROPERTIES" => $arResult["CHARACTERISTICS"]
						),
						$component, array('HIDE_ICONS'=>'Y')
					);?>
				</div>
			</div>
		<?elseif ($strGrupperType == "WEBDEBUG"):?>
			<div class="props_block bordered rounded-4">
				<div class="props_block__wrapper">
					<?$APPLICATION->IncludeComponent(
						"webdebug:propsorter",
						"linear",
						array(
							"IBLOCK_TYPE" => $arResult['IBLOCK_TYPE'],
							"IBLOCK_ID" => $arResult['IBLOCK_ID'],
							"PROPERTIES" => $arResult['CHARACTERISTICS'],
							"EXCLUDE_PROPERTIES" => array(),
							"WARNING_IF_EMPTY" => "N",
							"WARNING_IF_EMPTY_TEXT" => "",
							"NOGROUP_SHOW" => "Y",
							"NOGROUP_NAME" => "",
							"MULTIPLE_SEPARATOR" => ", "
						),
						$component, array('HIDE_ICONS'=>'Y')
					);?>
				</div>
			</div>
		<?elseif ($strGrupperType == "YENISITE_GRUPPER"):?>
			<div class="props_block bordered rounded-4">
				<div class="props_block__wrapper">
					<?$APPLICATION->IncludeComponent(
						'yenisite:ipep.props_groups',
						'',
						array(
							'DISPLAY_PROPERTIES' => $arResult['CHARACTERISTICS'],
							'IBLOCK_ID' => $arParams['IBLOCK_ID']
						),
						$component, array('HIDE_ICONS'=>'Y')
					);?>
				</div>
			</div>
		<?else:?>
			<?if ($arParams["PROPERTIES_DISPLAY_TYPE"] != "TABLE"):?>
				<div class="props_block">
					<div class="props_block__wrapper flexbox row js-offers-prop">
						<?foreach ($arResult["CHARACTERISTICS"] as $propCode => $arProp):?>
							<div class="char col-lg-3 col-md-4 col-xs-6 bordered js-prop-replace" itemprop="additionalProperty" itemscope itemtype="http://schema.org/PropertyValue">
								<div class="char_name font_15 color_666">
									<div class="props_item js-prop-title<?=isset($arProp["HINT"]) && $arParams["SHOW_HINTS"] === 'Y' ? ' whint' : '';?>">
										<span itemprop="name"><?=$arProp["NAME"];?></span>
									</div>
									<?if ($arProp["HINT"] && $arParams["SHOW_HINTS"]=="Y"):?><div class="hint hint--down"><span class="hint__icon rounded bg-theme-hover border-theme-hover bordered"><i>?</i></span><div class="tooltip"><?=$arProp["HINT"];?></div></div><?endif;?>
								</div>
								<div class="char_value font_15 color_333 js-prop-value" itemprop="value">
									<?if (count((array)$arProp["DISPLAY_VALUE"]) > 1):?>
										<?=implode(', ', $arProp["DISPLAY_VALUE"]);?>
									<?else:?>
										<?=$arProp["DISPLAY_VALUE"];?>
									<?endif;?>
								</div>
							</div>
						<?endforeach;?>
						<?if ($arResult['OFFER_PROP']):?>
							<?foreach ($arResult["OFFER_PROP"] as $propCode => $arProp):?>
								<div class="char col-lg-3 col-md-4 col-xs-6 bordered js-prop" itemprop="additionalProperty" itemscope itemtype="http://schema.org/PropertyValue">
									<div class="char_name font_15 color_666">
										<div class="props_item<?=isset($arProp["HINT"]) && $arParams["SHOW_HINTS"] === 'Y' ? ' whint' : '';?>">
											<span itemprop="name"><?=$arProp["NAME"];?></span>
										</div>
										<?if ($arProp["HINT"] && $arParams["SHOW_HINTS"]=="Y"):?><div class="hint hint--down"><span class="hint__icon rounded bg-theme-hover border-theme-hover bordered"><i>?</i></span><div class="tooltip"><?=$arProp["HINT"];?></div></div><?endif;?>
									</div>
									<div class="char_value font_15 color_333" itemprop="value">
										<?if (count((array)$arProp["VALUE"]) > 1):?>
											<?=implode(', ', $arProp["VALUE"]);?>
										<?else:?>
											<?=$arProp["VALUE"];?>
										<?endif;?>
									</div>
								</div>
							<?endforeach;?>
						<?endif;?>
					</div>
				</div>
			<?else:?>
				<div class="props_block props_block--table props_block--nbg bordered rounded-4">
					<table class="props_block__wrapper ">
						<tbody class="js-offers-prop">
							<?foreach ($arResult["CHARACTERISTICS"] as $arProp):?>
								<tr class="char js-prop-replace" itemprop="additionalProperty" itemscope itemtype="http://schema.org/PropertyValue">
									<td class="char_name font_15 color_666">
										<div class="props_item js-prop-title<?=isset($arProp["HINT"]) && $arParams["SHOW_HINTS"] === 'Y' ? ' whint' : '';?>">
											<span itemprop="name"><?=$arProp["NAME"];?></span>
											<?if ($arProp["HINT"] && $arParams["SHOW_HINTS"]=="Y"):?><div class="hint hint--down"><span class="hint__icon rounded bg-theme-hover border-theme-hover bordered"><i>?</i></span><div class="tooltip"><?=$arProp["HINT"];?></div></div><?endif;?>
										</div>
									</td>
									<td class="char_value font_15 color_333 js-prop-value">
										<span itemprop="value">
											<?if (count((array)$arProp["DISPLAY_VALUE"]) > 1):?>
												<?=implode(', ', $arProp["DISPLAY_VALUE"]);?>
											<?else:?>
												<?=$arProp["DISPLAY_VALUE"];?>
											<?endif;?>
										</span>
									</td>
								</tr>
							<?endforeach;?>
							<?if ($arResult['OFFER_PROP']):?>
								<?foreach ($arResult["OFFER_PROP"] as $arProp):?>
									<tr class="char js-prop" itemprop="additionalProperty" itemscope itemtype="http://schema.org/PropertyValue">
										<td class="char_name font_15 color_666">
											<div class="props_item<?=isset($arProp["HINT"]) && $arParams["SHOW_HINTS"] === 'Y' ? ' whint' : '';?>">
												<span itemprop="name"><?=$arProp["NAME"];?></span>
												<?if ($arProp["HINT"] && $arParams["SHOW_HINTS"]=="Y"):?><div class="hint hint--down"><span class="hint__icon rounded bg-theme-hover border-theme-hover bordered"><i>?</i></span><div class="tooltip"><?=$arProp["HINT"];?></div></div><?endif;?>
											</div>
										</td>
										<td class="char_value font_15 color_333">
											<span itemprop="value">
												<?if (count((array)$arProp["VALUE"]) > 1):?>
													<?=implode(', ', $arProp["VALUE"]);?>
												<?else:?>
													<?=$arProp["VALUE"];?>
												<?endif;?>
											</span>
										</td>
									</tr>
								<?endforeach;?>
							<?endif;?>
						</tbody>
					</table>
				</div>
			<?endif;?>
		<?endif;?>
	<?$this->EndViewTarget();?>
<?endif;?>

<?/*form*/?>
<?$templateData['FORM_BLOCK'] = isset($arParams['SHOW_FORM']) && $arParams['SHOW_FORM'] === "Y" ? $arParams['SHOW_FORM'] : "";?>

<?// files?>
<?$templateData['DOCUMENTS'] = boolval($arResult['DOCUMENTS']);?>
<?if ($templateData['DOCUMENTS']):?>
	<?$this->SetViewTarget('PRODUCT_FILES_INFO');?>
		<div class="doc-list-inner__list  grid-list  grid-list--items-1 grid-list--no-gap ">
			<?foreach ($arResult['DOCUMENTS'] as $arItem):?>
				<?
				$arDocFile = CAllcorp3Resort::GetFileInfo($arItem);
				$docFileDescr = $arDocFile['DESCRIPTION'];
				$docFileSize = $arDocFile['FILE_SIZE_FORMAT'];
				$docFileType = $arDocFile['TYPE'];
				$bDocImage = false;
				if ($docFileType == 'jpg' || $docFileType == 'jpeg' || $docFileType == 'bmp' || $docFileType == 'gif' || $docFileType == 'png') {
					$bDocImage = true;
				}
				?>
				<div class="doc-list-inner__wrapper grid-list__item colored_theme_hover_bg-block grid-list-border-outer fill-theme-parent-all">
					<div class="doc-list-inner__item height-100 rounded-4 shadow-hovered shadow-no-border-hovered">
						<?if ($arDocFile):?>
							<div class="doc-list-inner__icon-wrapper">
								<a class="file-type doc-list-inner__icon">
									<i class="file-type__icon file-type__icon--<?=$docFileType?>"></i>
								</a>
							</div>
						<?endif;?>
						<div class="doc-list-inner__content-wrapper">
							<div class="doc-list-inner__top">
								<?if ($arDocFile):?>
									<?if ($bDocImage):?>
										<a href="<?=$arDocFile['SRC'];?>" class="doc-list-inner__name fancy dark_link color-theme-target switcher-title" data-caption="<?=htmlspecialchars($docFileDescr);?>"><?=$docFileDescr?></a>
									<?else:?>
										<a href="<?=$arDocFile['SRC'];?>" target="_blank" class="doc-list-inner__name dark_link color-theme-target switcher-title" title="<?=htmlspecialchars($docFileDescr);?>">
											<?=$docFileDescr?>
										</a>
									<?endif;?>
									<div class="doc-list-inner__label"><?=$docFileSize?></div>
								<?else:?>
									<div class="doc-list-inner__name switcher-title"><?=$docFileDescr?></div>
								<?endif;?>
								<?if ($arDocFile):?>
									<?if ($bDocImage):?>
										<a class="doc-list-inner__icon-preview-image doc-list-inner__link-file fancy fill-theme-parent" data-caption="<?= htmlspecialchars($docFileDescr);?>" href="<?=$arDocFile['SRC'];?>">
											<?=CAllcorp3Resort::showIconSvg('image-preview fill-theme-target', SITE_TEMPLATE_PATH.'/images/svg/preview_image.svg');?>
										</a>
									<?else:?>
										<a class="doc-list-inner__icon-preview-image doc-list-inner__link-file fill-theme-parent" target="_blank" href="<?=$arDocFile['SRC'];?>">
											<?=CAllcorp3Resort::showIconSvg('image-preview fill-theme-target', SITE_TEMPLATE_PATH.'/images/svg/file_download.svg');?>
										</a>
									<?endif;?>
								<?endif;?>
							</div>
						</div>
					</div>
				</div>
			<?endforeach;?>
		</div>
	<?$this->EndViewTarget();?>
<?endif;?>

<?/*gallery mosaic*/?>
<?$templateData['BIG_GALLERY'] = boolval($arResult['BIG_GALLERY']);?>
<?$this->SetViewTarget('PRODUCT_GALLERY_MOSAIC_INFO');?>
	<?if ($templateData['BIG_GALLERY'] && is_array($arResult['BIG_GALLERY'])):?>
		<?
		$odd = count((array)$arResult['BIG_GALLERY']) % 2;
		$count = 1;
		?>
		<div class="gallery-mosaic grid-list grid-list--items-2 grid-list--gap-20 fit <?=$odd ? 'odd-class' : 'no-odd'?> item-count-<?=count((array)$arResult['BIG_GALLERY']);?>">
			<?foreach ($arResult['BIG_GALLERY'] as $arPhoto):?>
				<?if ($count++ <= 9):?>
					<div class="grid-list__item grid-list-border-outer rounded-4">
					<a href="<?=$arPhoto['DETAIL']['SRC'];?>" class="fancy" data-fancybox="big-gallery" target="_blank" title="<?=$arPhoto['TITLE'];?>">
							<img data-src="<?=$arPhoto['PREVIEW']['src'];?>" src="<?=$arPhoto['PREVIEW']['src'];?>" class="img-responsive inline lazy rounded-4" title="<?=$arPhoto['TITLE'];?>" alt="<?=$arPhoto['ALT'];?>" />
						</a>
					</div>
				<?endif;?>	
			<?endforeach;?>
		</div>
	<?endif;?>
<?$this->EndViewTarget();?>

<?// video?>
<?$templateData['VIDEO'] = boolval($arResult['VIDEO']);?>
<?if($arResult['VIDEO']):?>
	<?$this->SetViewTarget('PRODUCT_VIDEO_INFO');?>
		<?TSolution\Functions::showBlockHtml([
            'FILE' => 'video/detail_video_block.php',
            'PARAMS' => [
				'VIDEO' => $arResult['VIDEO'],
			],
        ]);?>
	<?$this->EndViewTarget();?>
<?endif;?>

<?$this->SetViewTarget('PRODUCT_SIDE_INFO');?>
	<div class="catalog-detail__sticky-panel sticky-block rounded-4">
		<div class="catalog-detail__sticky-panel-wrapper">
			<?ob_start();?>
			<div class="catalog-detail__buy-block" itemprop="offers" itemscope itemtype="http://schema.org/Offer" data-id="<?=$arResult['ID'];?>"<?=($bOrderViewBasket ? ' data-item="'.$dataItem.'"' : '');?>>
				<div style="position:relative">
					<div class="catalog-detail__title js-popup-title switcher-title color_333 font_15"><span><?=$arResult['NAME'];?></span></div>
				</div>

				<div class="line-block line-block--20 line-block--16-vertical line-block--align-normal flexbox--wrap flexbox--justify-beetwen">
					<div class="line-block__item catalog-detail__price catalog-detail__info--margined js-popup-price">
						<?=CAsproAllcorp3Resort::showPrice([
							'ITEM' => ($arCurrentOffer ? $arCurrentOffer : $arResult),
							'PARAMS' => $arParams,
							'SHOW_SCHEMA' => true,
							'BASKET' => $bOrderViewBasket,
						]);?>
					</div>

					<div class="line-block__item catalog-detail__countdown catalog-detail__info--margined">
						<?if (
							$arParams["SHOW_DISCOUNT_TIME"] == "Y" &&
							$arResult['DISPLAY_PROPERTIES']['DATE_COUNTER']['VALUE']
						):?>
							<?CAsproAllcorp3Resort::showDiscountCounter([
								'TYPE' => 'type-1',
								'ICONS' => true,
								'DATE' => $arResult['DISPLAY_PROPERTIES']['DATE_COUNTER']['VALUE'],
								'ITEM' => $arResult
							]);?>
						<?endif;?>
					</div>
				</div>

				<?if (strlen($status) || strlen($article)):?>
					<div class="catalog-detail__info-tech">
						<div class="line-block line-block--20 flexbox--wrap js-popup-info">
							<?// element status?>
							<?if (strlen($status)):?>
								<div class="line-block__item font_13">
									<?if ($bUseSchema):?>
										<?=\Aspro\Functions\CAsproAllcorp3Resort::showSchemaAvailabilityMeta($statusCode);?>
									<?endif;?>
									<span 
										class="status-icon <?=$statusCode?> js-replace-status" 
										data-state="<?=$statusCode?>"
										data-code="<?=$arResult['DISPLAY_PROPERTIES']['STATUS']['VALUE_XML_ID'];?>" 
										data-value="<?=$arResult['DISPLAY_PROPERTIES']['STATUS']['VALUE'];?>"
									><?=$status?></span>
								</div>
							<?endif;?>

							<?// element article?>
							<?if (strlen($article)):?>
								<div class="line-block__item font_13 color_999">
									<span class="article"><?=GetMessage('S_ARTICLE');?>&nbsp;<span 
										class="js-replace-article"
										data-value="<?=$arResult['DISPLAY_PROPERTIES']['ARTICLE']['VALUE'];?>"
									><?=$article?></span></span>
								</div>
							<?endif;?>
						</div>
					</div>
				<?endif;?>

				<?$arBtnConfig = [
					'DETAIL_PAGE' => true,
					'BASKET_URL' => false,
					'BASKET' => $bOrderViewBasket,
					'ORDER_BTN' => $bOrderButton,
					'BTN_CLASS' => 'btn-lg',
					'BTN_CLASS_MORE' => 'bg-theme-target border-theme-target btn-wide',
					'BTN_IN_CART_CLASS' => 'btn-lg btn-wide',
					'BTN_CALLBACK_CLASS' => 'btn-transparent-border',
					'BTN_OCB_CLASS' => 'btn-transparent-border btn-ocb',
					'SHOW_COUNTER' => false,
					'ONE_CLICK_BUY' => $bOcbButton,
					'QUESTION_BTN' => $bAskButton,
					'DISPLAY_COMPARE' => $arParams['DISPLAY_COMPARE'],
					'CATALOG_IBLOCK_ID' => $arResult['IBLOCK_ID'],
					'ITEM_ID' => $arResult['ID'],
					'TO_ORDER_TEXT' => $arParams['TO_ORDER_TEXT'] ?? GetMessage('TO_ORDER_TEXT'),
				];?>
				<div class="catalog-detail__cart js-replace-btns js-config-btns" data-btn-config='<?=str_replace('\'', '"', CUtil::PhpToJSObject($arBtnConfig, false, true));?>'>
					<?=CAsproAllcorp3Resort::showBasketButton(
						array_merge(
							$arBtnConfig, 
							[
								'ITEM' => ($arCurrentOffer ? $arCurrentOffer : $arResult),
								'PARAMS' => $arParams,
							]
						)
					);?>
				</div>

				<?if (strlen($arResult['INCLUDE_CONTENT'])):?>
					<div class="catalog-detail__garanty block-with-icon">
						<?=CAllcorp3Resort::showIconSvg("icon block-with-icon__icon", SITE_TEMPLATE_PATH.'/images/svg/catalog/info_big.svg', '', '', true, false);?>
						<div class="block-with-icon__text font_13 font_666">
							<?=$arResult['INCLUDE_CONTENT'];?>
						</div>
					</div>
				<?endif;?>
				<?if ($arResult['SKU']['PROPS']):?>
					<div class="catalog-block__offers1">
						<div 
						class="sku-props sku-props--detail"
						data-site-id="<?=SITE_ID;?>"
						data-item-id="<?=$arResult['ID'];?>"
						data-iblockid="<?=$arResult['IBLOCK_ID'];?>"
						data-offer-id="<?=$arCurrentOffer['ID'];?>"
						data-offer-iblockid="<?=$arCurrentOffer['IBLOCK_ID'];?>"
						>
							<div class="line-block line-block--flex-wrap line-block--flex-100 line-block--40 line-block--align-flex-end">
								<?=\Aspro\Allcorp3Resort\Functions\CSKUTemplate::showSkuPropsHtml($arResult['SKU']['PROPS']);?>
							</div>
						</div>
					</div>
				<?endif;?>
			</div>
			<?//show sale block?>
			<?if ($templateData['SALE']['VALUE'] && $templateData['SALE']['IBLOCK_ID']):?>
				<?$GLOBALS['arrSaleFilter'] = array('ID' => $templateData['SALE']['VALUE']);?>
				<?ob_start();?>
					<?$APPLICATION->IncludeComponent(
						"bitrix:news.list",
						"sale-linked",
						array(
							"IBLOCK_TYPE" => "aspro_allcorp3resort_content",
							"IBLOCK_ID" => $templateData['SALE']['IBLOCK_ID'],
							"NEWS_COUNT" => "20",
							"SORT_BY1" => "SORT",
							"SORT_ORDER1" => "ASC",
							"SORT_BY2" => "ID",
							"SORT_ORDER2" => "DESC",
							"FILTER_NAME" => "arrSaleFilter",
							"FIELD_CODE" => array(
								0 => "NAME",
								1 => "PREVIEW_TEXT",
								2 => "PREVIEW_PICTURE",
								3 => "DATE_ACTIVE_FROM",
								4 => "ACTIVE_TO",
								5 => "",
							),
							"PROPERTY_CODE" => array(
								0 => "PERIOD",
								1 => "REDIRECT",
								2 => "SALE_NUMBER",
								3 => "",
							),
							"CHECK_DATES" => "Y",
							"DETAIL_URL" => "",
							"AJAX_MODE" => "N",
							"AJAX_OPTION_JUMP" => "N",
							"AJAX_OPTION_STYLE" => "Y",
							"AJAX_OPTION_HISTORY" => "N",
							"CACHE_TYPE" => "A",
							"CACHE_TIME" => "36000000",
							"CACHE_FILTER" => "Y",
							"CACHE_GROUPS" => "N",
							"PREVIEW_TRUNCATE_LEN" => "",
							"ACTIVE_DATE_FORMAT" => "d.m.Y",
							"SET_TITLE" => "N",
							"SET_STATUS_404" => "N",
							"INCLUDE_IBLOCK_INTO_CHAIN" => "N",
							"ADD_SECTIONS_CHAIN" => "N",
							"HIDE_LINK_WHEN_NO_DETAIL" => "N",
							"PARENT_SECTION" => "",
							"PARENT_SECTION_CODE" => "",
							"INCLUDE_SUBSECTIONS" => "Y",
							"PAGER_TEMPLATE" => ".default",
							"DISPLAY_TOP_PAGER" => "N",
							"DISPLAY_BOTTOM_PAGER" => "Y",
							"PAGER_TITLE" => "",
							"PAGER_SHOW_ALWAYS" => "N",
							"PAGER_DESC_NUMBERING" => "N",
							"PAGER_DESC_NUMBERING_CACHE_TIME" => "36000",
							"PAGER_SHOW_ALL" => "N",
							"VIEW_TYPE" => "table",
							"BIG_BLOCK" => "Y",
							"COUNT_IN_LINE" => "2",

							"COMPACT" => true,
							"ELEMENT_TITLE" => "",
						),
						false, array("HIDE_ICONS" => "Y")
					);?>
				<?$html = trim(ob_get_clean());?>
				<?if ($html && strpos($html, 'error') === false):?>
					<div class="catalog-detail__sale">
						<?=$html?>
					</div>
				<?endif;?>
			<?endif;?>
			<?=$buyBlockHtml = ob_get_clean();?>
		</div>
	</div>
<?$this->EndViewTarget();?>

<div class="catalog-detail__top-info flexbox flexbox--direction-row flexbox--wrap-nowrap">
	<? //meta?>
	<meta itemprop="name" content="<?=$name = strip_tags(!empty($arResult['IPROPERTY_VALUES']['ELEMENT_PAGE_TITLE']) ? $arResult['IPROPERTY_VALUES']['ELEMENT_PAGE_TITLE'] : $arResult['NAME']);?>" />
	<link itemprop="url" href="<?=$arResult['DETAIL_PAGE_URL'];?>" />
	<meta itemprop="category" content="<?=$arResult['CATEGORY_PATH'];?>" />
	<meta itemprop="description" content="<?=(strlen(strip_tags($arResult['PREVIEW_TEXT'])) ? strip_tags($arResult['PREVIEW_TEXT']) : (strlen(strip_tags($arResult['DETAIL_TEXT'])) ? strip_tags($arResult['DETAIL_TEXT']) : $name));?>" />
	<meta itemprop="sku" content="<?=$arResult['ID'];?>" />
	<?if ($arResult['SKU_CONFIG']):?>
		<div class="js-sku-config" data-value='<?=str_replace('\'', '"', CUtil::PhpToJSObject($arResult['SKU_CONFIG'], false, true));?>'></div>
	<?endif;?>
	<div class="catalog-detail__main">
		<div class="catalog-detail__main-parts line-block line-block--48">
			<div class="catalog-detail__main-part catalog-detail__main-part--right flex-1 line-block__item js-popup-block-adaptive">
				<?=$buyBlockHtml?>
			</div>
		</div>
	</div>
</div>
