/**
 * Owl carousel
 * @version 2.3.4
 * @author Bartosz Wojciechowski
 * @author David Deutsch
 * @license The MIT License (MIT)
 * @todo Lazy Load Icon
 * @todo prevent animationend bubling
 * @todo itemsScaleUp
 * @todo Test Zepto
 * @todo stagePadding calculate wrong active classes
 */
!function($,window,document,undefined){function Owl(element,options){this.settings=null,this.options=$.extend({},Owl.Defaults,options),this.$element=$(element),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:["busy"],animating:["busy"],dragging:["interacting"]}},$.each(["onResize","onThrottledResize"],$.proxy((function(i,handler){this._handlers[handler]=$.proxy(this[handler],this)}),this)),$.each(Owl.Plugins,$.proxy((function(key,plugin){this._plugins[key.charAt(0).toLowerCase()+key.slice(1)]=new plugin(this)}),this)),$.each(Owl.Workers,$.proxy((function(priority,worker){this._pipe.push({filter:worker.filter,run:$.proxy(worker.run,this)})}),this)),this.setup(),this.initialize()}Owl.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:window,fallbackEasing:"swing",slideTransition:"",info:!1,nestedItemSelector:!1,itemElement:"div",stageElement:"div",refreshClass:"owl-refresh",loadedClass:"owl-loaded",loadingClass:"owl-loading",rtlClass:"owl-rtl",responsiveClass:"owl-responsive",dragClass:"owl-drag",itemClass:"owl-item",stageClass:"owl-stage",stageOuterClass:"owl-stage-outer",grabClass:"owl-grab"},Owl.Width={Default:"default",Inner:"inner",Outer:"outer"},Owl.Type={Event:"event",State:"state"},Owl.Plugins={},Owl.Workers=[{filter:["width","settings"],run:function(){this._width=this.$element.width()}},{filter:["width","items","settings"],run:function(cache){cache.current=this._items&&this._items[this.relative(this._current)]}},{filter:["items","settings"],run:function(){this.$stage.children(".cloned").remove()}},{filter:["width","items","settings"],run:function(cache){var margin=this.settings.margin||"",grid=!this.settings.autoWidth,rtl=this.settings.rtl,css={width:"auto","margin-left":rtl?margin:"","margin-right":rtl?"":margin};!grid&&this.$stage.children().css(css),cache.css=css}},{filter:["width","items","settings"],run:function(cache){var width=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,merge=null,iterator=this._items.length,grid=!this.settings.autoWidth,widths=[];for(cache.items={merge:!1,width:width};iterator--;)merge=this._mergers[iterator],merge=this.settings.mergeFit&&Math.min(merge,this.settings.items)||merge,cache.items.merge=merge>1||cache.items.merge,widths[iterator]=grid?width*merge:this._items[iterator].width();this._widths=widths}},{filter:["items","settings"],run:function(){var clones=[],items=this._items,settings=this.settings,view=Math.max(2*settings.items,4),size=2*Math.ceil(items.length/2),repeat=settings.loop&&items.length?settings.rewind?view:Math.max(view,size):0,append="",prepend="";for(repeat/=2;repeat>0;)clones.push(this.normalize(clones.length/2,!0)),append+=items[clones[clones.length-1]][0].outerHTML,clones.push(this.normalize(items.length-1-(clones.length-1)/2,!0)),prepend=items[clones[clones.length-1]][0].outerHTML+prepend,repeat-=1;this._clones=clones;const $append=$(append),$prepend=$(prepend);if(settings.escapeTag){const escapeTagWith=settings.escapeTagWith||"div";$append.each((function(){const $clonedH1=$(this).find(settings.escapeTag);$clonedH1.length&&$clonedH1.each((function(){const replacement="<"+escapeTagWith+" class='"+$clonedH1.prop("classList").value+"'>"+$clonedH1.html()+"</"+escapeTagWith+">";$(this).replaceWith(replacement)}))})),$prepend.each((function(){const $clonedH1=$(this).find(settings.escapeTag);$clonedH1.length&&$clonedH1.each((function(){const replacement="<"+escapeTagWith+" class='"+$clonedH1.prop("classList").value+"'>"+$clonedH1.html()+"</"+escapeTagWith+">";$(this).replaceWith(replacement)}))}))}$append.addClass("cloned").appendTo(this.$stage),$prepend.addClass("cloned").prependTo(this.$stage)}},{filter:["width","items","settings"],run:function(){var rtl=this.settings.rtl?1:-1,size=this._clones.length+this._items.length,iterator=-1,previous=0,current=0,coordinates=[],pullToEnd=!1;for(this._widths[this._widths.length-1]<this._width&&!this.settings.loop&&this.settings.lightDrag&&(pullToEnd=this._width-this._widths[this._widths.length-1]);++iterator<size;)previous=coordinates[iterator-1]||0,current=this._widths[this.relative(iterator)]+this.settings.margin,iterator==size-2&&pullToEnd?coordinates.push(previous+current*rtl+pullToEnd+this.settings.margin):coordinates.push(previous+current*rtl);this._coordinates=coordinates}},{filter:["width","items","settings"],run:function(){var padding=this.settings.stagePadding,coordinates=this._coordinates,css={width:Math.ceil(Math.abs(coordinates[coordinates.length-1]))+2*padding,"padding-left":padding||"","padding-right":padding||""};this.$stage.css(css)}},{filter:["width","items","settings"],run:function(cache){var iterator=this._coordinates.length,grid=!this.settings.autoWidth,items=this.$stage.children();if(grid&&cache.items.merge)for(;iterator--;)cache.css.width=this._widths[this.relative(iterator)],items.eq(iterator).css(cache.css);else grid&&(cache.css.width=cache.items.width,items.css(cache.css))}},{filter:["items"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr("style")}},{filter:["width","items","settings"],run:function(cache){cache.current=cache.current?this.$stage.children().index(cache.current):0,cache.current=Math.max(this.minimum(),Math.min(this.maximum(),cache.current)),this.reset(cache.current)}},{filter:["position"],run:function(){this.animate(this.coordinates(this._current))}},{filter:["width","position","items","settings"],run:function(){var rtl=this.settings.rtl?1:-1,padding=2*this.settings.stagePadding,begin=this.coordinates(this.current())+padding,end=begin+this.width()*rtl,inner,outer,matches=[],i,n;for(i=0,n=this._coordinates.length;i<n;i++)inner=this._coordinates[i-1]||0,outer=Math.abs(this._coordinates[i])+padding*rtl,(this.op(inner,"<=",begin)&&this.op(inner,">",end)||this.op(outer,"<",begin)&&this.op(outer,">",end))&&matches.push(i);this.$stage.children(".active").removeClass("active"),this.$stage.children(":eq("+matches.join("), :eq(")+")").addClass("active"),this.$stage.children(".center").removeClass("center"),this.settings.center&&this.$stage.children().eq(this.current()).addClass("center")}}],Owl.prototype.initializeStage=function(){this.$stage=this.$element.find("."+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=$("<"+this.settings.stageElement+">",{class:this.settings.stageClass}).wrap($("<div/>",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},Owl.prototype.initializeItems=function(){var $items=this.$element.find(".owl-item");if($items.length)return this._items=$items.get().map((function(item){return $(item)})),this._mergers=this._items.map((function(){return 1})),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate("width"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},Owl.prototype.initialize=function(){var imgs,nestedSelector,width;(this.enter("initializing"),this.trigger("initialize"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is("pre-loading"))&&(imgs=this.$element.find("img"),nestedSelector=this.settings.nestedItemSelector?"."+this.settings.nestedItemSelector:void 0,width=this.$element.children(nestedSelector).width(),imgs.length&&width<=0&&this.preloadAutoWidthImages(imgs));this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave("initializing"),this.trigger("initialized")},Owl.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(":visible")},Owl.prototype.setup=function(){var viewport=this.viewport(),overwrites=this.options.responsive,match=-1,settings=null;overwrites?($.each(overwrites,(function(breakpoint){breakpoint<=viewport&&breakpoint>match&&(match=Number(breakpoint))})),"function"==typeof(settings=$.extend({},this.options,overwrites[match])).stagePadding&&(settings.stagePadding=settings.stagePadding()),delete settings.responsive,settings.responsiveClass&&this.$element.attr("class",this.$element.attr("class").replace(new RegExp("("+this.options.responsiveClass+"-)\\S+\\s","g"),"$1"+match))):settings=$.extend({},this.options),this.trigger("change",{property:{name:"settings",value:settings}}),this._breakpoint=match,this.settings=settings,this.invalidate("settings"),this.trigger("changed",{property:{name:"settings",value:this.settings}})},Owl.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},Owl.prototype.prepare=function(item){var event=this.trigger("prepare",{content:item});return event.data||(event.data=$("<"+this.settings.itemElement+"/>").addClass(this.options.itemClass).append(item)),this.trigger("prepared",{content:event.data}),event.data},Owl.prototype.update=function(){for(var i=0,n=this._pipe.length,filter=$.proxy((function(p){return this[p]}),this._invalidated),cache={};i<n;)(this._invalidated.all||$.grep(this._pipe[i].filter,filter).length>0)&&this._pipe[i].run(cache),i++;this._invalidated={},!this.is("valid")&&this.enter("valid")},Owl.prototype.width=function(dimension){switch(dimension=dimension||Owl.Width.Default){case Owl.Width.Inner:case Owl.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},Owl.prototype.refresh=function(){this.enter("refreshing"),this.trigger("refresh"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave("refreshing"),this.trigger("refreshed")},Owl.prototype.onThrottledResize=function(){window.clearTimeout(this.resizeTimer),this.resizeTimer=window.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},Owl.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter("resizing"),this.trigger("resize").isDefaultPrevented()?(this.leave("resizing"),!1):(this.invalidate("width"),this.refresh(),this.leave("resizing"),void this.trigger("resized")))))},Owl.prototype.registerEventHandlers=function(){$.support.transition&&this.$stage.on($.support.transition.end+".owl.core",$.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(window,"resize",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on("mousedown.owl.core",$.proxy(this.onDragStart,this)),this.$stage.on("dragstart.owl.core selectstart.owl.core",(function(){return!1}))),this.settings.touchDrag&&(this.$stage.on("touchstart.owl.core",$.proxy(this.onDragStart,this)),this.$stage.on("touchcancel.owl.core",$.proxy(this.onDragEnd,this)))},Owl.prototype.onDragStart=function(event){var stage=null;3!==event.which&&("mouseDragDynamic"in this.settings&&!this.settings.mouseDragDynamic||(this.settings.marginMove?stage={x:stage=this.$stage.css("margin-left").replace("px",""),y:0}:$.support.transform?stage={x:(stage=this.$stage.css("transform").replace(/.*\(|\)| /g,"").split(","))[16===stage.length?12:4],y:stage[16===stage.length?13:5]}:(stage=this.$stage.position(),stage={x:this.settings.rtl?stage.left+this.$stage.width()-this.width()+this.settings.margin:stage.left,y:stage.top}),this.is("animating")&&($.support.transform?this.animate(stage.x):this.$stage.stop(),this.invalidate("position")),this.$element.toggleClass(this.options.grabClass,"mousedown"===event.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=$(event.target),this._drag.stage.start=stage,this._drag.stage.current=stage,this._drag.pointer=this.pointer(event),$(document).on("mouseup.owl.core touchend.owl.core",$.proxy(this.onDragEnd,this)),$(document).one("mousemove.owl.core touchmove.owl.core",$.proxy((function(event){var delta=this.difference(this._drag.pointer,this.pointer(event));$(document).on("mousemove.owl.core touchmove.owl.core",$.proxy(this.onDragMove,this)),Math.abs(delta.x)<Math.abs(delta.y)&&this.is("valid")||(event.preventDefault(),this.enter("dragging"),this.trigger("drag"))}),this))))},Owl.prototype.onDragMove=function(event){var minimum=null,maximum=null,pull=null,delta=this.difference(this._drag.pointer,this.pointer(event)),stage=this.difference(this._drag.stage.start,delta);this.is("dragging")&&(event.preventDefault(),this.settings.loop?(minimum=this.coordinates(this.minimum()),maximum=this.coordinates(this.maximum()+1)-minimum,stage.x=((stage.x-minimum)%maximum+maximum)%maximum+minimum):(minimum=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),maximum=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),pull=this.settings.pullDrag?-1*delta.x/5:0,stage.x=Math.max(Math.min(stage.x,minimum+pull),maximum+pull)),this._drag.stage.current=stage,this.animate(stage.x))},Owl.prototype.onDragEnd=function(event){var delta=this.difference(this._drag.pointer,this.pointer(event)),stage=this._drag.stage.current,direction=delta.x>0^this.settings.rtl?"left":"right";if($(document).off(".owl.core"),this.$element.removeClass(this.options.grabClass),0!==delta.x&&this.is("dragging")||!this.is("valid")){this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(stage.x,0!==delta.x?direction:this._drag.direction)),this.invalidate("position");var bUpdate=!1;this.settings.loop||(bUpdate=0===this.current()?stage.x>0:stage.x<this.coordinates()[this._items.length-1]),this.settings.lightDrag&&!bUpdate||this.update(),this._drag.direction=direction,(Math.abs(delta.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one("click.owl.core",(function(){return!1}))}this.is("dragging")&&(this.leave("dragging"),this.trigger("dragged"))},Owl.prototype.closest=function(coordinate,direction){var position=-1,pull=30,width=this.width(),coordinates=this.coordinates();return this.settings.freeDrag||$.each(coordinates,$.proxy((function(index,value){return"left"===direction&&coordinate>value-30&&coordinate<value+30?position=index:"right"===direction&&coordinate>value-width-30&&coordinate<value-width+30?position=index+1:this.op(coordinate,"<",value)&&this.op(coordinate,">",void 0!==coordinates[index+1]?coordinates[index+1]:value-width)&&(position="left"===direction?index+1:index),-1===position}),this)),this.settings.loop||(this.op(coordinate,">",coordinates[this.minimum()])?position=coordinate=this.minimum():this.op(coordinate,"<",coordinates[this.maximum()])&&(position=coordinate=this.maximum())),position},Owl.prototype.animate=function(coordinate){var animate=this.speed()>0;this.is("animating")&&this.onTransitionEnd(),animate&&(this.enter("animating"),this.trigger("translate")),this.settings.marginMove?this.$stage.css({"margin-left":coordinate+"px",transition:this.speed()/1e3+"s"+(this.settings.slideTransition?" "+this.settings.slideTransition:"")}):$.support.transform3d&&$.support.transition?this.$stage.css({transform:"translate3d("+coordinate+"px,0px,0px)",transition:this.speed()/1e3+"s"+(this.settings.slideTransition?" "+this.settings.slideTransition:"")}):animate?this.$stage.animate({left:coordinate+"px"},this.speed(),this.settings.fallbackEasing,$.proxy(this.onTransitionEnd,this)):this.$stage.css({left:coordinate+"px"})},Owl.prototype.is=function(state){return this._states.current[state]&&this._states.current[state]>0},Owl.prototype.current=function(position){if(void 0===position)return this._current;if(0!==this._items.length){if(position=this.normalize(position),this._current!==position){var event=this.trigger("change",{property:{name:"position",value:position}});void 0!==event.data&&(position=this.normalize(event.data)),this._current=position,this.invalidate("position"),this.trigger("changed",{property:{name:"position",value:this._current}})}return this._current}},Owl.prototype.invalidate=function(part){return"string"===$.type(part)&&(this._invalidated[part]=!0,this.is("valid")&&this.leave("valid")),$.map(this._invalidated,(function(v,i){return i}))},Owl.prototype.reset=function(position){void 0!==(position=this.normalize(position))&&(this._speed=0,this._current=position,this.suppress(["translate","translated"]),this.animate(this.coordinates(position)),this.release(["translate","translated"]))},Owl.prototype.normalize=function(position,relative){var n=this._items.length,m=relative?0:this._clones.length;return!this.isNumeric(position)||n<1?position=void 0:(position<0||position>=n+m)&&(position=((position-m/2)%n+n)%n+m/2),position},Owl.prototype.relative=function(position){return position-=this._clones.length/2,this.normalize(position,!0)},Owl.prototype.maximum=function(relative){var settings=this.settings,maximum=this._coordinates.length,iterator,reciprocalItemsWidth,elementWidth;if(settings.loop)maximum=this._clones.length/2+this._items.length-1;else if(settings.autoWidth||settings.merge){if(iterator=this._items.length)for(reciprocalItemsWidth=this._items[--iterator].width(),elementWidth=this.$element.width();iterator--&&!((reciprocalItemsWidth+=this._items[iterator].width()+this.settings.margin)>elementWidth););maximum=iterator+1}else maximum=settings.center?this._items.length-1:this._items.length-settings.items;return relative&&(maximum-=this._clones.length/2),Math.max(maximum,0)},Owl.prototype.minimum=function(relative){return relative?0:this._clones.length/2},Owl.prototype.items=function(position){return void 0===position?this._items.slice():(position=this.normalize(position,!0),this._items[position])},Owl.prototype.mergers=function(position){return void 0===position?this._mergers.slice():(position=this.normalize(position,!0),this._mergers[position])},Owl.prototype.clones=function(position){var odd=this._clones.length/2,even=odd+this._items.length,map=function(index){return index%2==0?even+index/2:odd-(index+1)/2};return void 0===position?$.map(this._clones,(function(v,i){return map(i)})):$.map(this._clones,(function(v,i){return v===position?map(i):null}))},Owl.prototype.speed=function(speed){return void 0!==speed&&(this._speed=speed),this._speed},Owl.prototype.coordinates=function(position){var multiplier=1,newPosition=position-1,coordinate;return void 0===position?$.map(this._coordinates,$.proxy((function(coordinate,index){return this.coordinates(index)}),this)):(this.settings.center?(this.settings.rtl&&(multiplier=-1,newPosition=position+1),coordinate=this._coordinates[position],coordinate+=(this.width()-coordinate+(this._coordinates[newPosition]||0))/2*multiplier):coordinate=this._coordinates[newPosition]||0,coordinate=Math.ceil(coordinate))},Owl.prototype.duration=function(from,to,factor){return 0===factor?0:Math.min(Math.max(Math.abs(to-from),1),6)*Math.abs(factor||this.settings.smartSpeed)},Owl.prototype.to=function(position,speed){var current=this.current(),revert=null,distance=position-this.relative(current),direction=(distance>0)-(distance<0),items=this._items.length,minimum=this.minimum(),maximum=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(distance)>items/2&&(distance+=-1*direction*items),(revert=(((position=current+distance)-minimum)%items+items)%items+minimum)!==position&&revert-distance<=maximum&&revert-distance>0&&(current=revert-distance,position=revert,this.reset(current))):position=this.settings.rewind?(position%(maximum+=1)+maximum)%maximum:Math.max(minimum,Math.min(maximum,position)),this.speed(this.duration(current,position,speed)),this.current(position),this.isVisible()&&this.update()},Owl.prototype.next=function(speed){speed=speed||!1,this.to(this.relative(this.current())+1,speed)},Owl.prototype.prev=function(speed){speed=speed||!1,this.to(this.relative(this.current())-1,speed)},Owl.prototype.onTransitionEnd=function(event){if(void 0!==event&&(event.stopPropagation(),(event.target||event.srcElement||event.originalTarget)!==this.$stage.get(0)))return!1;this.leave("animating"),this.trigger("translated")},Owl.prototype.viewport=function(){var width;return this.options.responsiveBaseElement!==window?width=$(this.options.responsiveBaseElement).width():window.innerWidth?width=window.innerWidth:document.documentElement&&document.documentElement.clientWidth?width=document.documentElement.clientWidth:console.warn("Can not detect viewport width."),width},Owl.prototype.replace=function(content){this.$stage.empty(),this._items=[],content&&(content=content instanceof jQuery?content:$(content)),this.settings.nestedItemSelector&&(content=content.find("."+this.settings.nestedItemSelector)),content.filter((function(){return 1===this.nodeType})).each($.proxy((function(index,item){item=this.prepare(item),this.$stage.append(item),this._items.push(item),this._mergers.push(1*item.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)}),this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate("items")},Owl.prototype.add=function(content,position){var current=this.relative(this._current);position=void 0===position?this._items.length:this.normalize(position,!0),content=content instanceof jQuery?content:$(content),this.trigger("add",{content:content,position:position}),content=this.prepare(content),0===this._items.length||position===this._items.length?(0===this._items.length&&this.$stage.append(content),0!==this._items.length&&this._items[position-1].after(content),this._items.push(content),this._mergers.push(1*content.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)):(this._items[position].before(content),this._items.splice(position,0,content),this._mergers.splice(position,0,1*content.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)),this._items[current]&&this.reset(this._items[current].index()),this.invalidate("items"),this.trigger("added",{content:content,position:position})},Owl.prototype.remove=function(position){void 0!==(position=this.normalize(position,!0))&&(this.trigger("remove",{content:this._items[position],position:position}),this._items[position].remove(),this._items.splice(position,1),this._mergers.splice(position,1),this.invalidate("items"),this.trigger("removed",{content:null,position:position}))},Owl.prototype.preloadAutoWidthImages=function(images){images.each($.proxy((function(i,element){this.enter("pre-loading"),element=$(element),$(new Image).one("load",$.proxy((function(e){element.attr("src",e.target.src),element.css("opacity",1),this.leave("pre-loading"),!this.is("pre-loading")&&!this.is("initializing")&&this.refresh()}),this)).attr("src",element.attr("src")||element.attr("data-src")||element.attr("data-src-retina"))}),this))},Owl.prototype.destroy=function(){for(var i in this.$element.off(".owl.core"),this.$stage.off(".owl.core"),$(document).off(".owl.core"),!1!==this.settings.responsive&&(window.clearTimeout(this.resizeTimer),this.off(window,"resize",this._handlers.onThrottledResize)),this._plugins)this._plugins[i].destroy();this.$stage.children(".cloned").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class",this.$element.attr("class").replace(new RegExp(this.options.responsiveClass+"-\\S+\\s","g"),"")).removeData("owl.carousel")},Owl.prototype.op=function(a,o,b){var rtl=this.settings.rtl;switch(o){case"<":return rtl?a>b:a<b;case">":return rtl?a<b:a>b;case">=":return rtl?a<=b:a>=b;case"<=":return rtl?a>=b:a<=b}},Owl.prototype.on=function(element,event,listener,capture){element.addEventListener?element.addEventListener(event,listener,capture):element.attachEvent&&element.attachEvent("on"+event,listener)},Owl.prototype.off=function(element,event,listener,capture){element.removeEventListener?element.removeEventListener(event,listener,capture):element.detachEvent&&element.detachEvent("on"+event,listener)},Owl.prototype.trigger=function(name,data,namespace,state,enter){var status={item:{count:this._items.length,index:this.current()}},handler=$.camelCase($.grep(["on",name,namespace],(function(v){return v})).join("-").toLowerCase()),event=$.Event([name,"owl",namespace||"carousel"].join(".").toLowerCase(),$.extend({relatedTarget:this},status,data));return this._supress[name]||($.each(this._plugins,(function(name,plugin){plugin.onTrigger&&plugin.onTrigger(event)})),this.register({type:Owl.Type.Event,name:name}),this.$element.trigger(event),this.settings&&"function"==typeof this.settings[handler]&&this.settings[handler].call(this,event)),event},Owl.prototype.enter=function(name){$.each([name].concat(this._states.tags[name]||[]),$.proxy((function(i,name){void 0===this._states.current[name]&&(this._states.current[name]=0),this._states.current[name]++}),this))},Owl.prototype.leave=function(name){$.each([name].concat(this._states.tags[name]||[]),$.proxy((function(i,name){this._states.current[name]--}),this))},Owl.prototype.register=function(object){if(object.type===Owl.Type.Event){if($.event.special[object.name]||($.event.special[object.name]={}),!$.event.special[object.name].owl){var _default=$.event.special[object.name]._default;$.event.special[object.name]._default=function(e){return!_default||!_default.apply||e.namespace&&-1!==e.namespace.indexOf("owl")?e.namespace&&e.namespace.indexOf("owl")>-1:_default.apply(this,arguments)},$.event.special[object.name].owl=!0}}else object.type===Owl.Type.State&&(this._states.tags[object.name]?this._states.tags[object.name]=this._states.tags[object.name].concat(object.tags):this._states.tags[object.name]=object.tags,this._states.tags[object.name]=$.grep(this._states.tags[object.name],$.proxy((function(tag,i){return $.inArray(tag,this._states.tags[object.name])===i}),this)))},Owl.prototype.suppress=function(events){$.each(events,$.proxy((function(index,event){this._supress[event]=!0}),this))},Owl.prototype.release=function(events){$.each(events,$.proxy((function(index,event){delete this._supress[event]}),this))},Owl.prototype.pointer=function(event){var result={x:null,y:null};return(event=(event=event.originalEvent||event||window.event).touches&&event.touches.length?event.touches[0]:event.changedTouches&&event.changedTouches.length?event.changedTouches[0]:event).pageX?(result.x=event.pageX,result.y=event.pageY):(result.x=event.clientX,result.y=event.clientY),result},Owl.prototype.isNumeric=function(number){return!isNaN(parseFloat(number))},Owl.prototype.difference=function(first,second){return{x:first.x-second.x,y:first.y-second.y}},$.fn.owlCarousel=function(option){var args=Array.prototype.slice.call(arguments,1);return this.each((function(){var $this=$(this),data=$this.data("owl.carousel");data||(data=new Owl(this,"object"==typeof option&&option),$this.data("owl.carousel",data),$.each(["next","prev","to","destroy","refresh","replace","add","remove"],(function(i,event){data.register({type:Owl.Type.Event,name:event}),data.$element.on(event+".owl.carousel.core",$.proxy((function(e){e.namespace&&e.relatedTarget!==this&&(this.suppress([event]),data[event].apply(this,[].slice.call(arguments,1)),this.release([event]))}),data))}))),"string"==typeof option&&"_"!==option.charAt(0)&&data[option].apply(data,args)}))},$.fn.owlCarousel.Constructor=Owl}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var AutoRefresh=function(carousel){this._core=carousel,this._interval=null,this._visible=null,this._handlers={"initialized.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.autoRefresh&&this.watch()}),this)},this._core.options=$.extend({},AutoRefresh.Defaults,this._core.options),this._core.$element.on(this._handlers)};AutoRefresh.Defaults={autoRefresh:!0,autoRefreshInterval:500},AutoRefresh.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=window.setInterval($.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},AutoRefresh.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass("owl-hidden",!this._visible),this._visible&&this._core.invalidate("width")&&this._core.refresh())},AutoRefresh.prototype.destroy=function(){var handler,property;for(handler in window.clearInterval(this._interval),this._handlers)this._core.$element.off(handler,this._handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.AutoRefresh=AutoRefresh}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var Lazy=function(carousel){this._core=carousel,this._loaded=[],this._handlers={"initialized.owl.carousel change.owl.carousel resized.owl.carousel":$.proxy((function(e){if(e.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(e.property&&"position"==e.property.name||"initialized"==e.type)){var settings=this._core.settings,n=settings.center&&Math.ceil(settings.items/2)||settings.items,i=settings.center&&-1*n||0,position=(e.property&&void 0!==e.property.value?e.property.value:this._core.current())+i,clones=this._core.clones().length,load=$.proxy((function(i,v){this.load(v)}),this);for(settings.lazyLoadEager>0&&(n+=settings.lazyLoadEager,settings.loop&&(position-=settings.lazyLoadEager,n++));i++<n;)this.load(clones/2+this._core.relative(position)),clones&&$.each(this._core.clones(this._core.relative(position)),load),position++}}),this)},this._core.options=$.extend({},Lazy.Defaults,this._core.options),this._core.$element.on(this._handlers)};Lazy.Defaults={lazyLoad:!1,lazyLoadEager:0},Lazy.prototype.load=function(position){var $item=this._core.$stage.children().eq(position),$elements=$item&&$item.find(".owl-lazy");!$elements||$.inArray($item.get(0),this._loaded)>-1||($elements.each($.proxy((function(index,element){var $element=$(element),image,url=window.devicePixelRatio>1&&$element.attr("data-src-retina")||$element.attr("data-src")||$element.attr("data-srcset");this._core.trigger("load",{element:$element,url:url},"lazy"),$element.is("img")?$element.one("load.owl.lazy",$.proxy((function(){$element.css("opacity",1),this._core.trigger("loaded",{element:$element,url:url},"lazy")}),this)).attr("src",url):$element.is("source")?$element.one("load.owl.lazy",$.proxy((function(){this._core.trigger("loaded",{element:$element,url:url},"lazy")}),this)).attr("srcset",url):((image=new Image).onload=$.proxy((function(){$element.css({"background-image":'url("'+url+'")',opacity:"1"}),this._core.trigger("loaded",{element:$element,url:url},"lazy")}),this),image.src=url)}),this)),this._loaded.push($item.get(0)))},Lazy.prototype.destroy=function(){var handler,property;for(handler in this.handlers)this._core.$element.off(handler,this.handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.Lazy=Lazy}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var AutoHeight=function(carousel){this._core=carousel,this._previousHeight=null,this._handlers={"initialized.owl.carousel refreshed.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.autoHeight&&this.update()}),this),"changed.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.autoHeight&&"position"===e.property.name&&this.update()}),this),"loaded.owl.lazy":$.proxy((function(e){e.namespace&&this._core.settings.autoHeight&&e.element.closest("."+this._core.settings.itemClass).index()===this._core.current()&&this.update()}),this)},this._core.options=$.extend({},AutoHeight.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var refThis=this;$(window).on("load",(function(){refThis._core.settings.autoHeight&&refThis.update()})),$(window).resize((function(){refThis._core.settings.autoHeight&&(null!=refThis._intervalId&&clearTimeout(refThis._intervalId),refThis._intervalId=setTimeout((function(){refThis.update()}),250))}))};AutoHeight.Defaults={autoHeight:!1,autoHeightClass:"owl-height"},AutoHeight.prototype.update=function(){var start=this._core._current,end=start+this._core.settings.items,lazyLoadEnabled=this._core.settings.lazyLoad,visible=this._core.$stage.children().toArray().slice(start,end),heights=[],maxheight=0;$.each(visible,(function(index,item){heights.push($(item).height())})),(maxheight=Math.max.apply(null,heights))<=1&&lazyLoadEnabled&&this._previousHeight&&(maxheight=this._previousHeight),this._previousHeight=maxheight,this._core.$stage.parent().height(maxheight).addClass(this._core.settings.autoHeightClass)},AutoHeight.prototype.destroy=function(){var handler,property;for(handler in this._handlers)this._core.$element.off(handler,this._handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.AutoHeight=AutoHeight}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var Video=function(carousel){this._core=carousel,this._videos={},this._playing=null,this._handlers={"initialized.owl.carousel":$.proxy((function(e){e.namespace&&this._core.register({type:"state",name:"playing",tags:["interacting"]})}),this),"resize.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.video&&this.isInFullScreen()&&e.preventDefault()}),this),"refreshed.owl.carousel":$.proxy((function(e){e.namespace&&this._core.is("resizing")&&this._core.$stage.find(".cloned .owl-video-frame").remove()}),this),"changed.owl.carousel":$.proxy((function(e){e.namespace&&"position"===e.property.name&&this._playing&&this.stop()}),this),"prepared.owl.carousel":$.proxy((function(e){if(e.namespace){var $element=$(e.content).find(".owl-video");$element.length&&($element.css("display","none"),this.fetch($element,$(e.content)))}}),this)},this._core.options=$.extend({},Video.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on("click.owl.video",".owl-video-play-icon",$.proxy((function(e){this.play(e)}),this))};Video.Defaults={video:!1,videoHeight:!1,videoWidth:!1},Video.prototype.fetch=function(target,item){var type=target.attr("data-vimeo-id")?"vimeo":target.attr("data-vzaar-id")?"vzaar":"youtube",id=target.attr("data-vimeo-id")||target.attr("data-youtube-id")||target.attr("data-vzaar-id"),width=target.attr("data-width")||this._core.settings.videoWidth,height=target.attr("data-height")||this._core.settings.videoHeight,url=target.attr("href");if(!url)throw new Error("Missing video URL.");if((id=url.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com|be\-nocookie\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/))[3].indexOf("youtu")>-1)type="youtube";else if(id[3].indexOf("vimeo")>-1)type="vimeo";else{if(!(id[3].indexOf("vzaar")>-1))throw new Error("Video URL not supported.");type="vzaar"}id=id[6],this._videos[url]={type:type,id:id,width:width,height:height},item.attr("data-video",url),this.thumbnail(target,this._videos[url])},Video.prototype.thumbnail=function(target,video){var tnLink,icon,path,dimensions=video.width&&video.height?"width:"+video.width+"px;height:"+video.height+"px;":"",customTn=target.find("img"),srcType="src",lazyClass="",settings=this._core.settings,create=function(path){icon='<div class="owl-video-play-icon"></div>',tnLink=settings.lazyLoad?$("<div/>",{class:"owl-video-tn "+lazyClass,srcType:path}):$("<div/>",{class:"owl-video-tn",style:"opacity:1;background-image:url("+path+")"}),target.after(tnLink),target.after(icon)};if(target.wrap($("<div/>",{class:"owl-video-wrapper",style:dimensions})),this._core.settings.lazyLoad&&(srcType="data-src",lazyClass="owl-lazy"),customTn.length)return create(customTn.attr(srcType)),customTn.remove(),!1;"youtube"===video.type?(path="//img.youtube.com/vi/"+video.id+"/hqdefault.jpg",create(path)):"vimeo"===video.type?$.ajax({type:"GET",url:"//vimeo.com/api/v2/video/"+video.id+".json",jsonp:"callback",dataType:"jsonp",success:function(data){path=data[0].thumbnail_large,create(path)}}):"vzaar"===video.type&&$.ajax({type:"GET",url:"//vzaar.com/api/videos/"+video.id+".json",jsonp:"callback",dataType:"jsonp",success:function(data){path=data.framegrab_url,create(path)}})},Video.prototype.stop=function(){this._core.trigger("stop",null,"video"),this._playing.find(".owl-video-frame").remove(),this._playing.removeClass("owl-video-playing"),this._playing=null,this._core.leave("playing"),this._core.trigger("stopped",null,"video")},Video.prototype.play=function(event){var target,item=$(event.target).closest("."+this._core.settings.itemClass),video=this._videos[item.attr("data-video")],width=video.width||"100%",height=video.height||this._core.$stage.height(),html,iframe;this._playing||(this._core.enter("playing"),this._core.trigger("play",null,"video"),item=this._core.items(this._core.relative(item.index())),this._core.reset(item.index()),(html=$('<iframe frameborder="0" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>')).attr("height",height),html.attr("width",width),"youtube"===video.type?html.attr("src","//www.youtube.com/embed/"+video.id+"?autoplay=1&rel=0&v="+video.id):"vimeo"===video.type?html.attr("src","//player.vimeo.com/video/"+video.id+"?autoplay=1"):"vzaar"===video.type&&html.attr("src","//view.vzaar.com/"+video.id+"/player?autoplay=true"),iframe=$(html).wrap('<div class="owl-video-frame" />').insertAfter(item.find(".owl-video")),this._playing=item.addClass("owl-video-playing"))},Video.prototype.isInFullScreen=function(){var element=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement;return element&&$(element).parent().hasClass("owl-video-frame")},Video.prototype.destroy=function(){var handler,property;for(handler in this._core.$element.off("click.owl.video"),this._handlers)this._core.$element.off(handler,this._handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.Video=Video}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var Animate=function(scope){this.core=scope,this.core.options=$.extend({},Animate.Defaults,this.core.options),this.swapping=!0,this.previous=void 0,this.next=void 0,this.handlers={"change.owl.carousel":$.proxy((function(e){e.namespace&&"position"==e.property.name&&(this.previous=this.core.current(),this.next=e.property.value)}),this),"drag.owl.carousel dragged.owl.carousel translated.owl.carousel":$.proxy((function(e){e.namespace&&(this.swapping="translated"==e.type)}),this),"translate.owl.carousel":$.proxy((function(e){e.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()}),this)},this.core.$element.on(this.handlers)};Animate.Defaults={animateOut:!1,animateIn:!1},Animate.prototype.swap=function(){if(1===this.core.settings.items&&$.support.animation&&$.support.transition){this.core.speed(0);var left,clear=$.proxy(this.clear,this),previous=this.core.$stage.children().eq(this.previous),next=this.core.$stage.children().eq(this.next),incoming=this.core.settings.animateIn,outgoing=this.core.settings.animateOut;this.core.current()!==this.previous&&(outgoing&&(left=this.core.coordinates(this.previous)-this.core.coordinates(this.next),previous.one($.support.animation.end,clear).css({left:left+"px"}).addClass("animated owl-animated-out").addClass(outgoing)),incoming&&next.one($.support.animation.end,clear).addClass("animated owl-animated-in").addClass(incoming))}},Animate.prototype.clear=function(e){$(e.target).css({left:""}).removeClass("animated owl-animated-out owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},Animate.prototype.destroy=function(){var handler,property;for(handler in this.handlers)this.core.$element.off(handler,this.handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.Animate=Animate}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var Autoplay=function(carousel){this._core=carousel,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={"changed.owl.carousel":$.proxy((function(e){e.namespace&&"settings"===e.property.name?this._core.settings.autoplay?this.play():this.stop():e.namespace&&"position"===e.property.name&&this._paused&&(this._time=0)}),this),"initialized.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.autoplay&&this.play()}),this),"play.owl.autoplay":$.proxy((function(e,t,s){e.namespace&&this.play(t,s)}),this),"stop.owl.autoplay":$.proxy((function(e){e.namespace&&this.stop()}),this),"mouseover.owl.autoplay":$.proxy((function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.pause()}),this),"mouseleave.owl.autoplay":$.proxy((function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.play()}),this),"touchstart.owl.core":$.proxy((function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.pause()}),this),"touchend.owl.core":$.proxy((function(){this._core.settings.autoplayHoverPause&&this.play()}),this)},this._core.$element.on(this._handlers),this._core.options=$.extend({},Autoplay.Defaults,this._core.options)};Autoplay.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},Autoplay.prototype._next=function(speed){this._call=window.setTimeout($.proxy(this._next,this,speed),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is("interacting")||document.hidden||this._core.next(speed||this._core.settings.autoplaySpeed)},Autoplay.prototype.read=function(){return(new Date).getTime()-this._time},Autoplay.prototype.play=function(timeout,speed){var elapsed;this._core.is("rotating")||this._core.enter("rotating"),timeout=timeout||this._core.settings.autoplayTimeout,elapsed=Math.min(this._time%(this._timeout||timeout),timeout),this._paused?(this._time=this.read(),this._paused=!1):window.clearTimeout(this._call),this._time+=this.read()%timeout-elapsed,this._timeout=timeout,this._call=window.setTimeout($.proxy(this._next,this,speed),timeout-elapsed)},Autoplay.prototype.stop=function(){this._core.is("rotating")&&(this._time=0,this._paused=!0,window.clearTimeout(this._call),this._core.leave("rotating"))},Autoplay.prototype.pause=function(){this._core.is("rotating")&&!this._paused&&(this._time=this.read(),this._paused=!0,window.clearTimeout(this._call))},Autoplay.prototype.destroy=function(){var handler,property;for(handler in this.stop(),this._handlers)this._core.$element.off(handler,this._handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.autoplay=Autoplay}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){"use strict";var Navigation=function(carousel){this._core=carousel,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={"prepared.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.dotsData&&this._templates.push('<div class="'+this._core.settings.dotClass+'">'+$(e.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot")+"</div>")}),this),"added.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.dotsData&&this._templates.splice(e.position,0,this._templates.pop())}),this),"remove.owl.carousel":$.proxy((function(e){e.namespace&&this._core.settings.dotsData&&this._templates.splice(e.position,1)}),this),"changed.owl.carousel":$.proxy((function(e){e.namespace&&"position"==e.property.name&&this.draw()}),this),"initialized.owl.carousel":$.proxy((function(e){e.namespace&&!this._initialized&&(this._core.trigger("initialize",null,"navigation"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger("initialized",null,"navigation"))}),this),"refreshed.owl.carousel":$.proxy((function(e){e.namespace&&this._initialized&&(this._core.trigger("refresh",null,"navigation"),this.update(),this.draw(),this._core.trigger("refreshed",null,"navigation"))}),this)},this._core.options=$.extend({},Navigation.Defaults,this._core.options),this.$element.on(this._handlers)};Navigation.Defaults={nav:!1,navText:['<span aria-label="Previous">&#x2039;</span>','<span aria-label="Next">&#x203a;</span>'],navSpeed:!1,navElement:'button type="button" role="presentation"',navContainer:!1,navContainerClass:"owl-nav",navClass:["owl-prev","owl-next"],slideBy:1,dotClass:"owl-dot",dotsClass:"owl-dots",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},Navigation.prototype.initialize=function(){var override,settings=this._core.settings;for(override in this._controls.$relative=(settings.navContainer?$(settings.navContainer):$("<div>").addClass(settings.navContainerClass).appendTo(this.$element)).addClass("disabled"),this._controls.$previous=$("<"+settings.navElement+">").addClass(settings.navClass[0]).html(settings.navText[0]).prependTo(this._controls.$relative).on("click",$.proxy((function(e){this.prev(settings.navSpeed)}),this)),this._controls.$next=$("<"+settings.navElement+">").addClass(settings.navClass[1]).html(settings.navText[1]).appendTo(this._controls.$relative).on("click",$.proxy((function(e){this.next(settings.navSpeed)}),this)),settings.dotsData||(this._templates=[$('<button role="button">').addClass(settings.dotClass).append($("<span>")).prop("outerHTML")]),this._controls.$absolute=(settings.dotsContainer?$(settings.dotsContainer):$("<div>").addClass(settings.dotsClass).appendTo(this.$element)).addClass("disabled"),this._controls.$absolute.on("click","button",$.proxy((function(e){var index=$(e.target).parent().is(this._controls.$absolute)?$(e.target).index():$(e.target).parent().index();e.preventDefault(),this.to(index,settings.dotsSpeed)}),this)),this._overrides)this._core[override]=$.proxy(this[override],this)},Navigation.prototype.destroy=function(){var handler,control,property,override,settings;for(handler in settings=this._core.settings,this._handlers)this.$element.off(handler,this._handlers[handler]);for(control in this._controls)"$relative"===control&&settings.navContainer?this._controls[control].html(""):this._controls[control].remove();for(override in this.overides)this._core[override]=this._overrides[override];for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},Navigation.prototype.update=function(){var i,j,k,lower=this._core.clones().length/2,upper=lower+this._core.items().length,maximum=this._core.maximum(!0),settings=this._core.settings,size=settings.center||settings.autoWidth||settings.dotsData?1:settings.dotsEach||settings.items;if("page"!==settings.slideBy&&(settings.slideBy=Math.min(settings.slideBy,settings.items)),settings.dots||"page"==settings.slideBy)for(this._pages=[],i=lower,j=0,k=0;i<upper;i++){if(j>=size||0===j){if(this._pages.push({start:Math.min(maximum,i-lower),end:i-lower+size-1}),Math.min(maximum,i-lower)===maximum)break;j=0,++k}j+=this._core.mergers(this._core.relative(i))}},Navigation.prototype.draw=function(){var difference,settings=this._core.settings,disabled=this._core.items().length<=settings.items,index=this._core.relative(this._core.current()),loop=settings.loop||settings.rewind;this._controls.$relative.toggleClass("disabled",!settings.nav||disabled),settings.nav&&(this._controls.$previous.toggleClass("disabled",!loop&&index<=this._core.minimum(!0)),this._controls.$next.toggleClass("disabled",!loop&&index>=this._core.maximum(!0))),this._controls.$absolute.toggleClass("disabled",!settings.dots||disabled),settings.dots&&(difference=this._pages.length-this._controls.$absolute.children().length,settings.dotsData&&0!==difference?this._controls.$absolute.html(this._templates.join("")):difference>0?this._controls.$absolute.append(new Array(difference+1).join(this._templates[0])):difference<0&&this._controls.$absolute.children().slice(difference).remove(),this._controls.$absolute.find(".active").removeClass("active"),this._controls.$absolute.children().eq($.inArray(this.current(),this._pages)).addClass("active"))},Navigation.prototype.onTrigger=function(event){var settings=this._core.settings;event.page={index:$.inArray(this.current(),this._pages),count:this._pages.length,size:settings&&(settings.center||settings.autoWidth||settings.dotsData?1:settings.dotsEach||settings.items)}},Navigation.prototype.current=function(){var current=this._core.relative(this._core.current());return $.grep(this._pages,$.proxy((function(page,index){return page.start<=current&&page.end>=current}),this)).pop()},Navigation.prototype.getPosition=function(successor){var position,length,settings=this._core.settings;return"page"==settings.slideBy?(position=$.inArray(this.current(),this._pages),length=this._pages.length,successor?++position:--position,position=this._pages[(position%length+length)%length].start):(position=this._core.relative(this._core.current()),length=this._core.items().length,successor?position+=settings.slideBy:position-=settings.slideBy),position},Navigation.prototype.next=function(speed){$.proxy(this._overrides.to,this._core)(this.getPosition(!0),speed)},Navigation.prototype.prev=function(speed){$.proxy(this._overrides.to,this._core)(this.getPosition(!1),speed)},Navigation.prototype.to=function(position,speed,standard){var length;!standard&&this._pages.length?(length=this._pages.length,$.proxy(this._overrides.to,this._core)(this._pages[(position%length+length)%length].start,speed)):$.proxy(this._overrides.to,this._core)(position,speed)},$.fn.owlCarousel.Constructor.Plugins.Navigation=Navigation}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){"use strict";var Hash=function(carousel){this._core=carousel,this._hashes={},this.$element=this._core.$element,this._handlers={"initialized.owl.carousel":$.proxy((function(e){e.namespace&&"URLHash"===this._core.settings.startPosition&&$(window).trigger("hashchange.owl.navigation")}),this),"prepared.owl.carousel":$.proxy((function(e){if(e.namespace){var hash=$(e.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");if(!hash)return;this._hashes[hash]=e.content}}),this),"changed.owl.carousel":$.proxy((function(e){if(e.namespace&&"position"===e.property.name){var current=this._core.items(this._core.relative(this._core.current())),hash=$.map(this._hashes,(function(item,hash){return item===current?hash:null})).join();if(!hash||window.location.hash.slice(1)===hash)return;window.location.hash=hash}}),this)},this._core.options=$.extend({},Hash.Defaults,this._core.options),this.$element.on(this._handlers),$(window).on("hashchange.owl.navigation",$.proxy((function(e){var hash=window.location.hash.substring(1),items=this._core.$stage.children(),position=this._hashes[hash]&&items.index(this._hashes[hash]);void 0!==position&&position!==this._core.current()&&this._core.to(this._core.relative(position),!1,!0)}),this))};Hash.Defaults={URLhashListener:!1},Hash.prototype.destroy=function(){var handler,property;for(handler in $(window).off("hashchange.owl.navigation"),this._handlers)this._core.$element.off(handler,this._handlers[handler]);for(property in Object.getOwnPropertyNames(this))"function"!=typeof this[property]&&(this[property]=null)},$.fn.owlCarousel.Constructor.Plugins.Hash=Hash}(window.Zepto||window.jQuery,window,document),function($,window,document,undefined){var style=$("<support>").get(0).style,prefixes="Webkit Moz O ms".split(" "),events={transition:{end:{WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",transition:"transitionend"}},animation:{end:{WebkitAnimation:"webkitAnimationEnd",MozAnimation:"animationend",OAnimation:"oAnimationEnd",animation:"animationend"}}},tests_csstransforms=function(){return!!test("transform")},tests_csstransforms3d=function(){return!!test("perspective")},tests_csstransitions,tests_cssanimations=function(){return!!test("animation")};function test(property,prefixed){var result=!1,upper=property.charAt(0).toUpperCase()+property.slice(1);return $.each((property+" "+prefixes.join(upper+" ")+upper).split(" "),(function(i,property){if(void 0!==style[property])return result=!prefixed||property,!1})),result}function prefixed(property){return test(property,!0)}(function(){return!!test("transition")})()&&($.support.transition=new String(prefixed("transition")),$.support.transition.end=events.transition.end[$.support.transition]),tests_cssanimations()&&($.support.animation=new String(prefixed("animation")),$.support.animation.end=events.animation.end[$.support.animation]),tests_csstransforms()&&($.support.transform=new String(prefixed("transform")),$.support.transform3d=tests_csstransforms3d())}(window.Zepto||window.jQuery,window,document);
//# sourceMappingURL=owl.carousel.min.js.map