<?
require($_SERVER["DOCUMENT_ROOT"]."/bitrix/header.php");
$APPLICATION->SetTitle("Правила обработки адресов");
?><p>Настройка поддержки ЧПУ производится для работающих проектов (вы должны установить обновление главного модуля до версии 5.1.8 и выше, поскольку в обновление ядра 5.1.8 включен механизм переопределения адресов для поддержки ЧПУ). Все, кто будет ставить новый дистрибутив, получат уже настроенную поддержку. 
  <br />
</p>

<p><b>Понятие обработки адресов </b></p>

<p>Обработка адресов (UrlRewrite) применяется для того, чтобы скрипт мог отвечать не только по своему физическому, но и по любому другому указанному адресу. Например, можно задать такие настройки обработки адресов, что скрипт, лежащий в файле <i>/fld/c.php</i> и отвечающий по адресу: 
  <br />
&nbsp;&nbsp;&nbsp;&nbsp; /fld/c.php?id=15 
  <br />
будет отвечать также по адресу: 
  <br />
&nbsp;&nbsp;&nbsp;&nbsp; /catalog/15.php 
  <br />
</p>

<p>Адрес, по которому будет отвечать скрипт, не должен физически существовать на сервере. Если такой адрес физически существует, то будет вызван скрипт по этому адресу. Система обработки адресов запущена в этом случае не будет. </p>

<p>Управление правилами преобразования адресов производится в панели управления на странице "Настройки - Обработка адресов": <em>/bitrix/admin/urlrewrite_list.php. 
    <br />
  </em>Механизм переопределения адресов создан в основном для компонентов 2.0, поддерживающих режим ЧПУ. В то же время, данный обработчик можно использовать для переопределения любых URL, а не только связанных с компонентами. </p>

<p>При добавлении на страницу компонента с поддержкой ЧПУ (если файл сохраняется с помощью API), автоматически создается правило переопределения адреса. Если страница создается не с помощью API, а, например, записывается через FTP, то необходимо выполнить пересоздание правил (кнопка на панели инструментов на странице управления правилами). 
  <br />
</p>

<p><b>Подключение механизма обработки адресов:</b> </p>

<p><b>1</b>. Если у вас на веб-сервере настроена обработка ошибки 404, например, для Apache установлена опция ErrorDocument или аналогичная инструкция прописана в файле .htaccess: 
  <br />
<span><code>&nbsp;&nbsp;&nbsp;&nbsp; ErrorDocument 404 /404.php
      <br />
    </code>то вы должны изменить файл <em>/404.php,</em> вставив в самое начало файла команду: 
    <br />
  <code>&nbsp;&nbsp;&nbsp; include_once( $_SERVER['DOCUMENT_ROOT']. '/bitrix/modules/main/include/urlrewrite.php' ); 
      <br />
    </code>
    <p><b>2</b>. Если вы для Apache используете модуль mod_rewrite, то в его настройках вы можете указать (например, в файле .htaccess): 
      <br />

<code>
    &lt;IfModule mod_rewrite.c&gt; 
        <br />
      RewriteEngine On 
        <br />
      RewriteCond %{REQUEST_FILENAME} !-f 
        <br />
      RewriteCond %{REQUEST_FILENAME} !-l 
        <br />
      RewriteCond %{REQUEST_FILENAME} !-d 
        <br />
      RewriteCond %{REQUEST_FILENAME} !/bitrix/urlrewrite.php$ 
        <br />
      RewriteRule ^(.*)$ /bitrix/urlrewrite.php [L] 
        <br />
      &lt;/IfModule&gt; 
        <br />
</code>
      </p>
  
    <p>После этих настроек будет работать штатный механизм поддержки ЧПУ для новых компонент.</p>

    <p><b>Простой тест для проверки проведенной настройки:</b> 
      <br />
    
      <br />
    <b>1</b>. Зайти на страницу <em>&quot;Настройки&quot; - &quot;Настройки продукта&quot; - &quot;Обработка адресов&quot; 
        <br />
      </em>
      <br />
    <b>2</b>. Выбирать пункт &quot;Новая запись&quot; и добавить: 
      <br />
    <em>&nbsp;&nbsp; Условие</em>: #^/sef_test/# 
      <br />
    <em>&nbsp;&nbsp; Компонент</em>: ничего не указываем 
      <br />
    <em>&nbsp;&nbsp; Файл</em>: /index.php (нужно указать файл, который фактически будет работать) 
      <br />
    <em>&nbsp;&nbsp; Правило</em>: ничего не указываем. 
      <br />
    Сохранить изменения. 
      <br />
    
      <br />
    <b>3</b>. Перейти по адресу в разделе /sef_test/ 
      <br />
    &nbsp;&nbsp;&nbsp; Например, http://localhost/sef_test/test.html 
      <br />
    
      <br />
    Если ЧПУ работает, то вы должны увидеть содержимое страницы, указанной в поле <em>Файл</em> в правиле переопределения. </p>

<p></p>



<b>Пример настройки ЧПУ для детальной страницы показа новостей</b>

<p>Для динамических страниц, содержащих в адресе параметр ID, можно создать правило, по которому адрес 
страницы для каждой новости будет включать значение ID в имени страницы, например, 234.html</p>

<code>Условие: #^/news/([0-9]+)\.html(\?.*)?$
  <br />
Правило: /about/news/detail.php?ID=$1
  <br />
</code>

<b>Пример настройки адресов страниц .html вместо .php</b>

<p>В некоторых случаях необходимо использовать адреса страниц с расширением .html, соответствующее правило будет выглядеть следующим образом:</p>

<code>Условие: #^(.+)\.html(\?.*)?$#
  <br />
Правило: $1.php
  <br />
</code>

<b>Обработка старых ссылок</b>
<p>При переносе информации со старого сайта на новый, часто необходимо сохранить 
в рабочем состоянии старые ссылки на некоторые материалы сайта. Например, страница может быть занесена в Избранное у посетителя,
или проиндексирована поисковыми системами. Для таких ссылок необходимо задать условия, которые описывают соответствие 
страниц старого и нового сайта.</p>
<p>Например, так задается соответствие для старой страницы: <i>about.html</i></p>
<code>Условие: #^/about.html(\?.*)?$#
  <br />
Правило: /about/index.php
  <br />
</code><?require($_SERVER["DOCUMENT_ROOT"]."/bitrix/footer.php");?>